/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2.visual;

import jp.kirikiri.tvp2.visual.GammaAdjustData;

public class GammaAdjustTempData {
    public byte[] B;
    public byte[] G;
    public byte[] R = new byte[256];

    public GammaAdjustTempData() {
        this.G = new byte[256];
        this.B = new byte[256];
    }

    public void Initialize(GammaAdjustData data) {
        double ramp = data.RCeil - data.RFloor;
        double gamp = data.GCeil - data.GFloor;
        double bamp = data.BCeil - data.BFloor;
        double rgamma = 1.0 / (double)data.RGamma;
        double ggamma = 1.0 / (double)data.GGamma;
        double bgamma = 1.0 / (double)data.BGamma;
        double rfloor = data.RFloor;
        double gfloor = data.GFloor;
        double bfloor = data.BFloor;
        int i = 0;
        while (i < 256) {
            double rate = (double)i / 255.0;
            int n = (int)(Math.pow(rate, rgamma) * ramp + 0.5 + rfloor);
            if (n < 0) {
                n = 0;
            } else if (n > 255) {
                n = 255;
            }
            this.R[i] = (byte)(n & 0xFF);
            n = (int)(Math.pow(rate, ggamma) * gamp + 0.5 + gfloor);
            if (n < 0) {
                n = 0;
            } else if (n > 255) {
                n = 255;
            }
            this.G[i] = (byte)(n & 0xFF);
            n = (int)(Math.pow(rate, bgamma) * bamp + 0.5 + bfloor);
            if (n < 0) {
                n = 0;
            } else if (n > 255) {
                n = 255;
            }
            this.B[i] = (byte)(n & 0xFF);
            ++i;
        }
    }
}

