/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2.visual;

import java.util.ArrayList;
import java.util.HashMap;
import jp.kirikiri.tjs2.BinaryStream;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.HashTable;
import jp.kirikiri.tjs2.Holder;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.TJSScriptError;
import jp.kirikiri.tjs2.TJSScriptException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantException;
import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.base.CompactEventCallbackInterface;
import jp.kirikiri.tvp2.base.Storage;
import jp.kirikiri.tvp2.msg.Message;
import jp.kirikiri.tvp2.utils.DebugClass;
import jp.kirikiri.tvp2.visual.BaseBitmap;
import jp.kirikiri.tvp2.visual.Rect;
import jp.kirikiri.tvp2env.NativeImageBuffer;
import jp.kirikiri.tvp2env.NativeImageLoader;
import jp.kirikiri.tvp2env.SystemColor;

public class GraphicsLoader {
    public static final int glmNormal = 0;
    public static final int glmPalettized = 1;
    public static final int glmGrayscale = 2;
    private static HashTable<GraphicsSearchData, GraphicImageData> GraphicCache;
    private static boolean ClearGraphicCacheCallbackInit;
    private static final String[] GRAPHIC_TYPE;

    static {
        GRAPHIC_TYPE = new String[]{".png", ".jpg", ".tlg", ".jpeg", ".bmp"};
    }

    public static void initialize() {
        GraphicCache = new HashTable();
        ClearGraphicCacheCallbackInit = false;
    }

    public static void finalizeApplication() {
        GraphicCache = null;
    }

    public static void checkGraphicCacheLimit() {
        while (TVP.GraphicCacheTotalBytes > TVP.GraphicCacheLimit) {
            GraphicImageData data = GraphicCache.getLastValue();
            if (data == null) break;
            int size = data.getSize();
            TVP.GraphicCacheTotalBytes -= (long)size;
            GraphicCache.chopLast(1);
        }
    }

    public static void clearGraphicCache() {
        GraphicCache.clear();
        TVP.GraphicCacheTotalBytes = 0L;
    }

    public static void touchImages(ArrayList<String> storages, int limit, long timeout) throws TJSException {
        int limitbytes;
        if (TVP.GraphicCacheLimit == 0L) {
            return;
        }
        if (limit >= 0) {
            limitbytes = (long)limit > TVP.GraphicCacheLimit || limit == 0 ? (int)TVP.GraphicCacheLimit : limit;
        } else {
            if ((long)(-limit) >= TVP.GraphicCacheLimit) {
                return;
            }
            limitbytes = (int)(TVP.GraphicCacheLimit + (long)limit);
        }
        int count = 0;
        int bytes = 0;
        long starttime = TVP.getTickCount();
        long limittime = starttime + timeout;
        BaseBitmap tmp = new BaseBitmap(32, 32, 32);
        StringBuilder statusstr = new StringBuilder(256);
        statusstr.append("(info) Touching ");
        boolean first = true;
        int storageCount = storages.size();
        while (count < storageCount) {
            if (timeout != 0L && TVP.getTickCount() >= limittime) {
                statusstr.append(" ... aborted [timed out]");
                break;
            }
            if (bytes >= limitbytes) {
                statusstr.append(" ... aborted [limit bytes exceeded]");
                break;
            }
            try {
                if (!first) {
                    statusstr.append(", ");
                }
                first = false;
                statusstr.append(storages.get(count));
                GraphicsLoader.loadGraphic(tmp, storages.get(count), 0x1FFFFFFF, 0, 0, 0, null, null);
                ++count;
                bytes += tmp.getByteSize();
            }
            catch (TJSException e) {
                statusstr.append("(error!:");
                statusstr.append(e.getMessage());
                statusstr.append(")");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        --count;
        GraphicsSearchData searchdata = new GraphicsSearchData();
        while (count >= 0) {
            searchdata.Name = TVP.StorageMediaManager.normalizeStorageName(storages.get(count), null);
            searchdata.KeyIdx = 0x1FFFFFFF;
            searchdata.Mode = 0;
            searchdata.DesW = 0;
            searchdata.DesH = 0;
            GraphicCache.getAndTouch(searchdata);
            --count;
        }
        statusstr.append(" (elapsed ");
        statusstr.append(TVP.getTickCount() - starttime);
        statusstr.append("ms)");
        DebugClass.addLog(statusstr.toString());
    }

    public static void loadGraphic(BaseBitmap dest, String name, int keyidx, int desw, int desh, int mode, String[] provincename, Holder<Dispatch2> metainfo) throws TJSException {
        String nname = TVP.StorageMediaManager.normalizeStorageName(name, null);
        GraphicsSearchData searchdata = null;
        if (TVP.GraphicCacheEnabled) {
            searchdata = new GraphicsSearchData();
            searchdata.Name = nname;
            searchdata.KeyIdx = keyidx;
            searchdata.Mode = mode;
            searchdata.DesW = desw;
            searchdata.DesH = desh;
            GraphicImageData ptr = GraphicCache.getAndTouch(searchdata);
            if (ptr != null) {
                ptr.assignToBitmap(dest);
                if (provincename != null && provincename.length > 0) {
                    provincename[0] = ptr.mProvinceName;
                }
                if (metainfo != null) {
                    metainfo.mValue = GraphicsLoader.metaInfoPairsToDictionary(ptr.mMetaInfo);
                }
                return;
            }
        }
        ArrayList<GraphicMetaInfoPair> mi = new ArrayList<GraphicMetaInfoPair>();
        try {
            GraphicsLoader.internalLoadGraphic(dest, nname, keyidx, desw, desh, mi, mode, provincename);
            if (metainfo != null) {
                metainfo.mValue = GraphicsLoader.metaInfoPairsToDictionary(mi);
            }
            if (TVP.GraphicCacheEnabled) {
                GraphicImageData data = new GraphicImageData();
                data.assignBitmap(dest);
                if (provincename != null && provincename.length > 0) {
                    data.mProvinceName = provincename[0];
                }
                data.mMetaInfo = mi;
                mi = null;
                GraphicsLoader.checkGraphicCacheLimit();
                int datasize = data.getSize();
                TVP.GraphicCacheTotalBytes += (long)datasize;
                GraphicCache.put(searchdata, data);
            }
        }
        finally {
            mi = null;
        }
    }

    private static boolean internalLoadGraphic(BaseBitmap dest, String _name, int keyidx, int desw, int desh, ArrayList<GraphicMetaInfoPair> MetaInfo, int mode, String[] provincename) throws TJSException {
        String newname;
        int i;
        int count;
        int start;
        if (!ClearGraphicCacheCallbackInit) {
            TVP.CompactEvent.addCompactEventHook(new CompactEventCallbackInterface(){

                @Override
                public void onCompact(int level) throws TJSScriptException, TJSScriptError, TJSException {
                    if (level >= 15) {
                        GraphicsLoader.clearGraphicCache();
                    }
                }
            });
            ClearGraphicCacheCallbackInit = true;
        }
        StringBuilder builder = new StringBuilder(256);
        String name = _name;
        String ext = Storage.extractStorageExt(name);
        if (ext == null || ext.length() == 0) {
            int count2 = GRAPHIC_TYPE.length;
            int i2 = 0;
            while (i2 < count2) {
                builder.delete(0, builder.length());
                builder.append(name);
                builder.append(GRAPHIC_TYPE[i2]);
                String newname2 = builder.toString();
                if (Storage.isExistentStorage(newname2)) {
                    name = newname2;
                    ext = GRAPHIC_TYPE[i2];
                    break;
                }
                ++i2;
            }
            if (i2 == count2) {
                Message.throwExceptionMessage("%1 \u306b\u3064\u3044\u3066\u9069\u5207\u306a\u62e1\u5f35\u5b50\u3092\u6301\u3063\u305f\u30d5\u30a1\u30a4\u30eb\u3092\u898b\u3064\u3051\u3089\u308c\u307e\u305b\u3093\u3067\u3057\u305f", name);
            }
        }
        boolean keyadapt = keyidx == 0x1FFFFFF;
        boolean doalphacolormat = SystemColor.is_clAlphaMat(keyidx);
        int alphamatcolor = SystemColor.get_clAlphaMat(keyidx);
        keyidx = SystemColor.is_clPalIdx(keyidx) ? SystemColor.get_clPalIdx(keyidx) : -1;
        HashMap<String, String> metainfo = new HashMap<String, String>();
        BinaryStream stream = Storage.createStream(name, 0);
        NativeImageBuffer img = NativeImageLoader.loadImage(stream, ext, metainfo, keyidx, mode);
        if (img == null) {
            return false;
        }
        dest.setNativeBitmap(img);
        if (desw != 0 && desh != 0 && (dest.getWidth() != desw || dest.getHeight() != desh)) {
            dest.setSize(desw, desh, true);
        }
        if (keyadapt && mode == 0) {
            dest.makeAlphaFromAdaptiveColor();
        }
        if (mode != 0) {
            return true;
        }
        int extlen = 0;
        if (ext != null) {
            extlen = ext.length();
        }
        String baseName = extlen != 0 ? _name.substring(0, _name.length() - extlen) : _name;
        if (provincename != null && provincename.length > 0) {
            builder.delete(0, builder.length());
            builder.append(baseName);
            builder.append("_p");
            start = builder.length();
            count = GRAPHIC_TYPE.length;
            i = 0;
            while (i < count) {
                builder.append(GRAPHIC_TYPE[i]);
                newname = builder.toString();
                if (Storage.isExistentStorage(newname)) {
                    provincename[0] = newname;
                    break;
                }
                builder.delete(start, builder.length());
                ++i;
            }
            if (i == count) {
                provincename[0] = null;
            }
        }
        builder.delete(0, builder.length());
        builder.append(baseName);
        builder.append("_m");
        start = builder.length();
        count = GRAPHIC_TYPE.length;
        i = 0;
        while (i < count) {
            builder.append(GRAPHIC_TYPE[i]);
            newname = builder.toString();
            if (Storage.isExistentStorage(newname)) {
                name = newname;
                ext = GRAPHIC_TYPE[i];
                break;
            }
            builder.delete(start, builder.length());
            ++i;
        }
        if (i != count) {
            stream = Storage.createStream(name, 0);
            img = NativeImageLoader.loadImage(stream, ext, null, 0, 2);
            Rect refrect = new Rect(0, 0, dest.getWidth(), dest.getHeight());
            NativeImageBuffer d = dest.getBitmap();
            d.copyRect(0, 0, img, refrect, 2);
        }
        if (doalphacolormat && dest.is32BPP()) {
            NativeImageBuffer d = dest.getBitmap();
            d.doAlphaColorMat(alphamatcolor);
        }
        return true;
    }

    private static Dispatch2 metaInfoPairsToDictionary(ArrayList<GraphicMetaInfoPair> vec) throws VariantException, TJSException {
        Dispatch2 dic = TJS.createDictionaryObject();
        if (vec == null) {
            return dic;
        }
        int count = vec.size();
        int i = 0;
        while (i < count) {
            GraphicMetaInfoPair g = vec.get(i);
            Variant val = new Variant(g.Value);
            dic.propSet(512, g.Name, val, dic);
            ++i;
        }
        return dic;
    }

    static class GraphicImageData {
        private BaseBitmap mBitmap;
        private int mWidth;
        private int mHeight;
        private int mPixelSize;
        public String mProvinceName;
        public ArrayList<GraphicMetaInfoPair> mMetaInfo;
        private int mSize;

        public final void assignBitmap(BaseBitmap bmp) {
            if (this.mBitmap != null) {
                this.mBitmap = null;
            }
            this.mWidth = bmp.getWidth();
            this.mHeight = bmp.getHeight();
            this.mPixelSize = bmp.is32BPP() ? 4 : 1;
            this.mSize = this.mWidth * this.mHeight * this.mPixelSize;
            this.mBitmap = new BaseBitmap(bmp);
        }

        public final void assignToBitmap(BaseBitmap bmp) {
            if (this.mBitmap != null) {
                bmp.assignBitmap(this.mBitmap);
            }
        }

        public final int getSize() {
            return this.mSize;
        }
    }

    static class GraphicMetaInfoPair {
        public String Name;
        public String Value;

        public GraphicMetaInfoPair(String name, String value) {
            this.Name = name;
            this.Value = value;
        }
    }

    static class GraphicsSearchData {
        public String Name;
        public int KeyIdx;
        public int Mode;
        public int DesW;
        public int DesH;

        GraphicsSearchData() {
        }

        public boolean equals(Object o) {
            if (o instanceof GraphicsSearchData) {
                GraphicsSearchData rhs = (GraphicsSearchData)o;
                return this.Name.equals(rhs.Name) && this.KeyIdx == rhs.KeyIdx && this.Mode == rhs.Mode && this.DesW == rhs.DesW && this.DesH == rhs.DesH;
            }
            return false;
        }

        public int hashCode() {
            int hash = this.Name.hashCode();
            hash ^= this.KeyIdx;
            hash ^= this.Mode;
            hash ^= this.DesW;
            return hash ^= this.DesH;
        }
    }
}

