/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2.visual;

import java.util.ArrayList;
import jp.kirikiri.tjs2.Holder;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.VariantException;
import jp.kirikiri.tvp2.msg.Message;
import jp.kirikiri.tvp2.visual.BaseBitmap;
import jp.kirikiri.tvp2.visual.ComplexRect;
import jp.kirikiri.tvp2.visual.Drawable;
import jp.kirikiri.tvp2.visual.LayerNI;
import jp.kirikiri.tvp2.visual.Point;
import jp.kirikiri.tvp2.visual.Rect;
import jp.kirikiri.tvp2.visual.Size;
import jp.kirikiri.tvp2.visual.WindowNI;
import jp.kirikiri.tvp2env.WindowForm;

public class LayerManager
implements Drawable {
    private static final int UPDATE_UNITE_LIMIT = 300;
    private WindowNI mWindow;
    private BaseBitmap mDrawBuffer;
    private int mDesiredLayerType;
    private LayerNI mCaptureOwner;
    private LayerNI mLastMouseMoveSent;
    private ArrayList<LayerNI> mModalLayerVector = new ArrayList();
    private LayerNI mFocusedLayer;
    private LayerNI mPrimary;
    private boolean mOverallOrderIndexValid;
    private ArrayList<LayerNI> mAllNodes = new ArrayList();
    private ComplexRect mUpdateRegion = new ComplexRect();
    private boolean mFocusChangeLock;
    private boolean mVisualStateChanged;
    private int mLastMouseMoveX;
    private int mLastMouseMoveY;
    private boolean mReleaseCaptureCalled;
    private boolean mInNotifyingHintOrCursorChange;
    private int mEnabledWorkRefCount;

    public LayerManager(WindowNI window) {
        this.mWindow = window;
        this.mDesiredLayerType = 1;
        this.mVisualStateChanged = true;
        this.mLastMouseMoveX = -1;
        this.mLastMouseMoveY = -1;
    }

    public void registerSelfToWindow() {
        this.mWindow.registerLayerManager(this);
    }

    public void unregisterSelfFromWindow() throws TJSException {
        this.mWindow.unregisterLayerManager(this);
    }

    public void notifyVisualStateChanged() {
        this.mVisualStateChanged = true;
    }

    @Override
    public BaseBitmap getDrawTargetBitmap(Rect rect, Rect cliprect) throws TJSException {
        int w = rect.width();
        int h = rect.height();
        if (this.mDrawBuffer == null) {
            this.mDrawBuffer = new BaseBitmap(w, h, 32);
        } else {
            int bw = this.mDrawBuffer.getWidth();
            int bh = this.mDrawBuffer.getHeight();
            if (bw < w || bh < h) {
                int neww = bw > w ? bw : w;
                neww += neww & 1;
                this.mDrawBuffer.setSize(neww, bh > h ? bh : h);
            }
        }
        cliprect.left = 0;
        cliprect.top = 0;
        cliprect.right = w;
        cliprect.bottom = h;
        return this.mDrawBuffer;
    }

    @Override
    public int getTargetLayerType() {
        return this.mDesiredLayerType;
    }

    public WindowNI getWindow() {
        return this.mWindow;
    }

    public ComplexRect getUpdateRegionForCompletion() {
        return this.mUpdateRegion;
    }

    @Override
    public void drawCompleted(Rect destrect, BaseBitmap bmp, Rect cliprect, int type, int opacity) throws TJSException {
        this.mWindow.notifyBitmapCompleted(this, destrect.left, destrect.top, bmp.getNativeImageBuffer(), cliprect, type, opacity);
    }

    public void attachPrimary(LayerNI pri) throws TJSException {
        this.detachPrimary();
        if (this.mPrimary == null) {
            this.mPrimary = pri;
            this.mEnabledWorkRefCount = 0;
            this.mOverallOrderIndexValid = false;
            this.mUpdateRegion.clear();
            pri.setVisible(true);
            pri.setOpacity(255);
        }
    }

    public void detachPrimary() throws TJSException {
        if (this.mPrimary != null) {
            this.setFocusTo(null);
            this.releaseCapture();
            this.forceMouseLeave();
            this.notifyPart(this.mPrimary);
            this.mPrimary = null;
        }
    }

    public LayerNI getPrimaryLayer() {
        return this.mPrimary;
    }

    public boolean isPrimaryLayerAttached() {
        return this.mPrimary != null;
    }

    public boolean getPrimaryLayerSize(Size c) {
        if (this.isPrimaryLayerAttached()) {
            c.width = this.mPrimary.getWidth();
            c.height = this.mPrimary.getHeight();
            return true;
        }
        return false;
    }

    public void notifyPart(LayerNI lay) throws TJSException {
        this.invalidateOverallIndex();
        this.blurTree(lay);
        this.releaseCaptureFromTree(lay);
    }

    public void invalidateOverallIndex() {
        this.mOverallOrderIndexValid = false;
    }

    public void recreateOverallOrderIndex() {
        if (!this.mOverallOrderIndexValid) {
            int[] index = new int[1];
            this.mAllNodes.clear();
            if (this.mPrimary != null) {
                this.mPrimary.recreateOverallOrderIndex(index, this.mAllNodes);
            }
            this.mOverallOrderIndexValid = true;
        }
    }

    public ArrayList<LayerNI> getAllNodes() {
        if (!this.mOverallOrderIndexValid) {
            this.recreateOverallOrderIndex();
        }
        return this.mAllNodes;
    }

    public void queryUpdateExcludeRect() {
        if (!this.mVisualStateChanged) {
            return;
        }
        Rect r = new Rect();
        r.clear();
        if (this.mPrimary != null) {
            this.mPrimary.queryUpdateExcludeRect(r, true);
        }
        this.mVisualStateChanged = false;
    }

    public void notifyMouseCursorChange(LayerNI layer, int cursor) throws TJSException {
        if (this.mInNotifyingHintOrCursorChange) {
            return;
        }
        this.mInNotifyingHintOrCursorChange = true;
        try {
            LayerNI l = this.mCaptureOwner != null ? this.mCaptureOwner : this.getMostFrontChildAt(this.mLastMouseMoveX, this.mLastMouseMoveY);
            if (l == layer) {
                this.setMouseCursor(cursor);
            }
        }
        finally {
            this.mInNotifyingHintOrCursorChange = false;
        }
    }

    public void setMouseCursor(int cursor) {
        if (this.mWindow == null) {
            return;
        }
        if (cursor == 0) {
            this.mWindow.setDefaultMouseCursor(this);
        } else {
            this.mWindow.setMouseCursor(this, cursor);
        }
    }

    public void getCursorPos(Point pos) {
        if (this.mWindow == null) {
            return;
        }
        this.mWindow.getCursorPos(this, pos);
    }

    public void setCursorPos(int x, int y) {
        if (this.mWindow == null) {
            return;
        }
        this.mWindow.setCursorPos(this, x, y);
    }

    public void notifyHintChange(LayerNI layer, String hint) throws TJSException {
        if (this.mInNotifyingHintOrCursorChange) {
            return;
        }
        this.mInNotifyingHintOrCursorChange = true;
        try {
            LayerNI l = this.mCaptureOwner != null ? this.mCaptureOwner : this.getMostFrontChildAt(this.mLastMouseMoveX, this.mLastMouseMoveY);
            if (l == layer) {
                this.setHint(hint);
            }
        }
        finally {
            this.mInNotifyingHintOrCursorChange = false;
        }
    }

    public void setHint(String hint) {
        if (this.mWindow == null) {
            return;
        }
        this.mWindow.setHintText(this, hint);
    }

    public void notifyLayerResize() throws TJSException {
        if (this.mWindow == null) {
            return;
        }
        this.mWindow.notifyLayerResize(this);
    }

    public void notifyWindowInvalidation() {
        if (this.mWindow == null) {
            return;
        }
        this.mWindow.notifyLayerImageChange(this);
    }

    public void setWindow(WindowNI window) {
        this.mWindow = window;
    }

    public void notifyResizeFromWindow(int w, int h) throws TJSException {
        if (this.mPrimary != null) {
            this.mPrimary.internalSetSize(w, h);
        }
    }

    public LayerNI getMostFrontChildAt(int x, int y) throws TJSException {
        return this.getMostFrontChildAt(x, y, null, false);
    }

    public LayerNI getMostFrontChildAt(int x, int y, LayerNI except, boolean get_disabled) throws TJSException {
        if (this.mPrimary == null) {
            return null;
        }
        Holder<Object> lay = new Holder<Object>(null);
        this.mPrimary.getMostFrontChildAt(x, y, lay, except, get_disabled);
        return (LayerNI)lay.mValue;
    }

    public void primaryClick(int x, int y) throws TJSException {
        LayerNI l = this.getMostFrontChildAt(x, y);
        if (l != null && this.mCaptureOwner == l) {
            int[] ax = new int[]{x};
            int[] ay = new int[]{y};
            l.fromPrimaryCoordinates(ax, ay);
            l.fireClick(ax[0], ay[0]);
        }
    }

    public void primaryDoubleClick(int x, int y) throws TJSException {
        LayerNI l = this.getMostFrontChildAt(x, y);
        if (l != null) {
            int[] ax = new int[]{x};
            int[] ay = new int[]{y};
            l.fromPrimaryCoordinates(ax, ay);
            l.fireDoubleClick(ax[0], ay[0]);
        }
    }

    public void primaryMouseDown(int x, int y, int mb, int flags) throws TJSException {
        LayerNI l;
        this.primaryMouseMove(x, y, flags);
        LayerNI layerNI = l = this.mCaptureOwner != null ? this.mCaptureOwner : this.getMostFrontChildAt(x, y);
        if (l != null) {
            int[] ax = new int[]{x};
            int[] ay = new int[]{y};
            l.fromPrimaryCoordinates(ax, ay);
            this.mReleaseCaptureCalled = false;
            l.fireMouseDown(ax[0], ay[0], mb, flags);
            boolean no_capture = this.mReleaseCaptureCalled;
            if (this.mCaptureOwner != l) {
                this.releaseCapture();
                if (!no_capture) {
                    this.mCaptureOwner = l;
                }
            }
            this.setHint("");
        } else {
            this.releaseCapture();
        }
    }

    void primaryMouseUp(int x, int y, int mb, int flags) throws TJSException {
        LayerNI l = this.mCaptureOwner != null ? this.mCaptureOwner : this.getMostFrontChildAt(x, y);
        if (l != null) {
            int orig_x = x;
            int orig_y = y;
            int[] ax = new int[]{x};
            int[] ay = new int[]{y};
            l.fromPrimaryCoordinates(ax, ay);
            l.fireMouseUp(ax[0], ay[0], mb, flags);
            if (!WindowForm.isAnyMouseButtonPressedInShiftStateFlags(flags)) {
                this.releaseCapture();
                this.primaryMouseMove(orig_x, orig_y, flags);
            }
        }
    }

    void primaryMouseMove(int x, int y, int flags) throws TJSException {
        boolean poschanged = this.mLastMouseMoveX != x || this.mLastMouseMoveY != y;
        this.mLastMouseMoveX = x;
        this.mLastMouseMoveY = y;
        LayerNI l = this.mCaptureOwner != null ? this.mCaptureOwner : this.getMostFrontChildAt(x, y);
        if (this.mLastMouseMoveSent != l) {
            if (this.mLastMouseMoveSent != null) {
                this.mLastMouseMoveSent.fireMouseLeave();
            }
            if ((l = this.mCaptureOwner != null ? this.mCaptureOwner : this.getMostFrontChildAt(x, y)) != null) {
                this.mInNotifyingHintOrCursorChange = true;
                try {
                    l.fireMouseEnter();
                    LayerNI ll = this.mCaptureOwner != null ? this.mCaptureOwner : this.getMostFrontChildAt(x, y);
                    if (l != ll) {
                        l.fireMouseLeave();
                        l = ll;
                        if (l != null) {
                            l.fireMouseEnter();
                        }
                    }
                    if (l != null) {
                        l.setCurrentCursorToWindow();
                    }
                    if (l != null) {
                        l.setCurrentHintToWindow();
                    }
                }
                finally {
                    this.mInNotifyingHintOrCursorChange = false;
                }
            }
            if (l == null) {
                this.setMouseCursor(0);
                this.setHint("");
            }
        }
        if (this.mLastMouseMoveSent != l) {
            if (this.mLastMouseMoveSent != null) {
                this.mLastMouseMoveSent = null;
            }
            this.mLastMouseMoveSent = l;
        }
        if (l != null && poschanged) {
            int[] ax = new int[]{x};
            int[] ay = new int[]{y};
            l.fromPrimaryCoordinates(ax, ay);
            l.fireMouseMove(ax[0], ay[0], flags);
        }
    }

    private void forceMouseLeave() {
        if (this.mLastMouseMoveSent != null) {
            LayerNI lay = this.mLastMouseMoveSent;
            this.mLastMouseMoveSent = null;
            lay.fireMouseLeave();
        }
    }

    void forceMouseRecheck() throws TJSException {
        this.primaryMouseMove(this.mLastMouseMoveX, this.mLastMouseMoveY, 0);
    }

    void mouseOutOfWindow() throws TJSException {
        if (this.mCaptureOwner == null) {
            this.primaryMouseMove(-1, -1, 0);
        }
    }

    void leaveMouseFromTree(LayerNI root) {
        if (this.mLastMouseMoveSent != null && this.mLastMouseMoveSent.isAncestorOrSelf(root)) {
            LayerNI lay = this.mLastMouseMoveSent;
            this.mLastMouseMoveSent = null;
            lay.fireMouseLeave();
        }
    }

    public void releaseCapture() {
        this.mReleaseCaptureCalled = true;
        if (this.mCaptureOwner != null) {
            this.mCaptureOwner = null;
            this.mWindow.windowReleaseCapture(this);
        }
    }

    private void releaseCaptureFromTree(LayerNI layer) {
        if (this.mCaptureOwner != null && this.mCaptureOwner.isAncestorOrSelf(layer)) {
            this.releaseCapture();
        }
    }

    public final boolean blurTree(LayerNI root) throws TJSException {
        this.removeTreeModalState(root);
        this.leaveMouseFromTree(root);
        if (this.mFocusedLayer == null) {
            return false;
        }
        if (this.mFocusedLayer.isAncestorOrSelf(root)) {
            return false;
        }
        LayerNI next = root.getNextFocusable();
        if (next != this.mFocusedLayer) {
            this.setFocusTo(next, true);
        } else {
            this.setFocusTo(null, true);
        }
        return true;
    }

    public LayerNI getFocusedLayer() {
        return this.mFocusedLayer;
    }

    public void setFocusedLayer(LayerNI layer) throws TJSException {
        this.setFocusTo(layer, false);
    }

    public final void checkTreeFocusableState(LayerNI root) {
    }

    LayerNI focusPrev() throws TJSException {
        LayerNI l = this.mFocusedLayer == null ? this.searchFirstFocusable(false) : this.mFocusedLayer.getPrevFocusable();
        if (l != null) {
            this.setFocusTo(l, false);
        }
        return l;
    }

    LayerNI focusNext() throws TJSException {
        LayerNI l = this.mFocusedLayer == null ? this.searchFirstFocusable(false) : this.mFocusedLayer.getNextFocusable();
        if (l != null) {
            this.setFocusTo(l, true);
        }
        return l;
    }

    LayerNI searchFirstFocusable(boolean ignore_chain_focusable) {
        if (this.mPrimary == null) {
            return null;
        }
        LayerNI lay = this.mPrimary.searchFirstFocusable(ignore_chain_focusable);
        return lay;
    }

    public boolean setFocusTo(LayerNI layer) throws TJSException {
        return this.setFocusTo(layer, true);
    }

    public boolean setFocusTo(LayerNI layer, boolean direction) throws TJSException {
        if (layer != null && !layer.getNodeFocusable()) {
            return false;
        }
        if (layer != null && !layer.getShutdown()) {
            layer = layer.fireBeforeFocus(this.mFocusedLayer, direction);
        }
        if (layer != null && !layer.getNodeFocusable()) {
            return false;
        }
        if (this.mFocusedLayer == layer) {
            return false;
        }
        if (this.mFocusChangeLock) {
            Message.throwExceptionMessage("\u30d5\u30a9\u30fc\u30ab\u30b9\u5909\u66f4\u51e6\u7406\u4e2d\u306f\u30d5\u30a9\u30fc\u30ab\u30b9\u3092\u65b0\u305f\u306b\u5909\u66f4\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        this.mFocusChangeLock = true;
        LayerNI org = this.mFocusedLayer;
        this.mFocusedLayer = layer;
        try {
            if (org != null && !org.getShutdown()) {
                org.fireBlur(layer);
            }
            if (this.mFocusedLayer != null && !this.mFocusedLayer.getShutdown()) {
                this.mFocusedLayer.fireFocus(org, direction);
            }
        }
        finally {
            this.mFocusChangeLock = false;
        }
        if (this.mFocusedLayer != null) {
            this.setImeModeOf(this.mFocusedLayer);
        } else {
            this.resetImeMode();
        }
        if (this.mFocusedLayer != null) {
            this.setAttentionPointOf(this.mFocusedLayer);
        } else {
            this.disableAttentionPoint();
        }
        this.mFocusChangeLock = false;
        return true;
    }

    void releaseAllModalLayer() {
        this.mModalLayerVector.clear();
    }

    void setModeTo(LayerNI layer) throws TJSException {
        if (layer == null) {
            return;
        }
        this.saveEnabledWork();
        try {
            LayerNI current = this.getCurrentModalLayer();
            if (current != null && layer.isAncestorOrSelf(current)) {
                Message.throwExceptionMessage("\u3059\u3067\u306b\u30e2\u30fc\u30c0\u30eb\u306a\u30ec\u30a4\u30e4\u306e\u89aa\u30ec\u30a4\u30e4\u3001\u3042\u308b\u3044\u306f\u4e0d\u53ef\u8996/\u7121\u52b9\u306a\u30ec\u30a4\u30e4\u3092\u30e2\u30fc\u30c0\u30eb\u306b\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093");
            }
            if (!layer.mVisible) {
                layer.mVisible = true;
            }
            if (!layer.getParentVisible() || !layer.mEnabled) {
                Message.throwExceptionMessage("\u3059\u3067\u306b\u30e2\u30fc\u30c0\u30eb\u306a\u30ec\u30a4\u30e4\u306e\u89aa\u30ec\u30a4\u30e4\u3001\u3042\u308b\u3044\u306f\u4e0d\u53ef\u8996/\u7121\u52b9\u306a\u30ec\u30a4\u30e4\u3092\u30e2\u30fc\u30c0\u30eb\u306b\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093");
            }
            if (layer == current) {
                Message.throwExceptionMessage("\u3059\u3067\u306b\u30e2\u30fc\u30c0\u30eb\u306a\u30ec\u30a4\u30e4\u306e\u89aa\u30ec\u30a4\u30e4\u3001\u3042\u308b\u3044\u306f\u4e0d\u53ef\u8996/\u7121\u52b9\u306a\u30ec\u30a4\u30e4\u3092\u30e2\u30fc\u30c0\u30eb\u306b\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093");
            }
            this.setFocusTo(layer.searchFirstFocusable(), true);
            this.mModalLayerVector.add(layer);
        }
        finally {
            this.notifyNodeEnabledState();
        }
    }

    void removeModeFrom(LayerNI layer) throws TJSException {
        boolean do_notify = false;
        try {
            int count = this.mModalLayerVector.size();
            int i = 0;
            while (i < count) {
                LayerNI ni = this.mModalLayerVector.get(i);
                if (layer == ni) {
                    if (!do_notify) {
                        do_notify = true;
                        this.saveEnabledWork();
                    }
                    this.setFocusTo(layer.getNextFocusable(), true);
                    this.mModalLayerVector.remove(i);
                    count = this.mModalLayerVector.size();
                    continue;
                }
                ++i;
            }
        }
        finally {
            if (do_notify) {
                this.notifyNodeEnabledState();
            }
        }
    }

    private void removeTreeModalState(LayerNI root) throws TJSException {
        boolean do_notify = false;
        try {
            int count = this.mModalLayerVector.size();
            int i = 0;
            while (i < count) {
                LayerNI ni = this.mModalLayerVector.get(i);
                if (ni.isAncestorOrSelf(root)) {
                    if (!do_notify) {
                        do_notify = true;
                        this.saveEnabledWork();
                    }
                    this.setFocusTo(root.getNextFocusable(), true);
                    this.mModalLayerVector.remove(i);
                    count = this.mModalLayerVector.size();
                    continue;
                }
                ++i;
            }
        }
        finally {
            if (do_notify) {
                this.notifyNodeEnabledState();
            }
        }
    }

    public LayerNI getCurrentModalLayer() {
        int size = this.mModalLayerVector.size();
        if (size == 0) {
            return null;
        }
        return this.mModalLayerVector.get(size - 1);
    }

    private boolean searchAttentionPoint(LayerNI target, Point pt) {
        while (target != null) {
            if (target.getUseAttention()) {
                pt.x = target.getAttentionLeft();
                pt.y = target.getAttentionTop();
                target.toPrimaryCoordinates(pt);
                return true;
            }
            target = target.getParent();
        }
        return false;
    }

    private void setAttentionPointOf(LayerNI layer) {
        if (this.mWindow == null) {
            return;
        }
        Point pt = new Point();
        if (this.searchAttentionPoint(layer, pt)) {
            this.mWindow.setAttentionPoint(this, layer, pt);
        } else {
            this.mWindow.disableAttentionPoint(this);
        }
    }

    private void disableAttentionPoint() {
        if (this.mWindow != null) {
            this.mWindow.disableAttentionPoint(this);
        }
    }

    void notifyAttentionStateChanged(LayerNI from) {
        if (this.mFocusedLayer == from) {
            this.setAttentionPointOf(from);
        }
    }

    private void setImeModeOf(LayerNI layer) {
        if (this.mWindow == null) {
            return;
        }
        this.mWindow.setImeMode(this, layer.getImeMode());
    }

    private void resetImeMode() {
        this.mWindow.resetImeMode(this);
    }

    void notifyImeModeChanged(LayerNI from) {
        if (this.mFocusedLayer == from) {
            this.setImeModeOf(from);
        }
    }

    void saveEnabledWork() {
        if (this.mEnabledWorkRefCount == 0 && this.mPrimary != null) {
            this.mPrimary.saveEnabledWork();
        }
        ++this.mEnabledWorkRefCount;
    }

    void notifyNodeEnabledState() {
        --this.mEnabledWorkRefCount;
        if (this.mEnabledWorkRefCount == 0 && this.mPrimary != null) {
            this.mPrimary.notifyNodeEnabledState();
        }
    }

    void primaryKeyDown(int key, int shift) throws TJSException {
        if (this.mFocusedLayer != null) {
            this.mFocusedLayer.fireKeyDown(key, shift);
        } else if (this.mPrimary != null) {
            this.mPrimary.defaultKeyDown(key, shift);
        }
    }

    void primaryKeyUp(int key, int shift) {
        if (this.mFocusedLayer != null) {
            this.mFocusedLayer.fireKeyUp(key, shift);
        } else if (this.mPrimary != null) {
            this.mPrimary.defaultKeyUp(key, shift);
        }
    }

    void primaryKeyPress(char key) {
        if (this.mFocusedLayer != null) {
            this.mFocusedLayer.fireKeyPress(key);
        } else if (this.mPrimary != null) {
            this.mPrimary.defaultKeyPress(key);
        }
    }

    void primaryMouseWheel(int shift, int delta, int x, int y) {
        if (this.mFocusedLayer != null) {
            this.mFocusedLayer.fireMouseWheel(shift, delta, x, y);
        }
    }

    public void addUpdateRegion(ComplexRect rects) {
        this.mUpdateRegion.or(rects);
        if (this.mUpdateRegion.getCount() > 300) {
            this.mUpdateRegion.unite();
        }
        this.notifyWindowInvalidation();
    }

    public void addUpdateRegion(Rect rect) {
        this.mUpdateRegion.or(rect);
        this.notifyWindowInvalidation();
    }

    public void updateToDrawDevice() throws VariantException, TJSException {
        if (this.mPrimary == null) {
            return;
        }
        this.mPrimary.completeForWindow(this);
    }

    public void notifyUpdateRegionFixed() {
    }

    public void requestInvalidation(Rect r) {
        if (this.mPrimary == null) {
            return;
        }
        Rect ur = new Rect();
        Rect cr = new Rect(0, 0, this.mPrimary.getRect().width(), this.mPrimary.getRect().height());
        if (Rect.intersectRect(ur, r, cr)) {
            this.addUpdateRegion(ur);
        }
    }

    void recheckInputState() throws TJSException {
        this.forceMouseRecheck();
    }

    void dumpLayerStructure() {
        if (this.mPrimary != null) {
            this.mPrimary.dumpStructure();
        }
    }

    public void notifyClick(int x, int y) throws TJSException {
        this.primaryClick(x, y);
    }

    public void notifyDoubleClick(int x, int y) throws TJSException {
        this.primaryDoubleClick(x, y);
    }

    public void notifyMouseDown(int x, int y, int mb, int flags) throws TJSException {
        this.primaryMouseDown(x, y, mb, flags);
    }

    public void notifyMouseUp(int x, int y, int mb, int flags) throws TJSException {
        this.primaryMouseUp(x, y, mb, flags);
    }

    public void notifyMouseMove(int x, int y, int flags) throws TJSException {
        this.primaryMouseMove(x, y, flags);
    }

    public void notifyMouseOutOfWindow() throws TJSException {
        this.mouseOutOfWindow();
    }

    public void notifyKeyDown(int key, int shift) throws TJSException {
        this.primaryKeyDown(key, shift);
    }

    public void notifyKeyUp(int key, int shift) {
        this.primaryKeyUp(key, shift);
    }

    public void notifyKeyPress(char key) {
        this.primaryKeyPress(key);
    }

    public void notifyMouseWheel(int shift, int delta, int x, int y) {
        this.primaryMouseWheel(shift, delta, x, y);
    }
}

