/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2.visual;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.Holder;
import jp.kirikiri.tjs2.IntVector;
import jp.kirikiri.tjs2.IntWrapper;
import jp.kirikiri.tjs2.NativeInstanceObject;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.TJSScriptError;
import jp.kirikiri.tjs2.TJSScriptException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantClosure;
import jp.kirikiri.tjs2.VariantException;
import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.base.CompactEventCallbackInterface;
import jp.kirikiri.tvp2.base.ContinuousEventCallbackInterface;
import jp.kirikiri.tvp2.msg.Message;
import jp.kirikiri.tvp2.utils.DebugClass;
import jp.kirikiri.tvp2.utils.ObjectList;
import jp.kirikiri.tvp2.visual.AffineMatrix2D;
import jp.kirikiri.tvp2.visual.BaseBitmap;
import jp.kirikiri.tvp2.visual.BaseTransHandler;
import jp.kirikiri.tvp2.visual.ComplexRect;
import jp.kirikiri.tvp2.visual.DivisibleData;
import jp.kirikiri.tvp2.visual.DivisibleTransHandler;
import jp.kirikiri.tvp2.visual.Drawable;
import jp.kirikiri.tvp2.visual.GammaAdjustData;
import jp.kirikiri.tvp2.visual.GiveUpdateTransHandler;
import jp.kirikiri.tvp2.visual.GraphicsLoader;
import jp.kirikiri.tvp2.visual.LayerClass;
import jp.kirikiri.tvp2.visual.LayerManager;
import jp.kirikiri.tvp2.visual.LayerType;
import jp.kirikiri.tvp2.visual.Point;
import jp.kirikiri.tvp2.visual.PointD;
import jp.kirikiri.tvp2.visual.Rect;
import jp.kirikiri.tvp2.visual.ScanLineProviderForBaseBitmap;
import jp.kirikiri.tvp2.visual.SimpleOptionProviderObject;
import jp.kirikiri.tvp2.visual.TempBitmapHolder;
import jp.kirikiri.tvp2.visual.TransHandlerProvider;
import jp.kirikiri.tvp2.visual.WindowClass;
import jp.kirikiri.tvp2.visual.WindowNI;
import jp.kirikiri.tvp2env.Font;
import jp.kirikiri.tvp2env.SystemColor;
import jp.kirikiri.tvp2env.WindowForm;

public class LayerNI
extends NativeInstanceObject
implements CompactEventCallbackInterface,
Drawable {
    private static final int TRANS_WHITE = 0xFFFFFF;
    private static final int TRANS_BLACK = 0;
    private static final int TRANS_GLAY = 0x808080;
    private static final int WHITE = -1;
    public static boolean PurgeOnHide = true;
    public static boolean DefaultHoldAlpha;
    private static final int htMask = 0;
    private static final int htProvince = 1;
    private static final int tutDivisibleFade = 0;
    private static final int tutDivisible = 1;
    private static final int tutGiveUpdate = 2;
    private static final int gsotNone = 0;
    private static final int gsotSimple = 1;
    private static final int gsotInterlace = 2;
    private static final int gsotBiDirection = 3;
    public static final int bmCopy = 0;
    public static final int bmCopyOnAlpha = 1;
    public static final int bmAlpha = 2;
    public static final int bmAlphaOnAlpha = 3;
    public static final int bmAdd = 4;
    public static final int bmSub = 5;
    public static final int bmMul = 6;
    public static final int bmDodge = 7;
    public static final int bmDarken = 8;
    public static final int bmLighten = 9;
    public static final int bmScreen = 10;
    public static final int bmAddAlpha = 11;
    public static final int bmAddAlphaOnAddAlpha = 12;
    public static final int bmAddAlphaOnAlpha = 13;
    public static final int bmAlphaOnAddAlpha = 14;
    public static final int bmCopyOnAddAlpha = 15;
    public static final int bmPsNormal = 16;
    public static final int bmPsAdditive = 17;
    public static final int bmPsSubtractive = 18;
    public static final int bmPsMultiplicative = 19;
    public static final int bmPsScreen = 20;
    public static final int bmPsOverlay = 21;
    public static final int bmPsHardLight = 22;
    public static final int bmPsSoftLight = 23;
    public static final int bmPsColorDodge = 24;
    public static final int bmPsColorDodge5 = 25;
    public static final int bmPsColorBurn = 26;
    public static final int bmPsLighten = 27;
    public static final int bmPsDarken = 28;
    public static final int bmPsDifference = 29;
    public static final int bmPsDifference5 = 30;
    public static final int bmPsExclusion = 31;
    private static int GraphicSplitOperationType;
    private static final int CACHE_UNITE_LIMIT = 60;
    private static final int EXPOSED_UNITE_LIMIT = 30;
    private static final int DIRECT_UNITE_LIMIT = 10;
    private static final boolean FreeUnusedLayerCache = true;
    private WeakReference<Dispatch2> mOwner;
    private VariantClosure mActionOwner = new VariantClosure(null);
    private boolean mShutdown;
    private boolean mCompactEventHookInit;
    LayerManager mManager;
    private LayerNI mParent;
    private ObjectList<LayerNI> mChildren;
    private String mName;
    boolean mVisible;
    private int mOpacity = 255;
    private int mOrderIndex;
    private int mOverallOrderIndex;
    private boolean mAbsoluteOrderMode;
    private int mAbsoluteOrderIndex;
    private boolean mChildrenOrderIndexValid;
    private int mVisibleChildrenCount = -1;
    private Dispatch2 mChildrenArray;
    private Dispatch2 mArrayClearMethod;
    private boolean mChildrenArrayValid;
    private int mType = 2;
    private int mDisplayType = 2;
    private Rect mRect = new Rect();
    private boolean mExposedRegionValid;
    private ComplexRect mExposedRegion;
    private ComplexRect mOverlappedRegion;
    private BaseBitmap mMainImage;
    private boolean mCanHaveImage;
    private BaseBitmap mProvinceImage;
    private int mNeutralColor = 0xFFFFFF;
    private int mTransparentColor = 0xFFFFFF;
    private int mImageLeft;
    private int mImageTop;
    private int mHitType;
    private int mHitThreshold;
    private boolean mOnHitTest_Work;
    boolean mEnabled;
    private boolean mEnabledWork;
    private boolean mFocusable;
    private boolean mJoinFocusChain;
    private LayerNI mFocusWork;
    private int mAttentionLeft;
    private int mAttentionTop;
    private int mUseAttention;
    private int mImeMode;
    private int mCursor;
    private int mCursorX_Work;
    private String mHint;
    private boolean mShowParentHint;
    private BaseBitmap mCacheBitmap;
    private int mCacheEnabledCount;
    private boolean mCached;
    private int mDrawFace;
    private int mFace;
    private boolean mHoldAlpha;
    private boolean mImageModified;
    private Rect mClipRect;
    private Font mFont;
    private boolean mFontChanged;
    private Dispatch2 mFontObject;
    private int mUpdateOfsX;
    private int mUpdateOfsY;
    private Rect mUpdateRectForChild;
    private int mUpdateRectForChildOfsX;
    private int mUpdateRectForChildOfsY;
    private Drawable mCurrentDrawTarget;
    private BaseBitmap mUpdateBitmapForChild;
    private Rect mUpdateExcludeRect;
    private ComplexRect mCacheRecalcRegion;
    private ComplexRect mDrawnRegion;
    private boolean mDirectTransferToParent;
    private boolean mCallOnPaint;
    private boolean mInCompletion;
    private DivisibleTransHandler mDivisibleTransHandler;
    private GiveUpdateTransHandler mGiveUpdateTransHandler;
    private LayerNI mTransDest;
    private Dispatch2 mTransDestObj;
    private LayerNI mTransSrc;
    private Dispatch2 mTransSrcObj;
    private boolean mInTransition;
    private boolean mTransWithChildren;
    private boolean mTransSelfUpdate;
    private long mTransTick;
    private boolean mUseTransTickCallback;
    private VariantClosure mTransTickCallback;
    private int mTransType;
    private int mTransUpdateType;
    private ScanLineProviderForBaseBitmap mDestSLP;
    private ScanLineProviderForBaseBitmap mSrcSLP;
    private boolean mTransCompEventPrevented;
    TransDrawable mTransDrawable;
    TransIdleCallback mTransIdleCallback;
    private static final String ON_TRANSITION_SOMPLITE = "onTransitionCompleted";
    private static int internalComplete2direction;
    private static String ON_HIT_TEST;
    private static final String SELFUPDATE = "selfupdate";
    private static final String CALLBACK = "callback";
    private static final String ON_SEARCH_PREV_FOCUSABLE = "onSearchPrevFocusable";
    private static final String ON_CLICK = "onClick";
    private static final String ON_DOUBLE_CLICK = "onDoubleClick";
    private static final String ON_MOUSE_DOWN = "onMouseDown";
    private static final String ON_MOUSE_UP = "onMouseUp";
    private static final String ON_MOUSE_MOVE = "onMouseMove";
    private static final String ON_MOUSE_ENTER = "onMouseEnter";
    private static final String ON_MOUSE_LEAVE = "onMouseLeave";
    private static final String ON_KEY_DOWN = "onKeyDown";
    private static final String ON_KEY_UP = "onKeyUp";
    private static final String ON_KEY_PRESS = "onKeyPress";
    private static final String ON_MOUSE_WHEEL = "onMouseWheel";

    static {
        GraphicSplitOperationType = 0;
        internalComplete2direction = 0;
        ON_HIT_TEST = "onHitTest";
    }

    public static void initialize() {
        DefaultHoldAlpha = false;
    }

    public final Dispatch2 getOwner() {
        return (Dispatch2)this.mOwner.get();
    }

    public final void setOwner(Dispatch2 owner) {
        this.mOwner = new WeakReference<Dispatch2>(owner);
    }

    public final boolean getShutdown() {
        return this.mShutdown;
    }

    public final LayerManager getManager() {
        return this.mManager;
    }

    public final LayerNI getParent() {
        return this.mParent;
    }

    public final Rect getRect() {
        return this.mRect;
    }

    public final int getAttentionLeft() {
        return this.mAttentionLeft;
    }

    public final int getAttentionTop() {
        return this.mAttentionTop;
    }

    public final boolean getUseAttention() {
        return this.mUseAttention != 0;
    }

    public final int getImeMode() {
        return this.mImeMode;
    }

    public LayerNI() throws TJSException {
        this.mRect.right = 32;
        this.mRect.bottom = 32;
        this.mHitType = 0;
        this.mHitThreshold = 16;
        this.mShowParentHint = true;
        this.mEnabled = true;
        this.mJoinFocusChain = true;
        this.mCanHaveImage = true;
        this.mFace = 128;
        this.updateDrawFace();
        this.mHoldAlpha = DefaultHoldAlpha;
        this.mClipRect = new Rect();
        this.mTransTickCallback = new VariantClosure(null, null);
        this.mChildren = new ObjectList();
        this.mCacheRecalcRegion = new ComplexRect();
        this.mDrawnRegion = new ComplexRect();
        this.mUpdateRectForChild = new Rect();
        this.mUpdateExcludeRect = new Rect();
        this.mExposedRegion = new ComplexRect();
        this.mOverlappedRegion = new ComplexRect();
        this.allocateDefaultImage();
        this.mFont = this.mMainImage.getFont();
        this.mTransIdleCallback = new TransIdleCallback();
        this.mTransDrawable = new TransDrawable();
    }

    @Override
    public int construct(Variant[] param, Dispatch2 tjs_obj) throws TJSException {
        WindowNI win;
        if (param.length < 2) {
            return -1004;
        }
        this.mOwner = new WeakReference<Dispatch2>(tjs_obj);
        VariantClosure clo = param[0].asObjectClosure();
        if (clo.mObject == null) {
            Message.throwExceptionMessage("Window \u30af\u30e9\u30b9\u306e\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044");
        }
        if ((win = (WindowNI)clo.mObject.getNativeInstance(WindowClass.ClassID)) == null) {
            Message.throwExceptionMessage("Window \u30af\u30e9\u30b9\u306e\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044");
        }
        clo = param[1].asObjectClosure();
        LayerNI lay = null;
        if (clo.mObject != null && (lay = (LayerNI)clo.mObject.getNativeInstance(LayerClass.ClassID)) == null) {
            Message.throwExceptionMessage("Layer \u30af\u30e9\u30b9\u306e\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044");
        }
        if (lay != null) {
            this.mManager = lay.getManager();
        }
        if (lay != null) {
            this.join(lay);
        }
        if (lay == null) {
            this.mManager = new LayerManager(win);
            this.mManager.attachPrimary(this);
            this.mManager.registerSelfToWindow();
            this.mDisplayType = 1;
            this.mType = 1;
            this.mTransparentColor = -1;
            this.mNeutralColor = -1;
            this.updateDrawFace();
            this.mHitThreshold = 0;
        }
        this.mActionOwner.set(param[0].asObjectClosure());
        return 0;
    }

    @Override
    public void invalidate() throws TJSException {
        this.mShutdown = true;
        this.stopTransition();
        if (this.mTransDest != null) {
            this.mTransDest.stopTransition();
        }
        if (this.mDestSLP != null) {
            this.mDestSLP = null;
        }
        if (this.mSrcSLP != null) {
            this.mSrcSLP = null;
        }
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        TVP.EventManager.cancelSourceEvents(owner);
        if (this.isPrimary()) {
            if (this.mManager != null) {
                this.mManager.detachPrimary();
            }
            this.mManager.unregisterSelfFromWindow();
        }
        if (this.mManager != null) {
            this.mManager = null;
        }
        this.part();
        try {
            this.mChildren.safeLock();
            int count = this.mChildren.getSafeLockedObjectCount();
            int i = 0;
            while (i < count) {
                LayerNI child = this.mChildren.get(i);
                if (child != null) {
                    child.part();
                }
                ++i;
            }
            this.mChildrenArrayValid = false;
            this.mChildrenOrderIndexValid = false;
            if (this.mManager != null) {
                this.mManager.invalidateOverallIndex();
            }
        }
        finally {
            this.mChildren.safeUnlock();
        }
        if (this.mFontObject != null) {
            this.mFontObject.invalidate(0, null, this.mFontObject);
            this.mFontObject = null;
        }
        this.deallocateImage();
        this.deallocateCache();
        this.mActionOwner.mObject = null;
        this.mActionOwner.mObjThis = null;
        if (this.mChildrenArray != null) {
            this.mChildrenArray = null;
        }
        if (this.mArrayClearMethod != null) {
            this.mArrayClearMethod = null;
        }
        if (this.mCompactEventHookInit) {
            TVP.EventManager.removeCompactEventHook(this);
        }
        TVP.EventManager.cancelSourceEvents(owner);
    }

    private void join(LayerNI parent) throws TJSException {
        if (parent == this) {
            Message.throwExceptionMessage("\u81ea\u5206\u81ea\u8eab\u3092\u89aa\u3068\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        if (parent != null && parent.mManager != this.mManager) {
            Message.throwExceptionMessage("\u5225\u306e\u30d7\u30e9\u30a4\u30de\u30ea\u30ec\u30a4\u30e4\u4e0b\u306b\u30ec\u30a4\u30e4\u3092\u79fb\u52d5\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        if (this.mParent != null) {
            this.part();
        }
        this.mParent = parent;
        if (this.mParent != null) {
            parent.addChild(this);
        }
    }

    private void part() throws TJSException {
        this.update();
        if (this.mManager != null) {
            this.mManager.notifyPart(this);
        }
        if (this.mParent != null) {
            this.mParent.severChild(this);
            this.mParent = null;
        }
    }

    private void addChild(LayerNI child) {
        this.notifyChildrenVisualStateChanged();
        this.mChildren.add(child);
        if (this.mAbsoluteOrderMode) {
            this.mChildren.compact();
            int count = this.mChildren.getCount();
            if (count >= 2) {
                LayerNI last = this.mChildren.get(count - 2);
                child.mAbsoluteOrderIndex = last.getAbsoluteOrderIndex() + 1;
            }
        }
        this.mChildrenArrayValid = false;
        this.mChildrenOrderIndexValid = false;
        if (this.mManager != null) {
            this.mManager.checkTreeFocusableState(child);
        }
        if (this.mManager != null) {
            this.mManager.invalidateOverallIndex();
        }
    }

    private void severChild(LayerNI child) throws TJSException {
        if (this.mManager != null) {
            this.mManager.blurTree(child);
        }
        this.notifyChildrenVisualStateChanged();
        this.mChildren.remove(child);
        this.mChildrenArrayValid = false;
        this.mChildrenOrderIndexValid = false;
        if (this.mManager != null) {
            this.mManager.invalidateOverallIndex();
        }
    }

    private void updateDrawFace() {
        if (this.mFace == 128) {
            switch (this.mDisplayType) {
                case 1: {
                    this.mDrawFace = 1;
                    break;
                }
                case 2: {
                    this.mDrawFace = 0;
                    break;
                }
                case 3: {
                    this.mDrawFace = 1;
                    break;
                }
                case 4: {
                    this.mDrawFace = 1;
                    break;
                }
                case 5: {
                    this.mDrawFace = 1;
                    break;
                }
                case 8: {
                    this.mDrawFace = 1;
                    break;
                }
                case 9: {
                    this.mDrawFace = 1;
                    break;
                }
                case 10: {
                    this.mDrawFace = 1;
                    break;
                }
                case 11: {
                    this.mDrawFace = 1;
                    break;
                }
                case 12: {
                    this.mDrawFace = 4;
                    break;
                }
                case 13: {
                    this.mDrawFace = 0;
                    break;
                }
                case 14: {
                    this.mDrawFace = 0;
                    break;
                }
                case 15: {
                    this.mDrawFace = 0;
                    break;
                }
                case 16: {
                    this.mDrawFace = 0;
                    break;
                }
                case 17: {
                    this.mDrawFace = 0;
                    break;
                }
                case 18: {
                    this.mDrawFace = 0;
                    break;
                }
                case 19: {
                    this.mDrawFace = 0;
                    break;
                }
                case 20: {
                    this.mDrawFace = 0;
                    break;
                }
                case 21: {
                    this.mDrawFace = 0;
                    break;
                }
                case 22: {
                    this.mDrawFace = 0;
                    break;
                }
                case 23: {
                    this.mDrawFace = 0;
                    break;
                }
                case 24: {
                    this.mDrawFace = 0;
                    break;
                }
                case 25: {
                    this.mDrawFace = 0;
                    break;
                }
                case 26: {
                    this.mDrawFace = 0;
                    break;
                }
                case 27: {
                    this.mDrawFace = 0;
                    break;
                }
                case 28: {
                    this.mDrawFace = 0;
                    break;
                }
                default: {
                    this.mDrawFace = 1;
                    break;
                }
            }
        } else {
            this.mDrawFace = this.mFace;
        }
    }

    private void internalStopTransition() throws TJSException {
        if (this.mInTransition) {
            Dispatch2 owner;
            this.mInTransition = false;
            this.mTransCompEventPrevented = false;
            if (!this.mTransSelfUpdate) {
                TVP.EventManager.removeContinuousEventHook(this.mTransIdleCallback);
            }
            if (this.mTransWithChildren) {
                this.decCacheEnabledCount();
                if (this.mTransSrc != null) {
                    this.mTransSrc.decCacheEnabledCount();
                }
            }
            if (this.mTransType == 1) {
                int tl = this.mRect.left;
                int tt = this.mRect.top;
                int sl = this.mTransSrc.mRect.left;
                int st = this.mTransSrc.mRect.top;
                boolean tv = this.getVisible();
                boolean sv = this.mTransSrc.getVisible();
                if (this.mTransWithChildren) {
                    this.exchange(this.mTransSrc, false);
                } else {
                    this.swap(this.mTransSrc);
                }
                this.setPosition(sl, st);
                this.mTransSrc.setPosition(tl, tt);
                this.setVisible(sv);
                this.mTransSrc.setVisible(tv);
            }
            boolean transsrcalive = false;
            if (this.mTransSrc != null && !this.mTransSrc.mShutdown) {
                transsrcalive = true;
            }
            if (this.mTransSrc != null) {
                this.mTransSrc.mTransDest = null;
            }
            this.mTransSrc = null;
            if (this.mDivisibleTransHandler != null) {
                this.mDivisibleTransHandler = null;
            }
            if (this.mGiveUpdateTransHandler != null) {
                this.mGiveUpdateTransHandler = null;
            }
            if ((owner = (Dispatch2)this.mOwner.get()) != null && !this.mShutdown && transsrcalive) {
                Variant[] param = new Variant[]{new Variant(this.mTransDestObj, this.mTransDestObj), new Variant(this.mTransSrcObj, this.mTransSrcObj)};
                this.mTransDestObj = null;
                this.mTransSrcObj = null;
                TVP.EventManager.postEvent(owner, owner, ON_TRANSITION_SOMPLITE, 0, 2, param);
            }
            if (this.mTransDestObj != null) {
                this.mTransDestObj = null;
            }
            if (this.mTransSrcObj != null) {
                this.mTransSrcObj = null;
            }
            this.mTransTickCallback.set(null, null);
        }
    }

    private void swap(LayerNI target) throws TJSException {
        this.exchange(target, true);
    }

    private void exchange(LayerNI target, boolean keepchildren) throws TJSException {
        LayerNI target_joined_parent;
        LayerNI this_joined_parent;
        if (this == target) {
            return;
        }
        LayerNI this_ancestor_child = this.getAncestorChild(target);
        LayerNI target_ancestor_child = target.getAncestorChild(this);
        LayerNI this_parent = this.mParent;
        LayerNI target_parent = target.mParent;
        boolean this_primary = this.isPrimary();
        boolean target_primary = target.isPrimary();
        boolean this_parent_absolute = true;
        if (this.mParent != null) {
            this_parent_absolute = this.mParent.mAbsoluteOrderMode;
        }
        int this_index = this.getAbsoluteOrderIndex();
        boolean target_parent_absolute = true;
        if (target.mParent != null) {
            target_parent_absolute = target.mParent.mAbsoluteOrderMode;
        }
        int target_index = target.getAbsoluteOrderIndex();
        if (this.mManager != null) {
            if (this_primary) {
                this.mManager.detachPrimary();
            }
            if (target_primary) {
                this.mManager.detachPrimary();
            }
        }
        this.part();
        target.part();
        if (this_ancestor_child != null) {
            if (this_ancestor_child != this) {
                this_ancestor_child.part();
            }
            if (!keepchildren) {
                this_joined_parent = target_parent;
                this.join(this_joined_parent);
                if (target == this_parent) {
                    target_joined_parent = this;
                    target.join(target_joined_parent);
                } else {
                    target_joined_parent = this_parent;
                    target.join(target_joined_parent);
                }
            } else {
                IntVector this_orders = new IntVector();
                IntVector target_orders = new IntVector();
                ObjectList<LayerNI> this_children = new ObjectList<LayerNI>(this.mChildren);
                ObjectList<LayerNI> target_children = new ObjectList<LayerNI>(target.mChildren);
                int this_children_count = this_children.getActualCount();
                int target_children_count = target_children.getActualCount();
                int i = 0;
                while (i < this_children_count) {
                    this_orders.push_back(this_children.get(i).getAbsoluteOrderIndex());
                    this_children.get(i).part();
                    ++i;
                }
                i = 0;
                while (i < target_children_count) {
                    target_orders.push_back(target_children.get(i).getAbsoluteOrderIndex());
                    target_children.get(i).part();
                    ++i;
                }
                this_joined_parent = target_parent;
                this.join(this_joined_parent);
                if (target == this_parent) {
                    target_joined_parent = this;
                    target.join(target_joined_parent);
                } else {
                    target_joined_parent = this_parent;
                    target.join(target_joined_parent);
                }
                i = 0;
                while (i < this_children_count) {
                    this_children.get(i).join(target);
                    ++i;
                }
                i = 0;
                while (i < target_children_count) {
                    target_children.get(i).join(this);
                    ++i;
                }
                if (this.mAbsoluteOrderMode && target.mAbsoluteOrderMode) {
                    i = 0;
                    while (i < this_children_count) {
                        this_children.get(i).setAbsoluteOrderIndex(this_orders.get(i));
                        ++i;
                    }
                    i = 0;
                    while (i < target_children_count) {
                        target_children.get(i).setAbsoluteOrderIndex(target_orders.get(i));
                        ++i;
                    }
                }
            }
            if (this_ancestor_child != this) {
                this_ancestor_child.join(this);
            }
        } else if (target_ancestor_child != null) {
            if (target_ancestor_child != target) {
                target_ancestor_child.part();
            }
            if (!keepchildren) {
                if (this == target_parent) {
                    this_joined_parent = target;
                    this.join(this_joined_parent);
                } else {
                    this_joined_parent = target_parent;
                    this.join(this_joined_parent);
                }
                target_joined_parent = this_parent;
                target.join(target_joined_parent);
            } else {
                IntVector this_orders = new IntVector();
                IntVector target_orders = new IntVector();
                ObjectList<LayerNI> this_children = new ObjectList<LayerNI>(this.mChildren);
                ObjectList<LayerNI> target_children = new ObjectList<LayerNI>(target.mChildren);
                int this_children_count = this_children.getActualCount();
                int target_children_count = target_children.getActualCount();
                int i = 0;
                while (i < this_children_count) {
                    this_orders.push_back(this_children.get(i).getAbsoluteOrderIndex());
                    this_children.get(i).part();
                    ++i;
                }
                i = 0;
                while (i < target_children_count) {
                    target_orders.push_back(target_children.get(i).getAbsoluteOrderIndex());
                    target_children.get(i).part();
                    ++i;
                }
                if (this == target_parent) {
                    this_joined_parent = target;
                    this.join(this_joined_parent);
                } else {
                    this_joined_parent = target_parent;
                    this.join(this_joined_parent);
                }
                target_joined_parent = this_parent;
                target.join(target_joined_parent);
                i = 0;
                while (i < this_children_count) {
                    this_children.get(i).join(target);
                    ++i;
                }
                i = 0;
                while (i < target_children_count) {
                    target_children.get(i).join(this);
                    ++i;
                }
                if (this.mAbsoluteOrderMode && target.mAbsoluteOrderMode) {
                    i = 0;
                    while (i < this_children_count) {
                        this_children.get(i).setAbsoluteOrderIndex(this_orders.get(i));
                        ++i;
                    }
                    i = 0;
                    while (i < target_children_count) {
                        target_children.get(i).setAbsoluteOrderIndex(target_orders.get(i));
                        ++i;
                    }
                }
            }
            if (target_ancestor_child != target) {
                target_ancestor_child.join(target);
            }
        } else if (!keepchildren) {
            this_joined_parent = target_parent;
            this.join(this_joined_parent);
            target_joined_parent = this_parent;
            target.join(target_joined_parent);
        } else {
            IntVector this_orders = new IntVector();
            IntVector target_orders = new IntVector();
            ObjectList<LayerNI> this_children = new ObjectList<LayerNI>(this.mChildren);
            ObjectList<LayerNI> target_children = new ObjectList<LayerNI>(target.mChildren);
            int this_children_count = this_children.getActualCount();
            int target_children_count = target_children.getActualCount();
            int i = 0;
            while (i < this_children_count) {
                this_orders.push_back(this_children.get(i).getAbsoluteOrderIndex());
                this_children.get(i).part();
                ++i;
            }
            i = 0;
            while (i < target_children_count) {
                target_orders.push_back(target_children.get(i).getAbsoluteOrderIndex());
                target_children.get(i).part();
                ++i;
            }
            this_joined_parent = target_parent;
            this.join(this_joined_parent);
            target_joined_parent = this_parent;
            target.join(target_joined_parent);
            i = 0;
            while (i < this_children_count) {
                this_children.get(i).join(target);
                ++i;
            }
            i = 0;
            while (i < target_children_count) {
                target_children.get(i).join(this);
                ++i;
            }
            if (this.mAbsoluteOrderMode && target.mAbsoluteOrderMode) {
                i = 0;
                while (i < this_children_count) {
                    this_children.get(i).setAbsoluteOrderIndex(this_orders.get(i));
                    ++i;
                }
                i = 0;
                while (i < target_children_count) {
                    target_children.get(i).setAbsoluteOrderIndex(target_orders.get(i));
                    ++i;
                }
            }
        }
        if (this.mManager != null) {
            if (this_primary) {
                this.mManager.attachPrimary(target);
            }
            if (target_primary) {
                this.mManager.attachPrimary(this);
            }
        }
        if (target_joined_parent == this_joined_parent && target_joined_parent != null && target_joined_parent.mAbsoluteOrderMode == target_parent_absolute && this_joined_parent.mAbsoluteOrderMode == this_parent_absolute && target_parent_absolute == this_parent_absolute && !target_parent_absolute) {
            if (this_index < target_index) {
                target.setOrderIndex(this_index);
                this.setOrderIndex(target_index);
            } else {
                this.setOrderIndex(target_index);
                target.setOrderIndex(this_index);
            }
        } else {
            if (target_joined_parent != null && target_joined_parent.mAbsoluteOrderMode == target_parent_absolute) {
                if (target_parent_absolute) {
                    target.setAbsoluteOrderIndex(target_index);
                } else {
                    target.setOrderIndex(target_index);
                }
            }
            if (this_joined_parent != null && this_joined_parent.mAbsoluteOrderMode == this_parent_absolute) {
                if (this_parent_absolute) {
                    this.setAbsoluteOrderIndex(this_index);
                } else {
                    this.setOrderIndex(this_index);
                }
            }
        }
    }

    private LayerNI getAncestorChild(LayerNI ancestor) {
        LayerNI c = this;
        LayerNI p = this.mParent;
        while (p != null) {
            if (p == ancestor) {
                return c;
            }
            c = p;
            p = p.mParent;
        }
        return null;
    }

    public void stopTransition() throws TJSException {
        this.internalStopTransition();
    }

    public boolean isPrimary() {
        if (this.mManager == null) {
            return false;
        }
        return this.mManager.getPrimaryLayer() == this;
    }

    private void deallocateImage() {
        if (this.mMainImage != null) {
            this.mMainImage = null;
        }
        if (this.mProvinceImage != null) {
            this.mProvinceImage = null;
        }
        this.mImageModified = true;
    }

    private void allocateCache() throws TJSException {
        if (this.mCacheBitmap == null) {
            this.mCacheBitmap = new BaseBitmap(this.mRect.width(), this.mRect.height(), 32);
        } else {
            this.mCacheBitmap.setSize(this.mRect.width(), this.mRect.height());
        }
        this.mCacheRecalcRegion.or(new Rect(0, 0, this.mRect.width(), this.mRect.height()));
    }

    private void deallocateCache() {
        if (this.mCacheBitmap != null) {
            this.mCacheBitmap = null;
        }
    }

    private int incCacheEnabledCount() throws TJSException {
        ++this.mCacheEnabledCount;
        if (this.mCacheEnabledCount != 0) {
            this.registerCompactEventHook();
            this.allocateCache();
        }
        return this.mCacheEnabledCount;
    }

    private int decCacheEnabledCount() {
        --this.mCacheEnabledCount;
        if (this.mCacheEnabledCount == 0) {
            this.deallocateCache();
        }
        return this.mCacheEnabledCount;
    }

    void setCached(boolean b) throws TJSException {
        if (b != this.mCached) {
            this.mCached = b;
            if (b) {
                this.incCacheEnabledCount();
            } else {
                this.decCacheEnabledCount();
            }
        }
    }

    private void registerCompactEventHook() {
        if (!this.mCompactEventHookInit) {
            TVP.EventManager.addCompactEventHook(this);
            this.mCompactEventHookInit = true;
        }
    }

    private void updateTransDestinationOnSelfUpdate(ComplexRect region) {
        if (this.mTransDest != null && this.mTransDest.mInTransition && this.mTransDest.mTransSelfUpdate) {
            switch (this.mTransDest.mTransUpdateType) {
                case 0: {
                    ComplexRect cp = new ComplexRect(region);
                    try {
                        this.mTransDest.update(cp, true);
                        break;
                    }
                    finally {
                        cp.clear();
                        cp = null;
                    }
                }
                default: {
                    this.mTransDest.update(true);
                }
            }
        }
    }

    private void updateTransDestinationOnSelfUpdate(Rect rect) {
        if (this.mTransDest != null && this.mTransDest.mInTransition && this.mTransDest.mTransSelfUpdate) {
            switch (this.mTransDest.mTransUpdateType) {
                case 0: {
                    this.mTransDest.update(rect, true);
                    break;
                }
                default: {
                    this.mTransDest.update(true);
                }
            }
        }
    }

    private void updateChildRegion(LayerNI child, ComplexRect region, boolean tempupdate, boolean targvisible, boolean addtoprimary) {
        Rect cr = new Rect();
        cr.top = 0;
        cr.left = 0;
        cr.right = this.mRect.width();
        cr.bottom = this.mRect.height();
        ComplexRect converted = new ComplexRect();
        try {
            converted.copyWithOffsets(region, cr, child.mRect.left, child.mRect.top);
            if (!tempupdate && this.getCacheEnabled() && targvisible) {
                this.mCacheRecalcRegion.or(converted);
                if (this.mCacheRecalcRegion.getCount() > 60) {
                    this.mCacheRecalcRegion.unite();
                }
            }
            if (this.mParent != null) {
                this.mParent.updateChildRegion(this, converted, tempupdate, targvisible, addtoprimary);
            } else if (addtoprimary && this.mManager != null) {
                this.mManager.addUpdateRegion(converted);
            }
            this.updateTransDestinationOnSelfUpdate(converted);
        }
        finally {
            converted.clear();
            converted = null;
        }
    }

    private void internalUpdate(Rect rect, boolean tempupdate) {
        Rect cr = new Rect();
        cr.top = 0;
        cr.left = 0;
        cr.right = this.mRect.width();
        cr.bottom = this.mRect.height();
        if (!Rect.intersectRect(cr, cr, rect)) {
            return;
        }
        if (!tempupdate && this.getCacheEnabled()) {
            this.mCacheRecalcRegion.or(cr);
            if (this.mCacheRecalcRegion.getCount() > 60) {
                this.mCacheRecalcRegion.unite();
            }
        }
        if (this.mParent != null) {
            ComplexRect c = new ComplexRect();
            try {
                c.or(cr);
                this.mParent.updateChildRegion(this, c, tempupdate, this.getVisible(), this.getNodeVisible());
            }
            finally {
                c.clear();
                c = null;
            }
        } else if (this.mManager != null) {
            this.mManager.addUpdateRegion(cr);
        }
        this.updateTransDestinationOnSelfUpdate(cr);
    }

    public void update() {
        this.update(false);
    }

    public void update(boolean tempupdate) {
        Rect rect = new Rect();
        rect.top = 0;
        rect.left = 0;
        rect.right = this.mRect.width();
        rect.bottom = this.mRect.height();
        this.internalUpdate(rect, tempupdate);
    }

    private void update(ComplexRect rects) {
        this.update(rects, false);
    }

    private void update(ComplexRect rects, boolean tempupdate) {
        Rect cr = new Rect();
        cr.top = 0;
        cr.left = 0;
        cr.right = this.mRect.width();
        cr.bottom = this.mRect.height();
        rects.and(cr);
        if (rects.getCount() == 0) {
            return;
        }
        if (!tempupdate && this.getCacheEnabled()) {
            this.mCacheRecalcRegion.or(rects);
            if (this.mCacheRecalcRegion.getCount() > 60) {
                this.mCacheRecalcRegion.unite();
            }
        }
        if (this.mParent != null) {
            this.mParent.updateChildRegion(this, rects, tempupdate, this.getVisible(), this.getNodeVisible());
        } else if (this.mManager != null) {
            this.mManager.addUpdateRegion(rects);
        }
        this.updateTransDestinationOnSelfUpdate(rects);
    }

    private void update(Rect rect, boolean tempupdate) {
        Rect cr = new Rect();
        cr.top = 0;
        cr.left = 0;
        cr.right = this.mRect.width();
        cr.bottom = this.mRect.height();
        if (!Rect.intersectRect(cr, cr, rect)) {
            return;
        }
        this.internalUpdate(cr, tempupdate);
    }

    private void notifyChildrenVisualStateChanged() {
        this.mVisibleChildrenCount = -1;
        this.setToCreateExposedRegion();
        if (this.mManager != null) {
            this.mManager.notifyVisualStateChanged();
        }
    }

    private void childChangeOrder(int from, int to) {
        if (from == to) {
            return;
        }
        ComplexRect rects = new ComplexRect();
        try {
            this.mChildren.compact();
            Rect r = new Rect();
            if (from < to) {
                LayerNI fromlay = this.mChildren.get(from);
                int i = from;
                while (i < to) {
                    this.mChildren.set(i, this.mChildren.get(i + 1));
                    r.set(fromlay.mRect);
                    if (Rect.intersectRect(r, r, this.mChildren.get((int)i).mRect)) {
                        rects.or(r);
                    }
                    ++i;
                }
                this.mChildren.set(to, fromlay);
            } else {
                LayerNI fromlay = this.mChildren.get(from);
                int i = from;
                while (i > to) {
                    this.mChildren.set(i, this.mChildren.get(i - 1));
                    r.set(fromlay.mRect);
                    if (Rect.intersectRect(r, r, this.mChildren.get((int)i).mRect)) {
                        rects.or(r);
                    }
                    --i;
                }
                this.mChildren.set(to, fromlay);
            }
            this.update(rects);
        }
        finally {
            rects.clear();
            rects = null;
        }
        this.mChildrenArrayValid = false;
        this.mChildrenOrderIndexValid = false;
        if (this.mManager != null) {
            this.mManager.invalidateOverallIndex();
        }
    }

    private void childChangeAbsoluteOrder(int from, int abs_to) {
        int to = 0;
        int count = this.mChildren.getCount();
        int i = 0;
        while (i < count) {
            LayerNI child = this.mChildren.get(i);
            if (child != null) {
                if (child.mAbsoluteOrderIndex >= abs_to) break;
                ++to;
            }
            ++i;
        }
        if (from < to) {
            --to;
        }
        this.childChangeOrder(from, to);
    }

    public int getAbsoluteOrderIndex() {
        if (this.mParent == null) {
            return 0;
        }
        if (this.mParent.mAbsoluteOrderMode) {
            return this.mAbsoluteOrderIndex;
        }
        return this.getOrderIndex();
    }

    public void setAbsoluteOrderIndex(int index) throws TJSException {
        if (this.mParent == null) {
            Message.throwExceptionMessage("\u30d7\u30e9\u30a4\u30de\u30ea\u30ec\u30a4\u30e4\u3084\u5144\u5f1f\u306e\u7121\u3044\u30ec\u30a4\u30e4\u306f\u524d\u5f8c\u306b\u79fb\u52d5\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        this.mParent.setAbsoluteOrderMode(true);
        this.mParent.childChangeAbsoluteOrder(this.getOrderIndex(), index);
        this.mAbsoluteOrderIndex = index;
    }

    public void setAbsoluteOrderMode(boolean b) {
        if (this.mAbsoluteOrderMode != b) {
            this.mAbsoluteOrderMode = b;
            if (b) {
                int count = this.mChildren.getCount();
                int i = 0;
                while (i < count) {
                    LayerNI child = this.mChildren.get(i);
                    if (child != null) {
                        child.mAbsoluteOrderIndex = child.getOrderIndex();
                    }
                    ++i;
                }
            }
        }
    }

    public int getOrderIndex() {
        if (this.mParent == null) {
            return 0;
        }
        if (this.mParent.mChildrenOrderIndexValid) {
            return this.mOrderIndex;
        }
        this.mParent.recreateOrderIndex();
        return this.mOrderIndex;
    }

    private void setToCreateExposedRegion() {
        this.mExposedRegionValid = false;
    }

    private void recreateOrderIndex() {
        int index = 0;
        int count = this.mChildren.getCount();
        int i = 0;
        while (i < count) {
            LayerNI child = this.mChildren.get(i);
            if (child != null) {
                child.mOrderIndex = index++;
            }
            ++i;
        }
        this.mChildrenOrderIndexValid = true;
    }

    public boolean isAncestor(LayerNI ancestor) {
        LayerNI p = this.mParent;
        while (p != null) {
            if (p == ancestor) {
                return true;
            }
            p = p.mParent;
        }
        return false;
    }

    public boolean isAncestorOrSelf(LayerNI ancestor) {
        return ancestor == this || this.isAncestor(ancestor);
    }

    private int getOverallOrderIndex() {
        if (this.mManager == null) {
            return 0;
        }
        this.mManager.recreateOverallOrderIndex();
        return this.mOverallOrderIndex;
    }

    private LayerNI getNeighborBelow(boolean loop) {
        if (this.mManager == null) {
            return null;
        }
        int index = this.getOverallOrderIndex();
        ArrayList<LayerNI> allnodes = this.mManager.getAllNodes();
        int count = allnodes.size();
        if (count == 0) {
            return null;
        }
        if (index == count - 1) {
            if (loop) {
                return allnodes.get(0);
            }
            return null;
        }
        return allnodes.get(index + 1);
    }

    private LayerNI getNextFocusableInternal() {
        LayerNI p = this;
        LayerNI current = this;
        if (current == (p = p.getNeighborBelow(true))) {
            return null;
        }
        if (p == null) {
            return null;
        }
        current = p;
        do {
            if (!p.getNodeFocusable() || !p.mJoinFocusChain) continue;
            return p;
        } while ((p = p.getNeighborBelow(true)) != null && p != current);
        return null;
    }

    public LayerNI getNextFocusable() {
        this.mFocusWork = this.getNextFocusableInternal();
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (!(owner == null || this.mShutdown || this.mFocusWork != null && this.mFocusWork.mOwner == null)) {
            String eventname = "onSearchNextFocusable";
            Variant[] param = new Variant[]{this.mFocusWork != null ? new Variant((Dispatch2)this.mFocusWork.mOwner.get(), (Dispatch2)this.mFocusWork.mOwner.get()) : new Variant(null, null)};
            TVP.EventManager.postEvent(owner, owner, "onSearchNextFocusable", 0, 2, param);
        }
        return this.mFocusWork;
    }

    public void saveEnabledWork() {
        this.mEnabledWork = this.getNodeEnabled();
        int count = this.mChildren.getCount();
        int i = 0;
        while (i < count) {
            LayerNI child = this.mChildren.get(i);
            if (child != null) {
                child.saveEnabledWork();
            }
            ++i;
        }
    }

    public boolean isDisabledByMode() {
        if (this.mManager == null) {
            return false;
        }
        LayerNI current = this.mManager.getCurrentModalLayer();
        if (current == null) {
            return false;
        }
        return !this.isAncestorOrSelf(current);
    }

    public boolean parentEnabled() {
        LayerNI par = this.mParent;
        while (par != null) {
            if (!par.mEnabled) {
                return false;
            }
            par = par.mParent;
        }
        return true;
    }

    public boolean getEnabled() {
        return this.mEnabled;
    }

    public boolean getNodeEnabled() {
        return this.getEnabled() && this.parentEnabled() && !this.isDisabledByMode();
    }

    public void notifyNodeEnabledState() {
        boolean en = this.getNodeEnabled();
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner != null && !this.mShutdown && this.mEnabledWork != en) {
            String eventname;
            if (en) {
                eventname = "onNodeEnabled";
                TVP.EventManager.postEvent(owner, owner, "onNodeEnabled", 0, 2, TJS.NULL_ARG);
            } else {
                eventname = "onNodeDisabled";
                TVP.EventManager.postEvent(owner, owner, "onNodeDisabled", 0, 2, TJS.NULL_ARG);
            }
        }
        try {
            this.mChildren.safeLock();
            int count = this.mChildren.getSafeLockedObjectCount();
            int i = 0;
            while (i < count) {
                LayerNI child = this.mChildren.get(i);
                if (child != null) {
                    child.notifyNodeEnabledState();
                }
                ++i;
            }
            this.mChildrenArrayValid = false;
            this.mChildrenOrderIndexValid = false;
            if (this.mManager != null) {
                this.mManager.invalidateOverallIndex();
            }
        }
        finally {
            this.mChildren.safeUnlock();
        }
    }

    private void allocateDefaultImage() throws TJSException {
        if (this.mMainImage == null) {
            this.mMainImage = new BaseBitmap(TempBitmapHolder.get());
        } else {
            this.mMainImage.assign(TempBitmapHolder.get());
        }
        this.mFontChanged = true;
        this.resetClip();
        this.mImageModified = true;
    }

    public BaseBitmap getMainImage() {
        this.applyFont();
        return this.mMainImage;
    }

    void resetClip() throws TJSException {
        if (this.mMainImage == null) {
            Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        this.mClipRect.top = 0;
        this.mClipRect.left = 0;
        this.mClipRect.right = this.mMainImage.getWidth();
        this.mClipRect.bottom = this.mMainImage.getHeight();
    }

    private void applyFont() {
        if (this.mFontChanged && this.mMainImage != null) {
            this.mFontChanged = false;
            this.mMainImage.setFont(this.mFont);
        }
    }

    public void setFontFace(String face) {
        if (!this.mFont.getFaceName().equals(face)) {
            this.mFont.setFaceName(face);
            this.mFontChanged = true;
        }
    }

    public String getFontFace() {
        return this.mFont.getFaceName();
    }

    public void setFontHeight(int height) {
        if (height < 0) {
            height = -height;
        }
        if (this.mFont.getHeight() != height) {
            this.mFont.setHeight(height);
            this.mFontChanged = true;
        }
    }

    public int getFontHeight() {
        return this.mFont.getHeight();
    }

    public void setFontAngle(int angle) {
        if (this.mFont.getAngle() != angle) {
            if ((angle %= 3600) < 0) {
                angle += 3600;
            }
            this.mFont.setAngle(angle);
            this.mFontChanged = true;
        }
    }

    public int getFontAngle() {
        return this.mFont.getAngle();
    }

    public void setFontBold(boolean b) {
        if (this.mFont.getBold() != b) {
            this.mFont.setBold(b);
            this.mFontChanged = true;
        }
    }

    public boolean getFontBold() {
        return this.mFont.getBold();
    }

    public void setFontItalic(boolean b) {
        if (this.mFont.getItalic() != b) {
            this.mFont.setItalic(b);
            this.mFontChanged = true;
        }
    }

    public boolean getFontItalic() {
        return this.mFont.getItalic();
    }

    public void setFontStrikeout(boolean b) {
        if (this.mFont.getStrikeout() != b) {
            this.mFont.setStrikeout(b);
            this.mFontChanged = true;
        }
    }

    public boolean getFontStrikeout() {
        return this.mFont.getStrikeout();
    }

    public void setFontUnderline(boolean b) {
        if (this.mFont.getUnderline() != b) {
            this.mFont.setUnderline(b);
            this.mFontChanged = true;
        }
    }

    public boolean getFontUnderline() {
        return this.mFont.getUnderline();
    }

    public void setVisible(boolean st) throws TJSException {
        if (this.mVisible != st) {
            if (this.isPrimary() && !st) {
                Message.throwExceptionMessage("\u30d7\u30e9\u30a4\u30de\u30ea\u30ec\u30a4\u30e4\u306f\u4e0d\u53ef\u8996\u306b\u3067\u304d\u307e\u305b\u3093");
            }
            if (!st) {
                this.update();
            }
            this.mVisible = st;
            if (st) {
                this.update();
            }
            if (this.mParent != null) {
                this.mParent.notifyChildrenVisualStateChanged();
            }
            if (this.mVisible) {
                if (this.mManager != null) {
                    this.mManager.checkTreeFocusableState(this);
                }
            } else {
                if (this.mManager != null) {
                    this.mManager.blurTree(this);
                }
                if (PurgeOnHide) {
                    this.purgeImage();
                }
            }
        }
    }

    public void setOpacity(int opa) throws TJSException {
        if (this.mOpacity != opa) {
            if (this.isPrimary() && opa != 255) {
                Message.throwExceptionMessage("\u30d7\u30e9\u30a4\u30de\u30ea\u30ec\u30a4\u30e4\u306f\u4e0d\u53ef\u8996\u306b\u3067\u304d\u307e\u305b\u3093");
            }
            this.mOpacity = opa;
            if (this.mParent != null) {
                this.mParent.notifyChildrenVisualStateChanged();
            }
            this.update();
        }
    }

    public final int getLeft() {
        return this.mRect.left;
    }

    public final int getTop() {
        return this.mRect.top;
    }

    public final int getWidth() {
        return this.mRect.width();
    }

    public final int getHeight() {
        return this.mRect.height();
    }

    public void recreateOverallOrderIndex(int[] index, ArrayList<LayerNI> nodes) {
        this.mOverallOrderIndex = index[0];
        index[0] = index[0] + 1;
        nodes.add(this);
        int count = this.mChildren.getCount();
        int i = 0;
        while (i < count) {
            LayerNI child = this.mChildren.get(i);
            if (child != null) {
                child.recreateOverallOrderIndex(index, nodes);
            }
            ++i;
        }
    }

    public void queryUpdateExcludeRect(Rect rect, boolean parentvisible) {
        rect.left -= this.mRect.left;
        rect.right -= this.mRect.left;
        rect.top -= this.mRect.top;
        rect.bottom -= this.mRect.top;
        parentvisible = parentvisible && this.mVisible && (this.mDisplayType == 1 || this.mDisplayType == 2 || this.mDisplayType == 12 || this.mDisplayType == 13) && this.mOpacity == 255;
        int count = this.mChildren.getCount();
        int i = count - 1;
        while (i >= 0) {
            LayerNI child = this.mChildren.get(i);
            if (child != null) {
                child.queryUpdateExcludeRect(rect, parentvisible);
            }
            --i;
        }
        if (parentvisible) {
            this.mUpdateExcludeRect.set(rect);
        } else {
            this.mUpdateExcludeRect.clear();
        }
        rect.left += this.mRect.left;
        rect.right += this.mRect.left;
        rect.top += this.mRect.top;
        rect.bottom += this.mRect.top;
        if (parentvisible && this.mDisplayType == 1 && this.mOpacity == 255) {
            if (rect.isEmpty()) {
                rect.set(this.mRect);
            } else if (!Rect.intersectRect(rect, rect, this.mRect)) {
                rect.clear();
            }
        }
    }

    public boolean parentFocusable() {
        LayerNI par = this.mParent;
        while (par != null) {
            if (!par.mVisible || !par.mEnabled) {
                return false;
            }
            par = par.mParent;
        }
        return true;
    }

    public boolean getNodeFocusable() {
        return this.checkFocusable() && this.parentFocusable() && !this.isDisabledByMode();
    }

    public boolean checkFocusable() {
        return this.mFocusable && this.mVisible && this.mEnabled;
    }

    public LayerNI fireBeforeFocus(LayerNI prevfocused, boolean direction) {
        this.mFocusWork = this;
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner != null && !this.mShutdown) {
            String eventname = "onBeforeFocus";
            Variant[] param = new Variant[]{new Variant(owner, owner), prevfocused != null ? new Variant((Dispatch2)prevfocused.mOwner.get(), (Dispatch2)prevfocused.mOwner.get()) : new Variant(null, null), new Variant(direction ? 1 : 0)};
            TVP.EventManager.postEvent(owner, owner, "onBeforeFocus", 0, 2, param);
        }
        return this.mFocusWork;
    }

    public void fireBlur(LayerNI prevfocused) {
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner != null && !this.mShutdown) {
            String eventname = "onBlur";
            Variant[] param = new Variant[]{prevfocused != null ? new Variant((Dispatch2)prevfocused.mOwner.get(), (Dispatch2)prevfocused.mOwner.get()) : new Variant(null, null)};
            TVP.EventManager.postEvent(owner, owner, "onBlur", 0, 2, param);
        }
    }

    public void fireFocus(LayerNI prevfocused, boolean direction) {
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner != null && !this.mShutdown) {
            String eventname = "onFocus";
            Variant[] param = new Variant[]{prevfocused != null ? new Variant((Dispatch2)prevfocused.mOwner.get(), (Dispatch2)prevfocused.mOwner.get()) : new Variant(null, null), new Variant(direction ? 1 : 0)};
            TVP.EventManager.postEvent(owner, owner, "onFocus", 0, 2, param);
        }
    }

    public void toPrimaryCoordinates(Point pt) {
        LayerNI l = this;
        while (l != null && !l.isPrimary()) {
            pt.x += l.mRect.left;
            pt.y += l.mRect.top;
            l = l.mParent;
        }
    }

    public void completeForWindow(Drawable drawable) throws VariantException, TJSException {
        this.beforeCompletion();
        if (this.mManager != null) {
            this.mManager.notifyUpdateRegionFixed();
        }
        this.mInCompletion = true;
        if (this.mManager != null) {
            this.mManager.getWindow().startBitmapCompletion(this.mManager);
        }
        try {
            this.internalComplete2(this.mManager.getUpdateRegionForCompletion(), drawable);
        }
        finally {
            if (this.mManager != null) {
                this.mManager.getWindow().endBitmapCompletion(this.mManager);
            }
        }
        this.mInCompletion = false;
        this.afterCompletion();
    }

    private void beforeCompletion() throws VariantException, TJSException {
        if (this.mInCompletion) {
            return;
        }
        if (this.mCallOnPaint) {
            this.mCallOnPaint = false;
            String eventname = "onPaint";
            Dispatch2 owner = (Dispatch2)this.mOwner.get();
            TVP.EventManager.postEvent(owner, owner, "onPaint", 0, 2, TJS.NULL_ARG);
        }
        if (this.mInTransition && this.mDivisibleTransHandler != null) {
            int er;
            if (this.mTransSelfUpdate) {
                this.mTransTick = this.getTransTick();
            }
            if ((er = this.mDivisibleTransHandler.startProcess(this.mTransTick)) != 1) {
                this.stopTransitionByHandler();
            }
        }
        if (this.mInTransition && this.mTransWithChildren && this.mTransUpdateType == 1) {
            this.mInTransition = false;
            this.mTransDrawable.Src1Bmp = this.complete();
            this.mInTransition = true;
            if (this.mTransSrc != null) {
                this.mTransDrawable.Src2Bmp = this.mTransSrc.complete();
            }
        }
        try {
            this.mChildren.safeLock();
            int count = this.mChildren.getSafeLockedObjectCount();
            int i = 0;
            while (i < count) {
                LayerNI child = this.mChildren.get(i);
                if (child != null) {
                    child.beforeCompletion();
                }
                ++i;
            }
            this.mChildrenArrayValid = false;
            this.mChildrenOrderIndexValid = false;
            if (this.mManager != null) {
                this.mManager.invalidateOverallIndex();
            }
        }
        finally {
            this.mChildren.safeUnlock();
        }
    }

    private long getTransTick() throws VariantException, TJSException {
        if (!this.mUseTransTickCallback) {
            return TVP.getTickCount();
        }
        Variant res = new Variant();
        this.mTransTickCallback.funcCall(0, null, res, null, null);
        return res.asInteger();
    }

    private void afterCompletion() throws TJSException {
        int er;
        if (this.mInCompletion) {
            return;
        }
        if (this.mInTransition && this.mDivisibleTransHandler != null && (er = this.mDivisibleTransHandler.endProcess()) != 1) {
            this.stopTransitionByHandler();
        }
        try {
            this.mChildren.safeLock();
            int count = this.mChildren.getSafeLockedObjectCount();
            int i = 0;
            while (i < count) {
                LayerNI child = this.mChildren.get(i);
                if (child != null) {
                    child.afterCompletion();
                }
                ++i;
            }
            this.mChildrenArrayValid = false;
            this.mChildrenOrderIndexValid = false;
            if (this.mManager != null) {
                this.mManager.invalidateOverallIndex();
            }
        }
        finally {
            this.mChildren.safeUnlock();
        }
    }

    private void stopTransitionByHandler() throws TJSException {
        if (!TVP.EventManager.isEventDisabled()) {
            this.internalStopTransition();
        } else {
            this.mTransCompEventPrevented = true;
        }
    }

    @Override
    public void onCompact(int level) throws TJSScriptException, TJSScriptError, TJSException {
        if (level >= 10) {
            this.compactCache();
        }
    }

    private void compactCache() {
        if (this.mCacheEnabledCount == 0) {
            this.deallocateCache();
        }
    }

    void setWidth(int width) throws TJSException {
        if (this.mRect.width() != width) {
            this.update(false);
            this.mRect.setWidth(width);
            if (this.mParent != null) {
                this.mParent.notifyChildrenVisualStateChanged();
            }
            this.setToCreateExposedRegion();
            this.imageLayerSizeChanged();
            this.update(false);
            if (this.isPrimary() && this.mManager != null) {
                this.mManager.notifyLayerResize();
            }
        }
    }

    void setHeight(int height) throws TJSException {
        if (this.mRect.height() != height) {
            this.update(false);
            this.mRect.setHeight(height);
            if (this.mParent != null) {
                this.mParent.notifyChildrenVisualStateChanged();
            }
            this.setToCreateExposedRegion();
            this.imageLayerSizeChanged();
            this.update(false);
            if (this.isPrimary() && this.mManager != null) {
                this.mManager.notifyLayerResize();
            }
        }
    }

    public void setSize(int width, int height) throws TJSException {
        this.internalSetSize(width, height);
    }

    void internalSetSize(int width, int height) throws TJSException {
        if (this.mRect.width() != width || this.mRect.height() != height) {
            this.update(false);
            this.mRect.setWidth(width);
            this.mRect.setHeight(height);
            if (this.mParent != null) {
                this.mParent.notifyChildrenVisualStateChanged();
            }
            this.setToCreateExposedRegion();
            this.imageLayerSizeChanged();
            this.update(false);
            if (this.isPrimary() && this.mManager != null) {
                this.mManager.notifyLayerResize();
            }
        }
    }

    private void imageLayerSizeChanged() throws TJSException {
        if (this.mMainImage == null) {
            return;
        }
        if (this.mMainImage.getWidth() < this.mRect.width()) {
            this.changeImageSize(this.mRect.width(), this.mMainImage.getHeight());
        }
        if (this.mMainImage.getWidth() + this.mImageLeft < this.mRect.width()) {
            this.mImageLeft = this.mRect.width() - this.mMainImage.getWidth();
            this.update();
        }
        if (this.mMainImage.getHeight() < this.mRect.height()) {
            this.changeImageSize(this.mMainImage.getWidth(), this.mRect.height());
        }
        if (this.mMainImage.getHeight() + this.mImageTop < this.mRect.height()) {
            this.mImageTop = this.mRect.height() - this.mMainImage.getHeight();
            this.update();
        }
    }

    private void changeImageSize(int width, int height) throws TJSException {
        if (width == 0 || height == 0) {
            Message.throwExceptionMessage("\u753b\u50cf\u30b5\u30a4\u30ba\u306e\u6a2a\u5e45\u3042\u308b\u3044\u306f\u7e26\u5e45\u3092 0 \u4ee5\u4e0b\u306e\u6570\u306b\u8a2d\u5b9a\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        if (this.mMainImage != null) {
            this.mMainImage.setSizeWithFill(width, height, this.mNeutralColor);
        }
        if (this.mProvinceImage != null) {
            this.mProvinceImage.setSizeWithFill(width, height, 0);
        }
        if (this.mMainImage != null) {
            this.resetClip();
        }
        this.mImageModified = true;
        this.resizeCache();
    }

    private void resizeCache() throws TJSException {
        if (this.mCacheBitmap != null && this.mMainImage != null) {
            this.mCacheBitmap.setSize(this.mMainImage.getWidth(), this.mMainImage.getHeight());
        }
        this.mCacheRecalcRegion.or(new Rect(0, 0, this.mRect.width(), this.mRect.height()));
    }

    private void internalSetImageSize(int width, int height) throws TJSException {
        if (width < this.mRect.width()) {
            this.mImageLeft = 0;
            this.setWidth(width);
        }
        if (width + this.mImageLeft < this.mRect.width()) {
            this.mImageLeft = this.mRect.width() - width;
        }
        if (height < this.mRect.height()) {
            this.mImageTop = 0;
            this.setHeight(height);
        }
        if (height + this.mImageTop < this.mRect.height()) {
            this.mImageTop = this.mRect.height() - height;
        }
        this.changeImageSize(width, height);
    }

    private void allocateProvinceImage() throws TJSException {
        int newh;
        int neww = this.mMainImage != null ? this.mMainImage.getWidth() : this.mRect.width();
        int n = newh = this.mMainImage != null ? this.mMainImage.getHeight() : this.mRect.height();
        if (this.mProvinceImage == null) {
            this.mProvinceImage = new BaseBitmap(neww, newh, 8);
            this.mProvinceImage.fill(new Rect(0, 0, neww, newh), 0);
        } else {
            this.mProvinceImage.setSizeWithFill(neww, newh, 0);
        }
        this.mImageModified = true;
    }

    private void deallocateProvinceImage() {
        if (this.mProvinceImage != null) {
            this.mProvinceImage = null;
        }
        this.mImageModified = true;
    }

    /*
     * Unable to fully structure code
     */
    public Dispatch2 loadImages(String name, int colorkey) throws TJSException {
        if (this.mMainImage == null) {
            Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        this.purgeImage();
        provincename = new String[1];
        holder = new Holder<Object>(null);
        GraphicsLoader.loadGraphic(this.mMainImage, name, colorkey, 0, 0, 0, provincename, holder);
        metainfo = (Dispatch2)holder.mValue;
        this.internalSetImageSize(this.mMainImage.getWidth(), this.mMainImage.getHeight());
        if (provincename[0] != null && provincename[0].length() != 0) {
            this.allocateProvinceImage();
            try {
                GraphicsLoader.loadGraphic(this.mProvinceImage, provincename[0], 0, this.mMainImage.getWidth(), this.mMainImage.getHeight(), 1, null, null);
                if (this.mProvinceImage.getWidth() == this.mMainImage.getWidth() && this.mProvinceImage.getHeight() == this.mMainImage.getHeight()) ** GOTO lbl20
                Message.throwExceptionMessage("\u9818\u57df\u753b\u50cf %1 \u306f\u30e1\u30a4\u30f3\u753b\u50cf\u3068\u30b5\u30a4\u30ba\u304c\u9055\u3044\u307e\u3059", provincename[0]);
            }
            catch (Exception e) {
                this.deallocateProvinceImage();
                throw new TJSException(e.getMessage());
            }
        } else {
            this.deallocateProvinceImage();
        }
lbl20:
        // 3 sources

        this.mImageModified = true;
        this.resetClip();
        this.update(false);
        return metainfo;
    }

    public boolean getCacheEnabled() {
        return this.mCacheEnabledCount != 0;
    }

    private int getVisibleChildrenCount() {
        if (this.mVisibleChildrenCount == -1) {
            this.checkChildrenVisibleState();
        }
        return this.mVisibleChildrenCount;
    }

    public int getCount() {
        return this.mChildren.getActualCount();
    }

    public boolean getVisible() {
        return this.mVisible;
    }

    public int getOpacity() {
        return this.mOpacity;
    }

    private void checkChildrenVisibleState() {
        if (this.getCount() == 0) {
            this.mVisibleChildrenCount = 0;
            return;
        }
        this.mVisibleChildrenCount = 0;
        int count = this.mChildren.getCount();
        int i = 0;
        while (i < count) {
            LayerNI child = this.mChildren.get(i);
            if (child != null && child.getVisible() && child.getOpacity() != 0) {
                ++this.mVisibleChildrenCount;
            }
            ++i;
        }
    }

    private void internalComplete2(ComplexRect updateregion, Drawable drawable) throws VariantException, TJSException {
        if (this.mManager != null) {
            this.mManager.queryUpdateExcludeRect();
        }
        ComplexRect.Iterator it = updateregion.getIterator();
        while (it.step()) {
            Rect r = new Rect(it.get());
            r.addOffsets(this.mRect.left, this.mRect.top);
            if (GraphicSplitOperationType != 0) {
                int y;
                int rw;
                int oh = this.getVisibleChildrenCount() != 0 || this.mInTransition ? ((rw = r.width()) < 40 ? 128 : (rw < 80 ? 64 : (rw < 160 ? 32 : (rw < 320 ? 16 : 8)))) : r.height();
                Rect or = new Rect();
                or.left = r.left;
                or.right = r.right;
                if (GraphicSplitOperationType == 2) {
                    y = r.top;
                    while (y < r.bottom) {
                        or.top = y;
                        or.bottom = y + oh < r.bottom ? y + oh : r.bottom;
                        this.draw(drawable, or, false);
                        y += oh * 2;
                    }
                    y = r.top + oh;
                    while (y < r.bottom) {
                        or.top = y;
                        or.bottom = y + oh < r.bottom ? y + oh : r.bottom;
                        this.draw(drawable, or, false);
                        y += oh * 2;
                    }
                    continue;
                }
                if (GraphicSplitOperationType == 1) {
                    y = r.top;
                    while (y < r.bottom) {
                        or.top = y;
                        or.bottom = y + oh < r.bottom ? y + oh : r.bottom;
                        this.draw(drawable, or, false);
                        y += oh;
                    }
                    continue;
                }
                if (GraphicSplitOperationType != 3) continue;
                if ((internalComplete2direction & 1) != 0) {
                    y = r.top;
                    while (y < r.bottom) {
                        or.top = y;
                        or.bottom = y + oh < r.bottom ? y + oh : r.bottom;
                        this.draw(drawable, or, false);
                        y += oh;
                    }
                } else {
                    y = r.bottom - oh;
                    if (y < r.top) {
                        y = r.top;
                    }
                    while (true) {
                        or.top = y < r.top ? r.top : y;
                        int n = or.bottom = y + oh < r.bottom ? y + oh : r.bottom;
                        if (or.bottom <= r.top) break;
                        this.draw(drawable, or, false);
                        y -= oh;
                    }
                }
                ++internalComplete2direction;
                continue;
            }
            this.draw(drawable, r, false);
        }
        updateregion.clear();
    }

    private void internalComplete(ComplexRect updateregion, Drawable drawable) throws VariantException, TJSException {
        this.beforeCompletion();
        this.mInCompletion = true;
        this.internalComplete2(updateregion, drawable);
        this.mInCompletion = false;
        this.afterCompletion();
    }

    private BaseBitmap complete(Rect rect) throws VariantException, TJSException {
        if (!this.getCacheEnabled()) {
            return null;
        }
        if (this.getVisibleChildrenCount() == 0 && this.mImageLeft == 0 && this.mImageTop == 0 && this.mMainImage.getWidth() == this.getWidth() && this.mMainImage.getHeight() == this.getHeight()) {
            return this.mMainImage;
        }
        if (this.mCacheRecalcRegion.getCount() == 0) {
            return this.mCacheBitmap;
        }
        CompleteDrawable drawable = new CompleteDrawable(this.mCacheBitmap, this.mDisplayType);
        ComplexRect ur = new ComplexRect();
        try {
            ur.or(rect);
            this.internalComplete(ur, drawable);
        }
        finally {
            drawable = null;
            ur.clear();
            ur = null;
        }
        return this.mCacheBitmap;
    }

    BaseBitmap complete() throws VariantException, TJSException {
        Rect r = new Rect();
        r.left = 0;
        r.top = 0;
        r.right = this.mRect.width();
        r.bottom = this.mRect.height();
        return this.complete(r);
    }

    public boolean isSeen() {
        return this.mVisible && this.mOpacity != 0;
    }

    private void parentRectToChildRect(Rect rect) {
        rect.left -= this.mRect.left;
        rect.right -= this.mRect.left;
        rect.top -= this.mRect.top;
        rect.bottom -= this.mRect.top;
    }

    private void drawSelf(Drawable target, Rect pr, Rect cr) throws VariantException, TJSException {
        if (this.mMainImage == null) {
            if (this.mDisplayType == 1) {
                BaseBitmap temp = TempBitmapHolder.getTemp(cr.width(), cr.height());
                try {
                    Rect bitmaprect = new Rect(cr);
                    bitmaprect.setOffsets(0, 0);
                    this.copySelf(temp, 0, 0, bitmaprect);
                    target.drawCompleted(pr, temp, bitmaprect, this.mDisplayType, this.mOpacity);
                }
                finally {
                    TempBitmapHolder.freeTemp();
                }
            }
            return;
        }
        cr.addOffsets(-this.mImageLeft, -this.mImageTop);
        if (this.mInTransition && !this.mTransWithChildren && this.mDivisibleTransHandler != null) {
            BaseBitmap temp = TempBitmapHolder.getTemp(cr.width(), cr.height());
            try {
                Rect bitmaprect = new Rect(cr);
                bitmaprect.setOffsets(0, 0);
                this.doDivisibleTransition(temp, 0, 0, cr);
                target.drawCompleted(pr, temp, bitmaprect, this.mDisplayType, this.mOpacity);
            }
            finally {
                TempBitmapHolder.freeTemp();
            }
        } else {
            target.drawCompleted(pr, this.mMainImage, cr, this.mDisplayType, this.mOpacity);
        }
    }

    private void copySelfForRect(BaseBitmap dest, int destx, int desty, Rect srcrect) throws TJSException {
        Rect cr = new Rect(srcrect);
        cr.addOffsets(-this.mImageLeft, -this.mImageTop);
        if (this.mInTransition && !this.mTransWithChildren && this.mDivisibleTransHandler != null) {
            this.doDivisibleTransition(dest, destx, desty, cr);
        } else if (this.mMainImage != null) {
            dest.copyRect(destx, desty, this.mMainImage, cr);
        } else {
            dest.fill(new Rect(destx, desty, destx + cr.width(), desty + cr.height()), this.mDisplayType == 1 ? this.mNeutralColor : this.mTransparentColor);
        }
    }

    private void copySelf(BaseBitmap dest, int destx, int desty, Rect r) throws TJSException {
        Rect uer = this.mUpdateExcludeRect;
        if (uer.isEmpty()) {
            this.copySelfForRect(dest, destx, desty, r);
        } else if (uer.top <= r.top && uer.bottom >= r.bottom) {
            if (uer.left > r.left && uer.right < r.right) {
                Rect r2 = new Rect(r);
                r2.right = uer.left;
                this.copySelfForRect(dest, destx, desty, r2);
                r2.right = r.right;
                r2.left = uer.right;
                this.copySelfForRect(dest, destx + (r2.left - r.left), desty, r2);
            } else if (r.left < uer.left || r.right > uer.right) {
                if (r.right <= uer.left || r.left >= uer.right) {
                    this.copySelfForRect(dest, destx, desty, r);
                } else if (r.right > uer.left && r.right <= uer.right) {
                    Rect r2 = new Rect(r);
                    r2.right = uer.left;
                    this.copySelfForRect(dest, destx, desty, r2);
                } else if (r.left >= uer.left && r.left < uer.left) {
                    Rect r2 = new Rect(r);
                    r2.left = uer.right;
                    this.copySelfForRect(dest, destx + (r2.left - r.left), desty, r2);
                } else {
                    this.copySelfForRect(dest, destx, desty, r);
                }
            }
        } else {
            this.copySelfForRect(dest, destx, desty, r);
        }
    }

    private void doDivisibleTransition(BaseBitmap dest, int dx, int dy, Rect srcrect) throws TJSException {
        if (!this.mInTransition || this.mDivisibleTransHandler == null) {
            return;
        }
        DivisibleData data = new DivisibleData();
        data.Left = srcrect.left;
        data.Top = srcrect.top;
        data.Width = srcrect.width();
        data.Height = srcrect.height();
        if (this.mSrcSLP == null) {
            this.mSrcSLP = new ScanLineProviderForBaseBitmap(this.mMainImage);
        } else {
            this.mSrcSLP.attach(this.mMainImage);
        }
        data.Src1 = this.mSrcSLP;
        data.Src1Left = srcrect.left;
        data.Src1Top = srcrect.top;
        this.mImageModified = true;
        if (this.mTransSrc != null) {
            if (this.mTransSrc.mSrcSLP == null) {
                this.mTransSrc.mSrcSLP = new ScanLineProviderForBaseBitmap(this.mTransSrc.mMainImage);
            } else {
                this.mTransSrc.mSrcSLP.attach(this.mTransSrc.mMainImage);
            }
            data.Src2 = this.mTransSrc.mSrcSLP;
            data.Src2Left = srcrect.left;
            data.Src2Top = srcrect.top;
        }
        if (this.mDestSLP == null) {
            this.mDestSLP = new ScanLineProviderForBaseBitmap(dest);
        } else {
            this.mDestSLP.attach(dest);
        }
        data.Dest = this.mDestSLP;
        data.DestLeft = dx;
        data.DestTop = dy;
        this.mDivisibleTransHandler.process(data);
        if (data.Dest == data.Src1) {
            dest.copyRect(dx, dy, this.mMainImage, srcrect);
        } else if (data.Dest == data.Src2) {
            dest.copyRect(dx, dy, this.mTransSrc.mMainImage, srcrect);
        }
    }

    private void createExposedRegion() {
        this.mExposedRegion.clear();
        this.mOverlappedRegion.clear();
        Rect rect = new Rect();
        rect.top = 0;
        rect.left = 0;
        rect.right = this.mRect.width();
        rect.bottom = this.mRect.height();
        if (this.mMainImage != null) {
            if (this.getVisibleChildrenCount() > 30) {
                this.mExposedRegion.or(rect);
                boolean first = true;
                Rect r2 = new Rect();
                int count = this.mChildren.getCount();
                int i = 0;
                while (i < count) {
                    Rect r;
                    LayerNI child = this.mChildren.get(i);
                    if (child != null && child.isSeen() && Rect.intersectRect(r = new Rect(child.getRect()), r, rect)) {
                        if (first) {
                            r2.set(child.getRect());
                            first = false;
                        } else {
                            Rect.unionRect(r2, r2, r);
                        }
                    }
                    ++i;
                }
                this.mOverlappedRegion.or(r2);
                this.mExposedRegion.sub(this.mOverlappedRegion);
            } else {
                Rect rect1 = new Rect();
                rect1.top = 0;
                rect1.left = 0;
                rect1.right = this.mRect.width();
                rect1.bottom = this.mRect.height();
                this.mExposedRegion.or(rect1);
                int count = this.mChildren.getCount();
                int i = 0;
                while (i < count) {
                    Rect r;
                    LayerNI child = this.mChildren.get(i);
                    if (child != null && child.isSeen() && Rect.intersectRect(r = new Rect(child.getRect()), r, rect1)) {
                        this.mOverlappedRegion.or(r);
                    }
                    ++i;
                }
                this.mExposedRegion.sub(this.mOverlappedRegion);
            }
        } else {
            this.mExposedRegion.clear();
            this.mOverlappedRegion.clear();
            this.mOverlappedRegion.or(rect);
            if (this.getVisibleChildrenCount() < 10) {
                ComplexRect one = this.mExposedRegion;
                ComplexRect two = new ComplexRect();
                try {
                    int count = this.mChildren.getCount();
                    int i = 0;
                    while (i < count) {
                        LayerNI child = this.mChildren.get(i);
                        if (child != null && child.isSeen()) {
                            Rect r = new Rect(child.getRect());
                            if (child.mDisplayType == this.mDisplayType && child.mOpacity == 255) {
                                ComplexRect one_and_r = new ComplexRect(one);
                                one_and_r.and(r);
                                ComplexRect two_and_r = new ComplexRect(two);
                                two_and_r.and(r);
                                one.sub(one_and_r);
                                two.or(one_and_r);
                                two.or(two_and_r);
                                ComplexRect tmp = new ComplexRect();
                                tmp.or(r);
                                tmp.sub(one_and_r);
                                tmp.sub(two_and_r);
                                one.or(tmp);
                                one_and_r.clear();
                                two_and_r.clear();
                                tmp.clear();
                            } else {
                                two.or(r);
                                one.sub(r);
                            }
                        }
                        ++i;
                    }
                }
                finally {
                    two.clear();
                    Object var3_7 = null;
                }
            }
            this.mOverlappedRegion.sub(this.mExposedRegion);
        }
        this.mExposedRegionValid = true;
    }

    private final ComplexRect getExposedRegion() {
        if (!this.mExposedRegionValid) {
            this.createExposedRegion();
        }
        return this.mExposedRegion;
    }

    private final ComplexRect getOverlappedRegion() {
        if (!this.mExposedRegionValid) {
            this.createExposedRegion();
        }
        return this.mOverlappedRegion;
    }

    private void draw(Drawable target, Rect r) throws VariantException, TJSException {
        this.draw(target, r, true);
    }

    private void draw(Drawable target, Rect r, boolean visiblecheck) throws VariantException, TJSException {
        boolean totalopaque;
        if (visiblecheck && !this.isSeen()) {
            return;
        }
        Rect rect = new Rect(r);
        if (!Rect.intersectRect(rect, rect, this.mRect)) {
            return;
        }
        this.mCurrentDrawTarget = target;
        this.parentRectToChildRect(rect);
        if (this.mInTransition && this.mTransWithChildren) {
            this.mTransDrawable.init(this, target);
            target = this.mTransDrawable;
        }
        this.mDirectTransferToParent = false;
        boolean bl = totalopaque = this.mDisplayType == 1 && this.mOpacity == 255;
        if (this.getCacheEnabled() && (!this.mInTransition || this.mTransWithChildren || this.mDivisibleTransHandler == null)) {
            ComplexRect.Iterator it = this.mCacheRecalcRegion.getIterator();
            while (it.step()) {
                Rect cr = new Rect(it.get());
                if (!Rect.intersectRect(cr, cr, rect)) continue;
                this.mDrawnRegion.clear();
                this.mUpdateBitmapForChild = this.mCacheBitmap;
                if (this.mMainImage != null) {
                    this.copySelf(this.mUpdateBitmapForChild, cr.left, cr.top, cr);
                }
                try {
                    this.mChildren.safeLock();
                    int count = this.mChildren.getSafeLockedObjectCount();
                    int i = 0;
                    while (i < count) {
                        LayerNI child = this.mChildren.get(i);
                        if (child != null && Rect.intersectRect(this.mUpdateRectForChild, cr, child.mRect)) {
                            this.mUpdateOfsX = 0;
                            this.mUpdateOfsY = 0;
                            this.mUpdateRectForChildOfsX = this.mUpdateRectForChild.left - child.mRect.left;
                            this.mUpdateRectForChildOfsY = this.mUpdateRectForChild.top - child.mRect.top;
                            child.draw(this, this.mUpdateRectForChild, true);
                        }
                        ++i;
                    }
                    this.mChildrenArrayValid = false;
                    this.mChildrenOrderIndexValid = false;
                    if (this.mManager != null) {
                        this.mManager.invalidateOverallIndex();
                    }
                }
                finally {
                    this.mChildren.safeUnlock();
                }
                if (this.mMainImage != null) continue;
                ComplexRect nr = new ComplexRect();
                nr.or(cr);
                nr.sub(this.mDrawnRegion);
                ComplexRect.Iterator it1 = nr.getIterator();
                while (it1.step()) {
                    Rect r1 = new Rect(it1.get());
                    this.copySelf(this.mUpdateBitmapForChild, r1.left, r1.top, r1);
                }
                nr.clear();
            }
            this.mCacheRecalcRegion.sub(rect);
            if (this.mCacheRecalcRegion.getCount() > 60) {
                this.mCacheRecalcRegion.unite();
            }
            Rect pr = new Rect(rect);
            pr.addOffsets(this.mRect.left, this.mRect.top);
            target.drawCompleted(pr, this.mCacheBitmap, rect, this.mDisplayType, this.mOpacity);
        } else if (this.getVisibleChildrenCount() == 0) {
            Rect pr = new Rect(rect);
            pr.addOffsets(this.mRect.left, this.mRect.top);
            Rect cr = new Rect(rect);
            this.drawSelf(target, pr, cr);
        } else {
            Rect cr;
            ComplexRect overlapped = this.getOverlappedRegion();
            ComplexRect exposed = this.getExposedRegion();
            this.mDrawnRegion.clear();
            ComplexRect.Iterator it = overlapped.getIterator();
            while (it.step()) {
                cr = new Rect(it.get());
                if (!Rect.intersectRect(cr, cr, rect)) continue;
                Rect updaterectforchild = new Rect();
                boolean tempalloc = false;
                if (totalopaque) {
                    this.mUpdateBitmapForChild = target.getDrawTargetBitmap(cr, updaterectforchild);
                } else {
                    this.mUpdateBitmapForChild = TempBitmapHolder.getTemp(cr.width(), cr.height());
                    tempalloc = true;
                    updaterectforchild.left = 0;
                    updaterectforchild.top = 0;
                    updaterectforchild.right = cr.width();
                    updaterectforchild.bottom = cr.height();
                }
                try {
                    this.copySelf(this.mUpdateBitmapForChild, updaterectforchild.left, updaterectforchild.top, cr);
                    try {
                        this.mChildren.safeLock();
                        int lcount = this.mChildren.getSafeLockedObjectCount();
                        int i = 0;
                        while (i < lcount) {
                            Rect chrect;
                            LayerNI child = this.mChildren.get(i);
                            if (child != null && child.mVisible && Rect.intersectRect(chrect = new Rect(), cr, child.mRect)) {
                                int ox = chrect.left - cr.left;
                                int oy = chrect.top - cr.top;
                                this.mUpdateRectForChild.set(updaterectforchild);
                                this.mUpdateRectForChild.addOffsets(ox, oy);
                                this.mUpdateRectForChildOfsX = chrect.left - child.mRect.left;
                                this.mUpdateRectForChildOfsY = chrect.top - child.mRect.top;
                                this.mUpdateOfsX = cr.left - updaterectforchild.left;
                                this.mUpdateOfsY = cr.top - updaterectforchild.top;
                                child.draw(this, chrect, true);
                            }
                            ++i;
                        }
                        this.mChildrenArrayValid = false;
                        this.mChildrenOrderIndexValid = false;
                        if (this.mManager != null) {
                            this.mManager.invalidateOverallIndex();
                        }
                    }
                    finally {
                        this.mChildren.safeUnlock();
                    }
                }
                catch (TJSException e) {
                    if (tempalloc) {
                        TempBitmapHolder.freeTemp();
                    }
                    throw e;
                }
                if (this.mDisplayType != 0) {
                    Rect pr = new Rect(cr);
                    pr.addOffsets(this.mRect.left, this.mRect.top);
                    target.drawCompleted(pr, this.mUpdateBitmapForChild, updaterectforchild, this.mDisplayType, this.mOpacity);
                }
                if (!tempalloc) continue;
                TempBitmapHolder.freeTemp();
            }
            this.mDirectTransferToParent = true;
            it = exposed.getIterator();
            while (it.step()) {
                cr = new Rect(it.get());
                if (!Rect.intersectRect(cr, cr, rect)) continue;
                if (this.mMainImage != null) {
                    Rect pr = new Rect(cr);
                    pr.addOffsets(this.mRect.left, this.mRect.top);
                    this.drawSelf(target, pr, cr);
                    continue;
                }
                Rect cr1 = new Rect(it.get());
                if (!Rect.intersectRect(cr1, cr1, rect)) continue;
                try {
                    this.mChildren.safeLock();
                    int llcount = this.mChildren.getSafeLockedObjectCount();
                    int i = 0;
                    while (i < llcount) {
                        Rect chrect;
                        LayerNI child = this.mChildren.get(i);
                        if (child != null && child.mVisible && Rect.intersectRect(chrect = new Rect(), cr1, child.mRect)) {
                            child.draw(this, chrect, true);
                        }
                        ++i;
                    }
                    this.mChildrenArrayValid = false;
                    this.mChildrenOrderIndexValid = false;
                    if (this.mManager == null) continue;
                    this.mManager.invalidateOverallIndex();
                }
                finally {
                    this.mChildren.safeUnlock();
                }
            }
            this.mDirectTransferToParent = false;
        }
        this.mCurrentDrawTarget = null;
    }

    private void updateAllChildren(boolean tempupdate) {
        try {
            this.mChildren.safeLock();
            int count = this.mChildren.getSafeLockedObjectCount();
            int i = 0;
            while (i < count) {
                LayerNI child = this.mChildren.get(i);
                if (child != null) {
                    child.update(tempupdate);
                }
                ++i;
            }
            this.mChildrenArrayValid = false;
            this.mChildrenOrderIndexValid = false;
            if (this.mManager != null) {
                this.mManager.invalidateOverallIndex();
            }
        }
        finally {
            this.mChildren.safeUnlock();
        }
    }

    public boolean getParentVisible() {
        LayerNI par = this.mParent;
        while (par != null) {
            if (!par.mVisible) {
                return false;
            }
            par = par.mParent;
        }
        return true;
    }

    public boolean getNodeVisible() {
        return this.getParentVisible() && this.mVisible;
    }

    private void invokeTransition(long tick) throws VariantException, TJSException {
        if (!this.mTransCompEventPrevented) {
            this.mTransTick = this.mUseTransTickCallback ? this.getTransTick() : tick;
            if (!this.getNodeVisible()) {
                this.stopTransitionByHandler();
            } else if (this.mMainImage == null && this.mTransWithChildren && this.mTransUpdateType == 0 && this.mDisplayType != 1) {
                this.updateAllChildren(true);
                if (this.mTransSrc != null) {
                    this.mTransSrc.updateAllChildren(true);
                }
            } else {
                this.update(true);
            }
        } else if (!TVP.EventManager.isEventDisabled()) {
            this.internalStopTransition();
        }
    }

    @Override
    public BaseBitmap getDrawTargetBitmap(Rect rect, Rect cliprect) throws TJSException {
        if (this.mDisplayType == 0 || this.mMainImage == null && this.mDirectTransferToParent) {
            Rect _rect = new Rect(rect);
            _rect.addOffsets(this.mRect.left, this.mRect.top);
            BaseBitmap bmp = this.mCurrentDrawTarget.getDrawTargetBitmap(_rect, cliprect);
            return bmp;
        }
        int w = rect.width();
        int h = rect.height();
        if (this.mUpdateRectForChild.width() < w || this.mUpdateRectForChild.height() < h) {
            Message.throwExceptionMessage("\u5185\u90e8\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f: at %1 line %2");
        }
        cliprect.set(this.mUpdateRectForChild);
        cliprect.addOffsets(rect.left - this.mUpdateRectForChildOfsX, rect.top - this.mUpdateRectForChildOfsY);
        return this.mUpdateBitmapForChild;
    }

    @Override
    public int getTargetLayerType() {
        if (this.mDisplayType == 0) {
            return this.mParent != null ? this.mParent.mDisplayType : 1;
        }
        return this.mDisplayType;
    }

    @Override
    public void drawCompleted(Rect destrect, BaseBitmap bmp, Rect cliprect, int type, int opacity) throws VariantException, TJSException {
        if (this.mDisplayType == 0 || this.mMainImage == null && this.mDirectTransferToParent) {
            Rect _destrect = new Rect(destrect);
            Rect _cliprect = new Rect(cliprect);
            _destrect.addOffsets(this.mRect.left, this.mRect.top);
            this.mCurrentDrawTarget.drawCompleted(_destrect, bmp, _cliprect, type, opacity);
            return;
        }
        if (bmp != this.mUpdateBitmapForChild) {
            if (this.mMainImage == null) {
                ComplexRect.Iterator it;
                Rect r = new Rect();
                Rect sr = new Rect();
                ComplexRect nr = new ComplexRect();
                nr.or(destrect);
                nr.sub(this.mDrawnRegion);
                ComplexRect or = new ComplexRect();
                if (this.mDisplayType == type && opacity == 255) {
                    it = nr.getIterator();
                    while (it.step()) {
                        r.set(it.get());
                        sr.left = cliprect.left + (r.left - destrect.left);
                        sr.top = cliprect.top + (r.top - destrect.top);
                        sr.right = sr.left + r.width();
                        sr.bottom = sr.top + r.height();
                        this.mUpdateBitmapForChild.copyRect(r.left - this.mUpdateOfsX, r.top - this.mUpdateOfsY, bmp, sr);
                    }
                    or.or(destrect);
                    or.sub(nr);
                } else {
                    it = nr.getIterator();
                    while (it.step()) {
                        r.set(it.get());
                        r.addOffsets(-this.mUpdateOfsX, -this.mUpdateOfsY);
                        this.copySelf(this.mUpdateBitmapForChild, r.left, r.top, r);
                    }
                    or.or(destrect);
                }
                it = or.getIterator();
                while (it.step()) {
                    r.set(it.get());
                    sr.left = cliprect.left + (r.left - destrect.left);
                    sr.top = cliprect.top + (r.top - destrect.top);
                    sr.right = sr.left + r.width();
                    sr.bottom = sr.top + r.height();
                    LayerNI.bltImage(this.mUpdateBitmapForChild, this.mDisplayType, r.left - this.mUpdateOfsX, r.top - this.mUpdateOfsY, bmp, sr, type, opacity);
                }
                this.mDrawnRegion.or(destrect);
                nr.clear();
                or.clear();
            } else {
                LayerNI.bltImage(this.mUpdateBitmapForChild, this.mDisplayType, destrect.left - this.mUpdateOfsX, destrect.top - this.mUpdateOfsY, bmp, cliprect, type, opacity);
            }
        }
    }

    private static void bltImage(BaseBitmap dest, int destlayertype, int destx, int desty, BaseBitmap src, Rect srcrect, int drawtype, int opacity) throws TJSException {
        int met;
        boolean hda = false;
        switch (drawtype) {
            case 0: {
                return;
            }
            case 1: {
                if (LayerType.isTypeUsingAlpha(destlayertype)) {
                    met = 1;
                    break;
                }
                if (LayerType.isTypeUsingAddAlpha(destlayertype)) {
                    met = 15;
                    break;
                }
                met = 0;
                break;
            }
            case 2: {
                if (LayerType.isTypeUsingAlpha(destlayertype)) {
                    met = 3;
                    break;
                }
                if (LayerType.isTypeUsingAddAlpha(destlayertype)) {
                    met = 14;
                    break;
                }
                met = 2;
                break;
            }
            case 3: {
                hda = LayerType.isTypeUsingAlphaChannel(destlayertype);
                met = 4;
                break;
            }
            case 4: {
                hda = LayerType.isTypeUsingAlphaChannel(destlayertype);
                met = 5;
                break;
            }
            case 5: {
                hda = LayerType.isTypeUsingAlphaChannel(destlayertype);
                met = 6;
                break;
            }
            case 8: {
                hda = LayerType.isTypeUsingAlphaChannel(destlayertype);
                met = 7;
                break;
            }
            case 9: {
                hda = LayerType.isTypeUsingAlphaChannel(destlayertype);
                met = 8;
                break;
            }
            case 10: {
                hda = LayerType.isTypeUsingAlphaChannel(destlayertype);
                met = 9;
                break;
            }
            case 11: {
                hda = LayerType.isTypeUsingAlphaChannel(destlayertype);
                met = 10;
                break;
            }
            case 12: {
                if (LayerType.isTypeUsingAlpha(destlayertype)) {
                    met = 13;
                    break;
                }
                if (LayerType.isTypeUsingAddAlpha(destlayertype)) {
                    met = 12;
                    break;
                }
                met = 11;
                break;
            }
            case 13: {
                hda = LayerType.isTypeUsingAlphaChannel(destlayertype);
                met = 16;
                break;
            }
            case 14: {
                hda = LayerType.isTypeUsingAlphaChannel(destlayertype);
                met = 17;
                break;
            }
            case 15: {
                hda = LayerType.isTypeUsingAlphaChannel(destlayertype);
                met = 18;
                break;
            }
            case 16: {
                hda = LayerType.isTypeUsingAlphaChannel(destlayertype);
                met = 19;
                break;
            }
            case 17: {
                hda = LayerType.isTypeUsingAlphaChannel(destlayertype);
                met = 20;
                break;
            }
            case 18: {
                hda = LayerType.isTypeUsingAlphaChannel(destlayertype);
                met = 21;
                break;
            }
            case 19: {
                hda = LayerType.isTypeUsingAlphaChannel(destlayertype);
                met = 22;
                break;
            }
            case 20: {
                hda = LayerType.isTypeUsingAlphaChannel(destlayertype);
                met = 23;
                break;
            }
            case 21: {
                hda = LayerType.isTypeUsingAlphaChannel(destlayertype);
                met = 24;
                break;
            }
            case 22: {
                hda = LayerType.isTypeUsingAlphaChannel(destlayertype);
                met = 25;
                break;
            }
            case 23: {
                hda = LayerType.isTypeUsingAlphaChannel(destlayertype);
                met = 26;
                break;
            }
            case 24: {
                hda = LayerType.isTypeUsingAlphaChannel(destlayertype);
                met = 27;
                break;
            }
            case 25: {
                hda = LayerType.isTypeUsingAlphaChannel(destlayertype);
                met = 28;
                break;
            }
            case 26: {
                hda = LayerType.isTypeUsingAlphaChannel(destlayertype);
                met = 29;
                break;
            }
            case 27: {
                hda = LayerType.isTypeUsingAlphaChannel(destlayertype);
                met = 30;
                break;
            }
            case 28: {
                hda = LayerType.isTypeUsingAlphaChannel(destlayertype);
                met = 31;
                break;
            }
            default: {
                return;
            }
        }
        dest.blt(destx, desty, src, srcrect, met, opacity, hda);
    }

    public void setImageWidth(int width) throws TJSException {
        if (this.mMainImage == null) {
            Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        if (width == this.mMainImage.getWidth()) {
            return;
        }
        if (width < this.mRect.width()) {
            this.mImageLeft = 0;
            this.setWidth(width);
        }
        if (width + this.mImageLeft < this.mRect.width()) {
            this.mImageLeft = this.mRect.width() - width;
        }
        this.changeImageSize(width, this.mMainImage.getHeight());
    }

    public int getImageWidth() throws TJSException {
        if (this.mMainImage == null) {
            Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        return this.mMainImage.getWidth();
    }

    public void setImageHeight(int height) throws TJSException {
        if (this.mMainImage == null) {
            Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        if (height == this.mMainImage.getHeight()) {
            return;
        }
        if (height < this.mRect.height()) {
            this.mImageTop = 0;
            this.setHeight(height);
        }
        if (height + this.mImageTop < this.mRect.height()) {
            this.mImageTop = this.mRect.height() - height;
        }
        this.changeImageSize(this.mMainImage.getWidth(), height);
    }

    public int getImageHeight() throws TJSException {
        if (this.mMainImage == null) {
            Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        return this.mMainImage.getHeight();
    }

    public void update(Rect rect) {
        this.update(rect, false);
    }

    public void updateByScript(Rect rect) {
        this.mCallOnPaint = true;
        this.update(rect);
    }

    public void updateByScript() {
        this.mCallOnPaint = true;
        this.update();
    }

    private void parentUpdate() {
        if (this.mParent != null) {
            Rect rect = new Rect();
            rect.top = 0;
            rect.left = 0;
            rect.right = this.mRect.width();
            rect.bottom = this.mRect.height();
            ComplexRect c = new ComplexRect();
            c.or(rect);
            this.mParent.updateChildRegion(this, c, false, this.getVisible(), this.getNodeVisible());
            c.clear();
        }
    }

    private void internalSetBounds(Rect rect) throws TJSException {
        int width = rect.right - rect.left;
        int height = rect.bottom - rect.top;
        if (width < 0 || height < 0) {
            Message.throwExceptionMessage("\u4e0d\u6b63\u306a\u30d1\u30e9\u30e1\u30fc\u30bf\u3067\u3059");
        }
        if (this.mRect.left != rect.left || this.mRect.top != rect.top) {
            boolean visible;
            boolean bl = visible = this.getVisible() || this.getNodeVisible();
            if (this.isPrimary() && (rect.left != 0 || rect.top != 0)) {
                Message.throwExceptionMessage("\u30d7\u30e9\u30a4\u30de\u30ea\u30ec\u30a4\u30e4\u306f\u79fb\u52d5\u3067\u304d\u307e\u305b\u3093");
            }
            if (visible) {
                this.parentUpdate();
            }
            this.mRect.setOffsets(rect.left, rect.top);
            if (this.mParent != null) {
                this.mParent.notifyChildrenVisualStateChanged();
            }
            this.setToCreateExposedRegion();
            if (visible) {
                this.parentUpdate();
            }
        }
        this.internalSetSize(width, height);
    }

    public void setBounds(Rect rect) throws TJSException {
        this.internalSetBounds(rect);
    }

    public void setPosition(int left, int top) throws TJSException {
        if (this.mRect.left != left || this.mRect.top != top) {
            boolean visible;
            boolean bl = visible = this.getVisible() || this.getNodeVisible();
            if (this.isPrimary() && (left != 0 || top != 0)) {
                Message.throwExceptionMessage("\u30d7\u30e9\u30a4\u30de\u30ea\u30ec\u30a4\u30e4\u306f\u79fb\u52d5\u3067\u304d\u307e\u305b\u3093");
            }
            if (visible) {
                this.parentUpdate();
            }
            this.mRect.setOffsets(left, top);
            if (this.mParent != null) {
                this.mParent.notifyChildrenVisualStateChanged();
            }
            if (visible) {
                this.parentUpdate();
            }
        }
    }

    public void drawText(int x, int y, String text, int color, int opa, boolean aa, int shadowlevel, int shadowcolor, int shadowwidth, int shadowofsx, int shadowofsy) throws TJSException {
        if (this.mMainImage == null) {
            Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        int met = 0;
        switch (this.mDrawFace) {
            case 0: {
                met = 3;
                break;
            }
            case 4: {
                if (opa < 0) {
                    Message.throwExceptionMessage("\u8ca0\u306e\u4e0d\u900f\u660e\u5ea6\u306f\u3053\u306e face \u3067\u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093");
                }
                met = 14;
                break;
            }
            case 1: {
                met = 2;
                break;
            }
            default: {
                Message.throwExceptionMessage("%1 \u3067\u306f\u3053\u306e face \u306b\u63cf\u753b\u3067\u304d\u307e\u305b\u3093", "drawText");
            }
        }
        this.applyFont();
        ComplexRect r = new ComplexRect();
        color = LayerNI.toActualColor(color);
        this.mMainImage.drawText(this.mClipRect, x, y, text, color, met, opa, this.mHoldAlpha, aa, shadowlevel, shadowcolor, shadowwidth, shadowofsx, shadowofsy, r);
        if (r.getCount() != 0) {
            this.mImageModified = true;
        }
        if (this.mImageLeft != 0 || this.mImageTop != 0) {
            r.addOffsets(this.mImageLeft, this.mImageTop);
        }
        this.update(r);
        r.clear();
    }

    public static final int toActualColor(int color) {
        if ((color & 0xFF000000) != 0) {
            return SystemColor.colorToRGB(color);
        }
        return color;
    }

    public static final int fromActualColor(int color) {
        return color &= 0xFFFFFF;
    }

    public Dispatch2 getFontObject() throws TJSException {
        if (this.mFontObject != null) {
            return this.mFontObject;
        }
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner == null) {
            Message.throwExceptionMessage("Panic! Layer object is not properly constructed. The constructor was not called??");
        }
        this.mFontObject = TVP.createFontObject(owner);
        return this.mFontObject;
    }

    public void setImageSize(int width, int height) throws TJSException {
        if (this.mMainImage == null) {
            Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        if (width == this.mMainImage.getWidth() && height == this.mMainImage.getHeight()) {
            return;
        }
        this.internalSetImageSize(width, height);
    }

    public void fillRect(Rect rect, int color) throws TJSException {
        Rect destrect = new Rect();
        if (!Rect.intersectRect(destrect, rect, this.mClipRect)) {
            return;
        }
        if (this.mDrawFace == 0 || this.mDrawFace == 4 || this.mDrawFace == 1 && !this.mHoldAlpha) {
            if (this.mMainImage == null) {
                Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
            }
            this.mImageModified = this.mMainImage.fill(destrect, color = (color & 0xFF000000) + (LayerNI.toActualColor(color & 0xFFFFFF) & 0xFFFFFF)) || this.mImageModified;
        } else if (this.mDrawFace == 1) {
            if (this.mMainImage == null) {
                Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
            }
            this.mImageModified = this.mMainImage.fillColor(destrect, color = LayerNI.toActualColor(color), 255) || this.mImageModified;
        } else if (this.mDrawFace == 2) {
            if (this.mMainImage == null) {
                Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
            }
            this.mImageModified = this.mMainImage.fillMask(destrect, color & 0xFF) || this.mImageModified;
        } else if (this.mDrawFace == 3) {
            if ((color &= 0xFF) != 0) {
                if (this.mProvinceImage == null) {
                    this.allocateProvinceImage();
                }
                if (this.mProvinceImage != null) {
                    this.mImageModified = this.mProvinceImage.fill(destrect, color & 0xFF) || this.mImageModified;
                }
            } else if (this.mProvinceImage != null) {
                if (destrect.left == 0 && destrect.top == 0 && destrect.right == this.mProvinceImage.getWidth() && destrect.bottom == this.mProvinceImage.getHeight()) {
                    this.deallocateProvinceImage();
                    this.mImageModified = true;
                } else {
                    boolean bl = this.mImageModified = this.mProvinceImage.fill(destrect, color & 0xFF) || this.mImageModified;
                }
            }
        }
        if (this.mImageLeft != 0 || this.mImageTop != 0) {
            Rect ur = new Rect(destrect);
            ur.addOffsets(this.mImageLeft, this.mImageTop);
            this.update(ur);
        } else {
            this.update(destrect);
        }
    }

    public VariantClosure getActionOwner() {
        return this.mActionOwner;
    }

    public int getTextWidth(String text) throws TJSException {
        if (this.mMainImage == null) {
            Message.throwExceptionMessage("%1 \u306f\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093", "getTextWidth");
        }
        this.applyFont();
        return this.mMainImage.getTextWidth(text);
    }

    public int getTextHeight(String text) throws TJSException {
        if (this.mMainImage == null) {
            Message.throwExceptionMessage("%1 \u306f\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093", "getTextHeight");
        }
        this.applyFont();
        return this.mMainImage.getTextHeight(text);
    }

    public double getEscWidthX(String text) throws TJSException {
        if (this.mMainImage == null) {
            Message.throwExceptionMessage("%1 \u306f\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093", "getEscWidthX");
        }
        this.applyFont();
        return this.mMainImage.getEscWidthX(text);
    }

    public double getEscWidthY(String text) throws TJSException {
        if (this.mMainImage == null) {
            Message.throwExceptionMessage("%1 \u306f\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093", "getEscWidthY");
        }
        this.applyFont();
        return this.mMainImage.getEscWidthY(text);
    }

    public double getEscHeightX(String text) throws TJSException {
        if (this.mMainImage == null) {
            Message.throwExceptionMessage("%1 \u306f\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093", "getEscHeightX");
        }
        this.applyFont();
        return this.mMainImage.getEscHeightX(text);
    }

    public double getEscHeightY(String text) throws TJSException {
        if (this.mMainImage == null) {
            Message.throwExceptionMessage("%1 \u306f\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093", "getEscHeightY");
        }
        this.applyFont();
        return this.mMainImage.getEscHeightY(text);
    }

    public boolean doUserFontSelect(int flags, String caption, String prompt, String samplestring) {
        this.applyFont();
        boolean b = this.mMainImage.selectFont(flags, caption, prompt, samplestring, this.mFont.getFaceName());
        if (b) {
            this.mFontChanged = true;
        }
        return b;
    }

    public void getFontList(int flags, ArrayList<String> list) {
        this.applyFont();
        this.mMainImage.getFontList(flags, list);
    }

    public void mapPrerenderedFont(String storage) throws TJSException {
        this.applyFont();
        this.mMainImage.mapPrerenderedFont(storage);
    }

    public void unmapPrerenderedFont() {
        this.applyFont();
        this.mMainImage.unmapPrerenderedFont();
    }

    public void loadFont(String storage, String facename) throws TJSException {
        this.applyFont();
        this.mMainImage.loadFont(storage, facename);
    }

    private void checkZOrderMoveRule(LayerNI lay) throws TJSException {
        if (this.mParent == null) {
            Message.throwExceptionMessage("\u30d7\u30e9\u30a4\u30de\u30ea\u30ec\u30a4\u30e4\u3084\u5144\u5f1f\u306e\u7121\u3044\u30ec\u30a4\u30e4\u306f\u524d\u5f8c\u306b\u79fb\u52d5\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        if (this.mParent.mChildren.getActualCount() <= 1) {
            Message.throwExceptionMessage("\u30d7\u30e9\u30a4\u30de\u30ea\u30ec\u30a4\u30e4\u3084\u5144\u5f1f\u306e\u7121\u3044\u30ec\u30a4\u30e4\u306f\u524d\u5f8c\u306b\u79fb\u52d5\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        if (lay == this) {
            Message.throwExceptionMessage("\u81ea\u5206\u81ea\u8eab\u306e\u524d\u5f8c\u3084\u89aa\u306e\u7570\u306a\u308b\u30ec\u30a4\u30e4\u306e\u524d\u5f8c\u306b\u79fb\u52d5\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        if (lay.mParent != this.mParent) {
            Message.throwExceptionMessage("\u81ea\u5206\u81ea\u8eab\u306e\u524d\u5f8c\u3084\u89aa\u306e\u7570\u306a\u308b\u30ec\u30a4\u30e4\u306e\u524d\u5f8c\u306b\u79fb\u52d5\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093");
        }
    }

    public void moveBefore(LayerNI lay) throws TJSException {
        if (this.mParent != null) {
            this.mParent.setAbsoluteOrderMode(false);
        }
        this.checkZOrderMoveRule(lay);
        int this_order = this.getOrderIndex();
        int lay_order = lay.getOrderIndex();
        if (this_order < lay_order) {
            this.mParent.childChangeOrder(this_order, lay_order);
        } else {
            this.mParent.childChangeOrder(this_order, lay_order + 1);
        }
    }

    public void moveBehind(LayerNI lay) throws TJSException {
        if (this.mParent != null) {
            this.mParent.setAbsoluteOrderMode(false);
        }
        this.checkZOrderMoveRule(lay);
        int this_order = this.getOrderIndex();
        int lay_order = lay.getOrderIndex();
        if (this_order < lay_order) {
            this.mParent.childChangeOrder(this_order, lay_order - 1);
        } else {
            this.mParent.childChangeOrder(this_order, lay_order);
        }
    }

    void setOrderIndex(int index) throws TJSException {
        if (this.mParent == null) {
            Message.throwExceptionMessage("\u30d7\u30e9\u30a4\u30de\u30ea\u30ec\u30a4\u30e4\u3084\u5144\u5f1f\u306e\u7121\u3044\u30ec\u30a4\u30e4\u306f\u524d\u5f8c\u306b\u79fb\u52d5\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        this.mParent.setAbsoluteOrderMode(false);
        if (index < 0) {
            index = 0;
        }
        if (index >= this.mParent.mChildren.getActualCount()) {
            index = this.mParent.mChildren.getActualCount() - 1;
        }
        this.mParent.childChangeOrder(this.getOrderIndex(), index);
    }

    public void bringToBack() throws TJSException {
        if (this.mParent == null) {
            Message.throwExceptionMessage("\u30d7\u30e9\u30a4\u30de\u30ea\u30ec\u30a4\u30e4\u3084\u5144\u5f1f\u306e\u7121\u3044\u30ec\u30a4\u30e4\u306f\u524d\u5f8c\u306b\u79fb\u52d5\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        this.mParent.setAbsoluteOrderMode(false);
        this.setOrderIndex(0);
    }

    public void bringToFront() throws TJSException {
        if (this.mParent == null) {
            Message.throwExceptionMessage("\u30d7\u30e9\u30a4\u30de\u30ea\u30ec\u30a4\u30e4\u3084\u5144\u5f1f\u306e\u7121\u3044\u30ec\u30a4\u30e4\u306f\u524d\u5f8c\u306b\u79fb\u52d5\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        this.mParent.setAbsoluteOrderMode(false);
        this.setOrderIndex(this.mParent.mChildren.getActualCount() - 1);
    }

    public void saveLayerImage(String name, String type) throws TJSException {
        if (this.mMainImage == null) {
            Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        this.mMainImage.saveAsBMP(name, type);
    }

    public void loadProvinceImage(String name) throws TJSException {
        if (this.mMainImage == null) {
            Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        this.allocateProvinceImage();
        try {
            GraphicsLoader.loadGraphic(this.mProvinceImage, name, 0, this.mMainImage.getWidth(), this.mMainImage.getHeight(), 1, null, null);
            if (this.mProvinceImage.getWidth() != this.mMainImage.getWidth() || this.mProvinceImage.getHeight() != this.mMainImage.getHeight()) {
                Message.throwExceptionMessage("\u9818\u57df\u753b\u50cf %1 \u306f\u30e1\u30a4\u30f3\u753b\u50cf\u3068\u30b5\u30a4\u30ba\u304c\u9055\u3044\u307e\u3059", name);
            }
        }
        catch (TJSException e) {
            this.deallocateProvinceImage();
            throw e;
        }
        this.mImageModified = true;
    }

    public int getMainPixel(int x, int y) throws TJSException {
        if (this.mMainImage == null) {
            Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        return LayerNI.fromActualColor(this.mMainImage.getPoint(x, y) & 0xFFFFFF);
    }

    public void setMainPixel(int x, int y, int color) throws TJSException {
        if (this.mMainImage == null) {
            Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        if (x < this.mClipRect.left || y < this.mClipRect.top || x >= this.mClipRect.right || y >= this.mClipRect.bottom) {
            return;
        }
        this.mMainImage.setPointMain(x, y, LayerNI.toActualColor(color));
        this.mImageModified = true;
        Rect r = new Rect();
        r.left = this.mImageLeft + x;
        r.top = this.mImageTop + y;
        r.right = r.left + 1;
        r.bottom = r.top + 1;
        this.update(r);
    }

    public int getMaskPixel(int x, int y) throws TJSException {
        if (this.mMainImage == null) {
            Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        return (this.mMainImage.getPoint(x, y) & 0xFF000000) >>> 24;
    }

    public void setMaskPixel(int x, int y, int mask) throws TJSException {
        if (this.mMainImage == null) {
            Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        if (x < this.mClipRect.left || y < this.mClipRect.top || x >= this.mClipRect.right || y >= this.mClipRect.bottom) {
            return;
        }
        this.mMainImage.setPointMask(x, y, mask);
        this.mImageModified = true;
        Rect r = new Rect();
        r.left = this.mImageLeft + x;
        r.top = this.mImageTop + y;
        r.right = r.left + 1;
        r.bottom = r.top + 1;
        this.update(r);
    }

    public int getProvincePixel(int x, int y) throws TJSException {
        if (this.mProvinceImage == null) {
            return 0;
        }
        if (x < 0 || y < 0 || x >= this.mProvinceImage.getWidth() || y >= this.mProvinceImage.getHeight()) {
            return 0;
        }
        int ret = this.mProvinceImage.getPoint(x, y);
        return ret;
    }

    public void setProvincePixel(int x, int y, int n) throws TJSException {
        if (this.mProvinceImage == null) {
            this.allocateProvinceImage();
        }
        if (x < this.mClipRect.left || y < this.mClipRect.top || x >= this.mClipRect.right || y >= this.mClipRect.bottom) {
            return;
        }
        this.mProvinceImage.setPoint(x, y, n);
        this.mImageModified = true;
        Rect r = new Rect();
        r.left = this.mImageLeft + x;
        r.top = this.mImageTop + y;
        r.right = r.left + 1;
        r.bottom = r.top + 1;
        this.update(r);
    }

    public LayerNI getMostFrontChildAt(int x, int y, boolean exclude_self, boolean get_disabled) throws TJSException {
        if (this.mManager == null) {
            return null;
        }
        LayerNI p = this;
        while (p != null) {
            if (p.mParent == null) break;
            x += p.mRect.left;
            y += p.mRect.top;
            p = p.mParent;
        }
        return this.mManager.getMostFrontChildAt(x, y, exclude_self ? this : null, get_disabled);
    }

    private boolean hitTestNoVisibleCheckInternal(int x, int y) throws TJSException {
        if (this.mHitType == 0) {
            if (this.mMainImage != null) {
                int px = x - this.mImageLeft;
                int py = y - this.mImageTop;
                if (px >= 0 && py >= 0 && px < this.mMainImage.getWidth() && py < this.mMainImage.getHeight()) {
                    int cl = this.mMainImage.getPoint(px, py);
                    return cl >>> 24 >= this.mHitThreshold;
                }
                return false;
            }
            if (x >= 0 && y >= 0 && x < this.mRect.width() && y < this.mRect.height()) {
                return this.mHitThreshold <= 0;
            }
            return false;
        }
        if (this.mHitType == 1) {
            if (this.mProvinceImage != null) {
                int px = x - this.mImageLeft;
                int py = y - this.mImageTop;
                if (px >= 0 && py >= 0 && px < this.mProvinceImage.getWidth() && py < this.mProvinceImage.getHeight()) {
                    int cl = this.mProvinceImage.getPoint(px, py);
                    return cl != 0;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    private boolean hitTestNoVisibleCheck(int x, int y) throws TJSException {
        boolean res = this.hitTestNoVisibleCheckInternal(x, y);
        if (res) {
            Dispatch2 owner = (Dispatch2)this.mOwner.get();
            if (owner != null && !this.mShutdown) {
                this.mOnHitTest_Work = true;
                Variant[] param = new Variant[]{new Variant(x), new Variant(y), new Variant(1)};
                TVP.EventManager.postEvent(owner, owner, ON_HIT_TEST, 0, 2, param);
                res = this.mOnHitTest_Work;
            } else {
                return res;
            }
        }
        return res;
    }

    boolean getMostFrontChildAt(int x, int y, Holder<LayerNI> lay, LayerNI except, boolean get_disabled) throws TJSException {
        if (!this.mVisible) {
            return false;
        }
        if ((x -= this.mRect.left) < 0 || (y -= this.mRect.top) < 0 || x >= this.mRect.width() || y >= this.mRect.height()) {
            return false;
        }
        int ox = x;
        int oy = y;
        try {
            this.mChildren.safeLock();
            int count = this.mChildren.getSafeLockedObjectCount();
            int i = count - 1;
            while (i >= 0) {
                boolean b;
                LayerNI child = this.mChildren.getSafeLockedObjectAt(i);
                if (child != null && (b = child.getMostFrontChildAt(x, y, lay, except, get_disabled))) {
                    return true;
                }
                --i;
            }
        }
        finally {
            this.mChildren.safeUnlock();
        }
        if (except == this) {
            return false;
        }
        if (this.hitTestNoVisibleCheck(ox, oy)) {
            if (!(get_disabled || this.getNodeEnabled() && !this.isDisabledByMode())) {
                lay.mValue = null;
                return true;
            }
            lay.mValue = this;
            return true;
        }
        return false;
    }

    public void setImagePosition(int left, int top) throws TJSException {
        if (this.mMainImage == null) {
            Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        if (this.mImageLeft != left || this.mImageTop != top) {
            if (left > 0) {
                Message.throwExceptionMessage("\u30ec\u30a4\u30e4\u9818\u57df\u306b\u753b\u50cf\u306e\u7121\u3044\u9818\u57df\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
            }
            if (top > 0) {
                Message.throwExceptionMessage("\u30ec\u30a4\u30e4\u9818\u57df\u306b\u753b\u50cf\u306e\u7121\u3044\u9818\u57df\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
            }
            if (this.mMainImage.getWidth() + left < this.mRect.width()) {
                Message.throwExceptionMessage("\u30ec\u30a4\u30e4\u9818\u57df\u306b\u753b\u50cf\u306e\u7121\u3044\u9818\u57df\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
            }
            if (this.mMainImage.getHeight() + top < this.mRect.height()) {
                Message.throwExceptionMessage("\u30ec\u30a4\u30e4\u9818\u57df\u306b\u753b\u50cf\u306e\u7121\u3044\u9818\u57df\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
            }
            this.mImageLeft = left;
            this.mImageTop = top;
            this.update();
        }
    }

    public void independMainImage(boolean copy) {
        if (this.mMainImage != null) {
            if (copy) {
                this.mMainImage.independ();
            } else {
                this.mMainImage.independNoCopy();
            }
        }
    }

    public void independProvinceImage(boolean copy) {
        if (this.mProvinceImage != null) {
            if (copy) {
                this.mProvinceImage.independ();
            } else {
                this.mProvinceImage.independNoCopy();
            }
        }
    }

    public void setClip(int left, int top, int width, int height) throws TJSException {
        if (this.mMainImage == null) {
            Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        this.mClipRect.left = left < 0 ? 0 : left;
        this.mClipRect.top = top < 0 ? 0 : top;
        int right = width + left;
        int bottom = height + top;
        int w = this.mMainImage.getWidth();
        int h = this.mMainImage.getHeight();
        this.mClipRect.right = w < right ? w : right;
        int n = this.mClipRect.bottom = h < bottom ? h : bottom;
        if (this.mClipRect.right < this.mClipRect.left) {
            this.mClipRect.right = this.mClipRect.left;
        }
        if (this.mClipRect.bottom < this.mClipRect.top) {
            this.mClipRect.bottom = this.mClipRect.top;
        }
    }

    public void colorRect(Rect rect, int color, int opa) throws TJSException {
        Rect destrect = new Rect();
        if (!Rect.intersectRect(destrect, rect, this.mClipRect)) {
            return;
        }
        switch (this.mDrawFace) {
            case 0: {
                if (this.mMainImage == null) {
                    Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (opa > 0) {
                    this.mImageModified = this.mMainImage.fillColorOnAlpha(destrect, color = LayerNI.toActualColor(color), opa) || this.mImageModified;
                    break;
                }
                this.mImageModified = this.mMainImage.removeConstOpacity(destrect, -opa) || this.mImageModified;
                break;
            }
            case 4: {
                if (this.mMainImage == null) {
                    Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (opa >= 0) {
                    this.mImageModified = this.mMainImage.fillColorOnAddAlpha(destrect, color = LayerNI.toActualColor(color), opa) || this.mImageModified;
                    break;
                }
                Message.throwExceptionMessage("\u8ca0\u306e\u4e0d\u900f\u660e\u5ea6\u306f\u3053\u306e face \u3067\u306f\u6307\u5b9a\u3067\u304d\u307e\u305b\u3093");
                break;
            }
            case 1: {
                if (this.mMainImage == null) {
                    Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                this.mImageModified = this.mMainImage.fillColor(destrect, color = LayerNI.toActualColor(color), opa) || this.mImageModified;
                break;
            }
            case 2: {
                if (this.mMainImage == null) {
                    Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                this.mImageModified = this.mMainImage.fillMask(destrect, (color & 0xFF) != 0 || this.mImageModified ? 1 : 0);
                break;
            }
            case 3: {
                if ((color &= 0xFF) != 0) {
                    if (this.mProvinceImage == null) {
                        this.allocateProvinceImage();
                    }
                    if (this.mProvinceImage == null) break;
                    this.mImageModified = this.mProvinceImage.fill(destrect, color & 0xFF) || this.mImageModified;
                    break;
                }
                if (this.mProvinceImage == null) break;
                if (destrect.left == 0 && destrect.top == 0 && destrect.right == this.mProvinceImage.getWidth() && destrect.bottom == this.mProvinceImage.getHeight()) {
                    this.deallocateProvinceImage();
                    this.mImageModified = true;
                    break;
                }
                boolean bl = this.mImageModified = this.mProvinceImage.fill(destrect, color & 0xFF) || this.mImageModified;
            }
        }
        if (this.mImageLeft != 0 || this.mImageTop != 0) {
            Rect ur = new Rect(destrect);
            ur.addOffsets(this.mImageLeft, this.mImageTop);
            this.update(ur);
        } else {
            this.update(destrect);
        }
    }

    private boolean clipDestPointAndSrcRect(Point d, Rect srcrectout, Rect srcrect) {
        srcrectout.set(srcrect);
        int dr = d.x + srcrect.right - srcrect.left;
        int db = d.y + srcrect.bottom - srcrect.top;
        if (d.x < this.mClipRect.left) {
            srcrectout.left += this.mClipRect.left - d.x;
            d.x = this.mClipRect.left;
        }
        if (dr > this.mClipRect.right) {
            srcrectout.right -= dr - this.mClipRect.right;
        }
        if (srcrectout.right <= srcrectout.left) {
            return false;
        }
        if (d.y < this.mClipRect.top) {
            srcrectout.top += this.mClipRect.top - d.y;
            d.y = this.mClipRect.top;
        }
        if (db > this.mClipRect.bottom) {
            srcrectout.bottom -= db - this.mClipRect.bottom;
        }
        return srcrectout.bottom > srcrectout.top;
    }

    public void piledCopy(int dx, int dy, LayerNI src, Rect srcrect) throws TJSException {
        Rect rect;
        Point d;
        if (this.mMainImage == null) {
            Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        if (src.mMainImage == null) {
            Message.throwExceptionMessage("\u8ee2\u9001\u5143\u30ec\u30a4\u30e4\u306f\u753b\u50cf\u3092\u6301\u3063\u3066\u3044\u307e\u305b\u3093");
        }
        if (!this.clipDestPointAndSrcRect(d = new Point(dx, dy), rect = new Rect(), srcrect)) {
            return;
        }
        dx = d.x;
        dy = d.y;
        src.incCacheEnabledCount();
        try {
            BaseBitmap bmp = src.complete(rect);
            this.mImageModified = this.mMainImage.copyRect(dx, dy, bmp, rect, 3) || this.mImageModified;
        }
        finally {
            src.decCacheEnabledCount();
        }
        Rect ur = new Rect(rect);
        ur.setOffsets(dx, dy);
        if (this.mImageLeft != 0 || this.mImageTop != 0) {
            ur.addOffsets(this.mImageLeft, this.mImageTop);
            this.update(ur);
        } else {
            this.update(ur);
        }
    }

    public void copyRect(int dx, int dy, LayerNI src, Rect srcrect) throws TJSException {
        Point d = new Point(dx, dy);
        Rect rect = new Rect();
        if (!this.clipDestPointAndSrcRect(d, rect, srcrect)) {
            return;
        }
        dx = d.x;
        dy = d.y;
        switch (this.mDrawFace) {
            case 0: 
            case 4: {
                if (this.mMainImage == null) {
                    Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (src.mMainImage == null) {
                    Message.throwExceptionMessage("\u8ee2\u9001\u5143\u30ec\u30a4\u30e4\u306f\u753b\u50cf\u3092\u6301\u3063\u3066\u3044\u307e\u305b\u3093");
                }
                this.mImageModified = this.mMainImage.copyRect(dx, dy, src.mMainImage, rect, 3) || this.mImageModified;
                break;
            }
            case 1: {
                if (this.mMainImage == null) {
                    Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (src.mMainImage == null) {
                    Message.throwExceptionMessage("\u8ee2\u9001\u5143\u30ec\u30a4\u30e4\u306f\u753b\u50cf\u3092\u6301\u3063\u3066\u3044\u307e\u305b\u3093");
                }
                this.mImageModified = this.mMainImage.copyRect(dx, dy, src.mMainImage, rect, this.mHoldAlpha ? 1 : 3) || this.mImageModified;
                break;
            }
            case 2: {
                if (this.mMainImage == null) {
                    Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (src.mMainImage == null) {
                    Message.throwExceptionMessage("\u8ee2\u9001\u5143\u30ec\u30a4\u30e4\u306f\u753b\u50cf\u3092\u6301\u3063\u3066\u3044\u307e\u305b\u3093");
                }
                this.mImageModified = this.mMainImage.copyRect(dx, dy, src.mMainImage, rect, 2) || this.mImageModified;
                break;
            }
            case 3: {
                if (src.mProvinceImage == null) {
                    if (this.mProvinceImage != null) {
                        this.mProvinceImage.fill(rect, 0);
                    }
                    this.mImageModified = true;
                    break;
                }
                if (this.mProvinceImage == null) {
                    this.allocateProvinceImage();
                }
                this.mImageModified = this.mProvinceImage.copyRect(dx, dy, src.mProvinceImage, rect) || this.mImageModified;
            }
        }
        Rect ur = new Rect(rect);
        ur.setOffsets(dx, dy);
        if (this.mImageLeft != 0 || this.mImageTop != 0) {
            ur.addOffsets(this.mImageLeft, this.mImageTop);
            this.update(ur);
        } else {
            this.update(ur);
        }
    }

    public void pileRect(int dx, int dy, LayerNI src, Rect srcrect, int opacity) throws TJSException {
        Rect rect;
        Point d;
        if (this.mDrawFace != 0 && this.mDrawFace != 1) {
            Message.throwExceptionMessage("%1 \u3067\u306f\u3053\u306e face \u306b\u63cf\u753b\u3067\u304d\u307e\u305b\u3093", "pileRect");
        }
        if (!this.clipDestPointAndSrcRect(d = new Point(dx, dy), rect = new Rect(), srcrect)) {
            return;
        }
        dx = d.x;
        dy = d.y;
        switch (this.mDrawFace) {
            case 0: {
                if (this.mMainImage == null) {
                    Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (src.mMainImage == null) {
                    Message.throwExceptionMessage("\u8ee2\u9001\u5143\u30ec\u30a4\u30e4\u306f\u753b\u50cf\u3092\u6301\u3063\u3066\u3044\u307e\u305b\u3093");
                }
                this.mImageModified = this.mMainImage.blt(dx, dy, src.mMainImage, rect, 3, opacity, this.mHoldAlpha) || this.mImageModified;
                break;
            }
            case 1: {
                if (this.mMainImage == null) {
                    Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (src.mMainImage == null) {
                    Message.throwExceptionMessage("\u8ee2\u9001\u5143\u30ec\u30a4\u30e4\u306f\u753b\u50cf\u3092\u6301\u3063\u3066\u3044\u307e\u305b\u3093");
                }
                this.mImageModified = this.mMainImage.blt(dx, dy, src.mMainImage, rect, 2, opacity, this.mHoldAlpha) || this.mImageModified;
            }
        }
        Rect ur = new Rect(rect);
        ur.setOffsets(dx, dy);
        if (this.mImageLeft != 0 || this.mImageTop != 0) {
            ur.addOffsets(this.mImageLeft, this.mImageTop);
            this.update(ur);
        } else {
            this.update(ur);
        }
    }

    public void blendRect(int dx, int dy, LayerNI src, Rect srcrect, int opacity) throws TJSException {
        Rect rect;
        Point d;
        if (this.mDrawFace != 0 && this.mDrawFace != 1) {
            Message.throwExceptionMessage("%1 \u3067\u306f\u3053\u306e face \u306b\u63cf\u753b\u3067\u304d\u307e\u305b\u3093", "blendRect");
        }
        if (!this.clipDestPointAndSrcRect(d = new Point(dx, dy), rect = new Rect(), srcrect)) {
            return;
        }
        dx = d.x;
        dy = d.y;
        switch (this.mDrawFace) {
            case 0: {
                if (this.mMainImage == null) {
                    Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (src.mMainImage == null) {
                    Message.throwExceptionMessage("\u8ee2\u9001\u5143\u30ec\u30a4\u30e4\u306f\u753b\u50cf\u3092\u6301\u3063\u3066\u3044\u307e\u305b\u3093");
                }
                this.mImageModified = this.mMainImage.blt(dx, dy, src.mMainImage, rect, 1, opacity, this.mHoldAlpha) || this.mImageModified;
                break;
            }
            case 1: {
                if (this.mMainImage == null) {
                    Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (src.mMainImage == null) {
                    Message.throwExceptionMessage("\u8ee2\u9001\u5143\u30ec\u30a4\u30e4\u306f\u753b\u50cf\u3092\u6301\u3063\u3066\u3044\u307e\u305b\u3093");
                }
                this.mImageModified = this.mMainImage.blt(dx, dy, src.mMainImage, rect, 0, opacity, this.mHoldAlpha) || this.mImageModified;
            }
        }
        Rect ur = new Rect(rect);
        ur.setOffsets(dx, dy);
        if (this.mImageLeft != 0 || this.mImageTop != 0) {
            ur.addOffsets(this.mImageLeft, this.mImageTop);
            this.update(ur);
        } else {
            this.update(ur);
        }
    }

    private int getOperationModeFromType() {
        switch (this.mDisplayType) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 8: {
                return 8;
            }
            case 9: {
                return 9;
            }
            case 10: {
                return 10;
            }
            case 11: {
                return 11;
            }
            case 12: {
                return 12;
            }
            case 13: {
                return 13;
            }
            case 14: {
                return 14;
            }
            case 15: {
                return 15;
            }
            case 16: {
                return 16;
            }
            case 17: {
                return 17;
            }
            case 18: {
                return 18;
            }
            case 19: {
                return 19;
            }
            case 20: {
                return 20;
            }
            case 21: {
                return 21;
            }
            case 22: {
                return 22;
            }
            case 23: {
                return 23;
            }
            case 24: {
                return 24;
            }
            case 25: {
                return 25;
            }
            case 26: {
                return 26;
            }
            case 27: {
                return 27;
            }
            case 28: {
                return 28;
            }
        }
        return 1;
    }

    private boolean getBltMethodFromOperationModeAndDrawFace(IntWrapper result, int mode) {
        int met = 0;
        boolean met_set = false;
        switch (mode) {
            case 13: {
                met_set = true;
                met = 16;
                break;
            }
            case 14: {
                met_set = true;
                met = 17;
                break;
            }
            case 15: {
                met_set = true;
                met = 18;
                break;
            }
            case 16: {
                met_set = true;
                met = 19;
                break;
            }
            case 17: {
                met_set = true;
                met = 20;
                break;
            }
            case 18: {
                met_set = true;
                met = 21;
                break;
            }
            case 19: {
                met_set = true;
                met = 22;
                break;
            }
            case 20: {
                met_set = true;
                met = 23;
                break;
            }
            case 21: {
                met_set = true;
                met = 24;
                break;
            }
            case 22: {
                met_set = true;
                met = 25;
                break;
            }
            case 23: {
                met_set = true;
                met = 26;
                break;
            }
            case 24: {
                met_set = true;
                met = 27;
                break;
            }
            case 25: {
                met_set = true;
                met = 28;
                break;
            }
            case 26: {
                met_set = true;
                met = 29;
                break;
            }
            case 27: {
                met_set = true;
                met = 30;
                break;
            }
            case 28: {
                met_set = true;
                met = 31;
                break;
            }
            case 3: {
                met_set = true;
                met = 4;
                break;
            }
            case 4: {
                met_set = true;
                met = 5;
                break;
            }
            case 5: {
                met_set = true;
                met = 6;
                break;
            }
            case 8: {
                met_set = true;
                met = 7;
                break;
            }
            case 9: {
                met_set = true;
                met = 8;
                break;
            }
            case 10: {
                met_set = true;
                met = 9;
                break;
            }
            case 11: {
                met_set = true;
                met = 10;
                break;
            }
            case 2: {
                if (this.mDrawFace == 0) {
                    met_set = true;
                    met = 3;
                    break;
                }
                if (this.mDrawFace == 4) {
                    met_set = true;
                    met = 14;
                    break;
                }
                if (this.mDrawFace != 1) break;
                met_set = true;
                met = 2;
                break;
            }
            case 12: {
                if (this.mDrawFace == 0) {
                    met_set = true;
                    met = 13;
                    break;
                }
                if (this.mDrawFace == 4) {
                    met_set = true;
                    met = 12;
                    break;
                }
                if (this.mDrawFace != 1) break;
                met_set = true;
                met = 11;
                break;
            }
            case 1: {
                if (this.mDrawFace == 0) {
                    met_set = true;
                    met = 1;
                    break;
                }
                if (this.mDrawFace == 4) {
                    met_set = true;
                    met = 15;
                    break;
                }
                if (this.mDrawFace != 1) break;
                met_set = true;
                met = 0;
            }
        }
        result.value = met;
        return met_set;
    }

    public void operateRect(int dx, int dy, LayerNI src, Rect srcrect, int mode, int opacity) throws TJSException {
        IntWrapper met;
        Point d = new Point(dx, dy);
        Rect rect = new Rect();
        if (!this.clipDestPointAndSrcRect(d, rect, srcrect)) {
            return;
        }
        dx = d.x;
        dy = d.y;
        if (mode == 128) {
            mode = src.getOperationModeFromType();
        }
        if (!this.getBltMethodFromOperationModeAndDrawFace(met = new IntWrapper(), mode)) {
            Message.throwExceptionMessage("%1 \u3067\u306f\u3053\u306e face \u306b\u63cf\u753b\u3067\u304d\u307e\u305b\u3093", "operateRect");
        }
        if (this.mMainImage == null) {
            Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        if (src.mMainImage == null) {
            Message.throwExceptionMessage("\u8ee2\u9001\u5143\u30ec\u30a4\u30e4\u306f\u753b\u50cf\u3092\u6301\u3063\u3066\u3044\u307e\u305b\u3093");
        }
        this.mImageModified = this.mMainImage.blt(dx, dy, src.mMainImage, rect, met.value, opacity, this.mHoldAlpha) || this.mImageModified;
        Rect ur = new Rect(rect);
        ur.setOffsets(dx, dy);
        if (this.mImageLeft != 0 || this.mImageTop != 0) {
            ur.addOffsets(this.mImageLeft, this.mImageTop);
            this.update(ur);
        } else {
            this.update(ur);
        }
    }

    public void stretchCopy(Rect destrect, LayerNI src, Rect srcrect, int type) throws TJSException {
        int t;
        Rect ur = new Rect(destrect);
        if (ur.right < ur.left) {
            t = ur.right;
            ur.right = ur.left;
            ur.left = t;
        }
        if (ur.bottom < ur.top) {
            t = ur.bottom;
            ur.bottom = ur.top;
            ur.top = t;
        }
        if (!Rect.intersectRect(ur, ur, this.mClipRect)) {
            return;
        }
        switch (this.mDrawFace) {
            case 0: 
            case 4: {
                if (this.mMainImage == null) {
                    Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (src.mMainImage == null) {
                    Message.throwExceptionMessage("\u8ee2\u9001\u5143\u30ec\u30a4\u30e4\u306f\u753b\u50cf\u3092\u6301\u3063\u3066\u3044\u307e\u305b\u3093");
                }
                this.mImageModified = this.mMainImage.stretchBlt(this.mClipRect, destrect, src.mMainImage, srcrect, 0, 255, false, type) || this.mImageModified;
                break;
            }
            case 1: {
                if (this.mMainImage == null) {
                    Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (src.mMainImage == null) {
                    Message.throwExceptionMessage("\u8ee2\u9001\u5143\u30ec\u30a4\u30e4\u306f\u753b\u50cf\u3092\u6301\u3063\u3066\u3044\u307e\u305b\u3093");
                }
                this.mImageModified = this.mMainImage.stretchBlt(this.mClipRect, destrect, src.mMainImage, srcrect, 0, 255, this.mHoldAlpha, type) || this.mImageModified;
                break;
            }
            default: {
                Message.throwExceptionMessage("%1 \u3067\u306f\u3053\u306e face \u306b\u63cf\u753b\u3067\u304d\u307e\u305b\u3093", "stretchCopy");
            }
        }
        if (this.mImageLeft != 0 || this.mImageTop != 0) {
            ur.addOffsets(this.mImageLeft, this.mImageTop);
            this.update(ur);
        } else {
            this.update(ur);
        }
    }

    public void stretchPile(Rect destrect, LayerNI src, Rect srcrect, int opacity, int type) throws TJSException {
        int t;
        if (this.mDrawFace != 0 && this.mDrawFace != 1) {
            Message.throwExceptionMessage("%1 \u3067\u306f\u3053\u306e face \u306b\u63cf\u753b\u3067\u304d\u307e\u305b\u3093", "stretchPile");
        }
        Rect ur = new Rect(destrect);
        if (ur.right < ur.left) {
            t = ur.right;
            ur.right = ur.left;
            ur.left = t;
        }
        if (ur.bottom < ur.top) {
            t = ur.bottom;
            ur.bottom = ur.top;
            ur.top = t;
        }
        if (!Rect.intersectRect(ur, ur, this.mClipRect)) {
            return;
        }
        switch (this.mDrawFace) {
            case 0: {
                if (this.mMainImage == null) {
                    Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (src.mMainImage == null) {
                    Message.throwExceptionMessage("\u8ee2\u9001\u5143\u30ec\u30a4\u30e4\u306f\u753b\u50cf\u3092\u6301\u3063\u3066\u3044\u307e\u305b\u3093");
                }
                this.mImageModified = this.mMainImage.stretchBlt(this.mClipRect, destrect, src.mMainImage, srcrect, 3, opacity, this.mHoldAlpha, type) || this.mImageModified;
                break;
            }
            case 1: {
                if (this.mMainImage == null) {
                    Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (src.mMainImage == null) {
                    Message.throwExceptionMessage("\u8ee2\u9001\u5143\u30ec\u30a4\u30e4\u306f\u753b\u50cf\u3092\u6301\u3063\u3066\u3044\u307e\u305b\u3093");
                }
                boolean bl = this.mImageModified = this.mMainImage.stretchBlt(this.mClipRect, destrect, src.mMainImage, srcrect, 2, opacity, this.mHoldAlpha, type) || this.mImageModified;
            }
        }
        if (this.mImageLeft != 0 || this.mImageTop != 0) {
            ur.addOffsets(this.mImageLeft, this.mImageTop);
            this.update(ur);
        } else {
            this.update(ur);
        }
    }

    public void stretchBlend(Rect destrect, LayerNI src, Rect srcrect, int opacity, int type) throws TJSException {
        int t;
        if (this.mDrawFace != 0 && this.mDrawFace != 1) {
            Message.throwExceptionMessage("%1 \u3067\u306f\u3053\u306e face \u306b\u63cf\u753b\u3067\u304d\u307e\u305b\u3093", "stretchBlend");
        }
        Rect ur = new Rect(destrect);
        if (ur.right < ur.left) {
            t = ur.right;
            ur.right = ur.left;
            ur.left = t;
        }
        if (ur.bottom < ur.top) {
            t = ur.bottom;
            ur.bottom = ur.top;
            ur.top = t;
        }
        if (!Rect.intersectRect(ur, ur, this.mClipRect)) {
            return;
        }
        switch (this.mDrawFace) {
            case 0: {
                if (this.mMainImage == null) {
                    Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (src.mMainImage == null) {
                    Message.throwExceptionMessage("\u8ee2\u9001\u5143\u30ec\u30a4\u30e4\u306f\u753b\u50cf\u3092\u6301\u3063\u3066\u3044\u307e\u305b\u3093");
                }
                this.mImageModified = this.mMainImage.stretchBlt(this.mClipRect, destrect, src.mMainImage, srcrect, 1, opacity, this.mHoldAlpha, type) || this.mImageModified;
                break;
            }
            case 1: {
                if (this.mMainImage == null) {
                    Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (src.mMainImage == null) {
                    Message.throwExceptionMessage("\u8ee2\u9001\u5143\u30ec\u30a4\u30e4\u306f\u753b\u50cf\u3092\u6301\u3063\u3066\u3044\u307e\u305b\u3093");
                }
                boolean bl = this.mImageModified = this.mMainImage.stretchBlt(this.mClipRect, destrect, src.mMainImage, srcrect, 0, opacity, this.mHoldAlpha, type) || this.mImageModified;
            }
        }
        if (this.mImageLeft != 0 || this.mImageTop != 0) {
            ur.addOffsets(this.mImageLeft, this.mImageTop);
            this.update(ur);
        } else {
            this.update(ur);
        }
    }

    public void operateStretch(Rect destrect, LayerNI src, Rect srcrect, int mode, int opacity, int type) throws TJSException {
        IntWrapper met;
        int t;
        Rect ur = new Rect(destrect);
        if (ur.right < ur.left) {
            t = ur.right;
            ur.right = ur.left;
            ur.left = t;
        }
        if (ur.bottom < ur.top) {
            t = ur.bottom;
            ur.bottom = ur.top;
            ur.top = t;
        }
        if (!Rect.intersectRect(ur, ur, this.mClipRect)) {
            return;
        }
        if (mode == 128) {
            mode = src.getOperationModeFromType();
        }
        if (!this.getBltMethodFromOperationModeAndDrawFace(met = new IntWrapper(), mode)) {
            Message.throwExceptionMessage("%1 \u3067\u306f\u3053\u306e face \u306b\u63cf\u753b\u3067\u304d\u307e\u305b\u3093", "operateStretch");
        }
        if (this.mMainImage == null) {
            Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        if (src.mMainImage == null) {
            Message.throwExceptionMessage("\u8ee2\u9001\u5143\u30ec\u30a4\u30e4\u306f\u753b\u50cf\u3092\u6301\u3063\u3066\u3044\u307e\u305b\u3093");
        }
        boolean bl = this.mImageModified = this.mMainImage.stretchBlt(this.mClipRect, destrect, src.mMainImage, srcrect, met.value, opacity, this.mHoldAlpha, type) || this.mImageModified;
        if (this.mImageLeft != 0 || this.mImageTop != 0) {
            ur.addOffsets(this.mImageLeft, this.mImageTop);
            this.update(ur);
        } else {
            this.update(ur);
        }
    }

    public void affineCopy(AffineMatrix2D matrix, LayerNI src, Rect srcrect, int type, boolean clear) throws TJSException {
        Rect updaterect = new Rect();
        boolean updated = false;
        switch (this.mDrawFace) {
            case 0: 
            case 4: {
                if (this.mMainImage == null) {
                    Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (src.mMainImage == null) {
                    Message.throwExceptionMessage("\u8ee2\u9001\u5143\u30ec\u30a4\u30e4\u306f\u753b\u50cf\u3092\u6301\u3063\u3066\u3044\u307e\u305b\u3093");
                }
                updated = this.mMainImage.affineBlt(this.mClipRect, src.mMainImage, srcrect, matrix, 0, 255, updaterect, false, type, clear, this.mNeutralColor);
                break;
            }
            case 1: {
                if (this.mMainImage == null) {
                    Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (src.mMainImage == null) {
                    Message.throwExceptionMessage("\u8ee2\u9001\u5143\u30ec\u30a4\u30e4\u306f\u753b\u50cf\u3092\u6301\u3063\u3066\u3044\u307e\u305b\u3093");
                }
                updated = this.mMainImage.affineBlt(this.mClipRect, src.mMainImage, srcrect, matrix, 0, 255, updaterect, this.mHoldAlpha, type, clear, this.mNeutralColor);
                break;
            }
            default: {
                Message.throwExceptionMessage("%1 \u3067\u306f\u3053\u306e face \u306b\u63cf\u753b\u3067\u304d\u307e\u305b\u3093", "affineCopy");
            }
        }
        boolean bl = this.mImageModified = updated || this.mImageModified;
        if (updated) {
            updaterect.addOffsets(this.mImageLeft, this.mImageTop);
            this.update(updaterect);
        }
    }

    public void affineCopy(PointD[] points, LayerNI src, Rect srcrect, int type, boolean clear) throws TJSException {
        Rect updaterect = new Rect();
        boolean updated = false;
        switch (this.mDrawFace) {
            case 0: 
            case 4: {
                if (this.mMainImage == null) {
                    Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (src.mMainImage == null) {
                    Message.throwExceptionMessage("\u8ee2\u9001\u5143\u30ec\u30a4\u30e4\u306f\u753b\u50cf\u3092\u6301\u3063\u3066\u3044\u307e\u305b\u3093");
                }
                updated = this.mMainImage.affineBlt(this.mClipRect, src.mMainImage, srcrect, points, 0, 255, updaterect, false, type, clear, this.mNeutralColor);
                break;
            }
            case 1: {
                if (this.mMainImage == null) {
                    Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (src.mMainImage == null) {
                    Message.throwExceptionMessage("\u8ee2\u9001\u5143\u30ec\u30a4\u30e4\u306f\u753b\u50cf\u3092\u6301\u3063\u3066\u3044\u307e\u305b\u3093");
                }
                updated = this.mMainImage.affineBlt(this.mClipRect, src.mMainImage, srcrect, points, 0, 255, updaterect, this.mHoldAlpha, type, clear, this.mNeutralColor);
                break;
            }
            default: {
                Message.throwExceptionMessage("%1 \u3067\u306f\u3053\u306e face \u306b\u63cf\u753b\u3067\u304d\u307e\u305b\u3093", "affineCopy");
            }
        }
        boolean bl = this.mImageModified = updated || this.mImageModified;
        if (updated) {
            updaterect.addOffsets(this.mImageLeft, this.mImageTop);
            this.update(updaterect);
        }
    }

    public void affinePile(AffineMatrix2D matrix, LayerNI src, Rect srcrect, int opacity, int type) throws TJSException {
        Rect updaterect = new Rect();
        boolean updated = false;
        if (this.mDrawFace != 0 && this.mDrawFace != 1) {
            Message.throwExceptionMessage("%1 \u3067\u306f\u3053\u306e face \u306b\u63cf\u753b\u3067\u304d\u307e\u305b\u3093", "affinePile");
        }
        switch (this.mDrawFace) {
            case 0: {
                if (this.mMainImage == null) {
                    Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (src.mMainImage == null) {
                    Message.throwExceptionMessage("\u8ee2\u9001\u5143\u30ec\u30a4\u30e4\u306f\u753b\u50cf\u3092\u6301\u3063\u3066\u3044\u307e\u305b\u3093");
                }
                updated = this.mMainImage.affineBlt(this.mClipRect, src.mMainImage, srcrect, matrix, 3, opacity, updaterect, this.mHoldAlpha, type);
                break;
            }
            case 1: {
                if (this.mMainImage == null) {
                    Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (src.mMainImage == null) {
                    Message.throwExceptionMessage("\u8ee2\u9001\u5143\u30ec\u30a4\u30e4\u306f\u753b\u50cf\u3092\u6301\u3063\u3066\u3044\u307e\u305b\u3093");
                }
                updated = this.mMainImage.affineBlt(this.mClipRect, src.mMainImage, srcrect, matrix, 2, opacity, updaterect, this.mHoldAlpha, type);
            }
        }
        boolean bl = this.mImageModified = updated || this.mImageModified;
        if (updated) {
            updaterect.addOffsets(this.mImageLeft, this.mImageTop);
            this.update(updaterect);
        }
    }

    public void affinePile(PointD[] points, LayerNI src, Rect srcrect, int opacity, int type) throws TJSException {
        Rect updaterect = new Rect();
        boolean updated = false;
        if (this.mDrawFace != 0 && this.mDrawFace != 1) {
            Message.throwExceptionMessage("%1 \u3067\u306f\u3053\u306e face \u306b\u63cf\u753b\u3067\u304d\u307e\u305b\u3093", "affinePile");
        }
        switch (this.mDrawFace) {
            case 0: {
                if (this.mMainImage == null) {
                    Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (src.mMainImage == null) {
                    Message.throwExceptionMessage("\u8ee2\u9001\u5143\u30ec\u30a4\u30e4\u306f\u753b\u50cf\u3092\u6301\u3063\u3066\u3044\u307e\u305b\u3093");
                }
                updated = this.mMainImage.affineBlt(this.mClipRect, src.mMainImage, srcrect, points, 3, opacity, updaterect, this.mHoldAlpha, type);
                break;
            }
            case 1: {
                if (this.mMainImage == null) {
                    Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (src.mMainImage == null) {
                    Message.throwExceptionMessage("\u8ee2\u9001\u5143\u30ec\u30a4\u30e4\u306f\u753b\u50cf\u3092\u6301\u3063\u3066\u3044\u307e\u305b\u3093");
                }
                updated = this.mMainImage.affineBlt(this.mClipRect, src.mMainImage, srcrect, points, 2, opacity, updaterect, this.mHoldAlpha, type);
            }
        }
        boolean bl = this.mImageModified = updated || this.mImageModified;
        if (updated) {
            updaterect.addOffsets(this.mImageLeft, this.mImageTop);
            this.update(updaterect);
        }
    }

    public void affineBlend(AffineMatrix2D matrix, LayerNI src, Rect srcrect, int opacity, int type) throws TJSException {
        Rect updaterect = new Rect();
        boolean updated = false;
        if (this.mDrawFace != 0 && this.mDrawFace != 1) {
            Message.throwExceptionMessage("%1 \u3067\u306f\u3053\u306e face \u306b\u63cf\u753b\u3067\u304d\u307e\u305b\u3093", "affineBlend");
        }
        switch (this.mDrawFace) {
            case 0: {
                if (this.mMainImage == null) {
                    Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (src.mMainImage == null) {
                    Message.throwExceptionMessage("\u8ee2\u9001\u5143\u30ec\u30a4\u30e4\u306f\u753b\u50cf\u3092\u6301\u3063\u3066\u3044\u307e\u305b\u3093");
                }
                updated = this.mMainImage.affineBlt(this.mClipRect, src.mMainImage, srcrect, matrix, 1, opacity, updaterect, this.mHoldAlpha, type);
                break;
            }
            case 1: {
                if (this.mMainImage == null) {
                    Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (src.mMainImage == null) {
                    Message.throwExceptionMessage("\u8ee2\u9001\u5143\u30ec\u30a4\u30e4\u306f\u753b\u50cf\u3092\u6301\u3063\u3066\u3044\u307e\u305b\u3093");
                }
                updated = this.mMainImage.affineBlt(this.mClipRect, src.mMainImage, srcrect, matrix, 0, opacity, updaterect, this.mHoldAlpha, type);
            }
        }
        boolean bl = this.mImageModified = updated || this.mImageModified;
        if (updated) {
            updaterect.addOffsets(this.mImageLeft, this.mImageTop);
            this.update(updaterect);
        }
    }

    public void affineBlend(PointD[] points, LayerNI src, Rect srcrect, int opacity, int type) throws TJSException {
        Rect updaterect = new Rect();
        boolean updated = false;
        if (this.mDrawFace != 0 && this.mDrawFace != 1) {
            Message.throwExceptionMessage("%1 \u3067\u306f\u3053\u306e face \u306b\u63cf\u753b\u3067\u304d\u307e\u305b\u3093", "affineBlend");
        }
        switch (this.mDrawFace) {
            case 0: {
                if (this.mMainImage == null) {
                    Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (src.mMainImage == null) {
                    Message.throwExceptionMessage("\u8ee2\u9001\u5143\u30ec\u30a4\u30e4\u306f\u753b\u50cf\u3092\u6301\u3063\u3066\u3044\u307e\u305b\u3093");
                }
                updated = this.mMainImage.affineBlt(this.mClipRect, src.mMainImage, srcrect, points, 1, opacity, updaterect, this.mHoldAlpha, type);
                break;
            }
            case 1: {
                if (this.mMainImage == null) {
                    Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
                }
                if (src.mMainImage == null) {
                    Message.throwExceptionMessage("\u8ee2\u9001\u5143\u30ec\u30a4\u30e4\u306f\u753b\u50cf\u3092\u6301\u3063\u3066\u3044\u307e\u305b\u3093");
                }
                updated = this.mMainImage.affineBlt(this.mClipRect, src.mMainImage, srcrect, points, 0, opacity, updaterect, this.mHoldAlpha, type);
            }
        }
        boolean bl = this.mImageModified = updated || this.mImageModified;
        if (updated) {
            updaterect.addOffsets(this.mImageLeft, this.mImageTop);
            this.update(updaterect);
        }
    }

    public void operateAffine(AffineMatrix2D matrix, LayerNI src, Rect srcrect, int mode, int opacity, int type) throws TJSException {
        IntWrapper met;
        Rect updaterect = new Rect();
        boolean updated = false;
        if (mode == 128) {
            mode = src.getOperationModeFromType();
        }
        if (!this.getBltMethodFromOperationModeAndDrawFace(met = new IntWrapper(), mode)) {
            Message.throwExceptionMessage("%1 \u3067\u306f\u3053\u306e face \u306b\u63cf\u753b\u3067\u304d\u307e\u305b\u3093", "operateAffine");
        }
        if (this.mMainImage == null) {
            Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        if (src.mMainImage == null) {
            Message.throwExceptionMessage("\u8ee2\u9001\u5143\u30ec\u30a4\u30e4\u306f\u753b\u50cf\u3092\u6301\u3063\u3066\u3044\u307e\u305b\u3093");
        }
        boolean bl = this.mImageModified = (updated = this.mMainImage.affineBlt(this.mClipRect, src.mMainImage, srcrect, matrix, met.value, opacity, updaterect, this.mHoldAlpha, type)) || this.mImageModified;
        if (updated) {
            updaterect.addOffsets(this.mImageLeft, this.mImageTop);
            this.update(updaterect);
        }
    }

    public void operateAffine(PointD[] points, LayerNI src, Rect srcrect, int mode, int opacity, int type) throws TJSException {
        IntWrapper met;
        Rect updaterect = new Rect();
        boolean updated = false;
        if (mode == 128) {
            mode = src.getOperationModeFromType();
        }
        if (!this.getBltMethodFromOperationModeAndDrawFace(met = new IntWrapper(), mode)) {
            Message.throwExceptionMessage("%1 \u3067\u306f\u3053\u306e face \u306b\u63cf\u753b\u3067\u304d\u307e\u305b\u3093", "operateAffine");
        }
        if (this.mMainImage == null) {
            Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        if (src.mMainImage == null) {
            Message.throwExceptionMessage("\u8ee2\u9001\u5143\u30ec\u30a4\u30e4\u306f\u753b\u50cf\u3092\u6301\u3063\u3066\u3044\u307e\u305b\u3093");
        }
        boolean bl = this.mImageModified = (updated = this.mMainImage.affineBlt(this.mClipRect, src.mMainImage, srcrect, points, met.value, opacity, updaterect, this.mHoldAlpha, type)) || this.mImageModified;
        if (updated) {
            updaterect.addOffsets(this.mImageLeft, this.mImageTop);
            this.update(updaterect);
        }
    }

    public void doBoxBlur(int xblur, int yblur) throws TJSException {
        if (this.mMainImage == null) {
            Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        boolean updated = this.mDrawFace != 0 ? this.mMainImage.doBoxBlur(this.mClipRect, new Rect(-xblur, -yblur, xblur, yblur)) : this.mMainImage.doBoxBlurForAlpha(this.mClipRect, new Rect(-xblur, -yblur, xblur, yblur));
        boolean bl = this.mImageModified = updated || this.mImageModified;
        if (updated) {
            Rect updaterect = new Rect(this.mClipRect);
            updaterect.addOffsets(this.mImageLeft, this.mImageTop);
            this.update(updaterect);
        }
    }

    public void adjustGamma(GammaAdjustData data) throws TJSException {
        if (this.mMainImage == null) {
            Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        if (this.mDrawFace == 4) {
            this.mMainImage.adjustGammaForAdditiveAlpha(this.mClipRect, data);
        } else {
            this.mMainImage.adjustGamma(this.mClipRect, data);
        }
        this.mImageModified = true;
        this.update();
    }

    public void doGrayScale() throws TJSException {
        if (this.mMainImage == null) {
            Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        this.mMainImage.doGrayScale(this.mClipRect);
        this.mImageModified = true;
        this.update();
    }

    public void flipLR() throws TJSException {
        if (this.mMainImage == null) {
            Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        Rect r = new Rect(0, 0, this.mMainImage.getWidth(), this.mMainImage.getHeight());
        this.mMainImage.flipLR(r);
        if (this.mProvinceImage != null) {
            this.mProvinceImage.flipLR(r);
        }
        this.mImageModified = true;
        this.update();
    }

    public void flipUD() throws TJSException {
        if (this.mMainImage == null) {
            Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        Rect r = new Rect(0, 0, this.mMainImage.getWidth(), this.mMainImage.getHeight());
        this.mMainImage.flipUD(r);
        if (this.mProvinceImage != null) {
            this.mProvinceImage.flipUD(r);
        }
        this.mImageModified = true;
        this.update();
    }

    public void convertLayerType(int fromtype) throws TJSException {
        if (this.mDrawFace == 4 && fromtype == 0) {
            if (this.mMainImage != null) {
                this.mMainImage.convertAlphaToAddAlpha();
            }
        } else if (this.mDrawFace == 0 && fromtype == 4) {
            if (this.mMainImage != null) {
                this.mMainImage.convertAddAlphaToAlpha();
            }
        } else {
            Message.throwExceptionMessage("\u6307\u5b9a\u3055\u308c\u305f\u30ec\u30a4\u30e4\u30bf\u30a4\u30d7\u5909\u63db\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        this.mImageModified = true;
        this.update();
    }

    public void setCursorPos(int x, int y) {
        if (this.mManager == null) {
            return;
        }
        LayerNI p = this;
        while (p != null) {
            if (p.mParent == null) break;
            x += p.mRect.left;
            y += p.mRect.top;
            p = p.mParent;
        }
        this.mManager.setCursorPos(x, y);
    }

    public void releaseCapture() {
        if (this.mManager != null) {
            this.mManager.releaseCapture();
        }
    }

    public boolean setFocus(boolean direction) throws TJSException {
        if (this.mManager != null) {
            return this.mManager.setFocusTo(this, direction);
        }
        return false;
    }

    public LayerNI focusPrev() throws TJSException {
        if (this.mManager != null) {
            return this.mManager.focusPrev();
        }
        return null;
    }

    public LayerNI focusNext() throws TJSException {
        if (this.mManager != null) {
            return this.mManager.focusNext();
        }
        return null;
    }

    public void setMode() throws TJSException {
        if (this.mManager != null) {
            this.mManager.setModeTo(this);
        }
    }

    public void removeMode() throws TJSException {
        if (this.mManager != null) {
            this.mManager.removeModeFrom(this);
        }
    }

    public void setAttentionPoint(int l, int t) {
        this.mAttentionLeft = l;
        this.mAttentionTop = t;
        if (this.mManager != null) {
            this.mManager.notifyAttentionStateChanged(this);
        }
    }

    public void startTransition(String name, boolean withchildren, LayerNI transsource, VariantClosure options) throws TJSException {
        if (this.mInTransition) {
            Message.throwExceptionMessage("\u73fe\u5728\u306e\u30c8\u30e9\u30f3\u30b8\u30b7\u30e7\u30f3\u3092\u505c\u6b62\u3055\u305b\u3066\u304b\u3089\u65b0\u3057\u3044\u30c8\u30e9\u30f3\u30b8\u30b7\u30e7\u30f3\u3092\u958b\u59cb\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u540c\u3058\u30ec\u30a4\u30e4\u306b\u5bfe\u3057\u3066\u8907\u6570\u306e\u30c8\u30e9\u30f3\u30b8\u30b7\u30e7\u30f3\u3092\u540c\u6642\u306b\u5b9f\u884c\u3057\u3088\u3046\u3068\u3059\u308b\u3068\u3053\u306e\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3059");
        }
        if (transsource != null && transsource.mTransSrc == this) {
            Message.throwExceptionMessage("\u30c8\u30e9\u30f3\u30b8\u30b7\u30e7\u30f3\u5143\u306e\u30c8\u30e9\u30f3\u30b8\u30b7\u30e7\u30f3\u5143\u304c\u81ea\u5206\u81ea\u8eab\u3067\u3059");
        }
        TransHandlerProvider pro = null;
        SimpleOptionProviderObject sop = null;
        BaseTransHandler handler = null;
        try {
            pro = TVP.findTransHandlerProvider(name);
            Variant var = new Variant();
            this.mTransSelfUpdate = false;
            int hr = options.propGet(0, SELFUPDATE, var, null);
            if (hr >= 0 && !var.isVoid()) {
                this.mTransSelfUpdate = var.asBoolean();
            }
            this.mTransTickCallback = new VariantClosure(null, null);
            this.mUseTransTickCallback = false;
            hr = options.propGet(0, CALLBACK, var, null);
            if (hr >= 0 && !var.isVoid()) {
                this.mTransTickCallback = var.asObjectClosure();
                this.mUseTransTickCallback = true;
            }
            sop = new SimpleOptionProviderObject(options);
            int[] type = new int[]{this.mTransType, this.mTransUpdateType};
            handler = pro.startTransition(sop, TVP.SimpleImageProvider, this.mDisplayType, withchildren ? this.getWidth() : this.mMainImage.getWidth(), withchildren ? this.getHeight() : this.mMainImage.getHeight(), transsource != null ? (withchildren ? transsource.getWidth() : transsource.mMainImage.getWidth()) : 0, transsource != null ? (withchildren ? transsource.getHeight() : transsource.mMainImage.getHeight()) : 0, type);
            this.mTransType = type[0];
            this.mTransUpdateType = type[1];
            if (handler == null) {
                Message.throwExceptionMessage("\u30c8\u30e9\u30f3\u30b8\u30b7\u30e7\u30f3\u30cf\u30f3\u30c9\u30e9\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f : %1", "iTVPTransHandlerProvider::StartTransition failed");
            }
            if (this.mTransUpdateType != 0 && this.mTransUpdateType != 1 && this.mTransUpdateType != 2) {
                Message.throwExceptionMessage("\u30c8\u30e9\u30f3\u30b8\u30b7\u30e7\u30f3\u30cf\u30f3\u30c9\u30e9\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f : %1", "Unknown update type");
            }
            if (this.mTransType != 0 && this.mTransType != 1) {
                Message.throwExceptionMessage("\u30c8\u30e9\u30f3\u30b8\u30b7\u30e7\u30f3\u30cf\u30f3\u30c9\u30e9\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f : %1", "Unknown transition type");
            }
            if (this.mTransUpdateType == 2) {
                Message.throwExceptionMessage("\u30c8\u30e9\u30f3\u30b8\u30b7\u30e7\u30f3\u30cf\u30f3\u30c9\u30e9\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f : %1", "Update type of tutGiveUpdate is not yet supported");
            }
            if (this.mTransType == 1 && transsource == null) {
                Message.throwExceptionMessage("\u30c8\u30e9\u30f3\u30b8\u30b7\u30e7\u30f3\u5143\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044");
            }
            if (!withchildren) {
                if (this.mMainImage == null) {
                    Message.throwExceptionMessage("\u30c8\u30e9\u30f3\u30b8\u30b7\u30e7\u30f3\u5143\u3068\u30c8\u30e9\u30f3\u30b8\u30b7\u30e7\u30f3\u5148\u306f\u3068\u3082\u306b\u753b\u50cf\u3092\u6301\u3063\u3066\u3044\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059");
                }
                if (transsource != null && transsource.mMainImage == null) {
                    Message.throwExceptionMessage("\u30c8\u30e9\u30f3\u30b8\u30b7\u30e7\u30f3\u5143\u3068\u30c8\u30e9\u30f3\u30b8\u30b7\u30e7\u30f3\u5148\u306f\u3068\u3082\u306b\u753b\u50cf\u3092\u6301\u3063\u3066\u3044\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059");
                }
            }
            this.mTransWithChildren = withchildren;
            if (this.mTransWithChildren) {
                this.incCacheEnabledCount();
                if (transsource != null) {
                    transsource.incCacheEnabledCount();
                }
            }
            this.mTransSrc = transsource;
            if (transsource != null) {
                transsource.mTransDest = this;
            }
            if (this.mTransUpdateType == 0 || this.mTransUpdateType == 1) {
                this.mDivisibleTransHandler = (DivisibleTransHandler)handler;
            }
            if (this.mTransUpdateType == 2) {
                this.mGiveUpdateTransHandler = (GiveUpdateTransHandler)handler;
            }
            this.mTransDestObj = (Dispatch2)this.mOwner.get();
            this.mTransSrcObj = transsource != null ? (Dispatch2)transsource.mOwner.get() : null;
            this.mTransIdleCallback.Owner = this;
            if (!this.mTransSelfUpdate) {
                TVP.EventManager.addContinuousEventHook(this.mTransIdleCallback);
            }
            if (this.mUseTransTickCallback) {
                this.mTransTick = 0L;
                if (this.mDivisibleTransHandler != null) {
                    this.mDivisibleTransHandler.startProcess(this.mTransTick);
                    this.mDivisibleTransHandler.endProcess();
                } else if (this.mGiveUpdateTransHandler != null) {
                    // empty if block
                }
            } else {
                this.mTransTick = this.getTransTick();
            }
            this.mInTransition = true;
            this.mTransCompEventPrevented = false;
            this.update(true);
        }
        finally {
            pro = null;
            sop = null;
        }
    }

    public void assignImages(LayerNI src) throws TJSException {
        boolean main_changed = true;
        if (src.mMainImage != null) {
            if (this.mMainImage != null) {
                main_changed = this.mMainImage.assign(src.mMainImage);
            } else {
                this.mMainImage = new BaseBitmap(src.mMainImage);
            }
            this.mFontChanged = true;
        } else {
            this.deallocateImage();
        }
        if (src.mProvinceImage != null) {
            if (this.mProvinceImage != null) {
                this.mProvinceImage.assign(src.mProvinceImage);
            } else {
                this.mProvinceImage = new BaseBitmap(src.mProvinceImage);
            }
        } else {
            this.deallocateProvinceImage();
        }
        if (main_changed && this.mMainImage != null) {
            this.internalSetImageSize(this.mMainImage.getWidth(), this.mMainImage.getHeight());
        }
        this.mImageModified = true;
        if (this.mMainImage != null) {
            this.resetClip();
        }
        if (main_changed) {
            this.update(false);
        }
    }

    private final String getTypeNameString() {
        switch (this.mType) {
            case 0: {
                return "ltBinder";
            }
            case 1: {
                return "ltOpaque";
            }
            case 2: {
                return "ltAlpha";
            }
            case 3: {
                return "ltAdditive";
            }
            case 4: {
                return "ltSubtractive";
            }
            case 5: {
                return "ltMultiplicative";
            }
            case 6: {
                return "ltEffect";
            }
            case 7: {
                return "ltFilter";
            }
            case 8: {
                return "ltDodge";
            }
            case 9: {
                return "ltDarken";
            }
            case 10: {
                return "ltLighten";
            }
            case 11: {
                return "ltScreen";
            }
            case 12: {
                return "ltAddAlpha";
            }
            case 13: {
                return "PsNormal";
            }
            case 14: {
                return "PsAdditive";
            }
            case 15: {
                return "PsSubtractive";
            }
            case 16: {
                return "PsMultiplicative";
            }
            case 17: {
                return "PsScreen";
            }
            case 18: {
                return "PsOverlay";
            }
            case 19: {
                return "PsHardLight";
            }
            case 20: {
                return "PsSoftLight";
            }
            case 21: {
                return "PsColorDodge";
            }
            case 22: {
                return "PsColorDodge5";
            }
            case 23: {
                return "PsColorBurn";
            }
            case 24: {
                return "PsLighten";
            }
            case 25: {
                return "PsDarken";
            }
            case 26: {
                return "PsDifference";
            }
            case 27: {
                return "PsDifference5";
            }
            case 28: {
                return "PsExclusion";
            }
        }
        return "unknown";
    }

    public void dumpStructure() {
        this.dumpStructure(0);
    }

    public void dumpStructure(int level) {
        char[] indent = new char[level * 2];
        StringBuilder builder = new StringBuilder(256);
        int i = 0;
        while (i < level * 2) {
            indent[i] = 32;
            ++i;
        }
        String name = this.mName;
        if (name == null || name.length() == 0) {
            name = "<noname>";
        }
        builder.append(indent);
        builder.append(name);
        builder.append(String.format(" (object 0x%x)", this.mOwner.hashCode()));
        builder.append(String.format(" (native 0x%x)", this.hashCode()));
        builder.append(" (");
        builder.append(this.mRect.left);
        builder.append(',');
        builder.append(this.mRect.top);
        builder.append(")-(");
        builder.append(this.mRect.right);
        builder.append(",");
        builder.append(this.mRect.bottom);
        builder.append(") (");
        builder.append(this.mRect.width());
        builder.append("x");
        builder.append(this.mRect.height());
        builder.append(")");
        builder.append(" ");
        builder.append(this.getVisible() ? "visible" : "invisible");
        builder.append(" index=");
        builder.append(this.getAbsoluteOrderIndex());
        builder.append(this.mProvinceImage != null ? " p" : "");
        builder.append(" ");
        builder.append(this.getTypeNameString());
        DebugClass.addLog(builder.toString());
        ++level;
        int count = this.mChildren.getCount();
        int i2 = 0;
        while (i2 < count) {
            LayerNI child = this.mChildren.get(i2);
            if (child != null) {
                child.dumpStructure(level);
            }
            ++i2;
        }
    }

    public void dumpStructureEx() {
        this.dumpStructureEx(0);
    }

    public void dumpStructureEx(int level) {
        char[] indent = new char[level * 2];
        StringBuilder builder = new StringBuilder(256);
        int i = 0;
        while (i < level * 2) {
            indent[i] = 32;
            ++i;
        }
        String filename = String.valueOf(this.mName) + ".png";
        String name = this.mName;
        if (name == null || name.length() == 0) {
            name = "<noname>";
            filename = "noname_" + this.getAbsoluteOrderIndex() + ".png";
        }
        builder.append(indent);
        builder.append(name);
        builder.append(String.format(" (object 0x%x)", this.mOwner.hashCode()));
        builder.append(String.format(" (native 0x%x)", this.hashCode()));
        builder.append(" (");
        builder.append(this.mRect.left);
        builder.append(',');
        builder.append(this.mRect.top);
        builder.append(")-(");
        builder.append(this.mRect.right);
        builder.append(",");
        builder.append(this.mRect.bottom);
        builder.append(") (");
        builder.append(this.mRect.width());
        builder.append("x");
        builder.append(this.mRect.height());
        builder.append(")");
        builder.append(" ");
        builder.append(this.getVisible() ? "visible" : "invisible");
        builder.append(" index=");
        builder.append(this.getAbsoluteOrderIndex());
        builder.append(this.mProvinceImage != null ? " p" : "");
        builder.append(" ");
        builder.append(this.getTypeNameString());
        try {
            this.saveLayerImage(filename, "png");
        }
        catch (TJSException e) {
            builder.append(" file save error:" + e.getMessage());
        }
        DebugClass.addLog(builder.toString());
        ++level;
        int count = this.mChildren.getCount();
        int i2 = 0;
        while (i2 < count) {
            LayerNI child = this.mChildren.get(i2);
            if (child != null) {
                child.dumpStructureEx(level);
            }
            ++i2;
        }
    }

    public void setHitTestWork(boolean b) {
        this.mOnHitTest_Work = b;
    }

    private LayerNI getNeighborAbove(boolean loop) {
        if (this.mManager == null) {
            return null;
        }
        int index = this.getOverallOrderIndex();
        ArrayList<LayerNI> allnodes = this.mManager.getAllNodes();
        if (allnodes.size() == 0) {
            return null;
        }
        if (index == 0) {
            if (loop) {
                return allnodes.get(allnodes.size() - 1);
            }
            return null;
        }
        return allnodes.get(index - 1);
    }

    public LayerNI getPrevFocusableInternal() {
        LayerNI p = this;
        LayerNI current = this;
        if (current == (p = p.getNeighborAbove(true))) {
            return null;
        }
        if (p == null) {
            return null;
        }
        current = p;
        do {
            if (!p.getNodeFocusable() || !p.mJoinFocusChain) continue;
            return p;
        } while ((p = p.getNeighborAbove(true)) != null && p != current);
        return null;
    }

    public LayerNI getPrevFocusable() {
        this.mFocusWork = this.getPrevFocusableInternal();
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (!(owner == null || this.mShutdown || this.mFocusWork != null && this.mFocusWork.mOwner == null)) {
            Variant[] param = new Variant[]{this.mFocusWork != null ? new Variant((Dispatch2)this.mFocusWork.mOwner.get(), (Dispatch2)this.mFocusWork.mOwner.get()) : new Variant(null, null)};
            TVP.EventManager.postEvent(owner, owner, ON_SEARCH_PREV_FOCUSABLE, 0, 2, param);
        }
        return this.mFocusWork;
    }

    public LayerNI searchFirstFocusable() {
        return this.searchFirstFocusable(true);
    }

    public LayerNI searchFirstFocusable(boolean ignore_chain_focusable) {
        if (ignore_chain_focusable ? this.getNodeFocusable() : this.getNodeFocusable() && this.mJoinFocusChain) {
            return this;
        }
        int count = this.mChildren.getCount();
        int i = 0;
        while (i < count) {
            LayerNI lay;
            LayerNI child = this.mChildren.get(i);
            if (child != null && (lay = child.searchFirstFocusable(ignore_chain_focusable)) != null) {
                return lay;
            }
            ++i;
        }
        return null;
    }

    public void fromPrimaryCoordinates(int[] x, int[] y) {
        LayerNI l = this;
        while (l != null && !l.isPrimary()) {
            x[0] = x[0] - l.mRect.left;
            y[0] = y[0] - l.mRect.top;
            l = l.mParent;
        }
    }

    public void fireClick(int x, int y) {
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner != null && !this.mShutdown) {
            Variant[] param = new Variant[]{new Variant(x), new Variant(y)};
            TVP.EventManager.postEvent(owner, owner, ON_CLICK, 0, 2, param);
        }
    }

    public void fireDoubleClick(int x, int y) {
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner != null && !this.mShutdown) {
            Variant[] param = new Variant[]{new Variant(x), new Variant(y)};
            TVP.EventManager.postEvent(owner, owner, ON_DOUBLE_CLICK, 0, 2, param);
        }
    }

    public void fireMouseDown(int x, int y, int mb, int flags) {
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner != null && !this.mShutdown) {
            Variant[] param = new Variant[]{new Variant(x), new Variant(y), new Variant(mb), new Variant(flags)};
            TVP.EventManager.postEvent(owner, owner, ON_MOUSE_DOWN, 0, 2, param);
        }
    }

    public void fireMouseUp(int x, int y, int mb, int flags) {
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner != null && !this.mShutdown) {
            Variant[] param = new Variant[]{new Variant(x), new Variant(y), new Variant(mb), new Variant(flags)};
            TVP.EventManager.postEvent(owner, owner, ON_MOUSE_UP, 0, 2, param);
        }
    }

    public void fireMouseMove(int x, int y, int flags) {
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner != null && !this.mShutdown) {
            Variant[] param = new Variant[]{new Variant(x), new Variant(y), new Variant(flags)};
            TVP.EventManager.postEvent(owner, owner, ON_MOUSE_MOVE, 0, 18, param);
        }
    }

    public void fireMouseEnter() {
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner != null && !this.mShutdown) {
            TVP.EventManager.postEvent(owner, owner, ON_MOUSE_ENTER, 0, 2, TJS.NULL_ARG);
        }
    }

    public void fireMouseLeave() {
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner != null && !this.mShutdown) {
            TVP.EventManager.postEvent(owner, owner, ON_MOUSE_LEAVE, 0, 2, TJS.NULL_ARG);
        }
    }

    private int getLayerActiveCursor() {
        int cursor = this.mCursor;
        LayerNI p = this;
        while (cursor == 0) {
            p = p.mParent;
            if (p == null) break;
            cursor = p.mCursor;
        }
        return cursor;
    }

    public void setCurrentCursorToWindow() {
        if (this.mManager != null) {
            this.mManager.setMouseCursor(this.getLayerActiveCursor());
        }
    }

    public void setCurrentHintToWindow() {
        if (this.mManager != null) {
            LayerNI p = this;
            while (p.mShowParentHint) {
                if (p.mParent == null) break;
                p = p.mParent;
            }
            this.mManager.setHint(p.mHint);
        }
    }

    public void fireKeyDown(int key, int shift) {
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner != null && !this.mShutdown) {
            Variant[] param = new Variant[]{new Variant(key), new Variant(shift), new Variant(1)};
            TVP.EventManager.postEvent(owner, owner, ON_KEY_DOWN, 0, 2, param);
        }
    }

    public void defaultKeyDown(int key, int shift) throws TJSException {
        boolean no_shift_downed;
        if (this.mManager == null) {
            return;
        }
        boolean bl = no_shift_downed = (shift & 1) == 0 && (shift & 2) == 0 && (shift & 4) == 0;
        if ((key == 9 || key == 39 || key == 40) && no_shift_downed) {
            this.mManager.focusNext();
        } else if (key == 9 && (shift & 1) != 0 && (shift & 2) == 0 && (shift & 4) == 0 || key == 37 || key == 38) {
            this.mManager.focusPrev();
        } else if ((key == 10 || key == 27) && no_shift_downed && this.mParent != null && this.mParent.getNodeEnabled()) {
            this.mParent.fireKeyDown(key, shift);
        }
    }

    public void fireKeyUp(int key, int shift) {
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner != null && !this.mShutdown) {
            Variant[] param = new Variant[]{new Variant(key), new Variant(shift), new Variant(1)};
            TVP.EventManager.postEvent(owner, owner, ON_KEY_UP, 0, 2, param);
        }
    }

    public void defaultKeyUp(int key, int shift) {
        boolean no_shift_downed;
        if (this.mManager == null) {
            return;
        }
        boolean bl = no_shift_downed = (shift & 1) == 0 && (shift & 2) == 0 && (shift & 4) == 0;
        if ((key == 10 || key == 27) && no_shift_downed && this.mParent != null && this.mParent.getNodeEnabled()) {
            this.mParent.fireKeyUp(key, shift);
        }
    }

    public void fireKeyPress(char key) {
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner != null && !this.mShutdown) {
            Variant[] param = new Variant[]{new Variant(String.valueOf(key)), new Variant(1)};
            TVP.EventManager.postEvent(owner, owner, ON_KEY_PRESS, 0, 2, param);
        }
    }

    public void defaultKeyPress(char key) {
        if (this.mManager == null) {
            return;
        }
        if ((key == '\r' || key == '\u001b') && this.mParent != null && this.mParent.getNodeEnabled()) {
            this.mParent.fireKeyPress(key);
        }
    }

    public void fireMouseWheel(int shift, int delta, int x, int y) {
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner != null && !this.mShutdown) {
            Variant[] val = new Variant[]{new Variant(shift), new Variant(delta), new Variant(x), new Variant(y)};
            TVP.EventManager.postEvent(owner, owner, ON_MOUSE_WHEEL, 0, 2, val);
        }
    }

    public void setFocusWork(LayerNI lay) {
        this.mFocusWork = lay;
    }

    public void setParent(LayerNI parent) throws TJSException {
        this.join(parent);
    }

    public Dispatch2 getChildrenArrayObject() throws VariantException, TJSException {
        if (this.mChildrenArray == null) {
            Holder<Object> classobj = new Holder<Object>(null);
            this.mChildrenArray = TJS.createArrayObject(classobj);
            try {
                Variant val = new Variant();
                int er = ((Dispatch2)classobj.mValue).propGet(0, "clear", val, (Dispatch2)classobj.mValue);
                if (er < 0) {
                    Message.throwExceptionMessage("\u5185\u90e8\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f: at %1 line %2");
                }
                this.mArrayClearMethod = val.asObject();
            }
            catch (TJSException e) {
                this.mChildrenArray = null;
                classobj = null;
                throw e;
            }
            classobj = null;
        }
        if (!this.mChildrenArrayValid) {
            this.mArrayClearMethod.funcCall(0, null, null, TJS.NULL_ARG, this.mChildrenArray);
            int total = this.mChildren.getCount();
            int count = 0;
            int i = 0;
            while (i < total) {
                LayerNI child = this.mChildren.get(i);
                if (child != null) {
                    Dispatch2 dsp = (Dispatch2)child.mOwner.get();
                    Variant val = new Variant(dsp, dsp);
                    this.mChildrenArray.propSetByNum(512, count, val, this.mChildrenArray);
                    ++count;
                }
                ++i;
            }
            this.mChildrenArrayValid = true;
        }
        return this.mChildrenArray;
    }

    public boolean getAbsoluteOrderMode() {
        return this.mAbsoluteOrderMode;
    }

    boolean getCached() {
        return this.mCached;
    }

    public WindowNI getWindow() {
        if (this.mManager == null) {
            return null;
        }
        return this.mManager.getWindow();
    }

    public void setLeft(int left) throws TJSException {
        if (this.mRect.left != left) {
            boolean visible;
            boolean bl = visible = this.getVisible() || this.getNodeVisible();
            if (this.isPrimary() && left != 0) {
                Message.throwExceptionMessage("\u30d7\u30e9\u30a4\u30de\u30ea\u30ec\u30a4\u30e4\u306f\u79fb\u52d5\u3067\u304d\u307e\u305b\u3093");
            }
            if (visible) {
                this.parentUpdate();
            }
            int w = this.mRect.width();
            this.mRect.left = left;
            this.mRect.right = w + this.mRect.left;
            if (this.mParent != null) {
                this.mParent.notifyChildrenVisualStateChanged();
            }
            if (visible) {
                this.parentUpdate();
            }
        }
    }

    public void setTop(int top) throws TJSException {
        if (this.mRect.top != top) {
            boolean visible;
            boolean bl = visible = this.getVisible() || this.getNodeVisible();
            if (this.isPrimary() && top != 0) {
                Message.throwExceptionMessage("\u30d7\u30e9\u30a4\u30de\u30ea\u30ec\u30a4\u30e4\u306f\u79fb\u52d5\u3067\u304d\u307e\u305b\u3093");
            }
            if (visible) {
                this.parentUpdate();
            }
            int h = this.mRect.height();
            this.mRect.top = top;
            this.mRect.bottom = h + this.mRect.top;
            if (this.mParent != null) {
                this.mParent.notifyChildrenVisualStateChanged();
            }
            if (visible) {
                this.parentUpdate();
            }
        }
    }

    public int getImageLeft() throws TJSException {
        if (this.mMainImage == null) {
            Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        return this.mImageLeft;
    }

    public void setImageLeft(int left) throws TJSException {
        if (this.mMainImage == null) {
            Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        if (this.mImageLeft != left) {
            if (left > 0) {
                Message.throwExceptionMessage("\u30ec\u30a4\u30e4\u9818\u57df\u306b\u753b\u50cf\u306e\u7121\u3044\u9818\u57df\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
            }
            if (this.mMainImage.getWidth() + left < this.mRect.width()) {
                Message.throwExceptionMessage("\u30ec\u30a4\u30e4\u9818\u57df\u306b\u753b\u50cf\u306e\u7121\u3044\u9818\u57df\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
            }
            this.mImageLeft = left;
            this.update();
        }
    }

    public int getImageTop() throws TJSException {
        if (this.mMainImage == null) {
            Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        return this.mImageTop;
    }

    public void setImageTop(int top) throws TJSException {
        if (this.mMainImage == null) {
            Message.throwExceptionMessage("\u3053\u306e type \u306e\u30ec\u30a4\u30e4\u3067\u306f\u63cf\u753b\u3084\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u3084\u753b\u50cf\u30b5\u30a4\u30ba/\u4f4d\u7f6e\u306e\u5909\u66f4/\u53d6\u5f97\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        if (this.mImageTop != top) {
            if (top > 0) {
                Message.throwExceptionMessage("\u30ec\u30a4\u30e4\u9818\u57df\u306b\u753b\u50cf\u306e\u7121\u3044\u9818\u57df\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
            }
            if (this.mMainImage.getHeight() + top < this.mRect.height()) {
                Message.throwExceptionMessage("\u30ec\u30a4\u30e4\u9818\u57df\u306b\u753b\u50cf\u306e\u7121\u3044\u9818\u57df\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
            }
            this.mImageTop = top;
            this.update();
        }
    }

    public int getType() {
        return this.mType;
    }

    public void setType(int type) throws TJSException {
        if (this.mType != type) {
            this.mType = type;
            switch (this.mType) {
                case 0: {
                    this.mTransparentColor = 0xFFFFFF;
                    this.mNeutralColor = 0xFFFFFF;
                    this.mDisplayType = this.mType;
                    this.mCanHaveImage = false;
                    this.deallocateImage();
                    break;
                }
                case 1: {
                    this.mTransparentColor = 0xFFFFFF;
                    this.mNeutralColor = 0xFFFFFF;
                    this.mDisplayType = this.mType;
                    this.mCanHaveImage = true;
                    this.allocateImage();
                    break;
                }
                case 2: {
                    this.mTransparentColor = 0xFFFFFF;
                    this.mNeutralColor = 0xFFFFFF;
                    this.mDisplayType = this.mType;
                    this.mCanHaveImage = true;
                    this.allocateImage();
                    break;
                }
                case 3: {
                    this.mTransparentColor = 0;
                    this.mNeutralColor = 0;
                    this.mDisplayType = this.mType;
                    this.mCanHaveImage = true;
                    this.allocateImage();
                    break;
                }
                case 4: {
                    this.mTransparentColor = 0xFFFFFF;
                    this.mNeutralColor = 0xFFFFFF;
                    this.mDisplayType = this.mType;
                    this.mCanHaveImage = true;
                    this.allocateImage();
                    break;
                }
                case 5: {
                    this.mTransparentColor = 0xFFFFFF;
                    this.mNeutralColor = 0xFFFFFF;
                    this.mDisplayType = this.mType;
                    this.mCanHaveImage = true;
                    this.allocateImage();
                    break;
                }
                case 6: {
                    this.mTransparentColor = 0xFFFFFF;
                    this.mNeutralColor = 0xFFFFFF;
                    this.mDisplayType = 0;
                    this.mCanHaveImage = false;
                    this.deallocateImage();
                    break;
                }
                case 7: {
                    this.mTransparentColor = 0xFFFFFF;
                    this.mNeutralColor = 0xFFFFFF;
                    this.mDisplayType = 0;
                    this.mCanHaveImage = false;
                    this.deallocateImage();
                    break;
                }
                case 8: {
                    this.mTransparentColor = 0;
                    this.mNeutralColor = 0;
                    this.mDisplayType = this.mType;
                    this.mCanHaveImage = true;
                    this.allocateImage();
                    break;
                }
                case 9: {
                    this.mTransparentColor = 0xFFFFFF;
                    this.mNeutralColor = 0xFFFFFF;
                    this.mDisplayType = this.mType;
                    this.mCanHaveImage = true;
                    this.allocateImage();
                    break;
                }
                case 10: {
                    this.mTransparentColor = 0;
                    this.mNeutralColor = 0;
                    this.mDisplayType = this.mType;
                    this.mCanHaveImage = true;
                    this.allocateImage();
                    break;
                }
                case 11: {
                    this.mTransparentColor = 0;
                    this.mNeutralColor = 0;
                    this.mDisplayType = this.mType;
                    this.mCanHaveImage = true;
                    this.allocateImage();
                    break;
                }
                case 12: {
                    this.mTransparentColor = 0;
                    this.mNeutralColor = 0;
                    this.mDisplayType = this.mType;
                    this.mCanHaveImage = true;
                    this.allocateImage();
                    break;
                }
                case 13: {
                    this.mTransparentColor = 0;
                    this.mNeutralColor = 0;
                    this.mDisplayType = this.mType;
                    this.mCanHaveImage = true;
                    this.allocateImage();
                    break;
                }
                case 14: {
                    this.mTransparentColor = 0;
                    this.mNeutralColor = 0;
                    this.mDisplayType = this.mType;
                    this.mCanHaveImage = true;
                    this.allocateImage();
                    break;
                }
                case 15: {
                    this.mTransparentColor = 0xFFFFFF;
                    this.mNeutralColor = 0xFFFFFF;
                    this.mDisplayType = this.mType;
                    this.mCanHaveImage = true;
                    this.allocateImage();
                    break;
                }
                case 16: {
                    this.mTransparentColor = 0xFFFFFF;
                    this.mNeutralColor = 0xFFFFFF;
                    this.mDisplayType = this.mType;
                    this.mCanHaveImage = true;
                    this.allocateImage();
                    break;
                }
                case 17: {
                    this.mTransparentColor = 0;
                    this.mNeutralColor = 0;
                    this.mDisplayType = this.mType;
                    this.mCanHaveImage = true;
                    this.allocateImage();
                    break;
                }
                case 18: {
                    this.mTransparentColor = 0x808080;
                    this.mNeutralColor = 0x808080;
                    this.mDisplayType = this.mType;
                    this.mCanHaveImage = true;
                    this.allocateImage();
                    break;
                }
                case 19: {
                    this.mTransparentColor = 0x808080;
                    this.mNeutralColor = 0x808080;
                    this.mDisplayType = this.mType;
                    this.mCanHaveImage = true;
                    this.allocateImage();
                    break;
                }
                case 20: {
                    this.mTransparentColor = 0x808080;
                    this.mNeutralColor = 0x808080;
                    this.mDisplayType = this.mType;
                    this.mCanHaveImage = true;
                    this.allocateImage();
                    break;
                }
                case 21: {
                    this.mTransparentColor = 0;
                    this.mNeutralColor = 0;
                    this.mDisplayType = this.mType;
                    this.mCanHaveImage = true;
                    this.allocateImage();
                    break;
                }
                case 22: {
                    this.mTransparentColor = 0;
                    this.mNeutralColor = 0;
                    this.mDisplayType = this.mType;
                    this.mCanHaveImage = true;
                    this.allocateImage();
                    break;
                }
                case 23: {
                    this.mTransparentColor = 0xFFFFFF;
                    this.mNeutralColor = 0xFFFFFF;
                    this.mDisplayType = this.mType;
                    this.mCanHaveImage = true;
                    this.allocateImage();
                    break;
                }
                case 24: {
                    this.mTransparentColor = 0;
                    this.mNeutralColor = 0;
                    this.mDisplayType = this.mType;
                    this.mCanHaveImage = true;
                    this.allocateImage();
                    break;
                }
                case 25: {
                    this.mTransparentColor = 0xFFFFFF;
                    this.mNeutralColor = 0xFFFFFF;
                    this.mDisplayType = this.mType;
                    this.mCanHaveImage = true;
                    this.allocateImage();
                    break;
                }
                case 26: {
                    this.mTransparentColor = 0;
                    this.mNeutralColor = 0;
                    this.mDisplayType = this.mType;
                    this.mCanHaveImage = true;
                    this.allocateImage();
                    break;
                }
                case 27: {
                    this.mTransparentColor = 0;
                    this.mNeutralColor = 0;
                    this.mDisplayType = this.mType;
                    this.mCanHaveImage = true;
                    this.allocateImage();
                    break;
                }
                case 28: {
                    this.mTransparentColor = 0;
                    this.mNeutralColor = 0;
                    this.mDisplayType = this.mType;
                    this.mCanHaveImage = true;
                    this.allocateImage();
                }
            }
            this.notifyLayerTypeChange();
            this.setToCreateExposedRegion();
            this.update();
        }
    }

    private void allocateImage() throws TJSException {
        if (this.mMainImage == null) {
            this.mImageLeft = 0;
            this.mImageTop = 0;
            this.mMainImage = new BaseBitmap(this.mRect.width(), this.mRect.height(), 32);
            this.mMainImage.fill(new Rect(0, 0, this.mRect.width(), this.mRect.height()), this.mNeutralColor);
            this.mMainImage.setFont(this.mFont);
        }
        if (this.mMainImage != null) {
            this.resetClip();
        }
        if (this.mProvinceImage != null) {
            this.mProvinceImage.setSizeWithFill(this.mMainImage.getWidth(), this.mMainImage.getHeight(), 0);
        }
        this.mFontChanged = true;
        this.mImageModified = true;
    }

    private void notifyLayerTypeChange() {
        this.updateDrawFace();
        if (this.mParent != null) {
            this.mParent.notifyLayerTypeChange();
        }
    }

    public int getFace() {
        return this.mFace;
    }

    public void setFace(int f) {
        this.mFace = f;
        this.updateDrawFace();
    }

    public boolean getHoldAlpha() {
        return this.mHoldAlpha;
    }

    public void setHoldAlpha(boolean b) {
        this.mHoldAlpha = b;
    }

    public int getClipLeft() {
        return this.mClipRect.left;
    }

    public void setClipLeft(int left) throws TJSException {
        this.setClip(left, this.getClipTop(), this.getClipWidth(), this.getClipHeight());
    }

    int getClipHeight() {
        return this.mClipRect.bottom - this.mClipRect.top;
    }

    int getClipWidth() {
        return this.mClipRect.right - this.mClipRect.left;
    }

    int getClipTop() {
        return this.mClipRect.top;
    }

    public void setClipTop(int top) throws TJSException {
        this.setClip(this.getClipLeft(), top, this.getClipWidth(), this.getClipHeight());
    }

    public void setClipWidth(int width) throws TJSException {
        this.setClip(this.getClipLeft(), this.getClipTop(), width, this.getClipHeight());
    }

    public void setClipHeight(int height) throws TJSException {
        this.setClip(this.getClipLeft(), this.getClipTop(), this.getClipWidth(), height);
    }

    public boolean getImageModified() {
        return this.mImageModified;
    }

    public void setImageModified(boolean b) {
        this.mImageModified = b;
    }

    public int getHitType() {
        return this.mHitType;
    }

    public void setHitType(int type) {
        this.mHitType = type;
    }

    public int getHitThreshold() {
        return this.mHitThreshold;
    }

    public void setHitThreshold(int t) {
        this.mHitThreshold = t;
    }

    public int getCursor() {
        return this.mCursor;
    }

    public void setCursorByStorage(String storage) throws TJSException {
        WindowNI win = this.getWindow();
        if (win != null) {
            WindowForm form = win.getForm();
            if (form != null) {
                this.mCursor = TVP.MouseCursor.getCursor(form, storage);
            } else {
                Message.throwExceptionMessage("\u30de\u30a6\u30b9\u30ab\u30fc\u30bd\u30eb %1 \u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", storage);
            }
        } else {
            Message.throwExceptionMessage("\u30de\u30a6\u30b9\u30ab\u30fc\u30bd\u30eb %1 \u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", storage);
        }
        if (this.mManager != null) {
            this.mManager.notifyMouseCursorChange(this, this.getLayerActiveCursor());
        }
    }

    public void setCursorByNumber(int num) throws TJSException {
        this.mCursor = num;
        if (this.mManager != null) {
            this.mManager.notifyMouseCursorChange(this, this.getLayerActiveCursor());
        }
    }

    public int getCursorX() {
        if (this.mManager == null) {
            return 0;
        }
        Point pt = new Point(0, 0);
        this.mManager.getCursorPos(pt);
        int x = pt.x;
        LayerNI p = this;
        while (p != null) {
            if (p.mParent == null) break;
            x -= p.mRect.left;
            p = p.mParent;
        }
        return x;
    }

    public void setCursorX(int x) {
        this.mCursorX_Work = x;
    }

    public int getCursorY() {
        if (this.mManager == null) {
            return 0;
        }
        Point pt = new Point(0, 0);
        this.mManager.getCursorPos(pt);
        int y = pt.y;
        LayerNI p = this;
        while (p != null) {
            if (p.mParent == null) break;
            y -= p.mRect.left;
            p = p.mParent;
        }
        return y;
    }

    public void setCursorY(int y) {
        if (this.mManager == null) {
            return;
        }
        int x = this.mCursorX_Work;
        LayerNI p = this;
        while (p != null) {
            if (p.mParent == null) break;
            x += p.mRect.left;
            y += p.mRect.top;
            p = p.mParent;
        }
        this.mManager.setCursorPos(x, y);
    }

    public String getHint() {
        return this.mHint;
    }

    public void setHint(String hint) throws TJSException {
        this.mShowParentHint = false;
        this.mHint = hint;
        if (this.mManager != null) {
            this.mManager.notifyHintChange(this, hint);
        }
    }

    public boolean getShowParentHint() {
        return this.mShowParentHint;
    }

    public void setShowParentHint(boolean b) {
        this.mShowParentHint = b;
    }

    public boolean getFocusable() {
        return this.mFocusable;
    }

    public void setFocusable(boolean b) throws TJSException {
        if (this.mFocusable != b) {
            boolean bstate = this.getNodeFocusable();
            this.mFocusable = b;
            boolean astate = this.getNodeFocusable();
            if (bstate != astate && !astate && this.mManager != null && this.mManager.getFocusedLayer() == this) {
                this.mManager.setFocusTo(this.getNextFocusable(), true);
            }
        }
    }

    public boolean getJoinFocusChain() {
        return this.mJoinFocusChain;
    }

    public void setJoinFocusChain(boolean b) {
        this.mJoinFocusChain = b;
    }

    public boolean getFocused() {
        if (this.mManager == null) {
            return false;
        }
        return this.mManager.getFocusedLayer() == this;
    }

    public void setEnabled(boolean b) throws TJSException {
        if (this.mEnabled != b) {
            if (this.mManager != null) {
                this.mManager.saveEnabledWork();
            }
            try {
                this.mEnabled = b;
                if (this.mEnabled) {
                    if (this.mManager != null) {
                        this.mManager.checkTreeFocusableState(this);
                    }
                } else if (this.mManager != null) {
                    this.mManager.blurTree(this);
                }
            }
            finally {
                if (this.mManager != null) {
                    this.mManager.notifyNodeEnabledState();
                }
            }
        }
    }

    public void setAttentionLeft(int l) {
        this.mAttentionLeft = l;
        if (this.mManager != null) {
            this.mManager.notifyAttentionStateChanged(this);
        }
    }

    public void setAttentionTop(int t) {
        this.mAttentionTop = t;
        if (this.mManager != null) {
            this.mManager.notifyAttentionStateChanged(this);
        }
    }

    public void setUseAttention(boolean b) {
        int n = this.mUseAttention = b ? 1 : 0;
        if (this.mManager != null) {
            this.mManager.notifyAttentionStateChanged(this);
        }
    }

    public void setImeMode(int mode) {
        this.mImeMode = mode;
        if (this.mManager != null) {
            this.mManager.notifyImeModeChanged(this);
        }
    }

    public boolean getCallOnPaint() {
        return this.mCallOnPaint;
    }

    public void setCallOnPaint(boolean b) {
        this.mCallOnPaint = b;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public int getNeutralColor() {
        return this.mNeutralColor;
    }

    public void setNeutralColor(int color) {
        this.mNeutralColor = color;
    }

    public boolean getHasImage() {
        return this.mMainImage != null;
    }

    public void setHasImage(boolean b) throws TJSException {
        if (!this.mCanHaveImage && b) {
            Message.throwExceptionMessage("\u3053\u306e\u30ec\u30a4\u30e4\u306f\u753b\u50cf\u3092\u6301\u3064\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        if (b) {
            this.allocateImage();
        } else {
            this.deallocateImage();
        }
        this.notifyChildrenVisualStateChanged();
        this.update();
    }

    public void purgeImage() {
        this.mMainImage.purgeImage();
    }

    public String toString() {
        if (this.mName != null) {
            return "Layer - " + this.mName;
        }
        return "Layer - no name";
    }

    static class CompleteDrawable
    implements Drawable {
        BaseBitmap Bitmap;
        int LayerType;

        public CompleteDrawable(BaseBitmap bmp, int layertype) {
            this.Bitmap = bmp;
            this.LayerType = layertype;
        }

        @Override
        public BaseBitmap getDrawTargetBitmap(Rect rect, Rect cliprect) {
            cliprect.set(rect);
            return this.Bitmap;
        }

        @Override
        public int getTargetLayerType() {
            return this.LayerType;
        }

        @Override
        public void drawCompleted(Rect destrect, BaseBitmap bmp, Rect cliprect, int type, int opacity) throws TJSException {
            if (bmp != this.Bitmap) {
                this.Bitmap.copyRect(destrect.left, destrect.top, bmp, cliprect);
            }
        }
    }

    static class TransDrawable
    implements Drawable {
        LayerNI Owner;
        BaseBitmap Target;
        Rect TargetRect = new Rect();
        Drawable OrgDrawable;
        BaseBitmap Src1Bmp;
        BaseBitmap Src2Bmp;

        public void init(LayerNI owner, Drawable org) {
            this.Owner = owner;
            this.OrgDrawable = org;
            this.Target = null;
        }

        @Override
        public BaseBitmap getDrawTargetBitmap(Rect rect, Rect cliprect) throws TJSException {
            this.Target = this.OrgDrawable.getDrawTargetBitmap(rect, cliprect);
            this.TargetRect.set(cliprect);
            return this.Target;
        }

        @Override
        public int getTargetLayerType() {
            return this.OrgDrawable.getTargetLayerType();
        }

        @Override
        public void drawCompleted(Rect destrect, BaseBitmap bmp, Rect cliprect, int type, int opacity) throws VariantException, TJSException {
            BaseBitmap dest;
            if (!this.Owner.mInTransition || this.Owner.mDivisibleTransHandler == null) {
                return;
            }
            DivisibleData data = new DivisibleData();
            data.Left = destrect.left - ((LayerNI)this.Owner).mRect.left;
            data.Top = destrect.top - ((LayerNI)this.Owner).mRect.top;
            data.Width = cliprect.width();
            data.Height = cliprect.height();
            BaseBitmap src1bmp = this.Owner.mTransUpdateType == 1 ? this.Src1Bmp : bmp;
            this.Owner.mImageModified = true;
            if (this.Owner.mSrcSLP == null) {
                this.Owner.mSrcSLP = new ScanLineProviderForBaseBitmap(src1bmp);
            } else {
                this.Owner.mSrcSLP.attach(src1bmp);
            }
            data.Src1 = this.Owner.mSrcSLP;
            data.Src1Left = cliprect.left;
            data.Src1Top = cliprect.top;
            BaseBitmap src = null;
            if (this.Owner.mTransSrc != null) {
                src = this.Owner.mTransUpdateType == 1 ? this.Src2Bmp : this.Owner.mTransSrc.complete(destrect);
                if (this.Owner.mTransSrc.mSrcSLP == null) {
                    this.Owner.mTransSrc.mSrcSLP = new ScanLineProviderForBaseBitmap(src);
                } else {
                    this.Owner.mTransSrc.mSrcSLP.attach(src);
                }
                data.Src2 = this.Owner.mTransSrc.mSrcSLP;
                data.Src2Left = data.Left;
                data.Src2Top = data.Top;
            } else {
                data.Src2 = null;
            }
            boolean tempalloc = false;
            if (bmp == this.Target || this.Target == null) {
                dest = TempBitmapHolder.getTemp(cliprect.width(), cliprect.height(), true);
                tempalloc = true;
                if (this.Owner.mDestSLP == null) {
                    this.Owner.mDestSLP = new ScanLineProviderForBaseBitmap(dest);
                } else {
                    this.Owner.mDestSLP.attach(dest);
                }
                data.Dest = this.Owner.mDestSLP;
                data.DestLeft = 0;
                data.DestTop = 0;
            } else {
                if (this.Owner.mDestSLP == null) {
                    this.Owner.mDestSLP = new ScanLineProviderForBaseBitmap(this.Target);
                } else {
                    this.Owner.mDestSLP.attach(this.Target);
                }
                dest = this.Target;
                data.Dest = this.Owner.mDestSLP;
                data.DestLeft = this.TargetRect.left;
                data.DestTop = this.TargetRect.top;
            }
            try {
                this.Owner.mDivisibleTransHandler.process(data);
                Rect cr = new Rect(cliprect);
                if (data.Dest == this.Owner.mDestSLP) {
                    cr.setOffsets(data.DestLeft, data.DestTop);
                    this.OrgDrawable.drawCompleted(destrect, dest, cr, type, opacity);
                } else if (data.Dest == data.Src1) {
                    cr.setOffsets(data.DestLeft, data.DestTop);
                    this.OrgDrawable.drawCompleted(destrect, bmp, cr, type, opacity);
                } else if (data.Dest == data.Src2 && this.Owner.mTransSrc != null) {
                    cr.setOffsets(data.DestLeft, data.DestTop);
                    this.OrgDrawable.drawCompleted(destrect, src, cr, type, opacity);
                }
            }
            finally {
                if (tempalloc) {
                    TempBitmapHolder.freeTemp();
                }
            }
        }
    }

    static class TransIdleCallback
    implements ContinuousEventCallbackInterface {
        public LayerNI Owner;

        TransIdleCallback() {
        }

        @Override
        public void onContinuousCallback(long tick) throws VariantException, TJSException {
            this.Owner.invokeTransition(tick);
        }
    }
}

