/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2.visual;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.Holder;
import jp.kirikiri.tjs2.NativeInstanceObject;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantClosure;
import jp.kirikiri.tjs2.VariantException;
import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.base.WindowEvents;
import jp.kirikiri.tvp2.msg.Message;
import jp.kirikiri.tvp2.utils.ObjectList;
import jp.kirikiri.tvp2.visual.MenuItemClass;
import jp.kirikiri.tvp2.visual.WindowClass;
import jp.kirikiri.tvp2.visual.WindowNI;
import jp.kirikiri.tvp2env.MenuItem;

public class MenuItemNI
extends NativeInstanceObject {
    ObjectList<MenuItemNI> mChildren = new ObjectList();
    private WindowNI mWindow;
    private WeakReference<Dispatch2> mOwner;
    private VariantClosure mActionOwner = new VariantClosure(null);
    private MenuItemNI mParent;
    private boolean mChildrenArrayValid;
    private Dispatch2 mChildrenArray;
    private Dispatch2 mArrayClearMethod;
    private ArrayList<Dispatch2> mChildOwnerReference = new ArrayList();
    private MenuItem mMenuItem;
    private String mCaption;
    static final String ON_CLICK = "onClick";

    @Override
    public final int construct(Variant[] param, Dispatch2 tjs_obj) throws VariantException, TJSException {
        if (param.length < 1) {
            return -1004;
        }
        int hr = super.construct(param, tjs_obj);
        if (hr < 0) {
            return hr;
        }
        this.mActionOwner.set(param[0].asObjectClosure());
        this.mOwner = new WeakReference<Dispatch2>(tjs_obj);
        if (param.length >= 2 && param[1].isObject()) {
            VariantClosure clo = param[1].asObjectClosure();
            if (clo.mObject == null) {
                Message.throwExceptionMessage("Window \u30af\u30e9\u30b9\u306e\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044");
            }
            this.mWindow = (WindowNI)clo.mObject.getNativeInstance(WindowClass.ClassID);
            if (this.mWindow == null) {
                Message.throwExceptionMessage("Window \u30af\u30e9\u30b9\u306e\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044");
            }
        }
        this.mMenuItem = this.mWindow != null ? this.mWindow.getRootMenuItem() : new MenuItem(this);
        if (this.mWindow == null && param.length >= 2) {
            this.mCaption = param[1].asString();
            this.mMenuItem.setCaption(this.mCaption);
        }
        return 0;
    }

    @Override
    public final void invalidate() throws VariantException, TJSException {
        boolean dodeletemenuitem = this.mWindow == null;
        TVP.EventManager.cancelSourceEvents((Dispatch2)this.mOwner.get());
        TVP.EventManager.cancelInputEvents(this);
        try {
            this.mChildren.safeLock();
            int count = this.mChildren.getSafeLockedObjectCount();
            int i = 0;
            while (i < count) {
                Dispatch2 itemowner;
                MenuItemNI item = this.mChildren.getSafeLockedObjectAt(i);
                if (item != null && (itemowner = (Dispatch2)item.mOwner.get()) != null) {
                    itemowner.invalidate(0, null, itemowner);
                    item.mOwner = null;
                }
                ++i;
            }
        }
        finally {
            this.mChildren.safeUnlock();
        }
        this.mWindow = null;
        this.mParent = null;
        this.mChildrenArray = null;
        this.mArrayClearMethod = null;
        this.mActionOwner.mObject = null;
        this.mActionOwner.mObjThis = null;
        super.invalidate();
        if (dodeletemenuitem) {
            this.mMenuItem = null;
        }
    }

    public static final MenuItemNI castFromVariant(Variant from) throws TJSException {
        if (from.isObject()) {
            MenuItemNI ni;
            VariantClosure clo = from.asObjectClosure();
            if (clo.mObject == null) {
                Message.throwExceptionMessage("MenuItem \u30af\u30e9\u30b9\u306e\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044");
            }
            if ((ni = (MenuItemNI)clo.mObject.getNativeInstance(MenuItemClass.mClassID)) == null) {
                Message.throwExceptionMessage("MenuItem \u30af\u30e9\u30b9\u306e\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044");
            }
            return ni;
        }
        Message.throwExceptionMessage("MenuItem \u30af\u30e9\u30b9\u306e\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044");
        return null;
    }

    private final boolean canDeliverEvents() {
        if (this.mMenuItem == null) {
            return false;
        }
        boolean enabled = true;
        MenuItem item = this.mMenuItem;
        while (item != null) {
            if (!item.getEnabled()) {
                enabled = false;
                break;
            }
            item = item.getParent();
        }
        return enabled;
    }

    private final void addChild(MenuItemNI item) {
        if (this.mChildren.add(item)) {
            this.mChildrenArrayValid = false;
            Dispatch2 itemowner = (Dispatch2)item.mOwner.get();
            if (itemowner != null) {
                this.mChildOwnerReference.add(itemowner);
            }
            item.mParent = this;
        }
    }

    private final void removeChild(MenuItemNI item) {
        if (this.mChildren.remove(item)) {
            this.mChildrenArrayValid = false;
            Dispatch2 itemowner = (Dispatch2)item.mOwner.get();
            if (itemowner != null) {
                this.mChildOwnerReference.remove(itemowner);
            }
            item.mParent = null;
        }
    }

    public final void add(MenuItemNI item) throws TJSException {
        if (this.mMenuItem != null && item.mMenuItem != null) {
            this.mMenuItem.add(item.mMenuItem);
            this.addChild(item);
        }
    }

    public final void insert(MenuItemNI item, int index) throws TJSException {
        if (this.mMenuItem != null && item.mMenuItem != null) {
            this.mMenuItem.insert(index, item.mMenuItem);
            this.addChild(item);
        }
    }

    public final void remove(MenuItemNI item) throws TJSException {
        if (this.mMenuItem != null && item.mMenuItem != null) {
            int index = this.mMenuItem.indexOf(item.mMenuItem);
            if (index == -1) {
                Message.throwExceptionMessage("\u6307\u5b9a\u3055\u308c\u305f\u30e1\u30cb\u30e5\u30fc\u9805\u76ee\u306f\u3053\u306e\u30e1\u30cb\u30e5\u30fc\u9805\u76ee\u306e\u5b50\u3067\u306f\u3042\u308a\u307e\u305b\u3093");
            }
            this.mMenuItem.delete(index);
            this.removeChild(item);
        }
    }

    public final VariantClosure getActionOwner() {
        return this.mActionOwner;
    }

    public final Dispatch2 getOwner() {
        return (Dispatch2)this.mOwner.get();
    }

    public final MenuItemNI getParent() {
        return this.mParent;
    }

    public final MenuItemNI getRootMenuItem() {
        MenuItemNI current = this;
        MenuItemNI parent = current.getParent();
        while (parent != null) {
            current = parent;
            parent = current.getParent();
        }
        return current;
    }

    public final WindowNI getWindow() {
        return this.mWindow;
    }

    public final Dispatch2 getChildrenArray() throws VariantException, TJSException {
        if (this.mChildrenArray == null) {
            Holder<Object> classobj = new Holder<Object>(null);
            this.mChildrenArray = TJS.createArrayObject(classobj);
            try {
                Variant val = new Variant();
                int er = ((Dispatch2)classobj.mValue).propGet(0, "clear", val, (Dispatch2)classobj.mValue);
                if (er < 0) {
                    Message.throwExceptionMessage("\u5185\u90e8\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f: at %1 line %2");
                }
                this.mArrayClearMethod = val.asObject();
            }
            catch (TJSException e) {
                this.mChildrenArray = null;
                classobj.mValue = null;
                classobj = null;
                throw e;
            }
            classobj.mValue = null;
            classobj = null;
        }
        if (!this.mChildrenArrayValid) {
            this.mArrayClearMethod.funcCall(0, null, null, null, this.mChildrenArray);
            try {
                this.mChildren.safeLock();
                int count = this.mChildren.getSafeLockedObjectCount();
                int itemcount = 0;
                int i = 0;
                while (i < count) {
                    MenuItemNI item = this.mChildren.getSafeLockedObjectAt(i);
                    if (item != null) {
                        Dispatch2 dsp = (Dispatch2)item.mOwner.get();
                        Variant val = new Variant(dsp, dsp);
                        this.mChildrenArray.propSetByNum(512, itemcount, val, this.mChildrenArray);
                        ++itemcount;
                    }
                    ++i;
                }
            }
            finally {
                this.mChildren.safeUnlock();
            }
            this.mChildrenArrayValid = true;
        }
        return this.mChildrenArray;
    }

    public final void onClick() {
        if (!this.canDeliverEvents()) {
            return;
        }
        MenuItemNI item = this;
        while (item.mWindow == null) {
            if (item.mParent == null) break;
            item = item.mParent;
        }
        if (item.mWindow == null) {
            return;
        }
        if (!item.mWindow.canDeliverEvents()) {
            return;
        }
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        TVP.EventManager.postEvent(owner, owner, ON_CLICK, 0, 2, TJS.NULL_ARG);
    }

    public void menuItemClick() {
        TVP.EventManager.postInputEvent(new WindowEvents.OnMenuItemClickInputEvent(this), 0);
    }

    public void setCaption(String caption) {
        if (this.mMenuItem == null) {
            return;
        }
        this.mCaption = caption;
        this.mMenuItem.setCaption(caption);
    }

    public String getCaption() {
        if (this.mMenuItem == null) {
            return null;
        }
        return this.mCaption;
    }

    public void setChecked(boolean b) {
        if (this.mMenuItem == null) {
            return;
        }
        this.mMenuItem.setChecked(b);
    }

    public boolean getChecked() {
        if (this.mMenuItem == null) {
            return false;
        }
        return this.mMenuItem.getChecked();
    }

    public void setEnabled(boolean b) {
        if (this.mMenuItem == null) {
            return;
        }
        this.mMenuItem.setEnabled(b);
    }

    public boolean getEnabled() {
        if (this.mMenuItem == null) {
            return false;
        }
        return this.mMenuItem.getEnabled();
    }

    public void setGroup(int g) {
        if (this.mMenuItem == null) {
            return;
        }
        this.mMenuItem.setGroupIndex(g);
    }

    public int getGroup() {
        if (this.mMenuItem == null) {
            return 0;
        }
        return this.mMenuItem.getGroupIndex();
    }

    public void setRadio(boolean b) {
        if (this.mMenuItem == null) {
            return;
        }
        this.mMenuItem.setRadioItem(b);
    }

    public boolean getRadio() {
        if (this.mMenuItem == null) {
            return false;
        }
        return this.mMenuItem.getRadioItem();
    }

    public void setShortcut(String shortcut) {
        if (this.mMenuItem == null) {
            return;
        }
        this.mMenuItem.setShortcut(shortcut);
    }

    public String getShortcut() {
        if (this.mMenuItem == null) {
            return null;
        }
        return this.mMenuItem.getShortcut();
    }

    public void setVisible(boolean b) throws TJSException {
        if (this.mMenuItem == null) {
            return;
        }
        if (this.mWindow != null) {
            this.mWindow.setMenuBarVisible(b);
        } else {
            this.mMenuItem.setVisible(b);
        }
    }

    public boolean getVisible() {
        if (this.mMenuItem == null) {
            return false;
        }
        if (this.mWindow != null) {
            return this.mWindow.getMenuBarVisible();
        }
        return this.mMenuItem.getVisible();
    }

    public int getIndex() {
        if (this.mMenuItem != null) {
            return -1;
        }
        return this.mMenuItem.getMenuIndex();
    }

    public void setIndex(int newIndex) throws TJSException {
        if (this.mMenuItem != null) {
            return;
        }
        this.mMenuItem.setMenuIndex(newIndex);
    }

    public int trackPopup(int flags, int x, int y) {
        if (this.mMenuItem == null) {
            return 0;
        }
        int result = 0;
        if (this.getRootMenuItem() != null && this.getRootMenuItem().getWindow() != null) {
            result = this.mMenuItem.popup(this.getRootMenuItem().getWindow().getForm(), flags, x, y);
        }
        return result;
    }
}

