/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2.visual;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.util.Arrays;
import jp.kirikiri.tjs2.BinaryStream;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.msg.Message;

public class PrerenderedFont {
    private static final byte[] HEADER = new byte[]{84, 86, 80, 32, 112, 114, 101, 45, 114, 101, 110, 100, 101, 114, 101, 100, 32, 102, 111, 110, 116, 26};
    private static final int SKIP_SIZE = 24;
    private int mVersion;
    private int mIndexCount;
    private char[] mChIndex;
    private int mDataOffset;
    private ByteBuffer mDataBuffer;
    private static final int CHARACTER_ITEM_SIZE = 20;
    private CharacterItem mWork = new CharacterItem();

    public PrerenderedFont(BinaryStream input) throws TJSException {
        this.load(input);
    }

    private void load(BinaryStream src) throws TJSException {
        byte[] buff = new byte[22];
        src.setPosition(0L);
        src.read(buff);
        if (!Arrays.equals(HEADER, buff)) {
            Message.throwExceptionMessage("\u30ec\u30f3\u30c0\u30ea\u30f3\u30b0\u6e08\u307f\u30d5\u30a9\u30f3\u30c8\u306e\u30de\u30c3\u30d4\u30f3\u30b0\u306b\u5931\u6557\u3057\u307e\u3057\u305f : %1", "Signature not found or invalid pre-rendered font file.");
        }
        src.read(buff, 0, 2);
        if (buff[1] != 2) {
            Message.throwExceptionMessage("\u30ec\u30f3\u30c0\u30ea\u30f3\u30b0\u6e08\u307f\u30d5\u30a9\u30f3\u30c8\u306e\u30de\u30c3\u30d4\u30f3\u30b0\u306b\u5931\u6557\u3057\u307e\u3057\u305f : %1", "Not a 16-bit UNICODE font file.");
        }
        this.mVersion = buff[0];
        if (this.mVersion != 0 && this.mVersion != 1) {
            Message.throwExceptionMessage("\u30ec\u30f3\u30c0\u30ea\u30f3\u30b0\u6e08\u307f\u30d5\u30a9\u30f3\u30c8\u306e\u30de\u30c3\u30d4\u30f3\u30b0\u306b\u5931\u6557\u3057\u307e\u3057\u305f : %1", "Invalid header version.");
        }
        int length = (int)(src.getSize() - 24L);
        this.mDataBuffer = ByteBuffer.allocateDirect(length);
        src.read(this.mDataBuffer);
        ByteBuffer bb = this.mDataBuffer;
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.clear();
        this.mDataBuffer = bb;
        this.mIndexCount = bb.getInt();
        int chOffset = bb.getInt();
        this.mDataOffset = bb.getInt();
        bb.position(chOffset - 24);
        CharBuffer cb = bb.asCharBuffer();
        this.mChIndex = new char[this.mIndexCount];
        cb.get(this.mChIndex);
    }

    public CharacterItem getCharData(char ch) {
        int idx = this.findCh(ch);
        if (idx < 0) {
            return null;
        }
        int offset = this.mDataOffset + idx * 20 - 24;
        ByteBuffer bb = this.mDataBuffer;
        bb.position(offset);
        CharacterItem ret = this.mWork;
        ret.Offset = bb.getInt();
        ret.Width = bb.getShort();
        ret.Height = bb.getShort();
        ret.OriginX = bb.getShort();
        ret.OriginY = bb.getShort();
        ret.IncX = bb.getShort();
        ret.IncY = bb.getShort();
        ret.Inc = bb.getShort();
        ret.Reserved = bb.getShort();
        return ret;
    }

    private int findCh(char ch) {
        int s = 0;
        int e = this.mIndexCount;
        char[] chindex = this.mChIndex;
        while (true) {
            int d;
            if ((d = e - s) <= 1) {
                if (chindex[s] == ch) {
                    return s;
                }
                return -1;
            }
            int m = s + (d >> 1);
            int c = chindex[m] & 0xFFFF;
            if (c > ch) {
                e = m;
                continue;
            }
            s = m;
        }
    }

    public void retrieve(CharacterItem item, byte[] buffer, int bufferpitch) {
        int len;
        if (item.Width == 0 || item.Height == 0) {
            return;
        }
        short w = item.Width;
        int ptr = item.Offset - 24;
        int dest = 0;
        int destlim = w * item.Height;
        ByteBuffer bb = this.mDataBuffer;
        if (this.mVersion == 0) {
            while (dest < destlim) {
                if (bb.get(ptr) == 65) {
                    byte last = buffer[dest - 1];
                    len = bb.get(++ptr);
                    ++ptr;
                    while (len > 0) {
                        --len;
                        buffer[dest] = last;
                        ++dest;
                    }
                    continue;
                }
                buffer[dest] = bb.get(ptr);
                ++dest;
                ++ptr;
            }
        } else if (this.mVersion >= 1) {
            while (dest < destlim) {
                int p = bb.get(ptr) & 0xFF;
                if (p >= 65) {
                    len = p - 64;
                    ++ptr;
                    byte last = buffer[dest - 1];
                    while (len > 0) {
                        --len;
                        buffer[dest] = last;
                        ++dest;
                    }
                    continue;
                }
                buffer[dest] = bb.get(ptr);
                ++dest;
                ++ptr;
            }
        }
        ptr = destlim - w;
        dest = bufferpitch * item.Height - bufferpitch;
        byte[] work = new byte[w];
        while (dest >= 0) {
            if (dest != ptr) {
                System.arraycopy(buffer, ptr, work, 0, w);
                System.arraycopy(work, 0, buffer, dest, w);
            }
            dest -= bufferpitch;
            ptr -= w;
        }
    }

    public static class CharacterItem {
        public int Offset;
        public short Width;
        public short Height;
        public short OriginX;
        public short OriginY;
        public short IncX;
        public short IncY;
        public short Inc;
        public short Reserved;
    }
}

