/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2.visual;

import java.util.ArrayList;

public class Rect {
    private static ArrayList<Rect> mRectPool = new ArrayList(128);
    public int left;
    public int top;
    public int right;
    public int bottom;

    public static Rect allocate() {
        int count = mRectPool.size();
        if (count > 0) {
            int i = count - 1;
            Rect ret = mRectPool.get(i);
            mRectPool.remove(i);
            return ret;
        }
        return new Rect();
    }

    public static void release(Rect r) {
        mRectPool.add(r);
    }

    public static void initialize() {
        mRectPool = new ArrayList(128);
    }

    public static void finalizeApplication() {
        mRectPool = null;
    }

    public Rect(int l, int t, int r, int b) {
        this.left = l;
        this.top = t;
        this.right = r;
        this.bottom = b;
    }

    public Rect() {
    }

    public Rect(Rect rt) {
        this.left = rt.left;
        this.top = rt.top;
        this.right = rt.right;
        this.bottom = rt.bottom;
    }

    public final int width() {
        return this.right - this.left;
    }

    public final int height() {
        return this.bottom - this.top;
    }

    public final void setWidth(int w) {
        this.right = this.left + w;
    }

    public final void setHeight(int h) {
        this.bottom = this.top + h;
    }

    public final void addOffsets(int x, int y) {
        this.left += x;
        this.right += x;
        this.top += y;
        this.bottom += y;
    }

    public final void setOffsets(int x, int y) {
        int w = this.width();
        int h = this.height();
        this.left = x;
        this.top = y;
        this.right = x + w;
        this.bottom = y + h;
    }

    public final void setSize(int w, int h) {
        this.right = this.left + w;
        this.bottom = this.top + h;
    }

    public final void set(Rect rt) {
        this.left = rt.left;
        this.top = rt.top;
        this.right = rt.right;
        this.bottom = rt.bottom;
    }

    public void set(int l, int t, int r, int b) {
        this.left = l;
        this.top = t;
        this.right = r;
        this.bottom = b;
    }

    public final void clear() {
        this.bottom = 0;
        this.right = 0;
        this.top = 0;
        this.left = 0;
    }

    public final boolean isEmpty() {
        return this.left >= this.right || this.top >= this.bottom;
    }

    public final boolean doUnion(Rect ref) {
        if (ref.isEmpty()) {
            return false;
        }
        if (this.left > ref.left) {
            this.left = ref.left;
        }
        if (this.top > ref.top) {
            this.top = ref.top;
        }
        if (this.right < ref.right) {
            this.right = ref.right;
        }
        if (this.bottom < ref.bottom) {
            this.bottom = ref.bottom;
        }
        return true;
    }

    boolean clip(Rect ref) {
        return Rect.intersectRect(this, this, ref);
    }

    public final boolean intersectsWithNoEmptyCheck(Rect ref) {
        return this.left < ref.right && this.top < ref.bottom && this.right > ref.left && this.bottom > ref.top;
    }

    public final boolean intersectsWith(Rect ref) {
        if (ref.isEmpty() || this.isEmpty()) {
            return false;
        }
        return this.intersectsWithNoEmptyCheck(ref);
    }

    public final boolean includedInNoEmptyCheck(Rect ref) {
        return ref.left <= this.left && ref.top <= this.top && ref.right >= this.right && ref.bottom >= this.bottom;
    }

    public final boolean includedIn(Rect ref) {
        if (ref.isEmpty() || this.isEmpty()) {
            return false;
        }
        return this.includedInNoEmptyCheck(ref);
    }

    public final boolean littlerThan(Rect rhs) {
        return this.top < rhs.top || this.top == rhs.top && this.left < rhs.left;
    }

    public final boolean greaterThan(Rect rhs) {
        return this.top > rhs.top || this.top == rhs.top && this.left > rhs.left;
    }

    public final boolean equals(Rect rhs) {
        return this.top == rhs.top && this.left == rhs.left && this.right == rhs.right && this.bottom == rhs.bottom;
    }

    public final boolean notEquals(Rect rhs) {
        return !this.equals(rhs);
    }

    public static final boolean intersectRect(Rect dest, Rect src1, Rect src2) {
        int bottom;
        int left = src1.left > src2.left ? src1.left : src2.left;
        int top = src1.top > src2.top ? src1.top : src2.top;
        int right = src1.right < src2.right ? src1.right : src2.right;
        int n = bottom = src1.bottom < src2.bottom ? src1.bottom : src2.bottom;
        if (right > left && bottom > top) {
            if (dest != null) {
                dest.left = left;
                dest.top = top;
                dest.right = right;
                dest.bottom = bottom;
            }
            return true;
        }
        return false;
    }

    public static final boolean unionRect(Rect dest, Rect src1, Rect src2) {
        int bottom;
        int left = src1.left < src2.left ? src1.left : src2.left;
        int top = src1.top < src2.top ? src1.top : src2.top;
        int right = src1.right > src2.right ? src1.right : src2.right;
        int n = bottom = src1.bottom > src2.bottom ? src1.bottom : src2.bottom;
        if (right > left && bottom > top) {
            if (dest != null) {
                dest.left = left;
                dest.top = top;
                dest.right = right;
                dest.bottom = bottom;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(64);
        builder.append("left:");
        builder.append(this.left);
        builder.append(", top:");
        builder.append(this.top);
        builder.append(", right:");
        builder.append(this.right);
        builder.append(", bottom:");
        builder.append(this.bottom);
        return builder.toString();
    }
}

