/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2.visual;

import java.util.ArrayList;
import jp.kirikiri.tvp2.visual.Rect;

public class RegionRect
extends Rect {
    private static ArrayList<RegionRect> RegionFreeRects;
    private static final int REGIONRECT_ALLOC_UNITS = 256;
    private static int RegionFreeMaxCount;
    public RegionRect Prev;
    public RegionRect Next;

    static {
        RegionFreeMaxCount = 0;
    }

    private static void prepareRegionRectangle() {
        int i = 0;
        while (i < 256) {
            RegionFreeRects.add(new RegionRect());
            ++RegionFreeMaxCount;
            ++i;
        }
    }

    public static void initialize() {
        RegionFreeRects = new ArrayList(512);
        RegionRect.prepareRegionRectangle();
    }

    public static void finalizeApplication() {
        RegionFreeRects = null;
    }

    public static RegionRect allocate() {
        int last = RegionFreeRects.size() - 1;
        if (last < 0) {
            return new RegionRect();
        }
        RegionRect r = RegionFreeRects.get(last);
        RegionFreeRects.remove(last);
        return r;
    }

    public static void release(RegionRect rect) {
        if (RegionFreeRects.size() > 512) {
            return;
        }
        RegionFreeRects.add(rect);
    }

    public RegionRect() {
    }

    public RegionRect(Rect r) {
        super(r);
    }

    public void linkAfter(RegionRect r) {
        RegionRect n = r.Next;
        r.Next = this;
        n.Prev = this;
        this.Prev = r;
        this.Next = n;
    }

    public void linkBefore(RegionRect r) {
        RegionRect p = r.Prev;
        r.Prev = this;
        p.Next = this;
        this.Prev = p;
        this.Next = r;
    }

    public void unlink() {
        RegionRect next;
        RegionRect prev = this.Prev;
        prev.Next = next = this.Next;
        next.Prev = prev;
    }

    public static /* bridge */ /* synthetic */ Rect allocate() {
        return RegionRect.allocate();
    }
}

