/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2.visual;

import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.msg.Message;
import jp.kirikiri.tvp2.visual.BaseBitmap;
import jp.kirikiri.tvp2.visual.ScanLineProvider;
import jp.kirikiri.tvp2env.NativeImageBuffer;

public class ScanLineProviderForBaseBitmap
implements ScanLineProvider {
    private boolean mOwn;
    BaseBitmap mBitmap;

    public ScanLineProviderForBaseBitmap(BaseBitmap bmp) {
        this(bmp, false);
    }

    public ScanLineProviderForBaseBitmap(BaseBitmap bmp, boolean own) {
        this.mOwn = own;
        this.mBitmap = bmp;
    }

    public void attach(BaseBitmap bmp) {
        this.mBitmap = bmp;
    }

    @Override
    public int getWidth() {
        return this.mBitmap.getWidth();
    }

    @Override
    public int getHeight() {
        return this.mBitmap.getHeight();
    }

    @Override
    public int getPixelFormat() {
        return this.mBitmap.getBPP();
    }

    @Override
    public int getPitchBytes() {
        return this.mBitmap.getPitchBytes();
    }

    @Override
    public NativeImageBuffer getScanLine() {
        return this.mBitmap.getBitmap();
    }

    @Override
    public NativeImageBuffer getScanLineForWrite() {
        this.mBitmap.independ();
        NativeImageBuffer ret = this.mBitmap.getBitmap();
        ret.toMutable();
        return ret;
    }

    @Override
    public void copyFrom(ScanLineProvider src) throws TJSException {
        if (src instanceof ScanLineProviderForBaseBitmap) {
            ScanLineProviderForBaseBitmap s = (ScanLineProviderForBaseBitmap)src;
            this.mBitmap = s.mBitmap;
            this.mOwn = s.mOwn;
        } else {
            Message.throwExceptionMessage("\u5185\u90e8\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f: at %1 line %2");
        }
    }
}

