/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2.visual;

import java.util.ArrayList;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.TJSScriptError;
import jp.kirikiri.tjs2.TJSScriptException;
import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.base.CompactEventCallbackInterface;
import jp.kirikiri.tvp2.visual.BaseBitmap;
import jp.kirikiri.tvp2.visual.Rect;

public class TempBitmapHolder
implements CompactEventCallbackInterface {
    private static final int INIT_SIZE = 32;
    private static final int INIT_BPP = 32;
    private static final int INIT_COLOR = 0xFFFFFF;
    private static TempBitmapHolder TempBitmapHolder;
    private BaseBitmap mBitmap = new BaseBitmap(32, 32, 32);
    private ArrayList<BaseBitmap> mTemporaries = new ArrayList();
    private int mTempLevel;
    private boolean mTempCompactInit;

    public static void initialize() {
        TempBitmapHolder = null;
    }

    public static void finalizeApplication() {
        TempBitmapHolder = null;
    }

    private TempBitmapHolder() throws TJSException {
        this.mBitmap.fill(new Rect(0, 0, 32, 32), 0xFFFFFF);
    }

    protected void finalize() {
        int count = this.mTemporaries.size();
        int i = 0;
        while (i < count) {
            this.mTemporaries.set(i, null);
            ++i;
        }
        if (this.mTempCompactInit && TVP.EventManager != null) {
            TVP.EventManager.removeCompactEventHook(this);
        }
    }

    private BaseBitmap internalGetTemp(int w, int h, boolean fit) throws TJSException {
        if (!this.mTempCompactInit) {
            TVP.EventManager.addCompactEventHook(this);
            this.mTempCompactInit = true;
        }
        if (!fit) {
            w += w & 1;
        }
        ++this.mTempLevel;
        if (this.mTempLevel > this.mTemporaries.size()) {
            BaseBitmap bmp = new BaseBitmap(w, h, 32);
            this.mTemporaries.add(bmp);
            return bmp;
        }
        BaseBitmap bmp = this.mTemporaries.get(this.mTempLevel - 1);
        if (!fit) {
            int bw = bmp.getWidth();
            int bh = bmp.getHeight();
            if (bw < w || bh < h) {
                bmp.setSize(bw > w ? bw : w, bh > h ? bh : h, false);
            }
        } else {
            int bw = bmp.getWidth();
            int bh = bmp.getHeight();
            if (bw != w || bh != h) {
                bmp.setSize(w, h, false);
            }
        }
        return bmp;
    }

    private void internalFreeTemp() {
        if (this.mTempLevel == 0) {
            return;
        }
        --this.mTempLevel;
    }

    private void compactTempBitmap() {
        int count = this.mTemporaries.size();
        int i = count - 1;
        while (i >= this.mTempLevel) {
            BaseBitmap bmp = this.mTemporaries.get(i);
            bmp.purgeImage();
            this.mTemporaries.remove(i);
            --i;
        }
    }

    @Override
    public void onCompact(int level) throws TJSScriptException, TJSScriptError, TJSException {
        if (level >= 10) {
            this.compactTempBitmap();
        }
    }

    static BaseBitmap get() throws TJSException {
        if (TempBitmapHolder == null) {
            TempBitmapHolder = new TempBitmapHolder();
        }
        return jp.kirikiri.tvp2.visual.TempBitmapHolder.TempBitmapHolder.mBitmap;
    }

    static BaseBitmap getTemp(int w, int h) throws TJSException {
        return jp.kirikiri.tvp2.visual.TempBitmapHolder.getTemp(w, h, false);
    }

    static BaseBitmap getTemp(int w, int h, boolean fit) throws TJSException {
        if (TempBitmapHolder == null) {
            TempBitmapHolder = new TempBitmapHolder();
        }
        return TempBitmapHolder.internalGetTemp(w, h, fit);
    }

    static void freeTemp() {
        if (TempBitmapHolder != null) {
            TempBitmapHolder.internalFreeTemp();
        }
    }
}

