/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2.visual;

import java.lang.ref.WeakReference;
import jp.kirikiri.tjs2.BinaryStream;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.NativeInstanceObject;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantClosure;
import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.base.Storage;
import jp.kirikiri.tvp2.msg.Message;
import jp.kirikiri.tvp2.utils.DebugClass;
import jp.kirikiri.tvp2.visual.LayerNI;
import jp.kirikiri.tvp2.visual.Rect;
import jp.kirikiri.tvp2.visual.WindowClass;
import jp.kirikiri.tvp2.visual.WindowNI;
import jp.kirikiri.tvp2env.VideoOverlay;
import jp.kirikiri.tvp2env.WindowForm;

public class VideoOverlayNI
extends NativeInstanceObject {
    public final int perLoop = 0;
    public final int perPeriod = 1;
    public final int perPrepare = 2;
    public final int perSegLoop = 3;
    public static final int ssUnload = 0;
    public static final int ssStop = 1;
    public static final int ssPlay = 2;
    public static final int ssPause = 3;
    private static final String ON_STATUS_CHANGED = "onStatusChanged";
    private static final String ON_CALLBACK_COMMAND = "onCallbackCommand";
    private static final String ON_PERIOD = "onPeriod";
    private static final String ON_FRAME_UPDATE = "onFrameUpdate";
    private VideoOverlay mVideoOverlay;
    private StringBuilder mMessageBuilder;
    private WeakReference<Dispatch2> mOwner = null;
    private boolean mCanDeliverEvents = true;
    private WindowNI mWindow;
    private VariantClosure mActionOwner = new VariantClosure(null);
    private int mStatus = 0;
    private Rect mRect;
    private boolean mVisible;
    private LayerNI mLayer1;
    private LayerNI mLayer2;
    private int mMode;
    private boolean mLoop;
    private boolean mIsPrepare;
    private int mSegLoopStartFrame;
    private int mSegLoopEndFrame;
    private boolean mIsEventPast;
    private int mEventFrame;

    public VideoOverlayNI() {
        this.mVideoOverlay = new VideoOverlay();
        this.mMessageBuilder = new StringBuilder();
        this.mRect = new Rect();
    }

    @Override
    public int construct(Variant[] param, Dispatch2 tjs_obj) throws TJSException {
        WindowNI win;
        int hr = super.construct(param, tjs_obj);
        if (hr < 0) {
            return hr;
        }
        if (param.length < 1) {
            return -1004;
        }
        VariantClosure clo = param[0].asObjectClosure();
        if (clo.mObject == null) {
            Message.throwExceptionMessage("Window \u30af\u30e9\u30b9\u306e\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044");
        }
        if ((win = (WindowNI)clo.mObject.getNativeInstance(WindowClass.ClassID)) == null) {
            Message.throwExceptionMessage("Window \u30af\u30e9\u30b9\u306e\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044");
        }
        this.mWindow = win;
        this.mWindow.registerVideoOverlayObject(this);
        this.mActionOwner.mObject = clo.mObject;
        this.mActionOwner.mObjThis = clo.mObjThis;
        this.mOwner = new WeakReference<Dispatch2>(tjs_obj);
        return 0;
    }

    @Override
    public void invalidate() throws TJSException {
        this.mOwner.clear();
        if (this.mWindow != null) {
            this.mWindow.unregisterVideoOverlayObject(this);
        }
        this.mActionOwner.mObjThis = null;
        this.mActionOwner.mObject = null;
        super.invalidate();
        this.close();
    }

    private String getStatusString() {
        switch (this.mStatus) {
            case 0: {
                return "unload";
            }
            case 2: {
                return "play";
            }
            case 1: {
                return "stop";
            }
            case 3: {
                return "pause";
            }
        }
        return "unknown";
    }

    private void setStatus(int s) {
        if (this.mStatus != s) {
            this.mStatus = s;
            Dispatch2 owner = (Dispatch2)this.mOwner.get();
            if (owner != null) {
                TVP.EventManager.cancelSourceEvents(owner);
                if (this.mCanDeliverEvents) {
                    Variant[] param = new Variant[]{new Variant(this.getStatusString())};
                    TVP.EventManager.postEvent(owner, owner, ON_STATUS_CHANGED, 0, 2, param);
                }
            }
        }
    }

    private void setStatusAsync(int s) {
        if (this.mStatus != s) {
            this.mStatus = s;
            Dispatch2 owner = (Dispatch2)this.mOwner.get();
            if (owner != null) {
                TVP.EventManager.cancelSourceEvents(owner);
                if (this.mCanDeliverEvents) {
                    Variant[] param = new Variant[]{new Variant(this.getStatusString())};
                    TVP.EventManager.postEvent(owner, owner, ON_STATUS_CHANGED, 0, 0, param);
                }
            }
        }
    }

    private void fireCallbackCommand(String command, String argument) {
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner != null && this.mCanDeliverEvents) {
            Variant[] param = new Variant[]{new Variant(command), new Variant(argument)};
            TVP.EventManager.postEvent(owner, owner, ON_CALLBACK_COMMAND, 0, 2, param);
        }
    }

    private void firePeriodEvent(int reason) {
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner != null && this.mCanDeliverEvents) {
            Variant[] param = new Variant[]{new Variant(reason)};
            TVP.EventManager.postEvent(owner, owner, ON_PERIOD, 0, 2, param);
        }
    }

    private void fireFrameUpdateEvent(int frame) {
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner != null && this.mCanDeliverEvents) {
            Variant[] param = new Variant[]{new Variant(frame)};
            TVP.EventManager.postEvent(owner, owner, ON_FRAME_UPDATE, 0, 2, param);
        }
    }

    public VariantClosure getActionOwner() {
        return this.mActionOwner;
    }

    public void open(String name) throws TJSException {
        this.close();
        BinaryStream stream = Storage.createStream(name, 0);
        this.mVideoOverlay.open(name, stream, this.mMode, this.mVisible);
    }

    public void close() {
        this.mVideoOverlay.close();
        this.setStatus(0);
    }

    public void shutdown() {
        boolean c = this.mCanDeliverEvents;
        this.setStatus(0);
        try {
            this.mVideoOverlay.close();
        }
        finally {
            this.mCanDeliverEvents = c;
        }
    }

    public void disconnect() {
        this.shutdown();
        this.mWindow = null;
    }

    public void play() {
        this.mVideoOverlay.setLoop(this.mLoop);
        this.mVideoOverlay.play();
        this.setStatus(2);
    }

    public void stop() {
        this.mVideoOverlay.stop();
        this.setStatus(1);
    }

    public void pause() {
        this.mVideoOverlay.pause();
        this.setStatus(3);
    }

    public void rewind() {
        this.mVideoOverlay.rewind();
        if (this.mEventFrame >= 0 && this.mIsEventPast) {
            this.mIsEventPast = false;
        }
    }

    public void prepare() {
        this.mIsPrepare = true;
    }

    public void setSegmentLoop(int comeFrame, int goFrame) {
        this.mSegLoopStartFrame = comeFrame;
        this.mSegLoopEndFrame = goFrame;
    }

    public void cancelSegmentLoop() {
        this.mSegLoopStartFrame = -1;
        this.mSegLoopEndFrame = -1;
    }

    public void setPeriodEvent(int eventFrame) {
        this.mEventFrame = eventFrame;
        this.mIsEventPast = eventFrame <= this.getFrame();
    }

    public void setStopFrame(int f) {
        this.mVideoOverlay.setStopFrame(f);
    }

    public void setDefaultStopFrame() {
        this.mVideoOverlay.setDefaultStopFrame();
    }

    public int getStopFrame() {
        return this.mVideoOverlay.getStopFrame();
    }

    public void setRectangleToVideoOverlay() {
        Rect rect = new Rect(this.mRect);
        this.mMessageBuilder.delete(0, this.mMessageBuilder.length());
        this.mMessageBuilder.append("Video zoom: (");
        this.mMessageBuilder.append(rect.left);
        this.mMessageBuilder.append(",");
        this.mMessageBuilder.append(rect.top);
        this.mMessageBuilder.append(")-(");
        this.mMessageBuilder.append(rect.right);
        this.mMessageBuilder.append(",");
        this.mMessageBuilder.append(rect.bottom);
        this.mMessageBuilder.append(") ->");
        DebugClass.addLog(this.mMessageBuilder.toString());
        this.mWindow.zoomRectangle(rect);
        this.mMessageBuilder.delete(0, this.mMessageBuilder.length());
        this.mMessageBuilder.append("(");
        this.mMessageBuilder.append(rect.left);
        this.mMessageBuilder.append(",");
        this.mMessageBuilder.append(rect.top);
        this.mMessageBuilder.append(")-(");
        this.mMessageBuilder.append(rect.right);
        this.mMessageBuilder.append(",");
        this.mMessageBuilder.append(rect.bottom);
        this.mMessageBuilder.append(")");
        DebugClass.addLog(this.mMessageBuilder.toString());
        this.mVideoOverlay.setRect(rect);
    }

    public void setPosition(int left, int top) {
        this.mRect.setOffsets(left, top);
        this.setRectangleToVideoOverlay();
    }

    public void setSize(int width, int height) {
        this.mRect.setSize(width, height);
        this.setRectangleToVideoOverlay();
    }

    public void setBounds(Rect rect) {
        this.mRect.set(rect);
        this.setRectangleToVideoOverlay();
    }

    public void setLeft(int l) {
        this.mRect.setOffsets(l, this.mRect.top);
        this.setRectangleToVideoOverlay();
    }

    public int getLeft() {
        return this.mRect.left;
    }

    public void setTop(int t) {
        this.mRect.setOffsets(this.mRect.left, t);
        this.setRectangleToVideoOverlay();
    }

    public int getTop() {
        return this.mRect.top;
    }

    public void setWidth(int w) {
        this.mRect.right = this.mRect.left + w;
        this.setRectangleToVideoOverlay();
    }

    public int getWidth() {
        return this.mRect.width();
    }

    public void setHeight(int h) {
        this.mRect.bottom = this.mRect.top + h;
        this.setRectangleToVideoOverlay();
    }

    public int getHeight() {
        return this.mRect.height();
    }

    public void setVisible(boolean b) {
        this.mVisible = b;
        this.mVideoOverlay.setVisible(this.mVisible);
    }

    public boolean getVisible() {
        return this.mVisible;
    }

    public void setTimePosition(long p) {
        this.mVideoOverlay.setPosition(p);
    }

    public long getTimePosition() {
        return this.mVideoOverlay.getPosition();
    }

    public void setFrame(int f) {
        this.mVideoOverlay.setFrame(f);
        if (this.mEventFrame >= f && this.mIsEventPast) {
            this.mIsEventPast = false;
        }
    }

    public int getFrame() {
        return this.mVideoOverlay.getFrame();
    }

    public double getFPS() {
        return this.mVideoOverlay.getFPS();
    }

    public int getNumberOfFrame() {
        return this.mVideoOverlay.getNumberOfFrame();
    }

    public long getTotalTime() {
        return this.mVideoOverlay.getTotalTime();
    }

    public void setLoop(boolean b) {
        this.mLoop = b;
        this.mVideoOverlay.setLoop(this.mLoop);
    }

    public boolean getLoop() {
        return this.mLoop;
    }

    public void setLayer1(LayerNI l) {
    }

    public LayerNI getLayer1() {
        return this.mLayer1;
    }

    public void setLayer2(LayerNI l) {
    }

    public LayerNI getLayer2() {
        return this.mLayer2;
    }

    public void setMode(int m) {
        if (!this.mVideoOverlay.isOpen()) {
            this.mMode = m;
        }
    }

    public int getMode() {
        return this.mMode;
    }

    public double getPlayRate() {
        return this.mVideoOverlay.getPlayRate();
    }

    public void setPlayRate(double r) {
        this.mVideoOverlay.setPlayRate(r);
    }

    public int getSegmentLoopStartFrame() {
        return this.mSegLoopStartFrame;
    }

    public int getSegmentLoopEndFrame() {
        return this.mSegLoopEndFrame;
    }

    public int getPeriodEventFrame() {
        return this.mEventFrame;
    }

    public int getAudioBalance() {
        return this.mVideoOverlay.getAudioBalance();
    }

    public void setAudioBalance(int b) {
        this.mVideoOverlay.setAudioBalance(b);
    }

    public int getAudioVolume() {
        return this.mVideoOverlay.getAudioVolume();
    }

    public void setAudioVolume(int v) {
        this.mVideoOverlay.setAudioVolume(v);
    }

    public int getNumberOfAudioStream() {
        return this.mVideoOverlay.getNumberOfAudioStream();
    }

    public void selectAudioStream(int n) {
        this.mVideoOverlay.selectAudioStream(n);
    }

    public int getEnabledAudioStream() {
        return this.mVideoOverlay.getEnableAudioStreamNum();
    }

    public void disableAudioStream() {
        this.mVideoOverlay.disableAudioStream();
    }

    public int getNumberOfVideoStream() {
        return this.mVideoOverlay.getNumberOfVideoStream();
    }

    public void selectVideoStream(int n) {
        this.mVideoOverlay.selectVideoStream(n);
    }

    public int getEnabledVideoStream() {
        return this.mVideoOverlay.getEnableVideoStreamNum();
    }

    public void setMixingLayer(LayerNI l) {
    }

    public void resetMixingBitmap() {
    }

    public void setMixingMovieAlpha(double a) {
        this.mVideoOverlay.setMixingMovieAlpha(a);
    }

    public double getMixingMovieAlpha() {
        return this.mVideoOverlay.getMixingMovieAlpha();
    }

    public void setMixingMovieBGColor(int col) {
        this.mVideoOverlay.setMixingMovieBGColor(col);
    }

    public int getMixingMovieBGColor() {
        return this.mVideoOverlay.getMixingMovieBGColor();
    }

    public int getOriginalWidth() {
        return this.mVideoOverlay.getVideoWidth();
    }

    public int getOriginalHeight() {
        return this.mVideoOverlay.getVideoHeight();
    }

    public void resetOverlayParams() {
        this.setRectangleToVideoOverlay();
        this.mVideoOverlay.setVisible(this.mVisible);
    }

    public void setRectOffset(int ofsx, int ofsy) {
        Rect r = new Rect(this.mRect.left + ofsx, this.mRect.top + ofsy, this.mRect.right + ofsx, this.mRect.bottom + ofsy);
        this.mVideoOverlay.setRect(r);
    }

    public void detachVideoOverlay() {
    }

    public void setTargetWindow(WindowForm form) {
        this.mVideoOverlay.setWindow(form);
    }
}

