/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2.visual;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.NativeInstanceObject;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantClosure;
import jp.kirikiri.tjs2.VariantException;
import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.base.WindowEvents;
import jp.kirikiri.tvp2.msg.Message;
import jp.kirikiri.tvp2.utils.DebugClass;
import jp.kirikiri.tvp2.utils.ObjectList;
import jp.kirikiri.tvp2.visual.ComplexRect;
import jp.kirikiri.tvp2.visual.LayerManager;
import jp.kirikiri.tvp2.visual.LayerNI;
import jp.kirikiri.tvp2.visual.Point;
import jp.kirikiri.tvp2.visual.Rect;
import jp.kirikiri.tvp2.visual.ScreenMode;
import jp.kirikiri.tvp2.visual.ScreenModeCandidate;
import jp.kirikiri.tvp2.visual.Size;
import jp.kirikiri.tvp2.visual.VideoOverlayNI;
import jp.kirikiri.tvp2env.DrawTarget;
import jp.kirikiri.tvp2env.Font;
import jp.kirikiri.tvp2env.MenuItem;
import jp.kirikiri.tvp2env.NativeImageBuffer;
import jp.kirikiri.tvp2env.WindowForm;

public class WindowNI
extends NativeInstanceObject {
    private ArrayList<VariantClosure> mObjectVector = new ArrayList();
    private boolean mObjectVectorLocked;
    protected WeakReference<Dispatch2> mOwner;
    protected Rect mWindowExposedRegion = new Rect();
    protected boolean mWindowUpdating;
    private DrawTarget mTargetWindow;
    protected NativeImageBuffer mOffscreenBuffer;
    private boolean mIsMainWindow;
    private boolean mDrawUpdateRectangle = false;
    protected int mPrimaryLayerManagerIndex;
    private ArrayList<LayerManager> mManagers = new ArrayList();
    private Rect mDestRect = new Rect();
    private boolean mShouldShow;
    private Dispatch2 mMenuItemObject;
    private WindowForm mForm;
    public static final int mcsVisible = 0;
    public static final int mcsTempHidden = 1;
    public static final int mcsHidden = 2;
    private static final int imDisable = 0;
    private static final int imClose = 1;
    private static final int imOpen = 2;
    private static final int imDontCare = 3;
    private static final int imSAlpha = 4;
    private static final int imAlpha = 5;
    private static final int imHira = 6;
    private static final int imSKata = 7;
    private static final int imKata = 8;
    private static final int imChinese = 9;
    private static final int imSHanguel = 10;
    private static final int imHanguel = 11;
    ObjectList<VideoOverlayNI> mVideoOverlay = new ObjectList();
    private static final int etUnknown = 0;
    private static final int etOnKeyDown = 1;
    private static final int etOnKeyUp = 2;
    private static final int etOnKeyPress = 3;

    public Dispatch2 getOwner() {
        return (Dispatch2)this.mOwner.get();
    }

    public Dispatch2 getWindowDispatch() {
        if (this.mOwner != null) {
            return (Dispatch2)this.mOwner.get();
        }
        return null;
    }

    @Override
    public int construct(Variant[] param, Dispatch2 tjs_obj) throws TJSException {
        this.mOwner = new WeakReference<Dispatch2>(tjs_obj);
        TVP.WindowList.registerWindowToList(this);
        this.mForm = new WindowForm(this);
        return 0;
    }

    @Override
    public void invalidate() throws VariantException, TJSException {
        int i;
        int count;
        TVP.WindowList.unregisterWindowToList(this);
        TVP.EventManager.cancelSourceEvents((Dispatch2)this.mOwner.get());
        TVP.EventManager.cancelInputEvents(this);
        TVP.EventManager.removeWindowUpdate(this);
        try {
            this.mVideoOverlay.safeLock();
            count = this.mVideoOverlay.getSafeLockedObjectCount();
            i = 0;
            while (i < count) {
                VideoOverlayNI item = this.mVideoOverlay.getSafeLockedObjectAt(i);
                if (item != null) {
                    item.disconnect();
                }
                ++i;
            }
        }
        finally {
            this.mVideoOverlay.safeUnlock();
        }
        this.mObjectVectorLocked = true;
        count = this.mObjectVector.size();
        i = 0;
        while (i < count) {
            VariantClosure clo = this.mObjectVector.get(i);
            try {
                clo.invalidate(0, null, null);
                clo = null;
            }
            catch (TJSException e) {
                DebugClass.addLog(e.getMessage());
            }
            ++i;
        }
        if (this.mMenuItemObject != null) {
            this.mMenuItemObject.invalidate(0, null, this.mMenuItemObject);
            this.mMenuItemObject = null;
        }
        super.invalidate();
        if (this.mForm != null) {
            this.mForm.invalidateClose();
            this.mForm = null;
        }
        TVP.EventManager.cancelSourceEvents((Dispatch2)this.mOwner.get());
        TVP.EventManager.cancelInputEvents(this);
        this.mOwner.clear();
    }

    public boolean isMainWindow() {
        return TVP.MainWindow == this;
    }

    public void fireOnActivate(boolean activate_or_deactivate) {
        TVP.EventManager.postInputEvent(new WindowEvents.OnWindowActivateEvent(this, activate_or_deactivate), 1);
    }

    public void fireOnOrientationChanged() {
        TVP.EventManager.postInputEvent(new WindowEvents.OnOrientationChangedEvent(this), 1);
    }

    public void onClose() {
        if (!this.canDeliverEvents()) {
            return;
        }
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner != null) {
            Variant[] arg = new Variant[]{new Variant(1)};
            TVP.EventManager.postEvent(owner, owner, "onCloseQuery", 0, 2, arg);
        }
    }

    public void onResize() {
        if (!this.canDeliverEvents()) {
            return;
        }
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner != null) {
            TVP.EventManager.postEvent(owner, owner, "onResize", 0, 2, TJS.NULL_ARG);
        }
    }

    public void onClick(int x, int y) throws TJSException {
        Point pos;
        if (!this.canDeliverEvents()) {
            return;
        }
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner != null) {
            Variant[] arg = new Variant[]{new Variant(x), new Variant(y)};
            TVP.EventManager.postEvent(owner, owner, "onClick", 0, 2, arg);
        }
        if (!this.transformToPrimaryLayerManager(pos = new Point(x, y))) {
            return;
        }
        LayerManager manager = this.getLayerManagerAt(this.mPrimaryLayerManagerIndex);
        if (manager == null) {
            return;
        }
        manager.notifyClick(pos.x, pos.y);
    }

    public void onDoubleClick(int x, int y) throws TJSException {
        Point pos;
        if (!this.canDeliverEvents()) {
            return;
        }
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner != null) {
            Variant[] arg = new Variant[]{new Variant(x), new Variant(y)};
            TVP.EventManager.postEvent(owner, owner, "onDoubleClick", 0, 2, arg);
        }
        if (!this.transformToPrimaryLayerManager(pos = new Point(x, y))) {
            return;
        }
        LayerManager manager = this.getLayerManagerAt(this.mPrimaryLayerManagerIndex);
        if (manager == null) {
            return;
        }
        manager.notifyDoubleClick(pos.x, pos.y);
    }

    public void onMouseDown(int x, int y, int mb, int flags) throws TJSException {
        Point pos;
        if (!this.canDeliverEvents()) {
            return;
        }
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner != null) {
            Variant[] arg = new Variant[]{new Variant(x), new Variant(y), new Variant(mb), new Variant(flags)};
            TVP.EventManager.postEvent(owner, owner, "onMouseDown", 0, 2, arg);
        }
        if (!this.transformToPrimaryLayerManager(pos = new Point(x, y))) {
            return;
        }
        LayerManager manager = this.getLayerManagerAt(this.mPrimaryLayerManagerIndex);
        if (manager == null) {
            return;
        }
        manager.notifyMouseDown(pos.x, pos.y, mb, flags);
    }

    public void onMouseUp(int x, int y, int mb, int flags) throws TJSException {
        Point pos;
        if (!this.canDeliverEvents()) {
            return;
        }
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner != null) {
            Variant[] arg = new Variant[]{new Variant(x), new Variant(y), new Variant(mb), new Variant(flags)};
            TVP.EventManager.postEvent(owner, owner, "onMouseUp", 0, 2, arg);
        }
        if (!this.transformToPrimaryLayerManager(pos = new Point(x, y))) {
            return;
        }
        LayerManager manager = this.getLayerManagerAt(this.mPrimaryLayerManagerIndex);
        if (manager == null) {
            return;
        }
        manager.notifyMouseUp(pos.x, pos.y, mb, flags);
    }

    public void onMouseMove(int x, int y, int flags) throws TJSException {
        Point pos;
        if (!this.canDeliverEvents()) {
            return;
        }
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner != null) {
            Variant[] arg = new Variant[]{new Variant(x), new Variant(y), new Variant(flags)};
            TVP.EventManager.postEvent(owner, owner, "onMouseMove", 0, 2, arg);
        }
        if (!this.transformToPrimaryLayerManager(pos = new Point(x, y))) {
            return;
        }
        LayerManager manager = this.getLayerManagerAt(this.mPrimaryLayerManagerIndex);
        if (manager == null) {
            return;
        }
        manager.notifyMouseMove(pos.x, pos.y, flags);
    }

    public void onReleaseCapture() {
        if (!this.canDeliverEvents()) {
            return;
        }
        LayerManager manager = this.getLayerManagerAt(this.mPrimaryLayerManagerIndex);
        if (manager == null) {
            return;
        }
        manager.releaseCapture();
    }

    public void onMouseOutOfWindow() throws TJSException {
        if (!this.canDeliverEvents()) {
            return;
        }
        LayerManager manager = this.getLayerManagerAt(this.mPrimaryLayerManagerIndex);
        if (manager == null) {
            return;
        }
        manager.notifyMouseOutOfWindow();
    }

    public void onMouseEnter() {
        if (!this.canDeliverEvents()) {
            return;
        }
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner != null) {
            TVP.EventManager.postEvent(owner, owner, "onMouseEnter", 0, 2, TJS.NULL_ARG);
        }
    }

    public void onMouseLeave() {
        if (!this.canDeliverEvents()) {
            return;
        }
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner != null) {
            TVP.EventManager.postEvent(owner, owner, "onMouseLeave", 0, 2, TJS.NULL_ARG);
        }
    }

    public void onKeyDown(int key, int shift) throws TJSException {
        LayerManager manager;
        if (!this.canDeliverEvents()) {
            return;
        }
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner != null) {
            Variant[] arg = new Variant[]{new Variant(key), new Variant(shift)};
            TVP.EventManager.postEvent(owner, owner, "onKeyDown", 0, 2, arg);
        }
        if ((manager = this.getLayerManagerAt(this.mPrimaryLayerManagerIndex)) == null) {
            return;
        }
        manager.notifyKeyDown(key, shift);
    }

    public void onKeyUp(int key, int shift) {
        LayerManager manager;
        if (!this.canDeliverEvents()) {
            return;
        }
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner != null) {
            Variant[] arg = new Variant[]{new Variant(key), new Variant(shift)};
            TVP.EventManager.postEvent(owner, owner, "onKeyUp", 0, 2, arg);
        }
        if ((manager = this.getLayerManagerAt(this.mPrimaryLayerManagerIndex)) == null) {
            return;
        }
        manager.notifyKeyUp(key, shift);
    }

    public void onKeyPress(char key) {
        LayerManager manager;
        if (!this.canDeliverEvents()) {
            return;
        }
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner != null) {
            Variant[] arg = new Variant[]{new Variant(String.valueOf(key))};
            TVP.EventManager.postEvent(owner, owner, "onKeyPress", 0, 2, arg);
        }
        if ((manager = this.getLayerManagerAt(this.mPrimaryLayerManagerIndex)) == null) {
            return;
        }
        manager.notifyKeyPress(key);
    }

    public void onFileDrop(Variant array) {
        if (!this.canDeliverEvents()) {
            return;
        }
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner != null) {
            Variant[] arg = new Variant[]{array};
            TVP.EventManager.postEvent(owner, owner, "onFileDrop", 0, 2, arg);
        }
    }

    public void onMouseWheel(int shift, int delta, int x, int y) {
        Point pos;
        if (!this.canDeliverEvents()) {
            return;
        }
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner != null) {
            Variant[] arg = new Variant[]{new Variant(shift), new Variant(delta), new Variant(x), new Variant(y)};
            TVP.EventManager.postEvent(owner, owner, "onMouseWheel", 0, 2, arg);
        }
        if (!this.transformToPrimaryLayerManager(pos = new Point(x, y))) {
            return;
        }
        LayerManager manager = this.getLayerManagerAt(this.mPrimaryLayerManagerIndex);
        if (manager == null) {
            return;
        }
        manager.notifyMouseWheel(shift, delta, pos.x, pos.y);
    }

    public void onPopupHide() {
        if (!this.canDeliverEvents()) {
            return;
        }
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner != null) {
            TVP.EventManager.postEvent(owner, owner, "onPopupHide", 0, 2, TJS.NULL_ARG);
        }
    }

    public void onActivate(boolean activate_or_deactivate) {
        if (!this.canDeliverEvents()) {
            return;
        }
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner != null && this.getWindowActive() == activate_or_deactivate) {
            if (activate_or_deactivate) {
                TVP.EventManager.postEvent(owner, owner, "onActivate", 0, 2, TJS.NULL_ARG);
            } else {
                TVP.EventManager.postEvent(owner, owner, "onDeactivate", 0, 2, TJS.NULL_ARG);
            }
        }
    }

    public void onOrientationChanged() {
        if (!this.canDeliverEvents()) {
            return;
        }
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner != null) {
            TVP.EventManager.postEvent(owner, owner, "onOrientationChanged", 0, 2, TJS.NULL_ARG);
        }
    }

    public void clearInputEvents() {
        TVP.EventManager.cancelInputEvents(this);
    }

    public void postReleaseCaptureEvent() {
        TVP.EventManager.postInputEvent(new WindowEvents.OnReleaseCaptureInputEvent(this), 0);
    }

    public void registerLayerManager(LayerManager manager) {
        this.mManagers.add(manager);
    }

    public void unregisterLayerManager(LayerManager manager) throws TJSException {
        int count = this.mManagers.size();
        int i = 0;
        while (i < count) {
            LayerManager man = this.mManagers.get(i);
            if (manager == man) {
                this.mManagers.remove(i);
                return;
            }
            ++i;
        }
        Message.throwExceptionMessage("\u5185\u90e8\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f: at %1 line %2");
    }

    public void notifyWindowExposureToLayer(Rect cliprect) {
        this.requestInvalidation(cliprect);
    }

    public void notifyUpdateRegionFixed(ComplexRect updaterects) {
        this.beginUpdate(updaterects);
    }

    public void updateContent() throws VariantException, TJSException {
        this.update();
        this.show();
        this.endUpdate();
    }

    public void deliverDrawDeviceShow() throws TJSException {
        this.show();
    }

    public void beginUpdate(ComplexRect rects) {
        this.mWindowUpdating = true;
    }

    public void endUpdate() {
        this.mWindowUpdating = false;
    }

    public void requestUpdate() {
        TVP.EventManager.postWindowUpdate(this);
    }

    public void dumpPrimaryLayerStructure() {
        this.dumpLayerStructure();
    }

    private void dumpLayerStructure() {
        int count = this.mManagers.size();
        int i = 0;
        while (i < count) {
            LayerManager m = this.mManagers.get(i);
            m.dumpLayerStructure();
            ++i;
        }
    }

    public void recheckInputState() throws TJSException {
        LayerManager manager = this.getLayerManagerAt(this.mPrimaryLayerManagerIndex);
        if (manager == null) {
            return;
        }
        manager.recheckInputState();
    }

    public void setShowUpdateRect(boolean b) {
        this.mDrawUpdateRectangle = b;
    }

    public void add(VariantClosure clo) {
        if (this.mObjectVectorLocked) {
            return;
        }
        int idx = this.mObjectVector.indexOf(clo);
        if (idx < 0) {
            this.mObjectVector.add(clo);
        }
    }

    public void remove(VariantClosure clo) {
        if (this.mObjectVectorLocked) {
            return;
        }
        int idx = this.mObjectVector.indexOf(clo);
        if (idx >= 0) {
            this.mObjectVector.remove(idx);
        }
    }

    public Dispatch2 getMenuItemObject() throws TJSException {
        if (this.mMenuItemObject != null) {
            return this.mMenuItemObject;
        }
        Dispatch2 owner = (Dispatch2)this.mOwner.get();
        if (owner == null) {
            Message.throwExceptionMessage("\u5185\u90e8\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f: at %1 line %2", "BaseWindowNI.getMenuItemObject");
        }
        this.mMenuItemObject = TVP.createMenuItemObject(owner);
        return this.mMenuItemObject;
    }

    LayerNI getPrimaryLayer() {
        LayerManager manager = this.getLayerManagerAt(this.mPrimaryLayerManagerIndex);
        if (manager == null) {
            return null;
        }
        return manager.getPrimaryLayer();
    }

    public LayerManager getLayerManagerAt(int index) {
        if (this.mManagers.size() <= index) {
            return null;
        }
        return this.mManagers.get(index);
    }

    public LayerNI getFocusedLayer() {
        LayerManager manager = this.getLayerManagerAt(this.mPrimaryLayerManagerIndex);
        if (manager == null) {
            return null;
        }
        return manager.getFocusedLayer();
    }

    public void setFocusedLayer(LayerNI layer) throws TJSException {
        LayerManager manager = this.getLayerManagerAt(this.mPrimaryLayerManagerIndex);
        if (manager == null) {
            return;
        }
        manager.setFocusedLayer(layer);
    }

    private void requestInvalidation(Rect rect) {
        Point lt = new Point(rect.left, rect.top);
        Point rb = new Point(rect.right, rect.bottom);
        if (!this.transformToPrimaryLayerManager(lt)) {
            return;
        }
        if (!this.transformToPrimaryLayerManager(rb)) {
            return;
        }
        ++rb.x;
        ++rb.y;
        LayerManager manager = this.getLayerManagerAt(this.mPrimaryLayerManagerIndex);
        if (manager == null) {
            return;
        }
        manager.requestInvalidation(new Rect(lt.x, lt.y, rb.x, rb.y));
    }

    private void show() throws TJSException {
        this.mTargetWindow.show();
    }

    private void update() throws VariantException, TJSException {
        int count = this.mManagers.size();
        int i = 0;
        while (i < count) {
            LayerManager m = this.mManagers.get(i);
            m.updateToDrawDevice();
            ++i;
        }
    }

    public void setImeMode(LayerManager manager, int mode) {
        LayerManager primary_manager = this.getLayerManagerAt(this.mPrimaryLayerManagerIndex);
        if (primary_manager == null) {
            return;
        }
        if (primary_manager == manager) {
            this.setImeMode(mode);
        }
    }

    public void resetImeMode(LayerManager manager) {
        LayerManager primary_manager = this.getLayerManagerAt(this.mPrimaryLayerManagerIndex);
        if (primary_manager == null) {
            return;
        }
        if (primary_manager == manager) {
            this.resetImeMode();
        }
    }

    public void setAttentionPoint(LayerManager manager, LayerNI layer, Point pt) {
        LayerManager primary_manager = this.getLayerManagerAt(this.mPrimaryLayerManagerIndex);
        if (primary_manager == null) {
            return;
        }
        if (primary_manager == manager && this.transformFromPrimaryLayerManager(pt)) {
            this.setAttentionPoint(layer, pt);
        }
    }

    private boolean transformToPrimaryLayerManager(Point pt) {
        LayerManager manager = this.getLayerManagerAt(this.mPrimaryLayerManagerIndex);
        if (manager == null) {
            return false;
        }
        Size pl = new Size();
        if (!manager.getPrimaryLayerSize(pl)) {
            return false;
        }
        int w = this.mDestRect.width();
        int h = this.mDestRect.height();
        pt.x = w != 0 ? pt.x * pl.width / w : 0;
        pt.y = h != 0 ? pt.y * pl.height / h : 0;
        return true;
    }

    private boolean transformFromPrimaryLayerManager(Point pt) {
        LayerManager manager = this.getLayerManagerAt(this.mPrimaryLayerManagerIndex);
        if (manager == null) {
            return false;
        }
        Size pl = new Size();
        if (!manager.getPrimaryLayerSize(pl)) {
            return false;
        }
        pt.x = pl.width != 0 ? pt.x * this.mDestRect.width() / pl.width : 0;
        pt.y = pl.height != 0 ? pt.y * this.mDestRect.height() / pl.height : 0;
        return true;
    }

    public void disableAttentionPoint(LayerManager manager) {
        LayerManager primary_manager = this.getLayerManagerAt(this.mPrimaryLayerManagerIndex);
        if (primary_manager == null) {
            return;
        }
        if (primary_manager == manager) {
            this.disableAttentionPoint();
        }
    }

    public void notifyLayerImageChange(LayerManager manager) {
        LayerManager primary_manager = this.getLayerManagerAt(this.mPrimaryLayerManagerIndex);
        if (primary_manager == manager) {
            this.requestUpdate();
        }
    }

    public void setTargetWindow(DrawTarget target, boolean ismain) {
        this.mTargetWindow = target;
        this.mIsMainWindow = ismain;
    }

    public void notifyBitmapCompleted(LayerManager layerManager, int x, int y, NativeImageBuffer nativeImageBuffer, Rect cliprect, int type, int opacity) throws TJSException {
        this.mTargetWindow.drawImage(x, y, nativeImageBuffer, cliprect, type, opacity);
        if (this.mDrawUpdateRectangle) {
            int rleft = x;
            int rtop = y;
            int rright = rleft + cliprect.width();
            int rbottom = rtop + cliprect.height();
            Point[] points = new Point[]{new Point(rleft, rtop), new Point(rright - 1, rtop), new Point(rright - 1, rbottom - 1), new Point(rleft, rbottom - 1)};
            this.mTargetWindow.drawLines(points, 0xFFFF00);
            points = null;
        }
    }

    public void windowReleaseCapture(LayerManager manager) {
        LayerManager primary_manager = this.getLayerManagerAt(this.mPrimaryLayerManagerIndex);
        if (primary_manager == null) {
            return;
        }
        if (primary_manager == manager) {
            this.windowReleaseCapture();
        }
    }

    public void notifyLayerResize(LayerManager manager) throws TJSException {
        LayerManager primary_manager = this.getLayerManagerAt(this.mPrimaryLayerManagerIndex);
        if (primary_manager == manager) {
            this.notifySrcResize();
        }
    }

    public void startBitmapCompletion(LayerManager manager) {
    }

    public void endBitmapCompletion(LayerManager manager) {
    }

    public void setDestRectangle(Rect rect) {
        this.mDestRect.set(rect);
    }

    public void setCursorPos(LayerManager manager, int x, int y) {
        Point pos;
        LayerManager primary_manager = this.getLayerManagerAt(this.mPrimaryLayerManagerIndex);
        if (primary_manager == null) {
            return;
        }
        if (primary_manager == manager && this.transformFromPrimaryLayerManager(pos = new Point(x, y))) {
            this.setCursorPos(pos.x, pos.y);
        }
    }

    public void setDefaultMouseCursor(LayerManager manager) {
        LayerManager primary_manager = this.getLayerManagerAt(this.mPrimaryLayerManagerIndex);
        if (primary_manager == null) {
            return;
        }
        if (primary_manager == manager) {
            this.setDefaultMouseCursor();
        }
    }

    public void setMouseCursor(LayerManager manager, int cursor) {
        LayerManager primary_manager = this.getLayerManagerAt(this.mPrimaryLayerManagerIndex);
        if (primary_manager == null) {
            return;
        }
        if (primary_manager == manager) {
            this.setMouseCursor(cursor);
        }
    }

    public void getCursorPos(LayerManager manager, Point pos) {
        LayerManager primary_manager = this.getLayerManagerAt(this.mPrimaryLayerManagerIndex);
        if (primary_manager == null) {
            return;
        }
        this.getCursorPos(pos);
        if (primary_manager != manager || !this.transformToPrimaryLayerManager(pos)) {
            pos.x = 0;
            pos.y = 0;
        }
    }

    public void setHintText(LayerManager manager, String text) {
        LayerManager primary_manager = this.getLayerManagerAt(this.mPrimaryLayerManagerIndex);
        if (primary_manager == null) {
            return;
        }
        if (primary_manager == manager) {
            this.setHintText(text);
        }
    }

    public boolean canDeliverEvents() {
        if (this.mForm == null) {
            return false;
        }
        return this.getVisible() && this.mForm.getFormEnabled();
    }

    public WindowForm getForm() {
        return this.mForm;
    }

    public void notifyWindowClose() {
        this.mForm = null;
    }

    public void sendCloseMessage() {
        if (this.mForm != null) {
            this.mForm.sendCloseMessage();
        }
    }

    public void tickBeat() throws TJSException {
        if (this.mForm != null) {
            this.mForm.tickBeat();
        }
    }

    protected boolean getWindowActive() {
        if (this.mForm != null) {
            return this.mForm.getWindowActive();
        }
        return false;
    }

    public void resetDrawDevice() throws TJSException {
        if (this.mForm != null) {
            this.mForm.resetDrawDevice();
        }
    }

    public void postInputEvent(String name, Dispatch2 params) throws TJSException {
        if (this.mForm == null) {
            return;
        }
        String key_name = "key";
        String shift_name = "shift";
        int type = "onKeyDown".equals(name) ? 1 : ("onKeyUp".equals(name) ? 2 : ("onKeyPress".equals(name) ? 3 : 0));
        if (type == 0) {
            Message.throwExceptionMessage("\u30a4\u30d9\u30f3\u30c8\u540d %1 \u306f\u672a\u77e5\u306e\u30a4\u30d9\u30f3\u30c8\u540d\u3067\u3059", name);
        }
        if (type == 1 || type == 2) {
            if (params == null) {
                Message.throwExceptionMessage("\u30a4\u30d9\u30f3\u30c8 %1 \u306b\u306f\u30d1\u30e9\u30e1\u30fc\u30bf\u304c\u5fc5\u8981\u3067\u3059", name);
            }
            int key = 0;
            int shift = 0;
            Variant val = new Variant();
            int hr = params.propGet(0, "key", val, params);
            if (hr >= 0) {
                key = val.asInteger();
            } else {
                Message.throwExceptionMessage("\u30a4\u30d9\u30f3\u30c8 %1 \u306b\u306f\u30d1\u30e9\u30e1\u30fc\u30bf %2 \u304c\u5fc5\u8981\u3067\u3059", name, "key");
            }
            hr = params.propGet(0, "shift", val, params);
            if (hr >= 0) {
                shift = val.asInteger();
            } else {
                Message.throwExceptionMessage("\u30a4\u30d9\u30f3\u30c8 %1 \u306b\u306f\u30d1\u30e9\u30e1\u30fc\u30bf %2 \u304c\u5fc5\u8981\u3067\u3059", name, "shift");
            }
            char vcl_key = (char)key;
            if (type == 1) {
                this.mForm.internalKeyDown(key, shift);
            } else if (type == 2) {
                this.mForm.onKeyUp(vcl_key, shift);
            }
        } else if (type == 3) {
            if (params == null) {
                Message.throwExceptionMessage("\u30a4\u30d9\u30f3\u30c8 %1 \u306b\u306f\u30d1\u30e9\u30e1\u30fc\u30bf\u304c\u5fc5\u8981\u3067\u3059", name);
            }
            int key = 0;
            Variant val = new Variant();
            int hr = params.propGet(0, "key", val, params);
            if (hr >= 0) {
                key = val.asInteger();
            } else {
                Message.throwExceptionMessage("\u30a4\u30d9\u30f3\u30c8 %1 \u306b\u306f\u30d1\u30e9\u30e1\u30fc\u30bf %2 \u304c\u5fc5\u8981\u3067\u3059", name, "key");
            }
            char vcl_key = (char)key;
            this.mForm.onKeyPress(vcl_key);
        }
    }

    public void notifySrcResize() throws TJSException {
        if (this.mWindowUpdating) {
            Message.throwExceptionMessage("\u753b\u9762\u66f4\u65b0\u4e2d\u306f\u3053\u306e\u6a5f\u80fd\u3092\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093");
        }
        Size s = new Size();
        this.getSrcSize(s);
        if (this.mForm != null) {
            this.mForm.setPaintBoxSize(s.width, s.height);
        }
    }

    void getSrcSize(Size s) {
        s.width = 0;
        s.height = 0;
        LayerManager manager = this.getLayerManagerAt(this.mPrimaryLayerManagerIndex);
        if (manager == null) {
            return;
        }
        if (!manager.getPrimaryLayerSize(s)) {
            s.width = 0;
            s.height = 0;
        }
    }

    public void setDefaultMouseCursor() {
        if (this.mForm != null) {
            this.mForm.setDefaultMouseCursor();
        }
    }

    public void setMouseCursor(int handle) {
        if (this.mForm != null) {
            this.mForm.setMouseCursor(handle);
        }
    }

    public void getCursorPos(Point pt) {
        if (this.mForm != null) {
            this.mForm.getCursorPos(pt);
        }
    }

    public void setCursorPos(int x, int y) {
        if (this.mForm != null) {
            this.mForm.setCursorPos(x, y);
        }
    }

    public void windowReleaseCapture() {
    }

    public void setHintText(String text) {
        if (this.mForm != null) {
            this.mForm.setHintText(text);
        }
    }

    public void setAttentionPoint(LayerNI layer, Point pt) {
        if (this.mForm != null) {
            Font font = null;
            this.mForm.setAttentionPoint(pt.x, pt.y, font);
        }
    }

    public void disableAttentionPoint() {
        if (this.mForm != null) {
            this.mForm.disableAttentionPoint();
        }
    }

    public void setImeMode(int mode) {
        if (this.mForm != null) {
            this.mForm.setImeMode(mode);
        }
    }

    public void setDefaultImeMode(int mode) {
    }

    public int getDefaultImeMode() {
        if (this.mForm != null) {
            return this.mForm.getDefaultImeMode();
        }
        return 0;
    }

    public void resetImeMode() {
        if (this.mForm != null) {
            this.mForm.resetImeMode();
        }
    }

    public MenuItem getRootMenuItem() {
        if (this.mForm == null) {
            return null;
        }
        return this.mForm.getMainMenu();
    }

    public void setMenuBarVisible(boolean b) throws TJSException {
        if (this.mForm == null) {
            return;
        }
        if (this.mForm.getFullScreenMode()) {
            Message.throwExceptionMessage("\u30d5\u30eb\u30b9\u30af\u30ea\u30fc\u30f3\u4e2d\u3067\u306f\u64cd\u4f5c\u3067\u304d\u306a\u3044\u30d7\u30ed\u30d1\u30c6\u30a3\u3092\u8a2d\u5b9a\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f");
        }
        this.mForm.setMenuBarVisible(b);
    }

    public boolean getMenuBarVisible() {
        if (this.mForm == null) {
            return false;
        }
        return this.mForm.getMenuBarVisible();
    }

    public void zoomRectangle(Rect rect) {
        if (this.mForm == null) {
            return;
        }
        this.mForm.zoomRectangle(rect);
    }

    public void readjustVideoRect() {
        if (this.mForm == null) {
            return;
        }
    }

    public void windowMoved() {
    }

    public void detachVideoOverlay() {
    }

    public void close() {
        if (this.mForm != null) {
            this.mForm.close();
        }
    }

    public void beginMove() throws TJSException {
        if (this.mForm != null) {
            if (this.mForm.getFullScreenMode()) {
                Message.throwExceptionMessage("\u30d5\u30eb\u30b9\u30af\u30ea\u30fc\u30f3\u4e2d\u3067\u306f\u64cd\u4f5c\u3067\u304d\u306a\u3044\u30e1\u30bd\u30c3\u30c9\u3092\u547c\u3073\u51fa\u305d\u3046\u3068\u3057\u307e\u3057\u305f");
            }
            this.mForm.beginMove();
        }
    }

    public void bringToFront() {
        if (this.mForm != null) {
            this.mForm.bringToFront();
        }
    }

    public void update(int type) throws VariantException, TJSException {
        if (this.mForm != null) {
            this.mForm.updateWindow(type);
        }
    }

    public void showModal() throws TJSException {
        if (this.mForm != null) {
            if (this.mForm.getFullScreenMode()) {
                Message.throwExceptionMessage("\u30d5\u30eb\u30b9\u30af\u30ea\u30fc\u30f3\u4e2d\u3067\u306f\u64cd\u4f5c\u3067\u304d\u306a\u3044\u30e1\u30bd\u30c3\u30c9\u3092\u547c\u3073\u51fa\u305d\u3046\u3068\u3057\u307e\u3057\u305f");
            }
            TVP.WindowList.clearAllWindowInputEvents();
            this.mForm.showWindowAsModal();
        }
    }

    public void hideMouseCursor() {
        if (this.mForm != null) {
            this.mForm.hideMouseCursor();
        }
    }

    public boolean getVisible() {
        if (this.mForm == null) {
            return false;
        }
        return this.mForm.getVisible();
    }

    public void setVisible(boolean s) throws TJSException {
        if (this.mForm != null) {
            if (this.mForm.getFullScreenMode()) {
                Message.throwExceptionMessage("\u30d5\u30eb\u30b9\u30af\u30ea\u30fc\u30f3\u4e2d\u3067\u306f\u64cd\u4f5c\u3067\u304d\u306a\u3044\u30d7\u30ed\u30d1\u30c6\u30a3\u3092\u8a2d\u5b9a\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f");
            }
            this.mForm.setVisible(s);
        }
    }

    public String getCaption() {
        if (this.mForm != null) {
            return this.mForm.getCaption();
        }
        return null;
    }

    public void setCaption(String v) {
        if (this.mForm != null) {
            this.mForm.setCaption(v);
        }
    }

    public void setWidth(int w) throws TJSException {
        if (this.mForm != null) {
            if (this.mForm.getFullScreenMode()) {
                Message.throwExceptionMessage("\u30d5\u30eb\u30b9\u30af\u30ea\u30fc\u30f3\u4e2d\u3067\u306f\u64cd\u4f5c\u3067\u304d\u306a\u3044\u30d7\u30ed\u30d1\u30c6\u30a3\u3092\u8a2d\u5b9a\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f");
            }
            this.mForm.setWidth(w);
        }
    }

    public int getWidth() {
        if (this.mForm == null) {
            return 0;
        }
        return this.mForm.getWidth();
    }

    public void setHeight(int h) throws TJSException {
        if (this.mForm != null) {
            if (this.mForm.getFullScreenMode()) {
                Message.throwExceptionMessage("\u30d5\u30eb\u30b9\u30af\u30ea\u30fc\u30f3\u4e2d\u3067\u306f\u64cd\u4f5c\u3067\u304d\u306a\u3044\u30d7\u30ed\u30d1\u30c6\u30a3\u3092\u8a2d\u5b9a\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f");
            }
            this.mForm.setHeight(h);
        }
    }

    public int getHeight() {
        if (this.mForm == null) {
            return 0;
        }
        return this.mForm.getHeight();
    }

    public void setLeft(int l) throws TJSException {
        if (this.mForm != null) {
            if (this.mForm.getFullScreenMode()) {
                Message.throwExceptionMessage("\u30d5\u30eb\u30b9\u30af\u30ea\u30fc\u30f3\u4e2d\u3067\u306f\u64cd\u4f5c\u3067\u304d\u306a\u3044\u30d7\u30ed\u30d1\u30c6\u30a3\u3092\u8a2d\u5b9a\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f");
            }
            this.mForm.setLeft(l);
        }
    }

    public int getLeft() {
        if (this.mForm == null) {
            return 0;
        }
        return this.mForm.getLeft();
    }

    public void setTop(int t) throws TJSException {
        if (this.mForm != null) {
            if (this.mForm.getFullScreenMode()) {
                Message.throwExceptionMessage("\u30d5\u30eb\u30b9\u30af\u30ea\u30fc\u30f3\u4e2d\u3067\u306f\u64cd\u4f5c\u3067\u304d\u306a\u3044\u30d7\u30ed\u30d1\u30c6\u30a3\u3092\u8a2d\u5b9a\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f");
            }
            this.mForm.setTop(t);
        }
    }

    public int getTop() {
        if (this.mForm == null) {
            return 0;
        }
        return this.mForm.getTop();
    }

    public void setSize(int w, int h) throws TJSException {
        if (this.mForm != null) {
            if (this.mForm.getFullScreenMode()) {
                Message.throwExceptionMessage("\u30d5\u30eb\u30b9\u30af\u30ea\u30fc\u30f3\u4e2d\u3067\u306f\u64cd\u4f5c\u3067\u304d\u306a\u3044\u30d7\u30ed\u30d1\u30c6\u30a3\u3092\u8a2d\u5b9a\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f");
            }
            this.mForm.setSize(w, h);
        }
    }

    public void setMinWidth(int v) throws TJSException {
        if (this.mForm != null) {
            if (this.mForm.getFullScreenMode()) {
                Message.throwExceptionMessage("\u30d5\u30eb\u30b9\u30af\u30ea\u30fc\u30f3\u4e2d\u3067\u306f\u64cd\u4f5c\u3067\u304d\u306a\u3044\u30d7\u30ed\u30d1\u30c6\u30a3\u3092\u8a2d\u5b9a\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f");
            }
            this.mForm.setMinWidth(v);
        }
    }

    public int getMinWidth() {
        if (this.mForm != null) {
            return this.mForm.getMinWidth();
        }
        return 0;
    }

    public void setMinHeight(int v) throws TJSException {
        if (this.mForm != null) {
            if (this.mForm.getFullScreenMode()) {
                Message.throwExceptionMessage("\u30d5\u30eb\u30b9\u30af\u30ea\u30fc\u30f3\u4e2d\u3067\u306f\u64cd\u4f5c\u3067\u304d\u306a\u3044\u30d7\u30ed\u30d1\u30c6\u30a3\u3092\u8a2d\u5b9a\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f");
            }
            this.mForm.setMinHeight(v);
        }
    }

    public int getMinHeight() {
        if (this.mForm != null) {
            return this.mForm.getMinHeight();
        }
        return 0;
    }

    public void setMinSize(int w, int h) throws TJSException {
        if (this.mForm != null) {
            if (this.mForm.getFullScreenMode()) {
                Message.throwExceptionMessage("\u30d5\u30eb\u30b9\u30af\u30ea\u30fc\u30f3\u4e2d\u3067\u306f\u64cd\u4f5c\u3067\u304d\u306a\u3044\u30d7\u30ed\u30d1\u30c6\u30a3\u3092\u8a2d\u5b9a\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f");
            }
            this.mForm.setMinSize(w, h);
        }
    }

    public void setMaxWidth(int v) throws TJSException {
        if (this.mForm != null) {
            if (this.mForm.getFullScreenMode()) {
                Message.throwExceptionMessage("\u30d5\u30eb\u30b9\u30af\u30ea\u30fc\u30f3\u4e2d\u3067\u306f\u64cd\u4f5c\u3067\u304d\u306a\u3044\u30d7\u30ed\u30d1\u30c6\u30a3\u3092\u8a2d\u5b9a\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f");
            }
            this.mForm.setMaxWidth(v);
        }
    }

    public int getMaxWidth() {
        if (this.mForm != null) {
            return this.mForm.getMaxWidth();
        }
        return 0;
    }

    public void setMaxHeight(int v) throws TJSException {
        if (this.mForm != null) {
            if (this.mForm.getFullScreenMode()) {
                Message.throwExceptionMessage("\u30d5\u30eb\u30b9\u30af\u30ea\u30fc\u30f3\u4e2d\u3067\u306f\u64cd\u4f5c\u3067\u304d\u306a\u3044\u30d7\u30ed\u30d1\u30c6\u30a3\u3092\u8a2d\u5b9a\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f");
            }
            this.mForm.setMaxHeight(v);
        }
    }

    public int getMaxHeight() {
        if (this.mForm != null) {
            return this.mForm.getMaxHeight();
        }
        return 0;
    }

    public void setMaxSize(int w, int h) throws TJSException {
        if (this.mForm != null) {
            if (this.mForm.getFullScreenMode()) {
                Message.throwExceptionMessage("\u30d5\u30eb\u30b9\u30af\u30ea\u30fc\u30f3\u4e2d\u3067\u306f\u64cd\u4f5c\u3067\u304d\u306a\u3044\u30d7\u30ed\u30d1\u30c6\u30a3\u3092\u8a2d\u5b9a\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f");
            }
            this.mForm.setMaxSize(w, h);
        }
    }

    public void setPosition(int l, int t) throws TJSException {
        if (this.mForm != null) {
            if (this.mForm.getFullScreenMode()) {
                Message.throwExceptionMessage("\u30d5\u30eb\u30b9\u30af\u30ea\u30fc\u30f3\u4e2d\u3067\u306f\u64cd\u4f5c\u3067\u304d\u306a\u3044\u30d7\u30ed\u30d1\u30c6\u30a3\u3092\u8a2d\u5b9a\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f");
            }
            this.mForm.setPosition(l, t);
        }
    }

    public void setLayerLeft(int l) {
        if (this.mForm != null) {
            this.mForm.setLayerLeft(l);
        }
    }

    public int getLayerLeft() {
        if (this.mForm == null) {
            return 0;
        }
        return this.mForm.getLayerLeft();
    }

    public void setLayerTop(int t) {
        if (this.mForm != null) {
            this.mForm.setLayerTop(t);
        }
    }

    public int getLayerTop() {
        if (this.mForm == null) {
            return 0;
        }
        return this.mForm.getLayerTop();
    }

    public void setLayerPosition(int l, int t) {
        if (this.mForm != null) {
            this.mForm.setLayerPosition(l, t);
        }
    }

    public void setInnerSunken(boolean b) throws TJSException {
        if (this.mForm != null) {
            if (this.mForm.getFullScreenMode()) {
                Message.throwExceptionMessage("\u30d5\u30eb\u30b9\u30af\u30ea\u30fc\u30f3\u4e2d\u3067\u306f\u64cd\u4f5c\u3067\u304d\u306a\u3044\u30d7\u30ed\u30d1\u30c6\u30a3\u3092\u8a2d\u5b9a\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f");
            }
            this.mForm.setInnerSunken(b);
        }
    }

    public boolean getInnerSunken() {
        if (this.mForm == null) {
            return true;
        }
        return this.mForm.getInnerSunken();
    }

    public void setInnerWidth(int w) throws TJSException {
        if (this.mForm != null) {
            if (this.mForm.getFullScreenMode()) {
                Message.throwExceptionMessage("\u30d5\u30eb\u30b9\u30af\u30ea\u30fc\u30f3\u4e2d\u3067\u306f\u64cd\u4f5c\u3067\u304d\u306a\u3044\u30d7\u30ed\u30d1\u30c6\u30a3\u3092\u8a2d\u5b9a\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f");
            }
            this.mForm.setInnerWidth(w);
        }
    }

    public int getInnerWidth() {
        if (this.mForm == null) {
            return 0;
        }
        return this.mForm.getInnerWidth();
    }

    public void setInnerHeight(int h) throws TJSException {
        if (this.mForm != null) {
            if (this.mForm.getFullScreenMode()) {
                Message.throwExceptionMessage("\u30d5\u30eb\u30b9\u30af\u30ea\u30fc\u30f3\u4e2d\u3067\u306f\u64cd\u4f5c\u3067\u304d\u306a\u3044\u30d7\u30ed\u30d1\u30c6\u30a3\u3092\u8a2d\u5b9a\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f");
            }
            this.mForm.setInnerHeight(h);
        }
    }

    public int getInnerHeight() {
        if (this.mForm == null) {
            return 0;
        }
        return this.mForm.getInnerHeight();
    }

    public void setInnerSize(int w, int h) throws TJSException {
        if (this.mForm != null) {
            if (this.mForm.getFullScreenMode()) {
                Message.throwExceptionMessage("\u30d5\u30eb\u30b9\u30af\u30ea\u30fc\u30f3\u4e2d\u3067\u306f\u64cd\u4f5c\u3067\u304d\u306a\u3044\u30d7\u30ed\u30d1\u30c6\u30a3\u3092\u8a2d\u5b9a\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f");
            }
            this.mForm.setInnerSize(w, h);
        }
    }

    public void setBorderStyle(int st) throws TJSException {
        if (this.mForm != null) {
            if (this.mForm.getFullScreenMode()) {
                Message.throwExceptionMessage("\u30d5\u30eb\u30b9\u30af\u30ea\u30fc\u30f3\u4e2d\u3067\u306f\u64cd\u4f5c\u3067\u304d\u306a\u3044\u30d7\u30ed\u30d1\u30c6\u30a3\u3092\u8a2d\u5b9a\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f");
            }
            this.mForm.setBorderStyle(st);
        }
    }

    public int getBorderStyle() {
        if (this.mForm == null) {
            return 0;
        }
        return this.mForm.getBorderStyle();
    }

    public void setStayOnTop(boolean b) {
        if (this.mForm == null) {
            return;
        }
        this.mForm.setStayOnTop(b);
    }

    public boolean getStayOnTop() {
        if (this.mForm == null) {
            return false;
        }
        return this.mForm.getStayOnTop();
    }

    public void setShowScrollBars(boolean b) {
        if (this.mForm != null) {
            this.mForm.setShowScrollBars(b);
        }
    }

    public boolean getShowScrollBars() {
        if (this.mForm == null) {
            return true;
        }
        return this.mForm.getShowScrollBars();
    }

    public void setFullScreen(boolean b) {
        if (this.mForm == null) {
            return;
        }
        this.mForm.setFullScreenMode(b);
    }

    public boolean getFullScreen() {
        if (this.mForm == null) {
            return false;
        }
        return this.mForm.getFullScreenMode();
    }

    public void setUseMouseKey(boolean b) {
        if (this.mForm == null) {
            return;
        }
        this.mForm.setUseMouseKey(b);
    }

    public boolean getUseMouseKey() {
        if (this.mForm == null) {
            return false;
        }
        return this.mForm.getUseMouseKey();
    }

    public void setTrapKey(boolean b) {
        if (this.mForm == null) {
            return;
        }
        this.mForm.setTrapKey(b);
    }

    public boolean getTrapKey() {
        if (this.mForm == null) {
            return false;
        }
        return this.mForm.getTrapKey();
    }

    public void setMaskRegion(int threshold) {
        if (this.mForm == null) {
            return;
        }
    }

    public void removeMaskRegion() {
        if (this.mForm == null) {
            return;
        }
        this.mForm.removeMaskRegion();
    }

    public void setMouseCursorState(int mcs) {
        if (this.mForm == null) {
            return;
        }
        this.mForm.setMouseCursorState(mcs);
    }

    public int getMouseCursorState() {
        if (this.mForm == null) {
            return 0;
        }
        return this.mForm.getMouseCursorState();
    }

    public void setFocusable(boolean b) {
        if (this.mForm == null) {
            return;
        }
        this.mForm.setFocusable(b);
    }

    public boolean getFocusable() {
        if (this.mForm != null) {
            return true;
        }
        return this.mForm.getFocusable();
    }

    public void setZoom(int numer, int denom) {
        if (this.mForm == null) {
            return;
        }
        this.mForm.setZoom(numer, denom);
    }

    public void setZoomNumer(int n) {
        if (this.mForm == null) {
            return;
        }
        this.mForm.setZoomNumer(n);
    }

    public int getZoomNumer() {
        if (this.mForm == null) {
            return 1;
        }
        return this.mForm.getZoomNumer();
    }

    public void setZoomDenom(int n) {
        if (this.mForm == null) {
            return;
        }
        this.mForm.setZoomDenom(n);
    }

    public int getZoomDenom() {
        if (this.mForm == null) {
            return 1;
        }
        return this.mForm.getZoomDenom();
    }

    public static void makeFullScreenModeCandidates(ScreenMode preferred, int mode, int zoom_mode, ArrayList<ScreenModeCandidate> candidates) {
        WindowForm.makeFullScreenModeCandidates(preferred, mode, zoom_mode, candidates);
    }

    public void registerWindowMessageReceiver(int asInteger, Dispatch2 asObject, Dispatch2 asObject2) {
    }

    void createOffscreenImage() {
    }

    public void onCloseQueryCalled(boolean b) throws VariantException, TJSException {
        if (this.mForm != null) {
            this.mForm.onCloseQueryCalled(b);
        }
    }

    public void showMenu() {
        if (this.mForm != null) {
            this.mForm.showMenu();
        }
    }

    public void registerVideoOverlayObject(VideoOverlayNI overlay) {
        this.mVideoOverlay.add(overlay);
        overlay.setTargetWindow(this.mForm);
    }

    public void unregisterVideoOverlayObject(VideoOverlayNI overlay) {
        this.mVideoOverlay.remove(overlay);
        overlay.setTargetWindow(null);
    }
}

