/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2env;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.base.FileMedia;
import jp.kirikiri.tvp2.base.Storage;
import jp.kirikiri.tvp2.base.StorageMediaManager;
import jp.kirikiri.tvp2.base.SystemInitializer;
import jp.kirikiri.tvp2.msg.Message;
import jp.kirikiri.tvp2.utils.DebugClass;
import jp.kirikiri.tvp2env.WindowForm;

public class ApplicationSystem {
    public static int MB_OK = 1;
    public static int MB_ICONSTOP = 2;
    private boolean Terminated = false;
    private boolean TerminateOnWindowClose = true;
    private boolean TerminateOnNoWindowStartup = true;
    private int TerminateCode = 0;
    private static final int VersionMajor = 0;
    private static final int VersionMinor = 0;
    private static final int VersionRelease = 1;
    private static final int VersionBuild = 0;
    private static boolean IsSetLookAndFeel = false;
    private static ApplicationSystem mSelf;

    public static void initializeSystem() {
        if (!IsSetLookAndFeel) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                IsSetLookAndFeel = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                // empty catch block
            }
        }
    }

    public static void finalizeApplication() {
    }

    public static void messageBox(String caption, String title, int flags) {
        int messageType = 0;
        JOptionPane.showMessageDialog(null, caption, title, messageType);
    }

    public void showSimpleMessageBox(String text, String caption) {
        JOptionPane.showMessageDialog(null, text, caption, 1);
    }

    public String InputQuery(String caption, String prompt, String value) {
        String ret = JOptionPane.showInputDialog(prompt, (Object)value);
        return ret;
    }

    public boolean showYesNoDialog(String title, String message) {
        int ret;
        WindowForm parent = null;
        if (TVP.MainWindow != null) {
            parent = TVP.MainWindow.getForm();
        }
        return (ret = JOptionPane.showConfirmDialog(parent, message, title, 0)) == 0;
    }

    public ApplicationSystem() {
        TVP.Application = new WeakReference<ApplicationSystem>(this);
        mSelf = this;
    }

    public void terminateAsync(int code) {
        this.Terminated = true;
        this.TerminateCode = code;
        System.exit(code);
    }

    public void terminateSync(int code) {
        TJS.IsTarminating = true;
        TVP.IsTarminating = true;
        SystemInitializer.systemUninitialize();
        System.exit(code);
    }

    public static boolean shellExecute(String target, String param) {
        Runtime runtime = Runtime.getRuntime();
        try {
            if (param != null) {
                String[] params = param.split(" ");
                int count = params.length;
                String[] cmdarray = new String[1 + count];
                cmdarray[0] = target;
                int i = 0;
                while (i < count) {
                    cmdarray[1 + i] = params[i];
                    ++i;
                }
                runtime.exec(cmdarray);
            } else {
                runtime.exec(target);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static String readRegValue(String key) {
        try {
            int last;
            Preferences root = null;
            String nodePath = key.replace('\\', '/');
            if (key.startsWith("HKEY_CURRENT_USER")) {
                root = Preferences.userRoot();
                int first = nodePath.indexOf(47);
                if (first != -1) {
                    nodePath = nodePath.substring(first);
                }
            } else {
                root = Preferences.systemRoot();
            }
            String keyName = (last = nodePath.lastIndexOf(47)) != -1 ? nodePath.substring(last + 1) : nodePath;
            Preferences node = root.node(nodePath = nodePath.substring(0, last));
            if (node != null) {
                return node.get(keyName, null);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getProperty(String key) {
        String name = key.charAt(0) == '-' ? key.substring(1) : key;
        return TVP.Properties.getProperty(name, null);
    }

    public static void setProperty(String key, String value) {
        String name = key.charAt(0) == '-' ? key.substring(1) : key;
        TVP.Properties.setProperty(name, value);
    }

    public static boolean createAppLock(String lockname) {
        return true;
    }

    public final String getVersionString() {
        return String.format("%d.%d.%d.%d", 0, 0, 1, 0);
    }

    public final String getVersionInformation() {
        String verstr = this.getVersionString();
        String tjsverstr = String.format("%d.%d.%d", 2, 4, 28);
        return Message.formatMessage("\u7fbd\u3005\u65ac(\u5409\u91cc\u5409\u91cc2\u4e92\u63db\u30a8\u30f3\u30b8\u30f3) \u5b9f\u884c\u30b3\u30a2/%1 TJS2J/%2 Copyright (C) 2011 T.Imoto and contributors All rights reserved.", verstr, tjsverstr);
    }

    public void registerFileMedia(StorageMediaManager storage) throws TJSException {
        FileMedia filemedia = new FileMedia();
        storage.register(filemedia);
        if (File.separatorChar == '/') {
            storage.setCurrentMediaName("file");
        }
    }

    public void initializeDataPath() throws TJSException {
        String dataDir;
        File dir;
        String dataXP3;
        File file;
        String buf = null;
        boolean bufset = false;
        boolean nosel = false;
        boolean forcesel = false;
        boolean forcedataxp3 = false;
        boolean acceptfilenameargument = false;
        String currentDir = System.getProperty("user.dir");
        if (currentDir.charAt(currentDir.length() - 1) != File.separatorChar) {
            currentDir = String.valueOf(currentDir) + File.separatorChar;
        }
        if (!nosel && (file = new File(dataXP3 = String.valueOf(currentDir) + "data.xp3")).exists() && file.isFile()) {
            buf = dataXP3;
            TVP.ProjectDirSelected = true;
            bufset = true;
            nosel = true;
        }
        if (!forcedataxp3 && !nosel && (dir = new File(dataDir = String.valueOf(currentDir) + "data")).exists() && dir.isDirectory()) {
            buf = String.valueOf(dataDir) + File.separatorChar;
            TVP.ProjectDirSelected = true;
            bufset = true;
            nosel = true;
        }
        if (buf != null) {
            if (buf.charAt(buf.length() - 1) != File.separatorChar) {
                buf = String.valueOf(buf) + '>';
            }
        } else {
            throw new TJSException("data\u30d5\u30a9\u30eb\u30c0/data.xp3 \u304c\u898b\u4ed8\u304b\u308a\u307e\u305b\u3093\u3002\n\u5b9f\u884c\u3059\u308b\u30d5\u30a9\u30eb\u30c0/\u30a2\u30fc\u30ab\u30a4\u30d6\u306f\u30b3\u30de\u30f3\u30c9\u30e9\u30a4\u30f3\u306e\u5f15\u6570\u3068\u3057\u3066\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044");
        }
        if (File.separatorChar == '/') {
            TVP.StorageMediaManager.setCurrentMediaName("file");
        }
        TVP.ProjectDir = TVP.StorageMediaManager.normalizeStorageName(buf, null);
        Storage.setCurrentDirectory(TVP.ProjectDir);
        TVP.NativeProjectDir = buf;
    }

    public static String getAppPath() throws TJSException {
        String path = System.getProperty("user.dir");
        char last = path.charAt(path.length() - 1);
        if (last != '/' && last != '\\') {
            path = String.valueOf(path) + '/';
        }
        path = TVP.StorageMediaManager.normalizeStorageName(path, null);
        return path;
    }

    public static String getPersonalPath() throws TJSException {
        String path = System.getProperty("user.home");
        char last = path.charAt(path.length() - 1);
        if (last != '/' && last != '\\') {
            path = String.valueOf(path) + '/';
        }
        path = TVP.StorageMediaManager.normalizeStorageName(path, null);
        return path;
    }

    public static String getNativeAppPath() throws TJSException {
        return System.getProperty("user.dir");
    }

    public static String getNativePersonalPath() {
        return System.getProperty("user.home");
    }

    public void initializeSaveDataPath(boolean stop_after_datapath_got) throws TJSException {
        String prop = TVP.Properties.getProperty("datapath", "$(exepath)\\savedata");
        if (File.separatorChar == '/') {
            if (prop.indexOf(92) != -1) {
                prop = prop.replace("\\", "/");
            }
        } else if (File.separatorChar == '\\' && prop.indexOf(47) != -1) {
            prop = prop.replace("/", "\\");
        }
        if (prop.indexOf("$(exepath)") >= 0) {
            prop = prop.replace("$(exepath)", ApplicationSystem.getNativeAppPath());
        }
        if (prop.indexOf("$(appdatapath)") >= 0) {
            prop = prop.replace("$(appdatapath)", ApplicationSystem.getNativePersonalPath());
        }
        if (prop.indexOf("$(personalpath)") >= 0) {
            prop = prop.replace("$(personalpath)", ApplicationSystem.getNativePersonalPath());
        }
        if (prop.indexOf("$(vistapath)") >= 0) {
            prop = prop.replace("$(vistapath)", ApplicationSystem.getNativeAppPath());
        }
        TVP.NativeDataPath = prop;
        if (stop_after_datapath_got) {
            return;
        }
        TVP.DataPath = TVP.StorageMediaManager.normalizeStorageName(TVP.NativeDataPath, null);
        DebugClass.addImportantLog("(info) Data path : " + TVP.DataPath);
        TVP.DebugLog.setLogLocation(TVP.NativeDataPath);
    }
}

