/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2env;

import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.visual.DivisibleTransHandler;
import jp.kirikiri.tvp2.visual.ScanLineProvider;
import jp.kirikiri.tvp2.visual.SimpleOptionProvider;

public abstract class BaseRotateTransHandler
implements DivisibleTransHandler {
    protected long mStartTick;
    protected long mTime;
    protected long mCurTime;
    protected int mWidth;
    protected int mHeight;
    protected int mBGColor;
    protected int mPhase;
    protected boolean mFirst;

    public BaseRotateTransHandler(long time, int width, int height, int bgcolor) {
        this.mWidth = width;
        this.mHeight = height;
        this.mTime = time;
        this.mBGColor = bgcolor | 0xFF000000;
        this.mFirst = true;
    }

    @Override
    public int setOption(SimpleOptionProvider options) {
        return 0;
    }

    @Override
    public int startProcess(long tick) {
        if (this.mFirst) {
            this.mFirst = false;
            this.mStartTick = tick;
        }
        this.mCurTime = tick - this.mStartTick;
        if (this.mCurTime > this.mTime) {
            this.mCurTime = this.mTime;
        }
        this.calcPosition();
        return 1;
    }

    @Override
    public int endProcess() {
        if (this.mCurTime == this.mTime) {
            return 2;
        }
        return 1;
    }

    @Override
    public int makeFinalImage(ScanLineProvider dest, ScanLineProvider src1, ScanLineProvider src2) throws TJSException {
        dest.copyFrom(src2);
        return 0;
    }

    abstract void calcPosition();
}

