/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2env;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.visual.DivisibleData;
import jp.kirikiri.tvp2.visual.DivisibleTransHandler;
import jp.kirikiri.tvp2.visual.LayerType;
import jp.kirikiri.tvp2.visual.ScanLineProvider;
import jp.kirikiri.tvp2.visual.SimpleOptionProvider;
import jp.kirikiri.tvp2env.CustomOperationComposite;

public class CrossFadeTransHandler
implements DivisibleTransHandler {
    protected SimpleOptionProvider mOptions;
    protected int mDestLayerType;
    protected long mStartTick;
    protected long mTime;
    protected boolean mFirst;
    protected int mPhaseMax;
    protected int mPhase;

    public CrossFadeTransHandler(SimpleOptionProvider options, int layertype, long time) {
        this(options, layertype, time, 255);
    }

    public CrossFadeTransHandler(SimpleOptionProvider options, int layertype, long time, int phasemax) {
        this.mDestLayerType = layertype;
        this.mOptions = options;
        this.mTime = time;
        this.mPhaseMax = phasemax;
        this.mFirst = true;
    }

    @Override
    public int setOption(SimpleOptionProvider options) {
        this.mOptions = null;
        this.mOptions = options;
        return 0;
    }

    @Override
    public int startProcess(long tick) {
        if (this.mFirst) {
            this.mFirst = false;
            this.mStartTick = tick;
        }
        this.mPhase = (int)((tick - this.mStartTick) * (long)this.mPhaseMax / this.mTime);
        if (this.mPhase >= this.mPhaseMax) {
            this.mPhase = this.mPhaseMax;
        }
        return 1;
    }

    @Override
    public int endProcess() {
        if (this.mPhase >= this.mPhaseMax) {
            return 2;
        }
        return 1;
    }

    @Override
    public int process(DivisibleData data) {
        if (this.mPhase == 0) {
            data.Dest = data.Src1;
            data.DestLeft = data.Src1Left;
            data.DestTop = data.Src1Top;
        } else if (this.mPhase == this.mPhaseMax) {
            data.Dest = data.Src2;
            data.DestLeft = data.Src2Left;
            data.DestTop = data.Src2Top;
        } else {
            try {
                this.blend(data);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    @Override
    public int makeFinalImage(ScanLineProvider dest, ScanLineProvider src1, ScanLineProvider src2) throws TJSException {
        dest.copyFrom(src2);
        return 0;
    }

    public void blend(DivisibleData data) {
        BufferedImage dest = (BufferedImage)data.Dest.getScanLineForWrite().getImage();
        BufferedImage src1 = (BufferedImage)data.Src1.getScanLine().getImage();
        BufferedImage src2 = (BufferedImage)data.Src2.getScanLine().getImage();
        int destLeft = data.DestLeft;
        int src1Left = data.Src1Left;
        int src2Left = data.Src2Left;
        int h = data.Height;
        int w = data.Width;
        int destTop = data.DestTop;
        int src1Top = data.Src1Top;
        int src2Top = data.Src2Top;
        if (LayerType.isTypeUsingAlpha(this.mDestLayerType)) {
            DataBuffer src1buf = src1.getRaster().getDataBuffer();
            DataBuffer src2buf = src2.getRaster().getDataBuffer();
            DataBuffer destbuf = dest.getRaster().getDataBuffer();
            int destType = destbuf.getDataType();
            int src1Type = src1buf.getDataType();
            int src2Type = src2buf.getDataType();
            if (destType == 3 && src1Type == 3 && src2Type == 3) {
                byte[] table = CustomOperationComposite.OpacityOnOpacityTable;
                int opa = this.mPhase;
                if (opa > 127) {
                    ++opa;
                }
                int iopa = 256 - opa;
                int[] s1 = ((DataBufferInt)src1buf).getData();
                int[] s2 = ((DataBufferInt)src2buf).getData();
                int[] d = ((DataBufferInt)destbuf).getData();
                int destW = dest.getWidth();
                int src1W = src1.getWidth();
                int src2W = src2.getWidth();
                destTop = destTop * destW + destLeft;
                src1Top = src1Top * src1W + src1Left;
                src2Top = src2Top * src2W + src2Left;
                int y = 0;
                while (y < h) {
                    int x = 0;
                    while (x < w) {
                        int color;
                        int s1v = s1[src1Top + x];
                        int s2v = s2[src1Top + x];
                        int a1 = s1v >>> 24;
                        int a2 = s2v >>> 24;
                        int addr = (a2 * opa & 0xFF00) + (a1 * iopa >>> 8);
                        int alpha = table[addr] & 0xFF;
                        int s1t = s1v & 0xFF00FF;
                        s1t = s1t + (((s2v & 0xFF00FF) - s1t) * alpha >>> 8) & 0xFF00FF;
                        d[destTop + x] = color = (s1t |= a1 + ((a2 - a1) * opa >>> 8) << 24) | (s1v &= 0xFF00) + (((s2v &= 0xFF00) - s1v) * alpha >>> 8) & 0xFF00;
                        ++x;
                    }
                    destTop += destW;
                    src1Top += src1W;
                    src2Top += src2W;
                    ++y;
                }
            }
        } else if (LayerType.isTypeUsingAddAlpha(this.mDestLayerType)) {
            DataBuffer src1buf = src1.getRaster().getDataBuffer();
            DataBuffer src2buf = src2.getRaster().getDataBuffer();
            DataBuffer destbuf = dest.getRaster().getDataBuffer();
            int destType = destbuf.getDataType();
            int src1Type = src1buf.getDataType();
            int src2Type = src2buf.getDataType();
            if (destType == 3 && src1Type == 3 && src2Type == 3) {
                int opa = this.mPhase;
                int[] s1 = ((DataBufferInt)src1buf).getData();
                int[] s2 = ((DataBufferInt)src2buf).getData();
                int[] d = ((DataBufferInt)destbuf).getData();
                int destW = dest.getWidth();
                int src1W = src1.getWidth();
                int src2W = src2.getWidth();
                destTop = destTop * destW + destLeft;
                src1Top = src1Top * src1W + src1Left;
                src2Top = src2Top * src2W + src2Left;
                int y = 0;
                while (y < h) {
                    int x = 0;
                    while (x < w) {
                        int b = s1[src1Top + x];
                        int a = s2[src1Top + x];
                        int b2 = b & 0xFF00FF;
                        int t = b2 + (((a & 0xFF00FF) - b2) * opa >>> 8) & 0xFF00FF;
                        b2 = (b & 0xFF00FF00) >>> 8;
                        d[destTop + x] = t + (b2 + ((((a & 0xFF00FF00) >>> 8) - b2) * opa >>> 8) << 8 & 0xFF00FF00);
                        ++x;
                    }
                    destTop += destW;
                    src1Top += src1W;
                    src2Top += src2W;
                    ++y;
                }
            }
        } else {
            float opa = (float)this.mPhase / 255.0f;
            if (dest == src1 && destLeft == src1Left && destTop == src1Top) {
                AlphaComposite composite = AlphaComposite.getInstance(3, opa);
                Graphics2D g = (Graphics2D)dest.getGraphics();
                g.setComposite(composite);
                g.drawImage(src2, destLeft, destTop, destLeft + w, destTop + h, src2Left, src2Top, src2Left + w, src2Top + h, null);
                g.dispose();
            } else {
                AlphaComposite composite = AlphaComposite.getInstance(3, opa);
                Graphics2D g = (Graphics2D)dest.getGraphics();
                g.setComposite(AlphaComposite.Src);
                g.drawImage(src1, destLeft, destTop, destLeft + w, destTop + h, src1Left, src1Top, src1Left + w, src1Top + h, null);
                g.setComposite(composite);
                g.drawImage(src2, destLeft, destTop, destLeft + w, destTop + h, src2Left, src2Top, src2Left + w, src2Top + h, null);
                g.dispose();
            }
        }
    }
}

