/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2env;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;

public class CustomOperationComposite
implements Composite {
    public static byte[] OpacityOnOpacityTable;
    public static byte[] NegativeMulTable;
    public static byte[] OpacityOnOpacityTable65;
    public static byte[] NegativeMulTable65;
    public static int[] RecipTable256;
    public static short[] RecipTable256_16;
    public static byte[] DivTable;
    public static byte[][] PsTableSoftLight;
    public static byte[][] PsTableColorDodge;
    public static byte[][] PsTableColorBurn;
    private static final int bmCopy = 0;
    private static final int bmCopyOnAlpha = 1;
    private static final int bmAlpha = 2;
    private static final int bmAlphaOnAlpha = 3;
    private static final int bmAdd = 4;
    private static final int bmSub = 5;
    private static final int bmMul = 6;
    private static final int bmDodge = 7;
    private static final int bmDarken = 8;
    private static final int bmLighten = 9;
    private static final int bmScreen = 10;
    private static final int bmAddAlpha = 11;
    private static final int bmAddAlphaOnAddAlpha = 12;
    private static final int bmAddAlphaOnAlpha = 13;
    private static final int bmAlphaOnAddAlpha = 14;
    private static final int bmCopyOnAddAlpha = 15;
    private static final int bmPsNormal = 16;
    private static final int bmPsAdditive = 17;
    private static final int bmPsSubtractive = 18;
    private static final int bmPsMultiplicative = 19;
    private static final int bmPsScreen = 20;
    private static final int bmPsOverlay = 21;
    private static final int bmPsHardLight = 22;
    private static final int bmPsSoftLight = 23;
    private static final int bmPsColorDodge = 24;
    private static final int bmPsColorDodge5 = 25;
    private static final int bmPsColorBurn = 26;
    private static final int bmPsLighten = 27;
    private static final int bmPsDarken = 28;
    private static final int bmPsDifference = 29;
    private static final int bmPsDifference5 = 30;
    private static final int bmPsExclusion = 31;
    public static final int copyMain = -1;
    public static final int copyMask = -2;
    private int mMethod;
    private int mOpacity;
    private boolean mHoldAlpha;

    public static void initialize() {
        float bt;
        float at;
        int b;
        OpacityOnOpacityTable = new byte[65536];
        NegativeMulTable = new byte[65536];
        RecipTable256 = new int[256];
        RecipTable256_16 = new short[256];
        DivTable = new byte[65536];
        OpacityOnOpacityTable65 = new byte[16640];
        NegativeMulTable65 = new byte[16640];
        int a = 0;
        while (a < 256) {
            b = 0;
            while (b < 256) {
                int ci;
                int addr = b * 256 + a;
                if (a != 0) {
                    at = (float)a / 255.0f;
                    bt = (float)b / 255.0f;
                    float c = bt / at;
                    if ((ci = (int)((c /= 1.0f - bt + c) * 255.0f)) >= 256) {
                        ci = 255;
                    }
                } else {
                    ci = 255;
                }
                CustomOperationComposite.OpacityOnOpacityTable[addr] = (byte)(ci & 0xFF);
                CustomOperationComposite.NegativeMulTable[addr] = (byte)(255 - (255 - a) * (255 - b) / 255 & 0xFF);
                ++b;
            }
            ++a;
        }
        a = 0;
        while (a < 256) {
            b = 0;
            while (b < 65) {
                int ci;
                int addr = b * 256 + a;
                if (a != 0) {
                    at = (float)a / 255.0f;
                    bt = (float)b / 64.0f;
                    float c = bt / at;
                    if ((ci = (int)((c /= 1.0f - bt + c) * 255.0f)) >= 256) {
                        ci = 255;
                    }
                } else {
                    ci = 255;
                }
                CustomOperationComposite.OpacityOnOpacityTable65[addr] = (byte)(ci & 0xFF);
                int bb = b * 4;
                if (bb > 255) {
                    bb = 255;
                }
                CustomOperationComposite.NegativeMulTable65[addr] = (byte)(255 - (255 - a) * (255 - bb) / 255 & 0xFF);
                ++b;
            }
            ++a;
        }
        CustomOperationComposite.RecipTable256[0] = 65536;
        CustomOperationComposite.RecipTable256_16[0] = Short.MAX_VALUE;
        int i = 1;
        while (i < 256) {
            int v;
            CustomOperationComposite.RecipTable256[i] = v = 65536 / i;
            CustomOperationComposite.RecipTable256_16[i] = (short)(v > Short.MAX_VALUE ? Short.MAX_VALUE : (short)v);
            ++i;
        }
        b = 0;
        while (b < 256) {
            CustomOperationComposite.DivTable[0 + b] = 0;
            a = 1;
            while (a < 256) {
                int tmp = b * 255 / a;
                if (tmp > 255) {
                    tmp = 255;
                }
                CustomOperationComposite.DivTable[(a << 8) + b] = (byte)(tmp & 0xFF);
                ++a;
            }
            ++b;
        }
        PsTableSoftLight = new byte[256][];
        PsTableColorDodge = new byte[256][];
        PsTableColorBurn = new byte[256][];
        int s = 0;
        while (s < 256) {
            CustomOperationComposite.PsTableSoftLight[s] = new byte[256];
            CustomOperationComposite.PsTableColorDodge[s] = new byte[256];
            CustomOperationComposite.PsTableColorBurn[s] = new byte[256];
            int d = 0;
            while (d < 256) {
                CustomOperationComposite.PsTableSoftLight[s][d] = s >= 128 ? (byte)((int)(Math.pow((double)d / 255.0, 128.0 / (double)s) * 255.0) & 0xFF) : (byte)((int)(Math.pow((double)d / 255.0, (1.0 - (double)s / 255.0) / 0.5) * 255.0) & 0xFF);
                CustomOperationComposite.PsTableColorDodge[s][d] = (byte)(255 - s <= d ? -1 : (byte)(d * 255 / (255 - s) & 0xFF));
                CustomOperationComposite.PsTableColorBurn[s][d] = s <= 255 - d ? (byte)0 : (byte)(255 - (255 - d) * 255 / s & 0xFF);
                ++d;
            }
            ++s;
        }
    }

    public CustomOperationComposite(int method, int opacity, boolean hda) {
        this.mMethod = method;
        this.mOpacity = opacity;
        this.mHoldAlpha = hda;
    }

    @Override
    public CompositeContext createContext(ColorModel srcColorModel, ColorModel dstColorModel, RenderingHints hints) {
        int method = this.mMethod;
        switch (method) {
            case 0: {
                if (this.mOpacity == 255 && this.mHoldAlpha) {
                    return new CopyColor();
                }
                if (!this.mHoldAlpha) {
                    return new ConstAlphaBlend(this.mOpacity);
                }
                return new ConstAlphaBlend_HDA(this.mOpacity);
            }
            case 1: {
                if (this.mOpacity == 255) {
                    return new CopyOpaqueImage();
                }
                return new ConstAlphaBlend_d(this.mOpacity);
            }
            case 2: {
                if (this.mOpacity == 255) {
                    if (!this.mHoldAlpha) {
                        return new AlphaBlend();
                    }
                    return new AlphaBlend_HDA();
                }
                if (!this.mHoldAlpha) {
                    return new AlphaBlend_o(this.mOpacity);
                }
                return new AlphaBlend_HDA_o(this.mOpacity);
            }
            case 3: {
                if (this.mOpacity == 255) {
                    return new AlphaBlend_d();
                }
                return new AlphaBlend_do(this.mOpacity);
            }
            case 4: {
                if (this.mOpacity == 255) {
                    if (!this.mHoldAlpha) {
                        return new AddBlend();
                    }
                    return new AddBlend_HDA();
                }
                if (!this.mHoldAlpha) {
                    return new AddBlend_o(this.mOpacity);
                }
                return new AddBlend_HDA_o(this.mOpacity);
            }
            case 5: {
                if (this.mOpacity == 255) {
                    if (!this.mHoldAlpha) {
                        return new SubBlend();
                    }
                    return new SubBlend_HDA();
                }
                if (!this.mHoldAlpha) {
                    return new SubBlend_o(this.mOpacity);
                }
                return new SubBlend_HDA_o(this.mOpacity);
            }
            case 6: {
                if (this.mOpacity == 255) {
                    if (!this.mHoldAlpha) {
                        return new MulBlend();
                    }
                    return new MulBlend_HDA();
                }
                if (!this.mHoldAlpha) {
                    return new MulBlend_o(this.mOpacity);
                }
                return new MulBlend_HDA_o(this.mOpacity);
            }
            case 7: {
                if (this.mOpacity == 255) {
                    if (!this.mHoldAlpha) {
                        return new ColorDodgeBlend();
                    }
                    return new ColorDodgeBlend_HDA();
                }
                if (!this.mHoldAlpha) {
                    return new ColorDodgeBlend_o(this.mOpacity);
                }
                return new ColorDodgeBlend_HDA_o(this.mOpacity);
            }
            case 8: {
                if (this.mOpacity == 255) {
                    if (!this.mHoldAlpha) {
                        return new DarkenBlend();
                    }
                    return new DarkenBlend_HDA();
                }
                if (!this.mHoldAlpha) {
                    return new DarkenBlend_o(this.mOpacity);
                }
                return new DarkenBlend_HDA_o(this.mOpacity);
            }
            case 9: {
                if (this.mOpacity == 255) {
                    if (!this.mHoldAlpha) {
                        return new LightenBlend();
                    }
                    return new LightenBlend_HDA();
                }
                if (!this.mHoldAlpha) {
                    return new LightenBlend_o(this.mOpacity);
                }
                return new LightenBlend_HDA_o(this.mOpacity);
            }
            case 10: {
                if (this.mOpacity == 255) {
                    if (!this.mHoldAlpha) {
                        return new ScreenBlend();
                    }
                    return new ScreenBlend_HDA();
                }
                if (!this.mHoldAlpha) {
                    return new ScreenBlend_o(this.mOpacity);
                }
                return new ScreenBlend_HDA_o(this.mOpacity);
            }
            case 11: {
                if (this.mOpacity == 255) {
                    if (!this.mHoldAlpha) {
                        return new AdditiveAlphaBlend();
                    }
                    return new AdditiveAlphaBlend_HDA();
                }
                if (!this.mHoldAlpha) {
                    return new AdditiveAlphaBlend_o(this.mOpacity);
                }
                return new AdditiveAlphaBlend_HDA_o(this.mOpacity);
            }
            case 12: {
                if (this.mOpacity == 255) {
                    return new AdditiveAlphaBlend_a();
                }
                return new AdditiveAlphaBlend_ao(this.mOpacity);
            }
            case 13: {
                break;
            }
            case 14: {
                if (this.mOpacity == 255) {
                    return new AlphaBlend_a();
                }
                return new AlphaBlend_ao(this.mOpacity);
            }
            case 15: {
                if (this.mOpacity == 255) {
                    return new CopyOpaqueImage();
                }
                return new ConstAlphaBlend_a(this.mOpacity);
            }
            case 16: {
                if (this.mOpacity == 255) {
                    if (!this.mHoldAlpha) {
                        return new PsAlphaBlend();
                    }
                    return new PsAlphaBlend_HDA();
                }
                if (!this.mHoldAlpha) {
                    return new PsAlphaBlend_o(this.mOpacity);
                }
                return new PsAlphaBlend_HDA_o(this.mOpacity);
            }
            case 17: {
                if (this.mOpacity == 255) {
                    if (!this.mHoldAlpha) {
                        return new PsAddBlend();
                    }
                    return new PsAddBlend_HDA();
                }
                if (!this.mHoldAlpha) {
                    return new PsAddBlend_o(this.mOpacity);
                }
                return new PsAddBlend_HDA_o(this.mOpacity);
            }
            case 18: {
                if (this.mOpacity == 255) {
                    if (!this.mHoldAlpha) {
                        return new PsSubBlend();
                    }
                    return new PsSubBlend_HDA();
                }
                if (!this.mHoldAlpha) {
                    return new PsSubBlend_o(this.mOpacity);
                }
                return new PsSubBlend_HDA_o(this.mOpacity);
            }
            case 19: {
                if (this.mOpacity == 255) {
                    if (!this.mHoldAlpha) {
                        return new PsMulBlend();
                    }
                    return new PsMulBlend_HDA();
                }
                if (!this.mHoldAlpha) {
                    return new PsMulBlend_o(this.mOpacity);
                }
                return new PsMulBlend_HDA_o(this.mOpacity);
            }
            case 20: {
                if (this.mOpacity == 255) {
                    if (!this.mHoldAlpha) {
                        return new PsScreenBlend();
                    }
                    return new PsScreenBlend_HDA();
                }
                if (!this.mHoldAlpha) {
                    return new PsScreenBlend_o(this.mOpacity);
                }
                return new PsScreenBlend_HDA_o(this.mOpacity);
            }
            case 21: {
                if (this.mOpacity == 255) {
                    if (!this.mHoldAlpha) {
                        return new PsOverlayBlend();
                    }
                    return new PsOverlayBlend_HDA();
                }
                if (!this.mHoldAlpha) {
                    return new PsOverlayBlend_o(this.mOpacity);
                }
                return new PsOverlayBlend_HDA_o(this.mOpacity);
            }
            case 22: {
                if (this.mOpacity == 255) {
                    if (!this.mHoldAlpha) {
                        return new PsHardLightBlend();
                    }
                    return new PsHardLightBlend_HDA();
                }
                if (!this.mHoldAlpha) {
                    return new PsHardLightBlend_o(this.mOpacity);
                }
                return new PsHardLightBlend_HDA_o(this.mOpacity);
            }
            case 23: {
                if (this.mOpacity == 255) {
                    if (!this.mHoldAlpha) {
                        return new PsSoftLightBlend();
                    }
                    return new PsSoftLightBlend_HDA();
                }
                if (!this.mHoldAlpha) {
                    return new PsSoftLightBlend_o(this.mOpacity);
                }
                return new PsSoftLightBlend_HDA_o(this.mOpacity);
            }
            case 24: {
                if (this.mOpacity == 255) {
                    if (!this.mHoldAlpha) {
                        return new PsColorDodgeBlend();
                    }
                    return new PsColorDodgeBlend_HDA();
                }
                if (!this.mHoldAlpha) {
                    return new PsColorDodgeBlend_o(this.mOpacity);
                }
                return new PsColorDodgeBlend_HDA_o(this.mOpacity);
            }
            case 25: {
                if (this.mOpacity == 255) {
                    if (!this.mHoldAlpha) {
                        return new PsColorDodge5Blend();
                    }
                    return new PsColorDodge5Blend_HDA();
                }
                if (!this.mHoldAlpha) {
                    return new PsColorDodge5Blend_o(this.mOpacity);
                }
                return new PsColorDodge5Blend_HDA_o(this.mOpacity);
            }
            case 26: {
                if (this.mOpacity == 255) {
                    if (!this.mHoldAlpha) {
                        return new PsColorBurnBlend();
                    }
                    return new PsColorBurnBlend_HDA();
                }
                if (!this.mHoldAlpha) {
                    return new PsColorBurnBlend_o(this.mOpacity);
                }
                return new PsColorBurnBlend_HDA_o(this.mOpacity);
            }
            case 27: {
                if (this.mOpacity == 255) {
                    if (!this.mHoldAlpha) {
                        return new PsLightenBlend();
                    }
                    return new PsLightenBlend_HDA();
                }
                if (!this.mHoldAlpha) {
                    return new PsLightenBlend_o(this.mOpacity);
                }
                return new PsLightenBlend_HDA_o(this.mOpacity);
            }
            case 28: {
                if (this.mOpacity == 255) {
                    if (!this.mHoldAlpha) {
                        return new PsDarkenBlend();
                    }
                    return new PsDarkenBlend_HDA();
                }
                if (!this.mHoldAlpha) {
                    return new PsDarkenBlend_o(this.mOpacity);
                }
                return new PsDarkenBlend_HDA_o(this.mOpacity);
            }
            case 29: {
                if (this.mOpacity == 255) {
                    if (!this.mHoldAlpha) {
                        return new PsDiffBlend();
                    }
                    return new PsDiffBlend_HDA();
                }
                if (!this.mHoldAlpha) {
                    return new PsDiffBlend_o(this.mOpacity);
                }
                return new PsDiffBlend_HDA_o(this.mOpacity);
            }
            case 30: {
                if (this.mOpacity == 255) {
                    if (!this.mHoldAlpha) {
                        return new PsDiff5Blend();
                    }
                    return new PsDiff5Blend_HDA();
                }
                if (!this.mHoldAlpha) {
                    return new PsDiff5Blend_o(this.mOpacity);
                }
                return new PsDiff5Blend_HDA_o(this.mOpacity);
            }
            case 31: {
                if (this.mOpacity == 255) {
                    if (!this.mHoldAlpha) {
                        return new PsExclusionBlend();
                    }
                    return new PsExclusionBlend_HDA();
                }
                if (!this.mHoldAlpha) {
                    return new PsExclusionBlend_o(this.mOpacity);
                }
                return new PsExclusionBlend_HDA_o(this.mOpacity);
            }
            case -1: {
                return new CopyMain();
            }
            case -2: {
                return new CopyMask();
            }
        }
        return AlphaComposite.Src.createContext(srcColorModel, dstColorModel, hints);
    }

    static class AddBlend
    extends BlendContext {
        AddBlend() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int tmp = (s0 & d0) + ((s0 ^ d0) >>> 1 & 0x7F7F7F7F) & 0x80808080;
                    tmp = (tmp << 1) - (tmp >>> 7);
                    o[dt + x] = s0 + d0 - tmp | tmp;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class AddBlend_HDA
    extends BlendContext {
        AddBlend_HDA() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int tmp = (s0 & d0) + ((s0 ^ d0) >>> 1 & 0x7F7F7F7F) & 0x80808080;
                    tmp = (tmp << 1) - (tmp >>> 7);
                    o[dt + x] = (s0 + d0 - tmp | tmp) & 0xFFFFFF | d0 & 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class AddBlend_HDA_o
    extends BlendContext {
        public AddBlend_HDA_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    s0 = ((s0 & 0xFF00) * opa >>> 8 & 0xFF00) + ((s0 & 0xFF00FF) * opa >>> 8 & 0xFF00FF);
                    int tmp = (s0 & d0) + ((s0 ^ d0) >>> 1 & 0x7F7F7F7F) & 0x80808080;
                    tmp = (tmp << 1) - (tmp >>> 7);
                    o[dt + x] = ((s0 + d0 - tmp | tmp) & 0xFFFFFF) + (d0 & 0xFF000000);
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class AddBlend_o
    extends BlendContext {
        public AddBlend_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    s0 = ((s0 & 0xFF00) * opa >>> 8 & 0xFF00) + ((s0 & 0xFF00FF) * opa >>> 8 & 0xFF00FF);
                    int tmp = (s0 & d0) + ((s0 ^ d0) >>> 1 & 0x7F7F7F7F) & 0x80808080;
                    tmp = (tmp << 1) - (tmp >>> 7);
                    o[dt + x] = s0 + d0 - tmp | tmp;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class AdditiveAlphaBlend
    extends BlendContext {
        AdditiveAlphaBlend() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int sopa = ~s0 >>> 24;
                    int a = ((d0 & 0xFF00FF) * sopa >>> 8 & 0xFF00FF) + ((d0 & 0xFF00) * sopa >>> 8 & 0xFF00);
                    int b = s0;
                    int tmp = (a & b) + ((a ^ b) >>> 1 & 0x7F7F7F7F) & 0x80808080;
                    tmp = (tmp << 1) - (tmp >>> 7);
                    o[dt + x] = a + b - tmp | tmp;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class AdditiveAlphaBlend_HDA
    extends BlendContext {
        AdditiveAlphaBlend_HDA() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int sopa = ~s0 >>> 24;
                    int a = ((d0 & 0xFF00FF) * sopa >>> 8 & 0xFF00FF) + ((d0 & 0xFF00) * sopa >>> 8 & 0xFF00);
                    int b = s0;
                    int tmp = (a & b) + ((a ^ b) >>> 1 & 0x7F7F7F7F) & 0x80808080;
                    tmp = (tmp << 1) - (tmp >>> 7);
                    o[dt + x] = (d0 & 0xFF000000) + (a + b - tmp | tmp) & 0xFFFFFF;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class AdditiveAlphaBlend_HDA_o
    extends BlendContext {
        public AdditiveAlphaBlend_HDA_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    s0 = ((s0 & 0xFF00FF) * opa >>> 8 & 0xFF00FF) + ((s0 >>> 8 & 0xFF00FF) * opa & 0xFF00FF00);
                    int sopa = ~s0 >>> 24;
                    int a = ((d0 & 0xFF00FF) * sopa >>> 8 & 0xFF00FF) + ((d0 & 0xFF00) * sopa >>> 8 & 0xFF00);
                    int b = s0;
                    int tmp = (a & b) + ((a ^ b) >>> 1 & 0x7F7F7F7F) & 0x80808080;
                    tmp = (tmp << 1) - (tmp >>> 7);
                    o[dt + x] = (d0 & 0xFF000000) + (a + b - tmp | tmp) & 0xFFFFFF;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class AdditiveAlphaBlend_a
    extends BlendContext {
        AdditiveAlphaBlend_a() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int dopa = d0 >>> 24;
                    int sopa = s0 >>> 24;
                    dopa = dopa + sopa - (dopa * sopa >>> 8);
                    dopa -= dopa >>> 8;
                    int a = ((d0 & 0xFF00FF) * (sopa ^= 0xFF) >>> 8 & 0xFF00FF) + ((d0 & 0xFF00) * sopa >>> 8 & 0xFF00);
                    int b = s0 &= 0xFFFFFF;
                    int tmp = (a & b) + ((a ^ b) >>> 1 & 0x7F7F7F7F) & 0x80808080;
                    tmp = (tmp << 1) - (tmp >>> 7);
                    o[dt + x] = (dopa << 24) + (a + b - tmp | tmp);
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class AdditiveAlphaBlend_ao
    extends BlendContext {
        public AdditiveAlphaBlend_ao(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    s0 = ((s0 & 0xFF00FF) * opa >>> 8 & 0xFF00FF) + ((s0 >>> 8 & 0xFF00FF) * opa & 0xFF00FF00);
                    int dopa = d0 >>> 24;
                    int sopa = s0 >>> 24;
                    dopa = dopa + sopa - (dopa * sopa >>> 8);
                    dopa -= dopa >>> 8;
                    int a = ((d0 & 0xFF00FF) * (sopa ^= 0xFF) >>> 8 & 0xFF00FF) + ((d0 & 0xFF00) * sopa >>> 8 & 0xFF00);
                    int b = s0 &= 0xFFFFFF;
                    int tmp = (a & b) + ((a ^ b) >>> 1 & 0x7F7F7F7F) & 0x80808080;
                    tmp = (tmp << 1) - (tmp >>> 7);
                    o[dt + x] = (dopa << 24) + (a + b - tmp | tmp);
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class AdditiveAlphaBlend_o
    extends BlendContext {
        public AdditiveAlphaBlend_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    s0 = ((s0 & 0xFF00FF) * opa >>> 8 & 0xFF00FF) + ((s0 >>> 8 & 0xFF00FF) * opa & 0xFF00FF00);
                    int sopa = ~s0 >>> 24;
                    int a = ((d0 & 0xFF00FF) * sopa >>> 8 & 0xFF00FF) + ((d0 & 0xFF00) * sopa >>> 8 & 0xFF00);
                    int b = s0;
                    int tmp = (a & b) + ((a ^ b) >>> 1 & 0x7F7F7F7F) & 0x80808080;
                    tmp = (tmp << 1) - (tmp >>> 7);
                    o[dt + x] = a + b - tmp | tmp;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class AlphaBlend
    extends BlendContext {
        AlphaBlend() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int sopa = s0 >>> 24;
                    int d1 = d0 & 0xFF00FF;
                    d1 = d1 + (((s0 & 0xFF00FF) - d1) * sopa >>> 8) & 0xFF00FF;
                    o[dt + x] = d1 + ((d0 &= 0xFF00) + (((s0 &= 0xFF00) - d0) * sopa >>> 8) & 0xFF00) | 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class AlphaBlend_HDA
    extends BlendContext {
        AlphaBlend_HDA() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int sopa = s0 >>> 24;
                    int d1 = d0 & 0xFF00FF;
                    d1 = (d1 + (((s0 & 0xFF00FF) - d1) * sopa >>> 8) & 0xFF00FF) + (d0 & 0xFF000000);
                    o[dt + x] = d1 + ((d0 &= 0xFF00) + (((s0 &= 0xFF00) - d0) * sopa >>> 8) & 0xFF00);
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class AlphaBlend_HDA_o
    extends BlendContext {
        public AlphaBlend_HDA_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int sopa = (s0 >>> 24) * opa >> 8;
                    int d1 = d0 & 0xFF00FF;
                    d1 = (d1 + (((s0 & 0xFF00FF) - d1) * sopa >>> 8) & 0xFF00FF) + (d0 & 0xFF000000);
                    o[dt + x] = d1 + ((d0 &= 0xFF00) + (((s0 &= 0xFF00) - d0) * sopa >>> 8) & 0xFF00);
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class AlphaBlend_a
    extends BlendContext {
        AlphaBlend_a() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int alpha = s0 >>> 24;
                    int color = s0;
                    s0 = ((color & 0xFF00) * alpha & 0xFF0000) + ((color & 0xFF00FF) * alpha & 0xFF00FF00) >>> 8;
                    int dopa = d0 >>> 24;
                    int sopa = (s0 += color & 0xFF000000) >>> 24;
                    dopa = dopa + sopa - (dopa * sopa >>> 8);
                    dopa -= dopa >>> 8;
                    int a = ((d0 & 0xFF00FF) * (sopa ^= 0xFF) >>> 8 & 0xFF00FF) + ((d0 & 0xFF00) * sopa >>> 8 & 0xFF00);
                    int b = s0 &= 0xFFFFFF;
                    int tmp = (a & b) + ((a ^ b) >>> 1 & 0x7F7F7F7F) & 0x80808080;
                    tmp = (tmp << 1) - (tmp >>> 7);
                    tmp = a + b - tmp | tmp;
                    o[dt + x] = (dopa << 24) + tmp;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class AlphaBlend_ao
    extends BlendContext {
        public AlphaBlend_ao(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    s0 = (s0 & 0xFFFFFF) + ((s0 >>> 24) * opa >>> 8 << 24);
                    int alpha = s0 >>> 24;
                    int color = s0;
                    s0 = ((color & 0xFF00) * alpha & 0xFF0000) + ((color & 0xFF00FF) * alpha & 0xFF00FF00) >>> 8;
                    int dopa = d0 >>> 24;
                    int sopa = (s0 += color & 0xFF000000) >>> 24;
                    dopa = dopa + sopa - (dopa * sopa >>> 8);
                    dopa -= dopa >>> 8;
                    int a = ((d0 & 0xFF00FF) * (sopa ^= 0xFF) >>> 8 & 0xFF00FF) + ((d0 & 0xFF00) * sopa >>> 8 & 0xFF00);
                    int b = s0 &= 0xFFFFFF;
                    int tmp = (a & b) + ((a ^ b) >>> 1 & 0x7F7F7F7F) & 0x80808080;
                    tmp = (tmp << 1) - (tmp >>> 7);
                    tmp = a + b - tmp | tmp;
                    o[dt + x] = (dopa << 24) + tmp;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class AlphaBlend_d
    extends BlendContext {
        AlphaBlend_d() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int addr = (s0 >>> 16 & 0xFF00) + (d0 >>> 24);
                    int destalpha = NegativeMulTable[addr] << 24;
                    int sopa = OpacityOnOpacityTable[addr] & 0xFF;
                    int d1 = d0 & 0xFF00FF;
                    d1 = d1 + (((s0 & 0xFF00FF) - d1) * sopa >>> 8) & 0xFF00FF;
                    o[dt + x] = d1 + ((d0 &= 0xFF00) + (((s0 &= 0xFF00) - d0) * sopa >>> 8) & 0xFF00) + destalpha;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class AlphaBlend_do
    extends BlendContext {
        public AlphaBlend_do(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int addr = ((s0 >>> 24) * opa & 0xFF00) + (d0 >>> 24);
                    int destalpha = NegativeMulTable[addr] << 24;
                    int sopa = OpacityOnOpacityTable[addr] & 0xFF;
                    int d1 = d0 & 0xFF00FF;
                    d1 = d1 + (((s0 & 0xFF00FF) - d1) * sopa >>> 8) & 0xFF00FF;
                    o[dt + x] = d1 + ((d0 &= 0xFF00) + (((s0 &= 0xFF00) - d0) * sopa >>> 8) & 0xFF00) + destalpha;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class AlphaBlend_o
    extends BlendContext {
        public AlphaBlend_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int sopa = (s0 >>> 24) * opa >>> 8;
                    int d1 = d0 & 0xFF00FF;
                    d1 = d1 + (((s0 & 0xFF00FF) - d1) * sopa >>> 8) & 0xFF00FF;
                    o[dt + x] = d1 + ((d0 &= 0xFF00) + (((s0 &= 0xFF00) - d0) * sopa >>> 8) & 0xFF00) | 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static abstract class BlendContext
    implements CompositeContext {
        private int mOpacity;

        public BlendContext() {
            this.mOpacity = 255;
        }

        public BlendContext(int opa) {
            this.mOpacity = opa;
        }

        @Override
        public void dispose() {
        }

        @Override
        public void compose(Raster src, Raster dst, WritableRaster dstOut) {
            if (dst != dstOut) {
                dstOut.setDataElements(0, 0, dst);
            }
            DataBufferInt srcBuff = (DataBufferInt)src.getDataBuffer();
            int[] s = srcBuff.getData();
            DataBufferInt dstBuff = (DataBufferInt)dst.getDataBuffer();
            int[] d = dstBuff.getData();
            DataBufferInt outBuff = (DataBufferInt)dstOut.getDataBuffer();
            int[] o = outBuff.getData();
            int sW = src.getWidth();
            int sH = src.getHeight();
            SampleModel ssm = src.getSampleModel();
            SampleModel osm = dstOut.getSampleModel();
            int sx = src.getSampleModelTranslateX();
            int sy = src.getSampleModelTranslateY();
            if (sx < 0) {
                sx = -sx;
            }
            if (sy < 0) {
                sy = -sy;
            }
            int srcStride = ssm instanceof SinglePixelPackedSampleModel ? ((SinglePixelPackedSampleModel)ssm).getScanlineStride() : src.getWidth();
            int dx = dstOut.getSampleModelTranslateX();
            int dy = dstOut.getSampleModelTranslateY();
            if (dx < 0) {
                dx = -dx;
            }
            if (dy < 0) {
                dy = -dy;
            }
            int dstStride = osm instanceof SinglePixelPackedSampleModel ? ((SinglePixelPackedSampleModel)osm).getScanlineStride() : dstOut.getWidth();
            int st = sx + sy * srcStride;
            int dt = dx + dy * dstStride;
            this.blt(s, d, o, srcStride, dstStride, sW, sH, st, dt, this.mOpacity);
        }

        protected abstract void blt(int[] var1, int[] var2, int[] var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);
    }

    static class ColorDodgeBlend
    extends BlendContext {
        ColorDodgeBlend() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int tmp2 = ~s0;
                    int tmp = (d0 & 0xFF) * RecipTable256[tmp2 & 0xFF] >>> 8;
                    int tmp3 = (tmp | ~(tmp - 256) >> 31) & 0xFF;
                    tmp = ((d0 & 0xFF00) >>> 8) * RecipTable256[(tmp2 & 0xFF00) >>> 8];
                    tmp3 |= (tmp | ~(tmp - 65536) >> 31) & 0xFF00;
                    tmp = ((d0 & 0xFF0000) >>> 16) * RecipTable256[(tmp2 & 0xFF0000) >>> 16];
                    o[dt + x] = (tmp3 |= ((tmp | ~(tmp - 65536) >> 31) & 0xFF00) << 8) | 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class ColorDodgeBlend_HDA
    extends BlendContext {
        ColorDodgeBlend_HDA() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int tmp2 = ~s0;
                    int tmp = (d0 & 0xFF) * RecipTable256[tmp2 & 0xFF] >>> 8;
                    int tmp3 = (tmp | ~(tmp - 256) >> 31) & 0xFF;
                    tmp = ((d0 & 0xFF00) >>> 8) * RecipTable256[(tmp2 & 0xFF00) >>> 8];
                    tmp3 |= (tmp | ~(tmp - 65536) >> 31) & 0xFF00;
                    tmp = ((d0 & 0xFF0000) >>> 16) * RecipTable256[(tmp2 & 0xFF0000) >>> 16];
                    o[dt + x] = (tmp3 |= ((tmp | ~(tmp - 65536) >> 31) & 0xFF00) << 8) + (d0 & 0xFF000000);
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class ColorDodgeBlend_HDA_o
    extends BlendContext {
        public ColorDodgeBlend_HDA_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int tmp2 = ~(((s0 & 0xFF00) * opa >>> 8 & 0xFF00) + ((s0 & 0xFF00FF) * opa >> 8 & 0xFF00FF));
                    int tmp = (d0 & 0xFF) * RecipTable256[tmp2 & 0xFF] >>> 8;
                    int tmp3 = (tmp | ~(tmp - 256) >> 31) & 0xFF;
                    tmp = ((d0 & 0xFF00) >>> 8) * RecipTable256[(tmp2 & 0xFF00) >>> 8];
                    tmp3 |= (tmp | ~(tmp - 65536) >> 31) & 0xFF00;
                    tmp = ((d0 & 0xFF0000) >>> 16) * RecipTable256[(tmp2 & 0xFF0000) >>> 16];
                    o[dt + x] = (tmp3 |= ((tmp | ~(tmp - 65536) >> 31) & 0xFF00) << 8) + (d0 & 0xFF000000);
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class ColorDodgeBlend_o
    extends BlendContext {
        public ColorDodgeBlend_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int tmp2 = ~(((s0 & 0xFF00) * opa >>> 8 & 0xFF00) + ((s0 & 0xFF00FF) * opa >>> 8 & 0xFF00FF));
                    int tmp = (d0 & 0xFF) * RecipTable256[tmp2 & 0xFF] >>> 8;
                    int tmp3 = (tmp | ~(tmp - 256) >> 31) & 0xFF;
                    tmp = ((d0 & 0xFF00) >>> 8) * RecipTable256[(tmp2 & 0xFF00) >>> 8];
                    tmp3 |= (tmp | ~(tmp - 65536) >> 31) & 0xFF00;
                    tmp = ((d0 & 0xFF0000) >>> 16) * RecipTable256[(tmp2 & 0xFF0000) >>> 16];
                    o[dt + x] = (tmp3 |= ((tmp | ~(tmp - 65536) >> 31) & 0xFF00) << 8) | 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class ConstAlphaBlend
    extends BlendContext {
        public ConstAlphaBlend(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int d1 = d0 & 0xFF00FF;
                    d1 = d1 + (((s0 & 0xFF00FF) - d1) * opa >>> 8) & 0xFF00FF;
                    o[dt + x] = d1 | (d0 &= 0xFF00) + (((s0 &= 0xFF00) - d0) * opa >>> 8) & 0xFF00 | 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class ConstAlphaBlend_HDA
    extends BlendContext {
        public ConstAlphaBlend_HDA(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int d1 = d0 & 0xFF00FF;
                    d1 = d1 + (((s0 & 0xFF00FF) - d1) * opa >>> 8) & 0xFF00FF | d0 & 0xFF000000;
                    o[dt + x] = d1 | (d0 &= 0xFF00) + (((s0 &= 0xFF00) - d0) * opa >>> 8) & 0xFF00;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class ConstAlphaBlend_a
    extends BlendContext {
        public ConstAlphaBlend_a(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    s0 = s0 & 0xFFFFFF | opa;
                    int dopa = d0 >>> 24;
                    int sopa = s0 >>> 24;
                    dopa = dopa + sopa - (dopa * sopa >>> 8);
                    dopa -= dopa >>> 8;
                    int a = ((d0 & 0xFF00FF) * (sopa ^= 0xFF) >>> 8 & 0xFF00FF) + ((d0 & 0xFF00) * sopa >>> 8 & 0xFF00);
                    int b = s0 &= 0xFFFFFF;
                    int tmp = (a & b) + ((a ^ b) >>> 1 & 0x7F7F7F7F) & 0x80808080;
                    tmp = (tmp << 1) - (tmp >>> 7);
                    tmp = a + b - tmp | tmp;
                    o[dt + x] = (dopa << 24) + tmp;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class ConstAlphaBlend_d
    extends BlendContext {
        public ConstAlphaBlend_d(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int addr = opa + (d0 >>> 24);
                    int alpha = OpacityOnOpacityTable[addr] & 0xFF;
                    int d1 = d0 & 0xFF00FF;
                    d1 = d1 + (((s0 & 0xFF00FF) - d1) * alpha >>> 8) & 0xFF00FF | NegativeMulTable[addr] << 24;
                    o[dt + x] = d1 | (d0 &= 0xFF00) + (((s0 &= 0xFF00) - d0) * alpha >>> 8) & 0xFF00;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class CopyColor
    extends BlendContext {
        CopyColor() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    o[dt + x] = d[dt + x] & 0xFF000000 | s[st + x] & 0xFFFFFF;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class CopyMain
    extends BlendContext {
        CopyMain() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    o[dt + x] = s0 & 0xFFFFFF | d0 & 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class CopyMask
    extends BlendContext {
        CopyMask() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    o[dt + x] = s0 & 0xFF000000 | d0 & 0xFFFFFF;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class CopyOpaqueImage
    extends BlendContext {
        CopyOpaqueImage() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    o[dt + x] = s[st + x] | 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class DarkenBlend
    extends BlendContext {
        DarkenBlend() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int m_src = ~s0;
                    int tmp = (m_src & d0) + ((m_src ^ d0) >>> 1 & 0x7F7F7F7F) & 0x80808080;
                    tmp = (tmp << 1) - (tmp >>> 7);
                    d0 ^= (d0 ^ s0) & tmp;
                    o[dt + x] = d0 | 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class DarkenBlend_HDA
    extends BlendContext {
        DarkenBlend_HDA() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int m_src = ~s0;
                    int tmp = (m_src & d0) + ((m_src ^ d0) >>> 1 & 0x7F7F7F7F) & 0x80808080;
                    tmp = (tmp << 1) - (tmp >>> 7);
                    int n = dt + x;
                    o[n] = o[n] ^ (d0 ^ s0) & tmp & 0xFFFFFF;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class DarkenBlend_HDA_o
    extends BlendContext {
        public DarkenBlend_HDA_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int m_src = ~s0;
                    int tmp = (m_src & d0) + ((m_src ^ d0) >>> 1 & 0x7F7F7F7F) & 0x80808080;
                    tmp = (tmp << 1) - (tmp >>> 7);
                    tmp = d0 ^ (d0 ^ s0) & tmp & 0xFFFFFF;
                    int d1 = d0 & 0xFF00FF;
                    d1 = (d1 + (((tmp & 0xFF00FF) - d1) * opa >>> 8) & 0xFF00FF) + (d0 & 0xFF000000);
                    m_src = d0 & 0xFF00;
                    o[dt + x] = d1 + (m_src + (((tmp &= 0xFF00) - m_src) * opa >>> 8) & 0xFF00);
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class DarkenBlend_o
    extends BlendContext {
        public DarkenBlend_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int m_src = ~s0;
                    int tmp = (m_src & d0) + ((m_src ^ d0) >>> 1 & 0x7F7F7F7F) & 0x80808080;
                    tmp = (tmp << 1) - (tmp >>> 7);
                    tmp = d0 ^ (d0 ^ s0) & tmp;
                    int d1 = d0 & 0xFF00FF;
                    d1 = d1 + (((tmp & 0xFF00FF) - d1) * opa >>> 8) & 0xFF00FF;
                    m_src = d0 & 0xFF00;
                    o[dt + x] = d1 + (m_src + (((tmp &= 0xFF00) - m_src) * opa >>> 8) & 0xFF00) | 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class LightenBlend
    extends BlendContext {
        LightenBlend() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int m_dest = ~d0;
                    int tmp = (s0 & m_dest) + ((s0 ^ m_dest) >>> 1 & 0x7F7F7F7F) & 0x80808080;
                    tmp = (tmp << 1) - (tmp >>> 7);
                    d0 ^= (d0 ^ s0) & tmp;
                    o[dt + x] = d0 | 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class LightenBlend_HDA
    extends BlendContext {
        LightenBlend_HDA() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int m_dest = ~d0;
                    int tmp = (s0 & m_dest) + ((s0 ^ m_dest) >>> 1 & 0x7F7F7F7F) & 0x80808080;
                    tmp = (tmp << 1) - (tmp >>> 7);
                    int n = dt + x;
                    o[n] = o[n] ^ (d0 ^ s0) & tmp & 0xFFFFFF;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class LightenBlend_HDA_o
    extends BlendContext {
        public LightenBlend_HDA_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int m_dest = ~d0;
                    int tmp = (s0 & m_dest) + ((s0 ^ m_dest) >>> 1 & 0x7F7F7F7F) & 0x80808080;
                    tmp = (tmp << 1) - (tmp >>> 7);
                    tmp = d0 ^ (d0 ^ s0) & tmp & 0xFFFFFF;
                    int d1 = d0 & 0xFF00FF;
                    d1 = (d1 + (((tmp & 0xFF00FF) - d1) * opa >>> 8) & 0xFF00FF) + (d0 & 0xFF000000);
                    m_dest = d0 & 0xFF00;
                    o[dt + x] = d1 + (m_dest + (((tmp &= 0xFF00) - m_dest) * opa >>> 8) & 0xFF00);
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class LightenBlend_o
    extends BlendContext {
        public LightenBlend_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int m_dest = ~d0;
                    int tmp = (s0 & m_dest) + ((s0 ^ m_dest) >>> 1 & 0x7F7F7F7F) & 0x80808080;
                    tmp = (tmp << 1) - (tmp >>> 7);
                    tmp = d0 ^ (d0 ^ s0) & tmp;
                    int d1 = d0 & 0xFF00FF;
                    d1 = d1 + (((tmp & 0xFF00FF) - d1) * opa >>> 8) & 0xFF00FF;
                    m_dest = d0 & 0xFF00;
                    o[dt + x] = d1 + (m_dest + (((tmp &= 0xFF00) - m_dest) * opa >>> 8) & 0xFF00) | 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class MulBlend
    extends BlendContext {
        MulBlend() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int tmp = (d0 & 0xFF) * (s0 & 0xFF) & 0xFF00;
                    tmp |= ((d0 & 0xFF00) >>> 8) * (s0 & 0xFF00) & 0xFF0000;
                    tmp |= ((d0 & 0xFF0000) >>> 16) * (s0 & 0xFF0000) & 0xFF000000;
                    o[dt + x] = (tmp >>>= 8) | 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class MulBlend_HDA
    extends BlendContext {
        MulBlend_HDA() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int tmp = (d0 & 0xFF) * (s0 & 0xFF) & 0xFF00;
                    tmp |= ((d0 & 0xFF00) >>> 8) * (s0 & 0xFF00) & 0xFF0000;
                    tmp |= ((d0 & 0xFF0000) >>> 16) * (s0 & 0xFF0000) & 0xFF000000;
                    o[dt + x] = (tmp >>>= 8) + (d0 & 0xFF000000);
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class MulBlend_HDA_o
    extends BlendContext {
        public MulBlend_HDA_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    s0 ^= 0xFFFFFFFF;
                    s0 = ~(((s0 & 0xFF00) * opa >>> 8 & 0xFF00) + ((s0 & 0xFF00FF) * opa >>> 8 & 0xFF00FF));
                    int tmp = (d0 & 0xFF) * (s0 & 0xFF) & 0xFF00;
                    tmp |= ((d0 & 0xFF00) >>> 8) * (s0 & 0xFF00) & 0xFF0000;
                    tmp |= ((d0 & 0xFF0000) >>> 16) * (s0 & 0xFF0000) & 0xFF000000;
                    o[dt + x] = (tmp >>>= 8) + (d0 & 0xFF000000);
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class MulBlend_o
    extends BlendContext {
        public MulBlend_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    s0 ^= 0xFFFFFFFF;
                    s0 = ~(((s0 & 0xFF00) * opa >>> 8 & 0xFF00) + ((s0 & 0xFF00FF) * opa >>> 8 & 0xFF00FF));
                    int tmp = (d0 & 0xFF) * (s0 & 0xFF) & 0xFF00;
                    tmp |= ((d0 & 0xFF00) >>> 8) * (s0 & 0xFF00) & 0xFF0000;
                    tmp |= ((d0 & 0xFF0000) >>> 16) * (s0 & 0xFF0000) & 0xFF000000;
                    o[dt + x] = (tmp >>>= 8) | 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsAddBlend
    extends BlendContext {
        PsAddBlend() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = s0 >>> 24;
                    int n = ((d0 & s0) << 1) + ((d0 ^ s0) & 0xFEFEFE) & 0x1010100;
                    n = (n >>> 8) + 0x7F7F7F ^ 0x7F7F7F;
                    s0 = d0 + s0 - n | n;
                    int d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsAddBlend_HDA
    extends BlendContext {
        PsAddBlend_HDA() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = s0 >>> 24;
                    int n = ((d0 & s0) << 1) + ((d0 ^ s0) & 0xFEFEFE) & 0x1010100;
                    n = (n >>> 8) + 0x7F7F7F ^ 0x7F7F7F;
                    s0 = d0 + s0 - n | n;
                    int d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | d0 & 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsAddBlend_HDA_o
    extends BlendContext {
        public PsAddBlend_HDA_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = (s0 >>> 24) * opa >>> 8;
                    int n = ((d0 & s0) << 1) + ((d0 ^ s0) & 0xFEFEFE) & 0x1010100;
                    n = (n >>> 8) + 0x7F7F7F ^ 0x7F7F7F;
                    s0 = d0 + s0 - n | n;
                    int d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | d0 & 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsAddBlend_o
    extends BlendContext {
        public PsAddBlend_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = (s0 >>> 24) * opa >>> 8;
                    int n = ((d0 & s0) << 1) + ((d0 ^ s0) & 0xFEFEFE) & 0x1010100;
                    n = (n >>> 8) + 0x7F7F7F ^ 0x7F7F7F;
                    s0 = d0 + s0 - n | n;
                    int d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsAlphaBlend
    extends BlendContext {
        PsAlphaBlend() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = s0 >>> 24;
                    int d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsAlphaBlend_HDA
    extends BlendContext {
        PsAlphaBlend_HDA() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = s0 >>> 24;
                    int d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | d0 & 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsAlphaBlend_HDA_o
    extends BlendContext {
        public PsAlphaBlend_HDA_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = (s0 >>> 24) * opa >>> 8;
                    int d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | d0 & 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsAlphaBlend_o
    extends BlendContext {
        public PsAlphaBlend_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = (s0 >>> 24) * opa >>> 8;
                    int d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsColorBurnBlend
    extends BlendContext {
        PsColorBurnBlend() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = s0 >>> 24;
                    s0 = PsTableColorBurn[s0 >>> 16 & 0xFF][d0 >>> 16 & 0xFF] << 16 | PsTableColorBurn[s0 >>> 8 & 0xFF][d0 >>> 8 & 0xFF] << 8 | PsTableColorBurn[s0 >>> 0 & 0xFF][d0 >>> 0 & 0xFF] << 0;
                    int d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsColorBurnBlend_HDA
    extends BlendContext {
        PsColorBurnBlend_HDA() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = s0 >>> 24;
                    s0 = PsTableColorBurn[s0 >>> 16 & 0xFF][d0 >>> 16 & 0xFF] << 16 | PsTableColorBurn[s0 >>> 8 & 0xFF][d0 >>> 8 & 0xFF] << 8 | PsTableColorBurn[s0 >>> 0 & 0xFF][d0 >>> 0 & 0xFF] << 0;
                    int d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | d0 & 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsColorBurnBlend_HDA_o
    extends BlendContext {
        public PsColorBurnBlend_HDA_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = (s0 >>> 24) * opa >>> 8;
                    s0 = PsTableColorBurn[s0 >>> 16 & 0xFF][d0 >>> 16 & 0xFF] << 16 | PsTableColorBurn[s0 >>> 8 & 0xFF][d0 >>> 8 & 0xFF] << 8 | PsTableColorBurn[s0 >>> 0 & 0xFF][d0 >>> 0 & 0xFF] << 0;
                    int d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | d0 & 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsColorBurnBlend_o
    extends BlendContext {
        public PsColorBurnBlend_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = (s0 >>> 24) * opa >>> 8;
                    s0 = PsTableColorBurn[s0 >>> 16 & 0xFF][d0 >>> 16 & 0xFF] << 16 | PsTableColorBurn[s0 >>> 8 & 0xFF][d0 >>> 8 & 0xFF] << 8 | PsTableColorBurn[s0 >>> 0 & 0xFF][d0 >>> 0 & 0xFF] << 0;
                    int d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsColorDodge5Blend
    extends BlendContext {
        PsColorDodge5Blend() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = s0 >>> 24;
                    s0 = (s0 & 0xFF00FF) * a >>> 8 & 0xFF00FF | (s0 & 0xFF00) * a >>> 8 & 0xFF00;
                    s0 = (PsTableColorDodge[s0 >>> 16 & 0xFF][d0 >>> 16 & 0xFF] & 0xFF) << 16 | (PsTableColorDodge[s0 >>> 8 & 0xFF][d0 >>> 8 & 0xFF] & 0xFF) << 8 | (PsTableColorDodge[s0 >>> 0 & 0xFF][d0 >>> 0 & 0xFF] & 0xFF) << 0;
                    o[dt + x] = s0 | 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsColorDodge5Blend_HDA
    extends BlendContext {
        PsColorDodge5Blend_HDA() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = s0 >>> 24;
                    s0 = (s0 & 0xFF00FF) * a >>> 8 & 0xFF00FF | (s0 & 0xFF00) * a >>> 8 & 0xFF00;
                    s0 = (PsTableColorDodge[s0 >>> 16 & 0xFF][d0 >>> 16 & 0xFF] & 0xFF) << 16 | (PsTableColorDodge[s0 >>> 8 & 0xFF][d0 >>> 8 & 0xFF] & 0xFF) << 8 | (PsTableColorDodge[s0 >>> 0 & 0xFF][d0 >>> 0 & 0xFF] & 0xFF) << 0;
                    o[dt + x] = s0 | d0 & 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsColorDodge5Blend_HDA_o
    extends BlendContext {
        public PsColorDodge5Blend_HDA_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = (s0 >>> 24) * opa >>> 8;
                    s0 = (s0 & 0xFF00FF) * a >>> 8 & 0xFF00FF | (s0 & 0xFF00) * a >>> 8 & 0xFF00;
                    s0 = (PsTableColorDodge[s0 >>> 16 & 0xFF][d0 >>> 16 & 0xFF] & 0xFF) << 16 | (PsTableColorDodge[s0 >>> 8 & 0xFF][d0 >>> 8 & 0xFF] & 0xFF) << 8 | (PsTableColorDodge[s0 >>> 0 & 0xFF][d0 >>> 0 & 0xFF] & 0xFF) << 0;
                    o[dt + x] = s0 | d0 & 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsColorDodge5Blend_o
    extends BlendContext {
        public PsColorDodge5Blend_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = (s0 >>> 24) * opa >>> 8;
                    s0 = (s0 & 0xFF00FF) * a >>> 8 & 0xFF00FF | (s0 & 0xFF00) * a >>> 8 & 0xFF00;
                    s0 = (PsTableColorDodge[s0 >>> 16 & 0xFF][d0 >>> 16 & 0xFF] & 0xFF) << 16 | (PsTableColorDodge[s0 >>> 8 & 0xFF][d0 >>> 8 & 0xFF] & 0xFF) << 8 | (PsTableColorDodge[s0 >>> 0 & 0xFF][d0 >>> 0 & 0xFF] & 0xFF) << 0;
                    o[dt + x] = s0 | 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsColorDodgeBlend
    extends BlendContext {
        PsColorDodgeBlend() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = s0 >>> 24;
                    s0 = (PsTableColorDodge[s0 >>> 16 & 0xFF][d0 >>> 16 & 0xFF] & 0xFF) << 16 | (PsTableColorDodge[s0 >>> 8 & 0xFF][d0 >>> 8 & 0xFF] & 0xFF) << 8 | (PsTableColorDodge[s0 >>> 0 & 0xFF][d0 >>> 0 & 0xFF] & 0xFF) << 0;
                    int d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsColorDodgeBlend_HDA
    extends BlendContext {
        PsColorDodgeBlend_HDA() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = s0 >>> 24;
                    s0 = (PsTableColorDodge[s0 >>> 16 & 0xFF][d0 >>> 16 & 0xFF] & 0xFF) << 16 | (PsTableColorDodge[s0 >>> 8 & 0xFF][d0 >>> 8 & 0xFF] & 0xFF) << 8 | (PsTableColorDodge[s0 >>> 0 & 0xFF][d0 >>> 0 & 0xFF] & 0xFF) << 0;
                    int d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | d0 & 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsColorDodgeBlend_HDA_o
    extends BlendContext {
        public PsColorDodgeBlend_HDA_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = (s0 >>> 24) * opa >>> 8;
                    s0 = (PsTableColorDodge[s0 >>> 16 & 0xFF][d0 >>> 16 & 0xFF] & 0xFF) << 16 | (PsTableColorDodge[s0 >>> 8 & 0xFF][d0 >>> 8 & 0xFF] & 0xFF) << 8 | (PsTableColorDodge[s0 >>> 0 & 0xFF][d0 >>> 0 & 0xFF] & 0xFF) << 0;
                    int d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | d0 & 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsColorDodgeBlend_o
    extends BlendContext {
        public PsColorDodgeBlend_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = (s0 >>> 24) * opa >>> 8;
                    s0 = (PsTableColorDodge[s0 >>> 16 & 0xFF][d0 >>> 16 & 0xFF] & 0xFF) << 16 | (PsTableColorDodge[s0 >>> 8 & 0xFF][d0 >>> 8 & 0xFF] & 0xFF) << 8 | (PsTableColorDodge[s0 >>> 0 & 0xFF][d0 >>> 0 & 0xFF] & 0xFF) << 0;
                    int d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsDarkenBlend
    extends BlendContext {
        PsDarkenBlend() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = s0 >>> 24;
                    int n = ((~d0 & s0) << 1) + ((~d0 ^ s0) & 0xFEFEFE) & 0x1010100;
                    n = (n >>> 8) + 0x7F7F7F ^ 0x7F7F7F;
                    s0 = d0 & n | s0 & ~n;
                    int d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsDarkenBlend_HDA
    extends BlendContext {
        PsDarkenBlend_HDA() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = s0 >>> 24;
                    int n = ((~d0 & s0) << 1) + ((~d0 ^ s0) & 0xFEFEFE) & 0x1010100;
                    n = (n >>> 8) + 0x7F7F7F ^ 0x7F7F7F;
                    s0 = d0 & n | s0 & ~n;
                    int d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | d0 & 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsDarkenBlend_HDA_o
    extends BlendContext {
        public PsDarkenBlend_HDA_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = (s0 >>> 24) * opa >>> 8;
                    int n = ((~d0 & s0) << 1) + ((~d0 ^ s0) & 0xFEFEFE) & 0x1010100;
                    n = (n >>> 8) + 0x7F7F7F ^ 0x7F7F7F;
                    s0 = d0 & n | s0 & ~n;
                    int d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | d0 & 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsDarkenBlend_o
    extends BlendContext {
        public PsDarkenBlend_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = (s0 >>> 24) * opa >>> 8;
                    int n = ((~d0 & s0) << 1) + ((~d0 ^ s0) & 0xFEFEFE) & 0x1010100;
                    n = (n >>> 8) + 0x7F7F7F ^ 0x7F7F7F;
                    s0 = d0 & n | s0 & ~n;
                    int d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsDiff5Blend
    extends BlendContext {
        PsDiff5Blend() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = s0 >>> 24;
                    s0 = (s0 & 0xFF00FF) * a >>> 8 & 0xFF00FF | (s0 & 0xFF00) * a >>> 8 & 0xFF00;
                    int n = ((~d0 & s0) << 1) + ((~d0 ^ s0) & 0xFEFEFE) & 0x1010100;
                    n = (n >>> 8) + 0x7F7F7F ^ 0x7F7F7F;
                    o[dt + x] = s0 = (s0 & n) - (d0 & n) | (d0 & ~n) - (s0 & ~n);
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsDiff5Blend_HDA
    extends BlendContext {
        PsDiff5Blend_HDA() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = s0 >>> 24;
                    s0 = (s0 & 0xFF00FF) * a >>> 8 & 0xFF00FF | (s0 & 0xFF00) * a >>> 8 & 0xFF00;
                    int n = ((~d0 & s0) << 1) + ((~d0 ^ s0) & 0xFEFEFE) & 0x1010100;
                    n = (n >>> 8) + 0x7F7F7F ^ 0x7F7F7F;
                    s0 = (s0 & n) - (d0 & n) | (d0 & ~n) - (s0 & ~n);
                    o[dt + x] = s0 | d0 & 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsDiff5Blend_HDA_o
    extends BlendContext {
        public PsDiff5Blend_HDA_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = (s0 >>> 24) * opa >>> 8;
                    s0 = (s0 & 0xFF00FF) * a >>> 8 & 0xFF00FF | (s0 & 0xFF00) * a >>> 8 & 0xFF00;
                    int n = ((~d0 & s0) << 1) + ((~d0 ^ s0) & 0xFEFEFE) & 0x1010100;
                    n = (n >>> 8) + 0x7F7F7F ^ 0x7F7F7F;
                    s0 = (s0 & n) - (d0 & n) | (d0 & ~n) - (s0 & ~n);
                    o[dt + x] = s0 | d0 & 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsDiff5Blend_o
    extends BlendContext {
        public PsDiff5Blend_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = (s0 >>> 24) * opa >>> 8;
                    s0 = (s0 & 0xFF00FF) * a >>> 8 & 0xFF00FF | (s0 & 0xFF00) * a >>> 8 & 0xFF00;
                    int n = ((~d0 & s0) << 1) + ((~d0 ^ s0) & 0xFEFEFE) & 0x1010100;
                    n = (n >>> 8) + 0x7F7F7F ^ 0x7F7F7F;
                    o[dt + x] = s0 = (s0 & n) - (d0 & n) | (d0 & ~n) - (s0 & ~n);
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsDiffBlend
    extends BlendContext {
        PsDiffBlend() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = s0 >>> 24;
                    int n = ((~d0 & s0) << 1) + ((~d0 ^ s0) & 0xFEFEFE) & 0x1010100;
                    n = (n >>> 8) + 0x7F7F7F ^ 0x7F7F7F;
                    s0 = (s0 & n) - (d0 & n) | (d0 & ~n) - (s0 & ~n);
                    int d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsDiffBlend_HDA
    extends BlendContext {
        PsDiffBlend_HDA() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = s0 >>> 24;
                    int n = ((~d0 & s0) << 1) + ((~d0 ^ s0) & 0xFEFEFE) & 0x1010100;
                    n = (n >>> 8) + 0x7F7F7F ^ 0x7F7F7F;
                    s0 = (s0 & n) - (d0 & n) | (d0 & ~n) - (s0 & ~n);
                    int d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | d0 & 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsDiffBlend_HDA_o
    extends BlendContext {
        public PsDiffBlend_HDA_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = (s0 >>> 24) * opa >>> 8;
                    int n = ((~d0 & s0) << 1) + ((~d0 ^ s0) & 0xFEFEFE) & 0x1010100;
                    n = (n >>> 8) + 0x7F7F7F ^ 0x7F7F7F;
                    s0 = (s0 & n) - (d0 & n) | (d0 & ~n) - (s0 & ~n);
                    int d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | d0 & 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsDiffBlend_o
    extends BlendContext {
        public PsDiffBlend_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = (s0 >>> 24) * opa >>> 8;
                    int n = ((~d0 & s0) << 1) + ((~d0 ^ s0) & 0xFEFEFE) & 0x1010100;
                    n = (n >>> 8) + 0x7F7F7F ^ 0x7F7F7F;
                    s0 = (s0 & n) - (d0 & n) | (d0 & ~n) - (s0 & ~n);
                    int d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsExclusionBlend
    extends BlendContext {
        PsExclusionBlend() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = s0 >>> 24;
                    int sd1 = (d0 >>> 16 & 0xFF) * ((s0 & 0xFF0000) >>> 7) & 0x1FF0000 | (d0 >>> 0 & 0xFF) * (s0 & 0xFF) >>> 7;
                    int sd2 = ((d0 >>> 8 & 0xFF) * (s0 & 0xFF00) & 0xFF8000) >>> 7;
                    s0 = (((s0 & 0xFF00FF) - sd1) * a >>> 8) + (d0 & 0xFF00FF) & 0xFF00FF | (((s0 & 0xFF00) - sd2) * a >>> 8) + (d0 & 0xFF00) & 0xFF00;
                    o[dt + x] = s0 | 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsExclusionBlend_HDA
    extends BlendContext {
        PsExclusionBlend_HDA() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = s0 >>> 24;
                    int sd1 = (d0 >>> 16 & 0xFF) * ((s0 & 0xFF0000) >>> 7) & 0x1FF0000 | (d0 >>> 0 & 0xFF) * (s0 & 0xFF) >>> 7;
                    int sd2 = ((d0 >>> 8 & 0xFF) * (s0 & 0xFF00) & 0xFF8000) >>> 7;
                    s0 = (((s0 & 0xFF00FF) - sd1) * a >>> 8) + (d0 & 0xFF00FF) & 0xFF00FF | (((s0 & 0xFF00) - sd2) * a >>> 8) + (d0 & 0xFF00) & 0xFF00;
                    o[dt + x] = s0 | d0 & 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsExclusionBlend_HDA_o
    extends BlendContext {
        public PsExclusionBlend_HDA_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = (s0 >>> 24) * opa >>> 8;
                    int sd1 = (d0 >>> 16 & 0xFF) * ((s0 & 0xFF0000) >>> 7) & 0x1FF0000 | (d0 >>> 0 & 0xFF) * (s0 & 0xFF) >>> 7;
                    int sd2 = ((d0 >>> 8 & 0xFF) * (s0 & 0xFF00) & 0xFF8000) >>> 7;
                    s0 = (((s0 & 0xFF00FF) - sd1) * a >>> 8) + (d0 & 0xFF00FF) & 0xFF00FF | (((s0 & 0xFF00) - sd2) * a >>> 8) + (d0 & 0xFF00) & 0xFF00;
                    o[dt + x] = s0 | d0 & 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsExclusionBlend_o
    extends BlendContext {
        public PsExclusionBlend_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = (s0 >>> 24) * opa >>> 8;
                    int sd1 = (d0 >>> 16 & 0xFF) * ((s0 & 0xFF0000) >>> 7) & 0x1FF0000 | (d0 >>> 0 & 0xFF) * (s0 & 0xFF) >>> 7;
                    int sd2 = ((d0 >>> 8 & 0xFF) * (s0 & 0xFF00) & 0xFF8000) >>> 7;
                    s0 = (((s0 & 0xFF00FF) - sd1) * a >>> 8) + (d0 & 0xFF00FF) & 0xFF00FF | (((s0 & 0xFF00) - sd2) * a >>> 8) + (d0 & 0xFF00) & 0xFF00;
                    o[dt + x] = s0 | 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsHardLightBlend
    extends BlendContext {
        PsHardLightBlend() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = s0 >>> 24;
                    int n = ((s0 & 0x808080) >>> 7) + 0x7F7F7F ^ 0x7F7F7F;
                    int d1 = d0 & n;
                    int s1 = s0 & n;
                    int sa1 = (((d0 |= 0x10101) >>> 16 & 0xFF) * (s0 & 0xFF0000) & 0xFF800000 | (d0 >>> 0 & 0xFF) * (s0 & 0xFF)) >>> 7;
                    int sa2 = ((d0 >>> 8 & 0xFF) * (s0 & 0xFF00) & 0xFF8000) >>> 7;
                    s0 = sa1 & ~n | sa2 & ~n;
                    s0 |= ((s1 & 0xFF00FF) + (d1 & 0xFE00FE) << 1) - (n & 0xFF00FF) - (sa1 & n);
                    s0 |= ((s1 & 0xFF00) + (d1 & 0xFE00) << 1) - (n & 0xFF00) - (sa2 & n);
                    d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsHardLightBlend_HDA
    extends BlendContext {
        PsHardLightBlend_HDA() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = s0 >>> 24;
                    int n = ((s0 & 0x808080) >>> 7) + 0x7F7F7F ^ 0x7F7F7F;
                    int d1 = d0 & n;
                    int s1 = s0 & n;
                    int sa1 = (((d0 |= 0x10101) >>> 16 & 0xFF) * (s0 & 0xFF0000) & 0xFF800000 | (d0 >>> 0 & 0xFF) * (s0 & 0xFF)) >>> 7;
                    int sa2 = ((d0 >>> 8 & 0xFF) * (s0 & 0xFF00) & 0xFF8000) >>> 7;
                    s0 = sa1 & ~n | sa2 & ~n;
                    s0 |= ((s1 & 0xFF00FF) + (d1 & 0xFE00FE) << 1) - (n & 0xFF00FF) - (sa1 & n);
                    s0 |= ((s1 & 0xFF00) + (d1 & 0xFE00) << 1) - (n & 0xFF00) - (sa2 & n);
                    d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | d0 & 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsHardLightBlend_HDA_o
    extends BlendContext {
        public PsHardLightBlend_HDA_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = (s0 >>> 24) * opa >>> 8;
                    int n = ((s0 & 0x808080) >>> 7) + 0x7F7F7F ^ 0x7F7F7F;
                    int d1 = d0 & n;
                    int s1 = s0 & n;
                    int sa1 = (((d0 |= 0x10101) >>> 16 & 0xFF) * (s0 & 0xFF0000) & 0xFF800000 | (d0 >>> 0 & 0xFF) * (s0 & 0xFF)) >>> 7;
                    int sa2 = ((d0 >>> 8 & 0xFF) * (s0 & 0xFF00) & 0xFF8000) >>> 7;
                    s0 = sa1 & ~n | sa2 & ~n;
                    s0 |= ((s1 & 0xFF00FF) + (d1 & 0xFE00FE) << 1) - (n & 0xFF00FF) - (sa1 & n);
                    s0 |= ((s1 & 0xFF00) + (d1 & 0xFE00) << 1) - (n & 0xFF00) - (sa2 & n);
                    d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | d0 & 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsHardLightBlend_o
    extends BlendContext {
        public PsHardLightBlend_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = (s0 >>> 24) * opa >>> 8;
                    int n = ((s0 & 0x808080) >>> 7) + 0x7F7F7F ^ 0x7F7F7F;
                    int d1 = d0 & n;
                    int s1 = s0 & n;
                    int sa1 = (((d0 |= 0x10101) >>> 16 & 0xFF) * (s0 & 0xFF0000) & 0xFF800000 | (d0 >>> 0 & 0xFF) * (s0 & 0xFF)) >>> 7;
                    int sa2 = ((d0 >>> 8 & 0xFF) * (s0 & 0xFF00) & 0xFF8000) >>> 7;
                    s0 = sa1 & ~n | sa2 & ~n;
                    s0 |= ((s1 & 0xFF00FF) + (d1 & 0xFE00FE) << 1) - (n & 0xFF00FF) - (sa1 & n);
                    s0 |= ((s1 & 0xFF00) + (d1 & 0xFE00) << 1) - (n & 0xFF00) - (sa2 & n);
                    d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsLightenBlend
    extends BlendContext {
        PsLightenBlend() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = s0 >>> 24;
                    int n = ((~d0 & s0) << 1) + ((~d0 ^ s0) & 0xFEFEFE) & 0x1010100;
                    n = (n >>> 8) + 0x7F7F7F ^ 0x7F7F7F;
                    s0 = s0 & n | d0 & ~n;
                    int d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsLightenBlend_HDA
    extends BlendContext {
        PsLightenBlend_HDA() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = s0 >>> 24;
                    int n = ((~d0 & s0) << 1) + ((~d0 ^ s0) & 0xFEFEFE) & 0x1010100;
                    n = (n >>> 8) + 0x7F7F7F ^ 0x7F7F7F;
                    s0 = s0 & n | d0 & ~n;
                    int d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | d0 & 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsLightenBlend_HDA_o
    extends BlendContext {
        public PsLightenBlend_HDA_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = (s0 >>> 24) * opa >>> 8;
                    int n = ((~d0 & s0) << 1) + ((~d0 ^ s0) & 0xFEFEFE) & 0x1010100;
                    n = (n >>> 8) + 0x7F7F7F ^ 0x7F7F7F;
                    s0 = s0 & n | d0 & ~n;
                    int d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | d0 & 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsLightenBlend_o
    extends BlendContext {
        public PsLightenBlend_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = (s0 >>> 24) * opa >>> 8;
                    int n = ((~d0 & s0) << 1) + ((~d0 ^ s0) & 0xFEFEFE) & 0x1010100;
                    n = (n >>> 8) + 0x7F7F7F ^ 0x7F7F7F;
                    s0 = s0 & n | d0 & ~n;
                    int d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsMulBlend
    extends BlendContext {
        PsMulBlend() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = s0 >>> 24;
                    s0 = ((d0 >>> 16 & 0xFF) * (s0 & 0xFF0000) & 0xFF000000 | (d0 >>> 8 & 0xFF) * (s0 & 0xFF00) & 0xFF0000 | (d0 >>> 0 & 0xFF) * (s0 & 0xFF)) >>> 8;
                    int d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsMulBlend_HDA
    extends BlendContext {
        PsMulBlend_HDA() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = s0 >>> 24;
                    s0 = ((d0 >>> 16 & 0xFF) * (s0 & 0xFF0000) & 0xFF000000 | (d0 >>> 8 & 0xFF) * (s0 & 0xFF00) & 0xFF0000 | (d0 >>> 0 & 0xFF) * (s0 & 0xFF)) >>> 8;
                    int d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | d0 & 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsMulBlend_HDA_o
    extends BlendContext {
        public PsMulBlend_HDA_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = (s0 >>> 24) * opa >>> 8;
                    s0 = ((d0 >>> 16 & 0xFF) * (s0 & 0xFF0000) & 0xFF000000 | (d0 >>> 8 & 0xFF) * (s0 & 0xFF00) & 0xFF0000 | (d0 >>> 0 & 0xFF) * (s0 & 0xFF)) >>> 8;
                    int d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | d0 & 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsMulBlend_o
    extends BlendContext {
        public PsMulBlend_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = (s0 >>> 24) * opa >>> 8;
                    s0 = ((d0 >>> 16 & 0xFF) * (s0 & 0xFF0000) & 0xFF000000 | (d0 >>> 8 & 0xFF) * (s0 & 0xFF00) & 0xFF0000 | (d0 >>> 0 & 0xFF) * (s0 & 0xFF)) >>> 8;
                    int d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsOverlayBlend
    extends BlendContext {
        PsOverlayBlend() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = s0 >>> 24;
                    int n = ((d0 & 0x808080) >>> 7) + 0x7F7F7F ^ 0x7F7F7F;
                    int d1 = d0 & n;
                    int s1 = s0 & n;
                    int sa1 = ((d0 >>> 16 & 0xFF) * ((s0 |= 0x10101) & 0xFF0000) & 0xFF800000 | (d0 >>> 0 & 0xFF) * (s0 & 0xFF)) >>> 7;
                    int sa2 = ((d0 >>> 8 & 0xFF) * (s0 & 0xFF00) & 0xFF8000) >>> 7;
                    s0 = sa1 & ~n | sa2 & ~n;
                    s0 |= ((s1 & 0xFE00FE) + (d1 & 0xFF00FF) << 1) - (n & 0xFF00FF) - (sa1 & n);
                    s0 |= ((s1 & 0xFE00) + (d1 & 0xFF00) << 1) - (n & 0xFF00) - (sa2 & n);
                    d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsOverlayBlend_HDA
    extends BlendContext {
        PsOverlayBlend_HDA() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = s0 >>> 24;
                    int n = ((d0 & 0x808080) >>> 7) + 0x7F7F7F ^ 0x7F7F7F;
                    int d1 = d0 & n;
                    int s1 = s0 & n;
                    int sa1 = ((d0 >>> 16 & 0xFF) * ((s0 |= 0x10101) & 0xFF0000) & 0xFF800000 | (d0 >>> 0 & 0xFF) * (s0 & 0xFF)) >>> 7;
                    int sa2 = ((d0 >>> 8 & 0xFF) * (s0 & 0xFF00) & 0xFF8000) >>> 7;
                    s0 = sa1 & ~n | sa2 & ~n;
                    s0 |= ((s1 & 0xFE00FE) + (d1 & 0xFF00FF) << 1) - (n & 0xFF00FF) - (sa1 & n);
                    s0 |= ((s1 & 0xFE00) + (d1 & 0xFF00) << 1) - (n & 0xFF00) - (sa2 & n);
                    d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | d0 & 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsOverlayBlend_HDA_o
    extends BlendContext {
        public PsOverlayBlend_HDA_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = (s0 >>> 24) * opa >>> 8;
                    int n = ((d0 & 0x808080) >>> 7) + 0x7F7F7F ^ 0x7F7F7F;
                    int d1 = d0 & n;
                    int s1 = s0 & n;
                    int sa1 = ((d0 >>> 16 & 0xFF) * ((s0 |= 0x10101) & 0xFF0000) & 0xFF800000 | (d0 >>> 0 & 0xFF) * (s0 & 0xFF)) >>> 7;
                    int sa2 = ((d0 >>> 8 & 0xFF) * (s0 & 0xFF00) & 0xFF8000) >>> 7;
                    s0 = sa1 & ~n | sa2 & ~n;
                    s0 |= ((s1 & 0xFE00FE) + (d1 & 0xFF00FF) << 1) - (n & 0xFF00FF) - (sa1 & n);
                    s0 |= ((s1 & 0xFE00) + (d1 & 0xFF00) << 1) - (n & 0xFF00) - (sa2 & n);
                    d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | d0 & 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsOverlayBlend_o
    extends BlendContext {
        public PsOverlayBlend_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = (s0 >>> 24) * opa >>> 8;
                    int n = ((d0 & 0x808080) >>> 7) + 0x7F7F7F ^ 0x7F7F7F;
                    int d1 = d0 & n;
                    int s1 = s0 & n;
                    int sa1 = ((d0 >>> 16 & 0xFF) * ((s0 |= 0x10101) & 0xFF0000) & 0xFF800000 | (d0 >>> 0 & 0xFF) * (s0 & 0xFF)) >>> 7;
                    int sa2 = ((d0 >>> 8 & 0xFF) * (s0 & 0xFF00) & 0xFF8000) >>> 7;
                    s0 = sa1 & ~n | sa2 & ~n;
                    s0 |= ((s1 & 0xFE00FE) + (d1 & 0xFF00FF) << 1) - (n & 0xFF00FF) - (sa1 & n);
                    s0 |= ((s1 & 0xFE00) + (d1 & 0xFF00) << 1) - (n & 0xFF00) - (sa2 & n);
                    d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsScreenBlend
    extends BlendContext {
        PsScreenBlend() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = s0 >>> 24;
                    int sd1 = ((d0 >>> 16 & 0xFF) * (s0 & 0xFF0000) & 0xFF000000 | (d0 >>> 0 & 0xFF) * (s0 & 0xFF)) >>> 8;
                    int sd2 = ((d0 >>> 8 & 0xFF) * (s0 & 0xFF00) & 0xFF0000) >>> 8;
                    s0 = (((s0 & 0xFF00FF) - sd1) * a >>> 8) + (d0 & 0xFF00FF) & 0xFF00FF | (((s0 & 0xFF00) - sd2) * a >>> 8) + (d0 & 0xFF00) & 0xFF00;
                    o[dt + x] = s0 | 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsScreenBlend_HDA
    extends BlendContext {
        PsScreenBlend_HDA() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = s0 >>> 24;
                    int sd1 = ((d0 >>> 16 & 0xFF) * (s0 & 0xFF0000) & 0xFF000000 | (d0 >>> 0 & 0xFF) * (s0 & 0xFF)) >>> 8;
                    int sd2 = ((d0 >>> 8 & 0xFF) * (s0 & 0xFF00) & 0xFF0000) >>> 8;
                    s0 = (((s0 & 0xFF00FF) - sd1) * a >>> 8) + (d0 & 0xFF00FF) & 0xFF00FF | (((s0 & 0xFF00) - sd2) * a >>> 8) + (d0 & 0xFF00) & 0xFF00;
                    o[dt + x] = s0 | d0 & 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsScreenBlend_HDA_o
    extends BlendContext {
        public PsScreenBlend_HDA_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = (s0 >>> 24) * opa >>> 8;
                    int sd1 = ((d0 >>> 16 & 0xFF) * (s0 & 0xFF0000) & 0xFF000000 | (d0 >>> 0 & 0xFF) * (s0 & 0xFF)) >>> 8;
                    int sd2 = ((d0 >>> 8 & 0xFF) * (s0 & 0xFF00) & 0xFF0000) >>> 8;
                    s0 = (((s0 & 0xFF00FF) - sd1) * a >>> 8) + (d0 & 0xFF00FF) & 0xFF00FF | (((s0 & 0xFF00) - sd2) * a >>> 8) + (d0 & 0xFF00) & 0xFF00;
                    o[dt + x] = s0 | d0 & 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsScreenBlend_o
    extends BlendContext {
        public PsScreenBlend_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = (s0 >>> 24) * opa >>> 8;
                    int sd1 = ((d0 >>> 16 & 0xFF) * (s0 & 0xFF0000) & 0xFF000000 | (d0 >>> 0 & 0xFF) * (s0 & 0xFF)) >>> 8;
                    int sd2 = ((d0 >>> 8 & 0xFF) * (s0 & 0xFF00) & 0xFF0000) >>> 8;
                    s0 = (((s0 & 0xFF00FF) - sd1) * a >>> 8) + (d0 & 0xFF00FF) & 0xFF00FF | (((s0 & 0xFF00) - sd2) * a >>> 8) + (d0 & 0xFF00) & 0xFF00;
                    o[dt + x] = s0 | 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsSoftLightBlend
    extends BlendContext {
        PsSoftLightBlend() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = s0 >>> 24;
                    s0 = PsTableSoftLight[s0 >>> 16 & 0xFF][d0 >>> 16 & 0xFF] << 16 | PsTableSoftLight[s0 >>> 8 & 0xFF][d0 >>> 8 & 0xFF] << 8 | PsTableSoftLight[s0 >>> 0 & 0xFF][d0 >>> 0 & 0xFF] << 0;
                    int d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsSoftLightBlend_HDA
    extends BlendContext {
        PsSoftLightBlend_HDA() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = s0 >>> 24;
                    s0 = PsTableSoftLight[s0 >>> 16 & 0xFF][d0 >>> 16 & 0xFF] << 16 | PsTableSoftLight[s0 >>> 8 & 0xFF][d0 >>> 8 & 0xFF] << 8 | PsTableSoftLight[s0 >>> 0 & 0xFF][d0 >>> 0 & 0xFF] << 0;
                    int d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | d0 & 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsSoftLightBlend_HDA_o
    extends BlendContext {
        public PsSoftLightBlend_HDA_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = (s0 >>> 24) * opa >>> 8;
                    s0 = PsTableSoftLight[s0 >>> 16 & 0xFF][d0 >>> 16 & 0xFF] << 16 | PsTableSoftLight[s0 >>> 8 & 0xFF][d0 >>> 8 & 0xFF] << 8 | PsTableSoftLight[s0 >>> 0 & 0xFF][d0 >>> 0 & 0xFF] << 0;
                    int d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | d0 & 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsSoftLightBlend_o
    extends BlendContext {
        public PsSoftLightBlend_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = (s0 >>> 24) * opa >>> 8;
                    s0 = PsTableSoftLight[s0 >>> 16 & 0xFF][d0 >>> 16 & 0xFF] << 16 | PsTableSoftLight[s0 >>> 8 & 0xFF][d0 >>> 8 & 0xFF] << 8 | PsTableSoftLight[s0 >>> 0 & 0xFF][d0 >>> 0 & 0xFF] << 0;
                    int d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsSubBlend
    extends BlendContext {
        PsSubBlend() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = s0 >>> 24;
                    int n = ((~d0 & (s0 ^= 0xFFFFFFFF)) << 1) + ((~d0 ^ s0) & 0xFEFEFE) & 0x1010100;
                    n = (n >>> 8) + 0x7F7F7F ^ 0x7F7F7F;
                    s0 = (d0 | n) - (s0 | n);
                    int d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsSubBlend_HDA
    extends BlendContext {
        PsSubBlend_HDA() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = s0 >>> 24;
                    int n = ((~d0 & (s0 ^= 0xFFFFFFFF)) << 1) + ((~d0 ^ s0) & 0xFEFEFE) & 0x1010100;
                    n = (n >>> 8) + 0x7F7F7F ^ 0x7F7F7F;
                    s0 = (d0 | n) - (s0 | n);
                    int d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | d0 & 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsSubBlend_HDA_o
    extends BlendContext {
        public PsSubBlend_HDA_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = (s0 >>> 24) * opa >>> 8;
                    int n = ((~d0 & (s0 ^= 0xFFFFFFFF)) << 1) + ((~d0 ^ s0) & 0xFEFEFE) & 0x1010100;
                    n = (n >>> 8) + 0x7F7F7F ^ 0x7F7F7F;
                    s0 = (d0 | n) - (s0 | n);
                    int d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | d0 & 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class PsSubBlend_o
    extends BlendContext {
        public PsSubBlend_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int a = (s0 >>> 24) * opa >>> 8;
                    int n = ((~d0 & (s0 ^= 0xFFFFFFFF)) << 1) + ((~d0 ^ s0) & 0xFEFEFE) & 0x1010100;
                    n = (n >>> 8) + 0x7F7F7F ^ 0x7F7F7F;
                    s0 = (d0 | n) - (s0 | n);
                    int d1 = d0 & 0xFF00FF;
                    int d2 = d0 & 0xFF00;
                    s0 = (((s0 & 0xFF00FF) - d1) * a >>> 8) + d1 & 0xFF00FF | (((s0 & 0xFF00) - d2) * a >>> 8) + d2 & 0xFF00;
                    o[dt + x] = s0 | 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class ScreenBlend
    extends BlendContext {
        ScreenBlend() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int tmp = ((d0 ^= 0xFFFFFFFF) & 0xFF) * ((s0 ^= 0xFFFFFFFF) & 0xFF) & 0xFF00;
                    tmp |= ((d0 & 0xFF00) >>> 8) * (s0 & 0xFF00) & 0xFF0000;
                    tmp |= ((d0 & 0xFF0000) >>> 16) * (s0 & 0xFF0000) & 0xFF000000;
                    o[dt + x] = ~(tmp >>>= 8) | 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class ScreenBlend_HDA
    extends BlendContext {
        ScreenBlend_HDA() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int tmp = ((d0 ^= 0xFFFFFFFF) & 0xFF) * ((s0 ^= 0xFFFFFFFF) & 0xFF) & 0xFF00;
                    tmp |= ((d0 & 0xFF00) >>> 8) * (s0 & 0xFF00) & 0xFF0000;
                    tmp |= ((d0 & 0xFF0000) >>> 16) * (s0 & 0xFF0000) & 0xFF000000;
                    o[dt + x] = ~(tmp >>>= 8) ^ d0 & 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class ScreenBlend_HDA_o
    extends BlendContext {
        public ScreenBlend_HDA_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    s0 = ~(((s0 & 0xFF00) * opa >>> 8 & 0xFF00) + ((s0 & 0xFF00FF) * opa >>> 8 & 0xFF00FF));
                    int tmp = ((d0 ^= 0xFFFFFFFF) & 0xFF) * (s0 & 0xFF) & 0xFF00;
                    tmp |= ((d0 & 0xFF00) >>> 8) * (s0 & 0xFF00) & 0xFF0000;
                    tmp |= ((d0 & 0xFF0000) >>> 16) * (s0 & 0xFF0000) & 0xFF000000;
                    o[dt + x] = ~(tmp >>>= 8) ^ d0 & 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class ScreenBlend_o
    extends BlendContext {
        public ScreenBlend_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    s0 = ~(((s0 & 0xFF00) * opa >>> 8 & 0xFF00) + ((s0 & 0xFF00FF) * opa >>> 8 & 0xFF00FF));
                    int tmp = ((d0 ^= 0xFFFFFFFF) & 0xFF) * (s0 & 0xFF) & 0xFF00;
                    tmp |= ((d0 & 0xFF00) >>> 8) * (s0 & 0xFF00) & 0xFF0000;
                    tmp |= ((d0 & 0xFF0000) >>> 16) * (s0 & 0xFF0000) & 0xFF000000;
                    o[dt + x] = ~(tmp >>>= 8) | 0xFF000000;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class SubBlend
    extends BlendContext {
        SubBlend() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int tmp = (s0 & d0) + ((s0 ^ d0) >>> 1 & 0x7F7F7F7F) & 0x80808080;
                    tmp = (tmp << 1) - (tmp >>> 7);
                    o[dt + x] = s0 + d0 - tmp & tmp;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class SubBlend_HDA
    extends BlendContext {
        SubBlend_HDA() {
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    int tmp = ((s0 |= 0xFF000000) & d0) + ((s0 ^ d0) >>> 1 & 0x7F7F7F7F) & 0x80808080;
                    tmp = (tmp << 1) - (tmp >>> 7);
                    o[dt + x] = s0 + d0 - tmp & tmp;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class SubBlend_HDA_o
    extends BlendContext {
        public SubBlend_HDA_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    s0 ^= 0xFFFFFFFF;
                    s0 = 0xFF000000 | ~(((s0 & 0xFF00) * opa >>> 8 & 0xFF00) + ((s0 & 0xFF00FF) * opa >>> 8 & 0xFF00FF));
                    int tmp = (s0 & d0) + ((s0 ^ d0) >>> 1 & 0x7F7F7F7F) & 0x80808080;
                    tmp = (tmp << 1) - (tmp >>> 7);
                    o[dt + x] = s0 + d0 - tmp & tmp;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }

    static class SubBlend_o
    extends BlendContext {
        public SubBlend_o(int opa) {
            super(opa);
        }

        @Override
        protected void blt(int[] s, int[] d, int[] o, int srcStride, int dstStride, int sw, int sh, int st, int dt, int opa) {
            int y = 0;
            while (y < sh) {
                int x = 0;
                while (x < sw) {
                    int s0 = s[st + x];
                    int d0 = d[dt + x];
                    s0 ^= 0xFFFFFFFF;
                    s0 = ~(((s0 & 0xFF00) * opa >>> 8 & 0xFF00) + ((s0 & 0xFF00FF) * opa >>> 8 & 0xFF00FF));
                    int tmp = (s0 & d0) + ((s0 ^ d0) >>> 1 & 0x7F7F7F7F) & 0x80808080;
                    tmp = (tmp << 1) - (tmp >>> 7);
                    o[dt + x] = s0 + d0 - tmp & tmp;
                    ++x;
                }
                st += srcStride;
                dt += dstStride;
                ++y;
            }
        }
    }
}

