/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2env;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import jp.kirikiri.tvp2.visual.Point;
import jp.kirikiri.tvp2.visual.Rect;
import jp.kirikiri.tvp2env.CustomOperationComposite;
import jp.kirikiri.tvp2env.NativeImageBuffer;
import jp.kirikiri.tvp2env.WindowForm;

public class DrawTarget {
    private Graphics mGraphcs;
    private WindowForm mWindow;
    private CustomOperationComposite mOpaqueComposite = new CustomOperationComposite(1, 255, false);

    public void setGraphics(Graphics g, WindowForm w) {
        this.mGraphcs = g;
        this.mWindow = w;
    }

    public void drawImage(int x, int y, NativeImageBuffer src, Rect refrect, int type, int opacity) {
        try {
            Graphics2D g = (Graphics2D)this.mGraphcs;
            if (g != null && src.getImage() != null) {
                if (type == 1) {
                    if (opacity == 255) {
                        g.setComposite(this.mOpaqueComposite);
                    } else {
                        g.setComposite(new CustomOperationComposite(1, opacity, false));
                    }
                } else if (opacity == 255) {
                    g.setComposite(AlphaComposite.SrcOver);
                } else {
                    g.setComposite(AlphaComposite.getInstance(3, (float)opacity / 255.0f));
                }
                g.drawImage(src.getImage(), x, y, x + refrect.width(), y + refrect.height(), refrect.left, refrect.top, refrect.right, refrect.bottom, null);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void show() {
        if (this.mWindow != null && this.mWindow.isVisible()) {
            Toolkit.getDefaultToolkit().sync();
            this.mWindow.repaintPanel();
        }
    }

    public void drawLines(Point[] points, int color) {
        Graphics g = this.mGraphcs;
        int count = points.length;
        int[] xPoints = new int[count];
        int[] yPoints = new int[count];
        int i = 0;
        while (i < count) {
            xPoints[i] = points[i].x;
            yPoints[i] = points[i].y;
            ++i;
        }
        g.setColor(new Color(color, false));
        g.drawPolyline(xPoints, yPoints, count);
    }
}

