/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2env;

import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import jp.kirikiri.tjs2.BinaryStream;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.utils.DebugClass;
import jp.kirikiri.tvp2.visual.Size;

public class Font {
    private static final long serialVersionUID = 4868231464013156104L;
    public static final int TF_ITALIC = 1;
    public static final int TF_BOLD = 2;
    public static final int TF_UNDERLINE = 4;
    public static final int TF_STRIKEOUT = 8;
    public static final int fsfFixedPitch = 1;
    public static final int fsfSameCharSet = 2;
    public static final int fsfNoVertical = 4;
    public static final int fsfTrueTypeOnly = 8;
    public static final int fsfUseFontFace = 256;
    private static Font DefaultFont;
    private static BufferedImage mTarget;
    private java.awt.Font mFont;
    private int mAngle;
    private static final String[] defaultFontNames;

    static {
        defaultFontNames = new String[]{"\uff2d\uff33 \u30b4\u30b7\u30c3\u30af", "IPA\u30b4\u30b7\u30c3\u30af", "VL \u30b4\u30b7\u30c3\u30af", "\u3055\u3056\u306a\u307f\u30b4\u30b7\u30c3\u30af", "\u30d2\u30e9\u30ae\u30ce\u89d2\u30b4", "\u30d2\u30e9\u30ae\u30ce\u4e38\u30b4", "\uff2d\uff33 \uff30\u30b4\u30b7\u30c3\u30af", "\u30e1\u30a4\u30ea\u30aa", "IPA P\u30b4\u30b7\u30c3\u30af", "VL P\u30b4\u30b7\u30c3\u30af", "\uff2d\uff33 \u660e\u671d", "\u3055\u3056\u306a\u307f\u660e\u671d", "IPA\u660e\u671d", "IPA P\u660e\u671d"};
    }

    public Font(Map<? extends AttributedCharacterIterator.Attribute, ?> attributes) {
        this.mFont = new java.awt.Font(attributes);
    }

    public Font(String name, int style, int size) {
        this.mFont = new java.awt.Font(name, style, size);
    }

    public Font(java.awt.Font ref) {
        this.mFont = ref;
    }

    public Font(Font org) {
        this.mFont = new java.awt.Font(org.getFont().getAttributes());
    }

    public Font(BinaryStream stream, Font ref, String facename) throws TJSException {
        try {
            java.awt.Font font = java.awt.Font.createFont(0, stream.getInputStream());
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            ge.registerFont(font);
            java.awt.Font reffont = ref.mFont;
            this.mFont = font.deriveFont(reffont.getStyle(), reffont.getSize());
        }
        catch (FontFormatException e) {
            throw new TJSException("Font file load error.");
        }
        catch (IOException e) {
            throw new TJSException("Font file load error.");
        }
    }

    public static void constructDefaultFont() {
        if (DefaultFont != null) {
            return;
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fonts = ge.getAvailableFontFamilyNames(Locale.JAPAN);
        int count = fonts.length;
        String fontName = null;
        int defCount = defaultFontNames.length;
        int f = 0;
        while (f < defCount) {
            int i = 0;
            while (i < count) {
                if (defaultFontNames[f].equals(fonts[i])) {
                    fontName = defaultFontNames[f];
                    break;
                }
                ++i;
            }
            if (fontName != null) break;
            ++f;
        }
        if (fontName == null) {
            fontName = "Monospaced";
            java.awt.Font tmp = new java.awt.Font(fontName, 0, 12);
            if ((fontName = tmp.getFontName(Locale.JAPAN)) == null) {
                fontName = "Monospaced";
            }
        }
        DebugClass.addLog("(info) Default Font Name : " + fontName);
        DefaultFont = new Font(fontName, 0, 12);
    }

    public static Font getDefaultFont() {
        if (DefaultFont == null) {
            Font.constructDefaultFont();
        }
        return DefaultFont;
    }

    public java.awt.Font getFont() {
        return this.mFont;
    }

    public void setFont(Font font) {
        this.mFont = new java.awt.Font(font.getFont().getAttributes());
        this.mAngle = font.mAngle;
    }

    public String getFaceName() {
        return this.mFont.getFontName();
    }

    public void setFaceName(String name) {
        Map<TextAttribute, ?> attr = this.mFont.getAttributes();
        java.awt.Font old = this.mFont;
        attr.put(TextAttribute.FAMILY, name);
        this.mFont = java.awt.Font.getFont(attr);
        if (this.mFont == null || !this.mFont.getFontName().equals(name)) {
            this.mFont = old;
        }
    }

    public int getHeight() {
        return this.mFont.getSize();
    }

    public void setHeight(int height) {
        Map<TextAttribute, ?> attr = this.mFont.getAttributes();
        attr.put(TextAttribute.SIZE, Float.valueOf(height));
        this.mFont = java.awt.Font.getFont(attr);
    }

    public int getAngle() {
        return this.mAngle;
    }

    public void setAngle(int angle) {
        this.mAngle = angle;
    }

    public boolean getBold() {
        return this.mFont.isBold();
    }

    public void setBold(boolean b) {
        Map<TextAttribute, ?> attr = this.mFont.getAttributes();
        if (b) {
            attr.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        } else {
            attr.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR);
        }
        this.mFont = java.awt.Font.getFont(attr);
    }

    public boolean getItalic() {
        return this.mFont.isItalic();
    }

    public void setItalic(boolean b) {
        Map<TextAttribute, ?> attr = this.mFont.getAttributes();
        if (b) {
            attr.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        } else {
            attr.put(TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR);
        }
        this.mFont = java.awt.Font.getFont(attr);
    }

    public boolean getStrikeout() {
        Boolean val;
        boolean state;
        Object attr = this.mFont.getAttributes().get(TextAttribute.STRIKETHROUGH);
        return attr instanceof Boolean && (state = (val = (Boolean)attr).booleanValue()) == TextAttribute.STRIKETHROUGH_ON;
    }

    public void setStrikeout(boolean b) {
        Map<TextAttribute, ?> attr = this.mFont.getAttributes();
        if (b) {
            attr.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        } else {
            attr.remove(TextAttribute.STRIKETHROUGH);
        }
        this.mFont = java.awt.Font.getFont(attr);
    }

    public boolean getUnderline() {
        Number val;
        int state;
        Object attr = this.mFont.getAttributes().get(TextAttribute.INPUT_METHOD_UNDERLINE);
        return attr instanceof Number && (state = (val = (Number)attr).intValue()) == TextAttribute.UNDERLINE_ON;
    }

    public void setUnderline(boolean b) {
        Map<TextAttribute, ?> attr = this.mFont.getAttributes();
        if (b) {
            attr.put(TextAttribute.INPUT_METHOD_UNDERLINE, TextAttribute.UNDERLINE_ON);
        } else {
            attr.remove(TextAttribute.INPUT_METHOD_UNDERLINE);
        }
        this.mFont = java.awt.Font.getFont(attr);
    }

    public int getTextWidth(String text) {
        if (mTarget == null) {
            mTarget = new BufferedImage(32, 32, 6);
        }
        Graphics2D g = mTarget.createGraphics();
        FontRenderContext frc = g.getFontRenderContext();
        Rectangle2D r = this.mFont.getStringBounds(text, frc);
        g.dispose();
        return (int)r.getWidth();
    }

    public int getTextHeight(String text) {
        if (mTarget == null) {
            mTarget = new BufferedImage(32, 32, 6);
        }
        Graphics2D g = mTarget.createGraphics();
        FontRenderContext frc = g.getFontRenderContext();
        Rectangle2D r = this.mFont.getStringBounds(text, frc);
        g.dispose();
        return (int)r.getHeight();
    }

    public Size getTextSize(String text) {
        if (mTarget == null) {
            mTarget = new BufferedImage(32, 32, 6);
        }
        Graphics2D g = mTarget.createGraphics();
        FontRenderContext frc = g.getFontRenderContext();
        Rectangle2D r = this.mFont.getStringBounds(text, frc);
        g.dispose();
        return new Size((int)r.getWidth(), (int)r.getHeight());
    }

    public float getAscent() {
        if (mTarget == null) {
            mTarget = new BufferedImage(32, 32, 6);
        }
        Graphics2D g = mTarget.createGraphics();
        FontRenderContext frc = g.getFontRenderContext();
        LineMetrics m = this.mFont.getLineMetrics("M", frc);
        g.dispose();
        return m.getAscent();
    }

    public static void getFontList(int flags, ArrayList<String> list) {
        list.clear();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        java.awt.Font[] fonts = ge.getAllFonts();
        int count = fonts.length;
        int i = 0;
        while (i < count) {
            list.add(fonts[i].getFontName());
            ++i;
        }
    }
}

