/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2env;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import javax.swing.JPanel;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2env.NativeImageBuffer;
import jp.kirikiri.tvp2env.PanelDrawListener;
import jp.kirikiri.tvp2env.VRAMImageBuffer;
import jp.kirikiri.tvp2env.WindowForm;

public class ImagePanel
extends JPanel {
    private static final long serialVersionUID = 7393364494465761702L;
    private VRAMImageBuffer mImageBuffer = new VRAMImageBuffer(this);
    private PanelDrawListener mDraw;
    private NativeImageBuffer mImage = new NativeImageBuffer(32, 32);
    private WindowForm mWindow;

    public void setOwner(WindowForm window) {
        this.mWindow = window;
    }

    @Override
    public void setSize(int w, int h) {
        super.setSize(w, h);
        if (w != 0 && h != 0) {
            try {
                Image img;
                this.mImage.recreate(w, h, true);
                if (this.mDraw != null && (img = this.mImage.getImage()) != null) {
                    this.mDraw.onDraw(img.getGraphics());
                }
            }
            catch (TJSException tJSException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void paintComponent(Graphics graphic) {
        this.mImageBuffer.initializeVolatileImage();
        try {
            do {
                int y;
                int x;
                int h;
                int w;
                this.mImageBuffer.validateVolatileImage();
                Graphics buffer = this.mImageBuffer.getGraphics();
                buffer.drawImage(this.mImage.getImage(), 0, 0, null);
                buffer.dispose();
                if (this.mWindow == null) continue;
                Graphics2D g = (Graphics2D)graphic;
                int ow = this.mWindow.getInnerWidthSave();
                int oh = this.mWindow.getInnerHeightSave();
                int dw = this.mWindow.getInnerWidth();
                int dh = this.mWindow.getInnerHeight();
                if (ow == dw || oh == dh) {
                    graphic.drawImage(this.mImageBuffer.getImage(), 0, 0, this);
                    continue;
                }
                int rw = 1000 * dw / ow;
                int rh = 1000 * dh / oh;
                if (rw < rh) {
                    w = dw;
                    h = oh * dw / ow;
                    x = 0;
                    y = (dh - h) / 2;
                } else {
                    w = ow * dh / oh;
                    h = dh;
                    x = (dw - w) / 2;
                    y = 0;
                }
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g.drawImage(this.mImageBuffer.getImage(), x, y, x + w, y + h, 0, 0, ow, oh, this);
            } while (this.mImageBuffer.isContentsLost());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void drawImage(Graphics graphic, int ox, int oy) {
        try {
            if (this.mWindow != null) {
                Graphics2D g = (Graphics2D)graphic;
                int ow = this.mWindow.getInnerWidthSave();
                int oh = this.mWindow.getInnerHeightSave();
                int dw = this.mWindow.getInnerWidth();
                int dh = this.mWindow.getInnerHeight();
                if (ow == dw || oh == dh) {
                    graphic.drawImage(this.mImage.getImage(), ox, oy, this);
                } else {
                    int y;
                    int x;
                    int h;
                    int w;
                    int rw = 1000 * dw / ow;
                    int rh = 1000 * dh / oh;
                    if (rw < rh) {
                        w = dw;
                        h = oh * dw / ow;
                        x = ox;
                        y = (dh - h) / 2 + oy;
                    } else {
                        w = ow * dh / oh;
                        h = dh;
                        x = (dw - w) / 2 + ox;
                        y = oy;
                    }
                    g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    g.drawImage(this.mImage.getImage(), x, y, x + w, y + h, 0, 0, ow, oh, this);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void setDrawListener(PanelDrawListener draw) {
        this.mDraw = draw;
    }
}

