/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2env;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.VariantException;
import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.base.ScriptsClass;
import jp.kirikiri.tvp2.base.SystemInitializer;
import jp.kirikiri.tvp2.base.TVPSystem;
import jp.kirikiri.tvp2.utils.DebugClass;
import jp.kirikiri.tvp2env.ApplicationSystem;
import jp.kirikiri.tvp2env.EventHandleThread;

class Main {
    private static final String PROP_FILE_NAME = "engine.properties";

    Main() {
    }

    public static void main(String[] args) {
        Main.processArg(args);
        Main.loadProperties(PROP_FILE_NAME);
        try {
            ApplicationSystem app = new ApplicationSystem();
            TVP.initialize();
            ScriptsClass.initScriptEnging();
            DebugClass.addImportantLog("Program started on " + TVPSystem.getOSName());
            DebugClass.addImportantLog("JVM : " + TVPSystem.getJVMName());
            DebugClass.addImportantLog("JRE : " + TVPSystem.getJREName());
            SystemInitializer.systemInitialize();
            ScriptsClass.initializeStartupScript();
            EventHandleThread t = new EventHandleThread();
            t.start();
        }
        catch (VariantException e) {
            TVP.DebugLog.onError();
            e.printStackTrace();
            ApplicationSystem.messageBox(e.getMessage(), "Error", 0);
        }
        catch (TJSException e) {
            TVP.DebugLog.onError();
            e.printStackTrace();
            ApplicationSystem.messageBox(e.getMessage(), "Error", 0);
        }
        catch (Exception e) {
            TVP.DebugLog.onError();
            e.printStackTrace();
            ApplicationSystem.messageBox(e.getMessage(), "Error", 0);
        }
    }

    private static void processArg(String[] args) {
        TVP.Properties = new Properties();
        int count = args.length;
        int i = 0;
        while (i < count) {
            String arg = args[i];
            if (arg.charAt(0) == '-') {
                String name = arg.substring(1);
                int index = name.indexOf(61);
                if (index != -1 && name.length() > index + 1) {
                    String value = name.substring(index + 1);
                    name = name.substring(0, index);
                    TVP.Properties.setProperty(name, value);
                } else {
                    TVP.Properties.setProperty(name, "no value");
                }
            }
            ++i;
        }
    }

    private static void loadProperties(String filename) {
        if (TVP.Properties == null) {
            TVP.Properties = new Properties();
        }
        try {
            Class<TVP> c = TVP.class;
            InputStream is = c.getResourceAsStream(filename);
            if (is == null) {
                is = new FileInputStream(filename);
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            TVP.Properties.load(br);
            br.close();
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void dumpProperties() {
        for (String string : TVP.Properties.keySet()) {
            String val = TVP.Properties.getProperty(string);
            System.out.println(String.valueOf(string) + "=" + val);
        }
    }
}

