/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2env;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.net.URL;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.TVP;

public class MainForm {
    private long mLastCompactedTick;
    private long mLastContinuousTick;
    private long mLastCloseClickedTick;
    private long mLastShowModalWindowSentTick;
    private long mLastRehashedTick;
    private long mMixedIdleTick;
    private boolean mContinuousEventCalling = false;
    private boolean mAutoShowConsoleOnError = false;
    private boolean mApplicationStayOnTop = false;
    private boolean mApplicationActivating = true;
    private boolean mApplicationNotMinimizing = true;
    private String mClassPath;
    private String mExeName;

    public MainForm() {
        long tick;
        this.mLastCompactedTick = tick = TVP.getTickCount();
        this.mLastContinuousTick = tick;
        this.mLastCloseClickedTick = tick;
        this.mLastShowModalWindowSentTick = tick;
        this.mLastRehashedTick = tick;
        this.mMixedIdleTick = tick;
    }

    public void invokeEvents() {
        this.callDeliverAllEventsOnIdle();
    }

    public void notifyEventDelivered() {
        this.mLastCloseClickedTick = 0L;
    }

    public void callDeliverAllEventsOnIdle() {
    }

    private void retrieveClassPath() {
        try {
            Class<?> c = this.getClass();
            URL u = c.getResource(String.valueOf(c.getSimpleName()) + ".class");
            this.mClassPath = u.toString();
            int delimiPos = this.mClassPath.indexOf(33);
            String name = delimiPos >= 0 ? this.mClassPath.substring(0, delimiPos) : this.mClassPath;
            if (name.indexOf("jar:file:/") >= 0) {
                name = name.substring("jar:file:/".length());
            }
            this.mExeName = TVP.StorageMediaManager.normalizeStorageName(name, null);
        }
        catch (NullPointerException e) {
            this.mExeName = this.mClassPath = System.getProperty("user.dir");
        }
        catch (TJSException e) {
            this.mExeName = this.mClassPath = System.getProperty("user.dir");
        }
    }

    public String getClassPath() {
        if (this.mClassPath == null) {
            this.retrieveClassPath();
        }
        return this.mClassPath;
    }

    public String getExeName() {
        if (this.mExeName == null) {
            this.retrieveClassPath();
        }
        return this.mExeName;
    }

    public void beginContinuousEvent() {
        if (!this.mContinuousEventCalling) {
            this.mContinuousEventCalling = true;
            this.invokeEvents();
        }
    }

    public void endContinuousEvent() {
        if (this.mContinuousEventCalling) {
            this.mContinuousEventCalling = false;
        }
    }

    public boolean applicationIdle() {
        this.deliverEvents();
        boolean cont = this.mContinuousEventCalling;
        this.mMixedIdleTick += TVP.getTickCount();
        return cont;
    }

    private void deliverEvents() {
        if (this.mContinuousEventCalling) {
            TVP.EventManager.setProcessContinuousHandlerEventFlag(true);
        }
        TVP.EventManager.deliverAllEvents();
    }

    public int getScreenWidth() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice device = graphicsEnvironment.getDefaultScreenDevice();
        return device.getDisplayMode().getWidth();
    }

    public int getScreenHeight() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice device = graphicsEnvironment.getDefaultScreenDevice();
        return device.getDisplayMode().getHeight();
    }

    public int getDesktopHeight() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle rect = graphicsEnvironment.getMaximumWindowBounds();
        return rect.height;
    }

    public int getDesktopLeft() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle rect = graphicsEnvironment.getMaximumWindowBounds();
        return rect.x;
    }

    public int getDesktopTop() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle rect = graphicsEnvironment.getMaximumWindowBounds();
        return rect.y;
    }

    public int getDesktopWidth() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle rect = graphicsEnvironment.getMaximumWindowBounds();
        return rect.width;
    }
}

