/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2env;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.MultipleGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.msg.Message;
import jp.kirikiri.tvp2.visual.MenuItemNI;
import jp.kirikiri.tvp2env.VirtualKey;
import jp.kirikiri.tvp2env.WindowForm;

public class MenuItem
implements ActionListener {
    JMenuBar mOwnerBar;
    JMenuItem mItem;
    JSeparator mSeparator;
    private MenuItemNI mActionOwner;
    private MenuItem mParent;
    private ArrayList<MenuItem> mChildren = new ArrayList();
    private String mCaption;
    private boolean mChecked;
    private boolean mEnabled = true;
    private int mGroupIndex;
    private boolean mRadioItem;
    private String mShortcut;
    private boolean mVisible = true;
    private char mMnemonic;
    private static final long serialVersionUID = 7339008711139249274L;
    private static Icon ICON_CHECK;
    private static Icon ICON_CIRCLE;
    private static Icon ICON_TRANS;

    private static void crateItemImage() {
        if (ICON_TRANS != null) {
            return;
        }
        BufferedImage image = new BufferedImage(16, 16, 6);
        ICON_TRANS = new ImageIcon(image);
        image = new BufferedImage(16, 16, 6);
        Graphics2D g = image.createGraphics();
        float[] dist = new float[]{0.0f, 0.6f, 1.0f};
        Color[] colors = new Color[]{Color.WHITE, Color.BLACK, Color.BLACK};
        RadialGradientPaint gradient = new RadialGradientPaint(8.0f, 6.0f, 9.0f, dist, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setPaint(gradient);
        g.fillOval(4, 4, 8, 8);
        g.dispose();
        ICON_CIRCLE = new ImageIcon(image);
        image = new BufferedImage(16, 16, 6);
        g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.BLACK);
        int[] xPoints = new int[]{4, 7, 12, 7, 4};
        int[] yPoints = new int[]{6, 12, 2, 9, 6};
        g.fillPolygon(xPoints, yPoints, 5);
        g.dispose();
        ICON_CHECK = new ImageIcon(image);
    }

    public MenuItem(JMenuBar bar) {
        this();
        this.mOwnerBar = bar;
    }

    public MenuItem(MenuItemNI action) {
        this();
        this.mActionOwner = action;
    }

    private MenuItem() {
        MenuItem.crateItemImage();
    }

    private void createMenuItemForChildren() {
        this.createMenuItem();
        JMenu menu = null;
        if (this.mItem != null && this.mItem instanceof JMenu) {
            menu = (JMenu)this.mItem;
        }
        if (menu != null) {
            int count = this.mChildren.size();
            int i = 0;
            while (i < count) {
                MenuItem item = this.mChildren.get(i);
                item.createMenuItemForChildren();
                if (item.mSeparator != null) {
                    menu.add(item.mSeparator);
                } else if (item.mItem != null) {
                    menu.add(item.mItem);
                }
                ++i;
            }
        }
    }

    private void createMenuItem() {
        int vk;
        if (this.mItem != null || this.mSeparator != null) {
            return;
        }
        Icon icon = this.mChecked ? (this.mRadioItem ? ICON_CIRCLE : ICON_CHECK) : ICON_TRANS;
        if (this.mParent != null && this.mParent.mOwnerBar != null) {
            icon = null;
        }
        if (this.mChildren.size() > 0) {
            this.mItem = new JMenu(this.mCaption);
            if (icon != null) {
                this.mItem.setIcon(icon);
            }
        } else {
            if ("-".equals(this.mCaption)) {
                this.mSeparator = new JSeparator();
                return;
            }
            this.mItem = icon != null ? new JMenuItem(this.mCaption, icon) : new JMenuItem(this.mCaption);
        }
        this.mItem.addActionListener(this);
        if (!this.mEnabled) {
            this.mItem.setEnabled(false);
        }
        if (!this.mVisible) {
            this.mItem.setVisible(false);
        }
        if (this.mShortcut != null) {
            this.setShortcut(this.mItem, this.mShortcut.toLowerCase());
        }
        if (this.mMnemonic != '\u0000' && (vk = VirtualKey.getKeyCode(this.mMnemonic)) >= 0) {
            this.mItem.setMnemonic(vk);
        }
    }

    private void captionToMnemonic() {
        this.mShortcut = this.captionToShortcut();
        int count = this.mCaption.length();
        int index = this.mCaption.indexOf("&");
        if (index >= 0 && index + 1 <= count) {
            int vk;
            char c = this.mCaption.charAt(index + 1);
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 97 - 65);
            }
            if ((vk = VirtualKey.getKeyCode(c)) >= 0) {
                this.mMnemonic = c;
                StringBuilder builder = new StringBuilder(count);
                builder.append(this.mCaption.substring(0, index));
                builder.append(this.mCaption.substring(index + 1));
                this.mCaption = builder.toString();
            }
        }
    }

    private String captionToShortcut() {
        int count = this.mCaption.length();
        int index = this.mCaption.indexOf(9);
        if (index >= 0 && index + 1 < count) {
            String ret = this.mCaption.substring(index + 1);
            this.mCaption = this.mCaption.substring(0, index);
            return ret;
        }
        return null;
    }

    private void setShortcut(JMenuItem item, String shortcut) {
        if (item == null) {
            return;
        }
        String[] keys = shortcut.split("\\+");
        int count = keys.length;
        int mode = 0;
        int keyCode = -1;
        int i = 0;
        while (i < count) {
            int code = VirtualKey.getKeyCode(keys[i]);
            if (code >= 0) {
                switch (code) {
                    case 16: {
                        mode |= 0x40;
                        break;
                    }
                    case 17: {
                        mode |= 0x80;
                        break;
                    }
                    case 18: {
                        mode |= 0x200;
                        break;
                    }
                    case 65406: {
                        mode |= 0x2000;
                        break;
                    }
                    case 157: {
                        mode |= 0x100;
                        break;
                    }
                    default: {
                        keyCode = code;
                    }
                }
            }
            ++i;
        }
        if (keyCode >= 0) {
            item.setAccelerator(KeyStroke.getKeyStroke(keyCode, mode));
        } else {
            item.setAccelerator(null);
        }
    }

    public MenuItem getParent() {
        return this.mParent;
    }

    private void freeNativeAll() {
        int count = this.mChildren.size();
        int i = 0;
        while (i < count) {
            this.mChildren.get(i).freeNativeAll();
            ++i;
        }
        if (this.mParent != null && (this.mParent.mItem != null || this.mParent.mOwnerBar != null)) {
            if (this.mParent.mItem != null && this.mParent.mItem instanceof JMenu) {
                JMenu owner = (JMenu)this.mParent.mItem;
                if (this.mItem != null) {
                    owner.remove(this.mItem);
                }
                if (this.mSeparator != null) {
                    owner.remove(this.mSeparator);
                }
            } else if (this.mParent.mOwnerBar != null) {
                JMenuBar owner = this.mParent.mOwnerBar;
                if (this.mItem != null) {
                    owner.remove(this.mItem);
                }
                if (this.mSeparator != null) {
                    owner.remove(this.mSeparator);
                }
            }
        }
        this.mItem = null;
        this.mSeparator = null;
    }

    private void detach(MenuItem item) {
        int index = this.indexOf(item);
        if (index >= 0) {
            this.mChildren.remove(index);
        }
        item.freeNativeAll();
        item.mParent = null;
    }

    private void addMenu(MenuItem item, int index) throws TJSException {
        if ((this.mItem != null || this.mOwnerBar != null) && item.mItem == null) {
            item.createMenuItemForChildren();
        }
        if (this.mItem != null && !(this.mItem instanceof JMenu)) {
            JComponent owner;
            if (this.mParent.mItem != null && this.mParent.mItem instanceof JMenu) {
                owner = (JMenu)this.mParent.mItem;
                if (this.mItem != null) {
                    ((JMenu)owner).remove(this.mItem);
                }
                if (this.mSeparator != null) {
                    ((JMenu)owner).remove(this.mSeparator);
                }
                this.mItem = null;
                this.mSeparator = null;
                this.createMenuItem();
                if (this.mItem != null) {
                    ((JMenu)owner).add((Component)this.mItem, this.mParent.indexOf(this));
                }
            } else if (this.mParent.mOwnerBar != null) {
                owner = this.mParent.mOwnerBar;
                if (this.mItem != null) {
                    owner.remove(this.mItem);
                }
                if (this.mSeparator != null) {
                    owner.remove(this.mSeparator);
                }
                this.mItem = null;
                this.mSeparator = null;
                this.createMenuItem();
                if (this.mItem != null) {
                    owner.add((Component)this.mItem, this.mParent.indexOf(this));
                }
            } else {
                Message.throwExceptionMessage("\u5185\u90e8\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f: at %1 line %2");
            }
            if (this.mItem instanceof JMenu) {
                JMenu menu = (JMenu)this.mItem;
                if (item.mItem != null) {
                    if (index >= 0) {
                        menu.add((Component)item.mItem, index);
                    } else {
                        menu.add(item.mItem);
                    }
                } else if (item.mSeparator != null) {
                    if (index >= 0) {
                        menu.add((Component)item.mSeparator, index);
                    } else {
                        menu.add(item.mSeparator);
                    }
                }
            } else {
                Message.throwExceptionMessage("\u5185\u90e8\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f: at %1 line %2");
            }
        } else if (this.mItem != null && this.mItem instanceof JMenu) {
            JMenu menu = (JMenu)this.mItem;
            if (item.mItem != null) {
                if (index >= 0) {
                    menu.add((Component)item.mItem, index);
                } else {
                    menu.add(item.mItem);
                }
            } else if (item.mSeparator != null) {
                if (index >= 0) {
                    menu.add((Component)item.mSeparator, index);
                } else {
                    menu.add(item.mSeparator);
                }
            }
        } else if (this.mOwnerBar != null) {
            if (item.mItem != null) {
                if (index >= 0) {
                    this.mOwnerBar.add((Component)item.mItem, index);
                } else {
                    this.mOwnerBar.add(item.mItem);
                }
            } else if (item.mSeparator != null) {
                if (index >= 0) {
                    this.mOwnerBar.add((Component)item.mSeparator, index);
                } else {
                    this.mOwnerBar.add(item.mSeparator);
                }
            }
        }
    }

    public void add(MenuItem item) throws TJSException {
        if (item.mParent != null) {
            item.mParent.detach(item);
        }
        this.mChildren.add(item);
        item.mParent = this;
        this.addMenu(item, -1);
    }

    public int indexOf(MenuItem item) {
        int count = this.mChildren.size();
        int i = 0;
        while (i < count) {
            if (item == this.mChildren.get(i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void insert(int index, MenuItem item) throws TJSException {
        if (item.mParent != null) {
            item.mParent.detach(this);
        }
        this.mChildren.add(index, item);
        item.mParent = this;
        this.addMenu(item, index);
    }

    public void delete(int index) {
        if (index >= 0 && index < this.mChildren.size()) {
            MenuItem item = this.mChildren.get(index);
            this.mChildren.remove(index);
            item.freeNativeAll();
            item.mParent = null;
        }
    }

    public void setCaption(String caption) {
        this.mCaption = caption;
        this.captionToMnemonic();
        if (this.mItem != null) {
            this.mItem.setText(this.mCaption);
        }
    }

    private void updateRadioCheck(int group) {
        if (this.mParent == null) {
            return;
        }
        int count = this.mParent.mChildren.size();
        int i = 0;
        while (i < count) {
            MenuItem item = this.mParent.mChildren.get(i);
            if (item.mRadioItem && item.mGroupIndex == group && item.mItem != null) {
                item.setChecked(false);
            }
            ++i;
        }
    }

    public void setChecked(boolean b) {
        if (this.mItem != null && this.mChecked != b && (this.mParent == null || this.mParent.mOwnerBar == null)) {
            if (b) {
                if (this.mRadioItem) {
                    this.updateRadioCheck(this.mGroupIndex);
                    this.mItem.setIcon(ICON_CIRCLE);
                } else {
                    this.mItem.setIcon(ICON_CHECK);
                }
            } else {
                this.mItem.setIcon(ICON_TRANS);
            }
        }
        this.mChecked = b;
    }

    public boolean getChecked() {
        return this.mChecked;
    }

    public void setEnabled(boolean b) {
        if (this.mItem != null) {
            this.mItem.setEnabled(b);
        }
        this.mEnabled = b;
    }

    public boolean getEnabled() {
        return this.mEnabled;
    }

    public void setGroupIndex(int g) {
        if (this.mItem != null && this.mParent != null) {
            this.setChecked(false);
        }
        this.mGroupIndex = g;
    }

    public int getGroupIndex() {
        return this.mGroupIndex;
    }

    public void setRadioItem(boolean b) {
        this.mRadioItem = b;
        if (this.mItem != null && this.mChecked) {
            this.setChecked(this.mChecked);
        }
    }

    public boolean getRadioItem() {
        return this.mRadioItem;
    }

    public void setShortcut(String shortcut) {
        if (this.mItem != null) {
            this.setShortcut(this.mItem, shortcut.toLowerCase());
        }
        this.mShortcut = shortcut;
    }

    public String getShortcut() {
        return this.mShortcut;
    }

    public void setVisible(boolean b) {
        if (this.mItem != null) {
            this.mItem.setVisible(b);
        }
        this.mVisible = b;
    }

    public boolean getVisible() {
        return this.mVisible;
    }

    public void setMenuIndex(int newIndex) throws TJSException {
        this.detach(this);
        this.insert(newIndex, this);
    }

    public int getMenuIndex() {
        int ret;
        if (this.mParent != null && (ret = this.mParent.indexOf(this)) < 0) {
            return 0;
        }
        return 0;
    }

    public int popup(WindowForm form, int flags, int x, int y) {
        return 0;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.mActionOwner != null) {
            this.mActionOwner.menuItemClick();
        }
    }
}

