/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2env;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.visual.DivisibleData;
import jp.kirikiri.tvp2.visual.DivisibleTransHandler;
import jp.kirikiri.tvp2.visual.ScanLineProvider;
import jp.kirikiri.tvp2.visual.SimpleOptionProvider;

public class MosaicTransHandler
implements DivisibleTransHandler {
    private long mStartTick;
    private long mTime;
    private long mHalfTime;
    private long mCurTime;
    private int mMaxBlockSize;
    private int mCurBlockSize;
    private int mBlendRatio;
    private boolean mFirst;
    private BufferedImage mWorkImage;

    public MosaicTransHandler(long time, int width, int height, int maxblocksize) {
        this.mTime = time;
        this.mHalfTime = time / 2L;
        this.mMaxBlockSize = maxblocksize;
        this.mFirst = true;
        this.mWorkImage = new BufferedImage(width, height, 2);
    }

    @Override
    public int setOption(SimpleOptionProvider options) {
        return 0;
    }

    @Override
    public int startProcess(long tick) {
        if (this.mFirst) {
            this.mFirst = false;
            this.mStartTick = tick;
        }
        long t = this.mCurTime = tick - this.mStartTick;
        if (this.mCurTime > this.mTime) {
            this.mCurTime = this.mTime;
        }
        if (t >= this.mHalfTime) {
            t = this.mTime - t;
        }
        if (t < 0L) {
            t = 0L;
        }
        this.mCurBlockSize = (int)((long)(this.mMaxBlockSize - 2) * t / this.mHalfTime + 2L);
        this.mBlendRatio = (int)(this.mCurTime * 255L / this.mTime);
        if (this.mBlendRatio > 255) {
            this.mBlendRatio = 255;
        }
        return 1;
    }

    @Override
    public int endProcess() {
        if (this.mBlendRatio == 255) {
            return 2;
        }
        return 1;
    }

    @Override
    public int process(DivisibleData data) {
        BufferedImage dest = (BufferedImage)data.Dest.getScanLineForWrite().getImage();
        BufferedImage src1 = (BufferedImage)data.Src1.getScanLine().getImage();
        BufferedImage src2 = (BufferedImage)data.Src2.getScanLine().getImage();
        int bs = this.mCurBlockSize;
        int hb = bs / 2;
        int destLeft = data.DestLeft - hb;
        int src1Left = data.Src1Left;
        int src2Left = data.Src2Left;
        int h = data.Height;
        int w = data.Width;
        int destTop = data.DestTop - hb;
        int src1Top = data.Src1Top;
        int src2Top = data.Src2Top;
        float opa = (float)this.mBlendRatio / 255.0f;
        int bw = w / bs;
        int bh = h / bs;
        Graphics2D wg = (Graphics2D)this.mWorkImage.getGraphics();
        wg.setComposite(AlphaComposite.Src);
        wg.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        wg.drawImage(src1, 0, 0, bw, bh, src1Left, src1Top, src1Left + w, src1Top + h, null);
        Graphics2D g = (Graphics2D)dest.getGraphics();
        g.setComposite(AlphaComposite.Src);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g.drawImage(this.mWorkImage, destLeft, destTop, destLeft + w, destTop + h, 0, 0, bw, bh, null);
        g.drawImage(this.mWorkImage, destLeft + w, destTop, destLeft + w + hb, destTop + h, bw - 1, 0, bw, bh, null);
        g.drawImage(this.mWorkImage, destLeft, destTop + h, destLeft + w, destTop + h + hb, 0, bh - 1, bw, bh, null);
        g.drawImage(this.mWorkImage, destLeft + w, destTop + h, destLeft + w + hb, destTop + h + hb, bw - 1, bh - 1, bw, bh, null);
        wg.drawImage(src2, 0, 0, bw, bh, src2Left, src2Top, src2Left + w, src2Top + h, null);
        wg.dispose();
        AlphaComposite composite = AlphaComposite.getInstance(3, opa);
        g.setComposite(composite);
        g.drawImage(this.mWorkImage, destLeft, destTop, destLeft + w, destTop + h, 0, 0, bw, bh, null);
        g.drawImage(this.mWorkImage, destLeft + w, destTop, destLeft + w + hb, destTop + h, bw - 1, 0, bw, bh, null);
        g.drawImage(this.mWorkImage, destLeft, destTop + h, destLeft + w, destTop + h + hb, 0, bh - 1, bw, bh, null);
        g.drawImage(this.mWorkImage, destLeft + w, destTop + h, destLeft + w + hb, destTop + h + hb, bw - 1, bh - 1, bw, bh, null);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.dispose();
        return 0;
    }

    @Override
    public int makeFinalImage(ScanLineProvider dest, ScanLineProvider src1, ScanLineProvider src2) throws TJSException {
        dest.copyFrom(src2);
        return 0;
    }
}

