/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2env;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import jp.kirikiri.tjs2.BinaryStream;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.base.ByteBufferInputStream;
import jp.kirikiri.tvp2.base.Storage;
import jp.kirikiri.tvp2.msg.Message;
import jp.kirikiri.tvp2env.NativeImageLoader;
import jp.kirikiri.tvp2env.WindowForm;

public class MouseCursor {
    public static final int crDefault = 0;
    public static final int crNone = -1;
    public static final int crArrow = -2;
    public static final int crCross = -3;
    public static final int crIBeam = -4;
    public static final int crSize = -5;
    public static final int crSizeNESW = -6;
    public static final int crSizeNS = -7;
    public static final int crSizeNWSE = -8;
    public static final int crSizeWE = -9;
    public static final int crUpArrow = -10;
    public static final int crHourGlass = -11;
    public static final int crDrag = -12;
    public static final int crNoDrop = -13;
    public static final int crHSplit = -14;
    public static final int crVSplit = -15;
    public static final int crMultiDrag = -16;
    public static final int crSQLWait = -17;
    public static final int crNo = -18;
    public static final int crAppStart = -19;
    public static final int crHelp = -20;
    public static final int crHandPoint = -21;
    public static final int crSizeAll = -22;
    public static final int crHBeam = 1;
    private HashMap<String, Integer> mCursorTable = new HashMap();
    private int mCursorCount = 1;
    private ArrayList<Cursor> mCursors = new ArrayList();
    private Cursor mNullCursor;
    private HashMap<Integer, Cursor> mInternalCursor;

    public MouseCursor() {
        this.mCursors.add(null);
        this.mInternalCursor = new HashMap();
        BufferedImage image = new BufferedImage(32, 32, 6);
        this.mNullCursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(16, 16), "trans");
    }

    private Cursor getInternalCursor(int v) {
        switch (v) {
            case 0: {
                return Cursor.getDefaultCursor();
            }
            case -2: {
                return Cursor.getDefaultCursor();
            }
            case -3: {
                return Cursor.getPredefinedCursor(1);
            }
            case -4: {
                return Cursor.getPredefinedCursor(2);
            }
            case -11: {
                return Cursor.getPredefinedCursor(3);
            }
            case -10: {
                return Cursor.getPredefinedCursor(8);
            }
            case -21: {
                return Cursor.getPredefinedCursor(12);
            }
            case -5: {
                return Cursor.getPredefinedCursor(13);
            }
            case -1: {
                return this.mNullCursor;
            }
            case -36: {
                return Cursor.getPredefinedCursor(11);
            }
            case -35: {
                return Cursor.getPredefinedCursor(10);
            }
            case -34: {
                return Cursor.getPredefinedCursor(9);
            }
            case -33: {
                return Cursor.getPredefinedCursor(7);
            }
            case -32: {
                return Cursor.getPredefinedCursor(6);
            }
            case -31: {
                return Cursor.getPredefinedCursor(5);
            }
            case -30: {
                return Cursor.getPredefinedCursor(4);
            }
        }
        return null;
    }

    public Cursor getCursor(int v) {
        Cursor c = this.mInternalCursor.get(v);
        if (c != null) {
            return c;
        }
        return this.getInternalCursor(v);
    }

    public int getCursor(WindowForm win, String name) throws TJSException {
        String place = Storage.searchPlacedPath(name);
        Integer in_hash = this.mCursorTable.get(place);
        if (in_hash != null) {
            return in_hash;
        }
        BinaryStream stream = Storage.createStream(place, 0);
        long size = stream.getSize();
        ByteBuffer buff = ByteBuffer.allocateDirect((int)size);
        stream.read(buff);
        stream.close();
        buff.flip();
        ByteBufferInputStream input = new ByteBufferInputStream(buff);
        BufferedImage img = NativeImageLoader.loadImage(input);
        if (img == null) {
            Message.throwExceptionMessage("\u30de\u30a6\u30b9\u30ab\u30fc\u30bd\u30eb %1 \u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", place);
        }
        Cursor c = win.getToolkit().createCustomCursor(img, new Point(img.getWidth() / 2, img.getHeight() / 2), name);
        ++this.mCursorCount;
        this.mCursors.add(this.mCursorCount, c);
        this.mCursorTable.put(place, this.mCursorCount);
        this.mInternalCursor.put(this.mCursorCount, c);
        return this.mCursorCount;
    }
}

