/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2env;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import javax.imageio.ImageIO;
import jp.kirikiri.tjs2.BinaryStream;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.base.Storage;
import jp.kirikiri.tvp2.msg.Message;
import jp.kirikiri.tvp2.visual.AffineMatrix2D;
import jp.kirikiri.tvp2.visual.CharacterData;
import jp.kirikiri.tvp2.visual.ComplexRect;
import jp.kirikiri.tvp2.visual.GammaAdjustTempData;
import jp.kirikiri.tvp2.visual.Rect;
import jp.kirikiri.tvp2env.CustomOperationComposite;
import jp.kirikiri.tvp2env.Font;

public class NativeImageBuffer {
    private static String[] WRITABLE_FORMANT_NAMES;
    private static byte[][] Color252DitherPalette;
    private static byte[][][][] DitherTable_676;
    private static final byte[][] Dither4x4;
    private BufferedImage mImage;
    private int mWidth;
    private int mHeight;
    private HashMap<Character, GlyphVector> mGlyphHash;
    private java.awt.Font mChecheFont;
    private int mRefCount;
    private static BufferedImage mFontTempImage;
    private static final int FontTempImageWidth = 64;
    private static final int FontTempImageHeight = 64;
    private static final int BITMAPFILEHEADER_SIZE = 14;
    private static final int BITMAPINFOHEADER_SIZE = 40;
    private static final int BMP_HEADER_SIZE = 54;
    private static final int BMP_PALETTE_SIZE = 1024;
    private static final int BI_RGB = 0;

    static {
        byte[][] byArrayArray = new byte[4][];
        byte[] byArray = new byte[4];
        byArray[1] = 12;
        byArray[2] = 2;
        byArray[3] = 14;
        byArrayArray[0] = byArray;
        byArrayArray[1] = new byte[]{8, 4, 10, 6};
        byArrayArray[2] = new byte[]{3, 15, 1, 13};
        byArrayArray[3] = new byte[]{11, 7, 9, 5};
        Dither4x4 = byArrayArray;
    }

    public static void initialize() {
        CustomOperationComposite.initialize();
        Color252DitherPalette = null;
        DitherTable_676 = null;
    }

    public NativeImageBuffer(int w, int h) {
        this.mWidth = w;
        this.mHeight = h;
        this.mImage = new BufferedImage(w, h, 2);
        this.mRefCount = 1;
    }

    public NativeImageBuffer(int w, int h, int bpp) {
        this.mWidth = w;
        this.mHeight = h;
        int type = 2;
        if (bpp == 8) {
            type = 13;
        }
        this.mImage = new BufferedImage(w, h, type);
        this.mRefCount = 1;
    }

    public NativeImageBuffer(NativeImageBuffer src) {
        this.mWidth = src.mWidth;
        this.mHeight = src.mHeight;
        int type = src.mImage.getType();
        this.mImage = new BufferedImage(this.mWidth, this.mHeight, type);
        Graphics2D g = (Graphics2D)this.mImage.getGraphics();
        g.setComposite(AlphaComposite.Src);
        g.drawImage((Image)src.mImage, 0, 0, null);
        g.dispose();
        this.mRefCount = 1;
    }

    public NativeImageBuffer(int w, int h, NativeImageBuffer src) {
        this.mWidth = w;
        this.mHeight = h;
        int type = src.mImage.getType();
        this.mImage = new BufferedImage(this.mWidth, this.mHeight, type);
        Graphics2D g = (Graphics2D)this.mImage.getGraphics();
        g.setComposite(AlphaComposite.Src);
        g.drawImage((Image)src.mImage, 0, 0, null);
        g.dispose();
        this.mRefCount = 1;
    }

    public NativeImageBuffer(BufferedImage img) {
        this.mWidth = img.getWidth();
        this.mHeight = img.getHeight();
        this.mImage = img;
        this.mRefCount = 1;
    }

    public final void addRef() {
        ++this.mRefCount;
    }

    public void finalizeRelease() {
        if (this.mRefCount != 1) {
            --this.mRefCount;
        }
    }

    public final void release() {
        if (this.mRefCount != 1) {
            --this.mRefCount;
        }
    }

    public final boolean isIndependent() {
        return this.mRefCount == 1;
    }

    public final Image getImage() {
        return this.mImage;
    }

    public final void setImage(BufferedImage img) {
        this.mImage = img;
        this.mWidth = img.getWidth();
        this.mHeight = img.getHeight();
    }

    public final int getWidth() {
        return this.mImage.getWidth();
    }

    public final int getHeight() {
        return this.mImage.getHeight();
    }

    public final void recreate(int w, int h, boolean keepimage) throws TJSException {
        int imageType = this.mImage.getType();
        if (w != 0 && h != 0) {
            BufferedImage img = new BufferedImage(w, h, imageType);
            if (keepimage && this.mImage != null) {
                Graphics dest = img.getGraphics();
                dest.drawImage(this.mImage, 0, 0, null);
            }
            this.mImage = null;
            this.mImage = img;
        } else {
            this.mImage = null;
        }
        this.mWidth = w;
        this.mHeight = h;
    }

    public final int getBPP() {
        return this.mImage.getColorModel().getPixelSize();
    }

    public final void getScanLine(int l, int[] buff) {
        if (this.mImage instanceof BufferedImage) {
            BufferedImage bi = this.mImage;
            int w = bi.getWidth();
            bi.getRGB(0, l, w, 1, buff, 0, w);
        }
    }

    public final int[] getScanLine(int l) {
        if (this.mImage instanceof BufferedImage) {
            BufferedImage bi = this.mImage;
            int w = bi.getWidth();
            return bi.getRGB(0, l, w, 1, null, 0, w);
        }
        return null;
    }

    public final int[] getScanLineForWrite(int l) {
        if (this.mImage instanceof BufferedImage) {
            BufferedImage bi = this.mImage;
            WritableRaster wr = bi.getRaster();
            DataBufferInt bdi = (DataBufferInt)wr.getDataBuffer();
            return bdi.getData();
        }
        return null;
    }

    public final void fill(Rect rect, int value) {
        if (this.mImage.getType() == 13) {
            int w = this.mImage.getWidth();
            WritableRaster src = this.mImage.getRaster();
            DataBuffer buff = src.getDataBuffer();
            int type = buff.getDataType();
            if (type == 0) {
                DataBufferByte srcBuff = (DataBufferByte)buff;
                byte[] s = srcBuff.getData();
                int ystart = rect.top * w + rect.left;
                int rw = rect.right - rect.left;
                int rh = rect.bottom - rect.top;
                byte color = (byte)(value & 0xFF);
                int y = 0;
                while (y < rh) {
                    int sp = ystart;
                    int x = 0;
                    while (x < rw) {
                        s[sp] = color;
                        ++sp;
                        ++x;
                    }
                    ystart += w;
                    ++y;
                }
            }
        } else {
            Graphics2D g = (Graphics2D)this.mImage.getGraphics();
            g.setComposite(AlphaComposite.Src);
            g.setColor(new Color(value, true));
            g.fillRect(rect.left, rect.top, rect.width(), rect.height());
            g.dispose();
        }
    }

    public final void fillColor(Rect rect, int color, int opa) {
        Graphics2D g = (Graphics2D)this.mImage.getGraphics();
        g.setComposite(this.createAlphaComposite(3, opa));
        g.setColor(new Color(color, false));
        g.fillRect(rect.left, rect.top, rect.width(), rect.height());
        g.dispose();
    }

    public final boolean copyRect(int x, int y, NativeImageBuffer src, Rect refrect) {
        Graphics2D g = (Graphics2D)this.mImage.getGraphics();
        g.setComposite(AlphaComposite.Src);
        boolean ret = g.drawImage(src.mImage, x, y, x + refrect.width(), y + refrect.height(), refrect.left, refrect.top, refrect.right, refrect.bottom, null);
        g.dispose();
        return ret;
    }

    public final boolean copyRect(int x, int y, NativeImageBuffer src, Rect refrect, int plane) {
        BufferedImage tmp;
        Graphics2D g = (Graphics2D)this.mImage.getGraphics();
        if (3 == plane) {
            g.setComposite(AlphaComposite.Src);
        } else if (1 == plane) {
            g.setComposite(new CustomOperationComposite(-1, 255, false));
        } else if (2 == plane) {
            g.setComposite(new CustomOperationComposite(-2, 255, false));
        }
        int h = refrect.height();
        int w = refrect.width();
        if (this == src && y >= refrect.top && y - refrect.top < h && x >= refrect.left && x - refrect.left < w) {
            int type = src.mImage.getType();
            tmp = new BufferedImage(w, h, type);
            Graphics2D tg = (Graphics2D)tmp.getGraphics();
            tg.setComposite(AlphaComposite.Src);
            tg.drawImage(src.mImage, 0, 0, w, h, refrect.left, refrect.top, refrect.right, refrect.bottom, null);
            tg.dispose();
            refrect = new Rect(0, 0, w, h);
        } else {
            tmp = src.mImage;
        }
        boolean ret = g.drawImage(tmp, x, y, x + refrect.width(), y + refrect.height(), refrect.left, refrect.top, refrect.right, refrect.bottom, null);
        g.dispose();
        return ret;
    }

    public final boolean copyRect(Rect dstrect, NativeImageBuffer src, Rect srcrect, int method, int opa, boolean hda) {
        Graphics2D g = (Graphics2D)this.mImage.getGraphics();
        g.setComposite(new CustomOperationComposite(method, opa, hda));
        boolean ret = g.drawImage(src.mImage, dstrect.left, dstrect.top, dstrect.right, dstrect.bottom, srcrect.left, srcrect.top, srcrect.right, srcrect.bottom, null);
        g.dispose();
        return ret;
    }

    public static CharacterData getCharacterData(Font fontV, char ch, boolean aa) {
        if (mFontTempImage == null) {
            mFontTempImage = new BufferedImage(64, 64, 10);
        }
        Graphics2D g = (Graphics2D)mFontTempImage.getGraphics();
        java.awt.Font font = fontV.getFont();
        if (aa) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        FontRenderContext frc = g.getFontRenderContext();
        char[] c = new char[]{ch};
        GlyphVector glyph = font.layoutGlyphVector(frc, c, 0, 1, 0);
        Rectangle r = glyph.getPixelBounds(frc, 0.0f, 0.0f);
        int rw = r.width;
        rw = (rw - 1 >>> 2) + 1 << 2;
        int rh = r.height;
        if (rw > mFontTempImage.getWidth() || rh > mFontTempImage.getHeight()) {
            int size = rw;
            if (size < rh) {
                size = rh;
            }
            int s2 = mFontTempImage.getWidth();
            while (s2 < size) {
                s2 <<= 1;
            }
            mFontTempImage = new BufferedImage(s2, s2, 10);
            g = (Graphics2D)mFontTempImage.getGraphics();
            if (aa) {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            frc = g.getFontRenderContext();
            glyph = font.layoutGlyphVector(frc, c, 0, 1, 0);
            r = glyph.getPixelBounds(frc, 0.0f, 0.0f);
        }
        g.setComposite(AlphaComposite.Src);
        g.setPaint(Color.BLACK);
        g.fillRect(0, 0, rw, rh);
        g.setPaint(Color.WHITE);
        g.drawGlyphVector(glyph, -r.x, -r.y);
        CharacterData ret = new CharacterData();
        ret.alloc(rw * rh);
        byte[] bmp = ret.getData();
        int w = mFontTempImage.getWidth();
        WritableRaster src = mFontTempImage.getRaster();
        DataBuffer buff = src.getDataBuffer();
        int type = buff.getDataType();
        if (type == 0) {
            DataBufferByte srcBuff = (DataBufferByte)buff;
            byte[] s = srcBuff.getData();
            int ystart = 0;
            int idx = 0;
            int y = 0;
            while (y < rh) {
                int sp = ystart;
                int x = 0;
                while (x < rw) {
                    int color = s[sp] & 0xFF;
                    byte out = (byte)(color >>> 2);
                    if (color != 0) {
                        out = (byte)(out + 1);
                    }
                    bmp[idx] = out;
                    ++idx;
                    ++sp;
                    ++x;
                }
                ystart += w;
                ++y;
            }
        }
        ret.mAntialiased = aa;
        ret.mPitch = rw;
        ret.mOriginX = r.x;
        ret.mOriginY = r.y;
        ret.mBlackBoxX = rw;
        ret.mBlackBoxY = rh;
        Rectangle2D r2 = font.getStringBounds(c, 0, 1, frc);
        ret.mCellIncX = (int)r2.getWidth();
        ret.mCellIncY = 0;
        return ret;
    }

    public final void drawText(Font fontV, Rect destrect, int x, int y, String text, int color, int bltmode, int opa, boolean holdalpha, boolean aa, int shlevel, int shadowcolor, int shwidth, int shofsx, int shofsy, ComplexRect updaterects) {
        AlphaComposite composite;
        Image img;
        boolean fontChange;
        int count = text.length();
        if (count == 0) {
            return;
        }
        java.awt.Font font = fontV.getFont();
        if (bltmode == 3) {
            if (opa < 0) {
                opa = 0;
            }
            if (opa > 255) {
                opa = 255;
            }
        } else {
            if (opa < 0) {
                opa = 0;
            }
            if (opa > 255) {
                opa = 255;
            }
        }
        if (opa == 0) {
            return;
        }
        if (this.mGlyphHash == null) {
            this.mGlyphHash = new HashMap();
        }
        boolean bl = fontChange = this.mChecheFont != font;
        if (fontChange) {
            this.mGlyphHash.clear();
            this.mChecheFont = font;
        }
        if ((img = this.getImage()) == null) {
            return;
        }
        Graphics2D g = (Graphics2D)img.getGraphics();
        FontMetrics metrics = g.getFontMetrics(font);
        AlphaComposite shadowcomposite = null;
        if (shlevel > 255) {
            shlevel = 255;
        }
        if (bltmode == 0 || bltmode == 1) {
            composite = this.createAlphaComposite(2, opa);
            if (shlevel != 0) {
                composite = this.createAlphaComposite(2, shlevel);
            }
        } else if (bltmode == 2 || bltmode == 3) {
            composite = this.createAlphaComposite(3, opa);
            if (shlevel != 0) {
                shadowcomposite = this.createAlphaComposite(3, shlevel);
            }
        } else {
            composite = this.createAlphaComposite(3, opa);
            if (shlevel != 0) {
                shadowcomposite = this.createAlphaComposite(3, shlevel);
            }
        }
        if (shlevel == 0) {
            g.setComposite(composite);
        }
        if (aa) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        Color fontColor = new Color(color);
        Color shadowColor = new Color(shadowcolor);
        char[] c = text.toCharArray();
        FontRenderContext frc = g.getFontRenderContext();
        float ox = x;
        float oy = y + metrics.getMaxAscent();
        Rect shbound = new Rect();
        Rect srect = new Rect();
        Rect union = new Rect();
        BasicStroke shStoroke = null;
        if (shlevel != 0) {
            shStoroke = new BasicStroke(shwidth);
        }
        int i = 0;
        while (i < count) {
            Rectangle r;
            boolean shadowdraw = false;
            boolean glyphdraw = false;
            GlyphVector glyph = this.mGlyphHash.get(Character.valueOf(c[i]));
            if (glyph == null) {
                glyph = font.layoutGlyphVector(frc, c, i, i + 1, 0);
                this.mGlyphHash.put(Character.valueOf(c[i]), glyph);
            }
            if (shlevel != 0) {
                g.setStroke(shStoroke);
                Shape shape = glyph.getOutline(ox + (float)shofsx - (float)(shwidth / 2), oy + (float)shofsy - (float)(shwidth / 2));
                Rectangle r2 = shape.getBounds();
                if (NativeImageBuffer.checkBounds(destrect, r2)) {
                    if (shlevel != 0) {
                        g.setComposite(shadowcomposite);
                    }
                    g.setPaint(shadowColor);
                    g.draw(shape);
                    g.fill(shape);
                    shbound.set(r2.x, r2.y, r2.x + r2.width, r2.y + r2.height);
                    shadowdraw = true;
                    updaterects.or(shbound);
                }
            }
            if (NativeImageBuffer.checkBounds(destrect, r = glyph.getPixelBounds(frc, ox, oy))) {
                if (shlevel != 0) {
                    g.setComposite(composite);
                }
                g.setPaint(fontColor);
                g.drawGlyphVector(glyph, ox, oy);
                if (updaterects != null) {
                    srect.set(r.x, r.y, r.x + r.width, r.y + r.height);
                    glyphdraw = true;
                }
            }
            if (shadowdraw || glyphdraw) {
                if (shadowdraw && glyphdraw) {
                    Rect.unionRect(union, srect, shbound);
                    updaterects.or(union);
                } else if (shadowdraw) {
                    updaterects.or(shbound);
                } else if (glyphdraw) {
                    updaterects.or(srect);
                }
            }
            ox += glyph.getGlyphMetrics(0).getAdvanceX();
            ++i;
        }
    }

    private static final boolean checkBounds(Rect drect, Rectangle srect) {
        if (srect.x >= drect.right) {
            return false;
        }
        if (srect.x + srect.width < drect.left) {
            return false;
        }
        if (srect.y >= drect.bottom) {
            return false;
        }
        return srect.y + srect.height >= drect.top;
    }

    private AlphaComposite createAlphaComposite(int type, int opa) {
        return AlphaComposite.getInstance(type, (float)opa / 255.0f);
    }

    private static final void create256ColorPaletteTable() {
        DitherTable_676 = new byte[3][][][];
        int i = 0;
        while (i < 3) {
            NativeImageBuffer.DitherTable_676[i] = new byte[4][][];
            int j = 0;
            while (j < 4) {
                NativeImageBuffer.DitherTable_676[i][j] = new byte[4][];
                int k = 0;
                while (k < 4) {
                    NativeImageBuffer.DitherTable_676[i][j][k] = new byte[256];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        int j = 0;
        while (j < 4) {
            int i2 = 0;
            while (i2 < 4) {
                double v1 = (double)Dither4x4[j][i2] / 16.0;
                double v2 = (double)Dither4x4[(j + 1) % 2][(i2 + 1) % 2] / 16.0;
                double v3 = (double)Dither4x4[j][(i2 + 1) % 2] / 16.0;
                int n = 0;
                while (n < 256) {
                    double nt = (double)n / 255.0;
                    int main = (int)(nt * 5.0);
                    double frac = nt * 5.0 - (double)((int)(nt * 5.0));
                    NativeImageBuffer.DitherTable_676[2][i2][j][n] = (byte)((main + (v1 < frac ? 1 : 0)) * 42);
                    NativeImageBuffer.DitherTable_676[0][i2][j][n] = (byte)(main + (v2 < frac ? 1 : 0));
                    main = (int)(nt * 6.0);
                    frac = nt * 6.0 - (double)((int)(nt * 6.0));
                    NativeImageBuffer.DitherTable_676[1][i2][j][n] = (byte)((main + (v3 < frac ? 1 : 0)) * 6);
                    ++n;
                }
                ++i2;
            }
            ++j;
        }
        Color252DitherPalette = new byte[3][];
        i = 0;
        while (i < 3) {
            NativeImageBuffer.Color252DitherPalette[i] = new byte[256];
            ++i;
        }
        int c = 0;
        int r = 0;
        while (r < 6) {
            int g = 0;
            while (g < 7) {
                int b = 0;
                while (b < 6) {
                    NativeImageBuffer.Color252DitherPalette[0][c] = (byte)(r * 255 / 5 & 0xFF);
                    NativeImageBuffer.Color252DitherPalette[1][c] = (byte)(g * 255 / 6 & 0xFF);
                    NativeImageBuffer.Color252DitherPalette[2][c] = (byte)(b * 255 / 5 & 0xFF);
                    ++c;
                    ++b;
                }
                ++g;
            }
            ++r;
        }
        while (c < 256) {
            NativeImageBuffer.Color252DitherPalette[2][c] = 0;
            NativeImageBuffer.Color252DitherPalette[1][c] = 0;
            NativeImageBuffer.Color252DitherPalette[0][c] = 0;
            ++c;
        }
    }

    public final void saveAs(OutputStream output, String name, String type) throws TJSException {
        if (WRITABLE_FORMANT_NAMES == null) {
            WRITABLE_FORMANT_NAMES = ImageIO.getWriterFormatNames();
        }
        BufferedImage img = null;
        if (this.mImage instanceof BufferedImage) {
            img = this.mImage;
        } else if (this.mImage != null) {
            img = new BufferedImage(this.mImage.getWidth(null), this.mImage.getHeight(null), 2);
            Graphics2D g = (Graphics2D)img.getGraphics();
            g.setComposite(AlphaComposite.Src);
            g.drawImage((Image)this.mImage, 0, 0, null);
            g.dispose();
        }
        if (img == null) {
            Message.throwExceptionMessage("\u5185\u90e8\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f: at %1 line %2");
            return;
        }
        boolean foundtype = false;
        boolean saveBmp = false;
        if (type.startsWith("bmp")) {
            saveBmp = true;
        } else {
            int count = WRITABLE_FORMANT_NAMES.length;
            int i = 0;
            while (i < count) {
                if (WRITABLE_FORMANT_NAMES[i].equals(type)) {
                    foundtype = true;
                    break;
                }
                ++i;
            }
        }
        if (!foundtype && !saveBmp) {
            Message.throwExceptionMessage("\u7121\u52b9\u306a\u4fdd\u5b58\u753b\u50cf\u5f62\u5f0f\u3067\u3059(%1)", type);
            return;
        }
        String format = type;
        if (saveBmp) {
            BinaryStream stream = Storage.createStream(TVP.StorageMediaManager.normalizeStorageName(name, null), 1);
            try {
                WritableRaster src;
                DataBuffer buff;
                int buftype;
                int pixelbytes = 4;
                if ("bmp24".equalsIgnoreCase(type)) {
                    pixelbytes = 3;
                } else if ("bmp8".equalsIgnoreCase(type)) {
                    pixelbytes = 1;
                }
                int height = img.getHeight();
                int width = img.getWidth();
                int fileSize = this.calcBmpSize(width, height, pixelbytes * 8);
                ByteBuffer buffer = ByteBuffer.allocate(fileSize);
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                int bmppitch = width * pixelbytes;
                bmppitch = (bmppitch - 1 >> 2) + 1 << 2;
                buffer.putShort((short)19778);
                buffer.putInt(54 + bmppitch * height + (pixelbytes == 1 ? 1024 : 0));
                buffer.putShort((short)0);
                buffer.putShort((short)0);
                buffer.putInt(54 + (pixelbytes == 1 ? 1024 : 0));
                buffer.putInt(40);
                buffer.putInt(width);
                buffer.putInt(height);
                buffer.putShort((short)1);
                buffer.putShort((short)(pixelbytes * 8));
                buffer.putInt(0);
                buffer.putInt(0);
                buffer.putInt(0);
                buffer.putInt(0);
                buffer.putInt(0);
                buffer.putInt(0);
                if (pixelbytes == 1) {
                    if (DitherTable_676 == null) {
                        NativeImageBuffer.create256ColorPaletteTable();
                    }
                    int i = 0;
                    while (i < 256) {
                        buffer.put(Color252DitherPalette[0][i]);
                        buffer.put(Color252DitherPalette[1][i]);
                        buffer.put(Color252DitherPalette[2][i]);
                        buffer.put((byte)0);
                        ++i;
                    }
                }
                if ((buftype = (buff = (src = this.mImage.getRaster()).getDataBuffer()).getDataType()) != 3) {
                    Message.throwExceptionMessage("\u5185\u90e8\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f: at %1 line %2");
                }
                DataBufferInt srcBuff = (DataBufferInt)buff;
                int[] s = srcBuff.getData();
                int remain24 = bmppitch % 3;
                int y = height - 1;
                while (y >= 0) {
                    int x;
                    int starty = y * width;
                    if (pixelbytes == 4) {
                        x = 0;
                        while (x < width) {
                            buffer.putInt(s[starty + x]);
                            ++x;
                        }
                    } else if (pixelbytes == 1) {
                        int xofs = 0;
                        int yofs = y;
                        byte[][][][] line = DitherTable_676;
                        yofs &= 3;
                        int vx = xofs & 3;
                        int x2 = 0;
                        while (x2 < width) {
                            int v = s[starty + x2];
                            int dest = line[0][yofs][vx][v >>> 16 & 0xFF] + line[2][yofs][vx][v & 0xFF] + line[1][yofs][vx][v >>> 8 & 0xFF];
                            ++vx;
                            vx &= 3;
                            buffer.put((byte)(dest & 0xFF));
                            ++x2;
                        }
                        int i = width;
                        while (i < bmppitch) {
                            buffer.put((byte)0);
                            ++i;
                        }
                    } else {
                        x = 0;
                        while (x < width) {
                            int color = s[starty + x];
                            buffer.put((byte)(color & 0xFF));
                            buffer.put((byte)(color >>> 8 & 0xFF));
                            buffer.put((byte)(color >>> 16 & 0xFF));
                            ++x;
                        }
                        int i = 0;
                        while (i < remain24) {
                            buffer.put((byte)0);
                            ++i;
                        }
                    }
                    --y;
                }
                stream.write(buffer.array());
            }
            finally {
                stream.close();
                stream = null;
                img = null;
            }
        }
        try {
            ImageIO.write((RenderedImage)img, format, output);
            output.close();
        }
        catch (IOException e) {
            img = null;
            Message.throwExceptionMessage("\u66f8\u304d\u8fbc\u307f\u30a8\u30e9\u30fc\u3067\u3059");
        }
        img = null;
    }

    private int calcBmpSize(int w, int h, int bpp) {
        int size = 0;
        size = bpp == 8 ? ((w - 1 >> 2) + 1 << 2) * h + 1024 + 54 : (bpp == 32 ? w * 4 * h + 54 : (w * 3 + 3 >> 2 << 2) * h + 54);
        return size;
    }

    public final int getPoint(int x, int y) throws TJSException {
        if (x < 0 || y < 0 || x >= this.getWidth() || y >= this.getHeight()) {
            Message.throwExceptionMessage("\u77e9\u5f62\u5916\u3092\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f");
        }
        if (this.mImage.getType() == 13) {
            int w = this.mImage.getWidth();
            WritableRaster src = this.mImage.getRaster();
            DataBuffer buff = src.getDataBuffer();
            int type = buff.getDataType();
            if (type == 0) {
                DataBufferByte srcBuff = (DataBufferByte)buff;
                byte[] s = srcBuff.getData();
                int pos = x + y * w;
                if (pos >= 0 && pos < s.length) {
                    byte ret = s[pos];
                    return ret;
                }
                Message.throwExceptionMessage("\u77e9\u5f62\u5916\u3092\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f");
            }
            return 0;
        }
        return this.mImage.getRGB(x, y);
    }

    public final void setPoint(int x, int y, int n) throws TJSException {
        if (x < 0 || y < 0 || x >= this.getWidth() || y >= this.getHeight()) {
            Message.throwExceptionMessage("\u77e9\u5f62\u5916\u3092\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f");
        }
        if (this.mImage.getType() == 13) {
            int w = this.mImage.getWidth();
            WritableRaster src = this.mImage.getRaster();
            DataBuffer buff = src.getDataBuffer();
            int type = buff.getDataType();
            if (type == 0) {
                DataBufferByte srcBuff = (DataBufferByte)buff;
                byte[] s = srcBuff.getData();
                int pos = x + y * w;
                if (pos >= 0 && pos < s.length) {
                    s[pos] = (byte)(n & 0xFF);
                } else {
                    Message.throwExceptionMessage("\u77e9\u5f62\u5916\u3092\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f");
                }
            }
        } else {
            this.mImage.setRGB(x, y, n);
        }
    }

    public void coerceData(boolean b) {
        this.mImage.coerceData(b);
    }

    public boolean isAlphaPremultiplied() {
        return this.mImage.isAlphaPremultiplied();
    }

    public void flipLR(Rect rect) throws TJSException {
        int w = this.mImage.getWidth();
        WritableRaster src = this.mImage.getRaster();
        DataBuffer buff = src.getDataBuffer();
        int type = buff.getDataType();
        if (type == 3) {
            DataBufferInt srcBuff = (DataBufferInt)buff;
            int[] s = srcBuff.getData();
            int ystart = rect.top * w + rect.left;
            int rh = rect.bottom - rect.top;
            int rw = rect.right - rect.left;
            int w2 = rw / 2;
            int y = 0;
            while (y < rh) {
                int x = 0;
                while (x < w2) {
                    int pos = ystart + x;
                    int dst = ystart + rw - x - 1;
                    int c = s[pos];
                    s[pos] = s[dst];
                    s[dst] = c;
                    ++x;
                }
                ystart += w;
                ++y;
            }
        } else if (type == 0 && this.mImage.getType() == 10) {
            byte[] s = ((DataBufferByte)buff).getData();
            int ystart = rect.top * w + rect.left;
            int rh = rect.bottom - rect.top;
            int rw = rect.right - rect.left;
            int w2 = rw / 2;
            int y = 0;
            while (y < rh) {
                int x = 0;
                while (x < w2) {
                    int pos = ystart + x;
                    int dst = ystart + rw - x - 1;
                    byte c = s[pos];
                    s[pos] = s[dst];
                    s[dst] = c;
                    ++x;
                }
                ystart += w;
                ++y;
            }
        } else {
            throw new TJSException("Not support image type.");
        }
    }

    public void flipUD(Rect rect) throws TJSException {
        int w = this.mImage.getWidth();
        WritableRaster src = this.mImage.getRaster();
        DataBuffer buff = src.getDataBuffer();
        int type = buff.getDataType();
        if (type == 3) {
            DataBufferInt srcBuff = (DataBufferInt)buff;
            int[] s = srcBuff.getData();
            int ystart = rect.top * w + rect.left;
            int yend = (rect.bottom - 1) * w + rect.left;
            int rw = rect.right - rect.left;
            int h2 = (rect.bottom - rect.top) / 2;
            int y = 0;
            while (y < h2) {
                int sp = ystart;
                int dp = yend;
                int x = 0;
                while (x < rw) {
                    int c = s[sp];
                    s[sp] = s[dp];
                    s[dp] = c;
                    ++sp;
                    ++dp;
                    ++x;
                }
                ystart += w;
                yend -= w;
                ++y;
            }
        } else if (type == 0 && this.mImage.getType() == 10) {
            byte[] s = ((DataBufferByte)buff).getData();
            int ystart = rect.top * w + rect.left;
            int yend = (rect.bottom - 1) * w + rect.left;
            int rw = rect.right - rect.left;
            int h2 = (rect.bottom - rect.top) / 2;
            int y = 0;
            while (y < h2) {
                int sp = ystart;
                int dp = yend;
                int x = 0;
                while (x < rw) {
                    byte c = s[sp];
                    s[sp] = s[dp];
                    s[dp] = c;
                    ++sp;
                    ++dp;
                    ++x;
                }
                ystart += w;
                yend -= w;
                ++y;
            }
        } else {
            throw new TJSException("Not support image type.");
        }
    }

    public void fillMask(Rect rect, int opa) throws TJSException {
        int w = this.mImage.getWidth();
        int mask = opa << 24;
        WritableRaster src = this.mImage.getRaster();
        DataBuffer buff = src.getDataBuffer();
        int type = buff.getDataType();
        if (type == 3) {
            DataBufferInt srcBuff = (DataBufferInt)buff;
            int[] s = srcBuff.getData();
            int ystart = rect.top * w + rect.left;
            int rw = rect.right - rect.left;
            int rh = rect.bottom - rect.top;
            int y = 0;
            while (y < rh) {
                int sp = ystart;
                int x = 0;
                while (x < rw) {
                    int c = s[sp] & 0xFFFFFF;
                    s[sp] = c | mask;
                    ++sp;
                    ++x;
                }
                ystart += w;
                ++y;
            }
        } else {
            throw new TJSException("Not support image type.");
        }
    }

    public void setPointMain(int x, int y, int color) {
        int c = this.mImage.getRGB(x, y);
        c &= 0xFF000000;
        this.mImage.setRGB(x, y, c |= color);
    }

    public void setPointMask(int x, int y, int mask) {
        int c = this.mImage.getRGB(x, y);
        c &= 0xFFFFFF;
        this.mImage.setRGB(x, y, c |= (mask & 0xFF) << 24);
    }

    public void blendColor(Rect rect, int color, int opa, boolean additive) throws TJSException {
        Graphics2D g = (Graphics2D)this.mImage.getGraphics();
        if (opa == 255) {
            g.setComposite(AlphaComposite.Src);
        } else {
            g.setComposite(this.createAlphaComposite(3, opa));
        }
        g.setColor(new Color(color, false));
        g.fillRect(rect.left, rect.top, rect.width(), rect.height());
        g.dispose();
    }

    public void removeConstOpacity(Rect rect, int level) {
        block6: {
            int w = this.mImage.getWidth();
            WritableRaster src = this.mImage.getRaster();
            DataBuffer buff = src.getDataBuffer();
            int type = buff.getDataType();
            if (type != 3) break block6;
            DataBufferInt srcBuff = (DataBufferInt)buff;
            int[] s = srcBuff.getData();
            int ystart = rect.top * w + rect.left;
            int rw = rect.right - rect.left;
            int rh = rect.bottom - rect.top;
            if (level == 255) {
                int y = 0;
                while (y < rh) {
                    int sp = ystart;
                    int x = 0;
                    while (x < rw) {
                        s[sp] = s[sp] & 0xFFFFFF;
                        ++sp;
                        ++x;
                    }
                    ystart += w;
                    ++y;
                }
            } else {
                int strength = 255 - level;
                int y = 0;
                while (y < rh) {
                    int sp = ystart;
                    int x = 0;
                    while (x < rw) {
                        int d = s[sp];
                        s[sp] = (d & 0xFFFFFF) + ((d >>> 24) * strength << 16 & 0xFF000000);
                        ++sp;
                        ++x;
                    }
                    ystart += w;
                    ++y;
                }
            }
        }
    }

    public boolean stretchBlt(Rect cliprect, Rect destrect, NativeImageBuffer ref, Rect refrect, int type, boolean hda, int opa, int method) {
        Graphics2D g = (Graphics2D)this.mImage.getGraphics();
        g.setClip(cliprect.left, cliprect.top, cliprect.width(), cliprect.height());
        if (type == 1 || type == 2) {
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        } else if (type == 3) {
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        } else {
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        }
        if (!hda) {
            if (method == 0) {
                if (opa == 255) {
                    g.setComposite(AlphaComposite.Src);
                } else {
                    g.setComposite(this.createAlphaComposite(2, opa));
                }
            } else if (method == 1 || method == 15) {
                if (opa == 255) {
                    g.setComposite(AlphaComposite.Src);
                } else {
                    g.setComposite(this.createAlphaComposite(2, opa));
                }
            } else if (method == 2 || method == 3 || method == 14 || method == 11 || method == 13 || method == 12) {
                if (opa == 255) {
                    g.setComposite(AlphaComposite.SrcOver);
                } else {
                    g.setComposite(this.createAlphaComposite(3, opa));
                }
            } else {
                g.setComposite(new CustomOperationComposite(method, opa, hda));
            }
        } else {
            g.setComposite(new CustomOperationComposite(method, opa, hda));
        }
        boolean ret = g.drawImage(ref.mImage, destrect.left, destrect.top, destrect.right, destrect.bottom, refrect.left, refrect.top, refrect.right, refrect.bottom, null);
        g.dispose();
        return ret;
    }

    public boolean affineBlt(Rect destrect, NativeImageBuffer ref, Rect refrect, AffineMatrix2D matrix, int method, int opa, Rect updaterect, boolean hda, int type, boolean clear, int clearcolor) {
        Graphics2D g = (Graphics2D)this.mImage.getGraphics();
        g.setClip(destrect.left, destrect.top, destrect.width(), destrect.height());
        if (clear) {
            g.setComposite(AlphaComposite.Src);
            g.setColor(new Color(clearcolor, true));
            g.fillRect(destrect.left, destrect.top, destrect.width(), destrect.height());
        }
        if (type == 1 || type == 2) {
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        } else if (type == 3) {
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        } else {
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        }
        AffineTransform trans = new AffineTransform(matrix.a, matrix.b, matrix.c, matrix.d, matrix.tx, matrix.ty);
        int width = refrect.width();
        int height = refrect.height();
        if (clear) {
            updaterect.left = destrect.left;
            updaterect.right = destrect.right;
            updaterect.top = destrect.top;
            updaterect.bottom = destrect.bottom;
        } else {
            double[] pts = new double[]{0.0, 0.0, width, 0.0, width, height, 0.0, height};
            double[] dstPts = new double[8];
            trans.transform(pts, 0, dstPts, 0, 4);
            int i = 0;
            while (i < 3) {
                int j = 3;
                while (j > i) {
                    int p = (j - 1) * 2;
                    double prev = dstPts[p];
                    int c = j * 2;
                    double cur = dstPts[c];
                    if (prev > cur) {
                        dstPts[c] = prev;
                        dstPts[p] = cur;
                    }
                    if ((prev = dstPts[p = (j - 1) * 2 + 1]) > (cur = dstPts[c = j * 2 + 1])) {
                        dstPts[c] = prev;
                        dstPts[p] = cur;
                    }
                    --j;
                }
                ++i;
            }
            updaterect.left = (int)dstPts[0];
            updaterect.right = (int)dstPts[6] + 1;
            updaterect.top = (int)dstPts[1];
            updaterect.bottom = (int)dstPts[7] + 1;
        }
        g.setTransform(trans);
        if (!hda) {
            if (method == 0) {
                if (opa == 255) {
                    g.setComposite(AlphaComposite.Src);
                } else {
                    g.setComposite(this.createAlphaComposite(2, opa));
                }
            } else if (method == 1 || method == 15) {
                if (opa == 255) {
                    g.setComposite(AlphaComposite.Src);
                } else {
                    g.setComposite(this.createAlphaComposite(2, opa));
                }
            } else if (method == 2 || method == 3 || method == 14 || method == 11 || method == 13 || method == 12) {
                if (opa == 255) {
                    g.setComposite(AlphaComposite.SrcOver);
                } else {
                    g.setComposite(this.createAlphaComposite(3, opa));
                }
            } else {
                g.setComposite(new CustomOperationComposite(method, opa, hda));
            }
        } else {
            g.setComposite(new CustomOperationComposite(method, opa, hda));
        }
        g.drawImage(ref.mImage, 0, 0, width, height, refrect.left, refrect.top, refrect.right, refrect.bottom, null);
        g.dispose();
        return true;
    }

    public void doBoxBlurLoop(Rect rect, Rect area) throws TJSException {
        int vert_sum_right_limit;
        int w = this.mImage.getWidth();
        WritableRaster src = this.mImage.getRaster();
        DataBuffer buff = src.getDataBuffer();
        int type = buff.getDataType();
        if (type != 3) {
            throw new TJSException("Not support image type.");
        }
        DataBufferInt srcBuff = (DataBufferInt)buff;
        int[] s = srcBuff.getData();
        int width = this.getWidth();
        int height = this.getHeight();
        int dest_buf_size = area.top <= 0 ? 1 - area.top : 0;
        int vert_sum_left_limit = rect.left + area.left;
        if (vert_sum_left_limit < 0) {
            vert_sum_left_limit = 0;
        }
        if ((vert_sum_right_limit = rect.right - 1 + area.right) >= width) {
            vert_sum_right_limit = width - 1;
        }
        int[] vert_sum = null;
        Object dest_buf = null;
        try {
            int right_frac_len;
            int left_frac_len;
            int center_len;
            int h_init_end;
            int v_init_end;
            int v_init_start;
            vert_sum = new int[(vert_sum_right_limit - vert_sum_left_limit + 1 + 1) * 4];
            if (dest_buf_size != 0) {
                dest_buf = new int[dest_buf_size][];
                int i = 0;
                while (i < dest_buf_size) {
                    dest_buf[i] = new int[rect.right - rect.left];
                    ++i;
                }
            }
            if ((v_init_start = rect.top + area.top) < 0) {
                v_init_start = 0;
            }
            if ((v_init_end = rect.top + area.bottom) >= height) {
                v_init_end = height - 1;
            }
            int vert_sum_count = v_init_end - v_init_start + 1;
            int y = v_init_start;
            while (y <= v_init_end) {
                int add_line = y * w;
                int vs = 0;
                int x = vert_sum_left_limit;
                while (x <= vert_sum_right_limit) {
                    int sv = s[add_line + x];
                    int n = vs + 0;
                    vert_sum[n] = vert_sum[n] + (sv >>> 24);
                    int n2 = vs + 1;
                    vert_sum[n2] = vert_sum[n2] + (sv >>> 16 & 0xFF);
                    int n3 = vs + 2;
                    vert_sum[n3] = vert_sum[n3] + (sv >>> 8 & 0xFF);
                    int n4 = vs + 3;
                    vert_sum[n4] = vert_sum[n4] + (sv & 0xFF);
                    vs += 4;
                    ++x;
                }
                ++y;
            }
            int h_init_start = rect.left + area.left;
            if (h_init_start < 0) {
                h_init_start = 0;
            }
            if ((h_init_end = rect.left + area.right) >= width) {
                h_init_end = width - 1;
            }
            if ((center_len = rect.right - rect.left - (left_frac_len = rect.left + area.left < 0 ? -(rect.left + area.left) : 0) - (right_frac_len = rect.right + area.right >= width ? rect.right + area.right - width + 1 : 0)) < 0) {
                left_frac_len = rect.right - rect.left;
                right_frac_len = 0;
                center_len = 0;
            }
            int left_frac_lim = rect.left + left_frac_len;
            int center_lim = rect.left + left_frac_len + center_len;
            int dest_buf_free = dest_buf_size;
            int dest_buf_wp = 0;
            int[] sum = new int[4];
            int y2 = rect.top;
            while (y2 < rect.bottom) {
                int off;
                int b;
                int g;
                int r;
                int a;
                int div;
                if (dest_buf_free == 0) {
                    System.arraycopy(dest_buf[dest_buf_wp], 0, s, (y2 - dest_buf_size) * w + rect.left, rect.right - rect.left);
                } else {
                    --dest_buf_free;
                }
                sum[3] = 0;
                sum[2] = 0;
                sum[1] = 0;
                sum[0] = 0;
                int horz_sum_count = h_init_end - h_init_start + 1;
                int x = h_init_start;
                while (x <= h_init_end) {
                    int off2 = x - vert_sum_left_limit << 2;
                    sum[0] = sum[0] + vert_sum[off2 + 0];
                    sum[1] = sum[1] + vert_sum[off2 + 1];
                    sum[2] = sum[2] + vert_sum[off2 + 2];
                    sum[3] = sum[3] + vert_sum[off2 + 3];
                    ++x;
                }
                int[] dp = dest_buf[dest_buf_wp];
                int di = 0;
                int x2 = rect.left;
                while (x2 < left_frac_lim) {
                    div = horz_sum_count * vert_sum_count;
                    a = sum[0] / div << 24 & 0xFF000000;
                    r = sum[1] / div << 16 & 0xFF0000;
                    g = sum[2] / div << 8 & 0xFF00;
                    b = sum[3] / div & 0xFF;
                    dp[di] = a | r | g | b;
                    ++di;
                    if (x2 + area.left >= 0) {
                        off = x2 + area.left - vert_sum_left_limit << 2;
                        sum[0] = sum[0] - vert_sum[off + 0];
                        sum[1] = sum[1] - vert_sum[off + 1];
                        sum[2] = sum[2] - vert_sum[off + 2];
                        sum[3] = sum[3] - vert_sum[off + 3];
                        --horz_sum_count;
                    }
                    if (x2 + area.right + 1 < width) {
                        off = x2 + area.right + 1 - vert_sum_left_limit << 2;
                        sum[0] = sum[0] + vert_sum[off + 0];
                        sum[1] = sum[1] + vert_sum[off + 1];
                        sum[2] = sum[2] + vert_sum[off + 2];
                        sum[3] = sum[3] + vert_sum[off + 3];
                        ++horz_sum_count;
                    }
                    ++x2;
                }
                if (center_len > 0) {
                    NativeImageBuffer.doBoxBlurAvg16(dp, di, sum, vert_sum, x2 + area.right + 1 - vert_sum_left_limit, x2 + area.left - vert_sum_left_limit, horz_sum_count * vert_sum_count, center_len);
                    di += center_len;
                }
                x2 = center_lim;
                while (x2 < rect.right) {
                    div = horz_sum_count * vert_sum_count;
                    a = sum[0] / div << 24 & 0xFF000000;
                    r = sum[1] / div << 16 & 0xFF0000;
                    g = sum[2] / div << 8 & 0xFF00;
                    b = sum[3] / div & 0xFF;
                    dp[di] = a | r | g | b;
                    ++di;
                    if (x2 + area.left >= 0) {
                        off = x2 + area.left - vert_sum_left_limit << 2;
                        sum[0] = sum[0] - vert_sum[off + 0];
                        sum[1] = sum[1] - vert_sum[off + 1];
                        sum[2] = sum[2] - vert_sum[off + 2];
                        sum[3] = sum[3] - vert_sum[off + 3];
                        --horz_sum_count;
                    }
                    if (x2 + area.right + 1 < width) {
                        off = x2 + area.right + 1 - vert_sum_left_limit << 2;
                        sum[0] = sum[0] + vert_sum[off + 0];
                        sum[1] = sum[1] + vert_sum[off + 1];
                        sum[2] = sum[2] + vert_sum[off + 2];
                        sum[3] = sum[3] + vert_sum[off + 3];
                        ++horz_sum_count;
                    }
                    ++x2;
                }
                if (y2 != rect.bottom - 1) {
                    int sv;
                    int limit;
                    int vs;
                    int add_line;
                    int topline = y2 + area.top;
                    int bottomline = y2 + area.bottom + 1;
                    if (topline >= 0 && bottomline < height) {
                        int sub_line = topline * w;
                        add_line = bottomline * w;
                        NativeImageBuffer.addSubVertSum16(vert_sum, s, add_line + vert_sum_left_limit, sub_line + vert_sum_left_limit, vert_sum_right_limit - vert_sum_left_limit + 1);
                    } else if (topline >= 0) {
                        vs = 0;
                        int sub_line = topline * w;
                        limit = sub_line + vert_sum_right_limit;
                        sub_line += vert_sum_left_limit;
                        while (sub_line <= limit) {
                            sv = s[sub_line];
                            int n = vs + 0;
                            vert_sum[n] = vert_sum[n] - (sv >>> 24);
                            int n5 = vs + 1;
                            vert_sum[n5] = vert_sum[n5] - (sv >>> 16 & 0xFF);
                            int n6 = vs + 2;
                            vert_sum[n6] = vert_sum[n6] - (sv >>> 8 & 0xFF);
                            int n7 = vs + 3;
                            vert_sum[n7] = vert_sum[n7] - (sv & 0xFF);
                            ++sub_line;
                            vs += 4;
                        }
                        --vert_sum_count;
                    } else if (bottomline < height) {
                        vs = 0;
                        add_line = bottomline * w;
                        limit = add_line + vert_sum_right_limit;
                        add_line += vert_sum_left_limit;
                        while (add_line <= limit) {
                            sv = s[add_line];
                            int n = vs + 0;
                            vert_sum[n] = vert_sum[n] + (sv >>> 24);
                            int n8 = vs + 1;
                            vert_sum[n8] = vert_sum[n8] + (sv >>> 16 & 0xFF);
                            int n9 = vs + 2;
                            vert_sum[n9] = vert_sum[n9] + (sv >>> 8 & 0xFF);
                            int n10 = vs + 3;
                            vert_sum[n10] = vert_sum[n10] + (sv & 0xFF);
                            ++add_line;
                            vs += 4;
                        }
                        ++vert_sum_count;
                    }
                }
                if (++dest_buf_wp >= dest_buf_size) {
                    dest_buf_wp = 0;
                }
                ++y2;
            }
            while (dest_buf_free < dest_buf_size) {
                System.arraycopy(dest_buf[dest_buf_wp], 0, s, (rect.bottom - (dest_buf_size - dest_buf_free)) * w + rect.left, rect.right - rect.left);
                if (++dest_buf_wp >= dest_buf_size) {
                    dest_buf_wp = 0;
                }
                ++dest_buf_free;
            }
        }
        finally {
            vert_sum = null;
            dest_buf = null;
        }
    }

    public void doBoxBlurLoopAlpha(Rect rect, Rect area) throws TJSException {
        int vert_sum_right_limit;
        int w = this.mImage.getWidth();
        WritableRaster src = this.mImage.getRaster();
        DataBuffer buff = src.getDataBuffer();
        int type = buff.getDataType();
        if (type != 3) {
            throw new TJSException("Not support image type.");
        }
        DataBufferInt srcBuff = (DataBufferInt)buff;
        int[] s = srcBuff.getData();
        int width = this.getWidth();
        int height = this.getHeight();
        int dest_buf_size = area.top <= 0 ? 1 - area.top : 0;
        int vert_sum_left_limit = rect.left + area.left;
        if (vert_sum_left_limit < 0) {
            vert_sum_left_limit = 0;
        }
        if ((vert_sum_right_limit = rect.right - 1 + area.right) >= width) {
            vert_sum_right_limit = width - 1;
        }
        int[] vert_sum = null;
        Object dest_buf = null;
        try {
            int right_frac_len;
            int left_frac_len;
            int center_len;
            int h_init_end;
            int v_init_end;
            int v_init_start;
            vert_sum = new int[(vert_sum_right_limit - vert_sum_left_limit + 1 + 1) * 4];
            if (dest_buf_size != 0) {
                dest_buf = new int[dest_buf_size][];
                int i = 0;
                while (i < dest_buf_size) {
                    dest_buf[i] = new int[rect.right - rect.left];
                    ++i;
                }
            }
            if ((v_init_start = rect.top + area.top) < 0) {
                v_init_start = 0;
            }
            if ((v_init_end = rect.top + area.bottom) >= height) {
                v_init_end = height - 1;
            }
            int vert_sum_count = v_init_end - v_init_start + 1;
            int y = v_init_start;
            while (y <= v_init_end) {
                int add_line = y * w;
                int vs = 0;
                int x = vert_sum_left_limit;
                while (x <= vert_sum_right_limit) {
                    int add = s[add_line + x];
                    int add_a = add >>> 24;
                    int n = vs + 0;
                    vert_sum[n] = vert_sum[n] + add_a;
                    add_a += add_a >>> 7;
                    int n2 = vs + 1;
                    vert_sum[n2] = vert_sum[n2] + ((add >>> 16 & 0xFF) * add_a >>> 8);
                    int n3 = vs + 2;
                    vert_sum[n3] = vert_sum[n3] + ((add >>> 8 & 0xFF) * add_a >>> 8);
                    int n4 = vs + 3;
                    vert_sum[n4] = vert_sum[n4] + ((add & 0xFF) * add_a >>> 8);
                    vs += 4;
                    ++x;
                }
                ++y;
            }
            int h_init_start = rect.left + area.left;
            if (h_init_start < 0) {
                h_init_start = 0;
            }
            if ((h_init_end = rect.left + area.right) >= width) {
                h_init_end = width - 1;
            }
            if ((center_len = rect.right - rect.left - (left_frac_len = rect.left + area.left < 0 ? -(rect.left + area.left) : 0) - (right_frac_len = rect.right + area.right >= width ? rect.right + area.right - width + 1 : 0)) < 0) {
                left_frac_len = rect.right - rect.left;
                right_frac_len = 0;
                center_len = 0;
            }
            int left_frac_lim = rect.left + left_frac_len;
            int center_lim = rect.left + left_frac_len + center_len;
            int dest_buf_free = dest_buf_size;
            int dest_buf_wp = 0;
            int[] sum = new int[4];
            int y2 = rect.top;
            while (y2 < rect.bottom) {
                int off;
                int b;
                int g;
                int r;
                int a;
                int div;
                if (dest_buf_free == 0) {
                    System.arraycopy(dest_buf[dest_buf_wp], 0, s, (y2 - dest_buf_size) * w + rect.left, rect.right - rect.left);
                } else {
                    --dest_buf_free;
                }
                sum[3] = 0;
                sum[2] = 0;
                sum[1] = 0;
                sum[0] = 0;
                int horz_sum_count = h_init_end - h_init_start + 1;
                int x = h_init_start;
                while (x <= h_init_end) {
                    int off2 = x - vert_sum_left_limit << 2;
                    sum[0] = sum[0] + vert_sum[off2 + 0];
                    sum[1] = sum[1] + vert_sum[off2 + 1];
                    sum[2] = sum[2] + vert_sum[off2 + 2];
                    sum[3] = sum[3] + vert_sum[off2 + 3];
                    ++x;
                }
                int[] dp = dest_buf[dest_buf_wp];
                int di = 0;
                int x2 = rect.left;
                while (x2 < left_frac_lim) {
                    div = horz_sum_count * vert_sum_count;
                    a = sum[0] / div << 24 & 0xFF000000;
                    r = sum[1] / div << 16 & 0xFF0000;
                    g = sum[2] / div << 8 & 0xFF00;
                    b = sum[3] / div & 0xFF;
                    dp[di] = a | r | g | b;
                    ++di;
                    if (x2 + area.left >= 0) {
                        off = x2 + area.left - vert_sum_left_limit << 2;
                        sum[0] = sum[0] - vert_sum[off + 0];
                        sum[1] = sum[1] - vert_sum[off + 1];
                        sum[2] = sum[2] - vert_sum[off + 2];
                        sum[3] = sum[3] - vert_sum[off + 3];
                        --horz_sum_count;
                    }
                    if (x2 + area.right + 1 < width) {
                        off = x2 + area.right + 1 - vert_sum_left_limit << 2;
                        sum[0] = sum[0] + vert_sum[off + 0];
                        sum[1] = sum[1] + vert_sum[off + 1];
                        sum[2] = sum[2] + vert_sum[off + 2];
                        sum[3] = sum[3] + vert_sum[off + 3];
                        ++horz_sum_count;
                    }
                    ++x2;
                }
                if (center_len > 0) {
                    NativeImageBuffer.doBoxBlurAvg16_d(dp, di, sum, vert_sum, x2 + area.right + 1 - vert_sum_left_limit, x2 + area.left - vert_sum_left_limit, horz_sum_count * vert_sum_count, center_len);
                    di += center_len;
                }
                x2 = center_lim;
                while (x2 < rect.right) {
                    div = horz_sum_count * vert_sum_count;
                    a = sum[0] / div << 24 & 0xFF000000;
                    r = sum[1] / div << 16 & 0xFF0000;
                    g = sum[2] / div << 8 & 0xFF00;
                    b = sum[3] / div & 0xFF;
                    dp[di] = a | r | g | b;
                    ++di;
                    if (x2 + area.left >= 0) {
                        off = x2 + area.left - vert_sum_left_limit << 2;
                        sum[0] = sum[0] - vert_sum[off + 0];
                        sum[1] = sum[1] - vert_sum[off + 1];
                        sum[2] = sum[2] - vert_sum[off + 2];
                        sum[3] = sum[3] - vert_sum[off + 3];
                        --horz_sum_count;
                    }
                    if (x2 + area.right + 1 < width) {
                        off = x2 + area.right + 1 - vert_sum_left_limit << 2;
                        sum[0] = sum[0] + vert_sum[off + 0];
                        sum[1] = sum[1] + vert_sum[off + 1];
                        sum[2] = sum[2] + vert_sum[off + 2];
                        sum[3] = sum[3] + vert_sum[off + 3];
                        ++horz_sum_count;
                    }
                    ++x2;
                }
                if (y2 != rect.bottom - 1) {
                    int i;
                    int vs;
                    int sub_line;
                    int topline = y2 + area.top;
                    int bottomline = y2 + area.bottom + 1;
                    if (topline >= 0 && bottomline < height) {
                        sub_line = topline * w;
                        int add_line = bottomline * w;
                        NativeImageBuffer.addSubVertSum16_d(vert_sum, s, add_line + vert_sum_left_limit, sub_line + vert_sum_left_limit, vert_sum_right_limit - vert_sum_left_limit + 1);
                    } else if (topline >= 0) {
                        sub_line = topline * w + vert_sum_left_limit;
                        vs = 0;
                        i = vert_sum_left_limit;
                        while (i <= vert_sum_right_limit) {
                            int sub = s[sub_line];
                            int sub_a = sub >>> 24;
                            int n = vs + 0;
                            vert_sum[n] = vert_sum[n] - sub_a;
                            sub_a += sub_a >>> 7;
                            int n5 = vs + 1;
                            vert_sum[n5] = vert_sum[n5] - ((sub >>> 16 & 0xFF) * sub_a >>> 8);
                            int n6 = vs + 2;
                            vert_sum[n6] = vert_sum[n6] - ((sub >>> 8 & 0xFF) * sub_a >>> 8);
                            int n7 = vs + 3;
                            vert_sum[n7] = vert_sum[n7] - ((sub & 0xFF) * sub_a >>> 8);
                            vs += 4;
                            ++sub_line;
                            ++i;
                        }
                        --vert_sum_count;
                    } else if (bottomline < height) {
                        int add_line = bottomline * w + vert_sum_left_limit;
                        vs = 0;
                        i = vert_sum_left_limit;
                        while (i <= vert_sum_right_limit) {
                            int add = s[add_line];
                            int add_a = add >>> 24;
                            int n = vs + 0;
                            vert_sum[n] = vert_sum[n] + add_a;
                            add_a += add_a >>> 7;
                            int n8 = vs + 1;
                            vert_sum[n8] = vert_sum[n8] + ((add >>> 16 & 0xFF) * add_a >>> 8);
                            int n9 = vs + 2;
                            vert_sum[n9] = vert_sum[n9] + ((add >>> 8 & 0xFF) * add_a >>> 8);
                            int n10 = vs + 3;
                            vert_sum[n10] = vert_sum[n10] + ((add & 0xFF) * add_a >>> 8);
                            vs += 4;
                            ++add_line;
                            ++i;
                        }
                        ++vert_sum_count;
                    }
                }
                if (++dest_buf_wp >= dest_buf_size) {
                    dest_buf_wp = 0;
                }
                ++y2;
            }
            while (dest_buf_free < dest_buf_size) {
                System.arraycopy(dest_buf[dest_buf_wp], 0, s, (rect.bottom - (dest_buf_size - dest_buf_free)) * w + rect.left, rect.right - rect.left);
                if (++dest_buf_wp >= dest_buf_size) {
                    dest_buf_wp = 0;
                }
                ++dest_buf_free;
            }
        }
        finally {
            vert_sum = null;
            dest_buf = null;
        }
    }

    private static final void addSubVertSum16(int[] dest, int[] s, int addline, int subline, int len) {
        int d = 0;
        len += addline;
        while (addline < len) {
            int add = s[addline];
            int sub = s[subline];
            int n = d + 0;
            dest[n] = dest[n] + ((add >>> 24) - (sub >>> 24));
            int n2 = d + 1;
            dest[n2] = dest[n2] + ((add >>> 16 & 0xFF) - (sub >>> 16 & 0xFF));
            int n3 = d + 2;
            dest[n3] = dest[n3] + ((add >>> 8 & 0xFF) - (sub >>> 8 & 0xFF));
            int n4 = d + 3;
            dest[n4] = dest[n4] + ((add & 0xFF) - (sub & 0xFF));
            d += 4;
            ++addline;
            ++subline;
        }
    }

    private static final void addSubVertSum16_d(int[] dest, int[] s, int addline, int subline, int len) {
        int d = 0;
        len += addline;
        while (addline < len) {
            int add = s[addline];
            int sub = s[subline];
            int add_a = add >>> 24;
            int sub_a = sub >>> 24;
            int n = d + 0;
            dest[n] = dest[n] + (add_a - sub_a);
            add_a += add_a >>> 7;
            sub_a += sub_a >>> 7;
            int n2 = d + 1;
            dest[n2] = dest[n2] + (((add >>> 16 & 0xFF) * add_a >>> 8) - ((sub >>> 16 & 0xFF) * sub_a >>> 8));
            int n3 = d + 2;
            dest[n3] = dest[n3] + (((add >>> 8 & 0xFF) * add_a >>> 8) - ((sub >>> 8 & 0xFF) * sub_a >>> 8));
            int n4 = d + 3;
            dest[n4] = dest[n4] + (((add & 0xFF) * add_a >>> 8) - ((sub & 0xFF) * sub_a >>> 8));
            d += 4;
            ++addline;
            ++subline;
        }
    }

    private static final void doBoxBlurAvg16(int[] dest, int desti, int[] sum, int[] vert_sum, int addi, int subi, int n, int len) {
        int rcp = 65536 / n;
        int half_n = n >>> 1;
        addi <<= 2;
        subi <<= 2;
        len += desti;
        while (desti < len) {
            dest[desti] = ((sum[0] + half_n) * rcp >>> 16 << 24) + ((sum[1] + half_n) * rcp >>> 16 << 16) + ((sum[2] + half_n) * rcp >>> 16 << 8) + ((sum[3] + half_n) * rcp >>> 16);
            sum[0] = sum[0] + (vert_sum[addi + 0] - vert_sum[subi + 0]);
            sum[1] = sum[1] + (vert_sum[addi + 1] - vert_sum[subi + 1]);
            sum[2] = sum[2] + (vert_sum[addi + 2] - vert_sum[subi + 2]);
            sum[3] = sum[3] + (vert_sum[addi + 3] - vert_sum[subi + 3]);
            ++desti;
            addi += 4;
            subi += 4;
        }
    }

    private static final void doBoxBlurAvg16_d(int[] dest, int desti, int[] sum, int[] vert_sum, int addi, int subi, int n, int len) {
        byte[] table = CustomOperationComposite.DivTable;
        int rcp = 65536 / n;
        int half_n = n >>> 1;
        addi <<= 2;
        subi <<= 2;
        len += desti;
        while (desti < len) {
            int a = (sum[0] + half_n) * rcp >>> 16;
            int t = a << 8;
            int r = sum[1];
            int g = sum[2];
            int b = sum[3];
            r = table[t + ((r + half_n) * rcp >>> 16)] & 0xFF;
            g = table[t + ((g + half_n) * rcp >>> 16)] & 0xFF;
            b = table[t + ((b + half_n) * rcp >>> 16)] & 0xFF;
            dest[desti] = a << 24 | r << 16 | g << 8 | b;
            sum[0] = sum[0] + (vert_sum[addi + 0] - vert_sum[subi + 0]);
            sum[1] = sum[1] + (vert_sum[addi + 1] - vert_sum[subi + 1]);
            sum[2] = sum[2] + (vert_sum[addi + 2] - vert_sum[subi + 2]);
            sum[3] = sum[3] + (vert_sum[addi + 3] - vert_sum[subi + 3]);
            ++desti;
            addi += 4;
            subi += 4;
        }
    }

    public void adjustGamma(Rect rect, GammaAdjustTempData tmp) throws TJSException {
        int w = this.mImage.getWidth();
        WritableRaster src = this.mImage.getRaster();
        DataBuffer buff = src.getDataBuffer();
        int type = buff.getDataType();
        if (type == 3) {
            DataBufferInt srcBuff = (DataBufferInt)buff;
            byte[] R = tmp.R;
            byte[] G = tmp.G;
            byte[] B = tmp.B;
            int[] s = srcBuff.getData();
            int ystart = rect.top * w + rect.left;
            int rw = rect.right - rect.left;
            int rh = rect.bottom - rect.top;
            int y = 0;
            while (y < rh) {
                int sp = ystart;
                int x = 0;
                while (x < rw) {
                    int d1 = s[sp];
                    int a = d1 & 0xFF000000;
                    if (a != 0) {
                        int t1 = B[d1 & 0xFF] & 0xFF;
                        t1 |= (G[(d1 >>>= 8) & 0xFF] & 0xFF) << 8;
                        t1 |= (R[(d1 >>>= 8) & 0xFF] & 0xFF) << 16;
                        s[sp] = t1 |= a;
                    }
                    ++sp;
                    ++x;
                }
                ystart += w;
                ++y;
            }
        } else {
            throw new TJSException("Not support image type.");
        }
    }

    public void adjustGammaForAdditiveAlpha(Rect rect, GammaAdjustTempData tmp) throws TJSException {
        int w = this.mImage.getWidth();
        WritableRaster src = this.mImage.getRaster();
        DataBuffer buff = src.getDataBuffer();
        int type = buff.getDataType();
        if (type == 3) {
            DataBufferInt srcBuff = (DataBufferInt)buff;
            byte[] R = tmp.R;
            byte[] G = tmp.G;
            byte[] B = tmp.B;
            short[] table = CustomOperationComposite.RecipTable256_16;
            int[] s = srcBuff.getData();
            int ystart = rect.top * w + rect.left;
            int rw = rect.right - rect.left;
            int rh = rect.bottom - rect.top;
            int y = 0;
            while (y < rh) {
                int sp = ystart;
                int x = 0;
                while (x < rw) {
                    int d = s[sp];
                    int a = d & 0xFF000000;
                    if (a == -16777216) {
                        int t1 = B[d & 0xFF] & 0xFF;
                        t1 |= (G[(d >>>= 8) & 0xFF] & 0xFF) << 8;
                        t1 |= (R[(d >>>= 8) & 0xFF] & 0xFF) << 16;
                        s[sp] = t1 |= a;
                    } else if (a != 0) {
                        int alpha = a >>> 24;
                        int alpha_adj = alpha + (alpha >>> 7);
                        short recip = table[alpha];
                        int t = d & 0xFF;
                        int d_tmp = t > alpha ? (B[255] * alpha_adj >>> 8) + t - alpha : B[recip * t >>> 8] * alpha_adj >>> 8;
                        t = d >>> 8 & 0xFF;
                        d_tmp = t > alpha ? (d_tmp |= (G[255] * alpha_adj >>> 8) + t - alpha << 8) : (d_tmp |= G[recip * t >>> 8] * alpha_adj >>> 8 << 8);
                        t = d >>> 16 & 0xFF;
                        d_tmp = t > alpha ? (d_tmp |= (R[255] * alpha_adj >>> 8) + t - alpha << 16) : (d_tmp |= R[recip * t >>> 8] * alpha_adj >>> 8 << 16);
                        s[sp] = d_tmp |= a;
                    }
                    ++sp;
                    ++x;
                }
                ystart += w;
                ++y;
            }
        } else {
            throw new TJSException("Not support image type.");
        }
    }

    public void doGrayScale(Rect rect) throws TJSException {
        int w = this.mImage.getWidth();
        WritableRaster src = this.mImage.getRaster();
        DataBuffer buff = src.getDataBuffer();
        int type = buff.getDataType();
        if (type == 3) {
            DataBufferInt srcBuff = (DataBufferInt)buff;
            int[] s = srcBuff.getData();
            int ystart = rect.top * w + rect.left;
            int rw = rect.right - rect.left;
            int rh = rect.bottom - rect.top;
            int y = 0;
            while (y < rh) {
                int sp = ystart;
                int x = 0;
                while (x < rw) {
                    int s1 = s[sp];
                    int d1 = (s1 & 0xFF) * 19;
                    d1 += (s1 >>> 8 & 0xFF) * 183;
                    d1 += (s1 >>> 16 & 0xFF) * 54;
                    s[sp] = d1 = (d1 >>> 8) * 65793 + (s1 & 0xFF000000);
                    ++sp;
                    ++x;
                }
                ystart += w;
                ++y;
            }
        } else {
            throw new TJSException("Not support image type.");
        }
    }

    public void drawFontImage(byte[] bp, int pitch, Rect srect, Rect drect, int color, int bltmode, int opa, boolean holdalpha) throws TJSException {
        int sh = drect.bottom - drect.top;
        int sw = drect.right - drect.left;
        int so = pitch * srect.top + srect.left;
        int w = this.mImage.getWidth();
        WritableRaster src = this.mImage.getRaster();
        DataBuffer buff = src.getDataBuffer();
        int type = buff.getDataType();
        if (type == 3) {
            DataBufferInt srcBuff = (DataBufferInt)buff;
            int[] s = srcBuff.getData();
            int ystart = drect.top * w + drect.left;
            int rw = drect.right - drect.left;
            int rh = drect.bottom - drect.top;
            int c1 = color & 0xFF00FF;
            color &= 0xFF00;
            if (bltmode == 3) {
                if (opa > 0) {
                    byte[] otable = CustomOperationComposite.OpacityOnOpacityTable65;
                    byte[] ntable = CustomOperationComposite.NegativeMulTable65;
                    if (opa == 255) {
                        int y = 0;
                        while (y < rh) {
                            int dp = ystart;
                            int sp = so;
                            int x = 0;
                            while (x < rw) {
                                int d = s[dp];
                                byte s1 = bp[sp];
                                int addr = (s1 << 8) + (d >>> 24);
                                int destalpha = (ntable[addr] & 0xFF) << 24;
                                int sopa = otable[addr] & 0xFF;
                                int d1 = d & 0xFF00FF;
                                d1 = d1 + ((c1 - d1) * sopa >>> 8) & 0xFF00FF;
                                s[dp] = d1 | (d &= 0xFF00) + ((color - d) * sopa >>> 8) & 0xFF00 | destalpha;
                                ++sp;
                                ++dp;
                                ++x;
                            }
                            ystart += w;
                            so += pitch;
                            ++y;
                        }
                    } else {
                        int y = 0;
                        while (y < rh) {
                            int dp = ystart;
                            int sp = so;
                            int x = 0;
                            while (x < rw) {
                                int d = s[dp];
                                byte s1 = bp[sp];
                                int addr = (s1 * opa & 0xFF00) + (d >>> 24);
                                int destalpha = (ntable[addr] & 0xFF) << 24;
                                int sopa = otable[addr] & 0xFF;
                                int d1 = d & 0xFF00FF;
                                d1 = d1 + ((c1 - d1) * sopa >>> 8) & 0xFF00FF;
                                s[dp] = d1 + ((d &= 0xFF00) + ((color - d) * sopa >>> 8) & 0xFF00) + destalpha;
                                ++sp;
                                ++dp;
                                ++x;
                            }
                            ystart += w;
                            so += pitch;
                            ++y;
                        }
                    }
                } else if (opa == -255) {
                    int y = 0;
                    while (y < rh) {
                        int dp = ystart;
                        int sp = so;
                        int x = 0;
                        while (x < rw) {
                            int d = s[dp];
                            byte s1 = bp[sp];
                            s[dp] = (d & 0xFFFFFF) + ((d >>> 24) * (64 - s1) << 18 & 0xFF000000);
                            ++sp;
                            ++dp;
                            ++x;
                        }
                        ystart += w;
                        so += pitch;
                        ++y;
                    }
                } else {
                    int strength = -opa;
                    if (strength > 127) {
                        ++strength;
                    }
                    int y = 0;
                    while (y < rh) {
                        int dp = ystart;
                        int sp = so;
                        int x = 0;
                        while (x < rw) {
                            int d = s[dp];
                            byte s1 = bp[sp];
                            s[dp] = (d & 0xFFFFFF) + ((d >>> 24) * (16384 - s1 * strength) << 10 & 0xFF000000);
                            ++sp;
                            ++dp;
                            ++x;
                        }
                        ystart += w;
                        so += pitch;
                        ++y;
                    }
                }
            } else if (bltmode == 14) {
                if (opa == 255) {
                    int y = 0;
                    while (y < rh) {
                        int dp = ystart;
                        int sp = so;
                        int x = 0;
                        while (x < rw) {
                            int s1;
                            int d = s[dp];
                            int s_tmp = s1 = bp[sp];
                            int tmp = (s_tmp * (c1 & 0xFF00FF) >>> 6 & 0xFF00FF) + (s_tmp * (color & 0xFF00) >>> 6 & 0xFF00);
                            s_tmp <<= 2;
                            s_tmp -= s_tmp >>> 8;
                            int sopa_inv = s_tmp ^ 0xFF;
                            int dopa = d >>> 24;
                            dopa = dopa + s_tmp - (dopa * s_tmp >>> 8);
                            dopa -= dopa >>> 8;
                            int a = ((d & 0xFF00FF) * sopa_inv >>> 8 & 0xFF00FF) + ((d & 0xFF00) * sopa_inv >>> 8 & 0xFF00);
                            int b = tmp;
                            int tmp1 = (a & b) + ((a ^ b) >>> 1 & 0x7F7F7F7F) & 0x80808080;
                            tmp1 = (tmp1 << 1) - (tmp1 >>> 7);
                            tmp1 = a + b - tmp1 | tmp1;
                            s[dp] = (dopa << 24) + tmp1;
                            ++sp;
                            ++dp;
                            ++x;
                        }
                        ystart += w;
                        so += pitch;
                        ++y;
                    }
                } else {
                    int y = 0;
                    while (y < rh) {
                        int dp = ystart;
                        int sp = so;
                        int x = 0;
                        while (x < rw) {
                            int d = s[dp];
                            byte s1 = bp[sp];
                            int s_tmp = s1 * opa >>> 8;
                            int tmp = (s_tmp * (c1 & 0xFF00FF) >>> 6 & 0xFF00FF) + (s_tmp * (color & 0xFF00) >>> 6 & 0xFF00);
                            s_tmp <<= 2;
                            s_tmp -= s_tmp >>> 8;
                            int sopa_inv = s_tmp ^ 0xFF;
                            int dopa = d >>> 24;
                            dopa = dopa + s_tmp - (dopa * s_tmp >>> 8);
                            dopa -= dopa >>> 8;
                            int a = ((d & 0xFF00FF) * sopa_inv >>> 8 & 0xFF00FF) + ((d & 0xFF00) * sopa_inv >>> 8 & 0xFF00);
                            int b = tmp;
                            int tmp1 = (a & b) + ((a ^ b) >>> 1 & 0x7F7F7F7F) & 0x80808080;
                            tmp1 = (tmp1 << 1) - (tmp1 >>> 7);
                            tmp1 = a + b - tmp1 | tmp1;
                            s[dp] = (dopa << 24) + tmp1;
                            ++sp;
                            ++dp;
                            ++x;
                        }
                        ystart += w;
                        so += pitch;
                        ++y;
                    }
                }
            } else if (opa == 255) {
                if (holdalpha) {
                    int y = 0;
                    while (y < rh) {
                        int dp = ystart;
                        int sp = so;
                        int x = 0;
                        while (x < rw) {
                            byte s1;
                            int d = s[dp];
                            byte sopa = s1 = bp[sp];
                            int d1 = d & 0xFF00FF;
                            d1 = (d1 + ((c1 - d1) * sopa >>> 6) & 0xFF00FF) + (d & 0xFF000000);
                            s[dp] = d1 | (d &= 0xFF00) + ((color - d) * sopa >>> 6) & 0xFF00;
                            ++sp;
                            ++dp;
                            ++x;
                        }
                        ystart += w;
                        so += pitch;
                        ++y;
                    }
                } else {
                    int y = 0;
                    while (y < rh) {
                        int dp = ystart;
                        int sp = so;
                        int x = 0;
                        while (x < rw) {
                            byte s1;
                            int d = s[dp];
                            byte sopa = s1 = bp[sp];
                            int d1 = d & 0xFF00FF;
                            d1 = d1 + ((c1 - d1) * sopa >>> 6) & 0xFF00FF;
                            s[dp] = d1 | (d &= 0xFF00) + ((color - d) * sopa >>> 6) & 0xFF00 | 0xFF000000;
                            ++sp;
                            ++dp;
                            ++x;
                        }
                        ystart += w;
                        so += pitch;
                        ++y;
                    }
                }
            } else if (holdalpha) {
                int y = 0;
                while (y < rh) {
                    int dp = ystart;
                    int sp = so;
                    int x = 0;
                    while (x < rw) {
                        int d = s[dp];
                        byte s1 = bp[sp];
                        int sopa = s1 * opa >>> 8;
                        int d1 = d & 0xFF00FF;
                        d1 = (d1 + ((c1 - d1) * sopa >>> 6) & 0xFF00FF) + (d & 0xFF000000);
                        s[dp] = d1 | (d &= 0xFF00) + ((color - d) * sopa >>> 6) & 0xFF00;
                        ++sp;
                        ++dp;
                        ++x;
                    }
                    ystart += w;
                    so += pitch;
                    ++y;
                }
            } else {
                int y = 0;
                while (y < rh) {
                    int dp = ystart;
                    int sp = so;
                    int x = 0;
                    while (x < rw) {
                        int d = s[dp];
                        byte s1 = bp[sp];
                        int sopa = s1 * opa >>> 8;
                        int d1 = d & 0xFF00FF;
                        d1 = d1 + ((c1 - d1) * sopa >>> 6) & 0xFF00FF;
                        s[dp] = d1 | (d &= 0xFF00) + ((color - d) * sopa >>> 6) & 0xFF00;
                        ++sp;
                        ++dp;
                        ++x;
                    }
                    ystart += w;
                    so += pitch;
                    ++y;
                }
            }
        } else {
            throw new TJSException("Not support image type.");
        }
    }

    private static final void bubbleSort(int[] a, int n) {
        int i = 0;
        while (i < n - 1) {
            int j = n - 1;
            while (j > i) {
                int prev = a[j - 1];
                int cur = a[j];
                if (prev > cur) {
                    a[j] = prev;
                    a[j - 1] = cur;
                }
                --j;
            }
            ++i;
        }
    }

    public void makeAlphaFromAdaptiveColor() throws TJSException {
        int maxlencolor;
        int[] s;
        int w = this.mImage.getWidth();
        WritableRaster src = this.mImage.getRaster();
        DataBuffer buff = src.getDataBuffer();
        int type = buff.getDataType();
        if (type == 3) {
            DataBufferInt srcBuff = (DataBufferInt)buff;
            s = srcBuff.getData();
            int[] buffer = new int[w];
            int i = 0;
            while (i < w) {
                buffer[i] = s[i] & 0xFFFFFF;
                ++i;
            }
            NativeImageBuffer.bubbleSort(buffer, w);
            int maxlen = 0;
            maxlencolor = -1;
            int pcolor = -1;
            int l = 0;
            int i2 = 0;
            while (i2 < w + 1) {
                if (buffer[i2] != pcolor) {
                    if (maxlen < l) {
                        maxlen = l;
                        maxlencolor = pcolor;
                        l = 0;
                    }
                } else {
                    ++l;
                }
                pcolor = buffer[i2];
                ++i2;
            }
            if (maxlencolor == -1) {
                maxlencolor = 0;
            }
        } else {
            throw new TJSException("Not support image type.");
        }
        this.makeAlphaFromKey(s, maxlencolor);
    }

    private void makeAlphaFromKey(int[] s, int key) {
        int count = s.length;
        int i = 0;
        while (i < count) {
            int a = s[i] & 0xFFFFFF;
            if (a != key) {
                a |= 0xFF000000;
            }
            s[i] = a;
            ++i;
        }
    }

    public void makeAlphaFromKeyColor(int color) throws TJSException {
        WritableRaster src = this.mImage.getRaster();
        DataBuffer buff = src.getDataBuffer();
        int type = buff.getDataType();
        if (type != 3) {
            throw new TJSException("Not support image type.");
        }
        DataBufferInt srcBuff = (DataBufferInt)buff;
        int[] s = srcBuff.getData();
        this.makeAlphaFromKey(s, color &= 0xFFFFFF);
    }

    public void doAlphaColorMat(int color) throws TJSException {
        WritableRaster src = this.mImage.getRaster();
        DataBuffer buff = src.getDataBuffer();
        int type = buff.getDataType();
        if (type == 3) {
            DataBufferInt srcBuff = (DataBufferInt)buff;
            int[] dest = srcBuff.getData();
            int length = dest.length;
            int i = 0;
            while (i < length) {
                int s = dest[i];
                int d = color;
                int sopa = s >>> 24;
                int d1 = d & 0xFF00FF;
                d1 = d1 + (((s & 0xFF00FF) - d1) * sopa >>> 8) & 0xFF00FF;
                dest[i] = d1 + ((d &= 0xFF00) + (((s &= 0xFF00) - d) * sopa >>> 8) & 0xFF00) + -16777216;
                ++i;
            }
        } else {
            throw new TJSException("Not support image type.");
        }
    }

    public void toMutable() {
    }

    public boolean isImageAllocated() {
        return true;
    }

    public void purgeImage() {
    }
}

