/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2env;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.imageio.ImageIO;
import jp.kirikiri.tjs2.BinaryStream;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.msg.Message;
import jp.kirikiri.tvp2env.NativeImageBuffer;
import jp.kirikiri.tvp2env.TLGLoader;

public class NativeImageLoader {
    public static BufferedImage loadImage(InputStream stream) {
        try {
            BufferedImage img = null;
            img = ImageIO.read(stream);
            return img;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static NativeImageBuffer loadImage(BinaryStream stream, String ext, HashMap<String, String> metainfo, int keyidx, int mode) throws TJSException {
        BufferedImage img = null;
        if (".tlg".equalsIgnoreCase(ext) || ".tlg5".equalsIgnoreCase(ext) || ".tlg6".equalsIgnoreCase(ext)) {
            img = TLGLoader.loadTLG(stream, mode, metainfo);
        }
        if (img == null) {
            try {
                img = ImageIO.read(stream.getInputStream());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (img == null) {
            return null;
        }
        if (mode == 0) {
            int imgType = img.getType();
            if (imgType != 2 && imgType != 3) {
                ColorModel model;
                int transparentColor = -1;
                if (imgType == 13 && keyidx != -1 && (model = img.getColorModel()) instanceof IndexColorModel) {
                    IndexColorModel indexColor = (IndexColorModel)model;
                    int indexSize = indexColor.getMapSize();
                    int[] palette = new int[indexSize];
                    indexColor.getRGBs(palette);
                    if (keyidx < palette.length) {
                        transparentColor = palette[keyidx];
                    }
                }
                BufferedImage img2 = new BufferedImage(img.getWidth(), img.getHeight(), 2);
                Graphics2D g = img2.createGraphics();
                g.drawImage((Image)img, 0, 0, null);
                g.dispose();
                img = img2;
                if (transparentColor != -1) {
                    WritableRaster src = img.getRaster();
                    DataBuffer buff = src.getDataBuffer();
                    int type = buff.getDataType();
                    if (type == 3) {
                        DataBufferInt srcBuff = (DataBufferInt)buff;
                        int[] s = srcBuff.getData();
                        int color = transparentColor & 0xFFFFFF;
                        int count = s.length;
                        int i = 0;
                        while (i < count) {
                            int a = s[i] & 0xFFFFFF;
                            if (a != color) {
                                a |= 0xFF000000;
                            }
                            s[i] = a;
                            ++i;
                        }
                        s = null;
                        srcBuff = null;
                    }
                    buff = null;
                    src = null;
                }
            }
        } else if (mode == 1 && img.getType() != 13) {
            Message.throwExceptionMessage("\u753b\u50cf\u8aad\u307f\u8fbc\u307f\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f/%1", "Unsupported color mode for palettized image.");
        }
        return new NativeImageBuffer(img);
    }
}

