/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2env;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import jp.kirikiri.tjs2.BinaryStream;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.msg.Message;

public class PNGLoader {
    private static final long PNG_SIGNATURE = -8552249625308161526L;
    private static final int IHDR_CHUNK = 1229472850;
    private static final int IHDR_CHUNK_SIZE = 13;
    private static final int CRC_SIZE = 4;
    private static final int PLTE_CHUNK = 1347179589;
    private static final int IDAT_CHUNK = 1229209940;
    private static final int IEND_CHUNK = 1229278788;
    private static final int COLOR_TYPE_GRAYSCALE = 0;
    private static final int COLOR_TYPE_RGB = 2;
    private static final int COLOR_TYPE_PALETTE = 3;
    private static final int COLOR_TYPE_GRAYSCALE_ALPHA = 4;
    private static final int COLOR_TYPE_RGB_ALPHA = 6;
    private static final int INTERLACE_TYPE_NON = 0;
    private static final int INTERLACE_TYPE_ADAM7 = 1;
    private static final int FILTER_TYPE_NON = 0;
    private static final int FILTER_TYPE_SUB = 1;
    private static final int FILTER_TYPE_UP = 2;
    private static final int FILTER_TYPE_AVERAGE = 3;
    private static final int FILTER_TYPE_PAETH = 4;
    private static Inflater Decompresser;

    public static void initialize() {
        Decompresser = null;
    }

    public static void finalizeApplication() {
        Decompresser = null;
    }

    public static BufferedImage loadPNG(BinaryStream src, int mode) throws TJSException {
        BufferedImage result;
        block45: {
            int o;
            int p;
            int stride;
            byte[] image;
            byte colortype;
            byte bitdepth;
            int height;
            int width;
            block43: {
                int[] palette;
                block47: {
                    block46: {
                        block44: {
                            int chunk_header;
                            if (Decompresser == null) {
                                Decompresser = new Inflater();
                            }
                            byte[] mark = new byte[8];
                            src.read(mark);
                            ByteBuffer buff = ByteBuffer.wrap(mark);
                            buff.order(ByteOrder.BIG_ENDIAN);
                            buff.position(0);
                            long sig = buff.getLong();
                            if (sig != -8552249625308161526L) {
                                Message.throwExceptionMessage("It's not PNG file.");
                            }
                            src.read(mark);
                            buff.position(0);
                            int size = buff.getInt();
                            if (size != 13) {
                                Message.throwExceptionMessage("Invalidate IHDR chunk size.");
                            }
                            if ((chunk_header = buff.getInt()) != 1229472850) {
                                Message.throwExceptionMessage("Invalidate PNG file.");
                            }
                            byte[] ihdr = new byte[17];
                            src.read(ihdr);
                            ByteBuffer chunkbuff = ByteBuffer.wrap(ihdr);
                            chunkbuff.order(ByteOrder.BIG_ENDIAN);
                            chunkbuff.position(0);
                            width = chunkbuff.getInt();
                            height = chunkbuff.getInt();
                            bitdepth = chunkbuff.get();
                            colortype = chunkbuff.get();
                            byte compresstype = chunkbuff.get();
                            byte filtertype = chunkbuff.get();
                            byte interlacetype = chunkbuff.get();
                            if (compresstype != 0 || filtertype != 0 || interlacetype != 0 && interlacetype != 1) {
                                Message.throwExceptionMessage("Invalidate Image format.");
                            }
                            if (interlacetype == 1) {
                                Message.throwExceptionMessage("Not supported interlace Adam7.");
                            }
                            if (colortype != 3 && colortype != 0) {
                                Message.throwExceptionMessage("Not supported color type.");
                            }
                            image = null;
                            palette = null;
                            long filesize = src.getSize();
                            block5: while (src.getPosition() <= filesize) {
                                src.read(mark);
                                buff.position(0);
                                size = buff.getInt();
                                chunk_header = buff.getInt();
                                switch (chunk_header) {
                                    case 1347179589: {
                                        palette = PNGLoader.readPalette(src, size);
                                        break;
                                    }
                                    case 1229209940: {
                                        image = PNGLoader.readImage(src, palette, size, width, height, bitdepth, colortype);
                                        src.setPosition(src.getPosition() + (long)size + 4L);
                                        break;
                                    }
                                    case 1229278788: {
                                        break block5;
                                    }
                                    default: {
                                        char c0 = (char)(chunk_header >>> 24 & 0xFF);
                                        char c1 = (char)(chunk_header >>> 16 & 0xFF);
                                        char c2 = (char)(chunk_header >>> 8 & 0xFF);
                                        char c3 = (char)(chunk_header & 0xFF);
                                        System.out.print("Ignore Chunk : " + c0 + c1 + c2 + c3 + "\n");
                                        src.setPosition(src.getPosition() + (long)size + 4L);
                                    }
                                }
                            }
                            if (image == null) {
                                Message.throwExceptionMessage("Internal error.");
                            }
                            result = new BufferedImage(width, height, 2);
                            int[] imagedata = null;
                            WritableRaster srcRaster = result.getRaster();
                            DataBuffer dataBuff = srcRaster.getDataBuffer();
                            int type = dataBuff.getDataType();
                            if (type == 3) {
                                DataBufferInt srcBuff = (DataBufferInt)dataBuff;
                                imagedata = srcBuff.getData();
                            } else {
                                Message.throwExceptionMessage("Internal error.");
                            }
                            stride = width * bitdepth + 7 >>> 3;
                            p = 0;
                            o = 0;
                            if (colortype != 3) break block43;
                            if (palette == null) {
                                Message.throwExceptionMessage("Internal error.");
                            }
                            if (bitdepth != 8) break block44;
                            int y = 0;
                            while (y < height) {
                                int x = 0;
                                while (x < width) {
                                    int idx = image[p] & 0xFF;
                                    ++p;
                                    imagedata[o] = palette[idx];
                                    ++o;
                                    ++x;
                                }
                                ++y;
                            }
                            break block45;
                        }
                        if (bitdepth != 4) break block46;
                        int y = 0;
                        while (y < height) {
                            int x = 0;
                            while (x < stride) {
                                int idx = image[p] & 0xFF;
                                ++p;
                                int h = idx >>> 4;
                                int l = idx & 0xF;
                                imagedata[o] = palette[h];
                                imagedata[++o] = palette[l];
                                ++o;
                                ++x;
                            }
                            ++y;
                        }
                        break block45;
                    }
                    if (bitdepth != 2) break block47;
                    int y = 0;
                    while (y < height) {
                        int x = 0;
                        while (x < stride) {
                            int idx = image[p] & 0xFF;
                            ++p;
                            int i0 = idx >>> 6;
                            int i1 = idx >>> 4 & 3;
                            int i2 = idx >>> 2 & 3;
                            int i3 = idx & 3;
                            imagedata[o] = palette[i0];
                            imagedata[++o] = palette[i1];
                            imagedata[++o] = palette[i2];
                            imagedata[++o] = palette[i3];
                            ++o;
                            ++x;
                        }
                        ++y;
                    }
                    break block45;
                }
                if (bitdepth != 1) break block45;
                int y = 0;
                while (y < height) {
                    int x = 0;
                    while (x < stride) {
                        int idx = image[p] & 0xFF;
                        ++p;
                        int b = 7;
                        while (b >= 0) {
                            int b0 = idx >>> b & 1;
                            imagedata[o] = palette[b0];
                            ++o;
                            --b;
                        }
                        ++x;
                    }
                    ++y;
                }
                break block45;
            }
            if (colortype == 0) {
                if (bitdepth == 8) {
                    int y = 0;
                    while (y < height) {
                        int x = 0;
                        while (x < width) {
                            int col = image[p] & 0xFF;
                            ++p;
                            imagedata[o] = 0xFF000000 | col << 16 | col << 8 | col;
                            ++o;
                            ++x;
                        }
                        ++y;
                    }
                } else if (bitdepth == 4) {
                    int y = 0;
                    while (y < height) {
                        int x = 0;
                        while (x < stride) {
                            int idx = image[p] & 0xFF;
                            ++p;
                            int col = idx >>> 4;
                            imagedata[o] = 0xFF000000 | col << 16 | col << 8 | col;
                            col = idx & 0xF;
                            imagedata[++o] = 0xFF000000 | col << 16 | col << 8 | col;
                            ++o;
                            ++x;
                        }
                        ++y;
                    }
                } else if (bitdepth == 2) {
                    int y = 0;
                    while (y < height) {
                        int x = 0;
                        while (x < stride) {
                            int idx = image[p] & 0xFF;
                            ++p;
                            int col = idx >>> 6;
                            imagedata[o] = 0xFF000000 | col << 16 | col << 8 | col;
                            col = idx >>> 4 & 3;
                            imagedata[++o] = 0xFF000000 | col << 16 | col << 8 | col;
                            col = idx >>> 2 & 3;
                            imagedata[++o] = 0xFF000000 | col << 16 | col << 8 | col;
                            col = idx & 3;
                            imagedata[++o] = 0xFF000000 | col << 16 | col << 8 | col;
                            ++o;
                            ++x;
                        }
                        ++y;
                    }
                } else if (bitdepth == 1) {
                    int y = 0;
                    while (y < height) {
                        int x = 0;
                        while (x < stride) {
                            int idx = image[p] & 0xFF;
                            ++p;
                            int b = 7;
                            while (b >= 0) {
                                int col = idx >>> b & 1;
                                imagedata[o] = 0xFF000000 | col << 16 | col << 8 | col;
                                ++o;
                                --b;
                            }
                            ++x;
                        }
                        ++y;
                    }
                }
            }
        }
        return result;
    }

    private static byte[] readImage(BinaryStream src, int[] palette, int size, int width, int height, byte bitdepth, byte colortype) throws TJSException {
        int bpp;
        int stride = width * bitdepth + 7 >>> 3;
        int imagebuffsize = stride * height + height;
        byte[] idat = new byte[size];
        src.read(idat);
        src.setPosition(src.getPosition() + 4L);
        byte[] buffer = new byte[imagebuffsize];
        int len = PNGLoader.decompressData(buffer, idat);
        if (len < stride) {
            Message.throwExceptionMessage("Invalidate IDAT size .");
        }
        if ((bpp = bitdepth >>> 3) <= 0) {
            bpp = 1;
        }
        byte[] output = new byte[stride * height];
        int p = 0;
        int o = 0;
        byte filtertype = buffer[p];
        ++p;
        switch (filtertype) {
            case 0: 
            case 2: {
                int x = 0;
                while (x < stride) {
                    output[o] = buffer[p];
                    ++p;
                    ++o;
                    ++x;
                }
                break;
            }
            case 1: 
            case 4: {
                int idx;
                int prev = 0;
                int x = 0;
                while (x < stride) {
                    idx = buffer[p] & 0xFF;
                    ++p;
                    prev = idx = idx + prev & 0xFF;
                    output[o] = (byte)idx;
                    ++o;
                    ++x;
                }
                break;
            }
            case 3: {
                int idx;
                int prev = 0;
                int x = 0;
                while (x < stride) {
                    idx = buffer[p] & 0xFF;
                    ++p;
                    prev = idx = idx + prev >>> 1 & 0xFF;
                    output[o] = (byte)idx;
                    ++o;
                    ++x;
                }
                break;
            }
            default: {
                Message.throwExceptionMessage("Unknown scanline filter type.");
            }
        }
        int u = 0;
        int y = 1;
        while (y < height) {
            filtertype = buffer[p];
            ++p;
            switch (filtertype) {
                case 0: {
                    int x = 0;
                    while (x < stride) {
                        output[o] = buffer[p];
                        ++p;
                        ++o;
                        ++x;
                    }
                    u += stride;
                    break;
                }
                case 1: {
                    int idx;
                    int lett = 0;
                    int x = 0;
                    while (x < stride) {
                        idx = buffer[p] & 0xFF;
                        ++p;
                        lett = idx = idx + lett & 0xFF;
                        output[o] = (byte)idx;
                        ++o;
                        ++x;
                    }
                    u += stride;
                    break;
                }
                case 2: {
                    int x = 0;
                    while (x < stride) {
                        int idx = buffer[p] & 0xFF;
                        ++p;
                        int up = output[u] & 0xFF;
                        ++u;
                        idx = idx + up & 0xFF;
                        output[o] = (byte)idx;
                        ++o;
                        ++x;
                    }
                    break;
                }
                case 3: {
                    int idx;
                    int left = 0;
                    int x = 0;
                    while (x < stride) {
                        idx = buffer[p] & 0xFF;
                        ++p;
                        int up = output[u] & 0xFF;
                        ++u;
                        left = idx = idx + (left + up >>> 1) & 0xFF;
                        output[o] = (byte)idx;
                        ++o;
                        ++x;
                    }
                    break;
                }
                case 4: {
                    int left = 0;
                    int upleft = 0;
                    int x = 0;
                    while (x < stride) {
                        int idx = buffer[p] & 0xFF;
                        ++p;
                        int up = output[u] & 0xFF;
                        ++u;
                        int pp = left + up - upleft;
                        int pa = Math.abs(pp - left);
                        int pb = Math.abs(pp - up);
                        int pc = Math.abs(pp - upleft);
                        int v = pa <= pb && pa <= pc ? left : (pb <= pc ? up : upleft);
                        upleft = up;
                        left = idx = idx + v & 0xFF;
                        output[o] = (byte)idx;
                        ++o;
                        ++x;
                    }
                    break;
                }
                default: {
                    Message.throwExceptionMessage("Unknown scanline filter type.");
                }
            }
            ++y;
        }
        return output;
    }

    private static int decompressData(byte[] output, byte[] indata) throws TJSException {
        int destlen = 0;
        try {
            try {
                Decompresser.setInput(indata);
                destlen = Decompresser.inflate(output);
                Decompresser.reset();
            }
            catch (DataFormatException e) {
                Message.throwExceptionMessage("\u30d5\u30a1\u30a4\u30eb\u306e\u5c55\u958b\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u672a\u5bfe\u5fdc\u306e\u5727\u7e2e\u5f62\u5f0f\u304c\u6307\u5b9a\u3055\u308c\u305f\u304b\u3001\u3042\u308b\u3044\u306f\u30d5\u30a1\u30a4\u30eb\u304c\u7834\u640d\u3057\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059");
                indata = null;
            }
        }
        finally {
            indata = null;
        }
        return destlen;
    }

    private static int[] readPalette(BinaryStream src, int size) throws TJSException {
        if (size % 3 != 0) {
            Message.throwExceptionMessage("Invalidate PLTE chunk size.");
        }
        byte[] pal = new byte[size + 4];
        src.read(pal);
        int len = size / 3;
        int[] result = new int[len];
        int p = 0;
        int i = 0;
        while (i < len) {
            int color;
            result[i] = color = 0xFF000000 | (pal[p] & 0xFF) << 16 | (pal[p + 1] & 0xFF) << 8 | pal[p + 2] & 0xFF;
            p += 3;
            ++i;
        }
        return result;
    }
}

