/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2env;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import jp.kirikiri.tvp2.visual.LayerNI;
import jp.kirikiri.tvp2env.Font;

public class PadForm
extends JFrame {
    private static final long serialVersionUID = -193457542364045737L;
    private static final int DEFAULT_WIDTH = 600;
    private static final int DEFAULT_HEIGHT = 400;
    private static final int ssNone = 0;
    private static final int ssHorizontal = 1;
    private static final int ssVertical = 2;
    private static final int ssBoth = 3;
    private JScrollPane mScrollPane;
    private JTextArea mTextArea;
    private JLabel mStatusBar;
    private String mSaveFileName;

    public PadForm() {
        this.getContentPane().setLayout(new BorderLayout());
        this.mTextArea = new JTextArea();
        this.mScrollPane = new JScrollPane(this.mTextArea);
        this.mScrollPane.setVerticalScrollBarPolicy(22);
        this.mScrollPane.setPreferredSize(new Dimension(600, 400));
        this.getContentPane().add((Component)this.mScrollPane, "Center");
        this.mStatusBar = new JLabel();
        this.getContentPane().add((Component)this.mStatusBar, "South");
        this.setDefaultCloseOperation(3);
        this.setSize(600, 400);
    }

    public void setFreeOnTerminate(boolean t) {
    }

    public void setExecButtonEnabled(boolean t) {
    }

    public void setLines(String lines) {
        this.mTextArea.setText(lines);
        JScrollBar bar = this.mScrollPane.getVerticalScrollBar();
        if (bar != null) {
            bar.setMaximum(this.mTextArea.getLineCount());
        }
    }

    public String getLines() {
        return this.mTextArea.getText();
    }

    public void goToLine(int pos) {
        this.mTextArea.setCaretPosition(pos);
        try {
            this.mTextArea.setSelectionStart(this.mTextArea.getLineStartOffset(pos));
            this.mTextArea.setSelectionEnd(this.mTextArea.getLineStartOffset(pos + 1));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        Dimension dim = this.mTextArea.getPreferredScrollableViewportSize();
        int lineheight = dim.height / this.mTextArea.getLineCount();
        int y = lineheight * pos;
        this.mScrollPane.scrollRectToVisible(new Rectangle(0, y, dim.width, lineheight));
    }

    public void setReadOnly(boolean read) {
        this.mTextArea.setEditable(!read);
    }

    public boolean getReadOnly() {
        return !this.mTextArea.isEditable();
    }

    public void setStatusText(String mes) {
        this.mStatusBar.setText(mes);
    }

    public String getStatusText() {
        return this.mStatusBar.getText();
    }

    public void setCaption(String caption) {
        this.setTitle(caption);
    }

    @Override
    public void setVisible(boolean state) {
        super.setVisible(state);
    }

    public boolean getVisible() {
        return this.isVisible();
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
    }

    @Override
    public String getTitle() {
        return super.getTitle();
    }

    public int getEditColor() {
        return this.mTextArea.getBackground().getRGB();
    }

    public void setEditColor(int color) {
        color = LayerNI.toActualColor(color);
        this.mTextArea.setBackground(new Color(color, false));
    }

    public String getFileName() {
        return this.mSaveFileName;
    }

    public void setFileName(String name) {
        this.mSaveFileName = name;
    }

    public int getFontColor() {
        return this.mTextArea.getForeground().getRGB();
    }

    public void setFontColor(int color) {
        color = LayerNI.toActualColor(color);
        this.mTextArea.setForeground(new Color(color, false));
    }

    public int getFontHeight() {
        Font font = new Font(this.mTextArea.getFont());
        return font.getHeight();
    }

    public void setFontHeight(int height) {
        Font font = new Font(this.mTextArea.getFont());
        font.setHeight(height);
        this.mTextArea.setFont(font.getFont());
    }

    public int getFontSize() {
        return this.mTextArea.getFont().getSize();
    }

    public void setFontSize(int size) {
        Font font = new Font(this.mTextArea.getFont());
        font.setHeight(size);
        this.mTextArea.setFont(font.getFont());
    }

    public boolean containsFontStyle(int style) {
        Font font = new Font(this.mTextArea.getFont());
        switch (style) {
            case 1: {
                return font.getItalic();
            }
            case 2: {
                return font.getBold();
            }
            case 4: {
                return font.getUnderline();
            }
            case 8: {
                return font.getStrikeout();
            }
        }
        return false;
    }

    public void addFontStyle(int style) {
        Font font = new Font(this.mTextArea.getFont());
        switch (style) {
            case 1: {
                font.setItalic(true);
                this.mTextArea.setFont(font.getFont());
                break;
            }
            case 2: {
                font.setBold(true);
                this.mTextArea.setFont(font.getFont());
                break;
            }
            case 4: {
                font.setUnderline(true);
                this.mTextArea.setFont(font.getFont());
                break;
            }
            case 8: {
                font.setStrikeout(true);
                this.mTextArea.setFont(font.getFont());
            }
        }
    }

    public void removeFontStyle(int style) {
        Font font = new Font(this.mTextArea.getFont());
        switch (style) {
            case 1: {
                font.setItalic(false);
                this.mTextArea.setFont(font.getFont());
                break;
            }
            case 2: {
                font.setBold(false);
                this.mTextArea.setFont(font.getFont());
                break;
            }
            case 4: {
                font.setUnderline(false);
                this.mTextArea.setFont(font.getFont());
                break;
            }
            case 8: {
                font.setStrikeout(false);
                this.mTextArea.setFont(font.getFont());
            }
        }
    }

    public boolean getFontBold() {
        Font font = new Font(this.mTextArea.getFont());
        return font.getBold();
    }

    public void setFontBold(boolean b) {
        Font font = new Font(this.mTextArea.getFont());
        font.setBold(true);
        this.mTextArea.setFont(font.getFont());
    }

    public boolean getFontItalic() {
        Font font = new Font(this.mTextArea.getFont());
        return font.getItalic();
    }

    public void setFontItalic(boolean b) {
        Font font = new Font(this.mTextArea.getFont());
        font.setItalic(true);
        this.mTextArea.setFont(font.getFont());
    }

    public boolean getFontUnderline() {
        Font font = new Font(this.mTextArea.getFont());
        return font.getUnderline();
    }

    public void setFontUnderline(boolean b) {
        Font font = new Font(this.mTextArea.getFont());
        font.setUnderline(true);
        this.mTextArea.setFont(font.getFont());
    }

    public boolean getFontStrikeOut() {
        Font font = new Font(this.mTextArea.getFont());
        return font.getStrikeout();
    }

    public void setFontStrikeOut(boolean b) {
        Font font = new Font(this.mTextArea.getFont());
        font.setStrikeout(true);
        this.mTextArea.setFont(font.getFont());
    }

    public String getFontName() {
        return this.mTextArea.getFont().getFontName();
    }

    public void setFontName(String name) {
        Font font = new Font(this.mTextArea.getFont());
        font.setFaceName(name);
        this.mTextArea.setFont(font.getFont());
    }

    public boolean getWordWrap() {
        return this.mTextArea.getLineWrap();
    }

    public void setWordWrap(boolean ww) {
        this.mTextArea.setLineWrap(ww);
        this.mTextArea.setWrapStyleWord(ww);
    }

    @Override
    public float getOpacity() {
        return 1.0f;
    }

    public void setOpacity(int opa) {
    }

    public boolean getStatusBarVisible() {
        return this.mStatusBar.isVisible();
    }

    public void setStatusBarVisible(boolean vis) {
        this.mStatusBar.setVisible(vis);
    }

    public int getScrollBarsVisible() {
        JScrollBar vbar = this.mScrollPane.getVerticalScrollBar();
        JScrollBar hbar = this.mScrollPane.getHorizontalScrollBar();
        if (vbar.isVisible() || hbar.isVisible()) {
            if (vbar.isVisible() && hbar.isVisible()) {
                return 3;
            }
            if (vbar.isVisible()) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public void setScrollBarsVisible(int vis) {
        JScrollBar vbar = this.mScrollPane.getVerticalScrollBar();
        JScrollBar hbar = this.mScrollPane.getHorizontalScrollBar();
        switch (vis) {
            case 0: {
                vbar.setVisible(false);
                hbar.setVisible(false);
                break;
            }
            case 1: {
                vbar.setVisible(false);
                hbar.setVisible(true);
                break;
            }
            case 2: {
                vbar.setVisible(true);
                hbar.setVisible(false);
                break;
            }
            case 3: {
                vbar.setVisible(true);
                hbar.setVisible(true);
            }
        }
    }

    public int getBorderStyle() {
        if (this.isResizable()) {
            return 2;
        }
        return 1;
    }

    public void setBorderStyle(int style) {
        switch (style) {
            case 0: {
                this.setResizable(false);
                break;
            }
            case 1: {
                this.setResizable(false);
                break;
            }
            case 2: {
                this.setResizable(true);
                break;
            }
            case 3: {
                this.setResizable(false);
                break;
            }
            case 4: {
                this.setResizable(false);
                break;
            }
            case 5: {
                this.setResizable(true);
            }
        }
    }

    public int getFormHeight() {
        return this.getHeight();
    }

    public int getFormWidth() {
        return this.getWidth();
    }

    public int getFormTop() {
        return this.getY();
    }

    public int getFormLeft() {
        return this.getX();
    }

    public void setFormHeight(int value) {
        this.setSize(this.getWidth(), value);
    }

    public void setFormWidth(int value) {
        this.setSize(value, this.getHeight());
    }

    public void setFormTop(int value) {
        this.setLocation(this.getX(), value);
    }

    public void setFormLeft(int value) {
        this.setLocation(value, this.getY());
    }

    public void setToolBarVisible(boolean b) {
    }

    public void setToolBarEnabled(boolean b) {
    }

    public void setExecuteButtonVisible(boolean b) {
    }

    public void setExecuteButtonEnabled(boolean b) {
    }

    public void setStatusBarLeft(int i) {
    }

    public void setStatusBarWidth(int width) {
    }
}

