/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2env;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.visual.DivisibleData;
import jp.kirikiri.tvp2.visual.DivisibleTransHandler;
import jp.kirikiri.tvp2.visual.ScanLineProvider;
import jp.kirikiri.tvp2.visual.SimpleOptionProvider;

public class RippleTransHandler
implements DivisibleTransHandler {
    private static final int RIPPLE_DIR_PREC = 32;
    private static final int RIPPLE_DRIFT_PREC = 4;
    private long mStartTick;
    private long mTime;
    private int mLayerType;
    private int mWidth;
    private int mHeight;
    private long mCurTime;
    private int mBlendRatio;
    private int mPhase;
    private int mDrift;
    private boolean mFirst;
    private int mDriftCarePixels;
    private int mCenterX;
    private int mCenterY;
    private int mRippleWidth;
    private float mRoundness;
    private float mSpeed;
    private int mMaxDrift;
    private short[] mCurDriftMap;
    private int mDriftMapOffset;
    RippleTable mTable;
    private static RippleTable mCacheTable;

    private static final RippleTable getRippleTable(int width, int height, int centerx, int centery, int ripplewidth, float roundness, int maxdrift) {
        if (mCacheTable == null) {
            mCacheTable = new RippleTable(width, height, centerx, centery, ripplewidth, roundness, maxdrift);
            return mCacheTable;
        }
        RippleTable table = mCacheTable;
        if (table.getWidth() == width && table.getHeight() == height && table.getCenterX() == centerx && table.getCenterY() == centery && table.getRippleWidth() == ripplewidth && table.getRoundness() == roundness && table.getMaxDrift() == maxdrift) {
            return table;
        }
        mCacheTable = null;
        mCacheTable = new RippleTable(width, height, centerx, centery, ripplewidth, roundness, maxdrift);
        return mCacheTable;
    }

    public RippleTransHandler(long time, int layertype, int width, int height, int centerx, int centery, int ripplewidth, float roundness, float speed, int maxdrift) {
        this.mLayerType = layertype;
        this.mWidth = width;
        this.mHeight = height;
        this.mTime = time;
        this.mCenterX = centerx;
        this.mCenterY = centery;
        this.mRippleWidth = ripplewidth;
        this.mRoundness = roundness;
        this.mSpeed = speed;
        this.mFirst = true;
        this.mMaxDrift = maxdrift;
        this.mTable = RippleTransHandler.getRippleTable(this.mWidth, this.mHeight, this.mCenterX, this.mCenterY, this.mRippleWidth, this.mRoundness, this.mMaxDrift);
    }

    @Override
    public int setOption(SimpleOptionProvider options) {
        return 0;
    }

    @Override
    public int startProcess(long tick) {
        if (this.mFirst) {
            this.mFirst = false;
            this.mStartTick = tick;
        }
        this.mCurTime = tick - this.mStartTick;
        this.mBlendRatio = (int)(this.mCurTime * 255L / this.mTime);
        if (this.mBlendRatio > 255) {
            this.mBlendRatio = 255;
        }
        this.mPhase = (int)((double)this.mSpeed * 1.5915494309189535E-4 * (double)this.mCurTime * (double)this.mRippleWidth) % this.mRippleWidth;
        if (this.mPhase < 0) {
            this.mPhase = 0;
        }
        this.mPhase = this.mRippleWidth - this.mPhase - 1;
        float s = (float)Math.sin(Math.PI * (double)this.mCurTime / (double)this.mTime);
        this.mDrift = (int)(s * (float)this.mMaxDrift * 4.0f);
        if (this.mDrift < 0) {
            this.mDrift = 0;
        }
        if (this.mDrift >= this.mMaxDrift * 4) {
            this.mDrift = this.mMaxDrift * 4 - 1;
        }
        this.mDriftCarePixels = this.mDrift / 4 + 1;
        if ((this.mDriftCarePixels & 1) != 0) {
            ++this.mDriftCarePixels;
        }
        this.mCurDriftMap = this.mTable.getDriftMap();
        this.mDriftMapOffset = this.mTable.getDriftMapOffset(this.mDrift, this.mPhase);
        return 1;
    }

    @Override
    public int endProcess() {
        if (this.mBlendRatio == 255) {
            return 2;
        }
        return 1;
    }

    @Override
    public int process(DivisibleData data) {
        BufferedImage dest = (BufferedImage)data.Dest.getScanLineForWrite().getImage();
        BufferedImage src1 = (BufferedImage)data.Src1.getScanLine().getImage();
        BufferedImage src2 = (BufferedImage)data.Src2.getScanLine().getImage();
        int width = data.Width;
        int left = data.Left;
        int right = left + width;
        int destTop = data.DestTop;
        int destpitch = dest.getWidth();
        int src1pitch = src1.getWidth();
        int src2pitch = src2.getWidth();
        DataBuffer destBuff = dest.getRaster().getDataBuffer();
        int destType = destBuff.getDataType();
        DataBuffer src1Buff = src1.getRaster().getDataBuffer();
        int src1Type = src1Buff.getDataType();
        DataBuffer src2Buff = src2.getRaster().getDataBuffer();
        int src2Type = src2Buff.getDataType();
        int destxofs = data.DestLeft - data.Left;
        if (destType == 3 && src1Type == 3 && src2Type == 3) {
            int[] s1 = ((DataBufferInt)src1Buff).getData();
            int[] s2 = ((DataBufferInt)src2Buff).getData();
            int[] d = ((DataBufferInt)destBuff).getData();
            int doffset = destTop * destpitch;
            int h = data.Height;
            int y = data.Top;
            while (h > 0) {
                int r;
                int l;
                --h;
                if (y < this.mDriftCarePixels || y >= this.mHeight - this.mDriftCarePixels) {
                    l = 0;
                    r = this.mCenterX;
                    if (l < left) {
                        l = left;
                    }
                    if (r > right) {
                        r = right;
                    }
                    if (l < r) {
                        if (y < this.mCenterY) {
                            this.rippleTransform_b_a_e(this.mTable.getDisplaceMap(), this.mTable.getDisplaceMapOffset(this.mCenterX - l - 1, this.mCenterY - y - 1), this.mCurDriftMap, this.mDriftMapOffset, d, doffset + l + destxofs, r - l, src1pitch, s1, s2, l, y, this.mWidth, this.mHeight, this.mBlendRatio);
                        } else {
                            this.rippleTransform_b_d_e(this.mTable.getDisplaceMap(), this.mTable.getDisplaceMapOffset(this.mCenterX - l - 1, y - this.mCenterY), this.mCurDriftMap, this.mDriftMapOffset, d, doffset + l + destxofs, r - l, src1pitch, s1, s2, l, y, this.mWidth, this.mHeight, this.mBlendRatio);
                        }
                    }
                    l = this.mCenterX;
                    r = this.mWidth;
                    if (l < left) {
                        l = left;
                    }
                    if (r > right) {
                        r = right;
                    }
                    if (l < r) {
                        if (y < this.mCenterY) {
                            this.rippleTransform_f_a_e(this.mTable.getDisplaceMap(), this.mTable.getDisplaceMapOffset(l - this.mCenterX, this.mCenterY - y - 1), this.mCurDriftMap, this.mDriftMapOffset, d, doffset + l + destxofs, r - l, src1pitch, s1, s2, l, y, this.mWidth, this.mHeight, this.mBlendRatio);
                        } else {
                            this.rippleTransform_f_d_e(this.mTable.getDisplaceMap(), this.mTable.getDisplaceMapOffset(l - this.mCenterX, y - this.mCenterY), this.mCurDriftMap, this.mDriftMapOffset, d, doffset + l + destxofs, r - l, src1pitch, s1, s2, l, y, this.mWidth, this.mHeight, this.mBlendRatio);
                        }
                    }
                } else {
                    int rr;
                    int ll;
                    l = 0;
                    r = this.mCenterX;
                    if (l < left) {
                        l = left;
                    }
                    if (r > right) {
                        r = right;
                    }
                    if (l < r) {
                        ll = 0;
                        rr = this.mDriftCarePixels;
                        if (ll < l) {
                            ll = l;
                        }
                        if (rr > r) {
                            rr = r;
                        }
                        if (ll < rr) {
                            if (y < this.mCenterY) {
                                this.rippleTransform_b_a_e(this.mTable.getDisplaceMap(), this.mTable.getDisplaceMapOffset(this.mCenterX - ll - 1, this.mCenterY - y - 1), this.mCurDriftMap, this.mDriftMapOffset, d, doffset + ll + destxofs, rr - ll, src1pitch, s1, s2, ll, y, this.mWidth, this.mHeight, this.mBlendRatio);
                            } else {
                                this.rippleTransform_b_d_e(this.mTable.getDisplaceMap(), this.mTable.getDisplaceMapOffset(this.mCenterX - ll - 1, y - this.mCenterY), this.mCurDriftMap, this.mDriftMapOffset, d, doffset + ll + destxofs, rr - ll, src1pitch, s1, s2, ll, y, this.mWidth, this.mHeight, this.mBlendRatio);
                            }
                        }
                        ll = this.mDriftCarePixels;
                        rr = r;
                        if (ll < l) {
                            ll = l;
                        }
                        if (ll < rr) {
                            if (y < this.mCenterY) {
                                this.rippleTransform_b(this.mTable.getDisplaceMap(), this.mTable.getDisplaceMapOffset(this.mCenterX - ll - 1, this.mCenterY - y - 1), this.mCurDriftMap, this.mDriftMapOffset, d, doffset + ll + destxofs, rr - ll, src1pitch, s1, y * src1pitch + ll, s2, y * src2pitch + ll, this.mBlendRatio);
                            } else {
                                this.rippleTransform_b(this.mTable.getDisplaceMap(), this.mTable.getDisplaceMapOffset(this.mCenterX - ll - 1, y - this.mCenterY), this.mCurDriftMap, this.mDriftMapOffset, d, doffset + ll + destxofs, rr - ll, -src1pitch, s1, y * src1pitch + ll, s2, y * src2pitch + ll, this.mBlendRatio);
                            }
                        }
                    }
                    l = this.mCenterX;
                    r = this.mWidth;
                    if (l < left) {
                        l = left;
                    }
                    if (r > right) {
                        r = right;
                    }
                    if (l < r) {
                        ll = l;
                        rr = this.mWidth - this.mDriftCarePixels;
                        if (rr > r) {
                            rr = r;
                        }
                        if (ll < rr) {
                            if (y < this.mCenterY) {
                                this.rippleTransform_f(this.mTable.getDisplaceMap(), this.mTable.getDisplaceMapOffset(ll - this.mCenterX, this.mCenterY - y - 1), this.mCurDriftMap, this.mDriftMapOffset, d, doffset + ll + destxofs, rr - ll, src1pitch, s1, y * src1pitch + ll, s2, y * src2pitch + ll, this.mBlendRatio);
                            } else {
                                this.rippleTransform_f(this.mTable.getDisplaceMap(), this.mTable.getDisplaceMapOffset(ll - this.mCenterX, y - this.mCenterY), this.mCurDriftMap, this.mDriftMapOffset, d, doffset + ll + destxofs, rr - ll, -src1pitch, s1, y * src1pitch + ll, s2, y * src2pitch + ll, this.mBlendRatio);
                            }
                        }
                        ll = this.mWidth - this.mDriftCarePixels;
                        rr = r;
                        if (ll < l) {
                            ll = l;
                        }
                        if (ll < rr) {
                            if (y < this.mCenterY) {
                                this.rippleTransform_f_a_e(this.mTable.getDisplaceMap(), this.mTable.getDisplaceMapOffset(ll - this.mCenterX, this.mCenterY - y - 1), this.mCurDriftMap, this.mDriftMapOffset, d, doffset + ll + destxofs, rr - ll, src1pitch, s1, s2, ll, y, this.mWidth, this.mHeight, this.mBlendRatio);
                            } else {
                                this.rippleTransform_f_d_e(this.mTable.getDisplaceMap(), this.mTable.getDisplaceMapOffset(ll - this.mCenterX, y - this.mCenterY), this.mCurDriftMap, this.mDriftMapOffset, d, doffset + ll + destxofs, rr - ll, src1pitch, s1, s2, ll, y, this.mWidth, this.mHeight, this.mBlendRatio);
                            }
                        }
                    }
                }
                doffset += destpitch;
                ++y;
            }
        }
        return 0;
    }

    private void rippleTransform_f_a_e(short[] displacemap, int displaceMapOffset, short[] driftmap, int driftmapOffset, int[] dest, int destOffset, int num, int pitch, int[] src1, int[] src2, int srcx, int srcy, int srcwidth, int srcheight, int ratio) {
        int i = 0;
        while (i < num) {
            short o = displacemap[displaceMapOffset + i];
            short n = driftmap[driftmapOffset + o];
            int x = srcx + i - (n >>> 8 & 0xFF);
            int y = srcy + (n & 0xFF);
            if (x < 0) {
                x = -x;
            }
            if (y < 0) {
                y = -y;
            }
            if (x >= srcwidth) {
                x = srcwidth - 1 - (x - srcwidth);
            }
            if (y >= srcheight) {
                y = srcheight - 1 - (y - srcheight);
            }
            int ofs = x + y * pitch;
            int s1 = src1[ofs];
            int s2 = src2[ofs];
            int s1_ = s1 & 0xFF00FF;
            s1_ = s1_ + (((s2 & 0xFF00FF) - s1_) * ratio >>> 8) & 0xFF00FF;
            dest[destOffset + i] = s1_ | (s1 &= 0xFF00) + (((s2 &= 0xFF00) - s1) * ratio >>> 8) & 0xFF00 | 0xFF000000;
            ++i;
        }
    }

    private void rippleTransform_f_d_e(short[] displacemap, int displaceMapOffset, short[] driftmap, int driftmapOffset, int[] dest, int destOffset, int num, int pitch, int[] src1, int[] src2, int srcx, int srcy, int srcwidth, int srcheight, int ratio) {
        int i = 0;
        while (i < num) {
            short o = displacemap[displaceMapOffset + i];
            short n = driftmap[driftmapOffset + o];
            int x = srcx + i - (n >>> 8 & 0xFF);
            int y = srcy - (n & 0xFF);
            if (x < 0) {
                x = -x;
            }
            if (y < 0) {
                y = -y;
            }
            if (x >= srcwidth) {
                x = srcwidth - 1 - (x - srcwidth);
            }
            if (y >= srcheight) {
                y = srcheight - 1 - (y - srcheight);
            }
            int ofs = x + y * pitch;
            int s1 = src1[ofs];
            int s2 = src2[ofs];
            int s1_ = s1 & 0xFF00FF;
            s1_ = s1_ + (((s2 & 0xFF00FF) - s1_) * ratio >>> 8) & 0xFF00FF;
            dest[destOffset + i] = s1_ | (s1 &= 0xFF00) + (((s2 &= 0xFF00) - s1) * ratio >>> 8) & 0xFF00 | 0xFF000000;
            ++i;
        }
    }

    private void rippleTransform_b_a_e(short[] displacemap, int displaceMapOffset, short[] driftmap, int driftmapOffset, int[] dest, int destOffset, int num, int pitch, int[] src1, int[] src2, int srcx, int srcy, int srcwidth, int srcheight, int ratio) {
        int i = 0;
        while (i < num) {
            short o = displacemap[displaceMapOffset];
            short n = driftmap[driftmapOffset + o];
            --displaceMapOffset;
            int x = srcx + i + (n >>> 8 & 0xFF);
            int y = srcy + (n & 0xFF);
            if (x < 0) {
                x = -x;
            }
            if (y < 0) {
                y = -y;
            }
            if (x >= srcwidth) {
                x = srcwidth - 1 - (x - srcwidth);
            }
            if (y >= srcheight) {
                y = srcheight - 1 - (y - srcheight);
            }
            int ofs = x + y * pitch;
            int s1 = src1[ofs];
            int s2 = src2[ofs];
            int s1_ = s1 & 0xFF00FF;
            s1_ = s1_ + (((s2 & 0xFF00FF) - s1_) * ratio >>> 8) & 0xFF00FF;
            dest[destOffset + i] = s1_ | (s1 &= 0xFF00) + (((s2 &= 0xFF00) - s1) * ratio >>> 8) & 0xFF00 | 0xFF000000;
            ++i;
        }
    }

    private void rippleTransform_b_d_e(short[] displacemap, int displaceMapOffset, short[] driftmap, int driftmapOffset, int[] dest, int destOffset, int num, int pitch, int[] src1, int[] src2, int srcx, int srcy, int srcwidth, int srcheight, int ratio) {
        int i = 0;
        while (i < num) {
            short o = displacemap[displaceMapOffset];
            short n = driftmap[driftmapOffset + o];
            --displaceMapOffset;
            int x = srcx + i + (n >>> 8 & 0xFF);
            int y = srcy - (n & 0xFF);
            if (x < 0) {
                x = -x;
            }
            if (y < 0) {
                y = -y;
            }
            if (x >= srcwidth) {
                x = srcwidth - 1 - (x - srcwidth);
            }
            if (y >= srcheight) {
                y = srcheight - 1 - (y - srcheight);
            }
            int ofs = x + y * pitch;
            int s1 = src1[ofs];
            int s2 = src2[ofs];
            int s1_ = s1 & 0xFF00FF;
            s1_ = s1_ + (((s2 & 0xFF00FF) - s1_) * ratio >>> 8) & 0xFF00FF;
            dest[destOffset + i] = s1_ | (s1 &= 0xFF00) + (((s2 &= 0xFF00) - s1) * ratio >>> 8) & 0xFF00 | 0xFF000000;
            ++i;
        }
    }

    private void rippleTransform_f(short[] displacemap, int displaceMapOffset, short[] driftmap, int driftmapOffset, int[] dest, int destOffset, int num, int pitch, int[] src1, int src1offset, int[] src2, int src2offset, int ratio) {
        int i = 0;
        while (i < num) {
            short o = displacemap[displaceMapOffset + i];
            short n = driftmap[driftmapOffset + o];
            int ofs = i - (n >>> 8 & 0xFF) + (n & 0xFF) * pitch;
            int s1 = src1[src1offset + ofs];
            int s2 = src2[src2offset + ofs];
            int s1_ = s1 & 0xFF00FF;
            s1_ = s1_ + (((s2 & 0xFF00FF) - s1_) * ratio >>> 8) & 0xFF00FF;
            dest[destOffset + i] = s1_ | (s1 &= 0xFF00) + (((s2 &= 0xFF00) - s1) * ratio >>> 8) & 0xFF00 | 0xFF000000;
            ++i;
        }
    }

    private void rippleTransform_b(short[] displacemap, int displaceMapOffset, short[] driftmap, int driftmapOffset, int[] dest, int destOffset, int num, int pitch, int[] src1, int src1offset, int[] src2, int src2offset, int ratio) {
        int i = 0;
        while (i < num) {
            short o = displacemap[displaceMapOffset];
            short n = driftmap[driftmapOffset + o];
            --displaceMapOffset;
            int ofs = i + (n >>> 8 & 0xFF) + (n & 0xFF) * pitch;
            int s1 = src1[src1offset + ofs];
            int s2 = src2[src2offset + ofs];
            int s1_ = s1 & 0xFF00FF;
            s1_ = s1_ + (((s2 & 0xFF00FF) - s1_) * ratio >>> 8) & 0xFF00FF;
            dest[destOffset + i] = s1_ | (s1 &= 0xFF00) + (((s2 &= 0xFF00) - s1) * ratio >>> 8) & 0xFF00 | 0xFF000000;
            ++i;
        }
    }

    @Override
    public int makeFinalImage(ScanLineProvider dest, ScanLineProvider src1, ScanLineProvider src2) throws TJSException {
        dest.copyFrom(src2);
        return 0;
    }

    static class RippleTable {
        private int mWidth;
        private int mHeight;
        private int mCenterX;
        private int mCenterY;
        private int mRippleWidth;
        private float mRoundness;
        private int mMaxDrift;
        private int mMapWidth;
        private int mMapHeight;
        private short[] mDisplaceMap = null;
        private short[] mDriftMap = null;

        public int getWidth() {
            return this.mWidth;
        }

        public int getHeight() {
            return this.mHeight;
        }

        public int getCenterX() {
            return this.mCenterX;
        }

        public int getCenterY() {
            return this.mCenterY;
        }

        public int getRippleWidth() {
            return this.mRippleWidth;
        }

        public float getRoundness() {
            return this.mRoundness;
        }

        public int getMaxDrift() {
            return this.mMaxDrift;
        }

        public int getMapWidth() {
            return this.mMapWidth;
        }

        public int getMapHeight() {
            return this.mMapHeight;
        }

        public RippleTable(int width, int height, int centerx, int centery, int ripplewidth, float roundness, int maxdrift) {
            this.mWidth = width;
            this.mHeight = height;
            this.mCenterX = centerx;
            this.mCenterY = centery;
            this.mRippleWidth = ripplewidth;
            this.mRoundness = roundness;
            this.mMaxDrift = maxdrift;
            this.makeTable();
        }

        public final short[] getDisplaceMap() {
            return this.mDisplaceMap;
        }

        public final int getDisplaceMapOffset(int x, int y) {
            return x + y * this.mMapWidth;
        }

        public final short[] getDriftMap() {
            return this.mDriftMap;
        }

        public final int getDriftMapOffset(int drift, int phase) {
            return drift * this.mRippleWidth * 64 + phase * 32;
        }

        private static final float rippleWaveForm(float rad) {
            float s = (float)((Math.sin(rad) + Math.sin(rad * 2.0f - 2.0f) * (double)0.2f) / (double)1.19f);
            s *= s;
            return s;
        }

        private final void makeTable() {
            int[] rippleform = null;
            int[] cos_table = null;
            int[] sin_table = null;
            try {
                this.mMapWidth = this.mCenterX < this.mWidth >>> 1 ? this.mWidth - this.mCenterX : this.mCenterX;
                this.mMapHeight = this.mCenterY < this.mHeight >>> 1 ? this.mHeight - this.mCenterY : this.mCenterY;
                this.mDisplaceMap = new short[this.mMapWidth * this.mMapHeight];
                int rmp = 0;
                short[] dispmap = this.mDisplaceMap;
                int ripplemask = this.mRippleWidth - 1;
                int y = 0;
                while (y < this.mMapHeight) {
                    float yy = ((float)y + 0.5f) * this.mRoundness;
                    float fac = 1.0f / yy;
                    int x = 0;
                    while (x < this.mMapWidth) {
                        float xx = (float)x + 0.5f;
                        int dir = (int)(Math.atan(xx * fac) * 20.371832715762604);
                        int dist = (int)Math.sqrt(xx * xx + yy * yy) & ripplemask;
                        dispmap[rmp] = (short)(dist * 32 + dir);
                        ++rmp;
                        ++x;
                    }
                    ++y;
                }
                this.mDriftMap = new short[this.mMaxDrift * 4 * this.mRippleWidth * 2 * 32];
                float rcp_rw = 1.0f / (float)this.mRippleWidth;
                rippleform = new int[this.mRippleWidth];
                int w = 0;
                while (w < this.mRippleWidth) {
                    float rad = (float)((double)((float)w * rcp_rw) * (Math.PI * -2));
                    float s = RippleTable.rippleWaveForm(rad);
                    if (s < -1.0f) {
                        s = -1.0f;
                    }
                    if (s > 1.0f) {
                        s = 1.0f;
                    }
                    rippleform[w] = (int)((s *= 2048.0f) < 0.0f ? s - 0.5f : s + 0.5f);
                    ++w;
                }
                cos_table = new int[32];
                sin_table = new int[32];
                w = 0;
                while (w < 32) {
                    float fdir = (float)(1.5707963267948966 - (double)((float)w + 0.5f) * 0.04908738521234052);
                    float v = (float)(Math.cos(fdir) * 2048.0);
                    cos_table[w] = (int)(v < 0.0f ? v - 0.5f : v + 0.5f);
                    v = (float)(Math.sin(fdir) * 2048.0);
                    sin_table[w] = (int)(v < 0.0f ? v - 0.5f : v + 0.5f);
                    ++w;
                }
                int ripplewidth_step = this.mRippleWidth * 32;
                int drift = 0;
                while (drift < this.mMaxDrift * 4) {
                    int fdrift = (drift << 10) / 4;
                    int dmp = drift * this.mRippleWidth * 64;
                    int w2 = 0;
                    while (w2 < this.mRippleWidth) {
                        int fd = rippleform[w2] * fdrift >>> 10;
                        int dir = 0;
                        while (dir < 32) {
                            short val;
                            int xd = cos_table[dir] * fd >>> 11;
                            int yd = sin_table[dir] * fd >>> 11;
                            short s = val = (short)((xd >>> 11 << 8) + (yd >>> 11) & 0xFFFF);
                            this.mDriftMap[dmp + w2 * 32 + ripplewidth_step + dir] = s;
                            this.mDriftMap[dmp + w2 * 32 + dir] = s;
                            ++dir;
                        }
                        ++w2;
                    }
                    ++drift;
                }
            }
            finally {
                rippleform = null;
                sin_table = null;
                cos_table = null;
            }
        }
    }
}

