/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2env;

import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tvp2.msg.Message;
import jp.kirikiri.tvp2.visual.BaseTransHandler;
import jp.kirikiri.tvp2.visual.SimpleImageProvider;
import jp.kirikiri.tvp2.visual.SimpleOptionProvider;
import jp.kirikiri.tvp2.visual.TransHandlerProvider;
import jp.kirikiri.tvp2env.RippleTransHandler;

public class RippleTransHandlerProvider
implements TransHandlerProvider {
    private static final String TIME = "time";
    private static final String CENTERX = "centerx";
    private static final String CENTERY = "centery";
    private static final String RWIDTH = "rwidth";
    private static final String ROUNDNESS = "roundness";
    private static final String SPEED = "speed";
    private static final String MAXDRIFT = "maxdrift";
    private Variant mVariantRet = new Variant();
    protected long[] mLogValueRet = new long[1];

    @Override
    public String getName() {
        return "ripple";
    }

    @Override
    public BaseTransHandler startTransition(SimpleOptionProvider options, SimpleImageProvider imagepro, int layertype, int src1w, int src1h, int src2w, int src2h, int[] type) throws TJSException {
        long time;
        int er;
        if (type != null && type.length >= 1) {
            type[0] = 1;
        }
        if (type != null && type.length >= 2) {
            type[1] = 1;
        }
        if (options == null) {
            return null;
        }
        if (src1w != src2w || src1h != src2h) {
            Message.throwExceptionMessage("\u30c8\u30e9\u30f3\u30b8\u30b7\u30e7\u30f3\u5143(%1)\u3068\u30c8\u30e9\u30f3\u30b8\u30b7\u30e7\u30f3\u5148(%2)\u306e\u30ec\u30a4\u30e4\u306e\u30b5\u30a4\u30ba\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093", String.valueOf(String.valueOf(src2w)) + "x" + src2h, String.valueOf(String.valueOf(src1w)) + "x" + src1h);
        }
        if ((er = options.getAsNumber(TIME, this.mLogValueRet)) < 0) {
            Message.throwExceptionMessage("\u30aa\u30d7\u30b7\u30e7\u30f3 %1 \u3092\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044", TIME);
        }
        if ((time = this.mLogValueRet[0]) < 2L) {
            time = 2L;
        }
        er = options.getAsNumber(CENTERX, this.mLogValueRet);
        int centerx = (int)this.mLogValueRet[0];
        if (er < 0) {
            centerx = src1w / 2;
        }
        er = options.getAsNumber(CENTERY, this.mLogValueRet);
        int centery = (int)this.mLogValueRet[0];
        if (er < 0) {
            centery = src1h / 2;
        }
        if (centerx < 0 || centery < 0 || centerx >= src1w || centery >= src1h) {
            Message.throwExceptionMessage("centerx and centery cannot be out of the image");
        }
        er = options.getAsNumber(RWIDTH, this.mLogValueRet);
        int ripplewidth = (int)this.mLogValueRet[0];
        if (er < 0) {
            ripplewidth = 128;
        }
        if (ripplewidth != 16 && ripplewidth != 32 && ripplewidth != 64 && ripplewidth != 128) {
            Message.throwExceptionMessage("rwidth must be 16, 32, 64 or 128");
        }
        er = options.getValue(ROUNDNESS, this.mVariantRet);
        float roundness = 1.0f;
        if (er >= 0 && !this.mVariantRet.isVoid()) {
            roundness = (float)this.mVariantRet.asDouble();
        }
        this.mVariantRet.clear();
        if ((double)roundness <= 0.0) {
            Message.throwExceptionMessage("roundness cannot be nagative or equal to 0");
        }
        er = options.getValue(SPEED, this.mVariantRet);
        float speed = 6.0f;
        if (er >= 0 && !this.mVariantRet.isVoid()) {
            speed = (float)this.mVariantRet.asDouble();
        }
        this.mVariantRet.clear();
        er = options.getAsNumber(MAXDRIFT, this.mLogValueRet);
        int maxdrift = (int)this.mLogValueRet[0];
        if (er < 0) {
            maxdrift = 24;
        }
        if (maxdrift < 0 || maxdrift >= 128) {
            Message.throwExceptionMessage("maxdrift cannot be nagative or larger than 127");
        }
        if (maxdrift >= src1w || maxdrift >= src1h) {
            Message.throwExceptionMessage("maxdrift must be lesser than both image width and height");
        }
        return new RippleTransHandler(time, layertype, src1w, src1h, centerx, centery, ripplewidth, roundness, speed, maxdrift);
    }
}

