/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2env;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import jp.kirikiri.tvp2.visual.DivisibleData;
import jp.kirikiri.tvp2env.BaseRotateTransHandler;

public class RotateSwapTransHandler
extends BaseRotateTransHandler {
    private boolean mSrc1First;
    private AffineTransform mSrc1Mat;
    private AffineTransform mSrc2Mat;
    private float mTwist;
    private Color mBGColorObj;

    public RotateSwapTransHandler(long time, int width, int height, int bgcolor, double twist) {
        super(time, width, height, bgcolor);
        this.mTwist = (float)(twist * Math.PI * 2.0);
        this.mBGColorObj = new Color(bgcolor | 0xFF000000, true);
    }

    @Override
    public int process(DivisibleData data) {
        BufferedImage dest = (BufferedImage)data.Dest.getScanLineForWrite().getImage();
        BufferedImage src1 = (BufferedImage)data.Src1.getScanLine().getImage();
        BufferedImage src2 = (BufferedImage)data.Src2.getScanLine().getImage();
        int destLeft = data.DestLeft;
        int src1Left = data.Src1Left;
        int src2Left = data.Src2Left;
        int h = data.Height;
        int w = data.Width;
        int destTop = data.DestTop;
        int src1Top = data.Src1Top;
        int src2Top = data.Src2Top;
        Graphics2D g = (Graphics2D)dest.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g.setComposite(AlphaComposite.Src);
        g.setColor(this.mBGColorObj);
        g.fillRect(destLeft, destTop, w, h);
        g.setTransform(this.mSrc1Mat);
        if (this.mSrc1First) {
            g.drawImage(src1, destLeft, destTop, destLeft + w, destTop + h, src1Left, src1Top, src1Left + w, src1Top + h, null);
        } else {
            g.drawImage(src2, destLeft, destTop, destLeft + w, destTop + h, src1Left, src1Top, src1Left + w, src1Top + h, null);
        }
        g.setTransform(this.mSrc2Mat);
        if (this.mSrc1First) {
            g.drawImage(src2, destLeft, destTop, destLeft + w, destTop + h, src2Left, src2Top, src2Left + w, src2Top + h, null);
        } else {
            g.drawImage(src1, destLeft, destTop, destLeft + w, destTop + h, src2Left, src2Top, src2Left + w, src2Top + h, null);
        }
        g.dispose();
        return 0;
    }

    @Override
    void calcPosition() {
        AffineTransform mat;
        AffineTransform trans;
        int scx = this.mWidth / 2;
        int scy = this.mHeight / 2;
        float zm = (float)((int)this.mCurTime) / (float)((int)this.mTime);
        this.mSrc1First = this.mCurTime >= this.mTime / 2L;
        float tm = zm * zm;
        float cx = (float)((double)((float)(-scx) * tm + (float)scx) + Math.sin((double)tm * Math.PI) * (double)scx * 1.5);
        float cy = (float)(-scy) * tm + (float)scy;
        float rad = tm * this.mTwist;
        tm = 1.0f - tm;
        AffineTransform rot = AffineTransform.getRotateInstance(-rad, cx, cy);
        AffineTransform scale = AffineTransform.getScaleInstance(tm, tm);
        scale.concatenate(rot);
        if (tm != 0.0f && tm != 1.0f) {
            cx -= cx * tm;
            cy -= cy * tm;
            trans = AffineTransform.getTranslateInstance(cx, cy);
            trans.concatenate(scale);
            mat = trans;
        } else {
            mat = scale;
        }
        if (this.mSrc1First) {
            this.mSrc1Mat = mat;
        } else {
            this.mSrc2Mat = mat;
        }
        tm = 1.0f - (1.0f - zm) * (1.0f - zm);
        cx = (float)((double)((float)(scx - (this.mWidth - 1)) * tm + (float)(this.mWidth - 1)) - Math.sin((double)tm * Math.PI) * (double)scx * 1.5);
        cy = (float)(scy - (this.mHeight - 1)) * tm + (float)(this.mHeight - 1);
        rad = (-1.0f + tm) * this.mTwist;
        rot = AffineTransform.getRotateInstance(-rad, cx, cy);
        scale = AffineTransform.getScaleInstance(tm, tm);
        scale.concatenate(rot);
        if (tm != 0.0f && tm != 1.0f) {
            cx -= cx * tm;
            cy -= cy * tm;
            trans = AffineTransform.getTranslateInstance(cx, cy);
            trans.concatenate(scale);
            mat = trans;
        } else {
            mat = scale;
        }
        if (this.mSrc1First) {
            this.mSrc2Mat = mat;
        } else {
            this.mSrc1Mat = mat;
        }
    }
}

