/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2env;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import jp.kirikiri.tvp2.visual.DivisibleData;
import jp.kirikiri.tvp2env.BaseRotateTransHandler;

public class RotateZoomTransHandler
extends BaseRotateTransHandler {
    private double mFactor;
    private double mTargetFactor;
    private double mAccel;
    private double mTwist;
    private double mTwistAccel;
    private int mCenterX;
    private int mCenterY;
    private boolean mFixSrc1;
    private AffineTransform mSrc1Mat;
    private AffineTransform mSrc2Mat;

    public RotateZoomTransHandler(long time, int width, int height, double factor, double targetfactor, double accel, double twist, double twistaccel, int centerx, int centery, boolean fixsrc1) {
        super(time, width, height, 0);
        this.mFactor = factor;
        this.mTargetFactor = targetfactor;
        this.mAccel = accel;
        this.mTwist = twist;
        this.mTwistAccel = twistaccel;
        this.mCenterX = centerx;
        this.mCenterY = centery;
        this.mFixSrc1 = fixsrc1;
        this.mSrc1Mat = new AffineTransform();
    }

    @Override
    void calcPosition() {
        float zm;
        float tm = zm = (float)((int)this.mCurTime) / (float)((int)this.mTime);
        if (this.mAccel < 0.0) {
            zm = 1.0f - zm;
            zm = (float)Math.pow(zm, -this.mAccel);
            zm = 1.0f - zm;
        } else if (this.mAccel > 0.0) {
            zm = (float)Math.pow(zm, this.mAccel);
        }
        float scx = (float)this.mWidth / 2.0f;
        float scy = (float)this.mHeight / 2.0f;
        float cx = (scx - (float)this.mCenterX) * zm + (float)this.mCenterX;
        float cy = (scy - (float)this.mCenterY) * zm + (float)this.mCenterY;
        if (this.mTwistAccel < 0.0) {
            tm = 1.0f - tm;
            tm = (float)Math.pow(tm, -this.mTwistAccel);
            tm = 1.0f - tm;
        } else if (this.mTwistAccel > 0.0) {
            tm = (float)Math.pow(tm, this.mTwistAccel);
        }
        float rad = (float)(this.mCurTime == this.mTime ? 0.0 : Math.PI * 2 * this.mTwist * (double)tm);
        zm = (float)((this.mTargetFactor - this.mFactor) * (double)zm + this.mFactor);
        AffineTransform rot = AffineTransform.getRotateInstance(-rad, cx, cy);
        AffineTransform scale = AffineTransform.getScaleInstance(zm, zm);
        scale.concatenate(rot);
        if (zm != 0.0f && zm != 1.0f) {
            cx -= cx * zm;
            cy -= cy * zm;
            AffineTransform trans = AffineTransform.getTranslateInstance(cx, cy);
            trans.concatenate(scale);
            this.mSrc2Mat = trans;
        } else {
            this.mSrc2Mat = scale;
        }
    }

    @Override
    public int process(DivisibleData data) {
        BufferedImage dest = (BufferedImage)data.Dest.getScanLineForWrite().getImage();
        BufferedImage src1 = (BufferedImage)data.Src1.getScanLine().getImage();
        BufferedImage src2 = (BufferedImage)data.Src2.getScanLine().getImage();
        int destLeft = data.DestLeft;
        int src1Left = data.Src1Left;
        int src2Left = data.Src2Left;
        int h = data.Height;
        int w = data.Width;
        int destTop = data.DestTop;
        int src1Top = data.Src1Top;
        int src2Top = data.Src2Top;
        Graphics2D g = (Graphics2D)dest.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g.setComposite(AlphaComposite.Src);
        g.setTransform(this.mSrc1Mat);
        if (this.mFixSrc1) {
            g.drawImage(src1, destLeft, destTop, destLeft + w, destTop + h, src1Left, src1Top, src1Left + w, src1Top + h, null);
        } else {
            g.drawImage(src2, destLeft, destTop, destLeft + w, destTop + h, src1Left, src1Top, src1Left + w, src1Top + h, null);
        }
        g.setTransform(this.mSrc2Mat);
        if (this.mFixSrc1) {
            g.drawImage(src2, destLeft, destTop, destLeft + w, destTop + h, src2Left, src2Top, src2Left + w, src2Top + h, null);
        } else {
            g.drawImage(src1, destLeft, destTop, destLeft + w, destTop + h, src2Left, src2Top, src2Left + w, src2Top + h, null);
        }
        g.dispose();
        return 0;
    }
}

