/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2env;

import jp.kirikiri.tvp2.visual.DivisibleData;
import jp.kirikiri.tvp2.visual.Rect;
import jp.kirikiri.tvp2.visual.ScanLineProvider;
import jp.kirikiri.tvp2.visual.SimpleOptionProvider;
import jp.kirikiri.tvp2env.CrossFadeTransHandler;
import jp.kirikiri.tvp2env.NativeImageBuffer;

public class ScrollTransHandler
extends CrossFadeTransHandler {
    public static final int sttLeft = 0;
    public static final int sttTop = 1;
    public static final int sttRight = 2;
    public static final int sttBottom = 3;
    public static final int ststNoStay = 0;
    public static final int ststStayDest = 1;
    public static final int ststStaySrc = 2;
    private int mFrom;
    private int mStay;

    public ScrollTransHandler(SimpleOptionProvider options, int layertype, long time, int from, int stay, int maxphase) {
        super(options, layertype, time, maxphase);
        this.mFrom = from;
        this.mStay = stay;
    }

    @Override
    public void blend(DivisibleData data) {
        int dt;
        int dl;
        Rect d;
        int from = this.mFrom;
        int stay = this.mStay;
        int phase = this.mPhase;
        int imagewidth = data.Src1.getWidth();
        int imageheight = data.Src1.getHeight();
        int src1left = 0;
        int src1top = 0;
        int src2left = 0;
        int src2top = 0;
        switch (from) {
            case 0: {
                if (stay == 0) {
                    src1left = phase;
                    src2left = phase - imagewidth;
                    break;
                }
                if (stay == 1) {
                    src2left = phase - imagewidth;
                    break;
                }
                if (stay != 2) break;
                src1left = phase;
                break;
            }
            case 1: {
                if (stay == 0) {
                    src1top = phase;
                    src2top = phase - imageheight;
                    break;
                }
                if (stay == 1) {
                    src2top = phase - imageheight;
                    break;
                }
                if (stay != 2) break;
                src1top = phase;
                break;
            }
            case 2: {
                if (stay == 0) {
                    src1left = -phase;
                    src2left = imagewidth - phase;
                    break;
                }
                if (stay == 1) {
                    src2left = imagewidth - phase;
                    break;
                }
                if (stay != 2) break;
                src1left = -phase;
                break;
            }
            case 3: {
                if (stay == 0) {
                    src1top = -phase;
                    src2top = imageheight - phase;
                    break;
                }
                if (stay == 1) {
                    src2top = imageheight - phase;
                    break;
                }
                if (stay != 2) break;
                src1top = -phase;
            }
        }
        Rect rdest = new Rect(data.Left, data.Top, data.Width + data.Left, data.Height + data.Top);
        Rect rs1 = new Rect(src1left, src1top, imagewidth + src1left, imageheight + src1top);
        Rect rs2 = new Rect(src2left, src2top, imagewidth + src2left, imageheight + src2top);
        if (stay != 0) {
            if (stay == 1) {
                if (from == 0 || from == 2) {
                    if (rs2.right >= rs1.left && rs2.right < rs1.right) {
                        rs1.left = rs2.right;
                    }
                    if (rs2.left >= rs1.left && rs2.left < rs1.right) {
                        rs1.right = rs2.left;
                    }
                } else {
                    if (rs2.bottom >= rs1.top && rs2.bottom < rs1.bottom) {
                        rs1.top = rs2.bottom;
                    }
                    if (rs2.top >= rs1.top && rs2.top < rs1.bottom) {
                        rs1.bottom = rs2.top;
                    }
                }
            } else if (stay == 2) {
                if (from == 0 || from == 2) {
                    if (rs1.right >= rs2.left && rs1.right < rs2.right) {
                        rs2.left = rs1.right;
                    }
                    if (rs1.left >= rs2.left && rs1.left < rs2.right) {
                        rs2.right = rs1.left;
                    }
                } else {
                    if (rs1.bottom >= rs2.top && rs1.bottom < rs2.bottom) {
                        rs2.top = rs1.bottom;
                    }
                    if (rs1.top >= rs2.top && rs1.top < rs2.bottom) {
                        rs2.bottom = rs1.top;
                    }
                }
            }
        }
        if (Rect.intersectRect(d = new Rect(), rdest, rs1)) {
            dl = d.left - data.Left + data.DestLeft;
            dt = d.top - data.Top + data.DestTop;
            d.addOffsets(-src1left, -src1top);
            this.copyRect(data.Dest, dl, dt, data.Src1, d);
        }
        if (Rect.intersectRect(d, rdest, rs2)) {
            dl = d.left - data.Left + data.DestLeft;
            dt = d.top - data.Top + data.DestTop;
            d.addOffsets(-src2left, -src2top);
            this.copyRect(data.Dest, dl, dt, data.Src2, d);
        }
    }

    private void copyRect(ScanLineProvider destimg, int x, int y, ScanLineProvider srcimg, Rect srcrect) {
        NativeImageBuffer dest = destimg.getScanLineForWrite();
        NativeImageBuffer src = srcimg.getScanLine();
        dest.copyRect(x, y, src, srcrect);
    }
}

