/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2env;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;

public class SoundMixer
implements LineListener {
    private Mixer mCurrentMixer;
    private FloatControl mPanControl;
    private FloatControl mGainControl;
    private FloatControl mVolumeControl;
    private float mMinPanValue;
    private float mMaxPanValue;
    private float mMinGainValue;
    private float mMaxGainValue;
    private float mMinVolumeValue;
    private float mMaxVolumeValue;

    public void initialize() {
        Mixer mixer;
        Line.Info[] infos;
        AudioFormat[] requestFormat = new AudioFormat[]{new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, 2, 4, 44100.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 8, 2, 2, 44100.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, 1, 2, 44100.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 8, 1, 1, 44100.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 22050.0f, 16, 2, 4, 22050.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 22050.0f, 8, 2, 2, 22050.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 22050.0f, 16, 1, 2, 22050.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 22050.0f, 8, 1, 1, 22050.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 11025.0f, 16, 2, 4, 11025.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 11025.0f, 8, 2, 2, 11025.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 11025.0f, 16, 1, 2, 11025.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 11025.0f, 8, 1, 1, 11025.0f, false)};
        DataLine.Info[] info = new DataLine.Info[12];
        int i = 0;
        while (i < requestFormat.length) {
            info[i] = new DataLine.Info(SourceDataLine.class, requestFormat[i]);
            ++i;
        }
        this.mCurrentMixer = AudioSystem.getMixer(null);
        if (this.mCurrentMixer != null && (infos = (mixer = this.mCurrentMixer).getSourceLineInfo()).length > 0) {
            boolean supportAll = true;
            int j = 0;
            while (j < info.length) {
                block17: {
                    try {
                        if (!mixer.isLineSupported(info[j])) {
                            supportAll = false;
                        }
                        break block17;
                    }
                    catch (IllegalArgumentException e) {
                        supportAll = false;
                    }
                    break;
                }
                ++j;
            }
            if (supportAll) {
                return;
            }
        }
        Mixer.Info[] mixers = AudioSystem.getMixerInfo();
        int count = mixers.length;
        int i2 = 0;
        while (i2 < count) {
            Mixer mixer2 = AudioSystem.getMixer(mixers[i2]);
            Line.Info[] infos2 = mixer2.getSourceLineInfo();
            if (infos2.length > 0) {
                boolean supportAll = true;
                int j = 0;
                while (j < info.length) {
                    block18: {
                        try {
                            if (!mixer2.isLineSupported(info[j])) {
                                supportAll = false;
                            }
                            break block18;
                        }
                        catch (IllegalArgumentException e) {
                            supportAll = false;
                        }
                        break;
                    }
                    ++j;
                }
                if (supportAll) {
                    this.mCurrentMixer = mixer2;
                    return;
                }
            }
            ++i2;
        }
        this.mCurrentMixer = AudioSystem.getMixer(null);
        if (this.mCurrentMixer == null) {
            return;
        }
        try {
            this.mCurrentMixer.open();
            this.mCurrentMixer.addLineListener(this);
            this.mPanControl = (FloatControl)this.mCurrentMixer.getControl(FloatControl.Type.PAN);
            this.mGainControl = (FloatControl)this.mCurrentMixer.getControl(FloatControl.Type.MASTER_GAIN);
            this.mVolumeControl = (FloatControl)this.mCurrentMixer.getControl(FloatControl.Type.VOLUME);
            this.mMinPanValue = this.mPanControl.getMinimum();
            this.mMaxPanValue = this.mPanControl.getMaximum();
            this.mMinGainValue = this.mGainControl.getMinimum();
            this.mMaxGainValue = this.mGainControl.getMaximum();
            this.mMinVolumeValue = this.mVolumeControl.getMinimum();
            this.mMaxVolumeValue = this.mVolumeControl.getMaximum();
        }
        catch (LineUnavailableException lineUnavailableException) {
            // empty catch block
        }
    }

    public void close() {
        if (this.mCurrentMixer != null) {
            this.mCurrentMixer.close();
        }
    }

    @Override
    public void update(LineEvent event) {
        LineEvent.Type type = event.getType();
        if (!(LineEvent.Type.CLOSE.equals(type) || LineEvent.Type.OPEN.equals(type) || LineEvent.Type.START.equals(type))) {
            LineEvent.Type.STOP.equals(type);
        }
    }

    public void setPan(float pan) {
        if (this.mPanControl == null) {
            return;
        }
        if (pan < this.mMinPanValue) {
            pan = this.mMinPanValue;
        } else if (pan > this.mMaxPanValue) {
            pan = this.mMaxPanValue;
        }
        this.mPanControl.setValue(pan);
    }

    public float getPan() {
        if (this.mPanControl != null) {
            return this.mPanControl.getValue();
        }
        return 0.0f;
    }

    public void setGain(float gain) {
        if (this.mGainControl == null) {
            return;
        }
        if (gain < this.mMinGainValue) {
            gain = this.mMinGainValue;
        } else if (gain > this.mMaxGainValue) {
            gain = this.mMaxGainValue;
        }
        this.mGainControl.setValue(gain);
    }

    public float getGain() {
        if (this.mGainControl != null) {
            return this.mGainControl.getValue();
        }
        return 0.0f;
    }

    public void setVolume(float volume) {
        if (this.mVolumeControl == null) {
            return;
        }
        if (volume < this.mMinVolumeValue) {
            volume = this.mMinVolumeValue;
        } else if (volume > this.mMaxVolumeValue) {
            volume = this.mMaxVolumeValue;
        }
        this.mVolumeControl.setValue(volume);
    }

    public float getVolume() {
        if (this.mVolumeControl != null) {
            return this.mVolumeControl.getValue();
        }
        return 0.0f;
    }

    public SourceDataLine getSourceDataLine(DataLine.Info info) throws LineUnavailableException {
        return (SourceDataLine)this.mCurrentMixer.getLine(info);
    }

    public void setGlobalVolume(int vol) {
        if (vol < 0) {
            vol = 0;
        } else if (vol > 100000) {
            vol = 100000;
        }
        float v = (float)(vol -= 100000) / Math.abs(this.mMinGainValue);
        this.setGain(v);
    }

    public int getGlobalVolume() {
        float v = this.getGain();
        if (v > 0.0f) {
            return 100000;
        }
        float vol = v * 100000.0f / Math.abs(this.mMinGainValue);
        vol = 100000.0f - vol;
        return (int)vol;
    }
}

