/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2env;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.SwingUtilities;
import jp.kirikiri.tjs2.BinaryStream;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.base.Storage;
import jp.kirikiri.tvp2.sound.WaveLabel;
import jp.kirikiri.tvp2.sound.WaveLoopManager;
import jp.kirikiri.tvp2.sound.WaveSoundBufferNI;
import jp.kirikiri.tvp2env.VorbisAudioInputStream;

public class SoundStream
implements Runnable,
LineListener {
    private static final int LABEL_CHECK_CYCLE = 16;
    WaveSoundBufferNI mOwner;
    private String mFileName;
    private Thread mThread;
    private SourceDataLine mLine;
    private FloatControl mPanControl;
    private FloatControl mGainControl;
    private float mMinPanValue;
    private float mMaxPanValue;
    private float mMinGainValue;
    private float mMaxGainValue;
    private int mRequenstBufferSize;
    private AudioInputStream mAudioStream;
    private AudioFormat mFormat;
    private InputStream mInputStream;
    private boolean mLoop;
    private long mNumberOfRead;
    long mTotalSamples;
    WaveLoopManager mLoopManager;
    boolean mIsPlaing;
    private boolean mIsPaused;
    private long mStartOffset;
    ArrayList<String> mLavelEvents = new ArrayList();
    private Runnable mUnloadEvent = new Runnable(){

        @Override
        public void run() {
            if (SoundStream.this.mOwner != null) {
                SoundStream.this.mOwner.setStatus(0);
            }
        }
    };
    private Runnable mPlayEvent = new Runnable(){

        @Override
        public void run() {
            if (SoundStream.this.mOwner != null) {
                SoundStream.this.mOwner.setStatus(2);
            }
        }
    };
    private Runnable mStopEvent = new Runnable(){

        @Override
        public void run() {
            if (SoundStream.this.mOwner != null) {
                SoundStream.this.mOwner.setStatus(1);
            }
        }
    };
    private Runnable mLabelEvent = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList<String> arrayList = SoundStream.this.mLavelEvents;
            synchronized (arrayList) {
                int count = SoundStream.this.mLavelEvents.size();
                if (count > 0) {
                    int i = 0;
                    while (i < count) {
                        String name = SoundStream.this.mLavelEvents.get(i);
                        if (SoundStream.this.mOwner != null) {
                            SoundStream.this.mOwner.invokeLabelEvent(name);
                        }
                        ++i;
                    }
                }
            }
        }
    };

    private void invokeEvent(int state) {
        switch (state) {
            case 2: {
                SwingUtilities.invokeLater(this.mPlayEvent);
                break;
            }
            case 1: {
                SwingUtilities.invokeLater(this.mStopEvent);
                break;
            }
            case 0: {
                SwingUtilities.invokeLater(this.mUnloadEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putLabelEvent(String name) {
        ArrayList<String> arrayList = this.mLavelEvents;
        synchronized (arrayList) {
            this.mLavelEvents.add(name);
        }
        SwingUtilities.invokeLater(this.mLabelEvent);
    }

    public SoundStream(WaveSoundBufferNI o) {
        this.mOwner = o;
        this.mLoopManager = new WaveLoopManager();
    }

    @Override
    public void run() {
        if (this.mAudioStream == null || this.mLine == null) {
            return;
        }
        int numBytesRead = 0;
        this.mLine.start();
        byte[] buffer = new byte[this.mRequenstBufferSize];
        int frameSize = this.mFormat.getFrameSize();
        this.mNumberOfRead = 0L;
        try {
            do {
                if ((numBytesRead = this.mAudioStream.read(buffer, 0, buffer.length)) > 0) {
                    this.mNumberOfRead += (long)numBytesRead;
                    this.mLine.write(buffer, 0, numBytesRead);
                    continue;
                }
                if (!this.mLoop) continue;
                this.mTotalSamples = this.mNumberOfRead / (long)frameSize;
                this.mAudioStream.reset();
                this.mNumberOfRead = 0L;
                numBytesRead = 0;
            } while (this.mLine.isActive() && numBytesRead != -1 && !this.mIsPaused);
            this.mLine.drain();
            this.mLine.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.mIsPlaing = false;
    }

    public void openFromStream(BinaryStream stream, String filename) throws IOException, TJSException {
        this.clear();
        this.mFileName = filename;
        this.mInputStream = stream.getInputStream();
        this.mTotalSamples = 0L;
        try {
            this.mAudioStream = filename.endsWith(".ogg") ? new VorbisAudioInputStream(this.mInputStream, new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, 2, 4, 44100.0f, false), this.mInputStream.available()) : AudioSystem.getAudioInputStream(this.mInputStream);
            String sliname = String.valueOf(filename) + ".sli";
            if (Storage.isExistentStorage(sliname)) {
                long size;
                byte[] buf;
                BinaryStream slistream = Storage.createStream(sliname, 0);
                int readSize = slistream.read(buf = new byte[(int)(size = slistream.getSize())]);
                if (readSize > 0) {
                    String slistr = new String(buf, 0, readSize, "UTF-8");
                    this.mLoopManager.readInformation(slistr);
                    this.mLoopManager.getLabels();
                }
                slistream.close();
            }
            this.mAudioStream.mark(this.mAudioStream.available());
            this.mAudioStream.reset();
            this.mFormat = this.mAudioStream.getFormat();
            this.mStartOffset = 0L;
            this.open(this.mFormat);
        }
        catch (UnsupportedAudioFileException e) {
            throw new IOException();
        }
        catch (LineUnavailableException e) {
            throw new IOException();
        }
    }

    private void open(AudioFormat format) throws LineUnavailableException {
        this.mRequenstBufferSize = (int)(format.getSampleRate() * (float)format.getChannels() * (float)format.getSampleSizeInBits() / 8.0f);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
        this.mLine = TVP.SoundMixer.getSourceDataLine(info);
        this.mLine.addLineListener(this);
        this.mLine.open(format, this.mRequenstBufferSize);
        this.mRequenstBufferSize = this.mLine.getBufferSize();
        try {
            this.mPanControl = (FloatControl)this.mLine.getControl(FloatControl.Type.PAN);
            this.mMinPanValue = this.mPanControl.getMinimum();
            this.mMaxPanValue = this.mPanControl.getMaximum();
        }
        catch (IllegalArgumentException e) {
            this.mPanControl = null;
        }
        this.mGainControl = (FloatControl)this.mLine.getControl(FloatControl.Type.MASTER_GAIN);
        this.mMinGainValue = this.mGainControl.getMinimum();
        this.mMaxGainValue = this.mGainControl.getMaximum();
    }

    public void play() {
        if (this.mLine != null && !this.mIsPaused) {
            this.mIsPlaing = true;
            this.mThread = new Thread(this);
            this.mThread.setName("Sound Stream : " + this.mFileName);
            this.mThread.start();
            ArrayList<WaveLabel> labels = this.mLoopManager.getLabels();
            if (labels != null && labels.size() > 0) {
                Thread ev = new Thread(new EventThread());
                ev.setName("Sound Event Stream : " + this.mFileName);
                ev.start();
            }
        }
    }

    public void stop() {
        if (this.mLine != null) {
            this.mLine.stop();
            this.mIsPlaing = false;
        }
    }

    public void clear() {
        this.stop();
        this.mIsPaused = false;
        this.mNumberOfRead = 0L;
        this.mTotalSamples = 0L;
    }

    public void setPanInternal(float pan) {
        if (this.mPanControl == null) {
            return;
        }
        if (pan < this.mMinPanValue) {
            pan = this.mMinPanValue;
        } else if (pan > this.mMaxPanValue) {
            pan = this.mMaxPanValue;
        }
        if (this.mPanControl != null) {
            this.mPanControl.setValue(pan);
        }
    }

    public float getPanInternal() {
        if (this.mPanControl == null) {
            return 0.0f;
        }
        return this.mPanControl.getValue();
    }

    public void setGain(float gain) {
        if (gain < this.mMinGainValue) {
            gain = this.mMinGainValue;
        } else if (gain > this.mMaxGainValue) {
            gain = this.mMaxGainValue;
        }
        if (this.mGainControl != null) {
            this.mGainControl.setValue(gain);
        }
    }

    public float getGain() {
        if (this.mGainControl == null) {
            return 0.0f;
        }
        return this.mGainControl.getValue();
    }

    public void setFade(float from, float to, int msec) {
        if (this.mGainControl != null) {
            this.mGainControl.shift(from, to, msec);
        }
    }

    @Override
    public void update(LineEvent event) {
        LineEvent.Type type = event.getType();
        if (LineEvent.Type.CLOSE.equals(type)) {
            this.invokeEvent(0);
        } else if (!LineEvent.Type.OPEN.equals(type) && !LineEvent.Type.START.equals(type) && LineEvent.Type.STOP.equals(type)) {
            this.invokeEvent(1);
            this.mIsPlaing = false;
        }
    }

    public void setVolume(int vol) {
        if (vol < 0) {
            vol = 0;
        } else if (vol > 100000) {
            vol = 100000;
        }
        float v = (float)vol / 100000.0f;
        v = (float)Math.log10(v) * 20.0f;
        this.setGain(v);
    }

    public int getVolume() {
        float v = this.getGain();
        if ((v = (float)Math.pow(10.0, (double)v / 20.0) * 100000.0f) > 100000.0f) {
            return 100000;
        }
        if (v < 0.0f) {
            return 0;
        }
        return (int)v;
    }

    public void fade(int to, int time) {
        if (this.mGainControl == null) {
            return;
        }
        if (to < 0) {
            to = 0;
        } else if (to > 100000) {
            to = 100000;
        }
        float v = (float)(to -= 100000) / Math.abs(this.mMinGainValue);
        float from = this.mGainControl.getValue();
        this.mGainControl.shift(from, v, time);
    }

    public int getPan() {
        if (this.mPanControl == null) {
            return 0;
        }
        float p = this.mPanControl.getValue();
        if (p < 0.0f) {
            return (int)(p * 100000.0f / Math.abs(this.mMinPanValue));
        }
        if ((double)p > 0.0) {
            return (int)(p * 100000.0f / Math.abs(this.mMaxPanValue));
        }
        return 0;
    }

    public void setPan(int v) {
        if (this.mPanControl == null) {
            return;
        }
        if (v < 0) {
            this.mPanControl.setValue((float)v * Math.abs(this.mMinPanValue) / 100000.0f);
        } else if (v > 0) {
            this.mPanControl.setValue((float)v * Math.abs(this.mMaxPanValue) / 100000.0f);
        } else {
            this.mPanControl.setValue(0.0f);
        }
    }

    public boolean getLooping() {
        return this.mLoop;
    }

    public void setLooping(boolean b) {
        this.mLoop = b;
    }

    public boolean getPaused() {
        return this.mIsPaused;
    }

    public void setPaused(boolean b) {
        this.mIsPaused = b;
    }

    public int getPosition() {
        if (this.mLine == null || this.mFormat == null) {
            return 0;
        }
        long sample = this.mLine.getLongFramePosition();
        if (this.mTotalSamples != 0L) {
            sample %= this.mTotalSamples;
        }
        long time = (long)((float)(sample * 1000L) / this.mFormat.getSampleRate());
        return (int)time;
    }

    public void setPosition(int pos) {
    }

    public int getSamplePosition() {
        if (this.mLine == null) {
            return 0;
        }
        long sample = this.mLine.getLongFramePosition();
        if (this.mTotalSamples != 0L) {
            sample %= this.mTotalSamples;
        }
        return (int)sample;
    }

    public void setSamplePosition(int sample) {
        if (this.mLine != null && !this.mLine.isActive()) {
            this.mStartOffset = sample;
        }
    }

    public int getTotalTime() {
        if (this.mAudioStream == null || this.mFormat == null) {
            return 0;
        }
        long length = this.mAudioStream.getFrameLength();
        long time = (long)((float)(length * 1000L) / this.mFormat.getSampleRate());
        return (int)time;
    }

    public int getFrequency() {
        if (this.mFormat == null) {
            return 0;
        }
        return (int)this.mFormat.getSampleRate();
    }

    public void setFrequency(int freq) {
    }

    public int getBitsPerSample() {
        if (this.mFormat == null) {
            return 0;
        }
        return this.mFormat.getSampleSizeInBits();
    }

    public int getChannels() {
        if (this.mFormat == null) {
            return 0;
        }
        return this.mFormat.getChannels();
    }

    class EventThread
    implements Runnable {
        EventThread() {
        }

        @Override
        public void run() {
            ArrayList<WaveLabel> labels = SoundStream.this.mLoopManager.getLabels();
            if (labels != null && labels.size() > 0) {
                int count = labels.size();
                int nextIndex = 0;
                long nextPosition = labels.get((int)nextIndex).Position;
                int sampleRate = (int)SoundStream.this.mFormat.getSampleRate();
                long lastPosition = 0L;
                while (SoundStream.this.mIsPlaing) {
                    WaveLabel label;
                    long pos = SoundStream.this.mLine.getLongFramePosition();
                    if (SoundStream.this.mTotalSamples != 0L) {
                        pos %= SoundStream.this.mTotalSamples;
                    }
                    if (pos < lastPosition) {
                        while (nextIndex < count) {
                            label = labels.get(nextIndex);
                            SoundStream.this.putLabelEvent(label.Name);
                            ++nextIndex;
                        }
                        nextIndex = 0;
                        nextPosition = labels.get((int)nextIndex).Position;
                    }
                    if (pos >= nextPosition && nextIndex < count) {
                        label = labels.get(nextIndex);
                        SoundStream.this.putLabelEvent(label.Name);
                        ++nextIndex;
                        while (nextIndex < count) {
                            label = labels.get(nextIndex);
                            nextPosition = label.Position;
                            if (pos < nextPosition) break;
                            SoundStream.this.putLabelEvent(label.Name);
                            ++nextIndex;
                        }
                    }
                    long wait = 0L;
                    if (pos < nextPosition) {
                        wait = nextPosition - pos;
                        wait = wait * 1000L / (long)sampleRate - 1L;
                    }
                    lastPosition = pos;
                    if (wait <= 0L) continue;
                    try {
                        Thread.sleep(wait);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

