/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2env;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import jp.kirikiri.tjs2.BinaryStream;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.msg.Message;

public class TLGLoader {
    private static final byte[] HEADER;
    private static final byte[] HEADER_TLG5;
    private static final byte[] HEADER_TLG6;
    private static final int TAGS = 1936154996;
    static final int TLG6_H_BLOCK_SIZE = 8;
    static final int TLG6_W_BLOCK_SIZE = 8;
    private static final int TLG6_GOLOMB_N_COUNT = 4;
    private static final int TLG6_LeadingZeroTable_BITS = 12;
    private static final int TLG6_LeadingZeroTable_SIZE = 4096;
    private static byte[] TLG6LeadingZeroTable;
    private static final int TLG6GolombBitLengthTable_SIZE = 1024;
    private static byte[][] TLG6GolombBitLengthTable;
    private static final short[][] TLG6GolombCompressed;

    static {
        byte[] byArray = new byte[11];
        byArray[0] = 84;
        byArray[1] = 76;
        byArray[2] = 71;
        byArray[3] = 48;
        byArray[4] = 46;
        byArray[5] = 48;
        byArray[7] = 115;
        byArray[8] = 100;
        byArray[9] = 115;
        byArray[10] = 26;
        HEADER = byArray;
        byte[] byArray2 = new byte[11];
        byArray2[0] = 84;
        byArray2[1] = 76;
        byArray2[2] = 71;
        byArray2[3] = 53;
        byArray2[4] = 46;
        byArray2[5] = 48;
        byArray2[7] = 114;
        byArray2[8] = 97;
        byArray2[9] = 119;
        byArray2[10] = 26;
        HEADER_TLG5 = byArray2;
        byte[] byArray3 = new byte[11];
        byArray3[0] = 84;
        byArray3[1] = 76;
        byArray3[2] = 71;
        byArray3[3] = 54;
        byArray3[4] = 46;
        byArray3[5] = 48;
        byArray3[7] = 114;
        byArray3[8] = 97;
        byArray3[9] = 119;
        byArray3[10] = 26;
        HEADER_TLG6 = byArray3;
        TLG6GolombCompressed = new short[][]{{3, 7, 15, 27, 63, 108, 223, 448, 130}, {3, 5, 13, 24, 51, 95, 192, 384, 257}, {2, 5, 12, 21, 39, 86, 155, 320, 384}, {2, 3, 9, 18, 33, 61, 129, 258, 511}};
    }

    public static final BufferedImage loadTLG(BinaryStream src, int mode, HashMap<String, String> metainfo) throws TJSException {
        BufferedImage result = null;
        byte[] mark = new byte[11];
        src.setPosition(0L);
        src.read(mark);
        if (Arrays.equals(HEADER, mark)) {
            byte[] intbuf = new byte[4];
            src.read(intbuf);
            ByteBuffer ibuff = ByteBuffer.wrap(intbuf);
            ibuff.order(ByteOrder.LITTLE_ENDIAN);
            ibuff.position(0);
            int rawlen = ibuff.getInt();
            long imgPos = src.getPosition();
            src.seek(rawlen + 11 + 4, 0);
            while (4 == src.read(intbuf)) {
                ibuff.position(0);
                int chunkname = ibuff.getInt();
                src.read(intbuf);
                ibuff.position(0);
                int chunksize = ibuff.getInt();
                if (1936154996 == chunkname) {
                    byte[] tag = null;
                    String name = null;
                    String value = null;
                    try {
                        try {
                            tag = new byte[chunksize + 1];
                            src.read(tag);
                            tag[chunksize] = 0;
                            if (metainfo != null) {
                                int i = 0;
                                while (i < chunksize) {
                                    int namelen = 0;
                                    while (tag[i] >= 48 && tag[i] <= 57) {
                                        namelen = namelen * 10 + tag[i] - 48;
                                        ++i;
                                    }
                                    if (tag[i] != 58) {
                                        Message.throwExceptionMessage("TLG \u8aad\u307f\u8fbc\u307f\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f/%1", "Malformed TLG SDS tag structure, missing colon after name length");
                                    }
                                    name = new String(tag, ++i, namelen, "MS932");
                                    if (tag[i += namelen] != 61) {
                                        Message.throwExceptionMessage("TLG \u8aad\u307f\u8fbc\u307f\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f/%1", "Malformed TLG SDS tag structure, missing equals after name");
                                    }
                                    ++i;
                                    int valuelen = 0;
                                    while (tag[i] >= 48 && tag[i] <= 57) {
                                        valuelen = valuelen * 10 + tag[i] - 48;
                                        ++i;
                                    }
                                    if (tag[i] != 58) {
                                        Message.throwExceptionMessage("TLG \u8aad\u307f\u8fbc\u307f\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f/%1", "Malformed TLG SDS tag structure, missing colon after value length");
                                    }
                                    value = new String(tag, ++i, valuelen, "MS932");
                                    if (tag[i += valuelen] != 44) {
                                        Message.throwExceptionMessage("TLG \u8aad\u307f\u8fbc\u307f\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f/%1", "Malformed TLG SDS tag structure, missing comma after a tag");
                                    }
                                    ++i;
                                    metainfo.put(name, value);
                                    name = null;
                                    value = null;
                                }
                            }
                        }
                        catch (UnsupportedEncodingException e) {
                            Message.throwExceptionMessage("TLG \u8aad\u307f\u8fbc\u307f\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f/%1", "Malformed TLG SDS tag structure, character cannot decoeded");
                            tag = null;
                            name = null;
                            value = null;
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        tag = null;
                        name = null;
                        value = null;
                        throw throwable;
                    }
                    tag = null;
                    name = null;
                    value = null;
                    continue;
                }
                src.setPosition(src.getPosition() + (long)chunksize);
            }
            src.setPosition(imgPos);
            result = TLGLoader.internalLoadTLG(src, mode, metainfo);
        } else {
            src.seek(0L, 0);
            result = TLGLoader.internalLoadTLG(src, mode, metainfo);
        }
        return result;
    }

    private static final BufferedImage internalLoadTLG(BinaryStream src, int mode, HashMap<String, String> metainfo) throws TJSException {
        byte[] mark = new byte[11];
        src.read(mark);
        if (Arrays.equals(HEADER_TLG5, mark)) {
            return TLGLoader.LoadTLG5(src, mode, metainfo);
        }
        if (Arrays.equals(HEADER_TLG6, mark)) {
            return TLGLoader.LoadTLG6(src, mode, metainfo);
        }
        Message.throwExceptionMessage("TLG \u8aad\u307f\u8fbc\u307f\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f/%1", "Invalid TLG header or unsupported TLG version.");
        return null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static final BufferedImage LoadTLG5(BinaryStream src, int mode, HashMap<String, String> metainfo) throws TJSException {
        if (mode != 0) {
            Message.throwExceptionMessage("TLG \u8aad\u307f\u8fbc\u307f\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f/%1", "TLG cannot be used as universal transition rule, province(_p) or mask(_m) images.");
        }
        result = null;
        mark = new byte[13];
        src.read(mark);
        buff = ByteBuffer.wrap(mark);
        buff.order(ByteOrder.LITTLE_ENDIAN);
        buff.position(0);
        colors = buff.get();
        width = buff.getInt();
        height = buff.getInt();
        blockheight = buff.getInt();
        if (colors != 3 && colors != 4) {
            Message.throwExceptionMessage("TLG \u8aad\u307f\u8fbc\u307f\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f/%1", "Unsupported color type.");
        }
        blockcount = (height - 1) / blockheight + 1;
        src.setPosition(src.getPosition() + (long)(blockcount * 4));
        imgType = 2;
        if (metainfo != null && (imgMode = metainfo.get("mode")) != null && imgMode.equals("addalpha")) {
            imgType = 3;
        }
        result = new BufferedImage(width, height, imgType);
        imagedata = null;
        srcRaster = result.getRaster();
        dataBuff = srcRaster.getDataBuffer();
        type = dataBuff.getDataType();
        if (type == 3) {
            srcBuff = (DataBufferInt)dataBuff;
            imagedata = srcBuff.getData();
        } else {
            Message.throwExceptionMessage("TLG \u8aad\u307f\u8fbc\u307f\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f/%1", "Internal error.");
        }
        inbuf = null;
        outbuf /* !! */  = new byte[4][];
        text = new byte[4096];
        rz = 0;
        try {
            inbuf = new byte[blockheight * width + 10];
            i = 0;
            while (i < colors) {
                outbuf /* !! */ [i] = new byte[blockheight * width + 10];
                ++i;
            }
            prevline = -1;
            y_blk = 0;
            while (y_blk < height) {
                c = 0;
                while (c < colors) {
                    src.read(mark, 0, 5);
                    buff.position(0);
                    m = buff.get();
                    size = buff.getInt();
                    if (m == 0) {
                        src.read(inbuf, 0, size);
                        rz = TLGLoader.decompressSlideLZSS(outbuf /* !! */ [c], inbuf, size, text, rz);
                    } else {
                        src.read(outbuf /* !! */ [c], 0, size);
                    }
                    ++c;
                }
                y_lim = y_blk + blockheight;
                if (y_lim > height) {
                    y_lim = height;
                }
                outbufoff = 0;
                y = y_blk;
                while (y < y_lim) {
                    block29: {
                        block28: {
                            current_org = current = y * width;
                            if (prevline < 0) break block28;
                            end = outbufoff + width;
                            switch (colors) {
                                case 3: {
                                    tr = 0;
                                    tg = 0;
                                    tb = 0;
                                    while (outbufoff < end) {
                                        b = outbuf /* !! */ [0][outbufoff] & 255;
                                        g = outbuf /* !! */ [1][outbufoff] & 255;
                                        r = outbuf /* !! */ [2][outbufoff] & 255;
                                        pcolor = imagedata[prevline];
                                        pb = pcolor & 255;
                                        pg = pcolor >>> 8 & 255;
                                        pr = pcolor >>> 16 & 255;
                                        imagedata[current] = ((tb += (b += g)) + pb & 255) + (((tg += g) + pg & 255) << 8) + (((tr += (r += g)) + pr & 255) << 16) + -16777216;
                                        ++current;
                                        ++prevline;
                                        ++outbufoff;
                                    }
                                    break block29;
                                }
                                case 4: {
                                    tr = 0;
                                    tg = 0;
                                    tb = 0;
                                    ta = 0;
                                    while (outbufoff < end) {
                                        b = outbuf /* !! */ [0][outbufoff] & 255;
                                        g = outbuf /* !! */ [1][outbufoff] & 255;
                                        r = outbuf /* !! */ [2][outbufoff] & 255;
                                        a = outbuf /* !! */ [3][outbufoff] & 255;
                                        b += g;
                                        r += g;
                                        pcolor = imagedata[prevline];
                                        pb = pcolor & 255;
                                        pg = pcolor >>> 8 & 255;
                                        pr = pcolor >>> 16 & 255;
                                        pa = pcolor >>> 24 & 255;
                                        imagedata[current] = ((tb += b) + pb & 255) + (((tg += g) + pg & 255) << 8) + (((tr += r) + pr & 255) << 16) + (((ta += a) + pa & 255) << 24);
                                        ++current;
                                        ++prevline;
                                        ++outbufoff;
                                    }
                                    break block1;
                                }
                            }
                            break block29;
                        }
                        end = outbufoff + width;
                        switch (colors) {
                            case 3: {
                                pr = 0;
                                pg = 0;
                                pb = 0;
                                while (outbufoff < end) {
                                    b = outbuf /* !! */ [0][outbufoff] & 255;
                                    g = outbuf /* !! */ [1][outbufoff] & 255;
                                    r = outbuf /* !! */ [2][outbufoff] & 255;
                                    imagedata[current] = -16777216 | ((pr += (r += g)) & 255) << 16 | ((pg += g) & 255) << 8 | (pb += (b += g)) & 255;
                                    ++current;
                                    ++outbufoff;
                                }
                                break;
                            }
                            case 4: {
                                pr = 0;
                                pg = 0;
                                pb = 0;
                                pa = 0;
                                while (outbufoff < end) {
                                    b = outbuf /* !! */ [0][outbufoff] & 255;
                                    g = outbuf /* !! */ [1][outbufoff] & 255;
                                    r = outbuf /* !! */ [2][outbufoff] & 255;
                                    a = outbuf /* !! */ [3][outbufoff] & 255;
                                    imagedata[current] = ((pa += a) & 255) << 24 | ((pr += (r += g)) & 255) << 16 | ((pg += g) & 255) << 8 | (pb += (b += g)) & 255;
                                    ++current;
                                    ++outbufoff;
                                }
                                break;
                            }
                        }
                    }
                    prevline = current_org;
                    ++y;
                }
                y_blk += blockheight;
            }
        }
        finally {
            inbuf = null;
            text = null;
            i = 0;
            ** while (i < colors)
        }
lbl-1000:
        // 1 sources

        {
            outbuf /* !! */ [i] = null;
            ++i;
            continue;
        }
lbl161:
        // 1 sources

        outbuf /* !! */  = null;
        return result;
    }

    private static final int decompressSlideLZSS(byte[] out, byte[] in, int insize, byte[] text, int initialr) {
        int r = initialr;
        int flags = 0;
        int o = 0;
        int i = 0;
        while (i < insize) {
            if (((flags >>>= 1) & 0x100) == 0) {
                flags = in[i] & 0xFF | 0xFF00;
                ++i;
            }
            if ((flags & 1) == 1) {
                int mpos = in[i] & 0xFF | (in[i + 1] & 0xF) << 8;
                int mlen = (in[i + 1] & 0xF0) >>> 4;
                i += 2;
                if ((mlen += 3) == 18) {
                    mlen += in[i] & 0xFF;
                    ++i;
                }
                while (mlen > 0) {
                    int n = o++;
                    int n2 = r++;
                    byte by = text[mpos++];
                    text[n2] = by;
                    out[n] = by;
                    mpos &= 0xFFF;
                    r &= 0xFFF;
                    --mlen;
                }
                continue;
            }
            byte c = in[i];
            ++i;
            out[o] = c;
            ++o;
            text[r] = c;
            ++r;
            r &= 0xFFF;
        }
        return r;
    }

    public static final BufferedImage LoadTLG6(BinaryStream src, int mode, HashMap<String, String> metainfo) throws TJSException {
        String imgMode;
        if (mode != 0) {
            Message.throwExceptionMessage("TLG \u8aad\u307f\u8fbc\u307f\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f/%1", "TLG cannot be used as universal transition rule, province(_p) or mask(_m) images.");
        }
        byte[] buf = new byte[12];
        src.read(buf, 0, 4);
        int colors = buf[0];
        if (colors != 1 && colors != 4 && colors != 3) {
            Message.throwExceptionMessage("TLG \u8aad\u307f\u8fbc\u307f\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f/%1", "Unsupported color count : " + colors);
        }
        if (buf[1] != 0) {
            Message.throwExceptionMessage("TLG \u8aad\u307f\u8fbc\u307f\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f/%1", "Data flag must be 0 (any flags are not yet supported)");
        }
        if (buf[2] != 0) {
            Message.throwExceptionMessage("TLG \u8aad\u307f\u8fbc\u307f\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f/%1", "Unsupported color type : " + buf[1]);
        }
        if (buf[3] != 0) {
            Message.throwExceptionMessage("TLG \u8aad\u307f\u8fbc\u307f\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f/%1", "External golomb bit length table is not yet supported.");
        }
        src.read(buf, 0, 12);
        ByteBuffer buff = ByteBuffer.wrap(buf);
        buff.order(ByteOrder.LITTLE_ENDIAN);
        buff.position(0);
        int width = buff.getInt();
        int height = buff.getInt();
        int max_bit_length = buff.getInt();
        int imgType = 2;
        if (metainfo != null && (imgMode = metainfo.get("mode")) != null && imgMode.equals("addalpha")) {
            imgType = 3;
        }
        BufferedImage result = new BufferedImage(width, height, imgType);
        int[] imagedata = null;
        WritableRaster srcRaster = result.getRaster();
        DataBuffer dataBuff = srcRaster.getDataBuffer();
        int type = dataBuff.getDataType();
        if (type == 3) {
            DataBufferInt srcBuff = (DataBufferInt)dataBuff;
            imagedata = srcBuff.getData();
        } else {
            Message.throwExceptionMessage("TLG \u8aad\u307f\u8fbc\u307f\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f/%1", "Internal error.");
        }
        int x_block_count = (width - 1) / 8 + 1;
        int y_block_count = (height - 1) / 8 + 1;
        int main_count = width / 8;
        int fraction = width - main_count * 8;
        byte[] bit_pool = null;
        int[] pixelbuf = null;
        byte[] filter_types = null;
        byte[] LZSS_text = null;
        int[] zeroline = null;
        try {
            bit_pool = new byte[max_bit_length / 8 + 5];
            pixelbuf = new int[width * 8 + 1];
            filter_types = new byte[x_block_count * y_block_count];
            zeroline = new int[width];
            LZSS_text = new byte[4096];
            if (colors == 3) {
                Arrays.fill(zeroline, -16777216);
            }
            ByteBuffer p = ByteBuffer.wrap(LZSS_text);
            p.order(ByteOrder.LITTLE_ENDIAN);
            p.position(0);
            int i = 0;
            while (i < 0x20202020) {
                int j = 0;
                while (j < 0x10101010) {
                    p.putInt(i);
                    p.putInt(j);
                    j += 0x1010101;
                }
                i += 0x1010101;
            }
            src.read(buf, 0, 4);
            buff.position(0);
            int inbuf_size = buff.getInt();
            byte[] inbuf = new byte[inbuf_size];
            try {
                src.read(inbuf);
                TLGLoader.decompressSlideLZSS(filter_types, inbuf, inbuf_size, LZSS_text, 0);
            }
            finally {
                inbuf = null;
            }
            int prevline = -1;
            int y = 0;
            while (y < height) {
                int ylim = y + 8;
                if (ylim >= height) {
                    ylim = height;
                }
                int pixel_count = (ylim - y) * width;
                int c = 0;
                while (c < colors) {
                    src.read(buf, 0, 4);
                    buff.position(0);
                    int bit_length = buff.getInt();
                    int method = bit_length >>> 30 & 3;
                    int byte_length = (bit_length &= 0x3FFFFFFF) / 8;
                    if (bit_length % 8 != 0) {
                        ++byte_length;
                    }
                    src.read(bit_pool, 0, byte_length);
                    switch (method) {
                        case 0: {
                            if (c == 0 && colors != 1) {
                                TLGLoader.decodeGolombValuesForFirst(pixelbuf, pixel_count, bit_pool);
                                break;
                            }
                            TLGLoader.decodeGolombValues(pixelbuf, c, pixel_count, bit_pool);
                            break;
                        }
                        default: {
                            Message.throwExceptionMessage("TLG \u8aad\u307f\u8fbc\u307f\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f/%1", "Unsupported entropy coding method");
                        }
                    }
                    ++c;
                }
                int ft_pos = y / 8 * x_block_count;
                int skipbytes = (ylim - y) * 8;
                int yy = y;
                while (yy < ylim) {
                    int curline = yy * width;
                    int dir = yy & 1 ^ 1;
                    int oddskip = ylim - yy - 1 - (yy - y);
                    if (main_count != 0) {
                        int start = (width < 8 ? width : 8) * (yy - y);
                        TLGLoader.TLG6DecodeLine(imagedata, prevline, zeroline, curline, width, main_count, filter_types, ft_pos, skipbytes, pixelbuf, start, colors == 3 ? -16777216 : 0, oddskip, dir);
                    }
                    if (main_count != x_block_count) {
                        int ww = fraction;
                        if (ww > 8) {
                            ww = 8;
                        }
                        int start = ww * (yy - y);
                        TLGLoader.TLG6DecodeLineGeneric(imagedata, prevline, zeroline, curline, width, main_count, x_block_count, filter_types, ft_pos, skipbytes, pixelbuf, start, colors == 3 ? -16777216 : 0, oddskip, dir);
                    }
                    prevline = curline;
                    ++yy;
                }
                y += 8;
            }
        }
        finally {
            bit_pool = null;
            pixelbuf = null;
            filter_types = null;
            zeroline = null;
            LZSS_text = null;
        }
        return result;
    }

    private static final void TLG6InitLeadingZeroTable() {
        TLG6LeadingZeroTable = new byte[4096];
        int i = 0;
        while (i < 4096) {
            int cnt = 0;
            int j = 1;
            while (j != 4096 && (i & j) == 0) {
                j <<= 1;
                ++cnt;
            }
            ++cnt;
            if (j == 4096) {
                cnt = 0;
            }
            TLGLoader.TLG6LeadingZeroTable[i] = (byte)(cnt & 0xFF);
            ++i;
        }
    }

    private static final void TLG6InitGolombTable() throws TJSException {
        TLG6GolombBitLengthTable = new byte[1024][];
        int i = 0;
        while (i < 1024) {
            TLGLoader.TLG6GolombBitLengthTable[i] = new byte[4];
            ++i;
        }
        int n = 0;
        while (n < 4) {
            int a = 0;
            int i2 = 0;
            while (i2 < 9) {
                int j = 0;
                while (j < TLG6GolombCompressed[n][i2]) {
                    TLGLoader.TLG6GolombBitLengthTable[a++][n] = (byte)i2;
                    ++j;
                }
                ++i2;
            }
            if (a != 1024) {
                Message.throwExceptionMessage("\u5185\u90e8\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f: at %1 line %2");
            }
            ++n;
        }
    }

    private static final void decodeGolombValuesForFirst(int[] pixelbuf, int pixel_count, byte[] bit_pool) throws TJSException {
        if (TLG6LeadingZeroTable == null) {
            TLGLoader.TLG6InitLeadingZeroTable();
            TLGLoader.TLG6InitGolombTable();
        }
        int n = 3;
        int a = 0;
        int bit_pos = 1;
        byte zero = (byte)((bit_pool[0] & 1) == 0 ? 1 : 0);
        int bit_pool_pos = 0;
        int pixelbuf_pos = 0;
        while (pixelbuf_pos < pixel_count) {
            int b;
            int t = (bit_pool[bit_pool_pos + 0] & 0xFF) + ((bit_pool[bit_pool_pos + 1] & 0xFF) << 8) + ((bit_pool[bit_pool_pos + 2] & 0xFF) << 16) + ((bit_pool[bit_pool_pos + 3] & 0xFF) << 24) >>> bit_pos;
            int bit_count = b = TLG6LeadingZeroTable[t & 0xFFF] & 0xFF;
            while (b == 0) {
                bit_count += 12;
                t = (bit_pool[(bit_pool_pos += (bit_pos += 12) >>> 3) + 0] & 0xFF) + ((bit_pool[bit_pool_pos + 1] & 0xFF) << 8) + ((bit_pool[bit_pool_pos + 2] & 0xFF) << 16) + ((bit_pool[bit_pool_pos + 3] & 0xFF) << 24) >>> (bit_pos &= 7);
                b = TLG6LeadingZeroTable[t & 0xFFF] & 0xFF;
                bit_count += b;
            }
            int count = 1 << --bit_count;
            count += (bit_pool[(bit_pool_pos += (bit_pos += b) >>> 3) + 0] & 0xFF) + ((bit_pool[bit_pool_pos + 1] & 0xFF) << 8) + ((bit_pool[bit_pool_pos + 2] & 0xFF) << 16) + ((bit_pool[bit_pool_pos + 3] & 0xFF) << 24) >>> (bit_pos &= 7) & count - 1;
            bit_pool_pos += (bit_pos += bit_count) >>> 3;
            bit_pos &= 7;
            if (zero != 0) {
                do {
                    pixelbuf[pixelbuf_pos] = 0;
                    ++pixelbuf_pos;
                } while (--count != 0);
                zero = (byte)(zero ^ 1);
                continue;
            }
            do {
                int bit_count2;
                int b2;
                byte k = TLG6GolombBitLengthTable[a][n];
                int t2 = (bit_pool[bit_pool_pos + 0] & 0xFF) + ((bit_pool[bit_pool_pos + 1] & 0xFF) << 8) + ((bit_pool[bit_pool_pos + 2] & 0xFF) << 16) + ((bit_pool[bit_pool_pos + 3] & 0xFF) << 24) >>> bit_pos;
                if (t2 != 0) {
                    bit_count2 = b2 = TLG6LeadingZeroTable[t2 & 0xFFF] & 0xFF;
                    while (b2 == 0) {
                        bit_count2 += 12;
                        t2 = (bit_pool[(bit_pool_pos += (bit_pos += 12) >>> 3) + 0] & 0xFF) + ((bit_pool[bit_pool_pos + 1] & 0xFF) << 8) + ((bit_pool[bit_pool_pos + 2] & 0xFF) << 16) + ((bit_pool[bit_pool_pos + 3] & 0xFF) << 24) >>> (bit_pos &= 7);
                        b2 = TLG6LeadingZeroTable[t2 & 0xFFF] & 0xFF;
                        bit_count2 += b2;
                    }
                    --bit_count2;
                } else {
                    bit_count2 = bit_pool[(bit_pool_pos += 5) - 1] & 0xFF;
                    bit_pos = 0;
                    t2 = (bit_pool[bit_pool_pos + 0] & 0xFF) + ((bit_pool[bit_pool_pos + 1] & 0xFF) << 8) + ((bit_pool[bit_pool_pos + 2] & 0xFF) << 16) + ((bit_pool[bit_pool_pos + 3] & 0xFF) << 24);
                    b2 = 0;
                }
                int v = (bit_count2 << k) + (t2 >>> b2 & (1 << k) - 1);
                int sign = (v & 1) - 1;
                a += (v >>>= 1);
                pixelbuf[pixelbuf_pos] = (v ^ sign) + sign + 1 & 0xFF;
                ++pixelbuf_pos;
                bit_pos += b2;
                bit_pool_pos += (bit_pos += k) >>> 3;
                bit_pos &= 7;
                if (--n >= 0) continue;
                a >>>= 1;
                n = 3;
            } while (--count != 0);
            zero = (byte)(zero ^ 1);
        }
    }

    private static void decodeGolombValues(int[] pixelbuf, int c, int pixel_count, byte[] bit_pool) throws TJSException {
        if (TLG6LeadingZeroTable == null) {
            TLGLoader.TLG6InitLeadingZeroTable();
            TLGLoader.TLG6InitGolombTable();
        }
        int shift = c *= 8;
        int mask = ~(255 << shift);
        int n = 3;
        int a = 0;
        int bit_pos = 1;
        byte zero = (byte)((bit_pool[0] & 1) == 0 ? 1 : 0);
        int bit_pool_pos = 0;
        int pixelbuf_pos = 0;
        while (pixelbuf_pos < pixel_count) {
            int b;
            int t = (bit_pool[bit_pool_pos + 0] & 0xFF) + ((bit_pool[bit_pool_pos + 1] & 0xFF) << 8) + ((bit_pool[bit_pool_pos + 2] & 0xFF) << 16) + ((bit_pool[bit_pool_pos + 3] & 0xFF) << 24) >>> bit_pos;
            int bit_count = b = TLG6LeadingZeroTable[t & 0xFFF] & 0xFF;
            while (b == 0) {
                bit_count += 12;
                t = (bit_pool[(bit_pool_pos += (bit_pos += 12) >>> 3) + 0] & 0xFF) + ((bit_pool[bit_pool_pos + 1] & 0xFF) << 8) + ((bit_pool[bit_pool_pos + 2] & 0xFF) << 16) + ((bit_pool[bit_pool_pos + 3] & 0xFF) << 24) >>> (bit_pos &= 7);
                b = TLG6LeadingZeroTable[t & 0xFFF] & 0xFF;
                bit_count += b;
            }
            int count = 1 << --bit_count;
            count += (bit_pool[(bit_pool_pos += (bit_pos += b) >>> 3) + 0] & 0xFF) + ((bit_pool[bit_pool_pos + 1] & 0xFF) << 8) + ((bit_pool[bit_pool_pos + 2] & 0xFF) << 16) + ((bit_pool[bit_pool_pos + 3] & 0xFF) << 24) >>> (bit_pos &= 7) & count - 1;
            bit_pool_pos += (bit_pos += bit_count) >>> 3;
            bit_pos &= 7;
            if (zero != 0) {
                do {
                    pixelbuf[pixelbuf_pos] = pixelbuf[pixelbuf_pos] & mask;
                    ++pixelbuf_pos;
                } while (--count != 0);
                zero = (byte)(zero ^ 1);
                continue;
            }
            do {
                int bit_count2;
                int b2;
                byte k = TLG6GolombBitLengthTable[a][n];
                int t2 = (bit_pool[bit_pool_pos + 0] & 0xFF) + ((bit_pool[bit_pool_pos + 1] & 0xFF) << 8) + ((bit_pool[bit_pool_pos + 2] & 0xFF) << 16) + ((bit_pool[bit_pool_pos + 3] & 0xFF) << 24) >>> bit_pos;
                if (t2 != 0) {
                    bit_count2 = b2 = TLG6LeadingZeroTable[t2 & 0xFFF] & 0xFF;
                    while (b2 == 0) {
                        bit_count2 += 12;
                        t2 = (bit_pool[(bit_pool_pos += (bit_pos += 12) >>> 3) + 0] & 0xFF) + ((bit_pool[bit_pool_pos + 1] & 0xFF) << 8) + ((bit_pool[bit_pool_pos + 2] & 0xFF) << 16) + ((bit_pool[bit_pool_pos + 3] & 0xFF) << 24) >>> (bit_pos &= 7);
                        b2 = TLG6LeadingZeroTable[t2 & 0xFFF] & 0xFF;
                        bit_count2 += b2;
                    }
                    --bit_count2;
                } else {
                    bit_count2 = bit_pool[(bit_pool_pos += 5) - 1] & 0xFF;
                    bit_pos = 0;
                    t2 = (bit_pool[bit_pool_pos + 0] & 0xFF) + ((bit_pool[bit_pool_pos + 1] & 0xFF) << 8) + ((bit_pool[bit_pool_pos + 2] & 0xFF) << 16) + ((bit_pool[bit_pool_pos + 3] & 0xFF) << 24);
                    b2 = 0;
                }
                int v = (bit_count2 << k) + (t2 >>> b2 & (1 << k) - 1);
                int sign = (v & 1) - 1;
                a += (v >>>= 1);
                pixelbuf[pixelbuf_pos] = pixelbuf[pixelbuf_pos] & mask | ((v ^ sign) + sign + 1 & 0xFF) << shift;
                ++pixelbuf_pos;
                bit_pos += b2;
                bit_pool_pos += (bit_pos += k) >>> 3;
                bit_pos &= 7;
                if (--n >= 0) continue;
                a >>>= 1;
                n = 3;
            } while (--count != 0);
            zero = (byte)(zero ^ 1);
        }
    }

    private static final int make_gt_mask(int a, int b) {
        int tmp2 = ~b;
        int tmp = (a & tmp2) + ((a ^ tmp2) >>> 1 & 0x7F7F7F7F) & 0x80808080;
        tmp = (tmp >>> 7) + 0x7F7F7F7F ^ 0x7F7F7F7F;
        return tmp;
    }

    private static final int packed_bytes_add(int a, int b) {
        int tmp = ((a & b) << 1) + ((a ^ b) & 0xFEFEFEFE) & 0x1010100;
        return a + b - tmp;
    }

    private static final int med2(int a, int b, int c) {
        int aa_gt_bb = TLGLoader.make_gt_mask(a, b);
        int a_xor_b_and_aa_gt_bb = (a ^ b) & aa_gt_bb;
        int aa = a_xor_b_and_aa_gt_bb ^ a;
        int bb = a_xor_b_and_aa_gt_bb ^ b;
        int n = TLGLoader.make_gt_mask(c, bb);
        int nn = TLGLoader.make_gt_mask(aa, c);
        int m = ~(n | nn);
        return n & aa | nn & bb | (bb & m) - (c & m) + (aa & m);
    }

    private static final int med(int a, int b, int c, int v) {
        return TLGLoader.packed_bytes_add(TLGLoader.med2(a, b, c), v);
    }

    private static final int avg(int a, int b, int c, int v) {
        int pack = (a & b) + (((a ^ b) & 0xFEFEFEFE) >>> 1) + ((a ^ b) & 0x1010101);
        return TLGLoader.packed_bytes_add(pack, v);
    }

    private static final void TLG6DecodeLineGeneric(int[] imagedata, int prevline, int[] zeroline, int curline, int width, int start_block, int block_limit, byte[] filtertypes, int ft_pos, int skipblockbytes, int[] in, int in_pos, int initialp, int oddskip, int dir) {
        int up;
        int p;
        int[] prevdata;
        if (prevline < 0) {
            prevdata = zeroline;
            prevline = 0;
        } else {
            prevdata = imagedata;
        }
        if (start_block != 0) {
            p = imagedata[(curline += start_block * 8) - 1];
            up = prevdata[(prevline += start_block * 8) - 1];
        } else {
            p = up = initialp;
        }
        in_pos += skipblockbytes * start_block;
        int step = (dir & 1) != 0 ? 1 : -1;
        int i = start_block;
        while (i < block_limit) {
            int w = width - i * 8;
            if (w > 8) {
                w = 8;
            }
            int ww = w;
            if (step == -1) {
                in_pos += ww - 1;
            }
            if ((i & 1) != 0) {
                in_pos += oddskip * ww;
            }
            switch (filtertypes[ft_pos + i]) {
                case 0: {
                    int u;
                    int R;
                    int G;
                    int B;
                    int IB;
                    int IG;
                    int IR;
                    int A;
                    do {
                        A = in[in_pos] >>> 24 & 0xFF;
                        IR = in[in_pos] >>> 16 & 0xFF;
                        IG = in[in_pos] >>> 8 & 0xFF;
                        B = IB = in[in_pos] & 0xFF;
                        G = IG;
                        R = IR;
                        u = prevdata[prevline];
                        p = TLGLoader.med(p, u, up, (0xFF0000 & R << 16) + (0xFF00 & G << 8) + (0xFF & B) + (A << 24));
                        up = u;
                        imagedata[curline] = p;
                        ++curline;
                        ++prevline;
                        in_pos += step;
                    } while (--w > 0);
                    break;
                }
                case 1: {
                    int u;
                    int R;
                    int G;
                    int B;
                    int IB;
                    int IG;
                    int IR;
                    int A;
                    do {
                        A = in[in_pos] >>> 24 & 0xFF;
                        IR = in[in_pos] >>> 16 & 0xFF;
                        IG = in[in_pos] >>> 8 & 0xFF;
                        B = IB = in[in_pos] & 0xFF;
                        G = IG;
                        R = IR;
                        u = prevdata[prevline];
                        p = TLGLoader.avg(p, u, up, (0xFF0000 & R << 16) + (0xFF00 & G << 8) + (0xFF & B) + (A << 24));
                        up = u;
                        imagedata[curline] = p;
                        ++curline;
                        ++prevline;
                        in_pos += step;
                    } while (--w > 0);
                    break;
                }
                case 2: {
                    int u;
                    int R;
                    int G;
                    int B;
                    int IB;
                    int IG;
                    int IR;
                    int A;
                    do {
                        A = in[in_pos] >>> 24 & 0xFF;
                        IR = in[in_pos] >>> 16 & 0xFF;
                        IG = in[in_pos] >>> 8 & 0xFF;
                        IB = in[in_pos] & 0xFF;
                        B = IB + IG;
                        G = IG;
                        R = IR + IG;
                        u = prevdata[prevline];
                        p = TLGLoader.med(p, u, up, (0xFF0000 & R << 16) + (0xFF00 & G << 8) + (0xFF & B) + (A << 24));
                        up = u;
                        imagedata[curline] = p;
                        ++curline;
                        ++prevline;
                        in_pos += step;
                    } while (--w > 0);
                    break;
                }
                case 3: {
                    int u;
                    int R;
                    int G;
                    int B;
                    int IB;
                    int IG;
                    int IR;
                    int A;
                    do {
                        A = in[in_pos] >>> 24 & 0xFF;
                        IR = in[in_pos] >>> 16 & 0xFF;
                        IG = in[in_pos] >>> 8 & 0xFF;
                        IB = in[in_pos] & 0xFF;
                        B = IB + IG;
                        G = IG;
                        R = IR + IG;
                        u = prevdata[prevline];
                        p = TLGLoader.avg(p, u, up, (0xFF0000 & R << 16) + (0xFF00 & G << 8) + (0xFF & B) + (A << 24));
                        up = u;
                        imagedata[curline] = p;
                        ++curline;
                        ++prevline;
                        in_pos += step;
                    } while (--w > 0);
                    break;
                }
                case 4: {
                    int u;
                    int R;
                    int G;
                    int B;
                    int IB;
                    int IG;
                    int IR;
                    int A;
                    do {
                        A = in[in_pos] >>> 24 & 0xFF;
                        IR = in[in_pos] >>> 16 & 0xFF;
                        IG = in[in_pos] >>> 8 & 0xFF;
                        B = IB = in[in_pos] & 0xFF;
                        G = IG + IB;
                        R = IR + IB + IG;
                        u = prevdata[prevline];
                        p = TLGLoader.med(p, u, up, (0xFF0000 & R << 16) + (0xFF00 & G << 8) + (0xFF & B) + (A << 24));
                        up = u;
                        imagedata[curline] = p;
                        ++curline;
                        ++prevline;
                        in_pos += step;
                    } while (--w > 0);
                    break;
                }
                case 5: {
                    int u;
                    int R;
                    int G;
                    int B;
                    int IB;
                    int IG;
                    int IR;
                    int A;
                    do {
                        A = in[in_pos] >>> 24 & 0xFF;
                        IR = in[in_pos] >>> 16 & 0xFF;
                        IG = in[in_pos] >>> 8 & 0xFF;
                        B = IB = in[in_pos] & 0xFF;
                        G = IG + IB;
                        R = IR + IB + IG;
                        u = prevdata[prevline];
                        p = TLGLoader.avg(p, u, up, (0xFF0000 & R << 16) + (0xFF00 & G << 8) + (0xFF & B) + (A << 24));
                        up = u;
                        imagedata[curline] = p;
                        ++curline;
                        ++prevline;
                        in_pos += step;
                    } while (--w > 0);
                    break;
                }
                case 6: {
                    int u;
                    int R;
                    int G;
                    int B;
                    int IB;
                    int IG;
                    int IR;
                    int A;
                    do {
                        A = in[in_pos] >>> 24 & 0xFF;
                        IR = in[in_pos] >>> 16 & 0xFF;
                        IG = in[in_pos] >>> 8 & 0xFF;
                        IB = in[in_pos] & 0xFF;
                        B = IB + IR + IG;
                        G = IG + IR;
                        R = IR;
                        u = prevdata[prevline];
                        p = TLGLoader.med(p, u, up, (0xFF0000 & R << 16) + (0xFF00 & G << 8) + (0xFF & B) + (A << 24));
                        up = u;
                        imagedata[curline] = p;
                        ++curline;
                        ++prevline;
                        in_pos += step;
                    } while (--w > 0);
                    break;
                }
                case 7: {
                    int u;
                    int R;
                    int G;
                    int B;
                    int IB;
                    int IG;
                    int IR;
                    int A;
                    do {
                        A = in[in_pos] >>> 24 & 0xFF;
                        IR = in[in_pos] >>> 16 & 0xFF;
                        IG = in[in_pos] >>> 8 & 0xFF;
                        IB = in[in_pos] & 0xFF;
                        B = IB + IR + IG;
                        G = IG + IR;
                        R = IR;
                        u = prevdata[prevline];
                        p = TLGLoader.avg(p, u, up, (0xFF0000 & R << 16) + (0xFF00 & G << 8) + (0xFF & B) + (A << 24));
                        up = u;
                        imagedata[curline] = p;
                        ++curline;
                        ++prevline;
                        in_pos += step;
                    } while (--w > 0);
                    break;
                }
                case 8: {
                    int u;
                    int R;
                    int G;
                    int B;
                    int IB;
                    int IG;
                    int IR;
                    int A;
                    do {
                        A = in[in_pos] >>> 24 & 0xFF;
                        IR = in[in_pos] >>> 16 & 0xFF;
                        IG = in[in_pos] >>> 8 & 0xFF;
                        IB = in[in_pos] & 0xFF;
                        B = IB + IR;
                        G = IG + IB + IR;
                        R = IR + IB + IR + IG;
                        u = prevdata[prevline];
                        p = TLGLoader.med(p, u, up, (0xFF0000 & R << 16) + (0xFF00 & G << 8) + (0xFF & B) + (A << 24));
                        up = u;
                        imagedata[curline] = p;
                        ++curline;
                        ++prevline;
                        in_pos += step;
                    } while (--w > 0);
                    break;
                }
                case 9: {
                    int u;
                    int R;
                    int G;
                    int B;
                    int IB;
                    int IG;
                    int IR;
                    int A;
                    do {
                        A = in[in_pos] >>> 24 & 0xFF;
                        IR = in[in_pos] >>> 16 & 0xFF;
                        IG = in[in_pos] >>> 8 & 0xFF;
                        IB = in[in_pos] & 0xFF;
                        B = IB + IR;
                        G = IG + IB + IR;
                        R = IR + IB + IR + IG;
                        u = prevdata[prevline];
                        p = TLGLoader.avg(p, u, up, (0xFF0000 & R << 16) + (0xFF00 & G << 8) + (0xFF & B) + (A << 24));
                        up = u;
                        imagedata[curline] = p;
                        ++curline;
                        ++prevline;
                        in_pos += step;
                    } while (--w > 0);
                    break;
                }
                case 10: {
                    int u;
                    int R;
                    int G;
                    int B;
                    int IB;
                    int IG;
                    int IR;
                    int A;
                    do {
                        A = in[in_pos] >>> 24 & 0xFF;
                        IR = in[in_pos] >>> 16 & 0xFF;
                        IG = in[in_pos] >>> 8 & 0xFF;
                        IB = in[in_pos] & 0xFF;
                        B = IB + IR;
                        G = IG + IB + IR;
                        R = IR;
                        u = prevdata[prevline];
                        p = TLGLoader.med(p, u, up, (0xFF0000 & R << 16) + (0xFF00 & G << 8) + (0xFF & B) + (A << 24));
                        up = u;
                        imagedata[curline] = p;
                        ++curline;
                        ++prevline;
                        in_pos += step;
                    } while (--w > 0);
                    break;
                }
                case 11: {
                    int u;
                    int R;
                    int G;
                    int B;
                    int IB;
                    int IG;
                    int IR;
                    int A;
                    do {
                        A = in[in_pos] >>> 24 & 0xFF;
                        IR = in[in_pos] >>> 16 & 0xFF;
                        IG = in[in_pos] >>> 8 & 0xFF;
                        IB = in[in_pos] & 0xFF;
                        B = IB + IR;
                        G = IG + IB + IR;
                        R = IR;
                        u = prevdata[prevline];
                        p = TLGLoader.avg(p, u, up, (0xFF0000 & R << 16) + (0xFF00 & G << 8) + (0xFF & B) + (A << 24));
                        up = u;
                        imagedata[curline] = p;
                        ++curline;
                        ++prevline;
                        in_pos += step;
                    } while (--w > 0);
                    break;
                }
                case 12: {
                    int u;
                    int R;
                    int G;
                    int B;
                    int IB;
                    int IG;
                    int IR;
                    int A;
                    do {
                        A = in[in_pos] >>> 24 & 0xFF;
                        IR = in[in_pos] >>> 16 & 0xFF;
                        IG = in[in_pos] >>> 8 & 0xFF;
                        IB = in[in_pos] & 0xFF;
                        B = IB + IG;
                        G = IG;
                        R = IR;
                        u = prevdata[prevline];
                        p = TLGLoader.med(p, u, up, (0xFF0000 & R << 16) + (0xFF00 & G << 8) + (0xFF & B) + (A << 24));
                        up = u;
                        imagedata[curline] = p;
                        ++curline;
                        ++prevline;
                        in_pos += step;
                    } while (--w > 0);
                    break;
                }
                case 13: {
                    int u;
                    int R;
                    int G;
                    int B;
                    int IB;
                    int IG;
                    int IR;
                    int A;
                    do {
                        A = in[in_pos] >>> 24 & 0xFF;
                        IR = in[in_pos] >>> 16 & 0xFF;
                        IG = in[in_pos] >>> 8 & 0xFF;
                        IB = in[in_pos] & 0xFF;
                        B = IB + IG;
                        G = IG;
                        R = IR;
                        u = prevdata[prevline];
                        p = TLGLoader.avg(p, u, up, (0xFF0000 & R << 16) + (0xFF00 & G << 8) + (0xFF & B) + (A << 24));
                        up = u;
                        imagedata[curline] = p;
                        ++curline;
                        ++prevline;
                        in_pos += step;
                    } while (--w > 0);
                    break;
                }
                case 14: {
                    int u;
                    int R;
                    int G;
                    int B;
                    int IB;
                    int IG;
                    int IR;
                    int A;
                    do {
                        A = in[in_pos] >>> 24 & 0xFF;
                        IR = in[in_pos] >>> 16 & 0xFF;
                        IG = in[in_pos] >>> 8 & 0xFF;
                        B = IB = in[in_pos] & 0xFF;
                        G = IG + IB;
                        R = IR;
                        u = prevdata[prevline];
                        p = TLGLoader.med(p, u, up, (0xFF0000 & R << 16) + (0xFF00 & G << 8) + (0xFF & B) + (A << 24));
                        up = u;
                        imagedata[curline] = p;
                        ++curline;
                        ++prevline;
                        in_pos += step;
                    } while (--w > 0);
                    break;
                }
                case 15: {
                    int u;
                    int R;
                    int G;
                    int B;
                    int IB;
                    int IG;
                    int IR;
                    int A;
                    do {
                        A = in[in_pos] >>> 24 & 0xFF;
                        IR = in[in_pos] >>> 16 & 0xFF;
                        IG = in[in_pos] >>> 8 & 0xFF;
                        B = IB = in[in_pos] & 0xFF;
                        G = IG + IB;
                        R = IR;
                        u = prevdata[prevline];
                        p = TLGLoader.avg(p, u, up, (0xFF0000 & R << 16) + (0xFF00 & G << 8) + (0xFF & B) + (A << 24));
                        up = u;
                        imagedata[curline] = p;
                        ++curline;
                        ++prevline;
                        in_pos += step;
                    } while (--w > 0);
                    break;
                }
                case 16: {
                    int u;
                    int R;
                    int G;
                    int B;
                    int IB;
                    int IG;
                    int IR;
                    int A;
                    do {
                        A = in[in_pos] >>> 24 & 0xFF;
                        IR = in[in_pos] >>> 16 & 0xFF;
                        IG = in[in_pos] >>> 8 & 0xFF;
                        B = IB = in[in_pos] & 0xFF;
                        G = IG;
                        R = IR + IG;
                        u = prevdata[prevline];
                        p = TLGLoader.med(p, u, up, (0xFF0000 & R << 16) + (0xFF00 & G << 8) + (0xFF & B) + (A << 24));
                        up = u;
                        imagedata[curline] = p;
                        ++curline;
                        ++prevline;
                        in_pos += step;
                    } while (--w > 0);
                    break;
                }
                case 17: {
                    int u;
                    int R;
                    int G;
                    int B;
                    int IB;
                    int IG;
                    int IR;
                    int A;
                    do {
                        A = in[in_pos] >>> 24 & 0xFF;
                        IR = in[in_pos] >>> 16 & 0xFF;
                        IG = in[in_pos] >>> 8 & 0xFF;
                        B = IB = in[in_pos] & 0xFF;
                        G = IG;
                        R = IR + IG;
                        u = prevdata[prevline];
                        p = TLGLoader.avg(p, u, up, (0xFF0000 & R << 16) + (0xFF00 & G << 8) + (0xFF & B) + (A << 24));
                        up = u;
                        imagedata[curline] = p;
                        ++curline;
                        ++prevline;
                        in_pos += step;
                    } while (--w > 0);
                    break;
                }
                case 18: {
                    int u;
                    int R;
                    int G;
                    int B;
                    int IB;
                    int IG;
                    int IR;
                    int A;
                    do {
                        A = in[in_pos] >>> 24 & 0xFF;
                        IR = in[in_pos] >>> 16 & 0xFF;
                        IG = in[in_pos] >>> 8 & 0xFF;
                        IB = in[in_pos] & 0xFF;
                        B = IB + IG + IR + IB;
                        G = IG + IR + IB;
                        R = IR + IB;
                        u = prevdata[prevline];
                        p = TLGLoader.med(p, u, up, (0xFF0000 & R << 16) + (0xFF00 & G << 8) + (0xFF & B) + (A << 24));
                        up = u;
                        imagedata[curline] = p;
                        ++curline;
                        ++prevline;
                        in_pos += step;
                    } while (--w > 0);
                    break;
                }
                case 19: {
                    int u;
                    int R;
                    int G;
                    int B;
                    int IB;
                    int IG;
                    int IR;
                    int A;
                    do {
                        A = in[in_pos] >>> 24 & 0xFF;
                        IR = in[in_pos] >>> 16 & 0xFF;
                        IG = in[in_pos] >>> 8 & 0xFF;
                        IB = in[in_pos] & 0xFF;
                        B = IB + IG + IR + IB;
                        G = IG + IR + IB;
                        R = IR + IB;
                        u = prevdata[prevline];
                        p = TLGLoader.avg(p, u, up, (0xFF0000 & R << 16) + (0xFF00 & G << 8) + (0xFF & B) + (A << 24));
                        up = u;
                        imagedata[curline] = p;
                        ++curline;
                        ++prevline;
                        in_pos += step;
                    } while (--w > 0);
                    break;
                }
                case 20: {
                    int u;
                    int R;
                    int G;
                    int B;
                    int IB;
                    int IG;
                    int IR;
                    int A;
                    do {
                        A = in[in_pos] >>> 24 & 0xFF;
                        IR = in[in_pos] >>> 16 & 0xFF;
                        IG = in[in_pos] >>> 8 & 0xFF;
                        IB = in[in_pos] & 0xFF;
                        B = IB + IR;
                        G = IG + IR;
                        R = IR;
                        u = prevdata[prevline];
                        p = TLGLoader.med(p, u, up, (0xFF0000 & R << 16) + (0xFF00 & G << 8) + (0xFF & B) + (A << 24));
                        up = u;
                        imagedata[curline] = p;
                        ++curline;
                        ++prevline;
                        in_pos += step;
                    } while (--w > 0);
                    break;
                }
                case 21: {
                    int u;
                    int R;
                    int G;
                    int B;
                    int IB;
                    int IG;
                    int IR;
                    int A;
                    do {
                        A = in[in_pos] >>> 24 & 0xFF;
                        IR = in[in_pos] >>> 16 & 0xFF;
                        IG = in[in_pos] >>> 8 & 0xFF;
                        IB = in[in_pos] & 0xFF;
                        B = IB + IR;
                        G = IG + IR;
                        R = IR;
                        u = prevdata[prevline];
                        p = TLGLoader.avg(p, u, up, (0xFF0000 & R << 16) + (0xFF00 & G << 8) + (0xFF & B) + (A << 24));
                        up = u;
                        imagedata[curline] = p;
                        ++curline;
                        ++prevline;
                        in_pos += step;
                    } while (--w > 0);
                    break;
                }
                case 22: {
                    int u;
                    int R;
                    int G;
                    int B;
                    int IB;
                    int IG;
                    int IR;
                    int A;
                    do {
                        A = in[in_pos] >>> 24 & 0xFF;
                        IR = in[in_pos] >>> 16 & 0xFF;
                        IG = in[in_pos] >>> 8 & 0xFF;
                        B = IB = in[in_pos] & 0xFF;
                        G = IG + IB;
                        R = IR + IB;
                        u = prevdata[prevline];
                        p = TLGLoader.med(p, u, up, (0xFF0000 & R << 16) + (0xFF00 & G << 8) + (0xFF & B) + (A << 24));
                        up = u;
                        imagedata[curline] = p;
                        ++curline;
                        ++prevline;
                        in_pos += step;
                    } while (--w > 0);
                    break;
                }
                case 23: {
                    int u;
                    int R;
                    int G;
                    int B;
                    int IB;
                    int IG;
                    int IR;
                    int A;
                    do {
                        A = in[in_pos] >>> 24 & 0xFF;
                        IR = in[in_pos] >>> 16 & 0xFF;
                        IG = in[in_pos] >>> 8 & 0xFF;
                        B = IB = in[in_pos] & 0xFF;
                        G = IG + IB;
                        R = IR + IB;
                        u = prevdata[prevline];
                        p = TLGLoader.avg(p, u, up, (0xFF0000 & R << 16) + (0xFF00 & G << 8) + (0xFF & B) + (A << 24));
                        up = u;
                        imagedata[curline] = p;
                        ++curline;
                        ++prevline;
                        in_pos += step;
                    } while (--w > 0);
                    break;
                }
                case 24: {
                    int u;
                    int R;
                    int G;
                    int B;
                    int IB;
                    int IG;
                    int IR;
                    int A;
                    do {
                        A = in[in_pos] >>> 24 & 0xFF;
                        IR = in[in_pos] >>> 16 & 0xFF;
                        IG = in[in_pos] >>> 8 & 0xFF;
                        B = IB = in[in_pos] & 0xFF;
                        G = IG + IR + IB;
                        R = IR + IB;
                        u = prevdata[prevline];
                        p = TLGLoader.med(p, u, up, (0xFF0000 & R << 16) + (0xFF00 & G << 8) + (0xFF & B) + (A << 24));
                        up = u;
                        imagedata[curline] = p;
                        ++curline;
                        ++prevline;
                        in_pos += step;
                    } while (--w > 0);
                    break;
                }
                case 25: {
                    int u;
                    int R;
                    int G;
                    int B;
                    int IB;
                    int IG;
                    int IR;
                    int A;
                    do {
                        A = in[in_pos] >>> 24 & 0xFF;
                        IR = in[in_pos] >>> 16 & 0xFF;
                        IG = in[in_pos] >>> 8 & 0xFF;
                        B = IB = in[in_pos] & 0xFF;
                        G = IG + IR + IB;
                        R = IR + IB;
                        u = prevdata[prevline];
                        p = TLGLoader.avg(p, u, up, (0xFF0000 & R << 16) + (0xFF00 & G << 8) + (0xFF & B) + (A << 24));
                        up = u;
                        imagedata[curline] = p;
                        ++curline;
                        ++prevline;
                        in_pos += step;
                    } while (--w > 0);
                    break;
                }
                case 26: {
                    int u;
                    int R;
                    int G;
                    int B;
                    int IB;
                    int IG;
                    int IR;
                    int A;
                    do {
                        A = in[in_pos] >>> 24 & 0xFF;
                        IR = in[in_pos] >>> 16 & 0xFF;
                        IG = in[in_pos] >>> 8 & 0xFF;
                        IB = in[in_pos] & 0xFF;
                        B = IB + IG;
                        G = IG + IR + IB + IG;
                        R = IR + IB + IG;
                        u = prevdata[prevline];
                        p = TLGLoader.med(p, u, up, (0xFF0000 & R << 16) + (0xFF00 & G << 8) + (0xFF & B) + (A << 24));
                        up = u;
                        imagedata[curline] = p;
                        ++curline;
                        ++prevline;
                        in_pos += step;
                    } while (--w > 0);
                    break;
                }
                case 27: {
                    int u;
                    int R;
                    int G;
                    int B;
                    int IB;
                    int IG;
                    int IR;
                    int A;
                    do {
                        A = in[in_pos] >>> 24 & 0xFF;
                        IR = in[in_pos] >>> 16 & 0xFF;
                        IG = in[in_pos] >>> 8 & 0xFF;
                        IB = in[in_pos] & 0xFF;
                        B = IB + IG;
                        G = IG + IR + IB + IG;
                        R = IR + IB + IG;
                        u = prevdata[prevline];
                        p = TLGLoader.avg(p, u, up, (0xFF0000 & R << 16) + (0xFF00 & G << 8) + (0xFF & B) + (A << 24));
                        up = u;
                        imagedata[curline] = p;
                        ++curline;
                        ++prevline;
                        in_pos += step;
                    } while (--w > 0);
                    break;
                }
                case 28: {
                    int u;
                    int R;
                    int G;
                    int B;
                    int IB;
                    int IG;
                    int IR;
                    int A;
                    do {
                        A = in[in_pos] >>> 24 & 0xFF;
                        IR = in[in_pos] >>> 16 & 0xFF;
                        IG = in[in_pos] >>> 8 & 0xFF;
                        IB = in[in_pos] & 0xFF;
                        B = IB + IG + IR;
                        G = IG + IR;
                        R = IR + IB + IG + IR;
                        u = prevdata[prevline];
                        p = TLGLoader.med(p, u, up, (0xFF0000 & R << 16) + (0xFF00 & G << 8) + (0xFF & B) + (A << 24));
                        up = u;
                        imagedata[curline] = p;
                        ++curline;
                        ++prevline;
                        in_pos += step;
                    } while (--w > 0);
                    break;
                }
                case 29: {
                    int u;
                    int R;
                    int G;
                    int B;
                    int IB;
                    int IG;
                    int IR;
                    int A;
                    do {
                        A = in[in_pos] >>> 24 & 0xFF;
                        IR = in[in_pos] >>> 16 & 0xFF;
                        IG = in[in_pos] >>> 8 & 0xFF;
                        IB = in[in_pos] & 0xFF;
                        B = IB + IG + IR;
                        G = IG + IR;
                        R = IR + IB + IG + IR;
                        u = prevdata[prevline];
                        p = TLGLoader.avg(p, u, up, (0xFF0000 & R << 16) + (0xFF00 & G << 8) + (0xFF & B) + (A << 24));
                        up = u;
                        imagedata[curline] = p;
                        ++curline;
                        ++prevline;
                        in_pos += step;
                    } while (--w > 0);
                    break;
                }
                case 30: {
                    int u;
                    int R;
                    int G;
                    int B;
                    int IB;
                    int IG;
                    int IR;
                    int A;
                    do {
                        A = in[in_pos] >>> 24 & 0xFF;
                        IR = in[in_pos] >>> 16 & 0xFF;
                        IG = in[in_pos] >>> 8 & 0xFF;
                        B = IB = in[in_pos] & 0xFF;
                        G = IG + (IB << 1);
                        R = IR + (IB << 1);
                        u = prevdata[prevline];
                        p = TLGLoader.med(p, u, up, (0xFF0000 & R << 16) + (0xFF00 & G << 8) + (0xFF & B) + (A << 24));
                        up = u;
                        imagedata[curline] = p;
                        ++curline;
                        ++prevline;
                        in_pos += step;
                    } while (--w > 0);
                    break;
                }
                case 31: {
                    int u;
                    int R;
                    int G;
                    int B;
                    int IB;
                    int IG;
                    int IR;
                    int A;
                    do {
                        A = in[in_pos] >>> 24 & 0xFF;
                        IR = in[in_pos] >>> 16 & 0xFF;
                        IG = in[in_pos] >>> 8 & 0xFF;
                        B = IB = in[in_pos] & 0xFF;
                        G = IG + (IB << 1);
                        R = IR + (IB << 1);
                        u = prevdata[prevline];
                        p = TLGLoader.avg(p, u, up, (0xFF0000 & R << 16) + (0xFF00 & G << 8) + (0xFF & B) + (A << 24));
                        up = u;
                        imagedata[curline] = p;
                        ++curline;
                        ++prevline;
                        in_pos += step;
                    } while (--w > 0);
                    break;
                }
                default: {
                    return;
                }
            }
            in_pos = step == 1 ? (in_pos += skipblockbytes - ww) : (in_pos += skipblockbytes + 1);
            if ((i & 1) != 0) {
                in_pos -= oddskip * ww;
            }
            ++i;
        }
    }

    private static final void TLG6DecodeLine(int[] imagedata, int prevline, int[] zeroline, int curline, int width, int block_count, byte[] filtertypes, int ft_pos, int skipblockbytes, int[] in, int in_pos, int initialp, int oddskip, int dir) {
        TLGLoader.TLG6DecodeLineGeneric(imagedata, prevline, zeroline, curline, width, 0, block_count, filtertypes, ft_pos, skipblockbytes, in, in_pos, initialp, oddskip, dir);
    }
}

