/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2env;

import java.util.ArrayList;
import javax.swing.SwingUtilities;
import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.utils.TimerNI;

public class TimerThread
implements Runnable {
    public static final int SUBMILLI_FRAC_BITS = 4;
    private static final int LEAST_TIMER_INTERVAL = 3;
    private ArrayList<TimerNI> mList = new ArrayList();
    ArrayList<TimerNI> mPending = new ArrayList();
    boolean mPendingEventsAvailable = false;
    private boolean mIsTerminated;
    private Thread mThread = new Thread(this);

    public TimerThread() {
        this.mThread.setPriority(TimerNI.LimitTimerCapacity ? 5 : 10);
        this.mThread.setName("TVP Timer Thread");
        this.mThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.getTerminated()) {
            long sleeptime;
            long step_next = -1L;
            long curtick = TVP.getTickCount();
            curtick <<= 4;
            TimerThread timerThread = this;
            synchronized (timerThread) {
                boolean any_triggered = false;
                int count = this.mList.size();
                int i = 0;
                while (i < count) {
                    TimerNI item = this.mList.get(i);
                    if (item.getEnabled() && item.getInterval() != 0L) {
                        if (item.getNextTick() < curtick) {
                            long n = (curtick - item.getNextTick()) / item.getInterval();
                            if (++n > 40L) {
                                item.trigger(1);
                                any_triggered = true;
                                item.setNextTick(curtick + item.getInterval());
                            } else {
                                item.trigger((int)n);
                                any_triggered = true;
                                item.setNextTick(item.getNextTick() + n * item.getInterval());
                            }
                        }
                        long to_next = item.getNextTick() - curtick;
                        if (step_next == -1L) {
                            step_next = to_next;
                        } else if (step_next > to_next) {
                            step_next = to_next;
                        }
                    }
                    ++i;
                }
                sleeptime = step_next != -1L ? (step_next > Integer.MAX_VALUE ? Integer.MAX_VALUE : step_next) : Long.MAX_VALUE;
                if (this.mList.size() == 0) {
                    sleeptime = Long.MAX_VALUE;
                }
                if (any_triggered && !this.mPendingEventsAvailable) {
                    this.mPendingEventsAvailable = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            if (!TimerThread.this.getTerminated()) {
                                1 var1_1 = this;
                                synchronized (var1_1) {
                                    int count = TimerThread.this.mPending.size();
                                    int i = 0;
                                    while (i < count) {
                                        TimerNI item = TimerThread.this.mPending.get(i);
                                        item.firePendingEventsAndClear();
                                        ++i;
                                    }
                                    TimerThread.this.mPending.clear();
                                    TimerThread.this.mPendingEventsAvailable = false;
                                }
                            }
                        }
                    });
                }
            }
            if (sleeptime != Long.MAX_VALUE) {
                sleeptime = (sleeptime >> 4) + (long)((sleeptime & 0xFL) != 0L ? 1 : 0);
            }
            if (sleeptime != Long.MAX_VALUE && sleeptime < 3L) {
                sleeptime = 3L;
            }
            if (Thread.interrupted()) continue;
            try {
                Thread.sleep(sleeptime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addItem(TimerNI item) {
        TimerThread timerThread = this;
        synchronized (timerThread) {
            int index = this.mList.indexOf(item);
            if (index == -1) {
                this.mList.add(item);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeItem(TimerNI item) {
        TimerThread timerThread = this;
        synchronized (timerThread) {
            int count = this.mList.size();
            int i = count - 1;
            while (i >= 0) {
                TimerNI t = this.mList.get(i);
                if (t == item) {
                    this.mList.remove(i);
                }
                --i;
            }
            this.removeFromPendingItem(item);
            return this.mList.size() != 0;
        }
    }

    private void removeFromPendingItem(TimerNI item) {
        int count = this.mPending.size();
        int i = count - 1;
        while (i >= 0) {
            TimerNI t = this.mPending.get(i);
            if (t == item) {
                this.mPending.remove(i);
            }
            --i;
        }
        item.zeroPendingCount();
    }

    private void registerToPendingItem(TimerNI item) {
        this.mPending.add(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(TimerNI item, boolean enabled) {
        TimerThread timerThread = this;
        synchronized (timerThread) {
            item.internalSetEnabled(enabled);
            if (enabled) {
                item.setNextTick((TVP.getTickCount() << 4) + item.getInterval());
            } else {
                item.cancelEvents();
                item.zeroPendingCount();
            }
        }
        if (enabled) {
            this.mThread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInterval(TimerNI item, long interval) {
        TimerThread timerThread = this;
        synchronized (timerThread) {
            item.internalSetInterval(interval);
            if (item.getEnabled()) {
                item.cancelEvents();
                item.zeroPendingCount();
                item.setNextTick((TVP.getTickCount() << 4) + item.getInterval());
            }
        }
        if (item.getEnabled()) {
            this.mThread.interrupt();
        }
    }

    private boolean getTerminated() {
        return this.mIsTerminated;
    }

    public static void init() {
        if (TVP.TimerThread == null) {
            TVP.TimerThread = new TimerThread();
        }
    }

    public static void uninit() {
        if (TVP.TimerThread != null) {
            TVP.TimerThread.mIsTerminated = true;
            try {
                TVP.TimerThread.mThread.interrupt();
                TVP.TimerThread.mThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            TVP.TimerThread = null;
        }
    }

    public static void add(TimerNI item) {
        TimerThread.init();
        TVP.TimerThread.addItem(item);
    }

    public static void remove(TimerNI item) {
        if (TVP.TimerThread != null && !TVP.TimerThread.removeItem(item)) {
            TimerThread.uninit();
        }
    }

    public static void removeFromPending(TimerNI item) {
        if (TVP.TimerThread != null) {
            TVP.TimerThread.removeFromPendingItem(item);
        }
    }

    public static void registerToPending(TimerNI item) {
        if (TVP.TimerThread != null) {
            TVP.TimerThread.registerToPendingItem(item);
        }
    }
}

