/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2env;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.visual.DivisibleData;
import jp.kirikiri.tvp2.visual.DivisibleTransHandler;
import jp.kirikiri.tvp2.visual.ScanLineProvider;
import jp.kirikiri.tvp2.visual.SimpleOptionProvider;

public class TurnTransHandler
implements DivisibleTransHandler {
    private static final int TURN_WIDTH_FACTOR = 2;
    private static final int BLOCK_SIZE = 64;
    private static final int[] GLOSS;
    private long mStartTick;
    private long mTime;
    private long mCurTime;
    private int mWidth;
    private int mHeight;
    private int mBGColor;
    private int mPhase;
    private boolean mFirst;
    private Color mBGColorObj;
    private Color mWhiteColor;
    private AffineTransform[] mTransMatrix;

    static {
        int[] nArray = new int[64];
        nArray[4] = 16;
        nArray[5] = 48;
        nArray[6] = 80;
        nArray[7] = 128;
        nArray[8] = 192;
        nArray[9] = 128;
        nArray[10] = 80;
        nArray[11] = 48;
        nArray[12] = 16;
        GLOSS = nArray;
    }

    public TurnTransHandler(long time, int width, int height, int bgcolor) {
        this.mWidth = width;
        this.mHeight = height;
        this.mTime = time;
        this.mBGColor = bgcolor | 0xFF000000;
        this.mBGColorObj = new Color(this.mBGColor, false);
        this.mWhiteColor = new Color(-1, true);
        this.mTransMatrix = new AffineTransform[32];
        this.mTransMatrix[0] = new AffineTransform();
        int i = 1;
        while (i < 32) {
            double p = (double)(i * i) / 31.0;
            double d = Math.sin(p * Math.PI / 32.0) * 4.0;
            double y = p - d;
            double shear = y / 32.0;
            double scale = 1.0 / (1.0 + shear);
            AffineTransform shearm = AffineTransform.getShearInstance(shear, shear);
            AffineTransform scalem = AffineTransform.getScaleInstance(scale, scale);
            scalem.concatenate(shearm);
            this.mTransMatrix[i] = scalem;
            ++i;
        }
        this.mFirst = true;
    }

    @Override
    public int setOption(SimpleOptionProvider options) {
        return 0;
    }

    @Override
    public int startProcess(long tick) {
        if (this.mFirst) {
            this.mFirst = false;
            this.mStartTick = tick;
        }
        this.mCurTime = tick - this.mStartTick;
        if (this.mCurTime > this.mTime) {
            this.mCurTime = this.mTime;
        }
        int xcount = (this.mWidth - 1) / 64 + 1;
        int ycount = (this.mHeight - 1) / 64 + 1;
        this.mPhase = (int)(this.mCurTime * (long)(64 + (xcount + ycount) * 2) / this.mTime - (long)(ycount * 2));
        return 1;
    }

    @Override
    public int endProcess() {
        if (this.mCurTime == this.mTime) {
            return 2;
        }
        return 1;
    }

    @Override
    public int process(DivisibleData data) {
        BufferedImage dest = (BufferedImage)data.Dest.getScanLineForWrite().getImage();
        BufferedImage src1 = (BufferedImage)data.Src1.getScanLine().getImage();
        BufferedImage src2 = (BufferedImage)data.Src2.getScanLine().getImage();
        int destLeft = data.DestLeft;
        int h = data.Height;
        int w = data.Width;
        int destTop = data.DestTop;
        int left = data.Left;
        int top = data.Top;
        int right = left + w;
        int bottom = top + h;
        int destxofs = destLeft - left;
        int destyofs = destTop - top;
        Graphics2D g = (Graphics2D)dest.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g.setComposite(AlphaComposite.Src);
        int startx = data.Left / 64;
        int starty = data.Top / 64;
        int endx = (data.Left + data.Width - 1) / 64;
        int endy = (data.Top + data.Height - 1) / 64;
        int y = starty;
        while (y <= endy) {
            int x = startx;
            while (x <= endx) {
                int phase = this.mPhase - (x - y) * 2;
                if (phase < 0) {
                    phase = 0;
                }
                if (phase > 63) {
                    phase = 63;
                }
                int gl = GLOSS[phase];
                int l = x * 64;
                int t = y * 64;
                int r = l + 64;
                int b = t + 64;
                if (l < left) {
                    l = left;
                }
                if (r > right) {
                    r = right;
                }
                if (t < top) {
                    t = top;
                }
                if (b > bottom) {
                    b = bottom;
                }
                if (l < r && t < b) {
                    if (phase == 0) {
                        g.setTransform(this.mTransMatrix[0]);
                        g.drawImage(src1, l + destxofs, t + destyofs, r + destxofs, b + destyofs, l, t, r, b, null);
                    } else if (phase == 63) {
                        g.setTransform(this.mTransMatrix[0]);
                        g.drawImage(src2, l + destxofs, t + destyofs, r + destxofs, b + destyofs, l, t, r, b, null);
                    } else {
                        AffineTransform mat;
                        BufferedImage src;
                        if (phase < 32) {
                            src = src1;
                            mat = this.mTransMatrix[phase];
                        } else {
                            src = src2;
                            mat = this.mTransMatrix[63 - phase];
                        }
                        if (x != y) {
                            double scale = mat.getScaleX();
                            double ox = (double)l - (double)l * scale;
                            double oy = (double)t - (double)t * scale;
                            AffineTransform trans = AffineTransform.getTranslateInstance(ox - oy, -ox + oy);
                            trans.concatenate(mat);
                            mat = trans;
                        }
                        g.setTransform(this.mTransMatrix[0]);
                        g.setColor(this.mBGColorObj);
                        g.fillRect(l + destxofs, t + destyofs, r - l, b - t);
                        if (gl != 0) {
                            g.setTransform(mat);
                            g.drawImage(src, l + destxofs, t + destyofs, r + destxofs, b + destyofs, l, t, r, b, null);
                            g.setComposite(AlphaComposite.getInstance(3, (float)gl / 255.0f));
                            g.setColor(this.mWhiteColor);
                            g.fillRect(l + destxofs, t + destyofs, r - l, b - t);
                            g.setComposite(AlphaComposite.Src);
                        } else {
                            g.setTransform(mat);
                            g.drawImage(src, l + destxofs, t + destyofs, r + destxofs, b + destyofs, l, t, r, b, null);
                        }
                    }
                }
                ++x;
            }
            ++y;
        }
        g.dispose();
        return 0;
    }

    @Override
    public int makeFinalImage(ScanLineProvider dest, ScanLineProvider src1, ScanLineProvider src2) throws TJSException {
        dest.copyFrom(src2);
        return 0;
    }
}

