/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2env;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import jp.kirikiri.tvp2.visual.DivisibleData;
import jp.kirikiri.tvp2.visual.LayerType;
import jp.kirikiri.tvp2.visual.ScanLineProvider;
import jp.kirikiri.tvp2.visual.SimpleOptionProvider;
import jp.kirikiri.tvp2env.CrossFadeTransHandler;
import jp.kirikiri.tvp2env.CustomOperationComposite;

public class UniversalTransHander
extends CrossFadeTransHandler {
    private static final int TABLE_SIZE = 256;
    private int mVague;
    private ScanLineProvider mRule;
    private int[] mBlendTable = new int[256];

    public UniversalTransHander(SimpleOptionProvider options, int layertype, long time, int vague, ScanLineProvider rule) {
        super(options, layertype, time, 255 + vague);
        this.mVague = vague;
        this.mRule = rule;
    }

    @Override
    public int startProcess(long tick) {
        int er = super.startProcess(tick);
        if (er < 0) {
            return er;
        }
        this.initUnivTransBlendTable(this.mBlendTable, this.mPhase, this.mVague);
        return er;
    }

    @Override
    public void blend(DivisibleData data) {
        block34: {
            BufferedImage dest = (BufferedImage)data.Dest.getScanLineForWrite().getImage();
            BufferedImage src1 = (BufferedImage)data.Src1.getScanLine().getImage();
            BufferedImage src2 = (BufferedImage)data.Src2.getScanLine().getImage();
            BufferedImage rule = (BufferedImage)this.mRule.getScanLine().getImage();
            int destLeft = data.DestLeft;
            int src1Left = data.Src1Left;
            int src2Left = data.Src2Left;
            int ruleLeft = data.Left;
            int h = data.Height;
            int w = data.Width;
            int destTop = data.DestTop;
            int src1Top = data.Src1Top;
            int src2Top = data.Src2Top;
            int ruleTop = data.Top;
            int destW = dest.getWidth();
            int src1W = src1.getWidth();
            int src2W = src2.getWidth();
            int ruleW = rule.getWidth();
            DataBuffer destBuff = dest.getRaster().getDataBuffer();
            int destType = destBuff.getDataType();
            DataBuffer src1Buff = src1.getRaster().getDataBuffer();
            int src1Type = src1Buff.getDataType();
            DataBuffer src2Buff = src2.getRaster().getDataBuffer();
            int src2Type = src2Buff.getDataType();
            DataBuffer ruleBuff = rule.getRaster().getDataBuffer();
            int ruleType = ruleBuff.getDataType();
            int[] table = this.mBlendTable;
            if (destType != 3 || src1Type != 3 || src2Type != 3 || ruleType != 0) break block34;
            int[] s1 = ((DataBufferInt)src1Buff).getData();
            int[] s2 = ((DataBufferInt)src2Buff).getData();
            int[] d = ((DataBufferInt)destBuff).getData();
            byte[] r = ((DataBufferByte)ruleBuff).getData();
            destTop = destTop * destW + destLeft;
            src1Top = src1Top * src1W + src1Left;
            src2Top = src2Top * src2W + src2Left;
            ruleTop = ruleTop * ruleW + ruleLeft;
            if (this.mVague >= 512) {
                if (LayerType.isTypeUsingAlpha(this.mDestLayerType)) {
                    byte[] opacitytable = CustomOperationComposite.OpacityOnOpacityTable;
                    int y = 0;
                    while (y < h) {
                        int x = 0;
                        while (x < w) {
                            int s1v = s1[src1Top + x];
                            int s2v = s2[src1Top + x];
                            int ru = r[ruleTop + x] & 0xFF;
                            int opa = table[ru];
                            int a1 = s1v >>> 24;
                            int a2 = s2v >>> 24;
                            int addr = (a2 * opa & 0xFF00) + (a1 * (256 - opa) >>> 8);
                            int alpha = opacitytable[addr] & 0xFF;
                            int s1t = s1v & 0xFF00FF;
                            s1t = s1t + (((s2v & 0xFF00FF) - s1t) * alpha >>> 8) & 0xFF00FF;
                            d[destTop + x] = (s1t |= a1 + ((a2 - a1) * opa >>> 8) << 24) | (s1v &= 0xFF00) + (((s2v &= 0xFF00) - s1v) * alpha >>> 8) & 0xFF00;
                            ++x;
                        }
                        destTop += destW;
                        src1Top += src1W;
                        src2Top += src2W;
                        ruleTop += ruleW;
                        ++y;
                    }
                } else if (LayerType.isTypeUsingAddAlpha(this.mDestLayerType)) {
                    int y = 0;
                    while (y < h) {
                        int x = 0;
                        while (x < w) {
                            int s1v = s1[src1Top + x];
                            int s2v = s2[src1Top + x];
                            int ru = r[ruleTop + x] & 0xFF;
                            int opa = table[ru];
                            int b2 = s1v & 0xFF00FF;
                            int t = b2 + (((s2v & 0xFF00FF) - b2) * opa >>> 8) & 0xFF00FF;
                            b2 = (s1v & 0xFF00FF00) >>> 8;
                            d[destTop + x] = t + (b2 + ((((s2v & 0xFF00FF00) >>> 8) - b2) * opa >>> 8) << 8 & 0xFF00FF00);
                            ++x;
                        }
                        destTop += destW;
                        src1Top += src1W;
                        src2Top += src2W;
                        ruleTop += ruleW;
                        ++y;
                    }
                } else {
                    int y = 0;
                    while (y < h) {
                        int x = 0;
                        while (x < w) {
                            int s1v = s1[src1Top + x];
                            int s2v = s2[src1Top + x];
                            int ru = r[ruleTop + x] & 0xFF;
                            int opa = table[ru];
                            int s1t = s1v & 0xFF00FF;
                            s1t = s1t + (((s2v & 0xFF00FF) - s1t) * opa >>> 8) & 0xFF00FF;
                            d[destTop + x] = s1t | (s1v &= 0xFF00) + (((s2v &= 0xFF00) - s1v) * opa >>> 8) & 0xFF00 | 0xFF000000;
                            ++x;
                        }
                        destTop += destW;
                        src1Top += src1W;
                        src2Top += src2W;
                        ruleTop += ruleW;
                        ++y;
                    }
                }
            } else {
                int src1lv = this.mPhase;
                int src2lv = this.mPhase - this.mVague;
                if (LayerType.isTypeUsingAlpha(this.mDestLayerType)) {
                    byte[] opacitytable = CustomOperationComposite.OpacityOnOpacityTable;
                    byte[] multable = CustomOperationComposite.NegativeMulTable;
                    int y = 0;
                    while (y < h) {
                        int x = 0;
                        while (x < w) {
                            int ru = r[ruleTop + x] & 0xFF;
                            if (ru >= src1lv) {
                                d[destTop + x] = s1[src1Top + x];
                            } else if (ru < src2lv) {
                                d[destTop + x] = s2[src1Top + x];
                            } else {
                                int s1v = s1[src1Top + x];
                                int s2v = s2[src1Top + x];
                                int opa = table[ru];
                                int a1 = s1v >>> 24;
                                int a2 = s2v >>> 24;
                                int addr = (a2 * opa & 0xFF00) + (a1 * (256 - opa) >>> 8);
                                byte alpha = opacitytable[addr];
                                int s1t = s1v & 0xFF00FF;
                                s1t = (s1t + (((s2v & 0xFF00FF) - s1t) * alpha >>> 8) & 0xFF00FF) + (multable[addr] << 24);
                                d[destTop + x] = s1t | (s1v &= 0xFF00) + (((s2v &= 0xFF00) - s1v) * alpha >>> 8) & 0xFF00;
                            }
                            ++x;
                        }
                        destTop += destW;
                        src1Top += src1W;
                        src2Top += src2W;
                        ruleTop += ruleW;
                        ++y;
                    }
                } else if (LayerType.isTypeUsingAddAlpha(this.mDestLayerType)) {
                    int y = 0;
                    while (y < h) {
                        int x = 0;
                        while (x < w) {
                            int ru = r[ruleTop + x] & 0xFF;
                            if (ru >= src1lv) {
                                d[destTop + x] = s1[src1Top + x];
                            } else if (ru < src2lv) {
                                d[destTop + x] = s2[src1Top + x];
                            } else {
                                int s1v = s1[src1Top + x];
                                int s2v = s2[src1Top + x];
                                int opa = table[ru];
                                int b2 = s1v & 0xFF00FF;
                                int t = b2 + (((s2v & 0xFF00FF) - b2) * opa >>> 8) & 0xFF00FF;
                                b2 = (s1v & 0xFF00FF00) >>> 8;
                                d[destTop + x] = t + (b2 + ((((s2v & 0xFF00FF00) >>> 8) - b2) * opa >>> 8) << 8 & 0xFF00FF00);
                            }
                            ++x;
                        }
                        destTop += destW;
                        src1Top += src1W;
                        src2Top += src2W;
                        ruleTop += ruleW;
                        ++y;
                    }
                } else {
                    int y = 0;
                    while (y < h) {
                        int x = 0;
                        while (x < w) {
                            int ru = r[ruleTop + x] & 0xFF;
                            if (ru >= src1lv) {
                                d[destTop + x] = s1[src1Top + x];
                            } else if (ru < src2lv) {
                                d[destTop + x] = s2[src1Top + x];
                            } else {
                                int s1v = s1[src1Top + x];
                                int s2v = s2[src1Top + x];
                                int opa = table[ru];
                                int s1t = s1v & 0xFF00FF;
                                s1t = s1t + (((s2v & 0xFF00FF) - s1t) * opa >>> 8) & 0xFF00FF;
                                d[destTop + x] = s1t | (s1v &= 0xFF00) + (((s2v &= 0xFF00) - s1v) * opa >>> 8) & 0xFF00 | 0xFF000000;
                            }
                            ++x;
                        }
                        destTop += destW;
                        src1Top += src1W;
                        src2Top += src2W;
                        ruleTop += ruleW;
                        ++y;
                    }
                }
            }
        }
    }

    private void initUnivTransBlendTable(int[] table, int phase, int vague) {
        int phasemax = phase;
        phase -= vague;
        if (vague == 0) {
            vague = 1;
        }
        int i = 0;
        while (i < 256) {
            if (i < phase) {
                table[i] = 255;
            } else if (i >= phasemax) {
                table[i] = 0;
            } else {
                int tmp = 255 - (i - phase) * 255 / vague;
                if (tmp < 0) {
                    tmp = 0;
                }
                if (tmp > 255) {
                    tmp = 255;
                }
                table[i] = tmp;
            }
            ++i;
        }
    }
}

