/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2env;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.VolatileImage;

public class VRAMImageBuffer {
    private Component mComponent;
    private VolatileImage mVolatileImage;
    private int mWidth;
    private int mHeight;

    public VRAMImageBuffer(Component cComponent) {
        this.mComponent = cComponent;
    }

    public void initializeVolatileImage() {
        if (this.mVolatileImage == null || this.mWidth != this.mComponent.getWidth() || this.mHeight != this.mComponent.getHeight()) {
            this.mWidth = this.mComponent.getWidth();
            this.mHeight = this.mComponent.getHeight();
            this.mVolatileImage = this.mComponent.createVolatileImage(this.mWidth, this.mHeight);
        }
    }

    public void validateVolatileImage() {
        GraphicsConfiguration gc = this.mComponent.getGraphicsConfiguration();
        if (this.mVolatileImage.validate(gc) == 2) {
            this.mVolatileImage = this.mComponent.createVolatileImage(this.mWidth, this.mHeight);
        }
    }

    public Graphics getGraphics() {
        return this.mVolatileImage.getGraphics();
    }

    public boolean isContentsLost() {
        return this.mVolatileImage.contentsLost();
    }

    public Image getImage() {
        return this.mVolatileImage;
    }
}

