/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2env;

import com.jcraft.jorbis.Info;
import com.jcraft.jorbis.JOrbisException;
import com.jcraft.jorbis.VorbisFile2;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import jp.kirikiri.tjs2.TJSException;

public class VorbisAudioInputStream
extends AudioInputStream {
    InputStream mInputStream;
    AudioFormat mOutputFormat;
    AudioFormat mInputFormat;
    VorbisFile2 mVorbisFile;
    long mLength;
    long mMarkPos;
    byte[] mTemp;

    public VorbisAudioInputStream(InputStream stream, AudioFormat format, long length) throws IOException, TJSException {
        super(stream, format, length);
        this.mInputStream = stream;
        this.mOutputFormat = format;
        this.mLength = length;
        this.mMarkPos = -1L;
        this.mTemp = new byte[2];
        try {
            this.mVorbisFile = new VorbisFile2(stream, null, 0);
        }
        catch (JOrbisException e) {
            throw new TJSException("Cannot open vorbis file." + e.getLocalizedMessage());
        }
        Info info = this.mVorbisFile.getInfo(0);
        this.mInputFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, info.rate, 16, info.channels, 2 * info.channels, info.rate, false);
    }

    @Override
    public int available() {
        Info info = this.mVorbisFile.getInfo(0);
        return (int)(this.mVorbisFile.pcm_total(-1) * (long)info.channels * 2L);
    }

    @Override
    public void close() {
        try {
            this.mVorbisFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public AudioFormat getFormat() {
        return this.mInputFormat;
    }

    @Override
    public long getFrameLength() {
        return this.mVorbisFile.pcm_total(-1);
    }

    @Override
    public void mark(int readlimit) {
        this.mMarkPos = this.mVorbisFile.pcm_tell();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() {
        int ret = this.mVorbisFile.read(this.mTemp, 2);
        if (ret < 0) {
            return -1;
        }
        return this.mTemp[0] & 0xFF;
    }

    @Override
    public int read(byte[] b) {
        return this.mVorbisFile.read(b, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (off != 0) {
            byte[] tmp = new byte[len];
            int ret = 0;
            ret = this.mVorbisFile.read(tmp, len);
            if (ret > 0) {
                System.arraycopy(tmp, 0, b, off, ret);
            }
            return ret;
        }
        return this.mVorbisFile.read(b, len);
    }

    @Override
    public void reset() {
        this.mVorbisFile.pcm_seek(this.mMarkPos);
    }

    @Override
    public long skip(long n) {
        long pos = this.mVorbisFile.pcm_tell();
        Info info = this.mVorbisFile.getInfo(0);
        long sampleskip = n / (long)info.channels * 2L;
        this.mVorbisFile.pcm_seek(pos += sampleskip);
        return n;
    }
}

