/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2env;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tvp2.visual.DivisibleData;
import jp.kirikiri.tvp2.visual.DivisibleTransHandler;
import jp.kirikiri.tvp2.visual.ScanLineProvider;
import jp.kirikiri.tvp2.visual.SimpleOptionProvider;

public class WaveTransHandler
implements DivisibleTransHandler {
    protected long mStartTick;
    protected long mHalfTime;
    protected long mTime;
    protected int mLayerType;
    protected int mWidth;
    protected int mHeight;
    protected int mMaxH;
    protected double mMaxOmega;
    protected int mCurH;
    protected double mCurOmega;
    protected double mCurRadStart;
    protected long mCurTime;
    protected int mBlendRatio;
    protected int mBGColor1;
    protected int mBGColor2;
    protected int mCurBGColor;
    protected int mWaveType;
    protected boolean mFirst;
    private Color mCurrentBGColor;
    private Composite mBlendComposite;

    public WaveTransHandler(long time, int layertype, int width, int height, int maxh, double maxomega, int bgcolor1, int bgcolor2, int wavetype) {
        this.mLayerType = layertype;
        this.mWidth = width;
        this.mHeight = height;
        this.mTime = time;
        this.mHalfTime = time / 2L;
        this.mMaxH = maxh;
        this.mMaxOmega = maxomega;
        this.mBGColor1 = bgcolor1 | 0xFF000000;
        this.mBGColor2 = bgcolor2 | 0xFF000000;
        this.mWaveType = wavetype;
        this.mFirst = true;
    }

    @Override
    public int setOption(SimpleOptionProvider options) {
        return 0;
    }

    @Override
    public int startProcess(long tick) {
        if (this.mFirst) {
            this.mFirst = false;
            this.mStartTick = tick;
        }
        long t = this.mCurTime = tick - this.mStartTick;
        if (this.mCurTime > this.mTime) {
            this.mCurTime = this.mTime;
        }
        if (t >= this.mHalfTime) {
            t = this.mTime - t;
        }
        if (t < 0L) {
            t = 0L;
        }
        double tt = Math.sin(1.570796326794895 * (double)t / (double)this.mHalfTime);
        this.mCurH = (int)(tt * (double)this.mMaxH);
        switch (this.mWaveType) {
            case 0: {
                this.mCurOmega = this.mMaxOmega * tt;
                break;
            }
            case 1: {
                this.mCurOmega = this.mMaxOmega * (double)(this.mTime - this.mCurTime) / (double)this.mTime;
                break;
            }
            case 2: {
                this.mCurOmega = this.mMaxOmega * (double)this.mCurTime / (double)this.mTime;
            }
        }
        this.mCurRadStart = -this.mCurOmega * (double)(this.mHeight / 2);
        this.mBlendRatio = (int)(this.mCurTime * 255L / this.mTime);
        if (this.mBlendRatio > 255) {
            this.mBlendRatio = 255;
        }
        int oldColor = this.mCurBGColor;
        this.mCurBGColor = WaveTransHandler.blend(this.mBGColor1, this.mBGColor2, this.mBlendRatio);
        if (oldColor != this.mCurBGColor || this.mCurrentBGColor == null) {
            this.mCurrentBGColor = new Color(this.mCurBGColor, true);
        }
        this.mBlendComposite = AlphaComposite.getInstance(3, (float)this.mBlendRatio / 255.0f);
        return 1;
    }

    @Override
    public int endProcess() {
        if (this.mBlendRatio == 255) {
            return 2;
        }
        return 1;
    }

    @Override
    public int process(DivisibleData data) {
        double rad = (double)data.Top * this.mCurOmega + this.mCurRadStart;
        BufferedImage dest = (BufferedImage)data.Dest.getScanLineForWrite().getImage();
        BufferedImage src1 = (BufferedImage)data.Src1.getScanLine().getImage();
        BufferedImage src2 = (BufferedImage)data.Src2.getScanLine().getImage();
        int destLeft = data.DestLeft;
        int left = data.Left;
        int top = data.Top;
        int w = data.Width;
        int right = left + w;
        int destTop = data.DestTop;
        Graphics2D g = (Graphics2D)dest.getGraphics();
        int n = 0;
        while (n < data.Height) {
            int r;
            int l;
            int d = (int)(Math.sin(rad) * (double)this.mCurH);
            if (d > 0) {
                l = 0;
                r = d;
                if (l < left) {
                    l = left;
                }
                if (r > right) {
                    r = right;
                }
                if (l < r) {
                    g.setComposite(AlphaComposite.Src);
                    g.setColor(this.mCurrentBGColor);
                    g.fillRect(l + destLeft - left, destTop, r - l, 1);
                }
            }
            if (d < 0) {
                l = d + this.mWidth;
                r = this.mWidth;
                if (l < left) {
                    l = left;
                }
                if (r > right) {
                    r = right;
                }
                if (l < r) {
                    g.setComposite(AlphaComposite.Src);
                    g.setColor(this.mCurrentBGColor);
                    g.fillRect(l + destLeft - left, destTop, r - l, 1);
                }
            }
            l = d;
            r = this.mWidth + d;
            if (l < left) {
                l = left;
            }
            if (r > right) {
                r = right;
            }
            if (l < r) {
                int width = r - l;
                int dl = l + destLeft - left;
                int dr = dl + width;
                int db = destTop + 1;
                int sl = l - d;
                int sr = sl + width;
                int sb = top + 1;
                g.setComposite(AlphaComposite.Src);
                g.drawImage(src1, dl, destTop, dr, db, sl, top, sr, sb, null);
                g.setComposite(this.mBlendComposite);
                g.drawImage(src2, dl, destTop, dr, db, sl, top, sr, sb, null);
            }
            ++destTop;
            ++top;
            ++n;
            rad += this.mCurOmega;
        }
        g.dispose();
        return 0;
    }

    @Override
    public int makeFinalImage(ScanLineProvider dest, ScanLineProvider src1, ScanLineProvider src2) throws TJSException {
        dest.copyFrom(src2);
        return 0;
    }

    public static int blend(int a, int b, int opa) {
        int tmp = a & 0xFF;
        int ret = 0xFF & tmp + (((b & 0xFF) - tmp) * opa >>> 8);
        tmp = a & 0xFF00;
        ret |= 0xFF00 & tmp + (((b & 0xFF00) - tmp) * opa >>> 8);
        tmp = a & 0xFF0000;
        ret |= 0xFF0000 & tmp + (((b & 0xFF0000) - tmp) * opa >>> 8);
        tmp = a >>> 24;
        return ret |= (0xFF & tmp + (((b >>> 24) - tmp) * opa >>> 8)) << 24;
    }
}

