/*
 * Decompiled with CFR 0.152.
 */
package jp.kirikiri.tvp2env;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodRequests;
import java.io.File;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.MouseInputListener;
import jp.kirikiri.tjs2.Dispatch2;
import jp.kirikiri.tjs2.TJS;
import jp.kirikiri.tjs2.TJSException;
import jp.kirikiri.tjs2.Variant;
import jp.kirikiri.tjs2.VariantException;
import jp.kirikiri.tvp2.TVP;
import jp.kirikiri.tvp2.base.WindowEvents;
import jp.kirikiri.tvp2.utils.DebugClass;
import jp.kirikiri.tvp2.utils.Random;
import jp.kirikiri.tvp2.visual.Point;
import jp.kirikiri.tvp2.visual.Rect;
import jp.kirikiri.tvp2.visual.ScreenMode;
import jp.kirikiri.tvp2.visual.ScreenModeCandidate;
import jp.kirikiri.tvp2.visual.WindowNI;
import jp.kirikiri.tvp2env.DrawTarget;
import jp.kirikiri.tvp2env.Font;
import jp.kirikiri.tvp2env.ImagePanel;
import jp.kirikiri.tvp2env.MenuItem;
import jp.kirikiri.tvp2env.PanelDrawListener;

public class WindowForm
extends JFrame
implements WindowListener,
KeyListener,
InputMethodListener,
InputMethodRequests,
MouseInputListener,
MouseWheelListener,
PanelDrawListener,
ComponentListener,
DropTargetListener {
    public static final int bsNone = 0;
    public static final int bsSingle = 1;
    public static final int bsSizeable = 2;
    public static final int bsDialog = 3;
    public static final int bsToolWindow = 4;
    public static final int bsSizeToolWin = 5;
    private static final int mbLeft = 0;
    private static final int mbRight = 1;
    private static final int mbMiddle = 2;
    private static final int mcsVisible = 0;
    private static final int mcsTempHidden = 1;
    private static final int mcsHidden = 2;
    private boolean mInMode;
    private boolean mFocusable;
    private boolean mNextSetWindowHandleToDrawDevice;
    private Rect mLastSentDrawDeviceDestRect;
    private WindowNI mNativeInstance;
    private int mLastMouseDownX;
    private int mLastMouseDownY;
    private int mInnerWidthSave;
    private int mInnerHeightSave;
    private int mOrgStyle;
    private int mOrgExStyle;
    private int mOrgLeft;
    private int mOrgTop;
    private int mOrgWidth;
    private int mOrgHeight;
    private boolean mOrgInnerSunken;
    private int mResetStayOnTopStateTick;
    private boolean mTrapKeys;
    private boolean mCanReceiveTrappedKeys;
    private boolean mInReceivingTrappedKeys;
    private boolean mInMenuLoop;
    private boolean mIsRepeatMessage;
    private boolean mUseMouseKey;
    private int mMouseKeyXAccel;
    private int mMouseKeyYAccel;
    private int mLastMouseKeyTick;
    private boolean mLastMouseMoved;
    private boolean mMouseLeftButtonEmulatedPushed;
    private boolean mMouseRightButtonEmulatedPushed;
    private java.awt.Point mLastMouseMovedPos;
    private boolean mAttentionPointEnabled;
    private java.awt.Point mAttentionPoint;
    private java.awt.Font mAttentionFont;
    private int mMouseCursorState;
    private boolean mForceMouseCursorVisible;
    private Cursor mCurrentMouseCursor;
    private int mLastMouseScreenX;
    private int mLastMouseScreenY;
    private int mLayerLeft;
    private int mLayerTop;
    private int mLayerWidth;
    private int mLayerHeight;
    private int mZoomDenom;
    private int mZoomNumer;
    private int mActualZoomDenom;
    private int mActualZoomNumer;
    private boolean mMenuBarVisible;
    private boolean mProgramClosing;
    private int mModalResult;
    private boolean mCanCloseWork;
    private boolean mClosing;
    private int mBorderStyle;
    private static final int mrOk = 1;
    private static final int mrCancel = 2;
    private static final int mrAbort = 3;
    private static final int mrRetry = 4;
    private static final int mrIgnore = 5;
    private static final int mrYes = 6;
    private static final int mrNo = 7;
    private static final int mrAll = 8;
    private static final int mrNoToAll = 9;
    private static final int mrYesToAll = 10;
    private static final int CLIENT_WIDTH = 320;
    private static final int CLIENT_HEIGHT = 240;
    private ImagePanel mPanel;
    private JScrollPane mScrollBox;
    private DrawTarget mDrawTarget;
    private DropTarget mDropTarget;
    private JMenuBar mMenuBar;
    private MenuItem mRootMenuItem;
    private long mLastRecheckInputStateSent;
    public static final int SS_SHIFT = 1;
    public static final int SS_ALT = 2;
    public static final int SS_CTRL = 4;
    public static final int SS_LEFT = 8;
    public static final int SS_RIGHT = 16;
    public static final int SS_MIDDLE = 32;
    public static final int SS_DOUBLE = 64;
    public static final int SS_REPEAT = 128;
    public static final int SS_ALTGRAPH = 256;
    public static final int SS_META = 512;
    private static final int fsrAuto = 0;
    private static final int fsrProportional = 1;
    private static final int fsrNearest = 2;
    private static final int fsrNoChange = 3;
    private static final int fszmNone = 0;
    private static final int fszmInner = 1;
    private static final int fszmOuter = 2;
    private static ScreenMode DefaultScreenMode;

    public WindowForm(WindowNI ni) {
        this.mNativeInstance = ni;
        this.mNextSetWindowHandleToDrawDevice = true;
        this.mLastSentDrawDeviceDestRect = new Rect();
        this.mFocusable = true;
        this.mInnerWidthSave = 320;
        this.mInnerHeightSave = 240;
        this.mMenuBarVisible = true;
        this.mActualZoomDenom = 1;
        this.mZoomDenom = 1;
        this.mActualZoomNumer = 1;
        this.mZoomNumer = 1;
        this.mLastMouseMovedPos = new java.awt.Point();
        this.mAttentionPoint = new java.awt.Point();
        this.mCurrentMouseCursor = Cursor.getDefaultCursor();
        this.mDrawTarget = new DrawTarget();
        this.enableInputMethods(true);
        this.addInputMethodListener(this);
        this.addKeyListener(this);
        this.requestFocus();
        Color transcolor = new Color(0, true);
        this.mPanel = new ImagePanel();
        this.mPanel.setOwner(this);
        this.mPanel.setDrawListener(this);
        this.mPanel.setSize(320, 240);
        this.mPanel.setPreferredSize(new Dimension(320, 240));
        this.mPanel.addMouseListener(this);
        this.mPanel.addMouseMotionListener(this);
        this.mPanel.addMouseWheelListener(this);
        this.mPanel.setOpaque(false);
        this.mPanel.setBackground(transcolor);
        this.mPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.mScrollBox = new JScrollPane(this.mPanel);
        this.mScrollBox.setVerticalScrollBarPolicy(20);
        this.mScrollBox.setHorizontalScrollBarPolicy(30);
        this.mScrollBox.setPreferredSize(new Dimension(320, 240));
        this.mScrollBox.setOpaque(false);
        this.mScrollBox.setBackground(transcolor);
        JViewport viewport = this.mScrollBox.getViewport();
        viewport.setOpaque(true);
        viewport.setBackground(new Color(0, false));
        this.getContentPane().add((Component)this.mScrollBox, "Center");
        if (TVP.getAppTitle() != null) {
            this.setTitle(TVP.getAppTitle());
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.addComponentListener(this);
        this.mDropTarget = new DropTarget(this, 3, this, true);
        this.setSize(320, 240);
    }

    public boolean getWindowActive() {
        return this.isActive();
    }

    @Override
    public void windowOpened(WindowEvent e) {
        if (this.mInnerWidthSave != 0 && this.mInnerHeightSave != 0) {
            this.setInnerSize(this.mInnerWidthSave, this.mInnerHeightSave);
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (TVP.EventManager.getBreathing()) {
            return;
        }
        if (this.mNativeInstance != null && (this.mModalResult == 0 || this.mModalResult == 2)) {
            Dispatch2 obj = this.mNativeInstance.getOwner();
            if (obj != null) {
                Variant[] arg = new Variant[]{new Variant(1)};
                String eventname = "onCloseQuery";
                if (!this.mProgramClosing) {
                    if (this.mNativeInstance != null) {
                        TVP.EventManager.postInputEvent(new WindowEvents.OnCloseInputEvent(this.mNativeInstance), 0);
                    }
                    this.mClosing = true;
                } else {
                    this.mCanCloseWork = true;
                    TVP.EventManager.postEvent(obj, obj, "onCloseQuery", 0, 2, arg);
                    if (this.mCanCloseWork) {
                        this.dispose();
                    }
                }
            } else {
                this.dispose();
            }
        } else {
            this.dispose();
        }
    }

    @Override
    public void windowClosed(WindowEvent e) {
        if (this.mNativeInstance != null) {
            this.mNativeInstance.isMainWindow();
            Dispatch2 obj = this.mNativeInstance.getOwner();
            this.mNativeInstance.notifyWindowClose();
            try {
                if (obj != null) {
                    obj.invalidate(0, null, obj);
                }
            }
            catch (VariantException variantException) {
            }
            catch (TJSException tJSException) {
                // empty catch block
            }
            this.mNativeInstance = null;
        }
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
        TVP.clearKeyStates();
        if (this.mNativeInstance != null) {
            TVP.EventManager.postInputEvent(new WindowEvents.OnReleaseCaptureInputEvent(this.mNativeInstance), 0);
        }
        this.deliverPopupHide();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int ct = e.getClickCount();
        if (this.mNativeInstance != null) {
            e.consume();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        int mod = e.getModifiersEx();
        int button = WindowForm.getMouseButtonNumber(e);
        int ct = e.getClickCount();
        if (!this.canSendPopupHide()) {
            this.deliverPopupHide();
        }
        this.mLastMouseDownX = x;
        this.mLastMouseDownY = y;
        if (this.mNativeInstance != null) {
            if (button == 0 && ct == 2) {
                TVP.EventManager.postInputEvent(new WindowEvents.OnDoubleClickInputEvent(this.mNativeInstance, this.mLastMouseDownX, this.mLastMouseDownY), 0);
            }
            int shift = WindowForm.modifiersToInt(mod, ct, e) & 0xFFFFFFBF;
            TVP.EventManager.postInputEvent(new WindowEvents.OnMouseDownInputEvent(this.mNativeInstance, x, y, button, shift), 0);
            e.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        int mod = e.getModifiersEx();
        int button = WindowForm.getMouseButtonNumber(e);
        int ct = e.getClickCount();
        if (this.mNativeInstance != null) {
            if (button == 0 && ct != 2) {
                TVP.EventManager.postInputEvent(new WindowEvents.OnClickInputEvent(this.mNativeInstance, this.mLastMouseDownX, this.mLastMouseDownY), 0);
            }
            int shift = WindowForm.modifiersToInt(mod, ct, e) & 0xFFFFFFBF;
            TVP.EventManager.postInputEvent(new WindowEvents.OnMouseUpInputEvent(this.mNativeInstance, x, y, button, shift), 0);
            e.consume();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        Random.updateEnvironNoiseForTick();
        if (this.mNativeInstance != null) {
            TVP.EventManager.postInputEvent(new WindowEvents.OnMouseEnterInputEvent(this.mNativeInstance), 0);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        Random.updateEnvironNoiseForTick();
        if (this.mNativeInstance != null) {
            TVP.EventManager.postInputEvent(new WindowEvents.OnMouseOutOfWindowInputEvent(this.mNativeInstance), 0);
            TVP.EventManager.postInputEvent(new WindowEvents.OnMouseLeaveInputEvent(this.mNativeInstance), 0);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.restoreMouseCursor();
        int x = e.getX();
        int y = e.getY();
        int mod = e.getModifiersEx();
        int ct = e.getClickCount();
        if (this.mNativeInstance != null) {
            int shift = WindowForm.modifiersToInt(mod, ct, e) & 0xFFFFFFBF;
            TVP.EventManager.postInputEvent(new WindowEvents.OnMouseMoveInputEvent(this.mNativeInstance, x, y, shift), 16);
            e.consume();
        }
        int pos = (y << 16) + x;
        Random.pushEnvironNoise(pos);
        this.mLastMouseMovedPos.x = x;
        this.mLastMouseMovedPos.y = y;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.restoreMouseCursor();
        int x = e.getX();
        int y = e.getY();
        int mod = e.getModifiersEx();
        int ct = e.getClickCount();
        if (this.mNativeInstance != null) {
            int shift = WindowForm.modifiersToInt(mod, ct, e) & 0xFFFFFFBF;
            TVP.EventManager.postInputEvent(new WindowEvents.OnMouseMoveInputEvent(this.mNativeInstance, x, y, shift), 16);
            e.consume();
        }
        int pos = (y << 16) + x;
        Random.pushEnvironNoise(pos);
        this.mLastMouseMovedPos.x = x;
        this.mLastMouseMovedPos.y = y;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int delta = -e.getWheelRotation() * 120;
        int x = e.getX();
        int y = e.getY();
        int mod = e.getModifiersEx();
        int ct = e.getClickCount();
        if (this.mNativeInstance != null) {
            int shift = WindowForm.modifiersToInt(mod, ct, e);
            TVP.EventManager.postInputEvent(new WindowEvents.OnMouseWheelInputEvent(this.mNativeInstance, shift, delta, x, y), 0);
            e.consume();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.requestFocus();
        char keyChar = e.getKeyChar();
        if (this.mNativeInstance != null && keyChar != '\u0000') {
            TVP.EventManager.postInputEvent(new WindowEvents.OnKeyPressInputEvent(this.mNativeInstance, keyChar), 0);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        TVP.setKeyState(e.getKeyCode());
        if (this.mNativeInstance != null) {
            int mod = e.getModifiersEx();
            int shift = WindowForm.modifiersToInt(mod, 0, null);
            this.internalKeyDown(e.getKeyCode(), this.mIsRepeatMessage ? shift | 0x80 : shift);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        TVP.resetKeyState(e.getKeyCode());
        int mod = e.getModifiersEx();
        int shift = WindowForm.modifiersToInt(mod, 0, null);
        this.internalKeyUp(e.getKeyCode(), shift);
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.mNativeInstance != null) {
            TVP.EventManager.postInputEvent(new WindowEvents.OnResizeInputEvent(this.mNativeInstance), 1);
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            dtde.acceptDrag(1);
            return;
        }
        dtde.rejectDrag();
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        if (this.mNativeInstance == null) {
            dtde.rejectDrop();
            return;
        }
        Dispatch2 array = null;
        try {
            array = TJS.createArrayObject();
            if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrop(1);
                Transferable t = dtde.getTransferable();
                List list = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                Variant val = new Variant();
                int count = 0;
                for (Object o : list) {
                    if (!(o instanceof File)) continue;
                    File f = (File)o;
                    val.set(TVP.StorageMediaManager.normalizeStorageName(f.getAbsolutePath(), null));
                    array.propSetByNum(2560, count, val, array);
                    ++count;
                }
                Variant arg = new Variant(array, array);
                TVP.EventManager.postInputEvent(new WindowEvents.OnFileDropInputEvent(this.mNativeInstance, arg), 0);
                dtde.dropComplete(true);
                array = null;
                return;
            }
        }
        catch (UnsupportedFlavorException ufe) {
            array = null;
        }
        catch (IOException ioe) {
            array = null;
        }
        catch (VariantException e) {
            array = null;
        }
        catch (TJSException e) {
            array = null;
        }
        dtde.rejectDrop();
    }

    private static final int getMouseButtonNumber(MouseEvent e) {
        int num = e.getButton();
        if (num == 1) {
            return 0;
        }
        if (num == 2) {
            return 2;
        }
        if (num == 3) {
            return 1;
        }
        return 0;
    }

    public static int modifiersToInt(int state, int clickcount, MouseEvent e) {
        int f = 0;
        if ((state & 0x40) != 0) {
            ++f;
        }
        if ((state & 0x200) != 0) {
            f += 2;
        }
        if ((state & 0x80) != 0) {
            f += 4;
        }
        if ((state & 0x400) != 0) {
            f += 8;
        }
        if ((state & 0x800) != 0) {
            f += 32;
        }
        if ((state & 0x1000) != 0) {
            f += 16;
        }
        if ((state & 0x2000) != 0) {
            f += 256;
        }
        if ((state & 0x100) != 0) {
            f += 512;
        }
        if (clickcount == 2) {
            f += 64;
        }
        return f;
    }

    public static final boolean isAnyMouseButtonPressedInShiftStateFlags(int state) {
        return (state & 0x78) != 0;
    }

    public void close() {
        if (this.mClosing) {
            return;
        }
        this.mProgramClosing = true;
        this.windowClosing(null);
        this.mProgramClosing = false;
    }

    public void invalidateClose() {
        this.mNativeInstance = null;
        super.setVisible(false);
        this.dispose();
    }

    public void getCursorPos(Point pt) {
        java.awt.Point pos = this.mPanel.getMousePosition();
        if (pos != null) {
            pt.x = pos.x;
            pt.y = pos.y;
        } else {
            PointerInfo pi = MouseInfo.getPointerInfo();
            java.awt.Point p = pi.getLocation();
            SwingUtilities.convertPointFromScreen(p, this.mPanel);
            pt.x = p.x;
            pt.y = p.y;
        }
    }

    private java.awt.Point getCursorPos() {
        java.awt.Point pos = this.mPanel.getMousePosition();
        if (pos != null) {
            return pos;
        }
        PointerInfo pi = MouseInfo.getPointerInfo();
        java.awt.Point p = pi.getLocation();
        SwingUtilities.convertPointFromScreen(p, this.mPanel);
        return p;
    }

    public void setFullScreenMode(boolean b) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        if (b) {
            if (graphicsDevice.getFullScreenWindow() != this) {
                Rectangle rect = super.getBounds();
                this.mOrgLeft = rect.x;
                this.mOrgTop = rect.y;
                this.mOrgWidth = rect.width;
                this.mOrgHeight = rect.height;
                this.dispose();
                this.setUndecorated(true);
                this.setVisible(true);
                graphicsDevice.setFullScreenWindow(this);
            }
        } else if (graphicsDevice.getFullScreenWindow() == this) {
            graphicsDevice.setFullScreenWindow(null);
            this.dispose();
            this.setUndecorated(false);
            this.setVisible(true);
            this.repaint();
        }
        this.requestFocusInWindow();
    }

    public boolean getFullScreenMode() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        return graphicsDevice.getFullScreenWindow() == this;
    }

    @Override
    public void onDraw(Graphics graphic) {
        if (this.mNextSetWindowHandleToDrawDevice) {
            boolean ismain = false;
            if (this.mNativeInstance != null) {
                ismain = this.mNativeInstance.isMainWindow();
            }
            if (this.mNativeInstance != null) {
                this.mNativeInstance.setTargetWindow(this.mDrawTarget, ismain);
            }
            this.mNextSetWindowHandleToDrawDevice = false;
        }
        this.setDrawDeviceDestRect();
        this.mDrawTarget.setGraphics(graphic, this);
        if (this.mNativeInstance != null) {
            Rect r = new Rect();
            Rectangle tr = this.mPanel.getBounds();
            r.left = tr.x;
            r.top = tr.y;
            r.right = tr.x + tr.width;
            r.bottom = tr.y + tr.height;
            this.mNativeInstance.notifyWindowExposureToLayer(r);
        }
    }

    private void setDrawDeviceDestRect() {
        int x_ofs = 0;
        int y_ofs = 0;
        Rectangle tr = this.mPanel.getBounds();
        Rect destrect = new Rect(tr.x + x_ofs, tr.y + y_ofs, tr.width + tr.x + x_ofs, tr.height + tr.y + y_ofs);
        if (this.mLastSentDrawDeviceDestRect.notEquals(destrect)) {
            if (this.mNativeInstance != null) {
                this.mNativeInstance.setDestRectangle(destrect);
            }
            this.mLastSentDrawDeviceDestRect.set(destrect);
        }
    }

    public boolean getFormEnabled() {
        return this.isEnabled();
    }

    public void sendCloseMessage() {
        this.getToolkit().getSystemEventQueue().postEvent(new WindowEvent(this, 201));
    }

    public void tickBeat() throws TJSException {
        long tickcount = TVP.getTickCount();
        boolean showingmenu = this.mInMenuLoop;
        this.setForceMouseCursorVisible(showingmenu);
        if (tickcount - this.mLastRecheckInputStateSent > 1000L) {
            this.mLastRecheckInputStateSent = tickcount;
            if (this.mNativeInstance != null) {
                this.mNativeInstance.recheckInputState();
            }
        }
    }

    public void resetDrawDevice() {
        this.mNextSetWindowHandleToDrawDevice = true;
        this.mLastSentDrawDeviceDestRect.clear();
        if (this.mPanel != null) {
            this.mPanel.repaint();
        }
    }

    public void internalKeyDown(int key, int shift) {
        long tick = TVP.getTickCount();
        Random.pushEnvironNoise(tick);
        Random.pushEnvironNoise(key);
        Random.pushEnvironNoise(shift);
        if (this.mNativeInstance != null) {
            TVP.EventManager.postInputEvent(new WindowEvents.OnKeyDownInputEvent(this.mNativeInstance, key, shift), 0);
        }
    }

    private void internalKeyUp(int key, int shift) {
        long tick = TVP.getTickCount();
        Random.pushEnvironNoise(tick);
        Random.pushEnvironNoise(key);
        Random.pushEnvironNoise(shift);
        if (this.mNativeInstance != null) {
            TVP.EventManager.postInputEvent(new WindowEvents.OnKeyUpInputEvent(this.mNativeInstance, key, shift), 0);
        }
    }

    public void onKeyUp(int key, int shift) {
        this.internalKeyUp(key, shift);
    }

    public void onKeyPress(char key) {
        if (this.mNativeInstance != null && key != '\u0000') {
            TVP.EventManager.postInputEvent(new WindowEvents.OnKeyPressInputEvent(this.mNativeInstance, key), 0);
        }
    }

    public void setPaintBoxSize(int w, int h) {
        JScrollBar bar = this.mScrollBox.getVerticalScrollBar();
        if (bar != null) {
            bar.setValue(0);
        }
        if ((bar = this.mScrollBox.getHorizontalScrollBar()) != null) {
            bar.setValue(0);
        }
        this.mLayerWidth = w;
        this.mLayerHeight = h;
        this.internalSetPaintBoxSize();
    }

    public void setCursorPos(int x, int y) {
        this.restoreMouseCursor();
    }

    public void setHintText(String text) {
        this.mPanel.setToolTipText(text);
    }

    public void disableAttentionPoint() {
        this.mAttentionPointEnabled = false;
    }

    public void setImeMode(int mode) {
    }

    public int getDefaultImeMode() {
        return 0;
    }

    public void resetImeMode() {
    }

    private void acquireImeControl() {
        this.requestFocus();
        this.enableInputMethods(true);
    }

    public void zoomRectangle(Rect rect) {
        rect.left = rect.left * this.mActualZoomNumer / this.mActualZoomDenom;
        rect.top = rect.top * this.mActualZoomNumer / this.mActualZoomDenom;
        rect.right = rect.right * this.mActualZoomNumer / this.mActualZoomDenom;
        rect.bottom = rect.bottom * this.mActualZoomNumer / this.mActualZoomDenom;
    }

    public void registerWindowMessageReceiver(int mode, Object proc, Object userdata) {
    }

    public void onCloseQueryCalled(boolean b) throws VariantException, TJSException {
        if (!this.mProgramClosing) {
            if (b) {
                if (this.mInMode) {
                    this.mModalResult = 1;
                } else {
                    this.setVisible(false);
                }
                this.mClosing = false;
                if (this.mNativeInstance != null) {
                    if (this.mNativeInstance.isMainWindow()) {
                        Dispatch2 obj = this.mNativeInstance.getOwner();
                        obj.invalidate(0, null, obj);
                        this.mNativeInstance = null;
                    }
                } else {
                    this.dispose();
                }
            } else {
                this.mClosing = false;
            }
        } else {
            this.mCanCloseWork = b;
        }
    }

    public void beginMove() {
    }

    public void bringToFront() {
        this.toFront();
    }

    public void updateWindow(int type) throws VariantException, TJSException {
        if (this.mNativeInstance != null) {
            Rect r = new Rect();
            r.left = 0;
            r.top = 0;
            r.right = this.mLayerWidth;
            r.bottom = this.mLayerHeight;
            this.mNativeInstance.notifyWindowExposureToLayer(r);
            TVP.EventManager.deliverWindowUpdateEvents();
        }
    }

    public void setMouseCursor(int handle) {
        Cursor cur = TVP.MouseCursor.getCursor(handle);
        if (cur != null) {
            if (this.mMouseCursorState == 0 && !this.mForceMouseCursorVisible) {
                this.setCursor(cur);
            }
            this.mCurrentMouseCursor = cur;
        } else {
            this.mCurrentMouseCursor = Cursor.getDefaultCursor();
            this.setCursor(this.mCurrentMouseCursor);
        }
    }

    public void hideMouseCursor() {
        this.setMouseCursorState(1);
    }

    public void setMouseCursorState(int mcs) {
        if (this.mMouseCursorState == 0 && mcs != 0) {
            if (!this.mForceMouseCursorVisible) {
                this.setMouseCursorVisibleState(false);
            }
        } else if (this.mMouseCursorState != 0 && mcs == 0 && !this.mForceMouseCursorVisible) {
            this.setMouseCursorVisibleState(true);
        }
        if (this.mMouseCursorState != mcs && mcs == 1) {
            java.awt.Point pos = this.getCursorPos();
            this.mLastMouseScreenX = pos.x;
            this.mLastMouseScreenY = pos.y;
        }
        this.mMouseCursorState = mcs;
    }

    private void restoreMouseCursor() {
        if (this.mMouseCursorState == 1) {
            java.awt.Point pt = this.getCursorPos();
            if (this.mLastMouseScreenX != pt.x || this.mLastMouseScreenY != pt.y) {
                this.setMouseCursorState(0);
            }
        }
    }

    private void setMouseCursorVisibleState(boolean b) {
        if (b) {
            this.setCursor(this.mCurrentMouseCursor);
        } else {
            this.setCursor(TVP.MouseCursor.getCursor(-1));
        }
    }

    private void setForceMouseCursorVisible(boolean s) {
        if (this.mForceMouseCursorVisible != s) {
            if (s) {
                this.setDefaultMouseCursor();
            } else {
                this.setMouseCursorVisibleState(this.mMouseCursorState == 0);
            }
            this.mForceMouseCursorVisible = s;
        }
    }

    public void setDefaultMouseCursor() {
        if (this.mCurrentMouseCursor != Cursor.getDefaultCursor()) {
            this.mCurrentMouseCursor = Cursor.getDefaultCursor();
            if (this.getCursor() != this.mCurrentMouseCursor) {
                this.setCursor(this.mCurrentMouseCursor);
            }
        }
    }

    public boolean getVisible() {
        return this.isVisible();
    }

    public String getCaption() {
        return this.getTitle();
    }

    public void setCaption(String v) {
        this.setTitle(v);
    }

    public void setWidth(int w) {
        this.setSize(w, this.getHeight());
    }

    public void setHeight(int h) {
        this.setSize(this.getWidth(), h);
    }

    public void setLeft(int l) {
        this.setLocation(l, this.getY());
    }

    public int getLeft() {
        return this.getX();
    }

    public void setTop(int t) {
        this.setLocation(this.getX(), t);
    }

    public int getTop() {
        return this.getY();
    }

    public void setMinWidth(int v) {
        Dimension dim = this.getMinimumSize();
        dim.width = v;
        this.setMinimumSize(dim);
    }

    public int getMinWidth() {
        return this.getMinimumSize().width;
    }

    public void setMinHeight(int v) {
        Dimension dim = this.getMinimumSize();
        dim.height = v;
        this.setMinimumSize(dim);
    }

    public int getMinHeight() {
        return this.getMinimumSize().height;
    }

    public void setMinSize(int w, int h) {
        Dimension dim = this.getMinimumSize();
        dim.width = w;
        dim.height = h;
        this.setMinimumSize(dim);
    }

    public void setMaxWidth(int v) {
        Dimension dim = this.getMaximumSize();
        dim.width = v;
        this.setMaximumSize(dim);
    }

    public void setMaxHeight(int v) {
        Dimension dim = this.getMaximumSize();
        dim.height = v;
        this.setMaximumSize(dim);
    }

    public int getMaxWidth() {
        return this.getMaximumSize().width;
    }

    public int getMaxHeight() {
        return this.getMaximumSize().height;
    }

    public void setMaxSize(int w, int h) {
        Dimension dim = this.getMaximumSize();
        dim.width = w;
        dim.height = h;
        this.setMaximumSize(dim);
    }

    public void setPosition(int l, int t) {
        this.setLocation(l, t);
    }

    private void internalSetPaintBoxSize() {
        int l = this.mLayerLeft * this.mActualZoomNumer / this.mActualZoomDenom;
        int t = this.mLayerTop * this.mActualZoomNumer / this.mActualZoomDenom;
        int w = this.mLayerWidth * this.mActualZoomNumer / this.mActualZoomDenom;
        int h = this.mLayerHeight * this.mActualZoomNumer / this.mActualZoomDenom;
        this.mPanel.setSize(w, h);
        this.mPanel.setLocation(l, t);
        this.mPanel.setPreferredSize(new Dimension(w, h));
        this.setDrawDeviceDestRect();
    }

    public void setLayerLeft(int left) {
        if (this.mLayerLeft != left) {
            this.mLayerLeft = left;
            if (this.mPanel != null) {
                this.internalSetPaintBoxSize();
            }
        }
    }

    public int getLayerLeft() {
        return this.mLayerLeft;
    }

    public void setLayerTop(int top) {
        if (this.mLayerTop != top) {
            this.mLayerTop = top;
            if (this.mPanel != null) {
                this.internalSetPaintBoxSize();
            }
        }
    }

    public int getLayerTop() {
        return this.mLayerTop;
    }

    public void setLayerPosition(int left, int top) {
        if (this.mLayerLeft != left || this.mLayerTop != top) {
            this.mLayerLeft = left;
            this.mLayerTop = top;
            if (this.mPanel != null) {
                this.internalSetPaintBoxSize();
            }
        }
    }

    public void setInnerSunken(boolean b) {
        if (b) {
            this.mScrollBox.setViewportBorder(new BevelBorder(1));
        } else {
            this.mScrollBox.setViewportBorder(new EmptyBorder(0, 0, 0, 0));
        }
    }

    public boolean getInnerSunken() {
        Border b = this.mScrollBox.getViewportBorder();
        return b instanceof LineBorder;
    }

    public void setInnerWidth(int w) {
        this.mInnerWidthSave = w;
        int h = this.mPanel.getHeight();
        Insets insets = this.mPanel.getInsets();
        this.mPanel.setSize(w += insets.left + insets.right, h += insets.top + insets.bottom);
        insets = this.getInsets();
        w += insets.left + insets.right;
        h += insets.top + insets.bottom;
        insets = this.mScrollBox.getInsets();
        w += insets.left + insets.right;
        h += insets.top + insets.bottom;
        if (this.getJMenuBar() != null) {
            JMenuBar bar = this.getJMenuBar();
            h += bar.getHeight();
        }
        super.setSize(w, h);
    }

    public int getInnerWidth() {
        int w = this.mScrollBox.getViewport().getWidth();
        Insets insets = this.mPanel.getInsets();
        return w -= insets.left + insets.right;
    }

    public void setInnerHeight(int h) {
        this.mInnerHeightSave = h;
        int w = this.mPanel.getWidth();
        Insets insets = this.mPanel.getInsets();
        this.mPanel.setSize(w += insets.left + insets.right, h += insets.top + insets.bottom);
        insets = this.getInsets();
        w += insets.left + insets.right;
        h += insets.top + insets.bottom;
        insets = this.mScrollBox.getInsets();
        w += insets.left + insets.right;
        h += insets.top + insets.bottom;
        if (this.getJMenuBar() != null) {
            JMenuBar bar = this.getJMenuBar();
            h += bar.getHeight();
        }
        super.setSize(w, h);
    }

    public int getInnerHeight() {
        int h = this.mScrollBox.getViewport().getHeight();
        Insets insets = this.mPanel.getInsets();
        return h -= insets.top + insets.bottom;
    }

    public void setInnerSize(int w, int h) {
        this.mInnerWidthSave = w;
        this.mInnerHeightSave = h;
        Insets insets = this.mPanel.getInsets();
        this.mPanel.setSize(w += insets.left + insets.right, h += insets.top + insets.bottom);
        this.mPanel.setPreferredSize(new Dimension(w, h));
        insets = this.mScrollBox.getInsets();
        w += insets.left + insets.right;
        h += insets.top + insets.bottom;
        Border border = this.mScrollBox.getViewportBorder();
        if (border != null) {
            insets = border.getBorderInsets(this.mScrollBox);
            w += insets.left + insets.right;
            h += insets.top + insets.bottom;
        }
        insets = this.getInsets();
        w += insets.left + insets.right;
        h += insets.top + insets.bottom;
        if (this.getJMenuBar() != null) {
            JMenuBar bar = this.getJMenuBar();
            h += bar.getHeight();
        }
        super.setSize(w, h);
    }

    public void setMenuBarVisible(boolean b) {
        this.mMenuBarVisible = b;
        JMenuBar bar = this.getJMenuBar();
        if (bar != null) {
            bar.setVisible(b);
        }
    }

    public boolean getMenuBarVisible() {
        JMenuBar bar = this.getJMenuBar();
        if (bar != null) {
            return bar.isVisible();
        }
        return false;
    }

    public void setAttentionPoint(int left, int top, Font font) {
        Insets insets = this.mPanel.getInsets();
        left += insets.left;
        top += insets.top;
        insets = this.mScrollBox.getInsets();
        left += insets.left;
        top += insets.top;
        insets = this.getInsets();
        this.mAttentionPoint.x = left += insets.left;
        this.mAttentionPoint.y = top += insets.top;
        this.mAttentionPointEnabled = true;
        this.mAttentionFont = font != null ? font.getFont() : Font.getDefaultFont().getFont();
        this.acquireImeControl();
    }

    public void showWindowAsModal() {
        this.mModalResult = 0;
        this.mInMode = true;
        if (this.mNativeInstance != null) {
            Dispatch2 obj = this.mNativeInstance.getOwner();
            Variant tmp = new Variant(1);
            try {
                String name;
                String prop = TVP.Properties.getProperty("modal_force_result_true", "true");
                if (("yes".equals(prop) || "true".equals(prop)) && obj.isValid(0, name = TVP.Properties.getProperty("modal_force_result_member_name", "result"), obj) == 1) {
                    obj.propSet(512, name, tmp, obj);
                }
            }
            catch (VariantException variantException) {
            }
            catch (TJSException tJSException) {
                // empty catch block
            }
        }
    }

    public void removeMaskRegion() {
    }

    public void setZoom(int numer, int denom) {
        this.setZoom(numer, denom, true);
    }

    public void setZoom(int numer, int denom, boolean set_logical) {
        java.awt.Point ad = this.adjustNumerAndDenom(numer, denom);
        numer = ad.x;
        denom = ad.y;
        if (set_logical) {
            this.mZoomNumer = numer;
            this.mZoomDenom = denom;
        }
        if (!this.getFullScreenMode()) {
            this.mActualZoomDenom = denom;
            this.mActualZoomNumer = numer;
        }
        this.internalSetPaintBoxSize();
    }

    private java.awt.Point adjustNumerAndDenom(int n, int d) {
        int a = n;
        int b = d;
        while (b != 0) {
            int t = b;
            b = a % b;
            a = t;
        }
        return new java.awt.Point(n /= a, d /= a);
    }

    public boolean getFocusable() {
        return this.mFocusable;
    }

    @Override
    public void setFocusable(boolean b) {
        this.mFocusable = b;
    }

    public void setZoomNumer(int n) {
        this.setZoom(n, this.mZoomDenom);
    }

    public int getZoomNumer() {
        return this.mZoomNumer;
    }

    public void setZoomDenom(int d) {
        this.setZoom(this.mZoomNumer, d);
    }

    public int getZoomDenom() {
        return this.mZoomDenom;
    }

    public void setBorderStyle(int st) {
        this.mBorderStyle = st;
        switch (st) {
            case 0: {
                this.setResizable(false);
                break;
            }
            case 1: {
                this.setResizable(false);
                break;
            }
            case 2: {
                this.setResizable(true);
                break;
            }
            case 3: {
                this.setResizable(false);
                break;
            }
            case 4: {
                this.setResizable(false);
                break;
            }
            case 5: {
                this.setResizable(true);
            }
        }
    }

    public int getBorderStyle() {
        return this.mBorderStyle;
    }

    public void setStayOnTop(boolean b) {
        this.setAlwaysOnTop(b);
    }

    public boolean getStayOnTop() {
        return this.isAlwaysOnTop();
    }

    public void setShowScrollBars(boolean b) {
        if (b) {
            this.mScrollBox.setVerticalScrollBarPolicy(20);
            this.mScrollBox.setHorizontalScrollBarPolicy(30);
        } else {
            this.mScrollBox.setVerticalScrollBarPolicy(21);
            this.mScrollBox.setHorizontalScrollBarPolicy(31);
        }
    }

    public boolean getShowScrollBars() {
        JScrollBar vbar = this.mScrollBox.getVerticalScrollBar();
        JScrollBar hbar = this.mScrollBox.getHorizontalScrollBar();
        return vbar != null && vbar.isVisible() || hbar != null && hbar.isVisible();
    }

    public void setUseMouseKey(boolean b) {
        this.mUseMouseKey = b;
    }

    public boolean getUseMouseKey() {
        return this.mUseMouseKey;
    }

    public void setTrapKey(boolean b) {
        this.mTrapKeys = b;
        if (this.mTrapKeys) {
            this.mCanReceiveTrappedKeys = false;
            this.mInReceivingTrappedKeys = false;
        }
    }

    public boolean getTrapKey() {
        return this.mTrapKeys;
    }

    public int getMouseCursorState() {
        return this.mMouseCursorState;
    }

    private void deliverPopupHide() {
        int count = TVP.WindowList.getWindowCount();
        int i = count - 1;
        while (i >= 0) {
            WindowForm form;
            WindowNI win = TVP.WindowList.getWindowListAt(i);
            if (win != null && (form = win.getForm()) != null) {
                form.firePopupHide();
            }
            --i;
        }
    }

    private void firePopupHide() {
        if (!this.canSendPopupHide()) {
            return;
        }
        if (!this.getVisible()) {
            return;
        }
        TVP.EventManager.postInputEvent(new WindowEvents.OnPopupHideInputEvent(this.mNativeInstance), 0);
    }

    private boolean canSendPopupHide() {
        return !this.mFocusable && this.getVisible() && this.getStayOnTop();
    }

    private static final String getGetFullScreenResolutionModeString(int mode) {
        switch (mode) {
            case 0: {
                return "fsrAuto";
            }
            case 1: {
                return "fsrProportional";
            }
            case 2: {
                return "fsrNearest";
            }
            case 3: {
                return "fsrNoChange";
            }
        }
        return "";
    }

    private static final void getOriginalScreenMetrics() {
        if (DefaultScreenMode == null) {
            DefaultScreenMode = new ScreenMode();
        }
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        DisplayMode mode = graphicsDevice.getDisplayMode();
        WindowForm.DefaultScreenMode.mWidth = mode.getWidth();
        WindowForm.DefaultScreenMode.mHeight = mode.getHeight();
        WindowForm.DefaultScreenMode.mBitsPerPixel = mode.getBitDepth();
    }

    private static final void enumerateAllDisplayModes(ArrayList<ScreenMode> modes) {
        modes.clear();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice device = ge.getDefaultScreenDevice();
        DisplayMode[] dmodes = device.getDisplayModes();
        int count = dmodes.length;
        int i = 0;
        while (i < count) {
            DisplayMode m = dmodes[i];
            modes.add(new ScreenMode(m.getWidth(), m.getHeight(), m.getBitDepth()));
            ++i;
        }
    }

    private static final void doReductionNumerAndDenom(java.awt.Point p) {
        int a = p.x;
        int b = p.y;
        while (b != 0) {
            int t = b;
            b = a % b;
            a = t;
        }
        p.x /= a;
        p.y /= a;
    }

    public static void makeFullScreenModeCandidates(ScreenMode preferred, int mode, int zoom_mode, ArrayList<ScreenModeCandidate> candidates) {
        ScreenMode m;
        int i;
        int count;
        if (mode == 0 && zoom_mode == 0) {
            zoom_mode = 1;
        }
        DebugClass.addLog("(info) Searching best fullscreen resolution ...");
        DebugClass.addLog("(info) condition: preferred screen mode: " + preferred.dump());
        DebugClass.addLog("(info) condition: mode: " + WindowForm.getGetFullScreenResolutionModeString(mode));
        DebugClass.addLog("(info) condition: zoom mode: " + (zoom_mode == 1 ? "inner" : (zoom_mode == 2 ? "outer" : "none")));
        WindowForm.getOriginalScreenMetrics();
        int preferred_bpp = preferred.mBitsPerPixel == 0 ? WindowForm.DefaultScreenMode.mBitsPerPixel : preferred.mBitsPerPixel;
        int screen_aspect_numer = WindowForm.DefaultScreenMode.mWidth;
        int screen_aspect_denom = WindowForm.DefaultScreenMode.mHeight;
        java.awt.Point pos = new java.awt.Point(screen_aspect_numer, screen_aspect_denom);
        WindowForm.doReductionNumerAndDenom(pos);
        screen_aspect_numer = pos.x;
        screen_aspect_denom = pos.y;
        DebugClass.addLog("(info) environment: default screen mode: " + DefaultScreenMode.dump());
        DebugClass.addLog("(info) environment: default screen aspect ratio: " + screen_aspect_numer + ":" + screen_aspect_denom);
        candidates.clear();
        ArrayList<ScreenMode> modes = new ArrayList<ScreenMode>();
        WindowForm.enumerateAllDisplayModes(modes);
        Collections.sort(modes, new Comparator<ScreenMode>(){

            @Override
            public int compare(ScreenMode o1, ScreenMode o2) {
                int area_this = o1.mWidth * o1.mHeight;
                int area_rhs = o2.mWidth * o2.mHeight;
                if (area_this < area_rhs) {
                    return -1;
                }
                if (area_this > area_rhs) {
                    return 1;
                }
                if (o1.mBitsPerPixel < o2.mBitsPerPixel) {
                    return -1;
                }
                if (o1.mBitsPerPixel > o2.mBitsPerPixel) {
                    return 1;
                }
                return 0;
            }
        });
        int last_width = -1;
        int last_height = -1;
        String last_line = null;
        DebugClass.addLog("(info) environment: available display modes:");
        int count2 = modes.size();
        int i2 = 0;
        while (i2 < count2) {
            ScreenMode m2 = modes.get(i2);
            if (last_width != m2.mWidth || last_height != m2.mHeight) {
                if (last_line != null) {
                    DebugClass.addLog(last_line);
                }
                pos.x = m2.mWidth;
                pos.y = m2.mHeight;
                WindowForm.doReductionNumerAndDenom(pos);
                int w = pos.x;
                int h = pos.y;
                last_line = "(info)  " + m2.dumpHeightAndWidth() + ", AspectRatio=" + w + ":" + h + ", BitsPerPixel=" + m2.mBitsPerPixel;
            } else {
                last_line = String.valueOf(last_line) + "/" + m2.mBitsPerPixel;
            }
            last_width = m2.mWidth;
            last_height = m2.mHeight;
            ++i2;
        }
        if (last_line != null) {
            DebugClass.addLog(last_line);
        }
        if (mode != 3) {
            if (mode != 2) {
                count = modes.size();
                i = count - 1;
                while (i >= 0) {
                    m = modes.get(i);
                    pos.x = m.mWidth;
                    pos.y = m.mHeight;
                    WindowForm.doReductionNumerAndDenom(pos);
                    int aspect_numer = pos.x;
                    int aspect_denom = pos.y;
                    if (aspect_numer != screen_aspect_numer || aspect_denom != screen_aspect_denom) {
                        modes.remove(i);
                    }
                    --i;
                }
            }
            if (zoom_mode == 0) {
                count = modes.size();
                i = count - 1;
                while (i >= 0) {
                    m = modes.get(i);
                    if (m.mWidth < preferred.mWidth || m.mHeight < preferred.mHeight) {
                        modes.remove(i);
                    }
                    --i;
                }
            }
        } else {
            count = modes.size();
            i = count - 1;
            while (i >= 0) {
                m = modes.get(i);
                if (m.mWidth != WindowForm.DefaultScreenMode.mWidth || m.mHeight != WindowForm.DefaultScreenMode.mHeight) {
                    modes.remove(i);
                }
                --i;
            }
        }
        count = modes.size();
        i = count - 1;
        while (i >= 0) {
            m = modes.get(i);
            if (m.mWidth > WindowForm.DefaultScreenMode.mWidth || m.mHeight > WindowForm.DefaultScreenMode.mHeight) {
                modes.remove(i);
            }
            --i;
        }
        count = modes.size();
        i = count - 1;
        while (i >= 0) {
            m = modes.get(i);
            if (m.mBitsPerPixel < 16) {
                modes.remove(i);
            }
            --i;
        }
        if (modes.size() == 0) {
            DebugClass.addImportantLog("(info) Panic! There is no reasonable candidate screen mode provided from the driver ... trying to use the default screen size and color depth ...");
            modes.add(new ScreenMode(WindowForm.DefaultScreenMode.mWidth, WindowForm.DefaultScreenMode.mHeight, WindowForm.DefaultScreenMode.mBitsPerPixel));
        }
        count = modes.size();
        i = count - 1;
        while (i >= 0) {
            m = modes.get(i);
            ScreenModeCandidate candidate = new ScreenModeCandidate();
            candidate.mWidth = m.mWidth;
            candidate.mHeight = m.mHeight;
            candidate.mBitsPerPixel = m.mBitsPerPixel;
            if (zoom_mode != 0) {
                double width_r = (double)candidate.mWidth / (double)preferred.mWidth;
                double height_r = (double)candidate.mHeight / (double)preferred.mHeight;
                if (zoom_mode == 1 ? width_r < height_r : width_r > height_r) {
                    candidate.mZoomNumer = candidate.mWidth;
                    candidate.mZoomDenom = preferred.mWidth;
                } else {
                    candidate.mZoomNumer = candidate.mHeight;
                    candidate.mZoomDenom = preferred.mHeight;
                }
                double zoom_r = (double)candidate.mZoomNumer / (double)candidate.mZoomDenom;
                if (zoom_r > 1.0 && zoom_r < 1.034) {
                    candidate.mZoomNumer = 1;
                    candidate.mZoomDenom = 1;
                }
            } else {
                candidate.mZoomNumer = 1;
                candidate.mZoomDenom = 1;
            }
            pos.x = candidate.mZoomNumer;
            pos.y = candidate.mZoomDenom;
            WindowForm.doReductionNumerAndDenom(pos);
            candidate.mZoomNumer = pos.x;
            candidate.mZoomDenom = pos.y;
            candidate.mRankBPP = Math.abs(preferred_bpp - candidate.mBitsPerPixel);
            if (candidate.mBitsPerPixel < preferred_bpp) {
                candidate.mRankBPP += 1000;
            }
            candidate.mRankZoomIn = candidate.mZoomNumer < candidate.mZoomDenom ? 1 : 0;
            if (mode == 0) {
                int zoom_rank = 0;
                if (candidate.mWidth != WindowForm.DefaultScreenMode.mWidth || candidate.mHeight != WindowForm.DefaultScreenMode.mHeight) {
                    ++zoom_rank;
                }
                if (candidate.mZoomNumer != 1 || candidate.mZoomDenom != 1) {
                    zoom_rank += 2;
                }
                candidate.mRankZoomBeauty = zoom_rank;
            } else {
                candidate.mRankZoomBeauty = 0;
            }
            candidate.mRankSize = Math.abs(candidate.mWidth * candidate.mHeight - preferred.mWidth * preferred.mHeight);
            candidates.add(candidate);
            --i;
        }
        Collections.sort(candidates, new Comparator<ScreenModeCandidate>(){

            @Override
            public int compare(ScreenModeCandidate o1, ScreenModeCandidate o2) {
                if (o1.mRankZoomIn < o2.mRankZoomIn) {
                    return -1;
                }
                if (o1.mRankZoomIn > o2.mRankZoomIn) {
                    return 1;
                }
                if (o1.mRankBPP < o2.mRankBPP) {
                    return -1;
                }
                if (o1.mRankBPP > o2.mRankBPP) {
                    return 1;
                }
                if (o1.mRankZoomBeauty < o2.mRankZoomBeauty) {
                    return -1;
                }
                if (o1.mRankZoomBeauty > o2.mRankZoomBeauty) {
                    return 1;
                }
                if (o1.mRankSize < o2.mRankSize) {
                    return -1;
                }
                if (o1.mRankSize > o2.mRankSize) {
                    return 1;
                }
                return 0;
            }
        });
        DebugClass.addLog("(info) result: candidates:");
        count = candidates.size();
        i = 0;
        while (i < count) {
            ScreenModeCandidate c = candidates.get(i);
            DebugClass.addLog("(info)  " + c.dump());
            ++i;
        }
    }

    public MenuItem getMainMenu() {
        if (this.mMenuBar == null) {
            this.mMenuBar = new JMenuBar();
            this.setJMenuBar(this.mMenuBar);
        }
        if (this.mRootMenuItem == null) {
            this.mRootMenuItem = new MenuItem(this.mMenuBar);
        }
        return this.mRootMenuItem;
    }

    public int getInnerWidthSave() {
        return this.mInnerWidthSave;
    }

    public int getInnerHeightSave() {
        return this.mInnerHeightSave;
    }

    public void repaintPanel() {
        this.mPanel.repaint();
    }

    public void showMenu() {
    }

    @Override
    public Rectangle getTextLocation(TextHitInfo offset) {
        return new Rectangle(this.mAttentionPoint.x, this.mAttentionPoint.y, 10, 10);
    }

    @Override
    public TextHitInfo getLocationOffset(int x, int y) {
        return null;
    }

    @Override
    public int getInsertPositionOffset() {
        return 0;
    }

    @Override
    public AttributedCharacterIterator getCommittedText(int beginIndex, int endIndex, AttributedCharacterIterator.Attribute[] attributes) {
        return null;
    }

    @Override
    public int getCommittedTextLength() {
        return 0;
    }

    @Override
    public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributes) {
        return null;
    }

    @Override
    public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributes) {
        return null;
    }

    @Override
    public void inputMethodTextChanged(InputMethodEvent event) {
        if (this.mNativeInstance != null) {
            AttributedCharacterIterator text = event.getText();
            char key = text.current();
            TVP.EventManager.postInputEvent(new WindowEvents.OnKeyPressInputEvent(this.mNativeInstance, key), 0);
            event.consume();
        }
    }

    @Override
    public void caretPositionChanged(InputMethodEvent event) {
    }
}

