/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef _KITA_H_
#define _KITA_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapplication.h>
#include <kparts/dockmainwindow.h>

class KPrinter;
class KToggleAction;
class KURL;
class KitaThreadTabWidget;
class KitaBoardView;
class KitaSubjectTabWidget;
class KLineEdit;

namespace KParts
{
    class URLArgs;
    class Part;
}

/**
 * This class serves as the main window for Kita.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author $AUTHOR <$EMAIL>
 * @version $APP_VERSION
 */

class KitaMainWindow : public KParts::DockMainWindow
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    KitaMainWindow();

    /**
     * Default Destructor
     */
    virtual ~KitaMainWindow();

    /**
     * Use this method to load whatever file/URL you have
     */
    void load( const KURL& url );

protected:
    /**
     * Overridden virtuals for Qt drag 'n drop (XDND)
     */
    virtual void dragEnterEvent( QDragEnterEvent* event );
    virtual void dropEvent( QDropEvent* event );

    /**
     * This function is called when it is time for the app to save its
     * properties for session management purposes.
     */
    void saveProperties( KConfig* );

    /**
     * This function is called when this app is restored.  The KConfig
     * object points to the session management config file that was saved
     * with @ref saveProperties
     */
    void readProperties( KConfig* );

    void readConfig( KConfig* );
    void writeConfig( KConfig* );

    void windowActivationChange( bool );

private slots:
    void fileNew();
    void optionsShowToolbar();
    void optionsShowStatusbar();
    void optionsConfigureKeys();
    void optionsConfigureToolbars();
    void optionsPreferences();
    void newToolbarConfig();
    void windowShowBoardlist();
    void windowShowSubjectlist();
    void windowToggleView();
    void windowMenuAboutToShow();
    void windowCloseTab();
    void settingsMenuAboutToShow();
    void slotEditCopy();
    void resetWindows();
    void closeSubjectView();
    void closeBoardView();

    void slotSetMainStatusbar( const QString& statusStr );
    void slotOpenURLRequest( const KURL& url, const KParts::URLArgs& );
    void setFont( const QFont& font );
    void slotWriteSucceeded();
    void slotURLLine();
    void setUrl( const KURL& url );
    void bookmark( const QString& datURL, bool on );
    void slotSetMainCaption( const QString& captionStr );
    void slotIsKitaActive();
    void slotSwitchSubjectView();
    void switchThreadView( const QString&, bool );

private:
    KitaThreadTabWidget* m_threadTab;
    KitaBoardView* m_boardView;
    KitaSubjectTabWidget* m_subjectTab;
    KLineEdit* m_urlLine;

    KPrinter *m_printer;
    KToggleAction *m_toolbarAction;
    KToggleAction *m_statusbarAction;
    KToggleAction *m_boardListAction;
    KToggleAction* m_subjectListAction;
    KAction* m_toggleViewAction;

    KDockWidget* m_mainDock;
    KDockWidget* m_boardDock;
    KDockWidget* m_subjectDock;

    void setupAccel();
    void setupActions();
    void setupView();
    void loadCache();
    void saveCache();
    void loadFavorites();
    void saveFavorites();
    void loadFavoriteBoards();
    void saveFavoriteBoards();
    void loadCompletion();
    void saveCompletion();
    void loadAsciiArt();
    void saveAsciiArt();
    void loadAboneIDList();
    void saveAboneIDList();
    void loadAboneNameList();
    void saveAboneNameList();
    void loadAboneWordList();
    void saveAboneWordList();
    
  signals:
    void windowDeactivated();
    void isKitaActive();
    void kitaIsActive();
    void favoritesUpdated();
    void switchSubjectView();
};

#endif // _KITA_H_
