/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef _KITABOARDVIEW_H_
#define _KITABOARDVIEW_H_

#include <qwidget.h>

#include "kitaboardviewbase.h"

class KURL;
class KListViewItem;
class QCp932Codec;

namespace Kita
{
    class Board;
    class Category;
}

/**
 *
 * @author Hideki Ikemoto <ikemo@users.sourceforge.jp>
 **/
class KitaBoardView : public KitaBoardViewBase
{
    Q_OBJECT
    KListViewItem* m_favorites;
    static QCp932Codec* m_cp932Codec;

    QString getCategory( const QString& line ) const;
    QString getBoardURL( const QString& line ) const;
    bool isBoardURL( const QString& url ) const;
    QValueList<Kita::Category> getCategoryList( const QString& html ) const;

private slots:
    void loadBoard( QListViewItem* item );
    void slotContextMenuRequested( QListViewItem*, const QPoint&, int );
    void slotMouseButtonClicked( int, QListViewItem* );
    void refreshFavoriteBoards();

public:
    KitaBoardView( QWidget *parent, const char *name = 0 );
    ~KitaBoardView();

public slots:
    void loadBoardList();
    void setFont( const QFont& font );

signals:
    void openBoardRequested( const QString& boardURL, bool withNewTab );
    void sigShowSubject();    
};

#endif
