/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#include "kitasubjecttabwidget.h"

#include <kpopupmenu.h>
#include <kdebug.h>
#include <klocale.h>
#include <krun.h>

#include <qapplication.h>
#include <qclipboard.h>

#include "libkita/signalcollection.h"

KitaSubjectTabWidget::KitaSubjectTabWidget( QWidget* parent, const char* name, WFlags f )
        : QTabWidget( parent, name, f )
{
    setTabBar( new Kita::SubjectTabBar( this ) );
    KitaSubjectView * view = new KitaSubjectView( this );
    addTab( view, "        " );
    m_latestView = view;
    m_viewList.append( view );

    m_favoriteList = new FavoriteListView( this, "favoriteTab" );
    addTab( m_favoriteList, "Favorite" );

    connectSignals( m_favoriteList );
    connectSignals( view );
    connect( view, SIGNAL( loadBoardCompleted( const KURL& ) ),
             this, SIGNAL( loadBoardCompleted( const KURL& ) ) );

    Kita::SignalCollection* signalCollection = Kita::SignalCollection::getInstance();
    connect( this, SIGNAL( currentChanged( QWidget* ) ),
             SLOT( slotCurrentChanged( QWidget* ) ) );
    connect( tabBar(), SIGNAL( deleteMenuSelected( KitaSubjectView* ) ),
             SLOT( deleteView( KitaSubjectView* ) ) );
    connect( signalCollection, SIGNAL( openBoardRequested( const QString&, bool ) ),
             SLOT( loadBoard( const QString&, bool ) ) );
    connect( this, SIGNAL( switchSubjectView() ),
             signalCollection, SIGNAL( switchSubjectView() ) );
    connect( signalCollection, SIGNAL( switchSubjectView() ),
	     SLOT( slotSwitchSubjectView() ));
}

KitaSubjectTabWidget::~KitaSubjectTabWidget()
{}

void KitaSubjectTabWidget::loadBoard( const QString& boardURL, bool withNewTab )
{
    emit switchSubjectView();
    KitaSubjectView * view = findView( boardURL );
    QString boardName = Kita::Board::getName( boardURL );
    if ( view )
    {
        m_latestView = view;
        setTabLabel( m_latestView, boardName );
    }
    else if ( withNewTab )
    {
        KitaSubjectView * newView = new KitaSubjectView( this );
        connectSignals( newView );
        connect( newView, SIGNAL( loadBoardCompleted( const KURL& ) ),
                 this, SIGNAL( loadBoardCompleted( const KURL& ) ) );
        insertTab( newView, boardName, count() - 1 );
        m_latestView = newView;
        m_viewList.append( newView );
    }
    else
    {
        setTabLabel( m_latestView, boardName );
    }

    m_latestView->loadBoard( boardURL );

    showPage( m_latestView );
}

/* private slot */
void KitaSubjectTabWidget::slotSwitchSubjectView()
{
    m_latestView->setFocusList();
}

void KitaSubjectTabWidget::connectSignals( Kita::ThreadListView* view )
{
    connect( view, SIGNAL( showThreadRequested( const QString&, bool ) ),
             this, SIGNAL( showThreadRequested( const QString&, bool ) ) );
}

KitaSubjectView* KitaSubjectTabWidget::findView( const QString& boardURL )
{
    KitaSubjectView * view;
    for ( view = m_viewList.first(); view; view = m_viewList.next() )
    {
        if ( view->boardURL() == boardURL )
        {
            return view;
        }
        if ( view->boardURL().isEmpty() )
        {
            return view;  // default view
        }
    }
    return 0;
}

void KitaSubjectTabWidget::slotCurrentChanged( QWidget* widget )
{
    if ( QString::compare( widget->name(), "favoriteTab" ) == 0 )
    {
        m_favoriteList->update();
    }
    else
    {
        m_latestView = static_cast<KitaSubjectView*>( widget );
	m_latestView->setFocusList();
    }
}

void KitaSubjectTabWidget::deleteView( KitaSubjectView* view )
{
    if ( count() <= 2 )
    {
        return ;
        // favoriteȤΤȤϲ⤷ʤ
    }
    m_viewList.remove( view );
    removePage( view );
    delete view;

    // FIXME: favoriteϰֺˤʤȤ
    setCurrentPage( 0 );
    m_latestView = static_cast<KitaSubjectView *>( currentPage() );
}

void KitaSubjectTabWidget::reloadSubjectList()
{
    if ( !m_latestView )
        m_latestView->reloadSubject();
}

Kita::SubjectTabBar::SubjectTabBar( QWidget* parent, const char* name )
        : QTabBar( parent, name )
{}

Kita::SubjectTabBar::~SubjectTabBar()
{}

// FIXME: KitaThreadTabWidget饳ԡ
void Kita::SubjectTabBar::contextMenuEvent( QContextMenuEvent* e )
{
    KPopupMenu popup( 0 );
    popup.insertItem( i18n( "Open with Web Browser" ), 0 );
    popup.insertItem( i18n( "Copy title and URL" ), 1 );
    popup.insertItem( i18n( "Close this tab" ), 2 );

    QTabWidget* parent = static_cast<QTabWidget *>( parentWidget() );
    // FIXME: ޤȤȽȤ
    if ( QString::compare( parent->currentPage() ->name(), "favoriteTab" ) == 0 )
    {
        return ;
    }
    KitaSubjectView* subjectView = static_cast<KitaSubjectView *>( parent->currentPage() );
    QClipboard* clipboard = QApplication::clipboard();

    switch ( popup.exec( e->globalPos() ) )
    {
    case 0:
        KRun::runURL( subjectView->boardURL(), "text/html" );
        break;
    case 1:
        clipboard->setText( subjectView->boardName() + "\n" + subjectView->boardURL() );
        break;
    case 2:
        emit deleteMenuSelected( subjectView );
        break;
    default:
        break;
    }

    kdDebug() << "currentPage = " << tab( currentTab() ) ->text() << endl;
}
