/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef KITATHREADTABWIDGET_H
#define KITATHREADTABWIDGET_H

#include <qtabwidget.h>
#include <qtabbar.h>
#include <kparts/browserextension.h>
#include <kparts/partmanager.h>

class KitaThreadPart;
class KitaThreadView;
class KURL;

namespace Kita
{
    class Thread;
}

/**
@author Hideki Ikemoto
*/
class KitaThreadTabWidget : public QTabWidget
{
    Q_OBJECT

    KParts::PartManager *m_manager;

public:
    KitaThreadTabWidget( QWidget* parent = 0, const char* name = 0, WFlags f = 0 );
    ~KitaThreadTabWidget();
    KParts::Part* findPartFromView( QWidget* );
    KParts::PartManager* manager() { return m_manager; }

public slots:
    void showThread( const QString& datURL, bool withNewTab );
    void deleteView( QWidget* );
    void reloadThread();
    void focusSearchCombo();
    void slotCurrentChanged( QWidget* );
    void closeCurrentTab();
    void slotCloseThreadTab( const KURL& url );
    void showAlternativeView( const KURL&, const QString&, const QString& );


private:
    void connectSignals();
    KitaThreadView* createView();
    QPtrList<KitaThreadView> m_viewList;
    KitaThreadView* findView( const QString& threadURL );
    const QString getTabLabel( const QString &name );

private slots:
    void slotUpdateThreadTab( const KURL& url );

protected:
    virtual void customEvent( QCustomEvent * e );  
 
signals:
    void setMainStatusbar( const QString& );
    void setMainCaption( const QString& );
    void switchSubjectView();
};

class KitaThreadTabBar : public QTabBar
{
    Q_OBJECT

public:
    KitaThreadTabBar( QWidget* parent = 0, const char* name = 0 );
    ~KitaThreadTabBar();

protected:
    virtual void contextMenuEvent( QContextMenuEvent* e );

signals:
    void deleteMenuSelected( QWidget* );
};


/*------------------------------------------------------------------*/
#include <qevent.h>

#define EVENT_CloseCurrentThreadTab ( QEvent::User + 100 )


class CloseCurrentThreadTabEvent : public QCustomEvent
{
    int pageindex;

  public:

    CloseCurrentThreadTabEvent( int idx )
	: QCustomEvent( EVENT_CloseCurrentThreadTab ), pageindex( idx ){}

    const int getIndex() const { return pageindex; }
};


#endif
