/***************************************************************************
*   Copyright (C) 2003-2004 by Hideki Ikemoto                             *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/
#include "access.h"

#include "thread.h"
#include "cache.h"
#include "kita_misc.h"

#include <config.h>

#include <sys/stat.h>
#include <stdlib.h>
#include <unistd.h>

#include <kurl.h>
#include <kglobal.h>
#include <kstandarddirs.h>
#include <kprotocolmanager.h>

#include <kio/slaveconfig.h>
#include <kio/netaccess.h>
#include <kio/jobclasses.h>
#include <kio/job.h>

#include <qregexp.h>
#include <qfile.h>
#include <qmessagebox.h>

using namespace Kita;

QString Access::getcache()
{
    QString cachePath = Kita::Cache::getPath( m_url );
    m_orgData = QString::null;

    if( cachePath != QString::null )
    {
        QFile file( cachePath );
        if ( file.open( IO_ReadOnly ) )
        {
            m_orgData += file.readAll();
            file.close();
        }
    }

    return m_orgData;
}

// å˽񤭹ߡ
void Access::writeCacheData()
{
    if ( m_invalidDataReceived ) return;
    if ( m_threadData == QString::null ) return;

    m_orgData += m_threadData;

    QString cachePath = Kita::Cache::getPath( m_url );
    if( cachePath != QString::null )
    {
        FILE *fs = fopen( QFile::encodeName( cachePath ), "w" );
        if ( !fs ) return ;

        fwrite( m_orgData, m_orgData.length(), 1, fs );
        fclose( fs );
    }

    return ;
}

QString Access::getupdate()
{
    QString getURL = m_url.url();
    if ( Kita::boardType( getURL ) == Board_MachiBBS )
    {
        getURL = Kita::datToThread( getURL );
    }

    QString retstr;
    m_threadData = "";
    m_firstReceive = FALSE;
    m_invalidDataReceived = FALSE;

    if ( KURL( getURL ).protocol() != "k2ch" )
    {
        KIO::SlaveConfig::self() ->setConfigData( "http",
                KURL( getURL ).host(),
                "UserAgent",
                QString( "Monazilla/1.00 (Kita/%1)" ).arg( VERSION ) );
    }

    KIO::TransferJob* job = KIO::get( getURL, true, false );
    m_currentJob = job;

    connect( job, SIGNAL( data( KIO::Job*, const QByteArray& ) ),
             SLOT( slotReceiveThreadData( KIO::Job*, const QByteArray& ) ) );
    connect( job, SIGNAL( result( KIO::Job* ) ), SLOT( slotThreadResult( KIO::Job* ) ) );

    // use 'HTTP-Headers' metadata.
    job->addMetaData( "PropagateHttpHeader", "true" );
    if ( ! m_orgData.isNull() )
    {
        m_firstReceive = TRUE; /* remove first char. see also slotReceiveThreadData() */
        job->addMetaData( "resume", QString::number( m_orgData.length() - 1 ) );
        job->addMetaData( "AllowCompressedPage", "false" );
    }

    return QString::null; /* dummy */
}

void Access::make_cacheDir( const KURL& url )
{
    // mkdir: $(KDRDIR)/share/cache/kita/pc.2ch.net/linux/xxxx.dat
    // ξ硢kita, pc.2ch.net, linux
    // TODO: 3ؤޤǤбƤʤΤʤȤ롣
    QString cachePath = Kita::Cache::getPath( url );
    KURL cacheDir = KURL( cachePath, "." );
    KURL cacheDir2 = KURL( cacheDir, ".." );
    KURL cacheDir3 = KURL( cacheDir2, ".." );
    if ( !KIO::NetAccess::exists( cacheDir3 ) )
    {
        KIO::NetAccess::mkdir( cacheDir3 );
    }
    if ( !KIO::NetAccess::exists( cacheDir2 ) )
    {
        KIO::NetAccess::mkdir( cacheDir2 );
    }
    if ( !KIO::NetAccess::exists( cacheDir ) )
    {
        KIO::NetAccess::mkdir( cacheDir );
    }
}

void Access::slotThreadResult( KIO::Job* job )
{
    m_currentJob = 0;
    if ( job->error() )
    {
        job->showErrorDialog();
    }
    else
    {
        m_header = job->queryMetaData( "HTTP-Headers" );
    }

    if ( !m_invalidDataReceived && m_threadData.length() )
    {
        if ( Kita::boardType( m_url.url() ) == Board_MachiBBS )
        {
            // TODO: need to refactoring.
            parse_machiBBS();
            KURL url = m_url;
            make_cacheDir( url );
            writeCacheData();
            emit receiveData( m_threadData );
        }
        else
        {
            KURL url = m_url;
            make_cacheDir( url );
            writeCacheData();
        }
    }
    emit finishLoad();
}

void Access::parse_machiBBS()
{
    QString ret;
    QStringList lines = QStringList::split( "\n", m_threadData );
    // pattern 1 (tokyo,kanagawa,...)
    QRegExp regexp( "<dt>(.*) .*<font color=\"#......\"><b> (.*) </b></font> .* (..../../..).* (..:..:..) ID:(.*)<br><dd>(.*)" );
    QRegExp regexp2( "<dt>(.*) .*<a href=\"mailto:(.*)\"><b> (.*) </B></a> .* (..../../..).* (..:..:..) ID:(.*)<br><dd>(.*)" );

    // pattern 2 (hokkaido,...)
    QRegExp regexp3( "<dt>(.*) .*<font color=\"#......\"><b> (.*) </b></font> .* (..../../..).* (..:..:..) ID:(.*)<font size=.>\\[ .*" );
    QRegExp regexp4( " \\]</font><br><dd>(.*)" );
    QRegExp regexp5( "<dt>(.*) .*<a href=\"mailto:(.*)\"><b> (.*) </B></a> .* (..../../..).* (..:..:..) ID:(.*)<font size=.>\\[ .*" );
    for ( QStringList::iterator it = lines.begin(); it != lines.end(); ++it )
    {
        QString line = (*it);
        if ( regexp.search( line ) != -1 )
        {
            int num = regexp.cap( 1 ).toInt();
            QString name = regexp.cap( 2 );
            QString date = regexp.cap( 3 );
            QString time = regexp.cap( 4 );
            QString id = regexp.cap( 5 );
            QString message = regexp.cap( 6 );
            QString datStr = name + "<><>" + date + " " + time + " ID:" + id
                             + "<>" + message + "<>\n";
            ret += datStr;
        }
        else if ( regexp2.search( line ) != -1 )
        {
            int num = regexp2.cap( 1 ).toInt();
            QString mail = regexp2.cap( 2 );
            QString name = regexp2.cap( 3 );
            QString date = regexp2.cap( 4 );
            QString time = regexp2.cap( 5 );
            QString id = regexp2.cap( 6 );
            QString message = regexp2.cap( 7 );
            QString datStr = name + "<>" + mail + "<>" + date + " " + time + " ID:" + id
                             + "<>" + message + "<>\n";
            ret += datStr;
        }
        else if ( regexp3.search( line ) != -1 )
        {
            ++it;
            if ( it == lines.end() ) break;
            QString nextLine = (*it);
            if ( regexp4.search( nextLine ) != -1 )
            {
                int num = regexp3.cap( 1 ).toInt();
                QString name = regexp3.cap( 2 );
                QString date = regexp3.cap( 3 );
                QString time = regexp3.cap( 4 );
                QString id = regexp3.cap( 5 );
                QString message = regexp4.cap( 1 );
                QString datStr = name + "<><>" + date + " " + time + " ID:" + id
                                 + "<>" + message + "<>\n";
                ret += datStr;
            }
        }
        else if ( regexp5.search( line ) != -1 )
        {
            ++it;
            if ( it == lines.end() ) break;
            QString nextLine = (*it);
            if ( regexp4.search( nextLine ) != -1 )
            {
                int num = regexp5.cap( 1 ).toInt();
                QString mail = regexp5.cap( 2 );
                QString name = regexp5.cap( 3 );
                QString date = regexp5.cap( 4 );
                QString time = regexp5.cap( 5 );
                QString id = regexp5.cap( 6 );
                QString message = regexp4.cap( 1 );
                QString datStr = name + "<>" + mail + "<>" + date + " " + time + " ID:" + id
                                 + "<>" + message + "<>\n";
                ret += datStr;
            }
        }
    }
    m_threadData = ret;
}


void Access::slotReceiveThreadData( KIO::Job*, const QByteArray& data )
{
    QString cstr( data );

    if( ( m_orgData != QString::null && responseCode() != 206 )
            || ( m_firstReceive && cstr[0] != '\n' )
            || ( m_orgData == QString::null && responseCode() != 200 )
      ) m_invalidDataReceived = TRUE;

    if( m_invalidDataReceived ) return;

    /* If this is the first call at resumption, remove LF at head. */
    if(m_firstReceive)
    {
        cstr = cstr.mid(1);
    }
    m_firstReceive = FALSE;
    m_threadData += cstr ;
    if ( Kita::boardType( m_url.url() ) != Board_MachiBBS )
    {
        emit receiveData( cstr );
    }
}


void Access::killJob()
{
    if ( m_currentJob ) m_currentJob->kill();
}

void Access::stopJob()
{
    if ( m_currentJob ) m_currentJob->kill( FALSE ); /* emit result signal */
}

int Access::serverTime()
{
    if(m_currentJob) m_header = m_currentJob->queryMetaData( "HTTP-Headers" );
    // parse HTTP headers
    QStringList headerList = QStringList::split( "\n", m_header );
    QRegExp regexp( "Date: (...), (..) (...) (....) (..:..:..) .*" );
    QString dateStr = headerList.grep( regexp ) [ 0 ];
    if ( regexp.search( dateStr ) == -1 )
    {
        // invalid date format
        return QDateTime::currentDateTime().toTime_t();
    }
    else
    {
        // I hate this format ;p
        QString usLocalDateStr = regexp.cap( 1 ) + " " + regexp.cap( 3 ) + " " +
                                 regexp.cap( 2 ) + " " + regexp.cap( 5 ) + " " +
                                 regexp.cap( 4 );

        // 1970/01/01 00:00:00 GMT
        QDateTime zeroTime( QDate( 1970, 1, 1 ), QTime( 0, 0 ) );
        return zeroTime.secsTo( QDateTime::fromString( usLocalDateStr ) );
    }
}

int Access::responseCode()
{
    if(m_currentJob) m_header = m_currentJob->queryMetaData( "HTTP-Headers" );
    // parse HTTP headers
    QStringList headerList = QStringList::split( "\n", m_header );
    QRegExp regexp( "HTTP/1\\.[01] ([0-9]+) .*" );
    QString dateStr = headerList.grep( regexp ) [ 0 ];
    if ( regexp.search( dateStr ) == -1 )
    {
        // invalid response
        return 0;
    }
    else
    {
        return regexp.cap( 1 ).toInt();
    }
}

bool Access::deleteLog( const Thread* thread, QWidget* parent )
{
    KURL url = thread->datURL();
    QString str = Kita::Cache::getPath( url );
    return KIO::NetAccess::del( str );
}

#include "access.moc"
