/***************************************************************************
*   Copyright (C) 2003-2004 by Hideki Ikemoto                             *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/
#ifndef KITAACCESS_H
#define KITAACCESS_H

#include <kurl.h>

#include <qobject.h>

namespace KIO
{
    class Job;
}

namespace Kita
{
    class Thread;

    /**
    @author Hideki Ikemoto
    */
    class Access : public QObject
    {
        Q_OBJECT

    public:
        Access( const KURL& url ) : m_url( url ), m_currentJob( 0 ) {};
        ~Access() {};

        QString get();
        void killJob();
        void stopJob();
        int serverTime();
        QString getcache();
        QString getupdate();
        int responseCode();
        static bool deleteLog( const Thread* thread, QWidget* parent );

    private:
        void writeCacheData();
        void parse_machiBBS();
        void make_cacheDir( const KURL& url );

        const KURL m_url;
        KIO::Job* m_currentJob;
        QString m_threadData;
        QString m_header;
        QString m_orgData;
        bool m_firstReceive;
        bool m_invalidDataReceived;

    private slots:
        void slotReceiveThreadData( KIO::Job* job, const QByteArray& data );
        void slotThreadResult( KIO::Job* job );

    signals:
        void redirection( const QString& );
        void receiveData( const QString& );
        void finishLoad();
    };

}

#endif
