/***************************************************************************
*   Copyright (C) 2003 by Hideki Ikemoto                                  *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef KITACATEGORY_H
#define KITACATEGORY_H

#include <qstring.h>
#include <qvaluelist.h>

/**
@author Hideki Ikemoto
*/

namespace Kita
{
    class Board;

    class Category
    {
        QString m_name;
        QValueList<QString> m_boardURLList;
    public:
        Category();
        Category( const QString& name );
        ~Category();
        void append( const QString& boardURL );
        const QValueList<QString>& getBoardURLList() const;
        const QString& name() const;
    };
}

#endif
